/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public class AlarmDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AlarmDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"ShortAlarm", (String)"Short or Frequent Alarm", (String)"Frequent alarms are bad for battery life. As of API 22, the `AlarmManager` will override near-future and high-frequency alarm requests, delaying the alarm at least 5 seconds into the future and ensuring that the repeat interval is at least 60 seconds.\n\nIf you really need to do work sooner than 5 seconds, post a delayed message or runnable to a Handler.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setRepeating");
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isMemberInClass((PsiMember)method, "android.app.AlarmManager") && evaluator.getParameterCount(method) == 4) {
            AlarmDetector.ensureAtLeast(context, node, 1, 5000L);
            AlarmDetector.ensureAtLeast(context, node, 2, 60000L);
        }
    }

    private static void ensureAtLeast(JavaContext context, UCallExpression node, int parameter, long min) {
        UExpression argument = (UExpression)node.getValueArguments().get(parameter);
        long value = AlarmDetector.getLongValue(context, argument);
        if (value < min) {
            String message = String.format("Value will be forced up to %1$d as of Android 5.1; don't rely on this to be exact", min);
            context.report(ISSUE, (UElement)argument, context.getLocation((UElement)argument), message);
        }
    }

    private static long getLongValue(JavaContext context, UExpression argument) {
        Object value = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.MAX_VALUE;
    }
}

