/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CallSuperDetector
extends Detector
implements Detector.UastScanner {
    private static final String CALL_SUPER_ANNOTATION = "android.support.annotation.CallSuper";
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"MissingSuperCall", (String)"Missing Super Call", (String)"Some methods, such as `View#onDetachedFromWindow`, require that you also call the super implementation as part of your method.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UMethod.class);
    }

    public UElementHandler createUastHandler(final JavaContext context) {
        return new UElementHandler(){

            public void visitMethod(UMethod method) {
                CallSuperDetector.checkCallSuper(context, method);
            }
        };
    }

    private static void checkCallSuper(JavaContext context, UMethod method) {
        PsiMethod superMethod = CallSuperDetector.getRequiredSuperMethod(context, method);
        if (superMethod != null && !SuperCallVisitor.callsSuper(method, superMethod)) {
            String methodName = method.getName();
            String message = "Overriding method should call `super." + methodName + "`";
            Location location = context.getNameLocation(method);
            context.report(ISSUE, method, location, message);
        }
    }

    private static PsiMethod getRequiredSuperMethod(JavaContext context, UMethod method) {
        PsiAnnotation[] annotations;
        JavaEvaluator evaluator = context.getEvaluator();
        PsiMethod directSuper = evaluator.getSuperMethod((PsiMethod)method);
        if (directSuper == null) {
            return null;
        }
        String name = method.getName();
        if (ON_DETACHED_FROM_WINDOW.equals(name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
                return null;
            }
            return directSuper;
        }
        if (ON_VISIBILITY_CHANGED.equals(name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                return null;
            }
            return directSuper;
        }
        for (PsiAnnotation annotation : annotations = evaluator.getAllAnnotations((PsiModifierListOwner)directSuper, true)) {
            String signature = annotation.getQualifiedName();
            if (!CALL_SUPER_ANNOTATION.equals(signature) && (signature == null || !signature.endsWith(".OverrideMustInvoke") && !signature.endsWith(".OverridingMethodsMustInvokeSuper"))) continue;
            return directSuper;
        }
        return null;
    }

    private static class SuperCallVisitor
    extends AbstractUastVisitor {
        private final PsiMethod targetMethod;
        private boolean callsSuper;

        public static boolean callsSuper(UMethod method, PsiMethod superMethod) {
            SuperCallVisitor visitor = new SuperCallVisitor(superMethod);
            method.accept((UastVisitor)visitor);
            return visitor.callsSuper;
        }

        private SuperCallVisitor(PsiMethod method) {
            this.targetMethod = method;
        }

        public boolean visitSuperExpression(USuperExpression node) {
            PsiElement resolved;
            UElement parent = LintUtils.skipParentheses((UElement)node.getUastParent());
            if (parent instanceof UReferenceExpression && this.targetMethod.equals(resolved = ((UReferenceExpression)parent).resolve())) {
                this.callsSuper = true;
            }
            return super.visitSuperExpression(node);
        }
    }
}

