/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;

public class PrivateApiDetector
extends Detector
implements Detector.UastScanner {
    public static final String LOAD_CLASS = "loadClass";
    public static final String FOR_NAME = "forName";
    public static final String GET_CLASS = "getClass";
    public static final String GET_DECLARED_METHOD = "getDeclaredMethod";
    private static final Implementation IMPLEMENTATION = new Implementation(PrivateApiDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"PrivateApi", (String)"Using Private APIs", (String)"Using reflection to access hidden/private Android APIs is not safe; it will often not work on devices from other vendors, and it may suddenly stop working (if the API is removed) or crash spectacularly (if the API behavior changes, since there are no guarantees for compatibility.)", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    public List<String> getApplicableMethodNames() {
        return Arrays.asList(FOR_NAME, LOAD_CLASS, GET_DECLARED_METHOD);
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (LOAD_CLASS.equals(method.getName())) {
            if (evaluator.isMemberInClass((PsiMember)method, "java.lang.ClassLoader") || evaluator.isMemberInClass((PsiMember)method, "dalvik.system.DexFile")) {
                PrivateApiDetector.checkLoadClass(context, node);
            }
        } else {
            if (!evaluator.isMemberInClass((PsiMember)method, "java.lang.Class")) {
                return;
            }
            if (GET_DECLARED_METHOD.equals(method.getName())) {
                PrivateApiDetector.checkGetDeclaredMethod(context, node);
            } else {
                PrivateApiDetector.checkLoadClass(context, node);
            }
        }
    }

    private static void checkGetDeclaredMethod(JavaContext context, UCallExpression call) {
        String cls = PrivateApiDetector.getClassFromMemberLookup(call);
        if (cls == null) {
            return;
        }
        if (!cls.startsWith("com.android.") && !cls.startsWith("android.")) {
            return;
        }
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        String methodName = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)arguments.get(0)), (boolean)false);
        PsiClass aClass = context.getEvaluator().findClass(cls);
        if (aClass == null) {
            return;
        }
        PsiMethod[] methodsByName = aClass.findMethodsByName(methodName, true);
        if (methodsByName.length == 0) {
            Location location = context.getLocation((UElement)call);
            context.report(ISSUE, (UElement)call, location, PrivateApiDetector.getErrorMessage());
        }
    }

    private static String getErrorMessage() {
        return "Accessing internal APIs via reflection is not supported and may not work on all devices or in the future";
    }

    private static void checkLoadClass(JavaContext context, UCallExpression call) {
        List arguments = call.getValueArguments();
        if (arguments.isEmpty()) {
            return;
        }
        Object value = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)arguments.get(0)));
        if (!(value instanceof String)) {
            return;
        }
        String cls = (String)value;
        boolean isInternal = false;
        if (cls.startsWith("com.android.internal.")) {
            isInternal = true;
        } else if (cls.startsWith("com.android.") || cls.startsWith("android.") && !cls.startsWith("android.support.")) {
            PsiClass aClass = context.getEvaluator().findClass(cls);
            if (aClass != null) {
                return;
            }
            String owner = ClassContext.getInternalName((String)cls);
            ApiLookup apiLookup = ApiLookup.get(context.getClient(), context.getMainProject().getBuildTarget());
            if (apiLookup == null) {
                return;
            }
            boolean bl = isInternal = !apiLookup.containsClass(owner);
        }
        if (isInternal) {
            Location location = context.getLocation((UElement)call);
            context.report(ISSUE, (UElement)call, location, PrivateApiDetector.getErrorMessage());
        }
    }

    public static String getClassFromMemberLookup(UCallExpression call) {
        return PrivateApiDetector.findReflectionClass((UElement)call.getReceiver());
    }

    private static String findReflectionClass(UElement element) {
        if (element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
            return PrivateApiDetector.findReflectionClass((UElement)((UQualifiedReferenceExpression)element).getSelector());
        }
        if (element instanceof UCallExpression) {
            UExpression qualifier;
            PsiType qualifierType;
            UCallExpression call = (UCallExpression)element;
            String name = call.getMethodName();
            if (FOR_NAME.equals(name) || LOAD_CLASS.equals(name)) {
                List arguments = call.getValueArguments();
                if (!arguments.isEmpty()) {
                    return ConstantEvaluator.evaluateString(null, (UElement)((UElement)arguments.get(0)), (boolean)false);
                }
            } else if (GET_CLASS.equals(name) && (qualifierType = TypeEvaluator.evaluate((UElement)(qualifier = call.getReceiver()))) instanceof PsiClassType) {
                return qualifierType.getCanonicalText();
            }
        } else if (element instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof ULocalVariable) {
                UExpression expression = UastLintUtils.findLastAssignment((PsiVariable)((PsiVariable)resolved), (UElement)element);
                return PrivateApiDetector.findReflectionClass((UElement)expression);
            }
        } else if (element instanceof UClassLiteralExpression) {
            UExpression expression = ((UClassLiteralExpression)element).getExpression();
            if (expression instanceof UTypeReferenceExpression) {
                return ((UTypeReferenceExpression)expression).getQualifiedName();
            }
            PsiType type = ((UClassLiteralExpression)element).getExpressionType();
            if (type instanceof PsiClassType) {
                return type.getCanonicalText();
            }
        }
        return null;
    }
}

