/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "foundText", "", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "visitNode", "node", "Lorg/w3c/dom/Node;", "Issues", "lint-checks_main"})
public final class ExtraTextDetector
extends ResourceXmlDetector {
    private boolean foundText;
    @JvmField
    public static final Issue ISSUE;
    public static final Issues Issues;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.LAYOUT) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.MENU) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.ANIM) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.ANIMATOR) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.DRAWABLE) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.COLOR);
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.foundText = false;
        this.visitNode(context, document);
    }

    /*
     * WARNING - void declaration
     */
    private final void visitNode(XmlContext context, Node node) {
        int i;
        int n;
        short nodeType = node.getNodeType();
        if (nodeType == 3 && !this.foundText) {
            String text = node.getNodeValue();
            n = text.length();
            for (i = 0; i < n; ++i) {
                Position start;
                char it;
                char c = text.charAt(i);
                if (Character.isWhitespace(c)) continue;
                String $receiver$iv = text;
                CharSequence $receiver$iv$iv = $receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $receiver$iv$iv.charAt(index$iv$iv);
                    boolean bl = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String snippet = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                int maxLength = 100;
                if (snippet.length() > maxLength) {
                    $receiver$iv$iv = snippet;
                    startIndex$iv$iv = 0;
                    StringBuilder stringBuilder = new StringBuilder();
                    CharSequence charSequence = $receiver$iv$iv;
                    if (charSequence == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string = ((String)charSequence).substring(startIndex$iv$iv, maxLength);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string2 = string;
                    snippet = stringBuilder.append(string2).append("...").toString();
                }
                Location location = context.getLocation(node);
                if (i > 0 && (start = location.getStart()) != null) {
                    int line = start.getLine();
                    int column = start.getColumn();
                    int offset = start.getOffset();
                    it = '\u0000';
                    int n2 = i - 1;
                    if (it <= n2) {
                        while (true) {
                            void j;
                            ++offset;
                            if (text.charAt((int)j) == '\n') {
                                if (line != -1) {
                                    ++line;
                                }
                                if (column != -1) {
                                    column = 0;
                                }
                            } else if (column != -1) {
                                ++column;
                            }
                            if (j == n2) break;
                            ++j;
                        }
                    }
                    start = (Position)new DefaultPosition(line, column, offset);
                    location = Location.Companion.create(context.file, start, location.getEnd());
                }
                Issue issue = ISSUE;
                Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"ISSUE");
                XmlContext.report$default((XmlContext)context, (Issue)issue, (Node)node, (Location)location, (String)("Unexpected text found in layout file: " + "\"" + snippet + "\""), null, (int)16, null);
                this.foundText = true;
                break;
            }
        }
        NodeList childNodes = node.getChildNodes();
        n = childNodes.getLength();
        for (i = 0; i < n; ++i) {
            Node child;
            Node node2 = child = childNodes.item(i);
            Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"child");
            this.visitNode(context, node2);
        }
    }

    static {
        Issues = new Issues(null);
        ISSUE = Issue.create((String)"ExtraText", (String)"Extraneous text in resource files", (String)"\nLayout resource files should only contain elements and attributes. Any XML text content found \\\nin the file is likely accidental (and potentially dangerous if the text resembles XML and the \\\ndeveloper believes the text to be functional)", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ExtraTextDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE}));
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "lint-checks_main"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

