/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WearStandaloneAppDetector
extends Detector
implements Detector.XmlScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(WearStandaloneAppDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue INVALID_WEAR_FEATURE_ATTRIBUTE = Issue.create((String)"InvalidWearFeatureAttribute", (String)"Invalid attribute for Wear uses-feature", (String)"For the `android.hardware.type.watch` uses-feature, android:required=\"false\" is disallowed. A single APK for Wear and non-Wear devices is not supported.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/wearables/apps/packaging.html");
    public static final Issue WEAR_STANDALONE_APP_ISSUE = Issue.create((String)"WearStandaloneAppFlag", (String)"Invalid or missing Wear standalone app flag", (String)"Wearable apps should specify whether they can work standalone, without a phone app.Add a valid meta-data entry for `com.google.android.wearable.standalone` to your application element and set the value to `true` or `false`.\n`<meta-data android:name=\"com.google.android.wearable.standalone\"\n            android:value=\"true\"/>`\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/wearables/apps/packaging.html");
    public static final String WEARABLE_STANDALONE_ATTR = "com.google.android.wearable.standalone";
    public static final int QFX_EXTRA_MISSING_META_DATA = 2;
    private boolean sawWearUsesFeature;
    private boolean sawStandaloneMetadata;

    public void beforeCheckFile(Context context) {
        this.sawWearUsesFeature = false;
        this.sawStandaloneMetadata = false;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("uses-feature", "meta-data");
    }

    public void visitElement(XmlContext context, Element element) {
        String tagName = element.getTagName();
        String attrName = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if ("uses-feature".equals(tagName)) {
            if ("android.hardware.type.watch".equals(attrName)) {
                this.sawWearUsesFeature = true;
                Attr requiredAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
                if (requiredAttr != null && !Boolean.valueOf(requiredAttr.getValue()).booleanValue()) {
                    context.report(INVALID_WEAR_FEATURE_ATTRIBUTE, (Node)requiredAttr, context.getLocation((Node)requiredAttr), "`android:required=\"false\"` is not supported for this feature");
                }
            }
        } else if (this.sawWearUsesFeature && "meta-data".equals(tagName) && WEARABLE_STANDALONE_ATTR.equals(attrName) && element.getParentNode() != null && element.getParentNode().getNodeName().equals("application")) {
            this.sawStandaloneMetadata = true;
            Attr valueAttr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "value");
            if (valueAttr == null) {
                LintFix fix = WearStandaloneAppDetector.fix().set("http://schemas.android.com/apk/res/android", "value", "true").build();
                context.report(WEAR_STANDALONE_APP_ISSUE, (Node)element, context.getLocation((Node)element), "Missing `android:value` attribute", fix);
            } else {
                String value = valueAttr.getValue();
                if (value == null || !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    LintFix fixes = WearStandaloneAppDetector.fix().group(new LintFix[]{WearStandaloneAppDetector.fix().replace().with("true").build(), WearStandaloneAppDetector.fix().replace().with("false").build()});
                    context.report(WEAR_STANDALONE_APP_ISSUE, (Node)valueAttr, context.getValueLocation(valueAttr), "Expecting a boolean value for attribute `android:value`", fixes);
                }
            }
        }
    }

    public void afterCheckFile(Context context) {
        if (context.getMainProject().isLibrary()) {
            return;
        }
        if (this.sawWearUsesFeature && !this.sawStandaloneMetadata && context.getMainProject().getTargetSdk() >= 23) {
            XmlContext xmlContext = (XmlContext)context;
            Element root = xmlContext.document.getDocumentElement();
            Element application = XmlUtils.getFirstSubTagTagByName((Node)root, (String)"application");
            if (application != null) {
                xmlContext.report(WEAR_STANDALONE_APP_ISSUE, (Node)application, xmlContext.getLocation((Node)application), "Missing `<meta-data android:name=\"com.google.android.wearable.standalone\" ../>` element", WearStandaloneAppDetector.fix().data(new Object[]{2}));
            }
        }
    }
}

