/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AppLinksValidDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AppIndexingApiDetector
extends Detector
implements Detector.XmlScanner,
Detector.UastScanner {
    private static final Implementation URL_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, Scope.MANIFEST_SCOPE);
    private static final Implementation APP_INDEXING_API_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.MANIFEST), new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE});
    public static final Issue ISSUE_APP_INDEXING = Issue.create((String)"GoogleAppIndexingWarning", (String)"Missing support for Firebase App Indexing", (String)"Adds URLs to get your app into the Google index, to get installs and traffic to your app from Google Search.", (Category)Category.USABILITY, (int)5, (Severity)Severity.WARNING, (Implementation)URL_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    public static final Issue ISSUE_APP_INDEXING_API = Issue.create((String)"GoogleAppIndexingApiWarning", (String)"Missing support for Firebase App Indexing Api", (String)"Adds URLs to get your app into the Google index, to get installs and traffic to your app from Google Search.", (Category)Category.USABILITY, (int)5, (Severity)Severity.WARNING, (Implementation)APP_INDEXING_API_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio").setEnabledByDefault(false);
    private static final String APP_INDEX_START = "start";
    private static final String APP_INDEX_END = "end";
    private static final String APP_INDEX_VIEW = "view";
    private static final String APP_INDEX_VIEW_END = "viewEnd";
    private static final String CLIENT_CONNECT = "connect";
    private static final String CLIENT_DISCONNECT = "disconnect";
    private static final String ADD_API = "addApi";
    private static final String APP_INDEXING_API_CLASS = "com.google.android.gms.appindexing.AppIndexApi";
    private static final String GOOGLE_API_CLIENT_CLASS = "com.google.android.gms.common.api.GoogleApiClient";
    private static final String GOOGLE_API_CLIENT_BUILDER_CLASS = "com.google.android.gms.common.api.GoogleApiClient.Builder";
    private static final String API_CLASS = "com.google.android.gms.appindexing.AppIndex";

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("application");
    }

    public void visitElement(XmlContext context, Element application) {
        boolean applicationHasActionView = false;
        for (Element activity : XmlUtils.getSubTagsByName((Node)application, (String)"activity")) {
            for (Element intent : XmlUtils.getSubTagsByName((Node)activity, (String)"intent-filter")) {
                boolean actionView = AppLinksValidDetector.hasActionView(intent);
                if (!actionView) continue;
                applicationHasActionView = true;
            }
        }
        if (!applicationHasActionView && !context.getProject().isLibrary()) {
            context.report(ISSUE_APP_INDEXING, (Node)application, context.getLocation((Node)application), "App is not indexable by Google Search; consider adding at least one Activity with an ACTION-VIEW intent filter. See issue explanation for more details.");
        }
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.app.Activity");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        if (declaration.getName() == null) {
            return;
        }
        if (!context.getEvaluator().extendsClass((PsiClass)declaration, "android.app.Activity", true)) {
            return;
        }
        declaration.accept((UastVisitor)new MethodVisitor(context, declaration));
    }

    private static Set<String> getActivitiesToCheck(Context context) {
        HashSet activitiesToCheck = Sets.newHashSet();
        Document doc = context.getMainProject().getMergedManifest();
        if (doc == null) {
            return Collections.emptySet();
        }
        for (Element child : XmlUtils.getSubTags((Node)doc)) {
            if (!child.getNodeName().equals("manifest")) continue;
            for (Element app : XmlUtils.getSubTagsByName((Node)child, (String)"application")) {
                for (Element act : XmlUtils.getSubTagsByName((Node)app, (String)"activity")) {
                    for (Element intent : XmlUtils.getSubTagsByName((Node)act, (String)"intent-filter")) {
                        boolean hasData = XmlUtils.getFirstSubTagTagByName((Node)intent, (String)"data") != null;
                        if (!hasData || !act.hasAttributeNS("http://schemas.android.com/apk/res/android", "name")) continue;
                        String activityName = LintUtils.resolveManifestName((Element)act);
                        activitiesToCheck.add(activityName);
                    }
                }
            }
        }
        return activitiesToCheck;
    }

    private static boolean hasFirstArgument(UExpression argument, List<UCallExpression> list) {
        for (UCallExpression call : list) {
            List expressions = call.getValueArguments();
            if (expressions.isEmpty()) continue;
            UExpression argument2 = (UExpression)expressions.get(0);
            if (!argument.asSourceString().equals(argument2.asSourceString())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOperand(UExpression operand, List<UCallExpression> list) {
        for (UCallExpression method : list) {
            UExpression operand2 = method.getReceiver();
            if (operand2 == null || !operand.asSourceString().equals(operand2.asSourceString())) continue;
            return true;
        }
        return false;
    }

    static class MethodVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;
        private final UClass mCls;
        private final List<UCallExpression> mStartMethods;
        private final List<UCallExpression> mEndMethods;
        private final List<UCallExpression> mConnectMethods;
        private final List<UCallExpression> mDisconnectMethods;
        private boolean mHasAddAppIndexApi;

        MethodVisitor(JavaContext context, UClass cls) {
            this.mCls = cls;
            this.mContext = context;
            this.mStartMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mEndMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mConnectMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mDisconnectMethods = Lists.newArrayListWithExpectedSize((int)2);
        }

        public boolean visitClass(UClass aClass) {
            if (aClass.getPsi().equals(this.mCls.getPsi())) {
                return super.visitClass(aClass);
            }
            return true;
        }

        public void afterVisitClass(UClass node) {
            this.report();
        }

        public boolean visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isMethodCall((UElement)node)) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitMethodCallExpression(UCallExpression node) {
            String methodName = node.getMethodName();
            if (methodName == null) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            switch (methodName) {
                case "start": {
                    if (!evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) break;
                    this.mStartMethods.add(node);
                    break;
                }
                case "end": {
                    if (!evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) break;
                    this.mEndMethods.add(node);
                    break;
                }
                case "view": {
                    if (!evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) break;
                    this.mStartMethods.add(node);
                    break;
                }
                case "viewEnd": {
                    if (!evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) break;
                    this.mEndMethods.add(node);
                    break;
                }
                case "connect": {
                    if (!evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) break;
                    this.mConnectMethods.add(node);
                    break;
                }
                case "disconnect": {
                    if (!evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) break;
                    this.mDisconnectMethods.add(node);
                    break;
                }
                case "addApi": {
                    PsiElement resolved;
                    List args;
                    if (!evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.GOOGLE_API_CLIENT_BUILDER_CLASS) || !evaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.GOOGLE_API_CLIENT_BUILDER_CLASS) || (args = node.getValueArguments()).isEmpty() || !((resolved = UastUtils.tryResolve((UElement)((UElement)args.get(0)))) instanceof PsiField) || !evaluator.isMemberInClass((PsiMember)((PsiField)resolved), AppIndexingApiDetector.API_CLASS)) break;
                    this.mHasAddAppIndexApi = true;
                    break;
                }
            }
        }

        private void report() {
            String message;
            List expressions;
            Set activitiesToCheck = AppIndexingApiDetector.getActivitiesToCheck((Context)this.mContext);
            boolean hasIntent = activitiesToCheck.contains(this.mCls.getQualifiedName());
            if (!hasIntent) {
                for (UCallExpression call : this.mStartMethods) {
                    this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)call, this.mContext.getNameLocation((UElement)call), "Missing support for Firebase App Indexing in the manifest");
                }
                for (UCallExpression call : this.mEndMethods) {
                    this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)call, this.mContext.getNameLocation((UElement)call), "Missing support for Firebase App Indexing in the manifest");
                }
                return;
            }
            if (this.mStartMethods.isEmpty() && this.mEndMethods.isEmpty()) {
                this.mContext.report(ISSUE_APP_INDEXING_API, this.mCls, this.mContext.getNameLocation(this.mCls), "Missing support for Firebase App Indexing API");
                return;
            }
            for (UCallExpression startNode : this.mStartMethods) {
                expressions = startNode.getValueArguments();
                if (expressions.isEmpty()) continue;
                UExpression startClient = (UExpression)expressions.get(0);
                if (!this.mHasAddAppIndexApi) {
                    message = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", startClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)startClient, this.mContext.getLocation((UElement)startClient), message);
                }
                if (!AppIndexingApiDetector.hasOperand(startClient, this.mConnectMethods)) {
                    message = String.format("GoogleApiClient `%1$s` is not connected", startClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)startClient, this.mContext.getLocation((UElement)startClient), message);
                }
                if (AppIndexingApiDetector.hasFirstArgument(startClient, this.mEndMethods)) continue;
                this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)startNode, this.mContext.getNameLocation((UElement)startNode), "Missing corresponding `AppIndex.AppIndexApi.end` method");
            }
            for (UCallExpression endNode : this.mEndMethods) {
                expressions = endNode.getValueArguments();
                if (expressions.isEmpty()) continue;
                UExpression endClient = (UExpression)expressions.get(0);
                if (!this.mHasAddAppIndexApi) {
                    message = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", endClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)endClient, this.mContext.getLocation((UElement)endClient), message);
                }
                if (!AppIndexingApiDetector.hasOperand(endClient, this.mDisconnectMethods)) {
                    message = String.format("GoogleApiClient `%1$s` is not disconnected", endClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)endClient, this.mContext.getLocation((UElement)endClient), message);
                }
                if (AppIndexingApiDetector.hasFirstArgument(endClient, this.mStartMethods)) continue;
                this.mContext.report(ISSUE_APP_INDEXING_API, (UElement)endNode, this.mContext.getNameLocation((UElement)endNode), "Missing corresponding `AppIndex.AppIndexApi.start` method");
            }
        }
    }
}

