/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;

public class CipherGetInstanceDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"GetInstance", (String)"Cipher.getInstance with ECB", (String)"`Cipher#getInstance` should not be called with ECB as the cipher mode or without setting the cipher mode because the default mode on android is ECB, which is insecure.", (Category)Category.SECURITY, (int)9, (Severity)Severity.WARNING, (Implementation)new Implementation(CipherGetInstanceDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String CIPHER = "javax.crypto.Cipher";
    private static final String GET_INSTANCE = "getInstance";
    private static final Set<String> ALGORITHM_ONLY = Sets.newHashSet((Object[])new String[]{"AES", "DES", "DESede"});

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_INSTANCE);
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        UExpression expression;
        Object value;
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, CIPHER, false)) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() == 1 && (value = ConstantEvaluator.evaluate((JavaContext)context, (UElement)(expression = (UExpression)arguments.get(0)))) instanceof String) {
            CipherGetInstanceDetector.checkParameter(context, node, (UElement)expression, (String)value, !(expression instanceof ULiteralExpression));
        }
    }

    private static void checkParameter(JavaContext context, UCallExpression call, UElement node, String value, boolean includeValue) {
        if (ALGORITHM_ONLY.contains(value)) {
            String message = "`Cipher.getInstance` should not be called without setting the encryption mode and padding";
            context.report(ISSUE, (UElement)call, context.getLocation(node), message);
        } else if ((value.contains("/ECB/") || value.endsWith("/ECB")) && !value.startsWith("RSA/")) {
            String message = "ECB encryption mode should not be used";
            if (includeValue) {
                message = message + " (was \"" + value + "\")";
            }
            context.report(ISSUE, (UElement)call, context.getLocation(node), message);
        }
    }
}

