/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

public abstract class RangeConstraint {
    public String describe(UExpression argument) {
        assert (false);
        return "";
    }

    public static RangeConstraint create(PsiAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        switch (qualifiedName) {
            case "android.support.annotation.IntRange": {
                return IntRangeConstraint.create(annotation);
            }
            case "android.support.annotation.FloatRange": {
                return FloatRangeConstraint.create(annotation);
            }
            case "android.support.annotation.Size": {
                return SizeConstraint.create(annotation);
            }
        }
        return null;
    }

    public static RangeConstraint create(JavaContext context, UAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        switch (qualifiedName) {
            case "android.support.annotation.IntRange": {
                return IntRangeConstraint.create(annotation);
            }
            case "android.support.annotation.FloatRange": {
                return FloatRangeConstraint.create(annotation);
            }
            case "android.support.annotation.Size": {
                return SizeConstraint.create(annotation);
            }
        }
        return null;
    }

    public static RangeConstraint create(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                RangeConstraint constraint = RangeConstraint.create(annotation);
                if (constraint == null) continue;
                return constraint;
            }
        }
        return null;
    }

    public Boolean isValid(UExpression argument) {
        return null;
    }

    protected Number guessSize(UExpression argument) {
        System.out.println("IMPLEMENT CONSTRAINT GUESS SIZE");
        return null;
    }

    public Boolean contains(RangeConstraint other) {
        return null;
    }

    private static boolean comparesReference(PsiElement reference, PsiExpression expression) {
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binary = (PsiBinaryExpression)expression;
            IElementType tokenType = binary.getOperationTokenType();
            if (tokenType == JavaTokenType.GE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.EQ) {
                PsiExpression lOperand = binary.getLOperand();
                PsiExpression rOperand = binary.getROperand();
                if (lOperand instanceof PsiReferenceExpression) {
                    return reference.equals(((PsiReferenceExpression)lOperand).resolve());
                }
                if (rOperand instanceof PsiReferenceExpression) {
                    return reference.equals(((PsiReferenceExpression)rOperand).resolve());
                }
            } else if (tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) {
                return RangeConstraint.comparesReference(reference, binary.getLOperand()) || RangeConstraint.comparesReference(reference, binary.getROperand());
            }
        }
        return false;
    }

    static long getLongValue(PsiElement value, long defaultValue) {
        PsiElement resolved;
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral) {
            o = ((PsiLiteral)value).getValue();
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
        } else if (value instanceof PsiPrefixExpression) {
            Object o2;
            PsiExpression operand;
            PsiPrefixExpression exp = (PsiPrefixExpression)value;
            if (exp.getOperationTokenType() == JavaTokenType.MINUS && (operand = exp.getOperand()) instanceof PsiLiteral && (o2 = ((PsiLiteral)operand).getValue()) instanceof Number) {
                return -((Number)o2).longValue();
            }
        } else if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) {
            return RangeConstraint.getLongValue((PsiElement)((PsiField)resolved).getInitializer(), defaultValue);
        }
        if (value instanceof PsiExpression && (o = ConstantEvaluator.evaluate(null, (PsiElement)value)) instanceof Number) {
            return ((Number)o).longValue();
        }
        return defaultValue;
    }

    static double getDoubleValue(PsiAnnotationMemberValue value, double defaultValue) {
        PsiElement resolved;
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral) {
            o = ((PsiLiteral)value).getValue();
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
        } else if (value instanceof PsiPrefixExpression) {
            Object o2;
            PsiExpression operand;
            PsiPrefixExpression exp = (PsiPrefixExpression)value;
            if (exp.getOperationTokenType() == JavaTokenType.MINUS && (operand = exp.getOperand()) instanceof PsiLiteral && (o2 = ((PsiLiteral)operand).getValue()) instanceof Number) {
                return -((Number)o2).doubleValue();
            }
        } else if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) {
            return RangeConstraint.getDoubleValue((PsiAnnotationMemberValue)((PsiField)resolved).getInitializer(), defaultValue);
        }
        if (value instanceof PsiExpression && (o = ConstantEvaluator.evaluate(null, (PsiElement)value)) instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return defaultValue;
    }

    static boolean getBooleanValue(PsiAnnotationMemberValue value, boolean defaultValue) {
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral && (o = ((PsiLiteral)value).getValue()) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }
}

