/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.repository.api.LocalPackage;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiMember;
import com.android.tools.lint.checks.ApiPackage;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.Pair;
import com.google.common.io.ByteSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiLookup {
    public static final String XML_FILE_PATH = "api-versions.xml";
    public static final int SDK_DATABASE_MIN_VERSION = 26;
    private static final String FILE_HEADER = "API database used by Android lint\u0000";
    private static final int BINARY_FORMAT_VERSION = 11;
    private static final boolean DEBUG_SEARCH = false;
    private static final boolean WRITE_STATS = false;
    private static final int CLASS_HEADER_MEMBER_OFFSETS = 1;
    private static final int CLASS_HEADER_API = 2;
    private static final int CLASS_HEADER_DEPRECATED = 3;
    private static final int CLASS_HEADER_REMOVED = 4;
    private static final int CLASS_HEADER_INTERFACES = 5;
    private static final int HAS_EXTRA_BYTE_FLAG = 128;
    private static final int API_MASK = -129;
    static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private final Api mInfo;
    private byte[] mData;
    private int[] mIndices;
    private static final Map<AndroidVersion, WeakReference<ApiLookup>> instances = new HashMap<AndroidVersion, WeakReference<ApiLookup>>();
    private int packageCount;
    private final IAndroidTarget target;

    public static ApiLookup get(LintClient client) {
        return ApiLookup.get(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiLookup get(LintClient client, IAndroidTarget target) {
        Class<ApiLookup> clazz = ApiLookup.class;
        synchronized (ApiLookup.class) {
            ApiLookup db;
            AndroidVersion version = target != null ? target.getVersion() : AndroidVersion.DEFAULT;
            WeakReference<ApiLookup> reference = instances.get(version);
            ApiLookup apiLookup = db = reference != null ? (ApiLookup)reference.get() : null;
            if (db == null) {
                String env = System.getProperty("LINT_API_DATABASE");
                File file = null;
                if (env != null) {
                    file = new File(env);
                    if (!file.exists()) {
                        file = null;
                    }
                } else {
                    if (target != null && version.getFeatureLevel() >= 26 && !(file = new File(target.getFile(7), XML_FILE_PATH)).isFile()) {
                        file = null;
                    }
                    if (file == null) {
                        target = null;
                        file = client.findResource(XML_FILE_PATH);
                    }
                }
                if (file == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                db = ApiLookup.get(client, file, target);
                instances.put(version, new WeakReference<ApiLookup>(db));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return db;
        }
    }

    public IAndroidTarget getTarget() {
        return this.target;
    }

    static String getPlatformVersion(LintClient client) {
        LocalPackage pkgInfo;
        AndroidSdkHandler sdk = client.getSdk();
        if (sdk != null && (pkgInfo = sdk.getLocalPackage("platform-tools", client.getRepositoryLogger())) != null) {
            return pkgInfo.getVersion().toShortString();
        }
        return null;
    }

    static String getCacheFileName(String xmlFileName, String platformVersion) {
        if (LintUtils.endsWith((String)xmlFileName, (String)".xml")) {
            xmlFileName = xmlFileName.substring(0, xmlFileName.length() - ".xml".length());
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(xmlFileName);
        sb.append('-').append(11);
        if (platformVersion != null) {
            sb.append('-').append(platformVersion.replace(' ', '_'));
        }
        sb.append(".bin");
        return sb.toString();
    }

    private static ApiLookup get(LintClient client, File xmlFile, IAndroidTarget target) {
        if (!xmlFile.exists()) {
            client.log(null, "The API database file %1$s does not exist", new Object[]{xmlFile});
            return null;
        }
        File cacheDir = client.getCacheDir(null, true);
        if (cacheDir == null) {
            cacheDir = xmlFile.getParentFile();
        }
        String platformVersion = ApiLookup.getPlatformVersion(client);
        File binaryData = new File(cacheDir, ApiLookup.getCacheFileName(xmlFile.getName(), platformVersion));
        if (!(binaryData.exists() && binaryData.lastModified() >= xmlFile.lastModified() && binaryData.length() != 0L || ApiLookup.createCache(client, xmlFile, binaryData))) {
            return null;
        }
        if (!binaryData.exists()) {
            client.log(null, "The API database file %1$s does not exist", new Object[]{binaryData});
            return null;
        }
        return new ApiLookup(client, xmlFile, binaryData, null, target);
    }

    private static boolean createCache(LintClient client, File xmlFile, File binaryData) {
        long begin = 0L;
        Api info = Api.parseApi(xmlFile);
        if (info != null) {
            try {
                ApiLookup.writeDatabase(binaryData, info);
                return true;
            }
            catch (IOException e) {
                client.log((Throwable)e, "Can't write API cache file", new Object[0]);
            }
        }
        return false;
    }

    private ApiLookup(LintClient client, File xmlFile, File binaryFile, Api info, IAndroidTarget target) {
        this.mInfo = info;
        this.target = target;
        if (binaryFile != null) {
            this.readData(client, xmlFile, binaryFile);
        }
    }

    private void readData(LintClient client, File xmlFile, File binaryFile) {
        if (!binaryFile.exists()) {
            client.log(null, "%1$s does not exist", new Object[]{binaryFile});
            return;
        }
        long start = 0L;
        try {
            byte[] expectedHeader;
            byte[] b = Files.toByteArray((File)binaryFile);
            int offset = 0;
            for (byte anExpectedHeader : expectedHeader = FILE_HEADER.getBytes(StandardCharsets.US_ASCII)) {
                if (anExpectedHeader == b[offset++]) continue;
                client.log(null, "Incorrect file header: not an API database cache file, or a corrupt cache file", new Object[0]);
                return;
            }
            if (b[offset++] != 11) {
                if (ApiLookup.createCache(client, xmlFile, binaryFile)) {
                    this.readData(client, xmlFile, binaryFile);
                }
                return;
            }
            int indexCount = ApiLookup.get4ByteInt(b, offset);
            this.packageCount = ApiLookup.get4ByteInt(b, offset += 4);
            offset += 4;
            this.mIndices = new int[indexCount];
            for (int i = 0; i < indexCount; ++i) {
                this.mIndices[i] = ApiLookup.get4ByteInt(b, offset);
                offset += 4;
            }
            this.mData = b;
        }
        catch (Throwable e) {
            client.log(null, "Failure reading binary cache file %1$s", new Object[]{binaryFile.getPath()});
            client.log(null, "Please delete the file and restart the IDE/lint: %1$s", new Object[]{binaryFile.getPath()});
            client.log(e, null, new Object[0]);
        }
    }

    private static void writeDatabase(File file, Api info) throws IOException {
        int removedIn;
        int deprecatedIn;
        int since;
        Map<String, ApiClass> classMap = info.getClasses();
        ArrayList<ApiPackage> packages = new ArrayList<ApiPackage>(info.getPackages().values());
        Collections.sort(packages);
        int estimatedSize = 0;
        for (ApiPackage pkg : packages) {
            estimatedSize += 4;
            estimatedSize += pkg.getName().length() + 20;
            if (LintUtils.assertionsEnabled() && !ApiLookup.isRelevantOwner(pkg.getName() + "/") && !pkg.getName().startsWith("android/support")) {
                System.out.println("Warning: isRelevantOwner fails for " + pkg.getName() + "/");
            }
            for (ApiClass cls : pkg.getClasses()) {
                estimatedSize += 4;
                estimatedSize += cls.getName().length() + 20;
                Iterator allMethods = cls.getAllMethods(info);
                Set<String> allFields = cls.getAllFields(info);
                Iterator<ApiClass> members = new ArrayList(allMethods.size() + allFields.size());
                Iterator iterator = allMethods.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (cls.getMethod(string, info) == cls.getSince() && cls.getMemberDeprecatedIn(string, info) == cls.getDeprecatedIn() && cls.getMemberRemovedIn(string, info) == cls.getRemovedIn()) continue;
                    members.add((ApiClass)((Object)string));
                }
                for (String string : allFields) {
                    if (cls.getField(string, info) == cls.getSince() && cls.getMemberDeprecatedIn(string, info) == cls.getDeprecatedIn() && cls.getMemberRemovedIn(string, info) == cls.getRemovedIn()) continue;
                    members.add((ApiClass)((Object)string));
                }
                estimatedSize += 2 + 4 * cls.getInterfaces().size();
                if (cls.getSuperClasses().size() > 1) {
                    estimatedSize += 2 + 4 * cls.getSuperClasses().size();
                }
                Collections.sort(members);
                cls.members = members;
                Iterator iterator2 = members.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    estimatedSize += string.length();
                    estimatedSize += 16;
                }
            }
            Collections.sort(pkg.getClasses());
        }
        ByteBuffer buffer = ByteBuffer.allocate(estimatedSize);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.put(FILE_HEADER.getBytes(StandardCharsets.US_ASCII));
        buffer.put((byte)11);
        int indexCountOffset = buffer.position();
        int indexCount = 0;
        buffer.putInt(0);
        buffer.putInt(packages.size());
        int newIndex = buffer.position();
        for (ApiPackage pkg : packages) {
            pkg.indexOffset = newIndex;
            newIndex += 4;
            ++indexCount;
        }
        for (ApiPackage pkg : packages) {
            for (ApiClass apiClass : pkg.getClasses()) {
                apiClass.indexOffset = newIndex;
                apiClass.index = indexCount++;
                newIndex += 4;
            }
        }
        for (ApiPackage pkg : packages) {
            for (ApiClass apiClass : pkg.getClasses()) {
                if (apiClass.members != null && !apiClass.members.isEmpty()) {
                    apiClass.memberOffsetBegin = newIndex;
                    apiClass.memberIndexStart = indexCount;
                    for (String ignored : apiClass.members) {
                        newIndex += 4;
                        ++indexCount;
                    }
                    apiClass.memberOffsetEnd = newIndex;
                    apiClass.memberIndexLength = indexCount - apiClass.memberIndexStart;
                    continue;
                }
                apiClass.memberOffsetBegin = -1;
                apiClass.memberOffsetEnd = -1;
                apiClass.memberIndexStart = -1;
                apiClass.memberIndexLength = 0;
            }
        }
        buffer.position(indexCountOffset);
        buffer.putInt(indexCount);
        buffer.position(newIndex);
        for (ApiPackage pkg : packages) {
            for (ApiClass apiClass : pkg.getClasses()) {
                String string = apiClass.getName();
                int index = apiClass.memberOffsetBegin;
                for (String member : apiClass.members) {
                    byte[] signature;
                    int start = buffer.position();
                    buffer.position(index);
                    buffer.putInt(start);
                    index = buffer.position();
                    buffer.position(start);
                    since = member.indexOf(40) != -1 ? apiClass.getMethod(member, info) : apiClass.getField(member, info);
                    if (since == 0) {
                        assert (false) : string + ':' + member;
                        since = 1;
                    }
                    deprecatedIn = apiClass.getMemberDeprecatedIn(member, info);
                    assert (deprecatedIn >= 0) : "Invalid deprecatedIn " + deprecatedIn + " for " + member;
                    removedIn = apiClass.getMemberRemovedIn(member, info);
                    assert (removedIn >= 0) : "Invalid removedIn " + removedIn + " for " + member;
                    for (byte b : signature = member.getBytes(StandardCharsets.UTF_8)) {
                        assert (b == (b & 0x7F)) : member;
                        buffer.put(b);
                        if (b == 41) break;
                    }
                    buffer.put((byte)0);
                    ApiLookup.writeSinceDeprecatedInRemovedIn(buffer, since, deprecatedIn, removedIn);
                }
                assert (index == apiClass.memberOffsetEnd) : apiClass.memberOffsetEnd;
            }
        }
        for (ApiPackage pkg : packages) {
            List<ApiClass> classes = pkg.getClasses();
            for (ApiClass apiClass : classes) {
                int api;
                List<Pair<String, Integer>> supers;
                int index = buffer.position();
                buffer.position(apiClass.indexOffset);
                buffer.putInt(index);
                buffer.position(index);
                String name = apiClass.getSimpleName();
                byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
                assert (nameBytes.length < 254) : name;
                buffer.put((byte)(nameBytes.length + 2));
                buffer.put(nameBytes);
                buffer.put((byte)0);
                ApiLookup.put3ByteInt(buffer, apiClass.memberIndexStart);
                ApiLookup.put2ByteInt(buffer, apiClass.memberIndexLength);
                ApiClass apiClass2 = classMap.get(apiClass.getName());
                assert (apiClass2 != null) : apiClass.getName();
                since = apiClass2.getSince();
                deprecatedIn = apiClass2.getDeprecatedIn();
                removedIn = apiClass2.getRemovedIn();
                ApiLookup.writeSinceDeprecatedInRemovedIn(buffer, since, deprecatedIn, removedIn);
                List<Pair<String, Integer>> interfaces = apiClass2.getInterfaces();
                int count = 0;
                if (!interfaces.isEmpty()) {
                    for (Pair<String, Integer> pair : interfaces) {
                        int api2 = (Integer)pair.getSecond();
                        if (api2 <= apiClass2.getSince()) continue;
                        ++count;
                    }
                }
                if (!(supers = apiClass2.getSuperClasses()).isEmpty()) {
                    for (Pair<String, Integer> pair : supers) {
                        api = (Integer)pair.getSecond();
                        if (api <= apiClass2.getSince()) continue;
                        ++count;
                    }
                }
                buffer.put((byte)count);
                if (count <= 0) continue;
                for (Pair<String, Integer> pair : supers) {
                    api = (Integer)pair.getSecond();
                    if (api <= apiClass2.getSince()) continue;
                    ApiClass superClass = classMap.get(pair.getFirst());
                    assert (superClass != null) : apiClass;
                    ApiLookup.put3ByteInt(buffer, superClass.index);
                    buffer.put((byte)api);
                }
                for (Pair<String, Integer> pair : interfaces) {
                    api = (Integer)pair.getSecond();
                    if (api <= apiClass2.getSince()) continue;
                    ApiClass interfaceClass = classMap.get(pair.getFirst());
                    assert (interfaceClass != null) : apiClass;
                    ApiLookup.put3ByteInt(buffer, interfaceClass.index);
                    buffer.put((byte)api);
                }
            }
        }
        for (ApiPackage pkg : packages) {
            int index = buffer.position();
            buffer.position(pkg.indexOffset);
            buffer.putInt(index);
            buffer.position(index);
            byte[] byArray = pkg.getName().getBytes(StandardCharsets.UTF_8);
            buffer.put(byArray);
            buffer.put((byte)0);
            List<ApiClass> list = pkg.getClasses();
            if (list.isEmpty()) {
                ApiLookup.put3ByteInt(buffer, 0);
                ApiLookup.put2ByteInt(buffer, 0);
                continue;
            }
            int firstClassIndex = list.get((int)0).index;
            int classCount = list.get((int)(list.size() - 1)).index - firstClassIndex + 1;
            ApiLookup.put3ByteInt(buffer, firstClassIndex);
            ApiLookup.put2ByteInt(buffer, classCount);
        }
        int size = buffer.position();
        assert (size <= buffer.limit());
        buffer.mark();
        byte[] b = new byte[size];
        buffer.rewind();
        buffer.get(b);
        if (file.exists()) {
            boolean deleted = file.delete();
            assert (deleted) : file;
        }
        ByteSink sink = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]);
        sink.write(b);
    }

    private static void writeSinceDeprecatedInRemovedIn(ByteBuffer buffer, int since, int deprecatedIn, int removedIn) {
        boolean isRemoved;
        assert (since != 0 && since == (since & 0xFFFFFF7F));
        assert (deprecatedIn == (deprecatedIn & 0xFFFFFF7F));
        assert (removedIn == (removedIn & 0xFFFFFF7F));
        boolean isDeprecated = deprecatedIn > 0;
        boolean bl = isRemoved = removedIn > 0;
        if (isDeprecated || isRemoved) {
            since |= 0x80;
        }
        buffer.put((byte)since);
        if (isDeprecated || isRemoved) {
            if (isRemoved) {
                deprecatedIn |= 0x80;
            }
            buffer.put((byte)deprecatedIn);
            if (isRemoved) {
                buffer.put((byte)removedIn);
            }
        }
    }

    private String dumpEntry(int offset) {
        return "<disabled>";
    }

    private static int compare(byte[] data, int offset, byte terminator, String s, int sOffset, int max) {
        int i = offset;
        for (int j = sOffset; j < max; ++j) {
            byte cb;
            int delta;
            byte b = data[i];
            int c = s.charAt(j);
            if (c == 46) {
                c = 47;
            }
            if ((delta = b - (cb = (byte)c)) != 0) {
                return delta;
            }
            ++i;
        }
        return data[i] - terminator;
    }

    public int getClassVersion(String className) {
        ApiClass cls;
        if (this.mData != null) {
            return this.getClassVersion(this.findClass(className));
        }
        if (this.mInfo != null && (cls = this.mInfo.getClass(className)) != null) {
            return cls.getSince();
        }
        return -1;
    }

    private int getClassVersion(int classNumber) {
        if (classNumber != -1) {
            int offset = this.seekClassData(classNumber, 2);
            int api = Byte.toUnsignedInt(this.mData[offset]) & 0xFFFFFF7F;
            return api > 1 ? api : -1;
        }
        return -1;
    }

    public int getValidCastVersion(String sourceClass, String destinationClass) {
        ApiClass cls;
        if (this.mData != null) {
            int interfaceNumber;
            int classNumber = this.findClass(sourceClass);
            if (classNumber != -1 && (interfaceNumber = this.findClass(destinationClass)) != -1) {
                int offset = this.seekClassData(classNumber, 5);
                int interfaceCount = this.mData[offset++];
                for (int i = 0; i < interfaceCount; ++i) {
                    int clsNumber = ApiLookup.get3ByteInt(this.mData, offset);
                    offset += 3;
                    byte api = this.mData[offset++];
                    if (clsNumber != interfaceNumber) continue;
                    return api;
                }
                return this.getClassVersion(classNumber);
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(sourceClass)) != null) {
            List<Pair<String, Integer>> interfaces = cls.getInterfaces();
            for (Pair<String, Integer> pair : interfaces) {
                String interfaceName = (String)pair.getFirst();
                if (!interfaceName.equals(destinationClass)) continue;
                return (Integer)pair.getSecond();
            }
        }
        return -1;
    }

    public int getClassDeprecatedIn(String className) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(className);
            if (classNumber != -1) {
                int offset = this.seekClassData(classNumber, 3);
                if (offset == -1) {
                    return -1;
                }
                int deprecatedIn = Byte.toUnsignedInt(this.mData[offset]);
                return deprecatedIn != 0 ? deprecatedIn : -1;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(className)) != null) {
            int deprecatedIn = cls.getDeprecatedIn();
            return deprecatedIn != 0 ? deprecatedIn : -1;
        }
        return -1;
    }

    public int getClassRemovedIn(String className) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(className);
            if (classNumber != -1) {
                int offset = this.seekClassData(classNumber, 4);
                if (offset == -1) {
                    return -1;
                }
                int removedIn = Byte.toUnsignedInt(this.mData[offset]);
                return removedIn != 0 ? removedIn : -1;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(className)) != null) {
            int removedIn = cls.getRemovedIn();
            return removedIn != 0 ? removedIn : -1;
        }
        return -1;
    }

    public boolean containsClass(String className) {
        if (this.mData != null) {
            return this.findClass(className) != -1;
        }
        if (this.mInfo != null) {
            return this.mInfo.getClass(className) != null;
        }
        return false;
    }

    public int getCallVersion(String owner, String name, String desc) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int api = this.findMember(classNumber, name, desc);
                if (api == -1) {
                    return this.getClassVersion(classNumber);
                }
                return api;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int since = cls.getMethod(signature, this.mInfo);
            if (since == 0) {
                since = -1;
            }
            return since;
        }
        return -1;
    }

    public int getCallDeprecatedIn(String owner, String name, String desc) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, desc);
                return deprecatedIn == 0 ? -1 : deprecatedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int deprecatedIn = cls.getMemberDeprecatedIn(signature, this.mInfo);
            return deprecatedIn == 0 ? -1 : deprecatedIn;
        }
        return -1;
    }

    public int getCallRemovedIn(String owner, String name, String desc) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int removedIn = this.findMemberRemovedIn(classNumber, name, desc);
                return removedIn == 0 ? -1 : removedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            String signature = name + desc;
            int removedIn = cls.getMemberRemovedIn(signature, this.mInfo);
            return removedIn == 0 ? -1 : removedIn;
        }
        return -1;
    }

    public Collection<ApiMember> getRemovedFields(String owner) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                return this.getRemovedMembers(classNumber, false);
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            return cls.getAllRemovedFields(this.mInfo);
        }
        return null;
    }

    public Collection<ApiMember> getRemovedCalls(String owner) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                return this.getRemovedMembers(classNumber, true);
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            return cls.getAllRemovedMethods(this.mInfo);
        }
        return null;
    }

    private Collection<ApiMember> getRemovedMembers(int classNumber, boolean methods) {
        int curr = this.seekClassData(classNumber, 1);
        int start = ApiLookup.get3ByteInt(this.mData, curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ApiMember> result = null;
        int end = start + length;
        for (int index = start; index < end; ++index) {
            int deprecatedIn;
            int since;
            byte b;
            int i;
            int offset = this.mIndices[index];
            boolean methodSignatureDetected = false;
            for (i = offset; i < this.mData.length && (b = this.mData[i]) != 0; ++i) {
                if (b != 40) continue;
                methodSignatureDetected = true;
            }
            if (i >= this.mData.length) {
                assert (false);
                break;
            }
            if (methodSignatureDetected != methods) continue;
            int endOfSignature = i++;
            if (((since = Byte.toUnsignedInt(this.mData[i++])) & 0x80) == 0 || ((deprecatedIn = Byte.toUnsignedInt(this.mData[i++])) & 0x80) == 0) continue;
            int removedIn = Byte.toUnsignedInt(this.mData[i]);
            if (removedIn != 0) {
                StringBuilder sb = new StringBuilder(endOfSignature - offset);
                for (i = offset; i < endOfSignature; ++i) {
                    sb.append((char)Byte.toUnsignedInt(this.mData[i]));
                }
                since &= 0xFFFFFF7F;
                deprecatedIn &= 0xFFFFFF7F;
                if (result == null) {
                    result = new ArrayList<ApiMember>();
                }
                result.add(new ApiMember(sb.toString(), since, deprecatedIn, removedIn));
                continue;
            }
            assert (false);
        }
        return result == null ? Collections.emptyList() : result;
    }

    public int getFieldVersion(String owner, String name) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int api = this.findMember(classNumber, name, null);
                if (api == -1) {
                    return this.getClassVersion(classNumber);
                }
                return api;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            int since = cls.getField(name, this.mInfo);
            if (since == 0) {
                since = -1;
            }
            return since;
        }
        return -1;
    }

    public int getFieldDeprecatedIn(String owner, String name) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, null);
                return deprecatedIn == 0 ? -1 : deprecatedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            int deprecatedIn = cls.getMemberDeprecatedIn(name, this.mInfo);
            return deprecatedIn == 0 ? -1 : deprecatedIn;
        }
        return -1;
    }

    public int getFieldRemovedIn(String owner, String name) {
        ApiClass cls;
        if (this.mData != null) {
            int classNumber = this.findClass(owner);
            if (classNumber != -1) {
                int removedIn = this.findMemberRemovedIn(classNumber, name, null);
                return removedIn == 0 ? -1 : removedIn;
            }
        } else if (this.mInfo != null && (cls = this.mInfo.getClass(owner)) != null) {
            int removedIn = cls.getMemberRemovedIn(name, this.mInfo);
            return removedIn == 0 ? -1 : removedIn;
        }
        return -1;
    }

    public static boolean isRelevantOwner(String owner) {
        if (owner.startsWith("java")) {
            return true;
        }
        if (owner.startsWith("android")) {
            return !owner.startsWith("/support/", 7);
        }
        return owner.startsWith("org/") ? owner.startsWith("xml", 4) || owner.startsWith("w3c/", 4) || owner.startsWith("json/", 4) || owner.startsWith("apache/", 4) : (owner.startsWith("com/") ? owner.startsWith("google/", 4) || owner.startsWith("android/", 4) : owner.startsWith("junit") || owner.startsWith("dalvik"));
    }

    public boolean isValidJavaPackage(String owner) {
        return this.findPackage(owner) != -1;
    }

    private int findPackage(String owner) {
        int low = 0;
        int high = this.packageCount;
        int packageNameLength = this.lastIndexOfDotOrSlash(owner);
        if (packageNameLength < 0) {
            packageNameLength = 0;
        }
        while (low < high) {
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            int compare = ApiLookup.compare(this.mData, offset, (byte)0, owner, 0, packageNameLength);
            if (compare == 0) {
                return middle;
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            assert (compare > 0);
            high = middle;
        }
        return -1;
    }

    private static int get4ByteInt(byte[] data, int offset) {
        byte b1 = data[offset++];
        byte b2 = data[offset++];
        byte b3 = data[offset++];
        byte b4 = data[offset];
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static void put3ByteInt(ByteBuffer buffer, int value) {
        byte b3 = (byte)(value & 0xFF);
        byte b2 = (byte)((value >>>= 8) & 0xFF);
        byte b1 = (byte)((value >>>= 8) & 0xFF);
        buffer.put(b1);
        buffer.put(b2);
        buffer.put(b3);
    }

    private static void put2ByteInt(ByteBuffer buffer, int value) {
        byte b2 = (byte)(value & 0xFF);
        byte b1 = (byte)((value >>>= 8) & 0xFF);
        buffer.put(b1);
        buffer.put(b2);
    }

    private static int get3ByteInt(byte[] mData, int offset) {
        byte b1 = mData[offset++];
        byte b2 = mData[offset++];
        byte b3 = mData[offset];
        return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    private static int get2ByteInt(byte[] data, int offset) {
        byte b1 = data[offset++];
        byte b2 = data[offset];
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    private int findClass(String owner) {
        int packageNumber = this.findPackage(owner);
        if (packageNumber == -1) {
            return -1;
        }
        int curr = this.mIndices[packageNumber];
        while (this.mData[curr] != 0) {
            ++curr;
        }
        int low = ApiLookup.get3ByteInt(this.mData, ++curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return -1;
        }
        int high = low + length;
        int index = this.lastIndexOfDotOrSlash(owner);
        int classNameLength = owner.length();
        while (low < high) {
            int compare;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if ((compare = ApiLookup.compare(this.mData, ++offset, (byte)0, owner, index + 1, classNameLength)) == 0) {
                return middle;
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            assert (compare > 0);
            high = middle;
        }
        return -1;
    }

    private int lastIndexOfDotOrSlash(String name) {
        int i = name.length();
        while (--i >= 0) {
            char c = name.charAt(i);
            if (c != '.' && c != '/') continue;
            return i;
        }
        return -1;
    }

    private int findMember(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 2);
    }

    private int findMemberDeprecatedIn(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 3);
    }

    private int findMemberRemovedIn(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 4);
    }

    private int seekClassData(int classNumber, int field) {
        int offset = this.mIndices[classNumber];
        offset += this.mData[offset] & 0xFF;
        if (field == 1) {
            return offset;
        }
        offset += 5;
        if (field == 2) {
            return offset;
        }
        boolean hasDeprecatedIn = (this.mData[offset] & 0x80) != 0;
        boolean hasRemovedIn = false;
        ++offset;
        if (field == 3) {
            return hasDeprecatedIn ? offset : -1;
        }
        if (hasDeprecatedIn) {
            hasRemovedIn = (this.mData[offset] & 0x80) != 0;
            ++offset;
        }
        if (field == 4) {
            return hasRemovedIn ? offset : -1;
        }
        if (hasRemovedIn) {
            ++offset;
        }
        assert (field == 5);
        return offset;
    }

    private int findMember(int classNumber, String name, String desc, int apiLevelField) {
        int curr = this.seekClassData(classNumber, 1);
        int low = ApiLookup.get3ByteInt(this.mData, curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return -1;
        }
        int high = low + length;
        while (low < high) {
            int compare;
            int nameLength;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if (desc != null) {
                int argsEnd;
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)40, name, 0, nameLength);
                if (compare == 0 && (compare = ApiLookup.compare(this.mData, offset += nameLength, (byte)41, desc, 0, argsEnd = desc.indexOf(41))) == 0) {
                    offset += argsEnd + 1;
                    if (this.mData[offset++] == 0) {
                        return this.getApiLevel(offset, apiLevelField);
                    }
                }
            } else {
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)0, name, 0, nameLength);
                if (compare == 0) {
                    offset += nameLength;
                    if (this.mData[offset++] == 0) {
                        return this.getApiLevel(offset, apiLevelField);
                    }
                }
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    private int getApiLevel(int offset, int apiLevelField) {
        int api = Byte.toUnsignedInt(this.mData[offset]);
        if (apiLevelField == 2) {
            return api & 0xFFFFFF7F;
        }
        if ((api & 0x80) == 0) {
            return -1;
        }
        api = Byte.toUnsignedInt(this.mData[++offset]);
        if (apiLevelField == 3) {
            return (api &= 0xFFFFFF7F) == 0 ? -1 : api;
        }
        assert (apiLevelField == 4);
        if ((api & 0x80) == 0 || apiLevelField != 4) {
            return -1;
        }
        return (api = Byte.toUnsignedInt(this.mData[++offset])) == 0 ? -1 : api;
    }

    static void dispose() {
        instances.clear();
    }
}

