/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.MavenCoordinates;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SupportAnnotationDetector
extends Detector
implements Detector.UastScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(SupportAnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RANGE = Issue.create((String)"Range", (String)"Outside Range", (String)"Some parameters are required to in a particular numerical range; this check makes sure that arguments passed fall within the range. For arrays, Strings and collections this refers to the size or length.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue RESOURCE_TYPE = Issue.create((String)"ResourceType", (String)"Wrong Resource Type", (String)"Ensures that resource id's passed to APIs are of the right type; for example, calling `Resources.getColor(R.string.name)` is wrong.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue COLOR_USAGE = Issue.create((String)"ResourceAsColor", (String)"Should pass resolved color instead of resource id", (String)"Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue TYPE_DEF = Issue.create((String)"WrongConstant", (String)"Incorrect constant", (String)"Ensures that when parameter in a method only allows a specific set of constants, calls obey those rules.", (Category)Category.SECURITY, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue RESTRICTED = Issue.create((String)"RestrictedApi", (String)"Restricted API", (String)"This API has been flagged with a restriction that has not been met.\n\nExamples of API restrictions:\n* Method can only be invoked by a subclass\n* Method can only be accessed from within the same library (defined by  the Gradle library group id)\n.* Method can only be accessed from tests.\n.\nYou can add your own API restrictions with the `@RestrictTo` annotation.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue TEST_VISIBILITY = Issue.create((String)"VisibleForTests", (String)"Visible Only For Tests", (String)"With the `@VisibleForTesting` annotation you can specify an `otherwise=` attribute which specifies the intended visibility if the method had not been made more widely visible for the tests.\n\nThis check looks for accesses from production code (e.g. not tests) where the access would not have been allowed with the intended production visibility.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue CHECK_RESULT = Issue.create((String)"CheckResult", (String)"Ignoring results", (String)"Some methods have no side effects, an calling them without doing something without the result is suspicious. ", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue CHECK_PERMISSION = Issue.create((String)"UseCheckPermission", (String)"Using the result of check permission calls", (String)"You normally want to use the result of checking a permission; these methods return whether the permission is held; they do not throw an error if the permission is not granted. Code which does not do anything with the return value probably meant to be calling the enforce methods instead, e.g. rather than `Context#checkCallingPermission` it should call `Context#enforceCallingPermission`.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue MISSING_PERMISSION = Issue.create((String)"MissingPermission", (String)"Missing Permissions", (String)"This check scans through your code and libraries and looks at the APIs being used, and checks this against the set of permissions required to access those APIs. If the code using those APIs is called at runtime, then the program will crash.\n\nFurthermore, for permissions that are revocable (with targetSdkVersion 23), client code must also be prepared to handle the calls throwing an exception if the user rejects the request for permission at runtime.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue THREAD = Issue.create((String)"WrongThread", (String)"Wrong Thread", (String)"Ensures that a method which expects to be called on a specific thread, is actually called from that thread. For example, calls on methods in widgets should always be made on the UI thread.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/components/processes-and-threads.html#Threads");
    public static final String GMS_HIDE_ANNOTATION = "com.google.android.gms.common.internal.Hide";
    public static final String CHECK_RESULT_ANNOTATION = "android.support.annotation.CheckResult";
    public static final String INT_RANGE_ANNOTATION = "android.support.annotation.IntRange";
    public static final String FLOAT_RANGE_ANNOTATION = "android.support.annotation.FloatRange";
    public static final String SIZE_ANNOTATION = "android.support.annotation.Size";
    public static final String PERMISSION_ANNOTATION = "android.support.annotation.RequiresPermission";
    public static final String UI_THREAD_ANNOTATION = "android.support.annotation.UiThread";
    public static final String MAIN_THREAD_ANNOTATION = "android.support.annotation.MainThread";
    public static final String WORKER_THREAD_ANNOTATION = "android.support.annotation.WorkerThread";
    public static final String BINDER_THREAD_ANNOTATION = "android.support.annotation.BinderThread";
    public static final String ANY_THREAD_ANNOTATION = "android.support.annotation.AnyThread";
    public static final String RESTRICT_TO_ANNOTATION = "android.support.annotation.RestrictTo";
    public static final String VISIBLE_FOR_TESTING_ANNOTATION = "android.support.annotation.VisibleForTesting";
    public static final String PERMISSION_ANNOTATION_READ = "android.support.annotation.RequiresPermission.Read";
    public static final String PERMISSION_ANNOTATION_WRITE = "android.support.annotation.RequiresPermission.Write";
    public static final String HALF_FLOAT_ANNOTATION = "android.support.annotation.HalfFloat";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final String ATTR_OTHERWISE = "otherwise";
    public static final String SECURITY_EXCEPTION = "java.lang.SecurityException";
    private static final String THINGS_LIBRARY = "com.google.android.things";
    private PermissionHolder mPermissions;
    private static final int VISIBILITY_PRIVATE = 2;
    private static final int VISIBILITY_PACKAGE_PRIVATE = 3;
    private static final int VISIBILITY_PROTECTED = 4;
    private static final int VISIBILITY_NONE = 5;
    private static final int RESTRICT_TO_LIBRARY_GROUP = 1;
    private static final int RESTRICT_TO_LIBRARY = 2;
    private static final int RESTRICT_TO_TESTS = 4;
    private static final int RESTRICT_TO_SUBCLASSES = 8;
    private static final int RESTRICT_TO_ALL = 16;
    private Boolean mIsAndroidThingsProject;

    private static void report(JavaContext context, Issue issue, UElement scope, Location location, String message) {
        SupportAnnotationDetector.report(context, issue, scope, location, message, null);
    }

    private static void report(JavaContext context, Issue issue, UElement scope, Location location, String message, LintFix quickfixData) {
        LintDriver driver = context.getDriver();
        if (issue != RESOURCE_TYPE && scope != null && driver.isSuppressed(context, RESOURCE_TYPE, scope)) {
            return;
        }
        context.report(issue, scope, location, message, quickfixData);
    }

    private void checkContextAnnotations(JavaContext context, PsiMethod method, UElement call, List<UAnnotation> allMethodAnnotations) {
        UElement p = LintUtils.skipParentheses((UElement)call.getUastParent());
        if (p instanceof UQualifiedReferenceExpression) {
            call = p;
            p = p.getUastParent();
        }
        if (p instanceof UBinaryExpression) {
            UExpression check = null;
            UBinaryExpression binary = (UBinaryExpression)p;
            if (call == binary.getLeftOperand()) {
                check = binary.getRightOperand();
            } else if (call == binary.getRightOperand()) {
                check = binary.getLeftOperand();
            }
            if (check != null) {
                this.checkAnnotations(context, (UElement)check, check, method, allMethodAnnotations, Collections.emptyList(), Collections.emptyList());
            }
        } else if (p instanceof UQualifiedReferenceExpression) {
            List arguments;
            UExpression selector;
            UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)p;
            if ("equals".equals(ref.getResolvedName()) && (selector = ref.getSelector()) instanceof UCallExpression && (arguments = ((UCallExpression)selector).getValueArguments()).size() == 1) {
                this.checkAnnotations(context, (UElement)arguments.get(0), (UExpression)arguments.get(0), method, allMethodAnnotations, Collections.emptyList(), Collections.emptyList());
            }
        } else if (UastExpressionUtils.isAssignment((UElement)p)) {
            UBinaryExpression assignment = (UBinaryExpression)p;
            UExpression rExpression = assignment.getRightOperand();
            this.checkAnnotations(context, (UElement)rExpression, rExpression, method, allMethodAnnotations, Collections.emptyList(), Collections.emptyList());
        }
    }

    private void checkAnnotations(JavaContext context, UElement argument, UExpression call, PsiMethod method, List<UAnnotation> annotations, List<UAnnotation> allMethodAnnotations, List<UAnnotation> allClassAnnotations) {
        boolean handledResourceTypes = false;
        for (UAnnotation annotation : annotations) {
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            switch (signature) {
                case "android.support.annotation.ColorInt": {
                    SupportAnnotationDetector.checkColor(context, argument);
                    break;
                }
                case "android.support.annotation.Dimension": 
                case "android.support.annotation.Px": {
                    SupportAnnotationDetector.checkPx(context, argument);
                    break;
                }
                case "android.support.annotation.IntRange": {
                    SupportAnnotationDetector.checkIntRange(context, annotation, argument, annotations);
                    break;
                }
                case "android.support.annotation.FloatRange": {
                    SupportAnnotationDetector.checkFloatRange(context, annotation, argument);
                    break;
                }
                case "android.support.annotation.Size": {
                    SupportAnnotationDetector.checkSize(context, annotation, argument);
                    break;
                }
                case "android.support.annotation.RequiresPermission": 
                case "android.support.annotation.RequiresPermission.Read": 
                case "android.support.annotation.RequiresPermission.Write": {
                    if (annotations == allMethodAnnotations) {
                        PermissionRequirement requirement = PermissionRequirement.create(annotation);
                        this.checkPermission(context, call, method, null, requirement);
                        break;
                    }
                    if (!(argument instanceof UExpression) || method == null) break;
                    this.checkParameterPermission(context, signature, call, method, (UExpression)argument);
                    break;
                }
                case "android.support.annotation.IntDef": {
                    boolean flag = PermissionRequirement.getAnnotationBooleanValue(annotation, "flag") == Boolean.TRUE;
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, flag, annotations);
                    break;
                }
                case "android.support.annotation.StringDef": {
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, null, false, annotations);
                    break;
                }
                case "android.support.annotation.AnimatorRes": 
                case "android.support.annotation.AnimRes": 
                case "android.support.annotation.AnyRes": 
                case "android.support.annotation.ArrayRes": 
                case "android.support.annotation.AttrRes": 
                case "android.support.annotation.BoolRes": 
                case "android.support.annotation.ColorRes": 
                case "android.support.annotation.FontRes": 
                case "android.support.annotation.DimenRes": 
                case "android.support.annotation.DrawableRes": 
                case "android.support.annotation.FractionRes": 
                case "android.support.annotation.IdRes": 
                case "android.support.annotation.IntegerRes": 
                case "android.support.annotation.InterpolatorRes": 
                case "android.support.annotation.LayoutRes": 
                case "android.support.annotation.MenuRes": 
                case "android.support.annotation.PluralsRes": 
                case "android.support.annotation.RawRes": 
                case "android.support.annotation.StringRes": 
                case "android.support.annotation.StyleableRes": 
                case "android.support.annotation.StyleRes": 
                case "android.support.annotation.TransitionRes": 
                case "android.support.annotation.XmlRes": {
                    if (handledResourceTypes) break;
                    handledResourceTypes = true;
                    EnumSet types = ResourceEvaluator.getTypesFromAnnotations(annotations);
                    if (types == null) break;
                    SupportAnnotationDetector.checkResourceType(context, argument, types, call, method);
                    break;
                }
                case "android.support.annotation.CheckResult": 
                case "edu.umd.cs.findbugs.annotations.CheckReturnValue": 
                case "javax.annotation.CheckReturnValue": 
                case "com.google.errorprone.annotations.CanIgnoreReturnValue": {
                    if (method == null) break;
                    SupportAnnotationDetector.checkResult(context, call, method, annotation);
                    break;
                }
                case "android.support.annotation.UiThread": 
                case "android.support.annotation.MainThread": 
                case "android.support.annotation.BinderThread": 
                case "android.support.annotation.WorkerThread": 
                case "android.support.annotation.AnyThread": {
                    if (method == null) break;
                    SupportAnnotationDetector.checkThreading(context, call, method, signature, annotation, allMethodAnnotations, allClassAnnotations);
                    break;
                }
                case "android.support.annotation.RestrictTo": 
                case "com.google.android.gms.common.internal.Hide": {
                    if (method == null) break;
                    SupportAnnotationDetector.checkRestrictTo(context, (UElement)call, method, annotation, allMethodAnnotations, allClassAnnotations);
                    break;
                }
                case "android.support.annotation.VisibleForTesting": 
                case "com.google.common.annotations.VisibleForTesting": {
                    if (method == null) break;
                    SupportAnnotationDetector.checkVisibleForTesting(context, (UElement)call, method, annotation, allMethodAnnotations, allClassAnnotations);
                }
            }
        }
    }

    private void checkParameterPermission(JavaContext context, String signature, UExpression call, PsiMethod method, UExpression argument) {
        PermissionFinder.Operation operation = null;
        if (signature.equals(PERMISSION_ANNOTATION_READ)) {
            operation = PermissionFinder.Operation.READ;
        } else if (signature.equals(PERMISSION_ANNOTATION_WRITE)) {
            operation = PermissionFinder.Operation.WRITE;
        } else {
            PsiType type = argument.getExpressionType();
            if (type != null && "android.content.Intent".equals(type.getCanonicalText())) {
                operation = PermissionFinder.Operation.ACTION;
            }
        }
        if (operation == null) {
            return;
        }
        PermissionFinder.Result result = PermissionFinder.findRequiredPermissions(context, operation, (UElement)argument);
        if (result != null) {
            this.checkPermission(context, call, method, result, result.requirement);
        }
    }

    private static void checkColor(JavaContext context, UElement argument) {
        if (argument instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)argument;
            if (expression.getThenExpression() != null) {
                SupportAnnotationDetector.checkColor(context, (UElement)expression.getThenExpression());
            }
            if (expression.getElseExpression() != null) {
                SupportAnnotationDetector.checkColor(context, (UElement)expression.getElseExpression());
            }
            return;
        }
        EnumSet types = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (types != null && types.contains(ResourceType.COLOR)) {
            String message = String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.asSourceString());
            SupportAnnotationDetector.report(context, COLOR_USAGE, argument, context.getLocation(argument), message);
        }
    }

    private static void checkPx(JavaContext context, UElement argument) {
        if (argument instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)argument;
            if (expression.getThenExpression() != null) {
                SupportAnnotationDetector.checkPx(context, (UElement)expression.getThenExpression());
            }
            if (expression.getElseExpression() != null) {
                SupportAnnotationDetector.checkPx(context, (UElement)expression.getElseExpression());
            }
            return;
        }
        EnumSet types = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (types != null && types.contains(ResourceType.DIMEN)) {
            String message = String.format("Should pass resolved pixel dimension instead of resource id here: `getResources().getDimension*(%1$s)`", argument.asSourceString());
            SupportAnnotationDetector.report(context, COLOR_USAGE, argument, context.getLocation(argument), message);
        }
    }

    private void checkPermission(JavaContext context, UExpression node, PsiMethod method, PermissionFinder.Result result, PermissionRequirement requirement) {
        if (requirement.isConditional()) {
            return;
        }
        PermissionHolder permissions = this.getPermissions(context);
        if (!requirement.isSatisfied(permissions)) {
            if (!requirement.isSatisfied(permissions = SupportAnnotationDetector.addLocalPermissions(context, permissions, (UElement)node))) {
                PermissionFinder.Operation operation;
                String name;
                if (result != null) {
                    name = result.name;
                    operation = result.operation;
                } else {
                    assert (method != null);
                    PsiClass containingClass = method.getContainingClass();
                    name = containingClass != null ? containingClass.getName() + "." + method.getName() : method.getName();
                    operation = PermissionFinder.Operation.CALL;
                }
                String message = String.format("Missing permissions required %1$s %2$s: %3$s", operation.prefix(), name, requirement.describeMissingPermissions(permissions));
                Location location = context.getLocation((UElement)node);
                SupportAnnotationDetector.report(context, MISSING_PERMISSION, (UElement)node, location, message, SupportAnnotationDetector.fix().data(new Object[]{requirement.getMissingPermissions(permissions), requirement.getLastApplicableApi()}));
            }
        } else if (requirement.isRevocable(permissions) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23 && requirement.getLastApplicableApi() >= 23 && !this.isAndroidThingsProject((Context)context)) {
            UMethod methodNode;
            boolean handlesMissingPermission = SupportAnnotationDetector.handlesSecurityException((UElement)node);
            if (!handlesMissingPermission && (methodNode = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true)) != null) {
                CheckPermissionVisitor visitor = new CheckPermissionVisitor((UElement)node);
                methodNode.accept((UastVisitor)visitor);
                handlesMissingPermission = visitor.checksPermission();
            }
            if (!handlesMissingPermission) {
                String message = "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or explicitly handle a potential `SecurityException`";
                Location location = context.getLocation((UElement)node);
                SupportAnnotationDetector.report(context, MISSING_PERMISSION, (UElement)node, location, message, SupportAnnotationDetector.fix().data(new Object[]{requirement.getRevocablePermissions(permissions), requirement}));
            }
        }
    }

    private static boolean handlesSecurityException(UElement node) {
        PsiClassType[] thrownTypes;
        UTryExpression tryCatch;
        UElement parent = node;
        while ((tryCatch = (UTryExpression)UastUtils.getParentOfType((UElement)parent, UTryExpression.class, (boolean)true)) != null) {
            for (UCatchClause catchClause : tryCatch.getCatchClauses()) {
                if (!SupportAnnotationDetector.containsSecurityException(catchClause.getTypes())) continue;
                return true;
            }
            parent = tryCatch;
        }
        UMethod declaration = (UMethod)UastUtils.getParentOfType((UElement)parent, UMethod.class, (boolean)false);
        return declaration != null && SupportAnnotationDetector.containsSecurityException(Arrays.asList(thrownTypes = declaration.getThrowsList().getReferencedTypes()));
    }

    private static PermissionHolder addLocalPermissions(JavaContext context, PermissionHolder permissions, UElement node) {
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (method == null) {
            return permissions;
        }
        UAnnotation annotation = method.findAnnotation(PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        UClass containingClass = UastUtils.getContainingUClass((UElement)method);
        if (containingClass != null) {
            annotation = containingClass.findAnnotation(PERMISSION_ANNOTATION);
            permissions = SupportAnnotationDetector.mergeAnnotationPermissions(context, permissions, annotation);
        }
        return permissions;
    }

    private static PermissionHolder mergeAnnotationPermissions(JavaContext context, PermissionHolder permissions, UAnnotation annotation) {
        if (annotation != null) {
            PermissionRequirement requirement = PermissionRequirement.create(annotation);
            permissions = PermissionHolder.SetPermissionLookup.join(permissions, requirement);
        }
        return permissions;
    }

    private static boolean containsSecurityException(List<? extends PsiType> types) {
        for (PsiType psiType : types) {
            PsiClass cls;
            if (!(psiType instanceof PsiClassType) || (cls = ((PsiClassType)psiType).resolve()) == null || !SECURITY_EXCEPTION.equals(cls.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private PermissionHolder getPermissions(JavaContext context) {
        if (this.mPermissions == null) {
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
            Project mainProject = context.getMainProject();
            Document mergedManifest = mainProject.getMergedManifest();
            if (mergedManifest != null) {
                for (Element element : XmlUtils.getSubTags((Node)mergedManifest.getDocumentElement())) {
                    String name;
                    String protectionLevel;
                    String nodeName = element.getNodeName();
                    if ("uses-permission".equals(nodeName) || "uses-permission-sdk-23".equals(nodeName) || "uses-permission-sdk-m".equals(nodeName)) {
                        String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (name2.isEmpty()) continue;
                        permissions.add(name2);
                        continue;
                    }
                    if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = element.getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
                    revocable.add(name);
                }
            }
            AndroidVersion minSdkVersion = mainProject.getMinSdkVersion();
            AndroidVersion targetSdkVersion = mainProject.getTargetSdkVersion();
            this.mPermissions = new PermissionHolder.SetPermissionLookup(permissions, revocable, minSdkVersion, targetSdkVersion);
        }
        return this.mPermissions;
    }

    private static void checkResult(JavaContext context, UExpression node, PsiMethod method, UAnnotation annotation) {
        if (SupportAnnotationDetector.isExpressionValueUnused(node)) {
            String methodName = JavaContext.getMethodName((UElement)node);
            String suggested = PermissionRequirement.getAnnotationStringValue(annotation, ATTR_SUGGEST);
            Issue issue = CHECK_RESULT;
            if (methodName != null && methodName.startsWith("check") && methodName.contains("Permission")) {
                issue = CHECK_PERMISSION;
            }
            String message = String.format("The result of `%1$s` is not used", methodName);
            if (suggested != null) {
                message = String.format("The result of `%1$s` is not used; did you mean to call `%2$s`?", methodName, suggested);
            } else if ("intersect".equals(methodName) && context.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                message = message + ". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.";
            }
            Location location = context.getLocation((UElement)node);
            SupportAnnotationDetector.report(context, issue, (UElement)node, location, message, SupportAnnotationDetector.fix().data(new Object[]{suggested}));
        }
    }

    private static boolean isExpressionValueUnused(UExpression expression) {
        return UastUtils.getQualifiedParentOrThis((UExpression)expression).getUastParent() instanceof UBlockExpression;
    }

    private static boolean isGmsContext(JavaContext context, UElement element) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiPackage pkg = evaluator.getPackage(element);
        if (pkg == null) {
            return false;
        }
        String qualifiedName = pkg.getQualifiedName();
        return qualifiedName.startsWith("com.google.firebase") || qualifiedName.startsWith("com.google.android.gms");
    }

    private static boolean isTestContext(JavaContext context, UElement element) {
        UAnnotated owner;
        if (context.isTestSource()) {
            return true;
        }
        while ((owner = (UAnnotated)UastUtils.getParentOfType((UElement)element, UAnnotated.class, (boolean)true)) != null) {
            for (UAnnotation annotation : owner.getAnnotations()) {
                int restrictionScope;
                String name = annotation.getQualifiedName();
                if (!(RESTRICT_TO_ANNOTATION.equals(name) ? ((restrictionScope = SupportAnnotationDetector.getRestrictionScope(annotation)) & 4) != 0 : VISIBLE_FOR_TESTING_ANNOTATION.equals(name))) continue;
                return true;
            }
            element = owner;
        }
        return false;
    }

    public static void checkVisibleForTesting(JavaContext context, UElement node, PsiMethod method, UAnnotation annotation, List<UAnnotation> allMethodAnnotations, List<UAnnotation> allClassAnnotations) {
        int visibility = SupportAnnotationDetector.getVisibilityForTesting(annotation);
        if (visibility == 5) {
            SupportAnnotationDetector.checkRestrictTo(context, node, method, annotation, allMethodAnnotations, allClassAnnotations, 4);
        } else {
            PsiPackage methodPackage;
            PsiFile containingFile2;
            UFile uFile = UastUtils.getContainingFile((UElement)node);
            PsiFile containingFile1 = uFile != null ? uFile.getPsi() : null;
            if (Objects.equals(containingFile1, containingFile2 = method.getContainingFile()) || containingFile2 == null) {
                return;
            }
            if (visibility == 2) {
                if (!SupportAnnotationDetector.isTestContext(context, node)) {
                    SupportAnnotationDetector.reportVisibilityError(context, node, "private");
                }
                return;
            }
            JavaEvaluator evaluator = context.getEvaluator();
            PsiPackage pkg = evaluator.getPackage(node);
            if (Objects.equals(pkg, methodPackage = evaluator.getPackage((PsiElement)method))) {
                return;
            }
            if (visibility == 3) {
                if (!SupportAnnotationDetector.isTestContext(context, node)) {
                    SupportAnnotationDetector.reportVisibilityError(context, node, "package private");
                }
                return;
            }
            assert (visibility == 4);
            PsiClass methodClass = method.getContainingClass();
            UClass thisClass = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (thisClass == null || methodClass == null) {
                return;
            }
            String qualifiedName = methodClass.getQualifiedName();
            if (qualifiedName == null || evaluator.inheritsFrom((PsiClass)thisClass, qualifiedName, false)) {
                return;
            }
            if (!SupportAnnotationDetector.isTestContext(context, node)) {
                SupportAnnotationDetector.reportVisibilityError(context, node, "protected");
            }
        }
    }

    private static void reportVisibilityError(JavaContext context, UElement node, String desc) {
        String message = String.format("This method should only be accessed from tests or within %1$s scope", desc);
        Location location = node instanceof UCallExpression ? context.getCallLocation((UCallExpression)node, false, false) : context.getLocation(node);
        SupportAnnotationDetector.report(context, TEST_VISIBILITY, node, location, message);
    }

    public static int getVisibilityForTesting(UAnnotation annotation) {
        UExpression value = annotation.findDeclaredAttributeValue(ATTR_OTHERWISE);
        if (value instanceof ULiteralExpression) {
            Object v = ((ULiteralExpression)value).getValue();
            if (v instanceof Integer) {
                return (Integer)v;
            }
        } else if (value instanceof UReferenceExpression) {
            UReferenceExpression referenceExpression = (UReferenceExpression)value;
            String name = referenceExpression.getResolvedName();
            if ("NONE".equals(name)) {
                return 5;
            }
            if ("PRIVATE".equals(name)) {
                return 2;
            }
            if ("PROTECTED".equals(name)) {
                return 4;
            }
            if ("PACKAGE_PRIVATE".equals(name)) {
                return 3;
            }
        }
        return 2;
    }

    public static void checkRestrictTo(JavaContext context, UElement node, PsiMethod method, UAnnotation annotation, List<UAnnotation> allMethodAnnotations, List<UAnnotation> allClassAnnotations) {
        int scope = SupportAnnotationDetector.getRestrictionScope(annotation);
        if (scope != 0) {
            SupportAnnotationDetector.checkRestrictTo(context, node, method, annotation, allMethodAnnotations, allClassAnnotations, scope);
        }
    }

    private static void checkRestrictTo(JavaContext context, UElement node, PsiMethod method, UAnnotation annotation, List<UAnnotation> allMethodAnnotations, List<UAnnotation> allClassAnnotations, int scope) {
        String qualifiedName;
        String methodGroup;
        String thisGroup;
        MavenCoordinates methodCoordinates;
        MavenCoordinates thisCoordinates;
        JavaEvaluator evaluator;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        boolean isClassAnnotation = false;
        if (SupportAnnotationDetector.containsAnnotation(allMethodAnnotations, annotation)) {
            if (context.getEvaluator().isInherited(annotation, (PsiModifierListOwner)method)) {
                return;
            }
        } else {
            if (SupportAnnotationDetector.containsRestrictionAnnotation(allMethodAnnotations)) {
                return;
            }
            isClassAnnotation = SupportAnnotationDetector.containsAnnotation(allClassAnnotations, annotation);
            if (isClassAnnotation ? context.getEvaluator().isInherited(annotation, (PsiModifierListOwner)containingClass) : SupportAnnotationDetector.containsRestrictionAnnotation(allClassAnnotations)) {
                return;
            }
        }
        if ((scope & 1) != 0) {
            evaluator = context.getEvaluator();
            thisCoordinates = evaluator.getLibrary(node);
            methodCoordinates = evaluator.getLibrary((PsiElement)method);
            thisGroup = thisCoordinates != null ? thisCoordinates.getGroupId() : null;
            String string = methodGroup = methodCoordinates != null ? methodCoordinates.getGroupId() : null;
            if (!Objects.equals(thisGroup, methodGroup) && methodGroup != null) {
                String where = String.format("from within the same library group (groupId=%1$s)", methodGroup);
                SupportAnnotationDetector.reportRestriction(where, containingClass, method, context, node, isClassAnnotation);
            }
        }
        if ((scope & 2) != 0) {
            String methodArtifact;
            String thisArtifact;
            evaluator = context.getEvaluator();
            thisCoordinates = evaluator.getLibrary(node);
            methodCoordinates = evaluator.getLibrary((PsiElement)method);
            thisGroup = thisCoordinates != null ? thisCoordinates.getGroupId() : null;
            String string = methodGroup = methodCoordinates != null ? methodCoordinates.getGroupId() : null;
            if (!Objects.equals(thisGroup, methodGroup) && methodGroup != null && !Objects.equals(thisArtifact = thisCoordinates != null ? thisCoordinates.getArtifactId() : null, methodArtifact = methodCoordinates.getArtifactId())) {
                String where = String.format("from within the same library (%1$s:%2$s)", methodGroup, methodArtifact);
                SupportAnnotationDetector.reportRestriction(where, containingClass, method, context, node, isClassAnnotation);
            }
        }
        if ((scope & 4) != 0 && !SupportAnnotationDetector.isTestContext(context, node)) {
            SupportAnnotationDetector.reportRestriction("from tests", containingClass, method, context, node, isClassAnnotation);
        }
        if ((scope & 0x10) != 0 && !SupportAnnotationDetector.isGmsContext(context, node)) {
            SupportAnnotationDetector.reportRestriction(null, containingClass, method, context, node, isClassAnnotation);
        }
        if ((scope & 8) != 0 && (qualifiedName = containingClass.getQualifiedName()) != null) {
            UClass outer;
            JavaEvaluator evaluator2 = context.getEvaluator();
            boolean isSubClass = false;
            UElement prev = node;
            while ((outer = (UClass)UastUtils.getParentOfType((UElement)prev, UClass.class, (boolean)true)) != null) {
                if (evaluator2.inheritsFrom((PsiClass)outer, qualifiedName, false)) {
                    isSubClass = true;
                    break;
                }
                if (evaluator2.isStatic((PsiModifierListOwner)outer)) break;
                prev = outer;
            }
            if (!isSubClass) {
                SupportAnnotationDetector.reportRestriction("from subclasses", containingClass, method, context, node, isClassAnnotation);
            }
        }
    }

    private static void reportRestriction(String where, PsiClass containingClass, PsiMethod method, JavaContext context, UElement node, boolean isClassAnnotation) {
        String message;
        String api = method.isConstructor() ? method.getName() + " constructor" : containingClass.getName() + "." + method.getName();
        UElement locationNode = node;
        if (node instanceof UCallExpression) {
            UCallExpression callExpression = (UCallExpression)node;
            UIdentifier nameElement = callExpression.getMethodIdentifier();
            if (nameElement != null) {
                locationNode = nameElement;
            }
            if (isClassAnnotation) {
                UExpression qualifier = callExpression.getReceiver();
                String className = containingClass.getName();
                if (qualifier != null && className != null && qualifier.asSourceString().equals(className)) {
                    locationNode = qualifier;
                    api = className;
                }
            }
        }
        if (where == null) {
            message = api + " is marked as internal and should not be accessed from apps";
        } else {
            message = api + " can only be called " + where;
            if (where.equals("from within the same library (groupId=com.android.support)")) {
                message = "This API is marked as internal to the support library and should not be accessed from apps";
            }
        }
        Location location = locationNode instanceof UCallExpression ? context.getCallLocation((UCallExpression)locationNode, false, false) : context.getLocation(locationNode);
        SupportAnnotationDetector.report(context, RESTRICTED, node, location, message, null);
    }

    public static int getRestrictionScope(UAnnotation annotation) {
        UExpression value = annotation.findDeclaredAttributeValue("value");
        if (value != null) {
            return SupportAnnotationDetector.getRestrictionScope(value);
        }
        if (GMS_HIDE_ANNOTATION.equals(annotation.getQualifiedName())) {
            return 16;
        }
        return 0;
    }

    private static int getRestrictionScope(UExpression expression) {
        int scope = 0;
        if (expression != null) {
            PsiElement resolved;
            if (UastExpressionUtils.isArrayInitializer((UElement)expression)) {
                UCallExpression initializerExpression = (UCallExpression)expression;
                List initializers = initializerExpression.getValueArguments();
                for (UExpression initializer : initializers) {
                    scope |= SupportAnnotationDetector.getRestrictionScope(initializer);
                }
            } else if (expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) instanceof PsiField) {
                String name = ((PsiField)resolved).getName();
                if ("GROUP_ID".equals(name) || "LIBRARY_GROUP".equals(name)) {
                    scope |= 1;
                } else if ("SUBCLASSES".equals(name)) {
                    scope |= 8;
                } else if ("TESTS".equals(name)) {
                    scope |= 4;
                } else if ("LIBRARY".equals(name)) {
                    scope |= 2;
                }
            }
        }
        return scope;
    }

    private static void checkThreading(JavaContext context, UExpression node, PsiMethod method, String signature, UAnnotation annotation, List<UAnnotation> allMethodAnnotations, List<UAnnotation> allClassAnnotations) {
        List<String> threadContext = SupportAnnotationDetector.getThreadContext(context, (UElement)node);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread(threadContext, signature)) {
            String name;
            if (SupportAnnotationDetector.containsAnnotation(allClassAnnotations, annotation)) {
                if (SupportAnnotationDetector.containsThreadingAnnotation(allMethodAnnotations)) {
                    return;
                }
            } else {
                assert (SupportAnnotationDetector.containsAnnotation(allMethodAnnotations, annotation));
                Boolean isFirst = null;
                for (UAnnotation other : allMethodAnnotations) {
                    if (other == annotation) {
                        if (isFirst != null) continue;
                        isFirst = true;
                        continue;
                    }
                    if (!SupportAnnotationDetector.isThreadingAnnotation(other)) continue;
                    if (isFirst == null) {
                        return;
                    }
                    String s = other.getQualifiedName();
                    if (s == null || !SupportAnnotationDetector.isCompatibleThread(threadContext, s)) continue;
                    return;
                }
            }
            if ((name = method.getName()).startsWith("post") && context.getEvaluator().isMemberInClass((PsiMember)method, "android.view.View")) {
                return;
            }
            List<String> targetThreads = SupportAnnotationDetector.getThreads(context, method);
            if (targetThreads == null) {
                targetThreads = Collections.singletonList(signature);
            }
            String message = String.format("%1$s %2$s must be called from the %3$s thread, currently inferred thread is %4$s thread", method.isConstructor() ? "Constructor" : "Method", method.getName(), SupportAnnotationDetector.describeThreads(targetThreads, true), SupportAnnotationDetector.describeThreads(threadContext, false));
            Location location = context.getLocation((UElement)node);
            SupportAnnotationDetector.report(context, THREAD, (UElement)node, location, message);
        }
    }

    public static boolean containsAnnotation(List<UAnnotation> list, UAnnotation annotation) {
        for (UAnnotation a : list) {
            if (a != annotation) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRestrictionAnnotation(List<UAnnotation> list) {
        return SupportAnnotationDetector.containsAnnotation(list, RESTRICT_TO_ANNOTATION);
    }

    public static boolean containsAnnotation(List<UAnnotation> list, String qualifiedName) {
        for (UAnnotation annotation : list) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsThreadingAnnotation(List<UAnnotation> array) {
        for (UAnnotation annotation : array) {
            if (!SupportAnnotationDetector.isThreadingAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThreadingAnnotation(UAnnotation annotation) {
        String signature = annotation.getQualifiedName();
        return signature != null && signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.");
    }

    public static String describeThreads(List<String> annotations, boolean any) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < annotations.size(); ++i) {
            if (i > 0) {
                if (i == annotations.size() - 1) {
                    if (any) {
                        sb.append(" or ");
                    } else {
                        sb.append(" and ");
                    }
                } else {
                    sb.append(", ");
                }
            }
            sb.append(SupportAnnotationDetector.describeThread(annotations.get(i)));
        }
        return sb.toString();
    }

    public static String describeThread(String annotation) {
        switch (annotation) {
            case "android.support.annotation.UiThread": {
                return "UI";
            }
            case "android.support.annotation.MainThread": {
                return "main";
            }
            case "android.support.annotation.BinderThread": {
                return "binder";
            }
            case "android.support.annotation.WorkerThread": {
                return "worker";
            }
            case "android.support.annotation.AnyThread": {
                return "any";
            }
        }
        return "other";
    }

    public static boolean isCompatibleThread(List<String> callers, String callee) {
        assert (!callers.isEmpty());
        for (String caller : callers) {
            if (SupportAnnotationDetector.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatibleThread(String caller, String callee) {
        if (callee.equals(caller)) {
            return true;
        }
        if (callee.equals(ANY_THREAD_ANNOTATION)) {
            return true;
        }
        return callee.equals(UI_THREAD_ANNOTATION) ? caller.equals(MAIN_THREAD_ANNOTATION) : callee.equals(MAIN_THREAD_ANNOTATION) && caller.equals(UI_THREAD_ANNOTATION);
    }

    public static List<String> getThreadContext(JavaContext context, UElement methodCall) {
        PsiMethod method = (PsiMethod)UastUtils.getParentOfType((UElement)methodCall, UMethod.class, (boolean)true, (Class[])new Class[]{UAnonymousClass.class, ULambdaExpression.class});
        return SupportAnnotationDetector.getThreads(context, method);
    }

    private static List<String> getThreads(JavaContext context, PsiMethod method) {
        if (method != null) {
            ArrayList<String> result = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                for (PsiAnnotation annotation : method.getModifierList().getAnnotations()) {
                    String name = annotation.getQualifiedName();
                    if (name == null || !name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                    if (result == null) {
                        result = new ArrayList<String>(4);
                    }
                    result.add(name);
                }
                if (result != null) {
                    return result;
                }
                method = context.getEvaluator().getSuperMethod(method);
            }
            while (cls != null) {
                PsiModifierList modifierList = cls.getModifierList();
                if (modifierList != null) {
                    for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                        String name = annotation.getQualifiedName();
                        if (name == null || !name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                        if (result == null) {
                            result = new ArrayList(4);
                        }
                        result.add(name);
                    }
                    if (result != null) {
                        return result;
                    }
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private static boolean isNumber(UElement argument) {
        if (argument instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)argument).getValue();
            return value instanceof Number;
        }
        if (argument instanceof UPrefixExpression) {
            UPrefixExpression expression = (UPrefixExpression)argument;
            UExpression operand = expression.getOperand();
            return SupportAnnotationDetector.isNumber((UElement)operand);
        }
        return false;
    }

    private static boolean isZero(UElement argument) {
        if (argument instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)argument).getValue();
            return value instanceof Number && ((Number)value).intValue() == 0;
        }
        return false;
    }

    private static boolean isMinusOne(UElement argument) {
        if (argument instanceof UUnaryExpression) {
            UUnaryExpression expression = (UUnaryExpression)argument;
            UExpression operand = expression.getOperand();
            if (operand instanceof ULiteralExpression && expression.getOperator() == UastPrefixOperator.UNARY_MINUS) {
                Object value = ((ULiteralExpression)operand).getValue();
                return value instanceof Number && ((Number)value).intValue() == 1;
            }
            return false;
        }
        return false;
    }

    private static void checkResourceType(JavaContext context, UElement argument, EnumSet<ResourceType> expectedType, UExpression call, PsiMethod calledMethod) {
        EnumSet actual = ResourceEvaluator.getResourceTypes((JavaEvaluator)context.getEvaluator(), (UElement)argument);
        if (actual == null && (!SupportAnnotationDetector.isNumber(argument) || SupportAnnotationDetector.isZero(argument) || SupportAnnotationDetector.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (!Sets.intersection((Set)actual, expectedType).isEmpty() || expectedType.contains(ResourceType.DRAWABLE) && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        if (expectedType.contains(ResourceType.STYLEABLE) && expectedType.size() == 1 && context.getEvaluator().isMemberInClass((PsiMember)calledMethod, "android.content.res.TypedArray") && call instanceof UCallExpression && SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)((UCallExpression)call).getReceiver(), context)) {
            return;
        }
        String message = actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "Expected a color resource id (`R.color.`) but received an RGB integer" : (expectedType.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.asSourceString()) : (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? "Expected a dimension resource id (`R.color.`) but received a pixel integer" : (expectedType.contains(ResourceEvaluator.DIMENSION_MARKER_TYPE) ? String.format("Should pass resolved pixel size instead of resource id here: `getResources().getDimension*(%1$s)`", argument.asSourceString()) : (expectedType.size() < ResourceType.getNames().length - 2 ? String.format("Expected resource of type %1$s", Joiner.on((String)" or ").join(expectedType)) : "Expected resource identifier (`R`.type.`name`)"))));
        SupportAnnotationDetector.report(context, RESOURCE_TYPE, argument, context.getLocation(argument), message);
    }

    public static boolean typeArrayFromArrayLiteral(UElement node, JavaContext context) {
        UCallExpression expression = SupportAnnotationDetector.getMethodCall(node);
        if (expression != null) {
            List expressions;
            String name = expression.getMethodName();
            if (name != null && "obtainStyledAttributes".equals(name) && !(expressions = expression.getValueArguments()).isEmpty()) {
                int arg;
                if (expressions.size() == 1) {
                    arg = 0;
                } else if (expressions.size() == 2) {
                    PsiType type;
                    for (arg = 0; arg < expressions.size() && !((type = ((UExpression)expressions.get(arg)).getExpressionType()) instanceof PsiArrayType); ++arg) {
                    }
                    if (arg == expressions.size()) {
                        return false;
                    }
                } else if (expressions.size() == 4) {
                    arg = 1;
                } else {
                    return false;
                }
                return ConstantEvaluator.isArrayLiteral((UElement)((UElement)expressions.get(arg)));
            }
            return false;
        }
        if (node instanceof UReferenceExpression) {
            PsiVariable variable;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)(variable = (PsiVariable)resolved), (UElement)node)) != null) {
                return SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)lastAssignment, context);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression operand = parenthesizedExpression.getExpression();
                return SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)operand, context);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                assert (castExpression != null);
                UExpression operand = castExpression.getOperand();
                return SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)operand, context);
            }
        }
        return false;
    }

    private static UCallExpression getMethodCall(UElement node) {
        UExpression last;
        if (node instanceof UQualifiedReferenceExpression && UastExpressionUtils.isMethodCall((UElement)(last = SupportAnnotationDetector.getLastInQualifiedChain((UQualifiedReferenceExpression)node)))) {
            return (UCallExpression)last;
        }
        if (UastExpressionUtils.isMethodCall((UElement)node)) {
            return (UCallExpression)node;
        }
        return null;
    }

    private static UExpression getLastInQualifiedChain(UQualifiedReferenceExpression node) {
        UExpression last = node.getSelector();
        while (last instanceof UQualifiedReferenceExpression) {
            last = ((UQualifiedReferenceExpression)last).getSelector();
        }
        return last;
    }

    private static void checkIntRange(JavaContext context, UAnnotation annotation, UElement argument, List<UAnnotation> allAnnotations) {
        if (argument instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)argument;
            if (expression.getThenExpression() != null) {
                SupportAnnotationDetector.checkIntRange(context, annotation, (UElement)expression.getThenExpression(), allAnnotations);
            }
            if (expression.getElseExpression() != null) {
                SupportAnnotationDetector.checkIntRange(context, annotation, (UElement)expression.getElseExpression(), allAnnotations);
            }
            return;
        }
        String message = SupportAnnotationDetector.getIntRangeError(context, annotation, argument);
        if (message != null) {
            if (SupportAnnotationDetector.findIntDef(allAnnotations) != null) {
                return;
            }
            SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static String getIntRangeError(JavaContext context, UAnnotation annotation, UElement argument) {
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            UCallExpression newExpression = (UCallExpression)argument;
            for (UExpression uExpression : newExpression.getValueArguments()) {
                String error = SupportAnnotationDetector.getIntRangeError(context, annotation, (UElement)uExpression);
                if (error == null) continue;
                return error;
            }
        }
        IntRangeConstraint constraint = IntRangeConstraint.create(annotation);
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(object instanceof Number)) {
            PsiElement psiElement;
            if (object instanceof int[] || object instanceof long[]) {
                if (object instanceof int[]) {
                    int[] nArray = (int[])object;
                    int error = nArray.length;
                    for (int i = 0; i < error; ++i) {
                        int value = nArray[i];
                        if (constraint.isValid(value)) continue;
                        return constraint.describe(value);
                    }
                }
                if (object instanceof long[]) {
                    for (long value : (long[])object) {
                        if (constraint.isValid(value)) continue;
                        return constraint.describe(value);
                    }
                }
            }
            if (argument instanceof UResolvable && (psiElement = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                Boolean contains;
                RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)psiElement);
                RangeConstraint here = RangeConstraint.create(annotation);
                if (here != null && referenceConstraint != null && (contains = here.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                    return here.toString();
                }
            }
            return null;
        }
        long l = ((Number)object).longValue();
        if (!constraint.isValid(l)) {
            return constraint.describe(l);
        }
        return null;
    }

    private static void checkFloatRange(JavaContext context, UAnnotation annotation, UElement argument) {
        if (argument instanceof UIfExpression) {
            UIfExpression expression = (UIfExpression)argument;
            if (expression.getThenExpression() != null) {
                SupportAnnotationDetector.checkFloatRange(context, annotation, (UElement)expression.getThenExpression());
            }
            if (expression.getElseExpression() != null) {
                SupportAnnotationDetector.checkFloatRange(context, annotation, (UElement)expression.getElseExpression());
            }
            return;
        }
        FloatRangeConstraint constraint = FloatRangeConstraint.create(annotation);
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(object instanceof Number)) {
            PsiElement psiElement;
            if (object instanceof float[] || object instanceof double[] || object instanceof int[] || object instanceof long[]) {
                if (object instanceof float[]) {
                    for (float value : (float[])object) {
                        if (constraint.isValid(value)) continue;
                        String message = constraint.describe(value);
                        SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
                        return;
                    }
                }
                if (object instanceof double[]) {
                    for (double value : (double[])object) {
                        if (constraint.isValid(value)) continue;
                        String message = constraint.describe(value);
                        SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
                        return;
                    }
                }
                if (object instanceof int[]) {
                    for (int value : (int[])object) {
                        if (constraint.isValid(value)) continue;
                        String message = constraint.describe(value);
                        SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
                        return;
                    }
                }
                if (object instanceof long[]) {
                    for (long value : (long[])object) {
                        if (constraint.isValid(value)) continue;
                        String message = constraint.describe(value);
                        SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
                        return;
                    }
                }
            }
            if (argument instanceof UResolvable && (psiElement = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                Boolean contains;
                RangeConstraint referenceConstraint = RangeConstraint.create((PsiModifierListOwner)psiElement);
                RangeConstraint here = RangeConstraint.create(annotation);
                if (here != null && referenceConstraint != null && (contains = here.contains(referenceConstraint)) != null && !contains.booleanValue()) {
                    String message = here.toString();
                    SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
                }
            }
            return;
        }
        double d = ((Number)object).doubleValue();
        if (!constraint.isValid(d)) {
            String message = constraint.describe(argument instanceof UExpression ? (UExpression)argument : null, d);
            SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static void checkSize(JavaContext context, UAnnotation annotation, UElement argument) {
        long actual;
        boolean isString = false;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            actual = ((UCallExpression)argument).getValueArgumentCount();
        } else {
            if (argument instanceof UIfExpression) {
                UIfExpression expression = (UIfExpression)argument;
                if (expression.getThenExpression() != null) {
                    SupportAnnotationDetector.checkSize(context, annotation, (UElement)expression.getThenExpression());
                }
                if (expression.getElseExpression() != null) {
                    SupportAnnotationDetector.checkSize(context, annotation, (UElement)expression.getElseExpression());
                }
                return;
            }
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (object instanceof String) {
                actual = ((String)object).length();
                isString = true;
            } else {
                actual = SupportAnnotationDetector.getArrayLength(object);
                if (actual == -1L) {
                    PsiElement resolved;
                    if (argument instanceof UResolvable && (resolved = ((UResolvable)argument).resolve()) instanceof PsiModifierListOwner) {
                        Boolean contains;
                        RangeConstraint constraint = RangeConstraint.create((PsiModifierListOwner)resolved);
                        RangeConstraint here = RangeConstraint.create(annotation);
                        if (here != null && constraint != null && (contains = here.contains(constraint)) != null && !contains.booleanValue()) {
                            String message = here.toString();
                            SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
                        }
                    }
                    return;
                }
            }
        }
        SizeConstraint constraint = SizeConstraint.create(annotation);
        if (!constraint.isValid(actual)) {
            String unit = isString ? "length" : "size";
            String message = constraint.describe(argument instanceof UExpression ? (UExpression)argument : null, unit, actual);
            SupportAnnotationDetector.report(context, RANGE, argument, context.getLocation(argument), message);
        }
    }

    private static int getArrayLength(Object object) {
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        if (object instanceof int[]) {
            return ((int[])object).length;
        }
        if (object instanceof long[]) {
            return ((long[])object).length;
        }
        if (object instanceof float[]) {
            return ((float[])object).length;
        }
        if (object instanceof double[]) {
            return ((double[])object).length;
        }
        if (object instanceof char[]) {
            return ((char[])object).length;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof short[]) {
            return ((short[])object).length;
        }
        return -1;
    }

    private static UAnnotation findIntRange(List<UAnnotation> annotations) {
        for (UAnnotation annotation : annotations) {
            if (!INT_RANGE_ANNOTATION.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    static UAnnotation findIntDef(List<UAnnotation> annotations) {
        for (UAnnotation annotation : annotations) {
            if (!"android.support.annotation.IntDef".equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    private static void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, List<UAnnotation> allAnnotations) {
        block12: {
            block21: {
                PsiVariable variable;
                block22: {
                    block19: {
                        UPolyadicExpression expression;
                        block20: {
                            block18: {
                                block17: {
                                    block14: {
                                        UastPrefixOperator operator;
                                        block16: {
                                            UPrefixExpression expression2;
                                            block15: {
                                                block13: {
                                                    block10: {
                                                        long v;
                                                        Object value;
                                                        block11: {
                                                            if (argument == null) {
                                                                return;
                                                            }
                                                            if (!(argument instanceof ULiteralExpression)) break block10;
                                                            value = ((ULiteralExpression)argument).getValue();
                                                            if (value == null) {
                                                                return;
                                                            }
                                                            if (!(value instanceof String)) break block11;
                                                            String string = (String)value;
                                                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, false, string, allAnnotations);
                                                            break block12;
                                                        }
                                                        if (!(value instanceof Integer) && !(value instanceof Long)) break block12;
                                                        long l = v = value instanceof Long ? ((Long)value).longValue() : ((Integer)value).longValue();
                                                        if (flag && v == 0L) {
                                                            return;
                                                        }
                                                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value, allAnnotations);
                                                        break block12;
                                                    }
                                                    if (!SupportAnnotationDetector.isMinusOne(argument)) break block13;
                                                    if (flag) break block12;
                                                    SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                                                    break block12;
                                                }
                                                if (!(argument instanceof UPrefixExpression)) break block14;
                                                expression2 = (UPrefixExpression)argument;
                                                if (!flag) break block15;
                                                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression2.getOperand(), errorNode, true, allAnnotations);
                                                break block12;
                                            }
                                            operator = expression2.getOperator();
                                            if (operator != UastPrefixOperator.BITWISE_NOT) break block16;
                                            SupportAnnotationDetector.report(context, TYPE_DEF, (UElement)expression2, context.getLocation((UElement)expression2), "Flag not allowed here");
                                            break block12;
                                        }
                                        if (operator != UastPrefixOperator.UNARY_MINUS) break block12;
                                        SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                                        break block12;
                                    }
                                    if (!(argument instanceof UParenthesizedExpression)) break block17;
                                    UExpression expression3 = ((UParenthesizedExpression)argument).getExpression();
                                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression3, errorNode, flag, allAnnotations);
                                    break block12;
                                }
                                if (!(argument instanceof UIfExpression)) break block18;
                                UIfExpression expression4 = (UIfExpression)argument;
                                if (expression4.getThenExpression() != null) {
                                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression4.getThenExpression(), errorNode, flag, allAnnotations);
                                }
                                if (expression4.getElseExpression() == null) break block12;
                                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression4.getElseExpression(), errorNode, flag, allAnnotations);
                                break block12;
                            }
                            if (!(argument instanceof UPolyadicExpression)) break block19;
                            expression = (UPolyadicExpression)argument;
                            if (!flag) break block20;
                            for (UExpression operand : expression.getOperands()) {
                                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)operand, errorNode, true, allAnnotations);
                            }
                            break block12;
                        }
                        UastBinaryOperator operator = expression.getOperator();
                        if (operator != UastBinaryOperator.BITWISE_AND && operator != UastBinaryOperator.BITWISE_OR && operator != UastBinaryOperator.BITWISE_XOR) break block12;
                        SupportAnnotationDetector.report(context, TYPE_DEF, (UElement)expression, context.getLocation((UElement)expression), "Flag not allowed here");
                        break block12;
                    }
                    if (!(argument instanceof UReferenceExpression)) break block21;
                    PsiElement resolved = ((UReferenceExpression)argument).resolve();
                    if (!(resolved instanceof PsiVariable)) break block12;
                    variable = (PsiVariable)resolved;
                    if (variable.getType() instanceof PsiArrayType) {
                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode != null ? errorNode : argument, flag, resolved, allAnnotations);
                        return;
                    }
                    if (!variable.hasModifierProperty("static") || !variable.hasModifierProperty("final")) break block22;
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode != null ? errorNode : argument, flag, resolved, allAnnotations);
                    break block12;
                }
                UExpression lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)variable, (UElement)argument);
                if (lastAssignment == null) break block12;
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)lastAssignment, errorNode != null ? errorNode : argument, flag, allAnnotations);
                break block12;
            }
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument) || UastExpressionUtils.isArrayInitializer((UElement)argument)) {
                UCallExpression arrayInitializer = (UCallExpression)argument;
                PsiType type = arrayInitializer.getExpressionType();
                if (type != null) {
                    type = type.getDeepComponentType();
                }
                if (PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type)) {
                    for (UExpression expression : arrayInitializer.getValueArguments()) {
                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression, errorNode, flag, allAnnotations);
                    }
                }
            }
        }
    }

    private static void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, Object value, List<UAnnotation> allAnnotations) {
        UAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
        if (rangeAnnotation != null && !(value instanceof PsiField) && SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, argument) == null) {
            return;
        }
        UExpression allowed = SupportAnnotationDetector.getAnnotationValue(annotation);
        if (allowed == null) {
            return;
        }
        if (UastExpressionUtils.isArrayInitializer((UElement)allowed)) {
            PsiElement resolvedArgument;
            if (argument instanceof UReferenceExpression && (resolvedArgument = ((UReferenceExpression)argument).resolve()) instanceof PsiModifierListOwner) {
                JavaEvaluator evaluator = context.getEvaluator();
                for (PsiAnnotation a : SupportAnnotationDetector.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)resolvedArgument, true))) {
                    UExpression paramValues;
                    String qualifiedName = a.getQualifiedName();
                    if (!"android.support.annotation.IntDef".equals(qualifiedName) && !"android.support.annotation.StringDef".equals(qualifiedName) || (paramValues = SupportAnnotationDetector.getAnnotationValue(JavaUAnnotation.wrap((PsiAnnotation)a))) == null) continue;
                    if (paramValues.equals(allowed)) {
                        return;
                    }
                    List<Object> param = SupportAnnotationDetector.getResolvedValues(paramValues, argument);
                    List<Object> all = SupportAnnotationDetector.getResolvedValues(allowed, argument);
                    if (!all.containsAll(param)) continue;
                    return;
                }
            }
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            PsiElement psiValue = null;
            if (value instanceof PsiElement) {
                psiValue = (PsiElement)value;
            }
            for (UExpression expression : initializers) {
                PsiElement resolved;
                if (!(expression instanceof ULiteralExpression ? value.equals(((ULiteralExpression)expression).getValue()) : psiValue != null && (expression instanceof ExternalReferenceExpression ? (resolved = UastLintUtils.resolve((ExternalReferenceExpression)((ExternalReferenceExpression)expression), (UElement)argument)) != null && resolved.isEquivalentTo(psiValue) : expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) != null && resolved.isEquivalentTo(psiValue)))) continue;
                return;
            }
            if (value instanceof PsiField && rangeAnnotation == null) {
                PsiField astNode = (PsiField)value;
                UExpression initializer = context.getUastContext().getInitializerBody((PsiVariable)astNode);
                if (initializer != null) {
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)initializer, errorNode, flag, allAnnotations);
                    return;
                }
            }
            if (allowed instanceof PsiCompiledElement || annotation.getPsi() instanceof PsiCompiledElement) {
                return;
            }
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, flag, initializers, allAnnotations);
        }
    }

    private static List<Object> getResolvedValues(UExpression allowed, UElement context) {
        ArrayList result = Lists.newArrayList();
        if (UastExpressionUtils.isArrayInitializer((UElement)allowed)) {
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            for (UExpression expression : initializers) {
                PsiElement resolved;
                if (expression instanceof ULiteralExpression) {
                    Object value = ((ULiteralExpression)expression).getValue();
                    if (value == null) continue;
                    result.add(value);
                    continue;
                }
                if (expression instanceof ExternalReferenceExpression) {
                    resolved = UastLintUtils.resolve((ExternalReferenceExpression)((ExternalReferenceExpression)expression), (UElement)context);
                    if (resolved == null) continue;
                    result.add(resolved);
                    continue;
                }
                if (!(expression instanceof UReferenceExpression) || (resolved = ((UReferenceExpression)expression).resolve()) == null) continue;
                result.add(resolved);
            }
        }
        return result;
    }

    private static void reportTypeDef(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, List<UAnnotation> allAnnotations) {
        UExpression allowed = SupportAnnotationDetector.getAnnotationValue(annotation);
        if (allowed != null && UastExpressionUtils.isArrayInitializer((UElement)allowed)) {
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, false, initializers, allAnnotations);
        }
    }

    private static void reportTypeDef(JavaContext context, UElement node, UElement errorNode, boolean flag, List<UExpression> allowedValues, List<UAnnotation> allAnnotations) {
        String rangeError;
        if (errorNode == null) {
            errorNode = node;
        }
        String values = SupportAnnotationDetector.listAllowedValues(node, allowedValues);
        String message = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        UAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
        if (rangeAnnotation != null && (rangeError = SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, node)) != null && !rangeError.isEmpty()) {
            message = message + " or " + Character.toLowerCase(rangeError.charAt(0)) + rangeError.substring(1);
        }
        SupportAnnotationDetector.report(context, TYPE_DEF, errorNode, context.getLocation(errorNode), message);
    }

    private static UExpression getAnnotationValue(UAnnotation annotation) {
        UExpression value = annotation.findDeclaredAttributeValue("value");
        if (value == null) {
            value = annotation.findDeclaredAttributeValue(null);
        }
        return value;
    }

    private static String listAllowedValues(UElement context, List<UExpression> allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (UExpression allowedValue : allowedValues) {
            String s = null;
            PsiElement resolved = null;
            if (allowedValue instanceof ExternalReferenceExpression) {
                resolved = UastLintUtils.resolve((ExternalReferenceExpression)((ExternalReferenceExpression)allowedValue), (UElement)context);
            } else if (allowedValue instanceof UReferenceExpression) {
                resolved = ((UReferenceExpression)allowedValue).resolve();
            }
            if (resolved instanceof PsiField) {
                String containingClassName;
                PsiField field = (PsiField)resolved;
                String string = containingClassName = field.getContainingClass() != null ? field.getContainingClass().getName() : null;
                if (containingClassName == null) continue;
                s = containingClassName + "." + field.getName();
            }
            if (s == null) {
                s = allowedValue.asSourceString();
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static long getLongAttribute(JavaContext context, UAnnotation annotation, String name, long defaultValue) {
        Long value = PermissionRequirement.getAnnotationLongValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    static double getDoubleAttribute(JavaContext context, UAnnotation annotation, String name, double defaultValue) {
        Double value = PermissionRequirement.getAnnotationDoubleValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    static boolean getBoolean(JavaContext context, UAnnotation annotation, String name, boolean defaultValue) {
        Boolean value = PermissionRequirement.getAnnotationBooleanValue(annotation, name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    static PsiAnnotation[] filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations) {
        ArrayList<PsiAnnotation> result = null;
        int length = annotations.length;
        if (length == 0) {
            return annotations;
        }
        for (PsiAnnotation annotation : annotations) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement ref;
            String signature = annotation.getQualifiedName();
            if (signature == null || signature.startsWith("java.")) continue;
            if (signature.startsWith("android.support.annotation.") || signature.equals(GMS_HIDE_ANNOTATION)) {
                if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) continue;
                if (length == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList<PsiAnnotation>(2);
                }
                result.add(annotation);
            }
            if ((ref = annotation.getNameReferenceElement()) == null || !((resolved = ref.resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass cls = (PsiClass)resolved;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false);
            for (int j = 0; j < innerAnnotations.length; ++j) {
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a == null || a.startsWith("java.") || !a.equals("android.support.annotation.IntDef") && !a.equals(PERMISSION_ANNOTATION) && !a.equals(INT_RANGE_ANNOTATION) && !a.equals("android.support.annotation.StringDef")) continue;
                if (length == 1 && j == innerAnnotations.length - 1 && result == null) {
                    return innerAnnotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(inner);
            }
        }
        return result != null ? result.toArray(PsiAnnotation.EMPTY_ARRAY) : PsiAnnotation.EMPTY_ARRAY;
    }

    private boolean isAndroidThingsProject(Context context) {
        if (this.mIsAndroidThingsProject == null) {
            Project project = context.getMainProject();
            Document mergedManifest = project.getMergedManifest();
            if (mergedManifest == null) {
                return false;
            }
            Element manifest = mergedManifest.getDocumentElement();
            if (manifest == null) {
                return false;
            }
            Element application = XmlUtils.getFirstSubTagByName((Node)manifest, (String)"application");
            if (application == null) {
                return false;
            }
            Element usesLibrary = XmlUtils.getFirstSubTagByName((Node)application, (String)"uses-library");
            while (usesLibrary != null && this.mIsAndroidThingsProject == null) {
                String name = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                boolean isThingsLibraryRequired = true;
                String required = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "required");
                if ("false".equals(required)) {
                    isThingsLibraryRequired = false;
                }
                if (THINGS_LIBRARY.equals(name) && isThingsLibraryRequired) {
                    this.mIsAndroidThingsProject = true;
                }
                usesLibrary = XmlUtils.getNextTagByName((Node)usesLibrary, (String)"uses-library");
            }
            if (this.mIsAndroidThingsProject == null) {
                this.mIsAndroidThingsProject = false;
            }
        }
        return this.mIsAndroidThingsProject;
    }

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(4);
        types.add(UArrayAccessExpression.class);
        types.add(UCallExpression.class);
        types.add(UEnumConstant.class);
        types.add(UMethod.class);
        types.add(UAnnotation.class);
        return types;
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new CallVisitor(context);
    }

    private class CallVisitor
    extends UElementHandler {
        private final JavaContext mContext;

        public CallVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitMethod(final UMethod method) {
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiAnnotation[] methodAnnotations = SupportAnnotationDetector.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)method, true));
            if (methodAnnotations.length > 0) {
                final List annotations = JavaUAnnotation.wrap((PsiAnnotation[])methodAnnotations);
                method.accept((UastVisitor)new AbstractUastVisitor(){

                    public boolean visitReturnExpression(UReturnExpression node) {
                        UExpression returnValue = node.getReturnExpression();
                        if (returnValue != null) {
                            SupportAnnotationDetector.this.checkAnnotations(CallVisitor.this.mContext, (UElement)returnValue, returnValue, (PsiMethod)method, annotations, annotations, Collections.emptyList());
                        }
                        return super.visitReturnExpression(node);
                    }
                });
            }
        }

        public void visitCallExpression(UCallExpression call) {
            PsiMethod method = call.resolve();
            if (method != null) {
                this.checkCall(method, call);
            }
        }

        public void visitAnnotation(UAnnotation annotation) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null || qualifiedName.startsWith("java.") || qualifiedName.startsWith("android.support.annotation.")) {
                return;
            }
            List attributeValues = annotation.getAttributeValues();
            if (attributeValues.isEmpty()) {
                return;
            }
            PsiClass resolved = annotation.resolve();
            if (resolved == null) {
                return;
            }
            for (UNamedExpression expression : attributeValues) {
                PsiMethod[] methods;
                String name = expression.getName();
                if (name == null) {
                    name = "value";
                }
                if ((methods = resolved.findMethodsByName(name, false)).length != 1) continue;
                PsiMethod method = methods[0];
                JavaEvaluator evaluator = this.mContext.getEvaluator();
                PsiAnnotation[] methodAnnotations = SupportAnnotationDetector.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)method, true));
                if (methodAnnotations.length <= 0) continue;
                UExpression value = expression.getExpression();
                List annotations = JavaUAnnotation.wrap((PsiAnnotation[])methodAnnotations);
                SupportAnnotationDetector.this.checkAnnotations(this.mContext, (UElement)value, value, method, annotations, annotations, Collections.emptyList());
            }
        }

        public void visitEnumConstant(UEnumConstant constant) {
            PsiMethod method = constant.resolveMethod();
            if (method != null) {
                this.checkCall(method, (UCallExpression)constant);
            }
        }

        public void visitArrayAccessExpression(UArrayAccessExpression expression) {
            PsiElement resolved;
            UExpression arrayExpression = expression.getReceiver();
            if (arrayExpression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)arrayExpression).resolve()) instanceof PsiModifierListOwner) {
                JavaEvaluator evaluator = this.mContext.getEvaluator();
                PsiAnnotation[] methodAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)resolved, true);
                if ((methodAnnotations = SupportAnnotationDetector.filterRelevantAnnotations(evaluator, methodAnnotations)).length > 0) {
                    SupportAnnotationDetector.this.checkContextAnnotations(this.mContext, null, (UElement)expression, JavaUAnnotation.wrap((PsiAnnotation[])methodAnnotations));
                }
            }
        }

        private void checkCall(PsiMethod method, UCallExpression call) {
            List pkgAnnotations;
            List classAnnotations;
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)method, true);
            List methodAnnotations = JavaUAnnotation.wrap((PsiAnnotation[])SupportAnnotationDetector.filterRelevantAnnotations(evaluator, annotations));
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                PsiAnnotation[] annotations2 = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass, true);
                classAnnotations = JavaUAnnotation.wrap((PsiAnnotation[])SupportAnnotationDetector.filterRelevantAnnotations(evaluator, annotations2));
                PsiPackage pkg = evaluator.getPackage((PsiElement)containingClass);
                if (pkg != null) {
                    PsiAnnotation[] annotations22 = evaluator.getAllAnnotations((PsiModifierListOwner)pkg, false);
                    pkgAnnotations = JavaUAnnotation.wrap((PsiAnnotation[])SupportAnnotationDetector.filterRelevantAnnotations(evaluator, annotations22));
                } else {
                    pkgAnnotations = Collections.emptyList();
                }
            } else {
                classAnnotations = Collections.emptyList();
                pkgAnnotations = Collections.emptyList();
            }
            if (!methodAnnotations.isEmpty()) {
                SupportAnnotationDetector.this.checkAnnotations(this.mContext, (UElement)call, (UExpression)call, method, methodAnnotations, methodAnnotations, classAnnotations);
                SupportAnnotationDetector.this.checkContextAnnotations(this.mContext, method, (UElement)call, methodAnnotations);
            }
            if (!classAnnotations.isEmpty()) {
                SupportAnnotationDetector.this.checkAnnotations(this.mContext, (UElement)call, (UExpression)call, method, classAnnotations, methodAnnotations, classAnnotations);
            }
            if (!pkgAnnotations.isEmpty()) {
                SupportAnnotationDetector.this.checkAnnotations(this.mContext, (UElement)call, (UExpression)call, method, pkgAnnotations, methodAnnotations, classAnnotations);
            }
            List arguments = call.getValueArguments();
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            List annotations3 = null;
            int j = 0;
            if (parameters.length > 0 && "$receiver".equals(parameters[0].getName())) {
                ++j;
            }
            int i = 0;
            int n = Math.min(parameters.length, arguments.size());
            while (j < n) {
                UExpression argument = (UExpression)arguments.get(i);
                PsiParameter parameter = parameters[j];
                annotations3 = JavaUAnnotation.wrap((PsiAnnotation[])SupportAnnotationDetector.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)parameter, true)));
                SupportAnnotationDetector.this.checkAnnotations(this.mContext, (UElement)argument, (UExpression)call, method, annotations3, methodAnnotations, classAnnotations);
                ++i;
                ++j;
            }
            if (annotations3 != null) {
                for (i = parameters.length; i < arguments.size(); ++i) {
                    UExpression argument = (UExpression)arguments.get(i);
                    SupportAnnotationDetector.this.checkAnnotations(this.mContext, (UElement)argument, (UExpression)call, method, annotations3, methodAnnotations, classAnnotations);
                }
            }
        }
    }

    private static class CheckPermissionVisitor
    extends AbstractUastVisitor {
        private boolean mChecksPermission;
        private boolean mDone;
        private final UElement mTarget;

        public CheckPermissionVisitor(UElement target) {
            this.mTarget = target;
        }

        public boolean visitElement(UElement node) {
            return this.mDone || super.visitElement(node);
        }

        public boolean visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isMethodCall((UElement)node)) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitMethodCallExpression(UCallExpression node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if ((name = node.getMethodName()) != null && (name.startsWith("check") || name.startsWith("enforce")) && name.endsWith("Permission")) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
        }

        public boolean checksPermission() {
            return this.mChecksPermission;
        }
    }
}

