/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public class GetSignaturesDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"PackageManagerGetSignatures", (String)"Potential Multiple Certificate Exploit", (String)"Improper validation of app signatures could lead to issues where a malicious app submits itself to the Play Store with both its real certificate and a fake certificate and gains access to functionality or information it shouldn't have due to another application only checking for the fake certificate and ignoring the rest. Please make sure to validate all signatures returned by this method.", (Category)Category.SECURITY, (int)8, (Severity)Severity.WARNING, (Implementation)new Implementation(GetSignaturesDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://bluebox.com/technical/android-fake-id-vulnerability/");
    private static final String PACKAGE_MANAGER_CLASS = "android.content.pm.PackageManager";
    private static final String GET_PACKAGE_INFO = "getPackageInfo";
    private static final int GET_SIGNATURES_FLAG = 64;

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_PACKAGE_INFO);
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        UExpression second;
        Object number;
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.methodMatches(method, PACKAGE_MANAGER_CLASS, true, new String[]{"java.lang.String", "int"})) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() == 2 && (number = ConstantEvaluator.evaluate((JavaContext)context, (UElement)(second = (UExpression)arguments.get(1)))) instanceof Number) {
            int flagValue = ((Number)number).intValue();
            GetSignaturesDetector.maybeReportIssue(flagValue, context, node, second);
        }
    }

    private static void maybeReportIssue(int flagValue, JavaContext context, UCallExpression node, UExpression last) {
        if ((flagValue & 0x40) != 0) {
            context.report(ISSUE, (UElement)node, context.getLocation((UElement)last), "Reading app signatures from getPackageInfo: The app signatures could be exploited if not validated properly; see issue explanation for details.");
        }
    }
}

