/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.repository.Revision;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.VersionChecks;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApiDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
ResourceFolderScanner {
    public static final String REQUIRES_API_ANNOTATION = "android.support.annotation.RequiresApi";
    public static final String SDK_SUPPRESS_ANNOTATION = "android.support.test.filters.SdkSuppress";
    public static final Issue UNSUPPORTED = Issue.create((String)"NewApi", (String)"Calling new methods on older versions", (String)"This check scans through all the Android API calls in the application and warns about any calls that are not available on **all** versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\n\nIf your code is **deliberately** accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n\nIf you are deliberately setting `android:` attributes in style definitions, make sure you place this in a `values-v`*NN* folder in order to avoid running into runtime conflicts on certain devices where manufacturers have added custom attributes whose ids conflict with the new ones on later platforms.\n\nSimilarly, you can use tools:targetApi=\"11\" in an XML file to indicate that the element will only be inflated in an adequate context.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(ApiDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.RESOURCE_FILE, Scope.MANIFEST), new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE}));
    public static final Issue INLINED = Issue.create((String)"InlinedApi", (String)"Using inlined constants on older versions", (String)"This check scans through all the Android API field references in the application and flags certain constants, such as static final integers and Strings, which were introduced in later versions. These will actually be copied into the class files rather than being referenced, which means that the value is available even when running on older devices. In some cases that's fine, and in other cases it can result in a runtime crash or incorrect behavior. It depends on the context, so consider the code carefully and decide whether it's safe and can be suppressed or whether the code needs to be guarded.\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\nIf your code is **deliberately** accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue OVERRIDE = Issue.create((String)"Override", (String)"Method conflicts with new inherited method", (String)"Suppose you are building against Android API 8, and you've subclassed Activity. In your subclass you add a new method called `isDestroyed`(). At some later point, a method of the same name and signature is added to Android. Your method will now override the Android method, and possibly break its contract. Your method is not calling `super.isDestroyed()`, since your compilation target doesn't know about the method.\n\nThe above scenario is what this lint detector looks for. The above example is real, since `isDestroyed()` was added in API 17, but it will be true for **any** method you have added to a subclass of an Android class where your build target is lower than the version the method was introduced in.\n\nTo fix this, either rename your method, or if you are really trying to augment the builtin method if available, switch to a higher build target where you can deliberately add `@Override` on your overriding method, and call `super` if appropriate etc.\n", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue UNUSED = Issue.create((String)"UnusedAttribute", (String)"Attribute unused on older versions", (String)"This check finds attributes set in XML files that were introduced in a version newer than the oldest version targeted by your application (with the `minSdkVersion` attribute).\n\nThis is not an error; the application will simply ignore the attribute. However, if the attribute is important to the appearance or functionality of your application, you should consider finding an alternative way to achieve the same result with only available attributes, and then you can optionally create a copy of the layout in a layout-vNN folder which will be used on API NN or higher where you can take advantage of the newer attribute.\n\nNote: This check does not only apply to attributes. For example, some tags can be unused too, such as the new `<tag>` element in layouts introduced in API 21.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ApiDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.RESOURCE_FOLDER), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.RESOURCE_FOLDER_SCOPE}));
    public static final Issue OBSOLETE_SDK = Issue.create((String)"ObsoleteSdkInt", (String)"Obsolete SDK_INT Version Check", (String)"This check flags version checks that are not necessary, because the `minSdkVersion` (or surrounding known API level) is already at least as high as the version checked for.\n\nSimilarly, it also looks for resources in `-vNN` folders, such as `values-v14` where the version qualifier is less than or equal to the `minSdkVersion`, where the contents should be merged into the best folder.", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String TAG_RIPPLE = "ripple";
    private static final String TAG_VECTOR = "vector";
    private static final String TAG_ANIMATED_VECTOR = "animated-vector";
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    protected ApiLookup mApiDatabase;
    private boolean mWarnedMissingDb;
    private int mMinApi = -1;
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";

    public void beforeCheckProject(Context context) {
        if (this.mApiDatabase == null) {
            this.mApiDatabase = ApiLookup.get(context.getClient(), context.getMainProject().getBuildTarget());
            if (this.mApiDatabase == null && !this.mWarnedMissingDb) {
                this.mWarnedMissingDb = true;
                context.report(IssueRegistry.LINT_ERROR, Location.create((File)context.file), "Can't find API database; API check not performed");
            }
        }
    }

    public boolean appliesTo(ResourceFolderType folderType) {
        return true;
    }

    public Collection<String> getApplicableElements() {
        return ALL;
    }

    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        int api;
        int minSdk;
        String prefix;
        String message;
        Location location;
        String owner;
        if (this.mApiDatabase == null) {
            return;
        }
        int attributeApiLevel = -1;
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            int minSdk2;
            int minSdk3;
            String name = attribute.getLocalName();
            if (!(name.equals("layout_width") || name.equals("layout_height") || ApiDetector.isSupportedByAppcompat(name, context) || name.equals("id") || (attributeApiLevel = this.mApiDatabase.getFieldVersion(owner = "android/R$attr", name)) <= (minSdk3 = this.getMinSdk((Context)context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(attribute.getOwnerElement()) || ApiDetector.isBenignUnusedAttribute(name) || ApiDetector.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel))) {
                if (RtlDetector.isRtlAttributeName(name) || "supportsRtl".equals(name)) {
                    if (name.equals("paddingStart")) {
                        boolean isOldBuildTools;
                        BuildToolInfo buildToolInfo = context.getProject().getBuildTools();
                        Revision buildTools = buildToolInfo != null ? buildToolInfo.getRevision() : null;
                        boolean bl = isOldBuildTools = buildTools != null && (buildTools.getMajor() < 23 || buildTools.getMajor() == 23 && buildTools.getMinor() == 0 && buildTools.getMicro() == 0);
                        if ((buildTools == null || isOldBuildTools) && ApiDetector.viewMayExtendTextView(attribute.getOwnerElement())) {
                            location = context.getLocation((Node)attribute);
                            message = String.format("Attribute `%1$s` referenced here can result in a crash on some specific devices older than API %2$d (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk3);
                            if (buildTools != null) {
                                message = String.format("Upgrade `buildToolsVersion` from `%1$s` to at least `23.0.1`; if not, ", buildTools.toShortString()) + Character.toLowerCase(message.charAt(0)) + message.substring(1);
                            }
                            context.report(UNSUPPORTED, (Node)attribute, location, message, ApiDetector.apiLevelFix(attributeApiLevel));
                        }
                    }
                } else {
                    Project mainProject;
                    Boolean appCompat;
                    Location location2 = context.getLocation((Node)attribute);
                    String localName = attribute.getLocalName();
                    String message2 = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", localName, attributeApiLevel, minSdk3);
                    if ("fontFamily".equals(localName) && (appCompat = (mainProject = context.getMainProject()).dependsOn("com.android.support:appcompat-v7")) != null && appCompat.booleanValue()) {
                        String prefix2 = XmlUtils.lookupNamespacePrefix((Node)attribute, (String)"http://schemas.android.com/apk/res-auto", (String)"app", (boolean)false);
                        message2 = message2 + " Did you mean `" + prefix2 + ":fontFamily` ?";
                    }
                    context.report(UNUSED, (Node)attribute, location2, message2, ApiDetector.apiLevelFix(attributeApiLevel));
                }
            }
            if (name.equals("divider")) {
                return;
            }
            if (name.equals("theme") && "include".equals(attribute.getOwnerElement().getTagName()) && Math.max(minSdk2 = this.getMinSdk((Context)context), context.getFolderVersion()) < 23) {
                Location location3 = context.getLocation((Node)attribute);
                String message3 = String.format("Attribute `android:theme` is only used by `<include>` tags in API level 23 and higher (current min is %1$d)", minSdk2);
                context.report(UNUSED, (Node)attribute, location3, message3, ApiDetector.apiLevelFix(23));
            }
        }
        String value = attribute.getValue();
        owner = null;
        String name = null;
        if (value.startsWith("@android:")) {
            prefix = "@android:";
        } else if (value.startsWith("?android:")) {
            int api2;
            prefix = "?android:";
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && (api2 = 21) > (minSdk = this.getMinSdk((Context)context)) && api2 > context.getFolderVersion() && api2 > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
                location = context.getLocation((Node)attribute);
                message = String.format("Using theme references in XML drawables requires API level %1$d (current min is %2$d)", api2, minSdk);
                context.report(UNSUPPORTED, (Node)attribute, location, message, ApiDetector.apiLevelFix(api2));
                return;
            }
        } else if (value.startsWith("android:") && "name".equals(attribute.getName()) && "item".equals(attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && "style".equals(attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            name = value.substring("android:".length());
            prefix = null;
        } else if (value.startsWith("android:") && "parent".equals(attribute.getName()) && "style".equals(attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            name = SdkUtils.getResourceFieldName((String)value.substring("android:".length()));
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            int index = value.indexOf(47, prefix.length());
            if (index >= 0) {
                owner = "android/R$" + value.substring(prefix.length(), index);
                name = SdkUtils.getResourceFieldName((String)value.substring(index + 1));
            } else if (value.startsWith("?android:")) {
                owner = "android/R$attr";
                name = value.substring("?android:".length());
            } else {
                return;
            }
        }
        if ((api = this.mApiDatabase.getFieldVersion(owner, name)) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
            if ("http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                return;
            }
            if (attributeApiLevel < api) {
                if (attributeApiLevel > minSdk) {
                    String attributeName = attribute.getLocalName();
                    Location location4 = context.getLocation((Node)attribute);
                    String message4 = String.format("`%1$s` requires API level %2$d (current min is %3$d), but note that attribute `%4$s` is only used in API level %5$d and higher", name, api, minSdk, attributeName, attributeApiLevel);
                    context.report(UNSUPPORTED, (Node)attribute, location4, message4, ApiDetector.apiLevelFix(api));
                } else {
                    location = context.getLocation((Node)attribute);
                    message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", value, api, minSdk);
                    context.report(UNSUPPORTED, (Node)attribute, location, message, ApiDetector.apiLevelFix(api));
                }
            }
        }
    }

    private static boolean isSupportedByAppcompat(String name, XmlContext context) {
        return name.equals("fillType") && Boolean.TRUE.equals(context.getProject().dependsOn("com.android.support:appcompat-v7"));
    }

    private static LintFix apiLevelFix(int api) {
        return LintFix.create().data(new Object[]{api});
    }

    private static boolean viewMayExtendTextView(Element element) {
        String tag = element.getTagName();
        if (tag.equals("view") && ((tag = element.getAttribute("class")) == null || tag.isEmpty())) {
            return false;
        }
        if (tag.indexOf(46) != -1) {
            return true;
        }
        return tag.contains("Text") || tag.contains("Button") || tag.equals("DigitalClock") || tag.equals("Chronometer") || tag.equals("CheckBox") || tag.equals("Switch");
    }

    private static boolean isAlreadyWarnedDrawableFile(XmlContext context, Attr attribute, int attributeApiLevel) {
        String root;
        return context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel == 21 && (TAG_RIPPLE.equals(root = attribute.getOwnerDocument().getDocumentElement().getTagName()) || TAG_VECTOR.equals(root) || TAG_ANIMATED_VECTOR.equals(root) || TAG_ANIMATED_SELECTOR.equals(root));
    }

    public static boolean isBenignUnusedAttribute(String name) {
        return "labelFor".equals(name) || "textIsSelectable".equals(name) || "textAlignment".equals(name) || "roundIcon".equals(name) || "fullBackupContent".equals(name);
    }

    public void visitElement(XmlContext context, Element element) {
        if (this.mApiDatabase == null) {
            return;
        }
        String tag = element.getTagName();
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, TAG_VECTOR, 21, "1.4", UNSUPPORTED);
                this.checkElement(context, element, TAG_RIPPLE, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_VECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, "drawable", 24, null, UNSUPPORTED);
                if ("layer-list".equals(tag)) {
                    this.checkLevelList(context, element);
                } else if (tag.contains(".")) {
                    this.checkElement(context, element, tag, 24, null, UNSUPPORTED);
                }
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                int minSdk;
                String name;
                String owner;
                int api;
                String typeString;
                int index;
                String text;
                Node textNode = childNodes.item(i);
                if (textNode.getNodeType() != 3 || !(text = textNode.getNodeValue()).contains("@android:") || (index = (text = text.trim()).indexOf(47, "@android:".length())) == -1 || ResourceType.getEnum((String)(typeString = text.substring("@android:".length(), index))) == null || (api = this.mApiDatabase.getFieldVersion(owner = "android/R$" + typeString, name = SdkUtils.getResourceFieldName((String)text.substring(index + 1)))) <= (minSdk = this.getMinSdk((Context)context)) || api <= context.getFolderVersion() || api <= ApiDetector.getLocalMinSdk(element)) continue;
                Location location = context.getLocation(textNode);
                String message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", text, api, minSdk);
                context.report(UNSUPPORTED, (Node)element, location, message, ApiDetector.apiLevelFix(api));
            }
        } else {
            int minSdk;
            int api;
            if ("view".equals(tag)) {
                tag = element.getAttribute("class");
                if (tag == null || tag.isEmpty()) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", 21, null, UNUSED);
            }
            if (tag.indexOf(46) != -1) {
                return;
            }
            String fqn = "android/widget/" + tag;
            if (tag.equals("TextureView")) {
                fqn = "android/view/TextureView";
            }
            if ((api = this.mApiDatabase.getClassVersion(fqn)) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element)) {
                Location location = context.getLocation((Node)element);
                String message = String.format("View requires API level %1$d (current min is %2$d): `<%3$s>`", api, minSdk, tag);
                context.report(UNSUPPORTED, (Node)element, location, message, ApiDetector.apiLevelFix(api));
            }
        }
    }

    private void checkLevelList(XmlContext context, Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            int minSdk;
            int attributeApiLevel;
            Element e;
            if (curr.getNodeType() != 1 || !"item".equals(curr.getNodeName()) || !(e = (Element)curr).hasAttributeNS("http://schemas.android.com/apk/res/android", "width") && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", "height") || (attributeApiLevel = 23) <= (minSdk = this.getMinSdk((Context)context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(element)) continue;
            for (String attributeName : new String[]{"width", "height"}) {
                Attr attribute = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                if (attribute == null) continue;
                Location location = context.getLocation((Node)attribute);
                String message = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk);
                context.report(UNUSED, (Node)attribute, location, message, ApiDetector.apiLevelFix(attributeApiLevel));
            }
        }
    }

    private void checkElement(XmlContext context, Element element, String tag, int api, String gradleVersion, Issue issue) {
        int minSdk;
        if (tag.equals(element.getTagName()) && api > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element) && !ApiDetector.featureProvidedByGradle(context, gradleVersion)) {
            String message;
            Location location = context.getLocation((Node)element);
            if ("drawable".equals(tag)) {
                Attr attribute = element.getAttributeNode("class");
                if (attribute == null) {
                    return;
                }
                location = context.getLocation((Node)attribute);
                tag = "class";
            }
            if (issue == UNSUPPORTED) {
                message = String.format("`<%1$s>` requires API level %2$d (current min is %3$d)", tag, api, minSdk);
                if (gradleVersion != null) {
                    message = message + String.format(" or building with Android Gradle plugin %1$s or higher", gradleVersion);
                } else if (tag.contains(".")) {
                    message = String.format("Custom drawables requires API level %1$d (current min is %2$d)", api, minSdk);
                }
            } else {
                assert (issue == UNUSED) : issue;
                message = String.format("`<%1$s>` is only used in API level %2$d and higher (current min is %3$d)", tag, api, minSdk);
            }
            context.report(issue, (Node)element, location, message, ApiDetector.apiLevelFix(api));
        }
    }

    protected int getMinSdk(Context context) {
        if (this.mMinApi == -1) {
            AndroidVersion minSdkVersion = context.getMainProject().getMinSdkVersion();
            this.mMinApi = minSdkVersion.getFeatureLevel();
            if (this.mMinApi == 1 && !context.getMainProject().isAndroidProject()) {
                this.mMinApi = Integer.MAX_VALUE;
            }
        }
        return this.mMinApi;
    }

    private static void checkSimpleDateFormat(JavaContext context, UCallExpression call, int minSdk) {
        if (minSdk >= 9) {
            return;
        }
        List expressions = call.getValueArguments();
        if (expressions.isEmpty()) {
            return;
        }
        UExpression argument = (UExpression)expressions.get(0);
        Object constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (constant instanceof String) {
            String pattern = (String)constant;
            boolean isEscaped = false;
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '\'') {
                    isEscaped = !isEscaped;
                    continue;
                }
                if (isEscaped || c != 'L' && c != 'c') continue;
                String message = String.format("The pattern character '%1$c' requires API level 9 (current min is %2$d) : \"`%3$s`\"", Character.valueOf(c), minSdk, pattern);
                context.report(UNSUPPORTED, (UElement)call, context.getRangeLocation((UElement)argument, i + 1, 1), message, ApiDetector.apiLevelFix(9));
                return;
            }
        }
    }

    private static int getLocalMinSdk(Element element) {
        while (element != null) {
            String targetApi = element.getAttributeNS("http://schemas.android.com/tools", "targetApi");
            if (targetApi != null && !targetApi.isEmpty()) {
                if (Character.isDigit(targetApi.charAt(0))) {
                    try {
                        return Integer.parseInt(targetApi);
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                return SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
            }
            Node parent = element.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            element = (Element)parent;
        }
        return -1;
    }

    private static boolean featureProvidedByGradle(XmlContext context, String minGradleVersionString) {
        GradleVersion minVersion;
        if (minGradleVersionString == null) {
            return false;
        }
        GradleVersion gradleModelVersion = context.getProject().getGradleModelVersion();
        return gradleModelVersion != null && (minVersion = GradleVersion.tryParse((String)minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
    }

    public UElementHandler createUastHandler(JavaContext context) {
        if (this.mApiDatabase == null || context.isTestSource()) {
            return null;
        }
        if (!context.getMainProject().isAndroidProject()) {
            return null;
        }
        return new ApiVisitor(context);
    }

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(14);
        types.add(UImportStatement.class);
        types.add(USimpleNameReferenceExpression.class);
        types.add(ULocalVariable.class);
        types.add(UTryExpression.class);
        types.add(UBinaryExpressionWithType.class);
        types.add(UBinaryExpression.class);
        types.add(UCallExpression.class);
        types.add(UClass.class);
        types.add(UMethod.class);
        types.add(UForEachExpression.class);
        types.add(UClassLiteralExpression.class);
        types.add(USwitchExpression.class);
        types.add(UCallableReferenceExpression.class);
        return types;
    }

    public static boolean isBenignConstantUsage(UElement node, String name, String owner) {
        if (ApiLookup.equivalentName(owner, "android/os/Build$VERSION_CODES")) {
            return true;
        }
        if (ApiLookup.equivalentName(owner, "android/view/ViewGroup$LayoutParams") && name.equals("MATCH_PARENT")) {
            return true;
        }
        if (ApiLookup.equivalentName(owner, "android/widget/AbsListView") && (name.equals("CHOICE_MODE_NONE") || name.equals("CHOICE_MODE_MULTIPLE") || name.equals("CHOICE_MODE_SINGLE"))) {
            return true;
        }
        if (ApiLookup.equivalentName(owner, "android/view/Gravity") && ("START".equals(name) || "END".equals(name))) {
            return true;
        }
        if (node == null) {
            return false;
        }
        for (UElement curr = node.getUastParent(); curr != null; curr = curr.getUastParent()) {
            if (curr instanceof USwitchClauseExpression) {
                List caseValues = ((USwitchClauseExpression)curr).getCaseValues();
                for (UExpression condition : caseValues) {
                    if (condition == null || !UastUtils.isChildOf((UElement)node, (UElement)condition, (boolean)false)) continue;
                    return true;
                }
                return false;
            }
            if (curr instanceof UIfExpression) {
                UExpression condition = ((UIfExpression)curr).getCondition();
                return UastUtils.isChildOf((UElement)node, (UElement)condition, (boolean)false);
            }
            if (curr instanceof UMethod || curr instanceof UClass) break;
        }
        return false;
    }

    private static List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass) {
        if (derivedClass.equals((Object)baseClass)) {
            return Collections.emptyList();
        }
        List<PsiClassType> chain = ApiDetector.getInheritanceChain(derivedClass, baseClass, new HashSet<PsiType>(), 0);
        if (chain != null) {
            Collections.reverse(chain);
        }
        return chain;
    }

    private static List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass, HashSet<PsiType> visited, int depth) {
        if (derivedClass.equals((Object)baseClass)) {
            return new ArrayList<PsiClassType>(depth);
        }
        ++depth;
        for (PsiType type : derivedClass.getSuperTypes()) {
            PsiClassType classType;
            List<PsiClassType> chain;
            if (!visited.add(type) || !(type instanceof PsiClassType) || (chain = ApiDetector.getInheritanceChain(classType = (PsiClassType)type, baseClass, visited, depth)) == null) continue;
            chain.add(derivedClass);
            return chain;
        }
        return null;
    }

    private static boolean isSuppressed(JavaContext context, int api, UElement element, int minSdk) {
        if (api <= minSdk) {
            return true;
        }
        int target = ApiDetector.getTargetApi(element);
        if (target != -1 && api <= target) {
            return true;
        }
        LintDriver driver = context.getDriver();
        return driver.isSuppressed(context, UNSUPPORTED, element) || driver.isSuppressed(context, INLINED, element) || VersionChecks.isWithinVersionCheckConditional(context.getEvaluator(), element, api) || VersionChecks.isPrecededByVersionCheckExit(element, api);
    }

    private static boolean isUsingDesugar(Context context, UElement element) {
        GradleVersion version = context.getProject().getGradleModelVersion();
        if (version == null) {
            return true;
        }
        if (!version.isAtLeast(2, 4, 0, "alpha", 8, true)) {
            return false;
        }
        return LintUtils.getLanguageLevel((UElement)element, (LanguageLevel)LanguageLevel.JDK_1_7).isAtLeast(LanguageLevel.JDK_1_8);
    }

    public static int getTargetApi(UElement scope) {
        while (scope != null) {
            PsiModifierList modifierList;
            int targetApi;
            if (scope instanceof PsiModifierListOwner && (targetApi = ApiDetector.getTargetApi(modifierList = ((PsiModifierListOwner)scope).getModifierList())) != -1) {
                return targetApi;
            }
            if (!((scope = scope.getUastParent()) instanceof PsiFile)) continue;
            break;
        }
        return -1;
    }

    public static int getTargetApi(PsiModifierList modifierList) {
        if (modifierList == null) {
            return -1;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            String fqcn = annotation.getQualifiedName();
            if (fqcn == null || !fqcn.equals("android.annotation.TargetApi") && !fqcn.equals(REQUIRES_API_ANNOTATION) && !fqcn.equals(SDK_SUPPRESS_ANNOTATION) && !fqcn.equals("TargetApi")) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair pair : parameterList.getAttributes()) {
                PsiAnnotationMemberValue v = pair.getValue();
                if (v instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)v;
                    Object value = literal.getValue();
                    if (value instanceof Integer) {
                        return (Integer)value;
                    }
                    if (!(value instanceof String)) continue;
                    return VersionChecks.codeNameToApi((String)value);
                }
                if (v instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                    for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                        if (!(mmv instanceof PsiLiteral)) continue;
                        PsiLiteral literal = (PsiLiteral)mmv;
                        Object value = literal.getValue();
                        if (value instanceof Integer) {
                            return (Integer)value;
                        }
                        if (!(value instanceof String)) continue;
                        return VersionChecks.codeNameToApi((String)value);
                    }
                    continue;
                }
                if (!(v instanceof PsiExpression)) continue;
                if (v instanceof PsiReferenceExpression) {
                    String name = ((PsiReferenceExpression)v).getQualifiedName();
                    return VersionChecks.codeNameToApi(name);
                }
                return VersionChecks.codeNameToApi(v.getText());
            }
        }
        return -1;
    }

    protected void checkObsoleteSdkVersion(JavaContext context, UElement node) {
        int minSdk;
        Boolean isConditional;
        UBinaryExpression binary = (UBinaryExpression)UastUtils.getParentOfType((UElement)node, UBinaryExpression.class, (boolean)true);
        if (binary != null && (isConditional = VersionChecks.isVersionCheckConditional(minSdk = this.getMinSdk((Context)context), binary)) != null) {
            String message = (isConditional != false ? "Unnecessary; SDK_INT is always >= " : "Unnecessary; SDK_INT is never < ") + minSdk;
            context.report(OBSOLETE_SDK, (UElement)binary, context.getLocation((UElement)binary), message, this.fix().data(new Object[]{isConditional}));
        }
    }

    public void checkFolder(ResourceContext context, String folderName) {
        int folderVersion = context.getFolderVersion();
        AndroidVersion minSdkVersion = context.getMainProject().getMinSdkVersion();
        if (folderVersion > 1 && folderVersion <= minSdkVersion.getFeatureLevel()) {
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
            assert (folderConfig != null) : context.file;
            folderConfig.setVersionQualifier(null);
            ResourceFolderType resourceFolderType = context.getResourceFolderType();
            assert (resourceFolderType != null) : context.file;
            String newFolderName = folderConfig.getFolderName(resourceFolderType);
            context.report(OBSOLETE_SDK, Location.create((File)context.file), String.format("This folder configuration (`v%1$d`) is unnecessary; `minSdkVersion` is %2$s. Merge all the resources in this folder into `%3$s`.", folderVersion, minSdkVersion.getApiString(), newFolderName), this.fix().data(new Object[]{context.file, newFolderName, minSdkVersion}));
        }
    }

    public static Location getCatchParametersLocation(JavaContext context, UCatchClause catchClause) {
        List types = catchClause.getTypeReferences();
        if (types.isEmpty()) {
            return Location.NONE;
        }
        Location first = context.getLocation((UElement)types.get(0));
        if (types.size() < 2) {
            return first;
        }
        Location last = context.getLocation((UElement)types.get(types.size() - 1));
        File file = first.getFile();
        Position start = first.getStart();
        Position end = last.getEnd();
        if (start == null) {
            return Location.create((File)file);
        }
        return Location.create((File)file, (Position)start, (Position)end);
    }

    public static boolean isMultiCatchReflectiveOperationException(UCatchClause catchClause) {
        List types = catchClause.getTypes();
        if (types.size() < 2) {
            return false;
        }
        for (PsiType t : types) {
            if (ApiDetector.isSubclassOfReflectiveOperationException(t)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSubclassOfReflectiveOperationException(PsiType type) {
        for (PsiType t : type.getSuperTypes()) {
            if (!REFLECTIVE_OPERATION_EXCEPTION.equals(t.getCanonicalText())) continue;
            return true;
        }
        return false;
    }

    private final class ApiVisitor
    extends UElementHandler {
        private final JavaContext mContext;

        private ApiVisitor(JavaContext context) {
            this.mContext = context;
        }

        public void visitImportStatement(UImportStatement statement) {
            PsiElement resolved;
            if (!statement.isOnDemand() && (resolved = statement.resolve()) instanceof PsiField) {
                this.checkField((UElement)statement, (PsiField)resolved);
            }
        }

        public void visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiField) {
                this.checkField((UElement)node, (PsiField)resolved);
            } else if (resolved instanceof PsiMethod && node instanceof UCallExpression) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        public void visitCallableReferenceExpression(UCallableReferenceExpression node) {
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiMethod) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        private void checkMethodReference(UReferenceExpression expression, PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            String owner = evaluator.getQualifiedName(containingClass);
            if (owner == null) {
                return;
            }
            if (!ApiDetector.this.mApiDatabase.containsClass(owner)) {
                return;
            }
            String name = LintUtils.getInternalMethodName((PsiMethod)method);
            String desc = evaluator.getMethodDescription(method, false, false);
            if (desc == null) {
                return;
            }
            int api = ApiDetector.this.mApiDatabase.getMethodVersion(owner, name, desc);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
            if (ApiDetector.isSuppressed(this.mContext, api, (UElement)expression, minSdk)) {
                return;
            }
            String signature = expression.asSourceString();
            Location location = this.mContext.getLocation((UElement)expression);
            String message = String.format("Method reference requires API level %1$d (current min is %2$d): %3$s", api, Math.max(minSdk, ApiDetector.getTargetApi((UElement)expression)), signature);
            this.mContext.report(UNSUPPORTED, (UElement)expression, location, message, ApiDetector.apiLevelFix(api));
        }

        public void visitBinaryExpressionWithType(UBinaryExpressionWithType node) {
            PsiType type;
            UTypeReferenceExpression typeReference;
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                this.visitTypeCastExpression(node);
            } else if (UastExpressionUtils.isInstanceCheck((UElement)node) && (typeReference = node.getTypeReference()) != null && (type = typeReference.getType()) instanceof PsiClassType) {
                this.checkClassReference((UElement)typeReference, (PsiClassType)type);
            }
        }

        private void visitTypeCastExpression(UBinaryExpressionWithType expression) {
            UExpression operand = expression.getOperand();
            PsiType operandType = operand.getExpressionType();
            PsiType castType = expression.getType();
            if (castType.equals(operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)operandType;
            PsiClassType interfaceType = (PsiClassType)castType;
            UTypeReferenceExpression typeReference = expression.getTypeReference();
            if (typeReference != null && !this.checkClassReference((UElement)typeReference, interfaceType)) {
                return;
            }
            this.checkCast((UElement)expression, classType, interfaceType);
        }

        private boolean checkClassReference(UElement node, PsiClassType classType) {
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            String expressionOwner = evaluator.getQualifiedName(classType);
            if (expressionOwner == null) {
                return true;
            }
            int api = ApiDetector.this.mApiDatabase.getClassVersion(expressionOwner);
            if (api == -1) {
                return true;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
            if (ApiDetector.isSuppressed(this.mContext, api, node, minSdk)) {
                return true;
            }
            String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, Math.max(minSdk, ApiDetector.getTargetApi(node)), expressionOwner);
            Location location = this.mContext.getLocation(node);
            this.mContext.report(UNSUPPORTED, node, location, message, ApiDetector.apiLevelFix(api));
            return false;
        }

        private void checkCast(UElement node, PsiClassType classType, PsiClassType interfaceType) {
            if (classType.equals((Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            String classTypeInternal = evaluator.getQualifiedName(classType);
            String interfaceTypeInternal = evaluator.getQualifiedName(interfaceType);
            if (interfaceTypeInternal == null || classTypeInternal == null) {
                return;
            }
            if (ApiLookup.equivalentName(interfaceTypeInternal, "java/lang/Object")) {
                return;
            }
            int api = ApiDetector.this.mApiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
            if (api <= minSdk) {
                return;
            }
            if (ApiDetector.isSuppressed(this.mContext, api, node, minSdk)) {
                return;
            }
            Location location = this.mContext.getLocation(node);
            String to = interfaceType.getClassName();
            String from = classType.getClassName();
            int min = Math.max(minSdk, ApiDetector.getTargetApi(node));
            String message = interfaceTypeInternal.equals(classTypeInternal) ? String.format("Cast to %1$s requires API level %2$d (current min is %3$d)", to, api, min) : String.format("Cast from %1$s to %2$s requires API level %3$d (current min is %4$d)", from, to, api, min);
            this.mContext.report(UNSUPPORTED, node, location, message, ApiDetector.apiLevelFix(api));
        }

        public void visitMethod(UMethod method) {
            String fqcn;
            PsiClass cls;
            int minSdk;
            int api;
            PsiModifierList methodModifierList;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !ApiDetector.isUsingDesugar((Context)this.mContext, (UElement)method) && ((methodModifierList = method.getModifierList()).hasExplicitModifier("default") || methodModifierList.hasExplicitModifier("static")) && !ApiDetector.isSuppressed(this.mContext, api = 24, (UElement)method, minSdk = ApiDetector.this.getMinSdk((Context)this.mContext))) {
                Location location = this.mContext.getLocation(method);
                String message = String.format("%1$s method requires API level %2$d (current min is %3$d)", methodModifierList.hasExplicitModifier("default") ? "Default" : "Static interface", api, Math.max(minSdk, ApiDetector.getTargetApi((UElement)method)));
                this.mContext.report(UNSUPPORTED, method, location, message, ApiDetector.apiLevelFix(api));
            }
            int buildSdk = this.mContext.getMainProject().getBuildSdk();
            String name = method.getName();
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiMethod superMethod = evaluator.getSuperMethod((PsiMethod)method);
            while (superMethod != null && (cls = superMethod.getContainingClass()) != null && (fqcn = cls.getQualifiedName()) != null && (fqcn.startsWith("android.") || fqcn.startsWith("java.") && !fqcn.equals("java.lang.Object") || fqcn.startsWith("javax."))) {
                String desc = evaluator.getMethodDescription(superMethod, false, false);
                if (desc != null) {
                    String owner = evaluator.getQualifiedName(cls);
                    if (owner == null) {
                        return;
                    }
                    int api2 = ApiDetector.this.mApiDatabase.getMethodVersion(owner, name, desc);
                    if (api2 > buildSdk && buildSdk != -1) {
                        if (this.mContext.getDriver().isSuppressed(this.mContext, OVERRIDE, (UElement)method)) {
                            return;
                        }
                        if (containingClass != null) {
                            String className = containingClass.getName();
                            String fullClassName = containingClass.getQualifiedName();
                            if (fullClassName != null) {
                                className = fullClassName;
                            }
                            fqcn = className + '#' + name;
                        } else {
                            fqcn = name;
                        }
                        String message = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): %3$s", api2, buildSdk, fqcn);
                        PsiIdentifier locationNode = method.getNameIdentifier();
                        if (locationNode == null) {
                            locationNode = method;
                        }
                        Location location = this.mContext.getLocation((PsiElement)locationNode);
                        this.mContext.report(OVERRIDE, method, location, message);
                    }
                }
                superMethod = evaluator.getSuperMethod(superMethod);
            }
        }

        public void visitClass(UClass aClass) {
            PsiModifierList modifierList;
            if (aClass.isAnnotationType() && !ApiDetector.isUsingDesugar((Context)this.mContext, (UElement)aClass) && (modifierList = aClass.getModifierList()) != null) {
                for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                    PsiNameValuePair[] attributes;
                    String name = annotation.getQualifiedName();
                    if ("java.lang.annotation.Repeatable".equals(name)) {
                        int api = 24;
                        int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
                        if (ApiDetector.isSuppressed(this.mContext, api, (UElement)aClass, minSdk)) continue;
                        Location location = this.mContext.getLocation((PsiElement)annotation);
                        String message = String.format("Repeatable annotation requires API level %1$d (current min is %2$d)", api, Math.max(minSdk, ApiDetector.getTargetApi((UElement)aClass)));
                        this.mContext.report(UNSUPPORTED, (PsiElement)annotation, location, message, ApiDetector.apiLevelFix(api));
                        continue;
                    }
                    if (!"java.lang.annotation.Target".equals(name)) continue;
                    for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                        PsiAnnotationMemberValue value = pair.getValue();
                        if (value instanceof PsiArrayInitializerMemberValue) {
                            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value;
                            for (PsiAnnotationMemberValue t : array.getInitializers()) {
                                this.checkAnnotationTarget(t, modifierList);
                            }
                            continue;
                        }
                        if (value == null) continue;
                        this.checkAnnotationTarget(value, modifierList);
                    }
                }
            }
            for (UTypeReferenceExpression typeReferenceExpression : aClass.getUastSuperTypes()) {
                PsiClassType classType;
                PsiClass cls;
                PsiType type = typeReferenceExpression.getType();
                if (!(type instanceof PsiClassType) || (cls = (classType = (PsiClassType)type).resolve()) == null) continue;
                this.checkClass((UElement)typeReferenceExpression, cls);
            }
        }

        public void visitClassLiteralExpression(UClassLiteralExpression expression) {
            PsiType type;
            UExpression element = expression.getExpression();
            if (element instanceof UTypeReferenceExpression && (type = ((UTypeReferenceExpression)element).getType()) instanceof PsiClassType) {
                this.checkClassType((UElement)element, (PsiClassType)type, null);
            }
        }

        private void checkClassType(UElement element, PsiClassType classType, String descriptor) {
            String owner = this.mContext.getEvaluator().getQualifiedName(classType);
            String fqcn = classType.getCanonicalText();
            if (owner != null) {
                this.checkClass(element, descriptor, owner, fqcn);
            }
        }

        private void checkClass(UElement element, PsiClass cls) {
            String owner = this.mContext.getEvaluator().getQualifiedName(cls);
            if (owner == null) {
                return;
            }
            String fqcn = cls.getQualifiedName();
            if (fqcn != null) {
                this.checkClass(element, null, owner, fqcn);
            }
        }

        private void checkClass(UElement element, String descriptor, String owner, String fqcn) {
            int api = ApiDetector.this.mApiDatabase.getClassVersion(owner);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
            if (ApiDetector.isSuppressed(this.mContext, api, element, minSdk)) {
                return;
            }
            if (UastUtils.getParentOfType((UElement)element, UAnnotation.class) != null) {
                return;
            }
            Location location = this.mContext.getNameLocation(element);
            minSdk = Math.max(minSdk, ApiDetector.getTargetApi(element));
            String message = String.format("%1$s requires API level %2$d (current min is %3$d): %4$s", descriptor == null ? "Class" : descriptor, api, Math.max(minSdk, ApiDetector.getTargetApi(element)), fqcn);
            this.mContext.report(UNSUPPORTED, element, location, message, ApiDetector.apiLevelFix(api));
        }

        private void checkAnnotationTarget(PsiAnnotationMemberValue element, PsiModifierList modifierList) {
            PsiAnnotation retention;
            UReferenceExpression ref;
            String referenceName;
            if (element instanceof UReferenceExpression && ("TYPE_PARAMETER".equals(referenceName = UastLintUtils.getReferenceName((UReferenceExpression)(ref = (UReferenceExpression)element))) || "TYPE_USE".equals(referenceName)) && ((retention = modifierList.findAnnotation("java.lang.annotation.Retention")) == null || retention.getText().contains("RUNTIME"))) {
                Location location = this.mContext.getLocation((PsiElement)element);
                String message = String.format("Type annotations are not supported in Android: %1$s", referenceName);
                this.mContext.report(UNSUPPORTED, (PsiElement)element, location, message);
            }
        }

        public void visitForEachExpression(UForEachExpression statement) {
            UExpression value = statement.getIteratedValue();
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiType type = value.getExpressionType();
            if (type instanceof PsiClassType) {
                PsiClass containingClass;
                PsiElement keySet;
                UQualifiedReferenceExpression keySetRef;
                String expressionOwner = evaluator.getQualifiedName((PsiClassType)type);
                if (expressionOwner == null) {
                    return;
                }
                int api = ApiDetector.this.mApiDatabase.getClassVersion(expressionOwner);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
                if (ApiDetector.isSuppressed(this.mContext, api, (UElement)statement, minSdk)) {
                    return;
                }
                Location location = this.mContext.getLocation((UElement)value);
                String message = String.format("The type of the for loop iterated value is %1$s, which requires API level %2$d (current min is %3$d)", type.getCanonicalText(), api, Math.max(minSdk, ApiDetector.getTargetApi((UElement)statement)));
                if (value instanceof UQualifiedReferenceExpression && "keySet".equals((keySetRef = (UQualifiedReferenceExpression)value).getResolvedName()) && (keySet = keySetRef.resolve()) instanceof PsiMethod && (containingClass = ((PsiMethod)keySet).getContainingClass()) != null && "java.util.concurrent.ConcurrentHashMap".equals(containingClass.getQualifiedName())) {
                    message = message + "; to work around this, add an explicit cast to (Map) before the `keySet` call.";
                }
                this.mContext.report(UNSUPPORTED, (UElement)statement, location, message, ApiDetector.apiLevelFix(api));
            }
        }

        public void visitCallExpression(UCallExpression expression) {
            PsiType expressionType;
            List arguments;
            int api;
            JavaEvaluator evaluator;
            String owner;
            PsiParameterList parameterList;
            PsiMethod method = expression.resolve();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiModifierList modifierList = method.getModifierList();
            if (!this.checkRequiresApi((UElement)expression, (PsiMember)method, modifierList) && (modifierList = containingClass.getModifierList()) != null) {
                this.checkRequiresApi((UElement)expression, (PsiMember)method, modifierList);
            }
            if ((parameterList = method.getParameterList()).getParametersCount() > 0) {
                PsiParameter[] parameters = parameterList.getParameters();
                List arguments2 = expression.getValueArguments();
                for (int i = 0; i < parameters.length; ++i) {
                    PsiType parameterType = parameters[i].getType();
                    if (!(parameterType instanceof PsiClassType)) continue;
                    if (i >= arguments2.size()) break;
                    UExpression argument = (UExpression)arguments2.get(i);
                    PsiType argumentType = argument.getExpressionType();
                    if (argumentType == null || parameterType.equals(argumentType) || !(argumentType instanceof PsiClassType)) continue;
                    this.checkCast((UElement)argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                }
            }
            if ((owner = (evaluator = this.mContext.getEvaluator()).getQualifiedName(containingClass)) == null) {
                return;
            }
            if (ApiLookup.startsWithEquivalentPrefix(owner, "android/support/")) {
                return;
            }
            if (!ApiDetector.this.mApiDatabase.containsClass(owner)) {
                return;
            }
            String name = LintUtils.getInternalMethodName((PsiMethod)method);
            String desc = evaluator.getMethodDescription(method, false, false);
            if (desc == null) {
                return;
            }
            if (ApiLookup.startsWithEquivalentPrefix(owner, "java/text/SimpleDateFormat") && name.equals("<init>") && !desc.equals("()V")) {
                ApiDetector.checkSimpleDateFormat(this.mContext, expression, ApiDetector.this.getMinSdk((Context)this.mContext));
            }
            if ((api = ApiDetector.this.mApiDatabase.getMethodVersion(owner, name, desc)) == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
            if (api <= minSdk) {
                return;
            }
            String fqcn = containingClass.getQualifiedName();
            if (UastExpressionUtils.isMethodCall((UElement)expression)) {
                UExpression qualifier = expression.getReceiver();
                if (qualifier != null && !(qualifier instanceof UThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    PsiClassType containingType;
                    List inheritanceChain;
                    PsiType receiverType = qualifier.getExpressionType();
                    if (receiverType instanceof PsiClassType && (inheritanceChain = ApiDetector.getInheritanceChain((PsiClassType)receiverType, containingType = this.mContext.getEvaluator().getClassType(containingClass))) != null) {
                        for (PsiClassType type : inheritanceChain) {
                            String expressionOwner = evaluator.getQualifiedName(type);
                            if (expressionOwner == null || expressionOwner.equals(owner)) continue;
                            int specificApi = ApiDetector.this.mApiDatabase.getMethodVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (!ApiDetector.this.mApiDatabase.isRelevantOwner(expressionOwner)) continue;
                                return;
                            }
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = type.getCanonicalText();
                            }
                            api = Math.min(specificApi, api);
                        }
                    }
                } else {
                    UInstanceExpression pte;
                    PsiElement resolved;
                    PsiClass cls = null;
                    if (this.mContext.file.getPath().endsWith(".java")) {
                        cls = UastUtils.getContainingClass((UElement)expression);
                    } else {
                        PsiType receiverType = expression.getReceiverType();
                        if (receiverType instanceof PsiClassType) {
                            cls = ((PsiClassType)receiverType).resolve();
                        }
                    }
                    if ((qualifier instanceof UThisExpression || qualifier instanceof USuperExpression) && (resolved = (pte = (UInstanceExpression)qualifier).resolve()) instanceof PsiClass) {
                        cls = (PsiClass)resolved;
                    }
                    while (cls != null) {
                        String expressionOwner;
                        if (cls instanceof PsiAnonymousClass) {
                            boolean found = false;
                            PsiClassType anonymousBaseType = ((PsiAnonymousClass)cls).getBaseClassType();
                            PsiClass anonymousBase = anonymousBaseType.resolve();
                            if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                cls = anonymousBase;
                                found = true;
                            } else {
                                PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                                if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                    cls = surroundingBaseType;
                                    found = true;
                                }
                            }
                            if (!found) break;
                        }
                        if ((expressionOwner = evaluator.getQualifiedName(cls)) == null || ApiLookup.equivalentName(expressionOwner, "java/lang/Object")) break;
                        int specificApi = ApiDetector.this.mApiDatabase.getMethodVersion(expressionOwner, name, desc);
                        if (specificApi == -1) {
                            if (ApiDetector.this.mApiDatabase.isRelevantOwner(expressionOwner)) {
                                break;
                            }
                        } else {
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = cls.getQualifiedName();
                            }
                            api = Math.min(specificApi, api);
                            break;
                        }
                        cls = cls.getSuperClass();
                    }
                }
            }
            if (ApiDetector.isSuppressed(this.mContext, api, (UElement)expression, minSdk)) {
                return;
            }
            if (UastExpressionUtils.isMethodCall((UElement)expression)) {
                PsiMethod containingMethod;
                PsiMethod[] methods;
                UExpression receiver = expression.getReceiver();
                PsiClass target = null;
                if (!method.isConstructor()) {
                    if (receiver != null) {
                        PsiType type = receiver.getExpressionType();
                        if (type instanceof PsiClassType) {
                            target = ((PsiClassType)type).resolve();
                        }
                    } else {
                        target = UastUtils.getContainingClass((UElement)expression);
                    }
                }
                if (target != null && (methods = target.findMethodsBySignature(method, true)).length > 1) {
                    for (PsiMethod m : methods) {
                        int methodApi;
                        String methodOwner;
                        PsiClass provider;
                        if (method.equals(m) || (provider = m.getContainingClass()) == null || (methodOwner = evaluator.getQualifiedName(provider)) == null || (methodApi = ApiDetector.this.mApiDatabase.getMethodVersion(methodOwner, name, desc)) != -1 && methodApi > minSdk) continue;
                        return;
                    }
                }
                if (receiver instanceof USuperExpression && (containingMethod = UastUtils.getContainingMethod((UElement)expression)) != null && name.equals(containingMethod.getName()) && evaluator.areSignaturesEqual(method, containingMethod) && !method.isConstructor()) {
                    return;
                }
                if (!(method instanceof PsiCompiledElement)) {
                    return;
                }
            }
            if (name.equals("compare") && api == 19 && ApiLookup.startsWithEquivalentPrefix(owner, "java/lang/") && desc.length() == 4 && ApiDetector.isUsingDesugar((Context)this.mContext, (UElement)expression) && (desc.equals("(JJ)") || desc.equals("(ZZ)") || desc.equals("(BB)") || desc.equals("(CC)") || desc.equals("(II)") || desc.equals("(JJ)") || desc.equals("(SS)"))) {
                return;
            }
            if (name.equals("requireNonNull") && api == 19 && owner.equals("java.util.Objects") && desc.equals("(Ljava.lang.Object;)") && ApiDetector.isUsingDesugar((Context)this.mContext, (UElement)expression)) {
                return;
            }
            if (name.equals("addSuppressed") && api == 19 && owner.equals("java.lang.Throwable") && desc.equals("(Ljava.lang.Throwable;)") && ApiDetector.isUsingDesugar((Context)this.mContext, (UElement)expression)) {
                return;
            }
            if (name.equals("forEach") && (arguments = expression.getValueArguments()).size() == 1 && (expressionType = ((UExpression)arguments.get(0)).getExpressionType()) != null && expressionType.getCanonicalText().startsWith("kotlin.")) {
                return;
            }
            String signature = "<init>".equals(name) ? "new " + fqcn : fqcn + '#' + name;
            UIdentifier nameIdentifier = expression.getMethodIdentifier();
            Location location = UastExpressionUtils.isConstructorCall((UElement)expression) && expression.getClassReference() != null ? this.mContext.getRangeLocation((UElement)expression, 0, (UElement)expression.getClassReference(), 0) : (nameIdentifier != null ? this.mContext.getLocation((UElement)nameIdentifier) : this.mContext.getLocation((UElement)expression));
            String message = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, Math.max(minSdk, ApiDetector.getTargetApi((UElement)expression)), signature);
            this.mContext.report(UNSUPPORTED, (UElement)expression, location, message, ApiDetector.apiLevelFix(api));
        }

        private boolean checkRequiresApi(UElement expression, PsiMember member, PsiModifierList modifierList) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                int target;
                int minSdk;
                if (!ApiDetector.REQUIRES_API_ANNOTATION.equals(annotation.getQualifiedName())) continue;
                UAnnotation wrapped = JavaUAnnotation.wrap((PsiAnnotation)annotation);
                int api = (int)UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)wrapped, (String)"value", (long)-1L);
                if (api <= 1) {
                    api = (int)UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)wrapped, (String)"api", (long)-1L);
                }
                if (api > (minSdk = ApiDetector.this.getMinSdk((Context)this.mContext)) && ((target = ApiDetector.getTargetApi(expression)) == -1 || api > target)) {
                    if (VersionChecks.isWithinVersionCheckConditional(this.mContext.getEvaluator(), expression, api)) {
                        return true;
                    }
                    if (VersionChecks.isPrecededByVersionCheckExit(expression, api)) {
                        return true;
                    }
                    Location location = UastExpressionUtils.isConstructorCall((UElement)expression) && ((UCallExpression)expression).getClassReference() != null ? this.mContext.getRangeLocation(expression, 0, (UElement)((UCallExpression)expression).getClassReference(), 0) : this.mContext.getNameLocation(expression);
                    String fqcn = member.getName();
                    String message = String.format("Call requires API level %1$d (current min is %2$d): `%3$s`", api, Math.max(minSdk, ApiDetector.getTargetApi(expression)), fqcn);
                    this.mContext.report(UNSUPPORTED, expression, location, message, ApiDetector.apiLevelFix(api));
                }
                return true;
            }
            return false;
        }

        public void visitLocalVariable(ULocalVariable variable) {
            UExpression initializer = variable.getUastInitializer();
            if (initializer == null) {
                return;
            }
            PsiType initializerType = initializer.getExpressionType();
            if (!(initializerType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = variable.getType();
            if (initializerType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast((UElement)initializer, (PsiClassType)initializerType, (PsiClassType)interfaceType);
        }

        public void visitBinaryExpression(UBinaryExpression expression) {
            if (expression.getOperator() instanceof UastBinaryOperator.AssignOperator) {
                UExpression rExpression = expression.getRightOperand();
                PsiType rhsType = rExpression.getExpressionType();
                if (!(rhsType instanceof PsiClassType)) {
                    return;
                }
                PsiType interfaceType = expression.getLeftOperand().getExpressionType();
                if (rhsType.equals(interfaceType)) {
                    return;
                }
                if (!(interfaceType instanceof PsiClassType)) {
                    return;
                }
                this.checkCast((UElement)rExpression, (PsiClassType)rhsType, (PsiClassType)interfaceType);
            }
        }

        public void visitTryExpression(UTryExpression statement) {
            int minSdk;
            int api;
            List resourceList = statement.getResourceVariables();
            if (!resourceList.isEmpty() && !ApiDetector.isUsingDesugar((Context)this.mContext, (UElement)statement) && (api = 19) > (minSdk = ApiDetector.this.getMinSdk((Context)this.mContext)) && api > ApiDetector.getTargetApi((UElement)statement)) {
                if (ApiDetector.isSuppressed(this.mContext, api, (UElement)statement, minSdk)) {
                    return;
                }
                UVariable first = (UVariable)resourceList.get(0);
                UVariable last = (UVariable)resourceList.get(resourceList.size() - 1);
                Location location = this.mContext.getRangeLocation((UDeclaration)first, 0, (UDeclaration)last, 0);
                String message = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, Math.max(minSdk, ApiDetector.getTargetApi((UElement)statement)));
                this.mContext.report(UNSUPPORTED, (UElement)statement, location, message, ApiDetector.apiLevelFix(api));
            }
            for (UCatchClause catchClause : statement.getCatchClauses()) {
                int minSdk2 = ApiDetector.this.getMinSdk((Context)this.mContext);
                if (minSdk2 < 19 && ApiDetector.isMultiCatchReflectiveOperationException(catchClause)) {
                    if (ApiDetector.isSuppressed(this.mContext, 19, (UElement)statement, minSdk2)) {
                        return;
                    }
                    String message = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", minSdk2);
                    this.mContext.report(UNSUPPORTED, (UElement)statement, ApiDetector.getCatchParametersLocation(this.mContext, catchClause), message, ApiDetector.apiLevelFix(19));
                    continue;
                }
                for (UTypeReferenceExpression typeReference : catchClause.getTypeReferences()) {
                    this.checkCatchTypeElement(statement, typeReference, typeReference.getType());
                }
            }
        }

        private void checkCatchTypeElement(UTryExpression statement, UTypeReferenceExpression typeReference, PsiType type) {
            PsiClass resolved = null;
            if (type instanceof PsiClassType) {
                resolved = ((PsiClassType)type).resolve();
            }
            if (resolved != null) {
                String signature = this.mContext.getEvaluator().getQualifiedName(resolved);
                if (signature == null) {
                    return;
                }
                int api = ApiDetector.this.mApiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk((Context)this.mContext);
                if (api <= minSdk) {
                    return;
                }
                int target = ApiDetector.getTargetApi((UElement)statement);
                if (target != -1 && api <= target) {
                    return;
                }
                if (ApiDetector.isSuppressed(this.mContext, api, (UElement)statement, minSdk)) {
                    return;
                }
                Location location = this.mContext.getLocation((UElement)typeReference);
                String fqcn = resolved.getQualifiedName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.mContext.report(UNSUPPORTED, location, message, ApiDetector.apiLevelFix(api));
            }
        }

        public void visitSwitchExpression(USwitchExpression statement) {
            PsiType type;
            UExpression expression = statement.getExpression();
            if (expression != null && (type = expression.getExpressionType()) instanceof PsiClassType) {
                this.checkClassType((UElement)expression, (PsiClassType)type, "Enum for switch");
            }
        }

        private void checkField(UElement node, PsiField field) {
            int minSdk;
            int api;
            PsiClass containingClass;
            PsiType type = field.getType();
            String name = field.getName();
            if ("SDK_INT".equals(name)) {
                ApiDetector.this.checkObsoleteSdkVersion(this.mContext, node);
            }
            if ((containingClass = field.getContainingClass()) == null || name == null) {
                return;
            }
            String owner = this.mContext.getEvaluator().getQualifiedName(containingClass);
            if (owner == null) {
                return;
            }
            PsiModifierList modifierList = field.getModifierList();
            if (!this.checkRequiresApi(node, (PsiMember)field, modifierList) && (modifierList = containingClass.getModifierList()) != null) {
                this.checkRequiresApi(node, (PsiMember)field, modifierList);
            }
            if ((api = ApiDetector.this.mApiDatabase.getFieldVersion(owner, name)) != -1 && api > (minSdk = ApiDetector.this.getMinSdk((Context)this.mContext)) && api > ApiDetector.getTargetApi(node)) {
                UElement locationNode;
                UElement reference;
                Issue issue = INLINED;
                if (!(type instanceof PsiPrimitiveType) && !LintUtils.isString((PsiType)type)) {
                    List conditions;
                    issue = UNSUPPORTED;
                    UElement parent = LintUtils.skipParentheses((UElement)node.getUastParent());
                    if (parent instanceof USwitchClauseExpression && (conditions = ((USwitchClauseExpression)parent).getCaseValues()).contains(node)) {
                        return;
                    }
                } else if (ApiDetector.isBenignConstantUsage(node, name, owner)) {
                    return;
                }
                String fqcn = ClassContext.getFqcn((String)owner) + '#' + name;
                if (node instanceof UImportStatement && (reference = ((UImportStatement)node).getImportReference()) != null) {
                    node = reference;
                }
                if (ApiDetector.isSuppressed(this.mContext, api, node, minSdk)) {
                    return;
                }
                String message = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api, Math.max(minSdk, ApiDetector.getTargetApi(node)), fqcn);
                for (locationNode = node; locationNode.getUastParent() instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)locationNode.getUastParent()).getSelector() == locationNode; locationNode = locationNode.getUastParent()) {
                }
                Location location = this.mContext.getLocation(locationNode);
                this.mContext.report(issue, node, location, message, ApiDetector.apiLevelFix(api));
            }
        }
    }
}

