/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Attr;
import org.xmlpull.v1.XmlPullParserException;

public class ViewTypeDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    public static final Issue WRONG_VIEW_CAST = Issue.create((String)"WrongViewCast", (String)"Mismatched view type", (String)"Keeps track of the view types associated with ids and if it finds a usage of the id in the Java code it ensures that it is treated as the same type.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.ERROR, (Implementation)new Implementation(ViewTypeDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES), new EnumSet[]{Scope.JAVA_FILE_SCOPE}));
    public static final Issue ADD_CAST = Issue.create((String)"FindViewByIdCast", (String)"Add Explicit Cast", (String)"In Android O, the `findViewById` signature switched to using generics, which means that most of the time you can leave out explicit casts and just assign the result of the `findViewById` call to variables of specific view classes.\n\nHowever, due to language changes between Java 7 and 8, this change may cause code to not compile without explicit casts. This lint check looks for these scenarios and suggests casts to be added now such that the code will continue to compile if the language level is updated to 1.8.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.WARNING, (Implementation)new Implementation(ViewTypeDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final String FIND_VIEW_BY_ID = "findViewById";
    private Boolean ignore = null;
    private final Map<String, Object> idToViewTag = new HashMap<String, Object>(50);
    private Map<File, Multimap<String, String>> fileIdMap;

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT;
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String view = attribute.getOwnerElement().getTagName();
        String value = attribute.getValue();
        String id = null;
        if (value.startsWith("@id/")) {
            id = value.substring("@id/".length());
        } else if (value.startsWith("@+id/")) {
            id = value.substring("@+id/".length());
        }
        if (id != null) {
            List list;
            Object existing;
            if (view.equals("view")) {
                view = attribute.getOwnerElement().getAttribute("class");
            }
            if ((existing = this.idToViewTag.get(id)) == null) {
                this.idToViewTag.put(id, view);
            } else if (existing instanceof String) {
                String existingString = (String)existing;
                if (!existingString.equals(view)) {
                    ArrayList<String> list2 = new ArrayList<String>(2);
                    list2.add((String)existing);
                    list2.add(view);
                    this.idToViewTag.put(id, list2);
                }
            } else if (existing instanceof List && !(list = (List)existing).contains(view)) {
                list.add(view);
            }
        }
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(FIND_VIEW_BY_ID);
    }

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        UVariable variable;
        UBinaryExpressionWithType errorNode;
        PsiClassType castType;
        PsiType type;
        UElement node;
        LintClient client = context.getClient();
        if (this.ignore == Boolean.TRUE) {
            return;
        }
        if (this.ignore == null) {
            this.ignore = !context.getScope().contains(Scope.ALL_RESOURCE_FILES) && !client.supportsProjectResources();
            if (this.ignore.booleanValue()) {
                return;
            }
        }
        if ((node = LintUtils.skipParentheses((UElement)call)) == null) {
            return;
        }
        UElement parent = node.getUastParent();
        if (parent instanceof UBinaryExpressionWithType) {
            UBinaryExpressionWithType cast = (UBinaryExpressionWithType)parent;
            type = cast.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            castType = (PsiClassType)type;
            errorNode = cast;
        } else if (parent instanceof UExpression) {
            if (parent instanceof UCallExpression) {
                UCallExpression c = (UCallExpression)parent;
                ViewTypeDetector.checkMissingCast(context, call, c);
                return;
            }
            if (parent instanceof UQualifiedReferenceExpression) {
                return;
            }
            variable = (UExpression)parent;
            type = variable.getExpressionType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            castType = (PsiClassType)type;
            errorNode = parent;
        } else if (parent instanceof UVariable) {
            variable = (UVariable)parent;
            type = variable.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            castType = (PsiClassType)type;
            errorNode = parent;
        } else {
            return;
        }
        String castTypeClass = castType.getCanonicalText();
        if (castTypeClass.equals("android.view.View") || castTypeClass.equals("kotlin.Unit")) {
            return;
        }
        List args = call.getValueArguments();
        if (args.size() == 1) {
            UExpression first = (UExpression)args.get(0);
            ResourceUrl resourceUrl = ResourceEvaluator.getResource((JavaEvaluator)context.getEvaluator(), (UElement)first);
            if (resourceUrl != null && resourceUrl.type == ResourceType.ID && !resourceUrl.framework) {
                String id = resourceUrl.name;
                if (client.supportsProjectResources()) {
                    AbstractResourceRepository resources = client.getResourceRepository(context.getMainProject(), true, false);
                    if (resources == null) {
                        return;
                    }
                    List items = resources.getResourceItem(ResourceType.ID, id);
                    if (items != null && !items.isEmpty()) {
                        HashSet compatible = Sets.newHashSet();
                        for (ResourceItem item : items) {
                            Collection<String> tags = this.getViewTags((Context)context, item);
                            if (tags == null) continue;
                            compatible.addAll(tags);
                        }
                        if (!compatible.isEmpty()) {
                            ArrayList layoutTypes = Lists.newArrayList((Iterable)compatible);
                            this.checkCompatible(context, castType, castTypeClass, null, layoutTypes, (UElement)errorNode, first, items);
                        }
                    }
                } else {
                    Object types = this.idToViewTag.get(id);
                    if (types instanceof String) {
                        String layoutType = (String)types;
                        this.checkCompatible(context, castType, castTypeClass, layoutType, null, (UElement)errorNode, first, null);
                    } else if (types instanceof List) {
                        List layoutTypes = (List)types;
                        this.checkCompatible(context, castType, castTypeClass, null, layoutTypes, (UElement)errorNode, first, null);
                    }
                }
            }
        }
    }

    private static void checkMissingCast(JavaContext context, UCallExpression findViewByIdCall, UCallExpression surroundingCall) {
        LanguageLevel languageLevel = LintUtils.getLanguageLevel((UElement)surroundingCall, (LanguageLevel)LanguageLevel.JDK_1_7);
        if (languageLevel.isLessThan(LanguageLevel.JDK_1_8)) {
            return;
        }
        UElement uastParent = surroundingCall.getUastParent();
        if (!(uastParent instanceof UQualifiedReferenceExpression)) {
            return;
        }
        List valueArguments = surroundingCall.getValueArguments();
        int parameterIndex = -1;
        int n = valueArguments.size();
        for (int i = 0; i < n; ++i) {
            if (!findViewByIdCall.equals(valueArguments.get(i))) continue;
            parameterIndex = i;
        }
        if (parameterIndex == -1) {
            return;
        }
        PsiMethod resolvedMethod = surroundingCall.resolve();
        if (resolvedMethod == null) {
            return;
        }
        PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
        if (parameterIndex >= parameters.length) {
            return;
        }
        PsiType parameterType = parameters[parameterIndex].getType();
        if (!(parameterType instanceof PsiClassType)) {
            return;
        }
        PsiClass parameterTypeClass = ((PsiClassType)parameterType).resolve();
        if (!(parameterTypeClass instanceof PsiTypeParameter)) {
            return;
        }
        PsiType erasure = TypeConversionUtil.erasure((PsiType)parameterType);
        if (erasure == null || erasure.getCanonicalText().equals("android.view.View")) {
            return;
        }
        LintFix fix = LintFix.create().replace().name("Add cast").text(FIND_VIEW_BY_ID).shortenNames().reformat(true).with("(android.view.View)findViewById").build();
        context.report(ADD_CAST, context.getLocation((UElement)findViewByIdCall), "Add explicit cast here; won't compile with Java language level 1.8 without it", fix);
    }

    protected Collection<String> getViewTags(Context context, ResourceItem item) {
        File file;
        Multimap<String, String> map;
        ResourceFile source = (ResourceFile)item.getSource();
        if (source != null && (map = this.getIdToTagsIn(context, file = source.getFile())) != null) {
            return map.get((Object)item.getName());
        }
        return null;
    }

    private Multimap<String, String> getIdToTagsIn(Context context, File file) {
        ArrayListMultimap map;
        if (!file.getPath().endsWith(".xml")) {
            return null;
        }
        if (this.fileIdMap == null) {
            this.fileIdMap = Maps.newHashMap();
        }
        if ((map = this.fileIdMap.get(file)) == null) {
            map = ArrayListMultimap.create();
            this.fileIdMap.put(file, (Multimap<String, String>)map);
            CharSequence contents = context.getClient().readFile(file);
            try {
                ViewTypeDetector.addTags((Reader)CharSequences.getReader((CharSequence)contents, (boolean)true), (Multimap<String, String>)map);
            }
            catch (IOException | XmlPullParserException throwable) {
                // empty catch block
            }
        }
        return map;
    }

    private static void addTags(Reader reader, Multimap<String, String> map) throws XmlPullParserException, IOException {
        KXmlParser parser = new KXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(reader);
        while (true) {
            int event;
            if ((event = parser.next()) == 2) {
                String tag;
                String id = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                if (id == null || id.isEmpty() || map.containsEntry((Object)(id = LintUtils.stripIdPrefix((String)id)), (Object)(tag = parser.getName()))) continue;
                map.put((Object)id, (Object)tag);
                continue;
            }
            if (event == 1) break;
        }
    }

    private void checkCompatible(JavaContext context, PsiClassType castType, String castTypeClass, String tag, List<String> tags, UElement node, UExpression resourceReference, List<ResourceItem> items) {
        boolean compatible;
        PsiClass castClass;
        block20: {
            block19: {
                assert (tag == null || tags == null) : tag + tags;
                if (castTypeClass.equals(tag) || tags != null && tags.contains(castTypeClass)) {
                    return;
                }
                castClass = castType.resolve();
                compatible = true;
                if (tag == null) break block19;
                if (tag.equals(castTypeClass) || context.getSdkInfo().isSubViewOf(castTypeClass, tag)) break block20;
                compatible = false;
                break block20;
            }
            compatible = false;
            assert (tags != null);
            for (String string : tags) {
                if (!string.equals(castTypeClass) && !context.getSdkInfo().isSubViewOf(castTypeClass, string)) continue;
                compatible = true;
                break;
            }
        }
        if (castClass != null && !compatible) {
            if (tag != null) {
                if (ViewTypeDetector.isCompatible(context, castClass, tag)) {
                    return;
                }
            } else {
                for (String string : tags) {
                    if (!ViewTypeDetector.isCompatible(context, castClass, string)) continue;
                    return;
                }
            }
        }
        if (!compatible) {
            String message;
            Location location;
            String sampleLayout = null;
            if (tag == null) {
                tag = Joiner.on((String)"|").join(tags);
            }
            if (items != null && (tags == null || tags.size() == 1)) {
                for (ResourceItem item : items) {
                    ResourceFile source;
                    Collection<String> t = this.getViewTags((Context)context, item);
                    if (t == null || !t.contains(tag) || (source = (ResourceFile)item.getSource()) == null) continue;
                    File file = source.getFile();
                    if (source.getFolderConfiguration().isDefault()) {
                        sampleLayout = file.getName();
                        break;
                    }
                    sampleLayout = file.getParentFile().getName() + "/" + file.getName();
                    break;
                }
            }
            String string = castTypeClass.substring(castTypeClass.lastIndexOf(46) + 1);
            if (!(node instanceof UBinaryExpressionWithType)) {
                if (node instanceof UVariable && ((UVariable)node).getTypeReference() != null) {
                    location = context.getLocation((UElement)((UVariable)node).getTypeReference());
                    location.setSecondary(ViewTypeDetector.createSecondary(context, tag, resourceReference, sampleLayout));
                } else {
                    location = context.getLocation(node);
                }
                message = String.format("Unexpected implicit cast to `%1$s`: layout tag was `%2$s`", string, tag);
            } else {
                location = context.getLocation(node);
                if (sampleLayout != null) {
                    location.setSecondary(ViewTypeDetector.createSecondary(context, tag, resourceReference, sampleLayout));
                }
                message = String.format("Unexpected cast to `%1$s`: layout tag was `%2$s`", string, tag);
            }
            context.report(WRONG_VIEW_CAST, node, location, message);
        }
    }

    private static Location createSecondary(JavaContext context, String tag, UExpression resourceReference, String sampleLayout) {
        Location secondary = context.getLocation((UElement)resourceReference);
        if (sampleLayout != null) {
            String article = tag.indexOf(46) == -1 && tag.indexOf(124) == -1 && StringUtil.isVowel((char)Character.toLowerCase(tag.charAt(0))) ? "an" : "a";
            secondary.setMessage(String.format("Id bound to %1$s `%2$s` in `%3$s`", article, tag, sampleLayout));
        }
        return secondary;
    }

    private static boolean isCompatible(JavaContext context, PsiClass castClass, String tag) {
        PsiClass cls = null;
        if (tag.indexOf(46) == -1) {
            for (String prefix : new String[]{"android.widget.", "android.view.", "android.webkit."}) {
                cls = context.getEvaluator().findClass(prefix + tag);
                if (cls == null) {
                    continue;
                }
                break;
            }
        } else {
            cls = context.getEvaluator().findClass(tag);
        }
        if (cls != null) {
            return cls.isInheritor(castClass, true);
        }
        return true;
    }
}

