/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.java.JavaUTypeCastExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class AnnotationDetector
extends Detector
implements SourceCodeScanner {
    public static final String GMS_HIDE_ANNOTATION = "com.google.android.gms.common.internal.Hide";
    public static final String CHECK_RESULT_ANNOTATION = "android.support.annotation.CheckResult";
    public static final String INT_RANGE_ANNOTATION = "android.support.annotation.IntRange";
    public static final String FLOAT_RANGE_ANNOTATION = "android.support.annotation.FloatRange";
    public static final String SIZE_ANNOTATION = "android.support.annotation.Size";
    public static final String PERMISSION_ANNOTATION = "android.support.annotation.RequiresPermission";
    public static final String UI_THREAD_ANNOTATION = "android.support.annotation.UiThread";
    public static final String MAIN_THREAD_ANNOTATION = "android.support.annotation.MainThread";
    public static final String WORKER_THREAD_ANNOTATION = "android.support.annotation.WorkerThread";
    public static final String BINDER_THREAD_ANNOTATION = "android.support.annotation.BinderThread";
    public static final String ANY_THREAD_ANNOTATION = "android.support.annotation.AnyThread";
    public static final String RESTRICT_TO_ANNOTATION = "android.support.annotation.RestrictTo";
    public static final String VISIBLE_FOR_TESTING_ANNOTATION = "android.support.annotation.VisibleForTesting";
    public static final String PERMISSION_ANNOTATION_READ = "android.support.annotation.RequiresPermission.Read";
    public static final String PERMISSION_ANNOTATION_WRITE = "android.support.annotation.RequiresPermission.Write";
    public static final String HALF_FLOAT_ANNOTATION = "android.support.annotation.HalfFloat";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final String SECURITY_EXCEPTION = "java.lang.SecurityException";
    public static final String FINDBUGS_ANNOTATIONS_CHECK_RETURN_VALUE = "edu.umd.cs.findbugs.annotations.CheckReturnValue";
    public static final String JAVAX_ANNOTATION_CHECK_RETURN_VALUE = "javax.annotation.CheckReturnValue";
    public static final String ERRORPRONE_CAN_IGNORE_RETURN_VALUE = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    public static final String GUAVA_VISIBLE_FOR_TESTING = "com.google.common.annotations.VisibleForTesting";
    public static final Implementation IMPLEMENTATION = new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INSIDE_METHOD = Issue.create((String)"LocalSuppress", (String)"@SuppressLint on invalid element", (String)"The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue ANNOTATION_USAGE = Issue.create((String)"SupportAnnotationUsage", (String)"Incorrect support annotation usage", (String)"This lint check makes sure that the support annotations (such as `@IntDef` and `@ColorInt`) are used correctly. For example, it's an error to specify an `@IntRange` where the `from` value is higher than the `to` value.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue UNIQUE = Issue.create((String)"UniqueConstants", (String)"Overlapping Enumeration Constants", (String)"The `@IntDef` annotation allows you to create a light-weight \"enum\" or type definition. However, it's possible to accidentally specify the same value for two or more of the values, which can lead to hard-to-detect bugs. This check looks for this scenario and flags any repeated constants.\n\nIn some cases, the repeated constant is intentional (for example, renaming a constant to a more intuitive name, and leaving the old name in place for compatibility purposes).  In that case, simply suppress this check by adding a `@SuppressLint(\"UniqueConstants\")` annotation.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue FLAG_STYLE = Issue.create((String)"ShiftFlags", (String)"Dangerous Flag Constant Declaration", (String)"When defining multiple constants for use in flags, the recommended style is to use the form `1 << 2`, `1 << 3`, `1 << 4` and so on to ensure that the constants are unique and non-overlapping.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue SWITCH_TYPE_DEF = Issue.create((String)"SwitchIntDef", (String)"Missing @IntDef in Switch", (String)"This check warns if a `switch` statement does not explicitly include all the values declared by the typedef `@IntDef` declaration.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    private Set<PsiElement> mWarnedFlags;

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(2);
        types.add(UAnnotation.class);
        types.add(USwitchExpression.class);
        return types;
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new AnnotationChecker(context);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static List<String> computeFieldNames(USwitchExpression node, Iterable<?> allowedValues) {
        ArrayList list = Lists.newArrayList();
        Iterator<?> iterator = allowedValues.iterator();
        while (true) {
            PsiClass containingClass;
            void var4_4;
            block12: {
                PsiElement resolved;
                if (!iterator.hasNext()) {
                    Collections.sort(list);
                    return list;
                }
                Object obj = iterator.next();
                if (obj instanceof ExternalReferenceExpression) {
                    ExternalReferenceExpression externalRef = (ExternalReferenceExpression)obj;
                    resolved = UastLintUtils.resolve((ExternalReferenceExpression)externalRef, (UElement)node);
                    if (resolved != null) {
                        PsiElement psiElement = resolved;
                    }
                } else {
                    PsiReferenceExpression ref;
                    if (obj instanceof PsiReferenceExpression) {
                        ref = (PsiReferenceExpression)obj;
                        resolved = ref.resolve();
                        if (resolved != null) {
                            PsiElement psiElement = resolved;
                            break block12;
                        } else {
                            String referenceName = ref.getReferenceName();
                            if (referenceName == null) continue;
                            list.add('`' + referenceName + '`');
                            continue;
                        }
                    }
                    if (obj instanceof PsiLiteral) {
                        list.add("`" + ((PsiLiteral)obj).getValue() + '`');
                        continue;
                    }
                    if (obj instanceof UReferenceExpression) {
                        ref = (UReferenceExpression)obj;
                        resolved = ref.resolve();
                        if (resolved == null) {
                            String resolvedName = ref.getResolvedName();
                            if (resolvedName == null) continue;
                            list.add('`' + resolvedName + '`');
                            continue;
                        }
                        PsiElement psiElement = resolved;
                    }
                }
            }
            if (!(var4_4 instanceof PsiField)) continue;
            PsiField field = (PsiField)var4_4;
            String name = field.getName();
            UClass clz = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (clz != null && (containingClass = field.getContainingClass()) != null && !containingClass.equals(clz.getPsi())) {
                name = containingClass.getName() + '.' + field.getName();
            }
            list.add('`' + name + '`');
        }
    }

    private static UElement getAnnotationScope(UAnnotation node) {
        UElement scope = UastUtils.getParentOfType((UElement)node, UAnnotation.class, (boolean)true);
        if (scope == null) {
            scope = node;
        }
        return scope;
    }

    private static boolean removeFieldFromList(List<Object> fields, PsiField resolvedField) {
        for (Object field : fields) {
            PsiField candidateField;
            if (!(field instanceof PsiField) || !(candidateField = (PsiField)field).isEquivalentTo((PsiElement)resolvedField)) continue;
            return true;
        }
        return false;
    }

    static PsiAnnotation[] filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations) {
        ArrayList<PsiAnnotation> result = null;
        int length = annotations.length;
        if (length == 0) {
            return annotations;
        }
        for (PsiAnnotation annotation : annotations) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement ref;
            String signature = annotation.getQualifiedName();
            if (signature == null || signature.startsWith("java.")) continue;
            if (signature.startsWith("android.support.annotation.") || signature.equals(GMS_HIDE_ANNOTATION)) {
                if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) continue;
                if (length == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList<PsiAnnotation>(2);
                }
                result.add(annotation);
            }
            if ((ref = annotation.getNameReferenceElement()) == null || !((resolved = ref.resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass cls = (PsiClass)resolved;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false);
            for (int j = 0; j < innerAnnotations.length; ++j) {
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a == null || a.startsWith("java.") || !a.equals("android.support.annotation.IntDef") && !a.equals("android.support.annotation.LongDef") && !a.equals(PERMISSION_ANNOTATION) && !a.equals(INT_RANGE_ANNOTATION) && !a.equals("android.support.annotation.StringDef")) continue;
                if (length == 1 && j == innerAnnotations.length - 1 && result == null) {
                    return innerAnnotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(inner);
            }
        }
        return result != null ? result.toArray(PsiAnnotation.EMPTY_ARRAY) : PsiAnnotation.EMPTY_ARRAY;
    }

    private class AnnotationChecker
    extends UElementHandler {
        private final JavaContext mContext;

        public AnnotationChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitAnnotation(UAnnotation annotation) {
            block14: {
                PsiClass cls;
                String type;
                block16: {
                    block26: {
                        block24: {
                            int set;
                            block25: {
                                block23: {
                                    block22: {
                                        block19: {
                                            long min;
                                            long exact;
                                            int unset;
                                            block21: {
                                                long multiple;
                                                block20: {
                                                    block18: {
                                                        boolean invalid;
                                                        block17: {
                                                            UMethod method;
                                                            block13: {
                                                                UExpression value;
                                                                block15: {
                                                                    type = annotation.getQualifiedName();
                                                                    if (type == null || type.startsWith("java.lang.")) {
                                                                        return;
                                                                    }
                                                                    if (!"android.annotation.SuppressLint".equals(type)) break block13;
                                                                    UElement parent = annotation.getUastParent();
                                                                    if (parent == null) {
                                                                        return;
                                                                    }
                                                                    if (!(parent instanceof UDeclarationsExpression || parent instanceof ULocalVariable || parent instanceof UParameter)) {
                                                                        return;
                                                                    }
                                                                    List attributes = annotation.getAttributeValues();
                                                                    if (attributes.size() != 1) break block14;
                                                                    UNamedExpression attribute = (UNamedExpression)attributes.get(0);
                                                                    value = attribute.getExpression();
                                                                    if (!(value instanceof ULiteralExpression)) break block15;
                                                                    Object v = ((ULiteralExpression)value).getValue();
                                                                    if (!(v instanceof String)) break block14;
                                                                    String id = (String)v;
                                                                    this.checkSuppressLint(annotation, id);
                                                                    break block14;
                                                                }
                                                                if (!UastExpressionUtils.isArrayInitializer((UElement)value)) break block14;
                                                                for (UExpression ex : ((UCallExpression)value).getValueArguments()) {
                                                                    String id;
                                                                    Object v;
                                                                    if (!(ex instanceof ULiteralExpression) || !((v = ((ULiteralExpression)ex).getValue()) instanceof String) || this.checkSuppressLint(annotation, id = (String)v)) continue;
                                                                    return;
                                                                }
                                                                break block14;
                                                            }
                                                            if (!type.startsWith("android.support.annotation.")) break block16;
                                                            if (!AnnotationDetector.CHECK_RESULT_ANNOTATION.equals(type)) break block17;
                                                            if (!(annotation.getUastParent() instanceof UMethod) || (method = (UMethod)annotation.getUastParent()).isConstructor() || !PsiType.VOID.equals((Object)method.getReturnType())) break block14;
                                                            this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "@CheckResult should not be specified on `void` methods");
                                                            break block14;
                                                        }
                                                        if (!AnnotationDetector.INT_RANGE_ANNOTATION.equals(type) && !AnnotationDetector.FLOAT_RANGE_ANNOTATION.equals(type)) break block18;
                                                        if (AnnotationDetector.INT_RANGE_ANNOTATION.equals(type)) {
                                                            this.checkTargetType(annotation, "int", "long", true);
                                                            long from = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_FROM, (long)Long.MIN_VALUE);
                                                            long to = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_TO, (long)Long.MAX_VALUE);
                                                            invalid = from > to;
                                                        } else {
                                                            this.checkTargetType(annotation, "float", "double", true);
                                                            double from = UastLintUtils.getDoubleAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_FROM, (double)Double.NEGATIVE_INFINITY);
                                                            double to = UastLintUtils.getDoubleAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_TO, (double)Double.POSITIVE_INFINITY);
                                                            boolean bl = invalid = from > to;
                                                        }
                                                        if (!invalid) break block14;
                                                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Invalid range: the `from` attribute must be less than the `to` attribute");
                                                        break block14;
                                                    }
                                                    if (!AnnotationDetector.SIZE_ANNOTATION.equals(type)) break block19;
                                                    unset = -42;
                                                    exact = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)"value", (long)unset);
                                                    min = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MIN, (long)Long.MIN_VALUE);
                                                    long max = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MAX, (long)Long.MAX_VALUE);
                                                    multiple = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MULTIPLE, (long)1L);
                                                    if (min <= max) break block20;
                                                    this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Invalid size range: the `min` attribute must be less than the `max` attribute");
                                                    break block14;
                                                }
                                                if (multiple >= 1L) break block21;
                                                this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "The size multiple must be at least 1");
                                                break block14;
                                            }
                                            if ((exact >= 0L || exact == (long)unset) && (min >= 0L || min == Long.MIN_VALUE)) break block14;
                                            this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "The size can't be negative");
                                            break block14;
                                        }
                                        if (!"android.support.annotation.ColorInt".equals(type) && !"android.support.annotation.Px".equals(type)) break block22;
                                        this.checkTargetType(annotation, "int", "long", true);
                                        break block14;
                                    }
                                    if (!"android.support.annotation.IntDef".equals(type) && !"android.support.annotation.LongDef".equals(type)) break block23;
                                    this.ensureUniqueValues(annotation);
                                    break block14;
                                }
                                if (!AnnotationDetector.PERMISSION_ANNOTATION.equals(type) && !AnnotationDetector.PERMISSION_ANNOTATION_READ.equals(type) && !AnnotationDetector.PERMISSION_ANNOTATION_WRITE.equals(type)) break block24;
                                if (!(annotation.getUastParent() instanceof UMethod)) break block14;
                                String value = UastLintUtils.getAnnotationStringValue((UAnnotation)annotation, (String)"value");
                                String[] anyOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)AnnotationDetector.ATTR_ANY_OF);
                                String[] allOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)AnnotationDetector.ATTR_ALL_OF);
                                set = 0;
                                if (value != null) {
                                    ++set;
                                }
                                if (allOf != null) {
                                    ++set;
                                }
                                if (anyOf != null) {
                                    ++set;
                                }
                                if (set != 0) break block25;
                                this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "For methods, permission annotation should specify one of `value`, `anyOf` or `allOf`");
                                break block14;
                            }
                            if (set <= 1) break block14;
                            this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Only specify one of `value`, `anyOf` or `allOf`");
                            break block14;
                        }
                        if (!type.equals(AnnotationDetector.HALF_FLOAT_ANNOTATION)) break block26;
                        this.checkTargetType(annotation, "short", null, true);
                        break block14;
                    }
                    if (!type.endsWith("Res")) break block14;
                    this.checkTargetType(annotation, "int", "long", true);
                    break block14;
                }
                PsiClass resolved = annotation.resolve();
                if (resolved != null && (cls = resolved).isAnnotationType() && cls.getModifierList() != null) {
                    for (PsiAnnotation a : cls.getModifierList().getAnnotations()) {
                        String name = a.getQualifiedName();
                        if ("android.support.annotation.IntDef".equals(name)) {
                            this.checkTargetType(annotation, "int", "long", true);
                            continue;
                        }
                        if ("android.support.annotation.LongDef".equals(name)) {
                            this.checkTargetType(annotation, "long", null, true);
                            continue;
                        }
                        if (!"android.support.annotation.StringDef".equals(type)) continue;
                        this.checkTargetType(annotation, "java.lang.String", null, true);
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkTargetType(UAnnotation node, String type1, String type2, boolean allowCollection) {
            String expectedTypes;
            String typeName;
            PsiType type;
            UElement parent = node.getUastParent();
            if (parent instanceof UDeclarationsExpression) {
                List elements = ((UDeclarationsExpression)parent).getDeclarations();
                if (elements.isEmpty()) return;
                UDeclaration element = (UDeclaration)elements.get(0);
                if (!(element instanceof ULocalVariable)) return;
                type = ((ULocalVariable)element).getType();
            } else if (parent instanceof UMethod) {
                UMethod method = (UMethod)parent;
                type = method.isConstructor() ? this.mContext.getEvaluator().getClassType(method.getContainingClass()) : method.getReturnType();
            } else {
                if (!(parent instanceof UVariable)) return;
                UVariable variable = (UVariable)parent;
                if (variable.getTypeReference() == null) {
                    return;
                }
                type = variable.getType();
            }
            if (type == null) {
                return;
            }
            if (allowCollection) {
                PsiClass resolved;
                PsiClassType classType;
                if (type instanceof PsiArrayType) {
                    type = type.getDeepComponentType();
                } else if (type instanceof PsiClassType && (classType = (PsiClassType)type).getParameters().length == 1 && (resolved = classType.resolve()) != null && this.mContext.getEvaluator().implementsInterface(resolved, "java.util.Collection", false)) {
                    type = classType.getParameters()[0];
                }
            }
            if ((typeName = type.getCanonicalText()).equals("error.NonExistentClass")) {
                return;
            }
            if (typeName.equals(type1) || type2 != null && typeName.equals(type2)) return;
            if (typeName.equals(LintUtils.getAutoBoxedType((String)type1)) || type2 != null && typeName.equals(LintUtils.getAutoBoxedType((String)type2))) {
                return;
            }
            String string = expectedTypes = type2 == null ? type1 : type1 + " or " + type2;
            if (typeName.equals("java.lang.String")) {
                typeName = "String";
            }
            String message = String.format("This annotation does not apply for type %1$s; expected %2$s", typeName, expectedTypes);
            Location location = this.mContext.getLocation((UElement)node);
            this.mContext.report(ANNOTATION_USAGE, (UElement)node, location, message);
        }

        public void visitSwitchExpression(USwitchExpression switchExpression) {
            UAnnotation annotation;
            UExpression condition = switchExpression.getExpression();
            if (condition != null && PsiType.INT.equals((Object)condition.getExpressionType()) && (annotation = this.findIntDefAnnotation(condition)) != null) {
                UExpression value = annotation.findAttributeValue("value");
                if (value == null) {
                    value = annotation.findAttributeValue(null);
                }
                if (value != null && UastExpressionUtils.isArrayInitializer((UElement)value)) {
                    List allowedValues = ((UCallExpression)value).getValueArguments();
                    switchExpression.accept((UastVisitor)new SwitchChecker(switchExpression, allowedValues));
                }
            }
        }

        private UAnnotation findIntDefAnnotation(UExpression expression) {
            if (expression instanceof UReferenceExpression) {
                PsiLocalVariable variable;
                UExpression lastAssignment;
                PsiElement resolved = ((UReferenceExpression)expression).resolve();
                if (resolved instanceof PsiModifierListOwner) {
                    PsiAnnotation[] annotations = this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)resolved, true);
                    PsiAnnotation[] relevantAnnotations = AnnotationDetector.filterRelevantAnnotations(this.mContext.getEvaluator(), annotations);
                    UAnnotation annotation = TypedefDetector.Companion.findIntDef(JavaUAnnotation.wrap((PsiAnnotation[])relevantAnnotations));
                    if (annotation != null) {
                        return annotation;
                    }
                }
                if (resolved instanceof PsiLocalVariable && (lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)(variable = (PsiLocalVariable)resolved), (UElement)expression)) != null) {
                    return this.findIntDefAnnotation(lastAssignment);
                }
            } else if (expression instanceof UCallExpression) {
                PsiMethod method = ((UCallExpression)expression).resolve();
                if (method != null) {
                    PsiAnnotation[] annotations = this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)method, true);
                    PsiAnnotation[] relevantAnnotations = AnnotationDetector.filterRelevantAnnotations(this.mContext.getEvaluator(), annotations);
                    List uAnnotations = JavaUAnnotation.wrap((PsiAnnotation[])relevantAnnotations);
                    UAnnotation annotation = TypedefDetector.Companion.findIntDef(uAnnotations);
                    if (annotation != null) {
                        return annotation;
                    }
                }
            } else if (expression instanceof UIfExpression) {
                UAnnotation result;
                UIfExpression ifExpression = (UIfExpression)expression;
                if (ifExpression.getThenExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getThenExpression())) != null) {
                    return result;
                }
                if (ifExpression.getElseExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getElseExpression())) != null) {
                    return result;
                }
            } else {
                if (expression instanceof JavaUTypeCastExpression) {
                    return this.findIntDefAnnotation(((JavaUTypeCastExpression)expression).getOperand());
                }
                if (expression instanceof UParenthesizedExpression) {
                    return this.findIntDefAnnotation(((UParenthesizedExpression)expression).getExpression());
                }
            }
            return null;
        }

        private Integer getConstantValue(PsiField intDefConstantRef) {
            Object constant = intDefConstantRef.computeConstantValue();
            if (constant instanceof Number) {
                return ((Number)constant).intValue();
            }
            return null;
        }

        private void ensureUniqueValues(UAnnotation node) {
            boolean flag;
            UExpression value = node.findDeclaredAttributeValue("value");
            if (value == null) {
                value = node.findDeclaredAttributeValue(null);
            }
            if (value == null) {
                return;
            }
            if (!UastExpressionUtils.isArrayInitializer((UElement)value)) {
                return;
            }
            List initializers = ((UCallExpression)value).getValueArguments();
            HashMap valueToIndex = Maps.newHashMapWithExpectedSize((int)initializers.size());
            boolean bl = flag = UastLintUtils.getAnnotationBooleanValue((UAnnotation)node, (String)"flag") == Boolean.TRUE;
            if (flag) {
                this.ensureUsingFlagStyle(initializers);
            }
            ConstantEvaluator constantEvaluator = new ConstantEvaluator();
            for (int index = 0; index < initializers.size(); ++index) {
                UExpression expression = (UExpression)initializers.get(index);
                Object o = constantEvaluator.evaluate((UElement)expression);
                if (!(o instanceof Number)) continue;
                Number number = (Number)o;
                if (valueToIndex.containsKey(number)) {
                    Number repeatedValue = number;
                    int prevIndex = (Integer)valueToIndex.get(number);
                    UExpression prevConstant = (UExpression)initializers.get(prevIndex);
                    String message = String.format("Constants `%1$s` and `%2$s` specify the same exact value (%3$s); this is usually a cut & paste or merge error", expression.asSourceString(), prevConstant.asSourceString(), repeatedValue.toString());
                    Location location = this.mContext.getLocation((UElement)expression);
                    Location secondary = this.mContext.getLocation((UElement)prevConstant);
                    secondary.setMessage("Previous same value");
                    location.setSecondary(secondary);
                    UElement scope = AnnotationDetector.getAnnotationScope(node);
                    this.mContext.report(UNIQUE, scope, location, message);
                    break;
                }
                valueToIndex.put(number, index);
            }
        }

        private void ensureUsingFlagStyle(List<UExpression> constants) {
            if (constants.size() < 3) {
                return;
            }
            for (UExpression constant : constants) {
                long value;
                PsiLiteral literal;
                Object o;
                PsiExpression initializer;
                PsiElement resolved;
                if (!(constant instanceof UReferenceExpression) || (resolved = ((UReferenceExpression)constant).resolve()) instanceof PsiCompiledElement || !(resolved instanceof PsiField) || !((initializer = ((PsiField)resolved).getInitializer()) instanceof PsiLiteral) || !((o = (literal = (PsiLiteral)initializer).getValue()) instanceof Number) || Math.abs(value = ((Number)o).longValue()) <= 1L || Long.bitCount(value) != 1) continue;
                int shift = Long.numberOfTrailingZeros(value);
                if (AnnotationDetector.this.mWarnedFlags == null) {
                    AnnotationDetector.this.mWarnedFlags = Sets.newHashSet();
                }
                if (!AnnotationDetector.this.mWarnedFlags.add(resolved)) {
                    return;
                }
                String message = String.format("Consider declaring this constant using 1 << %1$d instead", shift);
                String replace = String.format(Locale.ROOT, "1%s << %d", o instanceof Long ? "L" : "", shift);
                LintFix fix = AnnotationDetector.this.fix().replace().with(replace).build();
                Location location = this.mContext.getLocation((PsiElement)initializer);
                this.mContext.report(FLAG_STYLE, (PsiElement)initializer, location, message, fix);
            }
        }

        private boolean checkSuppressLint(UAnnotation node, String id) {
            IssueRegistry registry = this.mContext.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains(Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                UElement scope = AnnotationDetector.getAnnotationScope(node);
                this.mContext.report(INSIDE_METHOD, scope, this.mContext.getLocation((UElement)node), String.format("The `@SuppressLint` annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id));
                return false;
            }
            return true;
        }

        private class SwitchChecker
        extends AbstractUastVisitor {
            private final USwitchExpression mSwitchExpression;
            private final List<UExpression> mAllowedValues;
            private final List<Object> mFields;
            private final List<Integer> mSeenValues;
            private boolean mReported = false;

            private SwitchChecker(USwitchExpression switchExpression, List<UExpression> allowedValues) {
                this.mSwitchExpression = switchExpression;
                this.mAllowedValues = allowedValues;
                this.mFields = Lists.newArrayListWithCapacity((int)allowedValues.size());
                for (UExpression allowedValue : allowedValues) {
                    if (allowedValue instanceof ExternalReferenceExpression) {
                        ExternalReferenceExpression externalRef = (ExternalReferenceExpression)allowedValue;
                        PsiElement resolved = UastLintUtils.resolve((ExternalReferenceExpression)externalRef, (UElement)switchExpression);
                        if (!(resolved instanceof PsiField)) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (allowedValue instanceof UReferenceExpression) {
                        PsiElement resolved = ((UReferenceExpression)allowedValue).resolve();
                        if (resolved == null) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (!(allowedValue instanceof ULiteralExpression)) continue;
                    this.mFields.add(allowedValue);
                }
                this.mSeenValues = Lists.newArrayListWithCapacity((int)allowedValues.size());
            }

            public boolean visitSwitchClauseExpression(USwitchClauseExpression node) {
                if (this.mReported) {
                    return true;
                }
                if (this.mAllowedValues == null) {
                    return true;
                }
                List caseValues = node.getCaseValues();
                if (caseValues.isEmpty()) {
                    return true;
                }
                for (UExpression caseValue : caseValues) {
                    UExpression initializer;
                    if (caseValue instanceof ULiteralExpression) {
                        List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mAllowedValues);
                        String message = "Don't use a constant here; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                        AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)caseValue, AnnotationChecker.this.mContext.getLocation((UElement)caseValue), message);
                        this.mReported = true;
                        continue;
                    }
                    if (!(caseValue instanceof UReferenceExpression)) continue;
                    PsiElement resolved = ((UReferenceExpression)caseValue).resolve();
                    if (resolved == null) {
                        return true;
                    }
                    if (!(resolved instanceof PsiField)) continue;
                    PsiField resolvedField = (PsiField)resolved;
                    boolean found = AnnotationDetector.removeFieldFromList(this.mFields, resolvedField);
                    if (!found && (initializer = AnnotationChecker.this.mContext.getUastContext().getInitializerBody((PsiVariable)((PsiField)resolved))) instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) instanceof PsiField) {
                        found = AnnotationDetector.removeFieldFromList(this.mFields, (PsiField)resolved);
                    }
                    if (found) {
                        Integer cv = AnnotationChecker.this.getConstantValue((PsiField)resolved);
                        if (cv == null) continue;
                        this.mSeenValues.add(cv);
                        continue;
                    }
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mAllowedValues);
                    String message = "Unexpected constant; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                    LintFix fix = AnnotationDetector.this.fix().data(new Object[]{list});
                    Location location = AnnotationChecker.this.mContext.getNameLocation((UElement)caseValue);
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)caseValue, location, message, fix);
                }
                return true;
            }

            public void afterVisitSwitchExpression(USwitchExpression node) {
                this.reportMissingSwitchCases();
                super.afterVisitSwitchExpression(node);
            }

            private void reportMissingSwitchCases() {
                if (this.mReported) {
                    return;
                }
                if (this.mAllowedValues == null) {
                    return;
                }
                if (!this.mFields.isEmpty()) {
                    ListIterator<Object> iterator = this.mFields.listIterator();
                    while (iterator.hasNext()) {
                        Integer cv;
                        Object next = iterator.next();
                        if (!(next instanceof PsiField) || !this.mSeenValues.contains(cv = AnnotationChecker.this.getConstantValue((PsiField)next))) continue;
                        iterator.remove();
                    }
                }
                if (!this.mFields.isEmpty()) {
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mFields);
                    String message = "Switch statement on an `int` with known associated constant missing case " + Joiner.on((String)", ").join((Iterable)list);
                    LintFix fix = AnnotationDetector.this.fix().data(new Object[]{list});
                    Location location = AnnotationChecker.this.mContext.getLocation((UElement)this.mSwitchExpression.getSwitchIdentifier());
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)this.mSwitchExpression, location, message, fix);
                }
            }
        }
    }
}

