/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;

public class FirebaseMessagingDetector
extends Detector
implements SourceCodeScanner {
    private static final String FIREBASE_IID_PACKAGE = "com.google.firebase.iid";
    private static final String FIREBASE_IID_CLASS_NAME = "com.google.firebase.iid.FirebaseInstanceId";
    private static final String FIREBASE_IID_SERVICE_CLASS_NAME = "com.google.firebase.iid.FirebaseInstanceIdService";
    private static final String ON_TOKEN_REFRESH_METHOD_NAME = "onTokenRefresh";
    private static final String GET_TOKEN_METHOD_NAME = "getToken";
    private static final Implementation IMPLEMENTATION = new Implementation(FirebaseMessagingDetector.class, Scope.JAVA_FILE_SCOPE, new EnumSet[]{Scope.ALL});
    public static final Issue MISSING_TOKEN_REFRESH = Issue.create((String)"MissingFirebaseInstanceTokenRefresh", (String)"Missing Firebase Instance ID Token Refresh", (String)"Apps that check the Firebase Instance ID should usually implement the FirebaseInstanceIdService#onTokenRefresh() callback in order to observe changes.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://firebase.google.com/docs/cloud-messaging/android/client#monitor-token-generation");
    private boolean mIsOnTokenRefreshDefined;
    private UCallExpression mGetTokenCallSite;
    private JavaContext mGetTokenContext;

    public void beforeCheckProject(Context context) {
        this.mIsOnTokenRefreshDefined = false;
        this.mGetTokenCallSite = null;
        this.mGetTokenContext = null;
    }

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && FIREBASE_IID_CLASS_NAME.equals(containingClass.getQualifiedName()) && !context.getDriver().isSuppressed(context, MISSING_TOKEN_REFRESH, (UElement)this.mGetTokenCallSite)) {
            this.mGetTokenCallSite = call;
            this.mGetTokenContext = context;
        }
    }

    public void visitClass(JavaContext context, UClass declaration) {
        if (!FIREBASE_IID_SERVICE_CLASS_NAME.equals(declaration.getQualifiedName())) {
            for (UMethod method : declaration.getMethods()) {
                if (!method.getName().equals(ON_TOKEN_REFRESH_METHOD_NAME)) continue;
                this.mIsOnTokenRefreshDefined = true;
            }
        }
    }

    public void afterCheckProject(Context context) {
        if (this.mGetTokenCallSite != null && !this.mIsOnTokenRefreshDefined) {
            context.report(MISSING_TOKEN_REFRESH, this.mGetTokenContext.getLocation((UElement)this.mGetTokenCallSite), "getToken() called without defining onTokenRefresh callback.");
        }
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_TOKEN_METHOD_NAME);
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList(FIREBASE_IID_SERVICE_CLASS_NAME);
    }
}

