/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

public class JavaScriptInterfaceDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"JavascriptInterface", (String)"Missing @JavascriptInterface on methods", (String)"As of API 17, you must annotate methods in objects registered with the `addJavascriptInterface` method with a `@JavascriptInterface` annotation.", (Category)Category.SECURITY, (int)8, (Severity)Severity.ERROR, (Implementation)new Implementation(JavaScriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/webkit/WebView.html#addJavascriptInterface(java.lang.Object, java.lang.String)");
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";
    private static final String JAVASCRIPT_INTERFACE_CLS = "android.webkit.JavascriptInterface";
    private static final String WEB_VIEW_CLS = "android.webkit.WebView";

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(ADD_JAVASCRIPT_INTERFACE);
    }

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        if (context.getMainProject().getTargetSdk() < 17) {
            return;
        }
        List arguments = call.getValueArguments();
        if (arguments.size() != 2) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.isMemberInClass((PsiMember)method, WEB_VIEW_CLS)) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        PsiType evaluated = TypeEvaluator.evaluate((UElement)first);
        if (evaluated instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)evaluated;
            PsiClass cls = classType.resolve();
            if (cls == null) {
                return;
            }
            if (JavaScriptInterfaceDetector.isJavaScriptAnnotated(cls)) {
                return;
            }
            Location location = context.getNameLocation((UElement)call);
            String message = String.format("None of the methods in the added interface (%1$s) have been annotated with `@android.webkit.JavascriptInterface`; they will not be visible in API 17", cls.getName());
            context.report(ISSUE, (UElement)call, location, message);
        }
    }

    private static boolean isJavaScriptAnnotated(PsiClass clz) {
        while (clz != null) {
            PsiModifierList modifierList = clz.getModifierList();
            if (modifierList != null && modifierList.findAnnotation(JAVASCRIPT_INTERFACE_CLS) != null) {
                return true;
            }
            for (PsiMethod method : clz.getMethods()) {
                if (method.getModifierList().findAnnotation(JAVASCRIPT_INTERFACE_CLS) == null) continue;
                return true;
            }
            clz = clz.getSuperClass();
        }
        return false;
    }
}

