/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryParser;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FontDetector
extends ResourceXmlDetector {
    public static final int FUTURE_API_VERSION_WHERE_DOWNLOADABLE_FONTS_WORK_IN_FRAMEWORK = 0x7FFFFFFE;
    private static final Implementation IMPLEMENTATION = new Implementation(FontDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue FONT_VALIDATION_WARNING = Issue.create((String)"FontValidationWarning", (String)"Validation of font files", (String)"Look for problems in various font files.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/text/downloadable-fonts.html");
    public static final Issue FONT_VALIDATION_ERROR = Issue.create((String)"FontValidationError", (String)"Validation of font files", (String)"Look for problems in various font files.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/guide/topics/text/downloadable-fonts.html");
    public static final GradleCoordinate MIN_APPSUPPORT_VERSION = new GradleCoordinate("com.android.support", "appcompat-v7", "26.0.0");
    private FontLoader mFontLoader;

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.FONT;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("font-family", "font");
    }

    public void beforeCheckProject(Context context) {
        if (this.mFontLoader == null) {
            this.mFontLoader = FontLoader.getInstance((File)context.getClient().getSdkHome());
        }
    }

    public void visitElement(XmlContext context, Element element) {
        boolean downloadableFontFile;
        Attr authority = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderAuthority");
        Attr query = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderQuery");
        Attr androidPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderPackage");
        Attr certs = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fontProviderCerts");
        Attr appAuthority = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderAuthority");
        Attr appQuery = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderQuery");
        Attr appPackage = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderPackage");
        Attr appCerts = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "fontProviderCerts");
        Attr firstAndroidAttribute = (Attr)LintUtils.coalesce((Object[])new Attr[]{authority, query, androidPackage, certs});
        Attr firstAppAttribute = (Attr)LintUtils.coalesce((Object[])new Attr[]{appAuthority, appQuery, appPackage, appCerts});
        List<String> missingAndroidAttributes = FontDetector.findMissingAttributes(authority, query, androidPackage, certs);
        List<String> missingAppAttributes = FontDetector.findMissingAttributes(appAuthority, appQuery, appPackage, appCerts);
        Element fontTag = XmlUtils.getFirstSubTagByName((Node)element, (String)"font");
        AndroidVersion minSdk = context.getMainProject().getMinSdkVersion();
        boolean bl = downloadableFontFile = LintUtils.coalesce((Object[])new Attr[]{firstAndroidAttribute, firstAppAttribute}) != null;
        if (downloadableFontFile) {
            FontDetector.checkSupportLibraryVersion(context, element);
            if (FontDetector.reportMisplacedFontTag(context, fontTag)) {
                return;
            }
            if (minSdk.getApiLevel() >= 0x7FFFFFFE) {
                FontDetector.reportUnexpectedAttributeNamespace(context, firstAppAttribute, "android");
            } else {
                FontDetector.reportUnexpectedAttributeNamespace(context, firstAndroidAttribute, "app");
            }
            FontProvider provider = this.reportUnknownProvider(context, authority, appAuthority);
            if (provider != null) {
                FontDetector.reportUnknownPackage(context, androidPackage, appPackage, provider);
                this.reportQueryProblem(context, query, appQuery, provider);
            }
            if (minSdk.getFeatureLevel() > 27) {
                this.reportMissingAppAttribute(context, firstAndroidAttribute, missingAndroidAttributes, "http://schemas.android.com/apk/res/android", "android", provider);
            } else {
                this.reportMissingAppAttribute(context, firstAppAttribute, missingAppAttributes, "http://schemas.android.com/apk/res-auto", "app", provider);
            }
        }
    }

    private static List<String> findMissingAttributes(Attr authority, Attr query, Attr packageName, Attr certs) {
        if (authority != null && query != null && packageName != null && certs != null) {
            return Collections.emptyList();
        }
        ArrayList<String> missing = new ArrayList<String>();
        if (authority == null) {
            missing.add("fontProviderAuthority");
        }
        if (query == null) {
            missing.add("fontProviderQuery");
        }
        if (packageName == null) {
            missing.add("fontProviderPackage");
        }
        if (certs == null) {
            missing.add("fontProviderCerts");
        }
        return missing;
    }

    private static void checkSupportLibraryVersion(XmlContext context, Element element) {
        Variant variant = context.getMainProject().getCurrentVariant();
        if (variant == null) {
            return;
        }
        Dependencies dependencies = variant.getMainArtifact().getDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            GradleCoordinate version;
            MavenCoordinates rc = library.getResolvedCoordinates();
            if (!"com.android.support".equals(rc.getGroupId()) || !"appcompat-v7".equals(rc.getArtifactId()) || GradleCoordinate.COMPARE_PLUS_LOWER.compare(version = new GradleCoordinate("com.android.support", "appcompat-v7", rc.getVersion()), MIN_APPSUPPORT_VERSION) >= 0) continue;
            String message = "Using version " + version.getRevision() + " of the " + "appcompat-v7" + " library. Required version for using downloadable fonts: " + MIN_APPSUPPORT_VERSION.getRevision() + " or higher.";
            LintFix fix = LintFix.create().data(new Object[]{"appcompat-v7"});
            FontDetector.reportError(context, element, message, fix);
        }
    }

    private static boolean reportMisplacedFontTag(XmlContext context, Element fontTag) {
        if (fontTag == null) {
            return false;
        }
        LintFix fix = LintFix.create().replace().with("").build();
        FontDetector.reportError(context, fontTag, "A downloadable font cannot have a `<font>` sub tag", fix);
        return true;
    }

    private static void reportUnexpectedAttributeNamespace(XmlContext context, Attr first, String namespace) {
        if (first != null) {
            AndroidVersion minSdk = context.getMainProject().getMinSdkVersion();
            String message = String.format("For `minSdkVersion`=%1$d only `%2$s:` attributes should be used", minSdk.getApiLevel(), namespace);
            LintFix fix = LintFix.create().unset(first.getNamespaceURI(), first.getLocalName()).build();
            FontDetector.reportWarning(context, first, message, fix);
        }
    }

    private void reportMissingAppAttribute(XmlContext context, Attr firstFontAttribute, List<String> missingAttributes, String namespaceUri, String namespacePrefix, FontProvider provider) {
        if (firstFontAttribute != null && !missingAttributes.isEmpty()) {
            String message = String.format("Missing required %1$s: %2$s:%3$s", StringUtil.pluralize((String)"attribute", (int)missingAttributes.size()), namespacePrefix, Joiner.on((String)(", " + namespacePrefix + ":")).join(missingAttributes));
            LintFix fix = this.makeMissingAttributeFix(missingAttributes, namespaceUri, provider);
            FontDetector.reportError(context, firstFontAttribute.getOwnerElement(), message, fix);
        }
    }

    private LintFix makeMissingAttributeFix(List<String> missingAttributes, String namespaceUri, FontProvider provider) {
        if (provider == null) {
            provider = this.mFontLoader.findOnlyKnownProvider();
        }
        LintFix.GroupBuilder fix = this.fix().composite();
        for (String missingAttribute : missingAttributes) {
            String value = FontDetector.generateNewValue(missingAttribute, provider);
            if (value == null) {
                fix.add(this.fix().set().todo(namespaceUri, missingAttribute).build());
                continue;
            }
            fix.add(this.fix().set(namespaceUri, missingAttribute, value).build());
        }
        return fix.build();
    }

    private static String generateNewValue(String missingAttribute, FontProvider provider) {
        if (provider == null) {
            return null;
        }
        switch (missingAttribute) {
            case "fontProviderAuthority": {
                return provider.getAuthority();
            }
            case "fontProviderPackage": {
                return provider.getPackageName();
            }
            case "fontProviderCerts": {
                return "@array/" + provider.getCertificateResourceName();
            }
        }
        return null;
    }

    private FontProvider reportUnknownProvider(XmlContext context, Attr attrAuthority, Attr attrAppAuthority) {
        String authority = attrAuthority != null ? attrAuthority.getValue() : null;
        String appAuthority = attrAppAuthority != null ? attrAppAuthority.getValue() : null;
        FontProvider provider = null;
        if (authority != null) {
            provider = this.reportUnknownProvider(context, attrAuthority, authority);
        } else if (appAuthority != null) {
            provider = this.reportUnknownProvider(context, attrAppAuthority, appAuthority);
        }
        return provider;
    }

    private FontProvider reportUnknownProvider(XmlContext context, Attr attrAuthority, String authority) {
        FontProvider provider = this.mFontLoader.findProvider(authority);
        if (provider != null) {
            return provider;
        }
        LintFix fix = null;
        FontProvider onlyKnownProvider = this.mFontLoader.findOnlyKnownProvider();
        if (onlyKnownProvider != null) {
            fix = this.fix().name("Replace with " + onlyKnownProvider.getAuthority()).replace().text(authority).with(onlyKnownProvider.getAuthority()).build();
        }
        FontDetector.reportError(context, attrAuthority, "Unknown font provider authority", fix);
        return null;
    }

    private static void reportUnknownPackage(XmlContext context, Attr attrAndroidPackage, Attr attrAppPackage, FontProvider provider) {
        String appPackage;
        String androidPackage = attrAndroidPackage != null ? attrAndroidPackage.getValue() : null;
        String string = appPackage = attrAppPackage != null ? attrAppPackage.getValue() : null;
        if (androidPackage != null && !androidPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context, attrAndroidPackage, androidPackage, provider);
        } else if (appPackage != null && !appPackage.equals(provider.getPackageName())) {
            FontDetector.reportUnknownPackage(context, attrAppPackage, appPackage, provider);
        }
    }

    private static void reportUnknownPackage(XmlContext context, Attr attrPackage, String packageName, FontProvider provider) {
        if (provider.getPackageName().equals(packageName)) {
            return;
        }
        LintFix fix = LintFix.create().name("Replace with " + provider.getPackageName()).replace().text(packageName).with(provider.getPackageName()).build();
        FontDetector.reportError(context, attrPackage, "Unexpected font provider package", fix);
    }

    private void reportQueryProblem(XmlContext context, Attr androidQueryAttr, Attr appQueryAttr, FontProvider provider) {
        String appQuery;
        String androidQuery = androidQueryAttr != null ? androidQueryAttr.getValue() : null;
        String string = appQuery = appQueryAttr != null ? appQueryAttr.getValue() : null;
        if (androidQuery != null) {
            this.reportQueryProblem(context, androidQueryAttr, androidQuery, provider);
        } else if (appQuery != null) {
            this.reportQueryProblem(context, appQueryAttr, appQuery, provider);
        }
    }

    private void reportQueryProblem(XmlContext context, Attr queryAttr, String query, FontProvider provider) {
        if (query.isEmpty()) {
            LintFix fix = this.fix().set().todo(queryAttr.getNamespaceURI(), queryAttr.getLocalName()).build();
            FontDetector.reportError(context, queryAttr, "Missing provider query", fix);
            return;
        }
        try {
            QueryParser.DownloadableParseResult result = QueryParser.parseDownloadableFont((String)provider.getAuthority(), (String)XmlUtils.fromXmlAttributeValue((String)query));
            if (!this.mFontLoader.fontsLoaded()) {
                return;
            }
            for (String fontName : result.getFonts().keySet()) {
                FontFamily family = this.mFontLoader.findFont(provider, fontName);
                if (family == null) {
                    FontDetector.reportError(context, queryAttr, "Unknown font: " + fontName, null);
                    continue;
                }
                for (MutableFontDetail detail : result.getFonts().get((Object)fontName)) {
                    FontDetail best = detail.findBestMatch((Collection)family.getFonts());
                    if (best == null || detail.match(best) == 0) continue;
                    LintFix fix = null;
                    if (result.getFonts().size() == 1) {
                        String better = best.generateQuery(detail.getExact());
                        fix = this.fix().name("Replace with closest font: " + better).set(queryAttr.getNamespaceURI(), queryAttr.getLocalName(), better).build();
                    }
                    if (detail.getExact()) {
                        FontDetector.reportError(context, queryAttr, "No exact match found for: " + fontName, fix);
                        continue;
                    }
                    FontDetector.reportWarning(context, queryAttr, "No exact match found for: " + fontName, fix);
                }
            }
        }
        catch (QueryParser.FontQueryParserError ex) {
            FontDetector.reportError(context, queryAttr, ex.getMessage(), null);
        }
    }

    private static void reportError(XmlContext context, Node node, String message, LintFix fix) {
        if (!context.isEnabled(FONT_VALIDATION_ERROR)) {
            return;
        }
        context.report(FONT_VALIDATION_ERROR, node, context.getLocation(node), message, fix);
    }

    private static void reportWarning(XmlContext context, Node node, String message, LintFix fix) {
        if (!context.isEnabled(FONT_VALIDATION_WARNING)) {
            return;
        }
        context.report(FONT_VALIDATION_WARNING, node, context.getLocation(node), message, fix);
    }
}

