/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;

public class LocaleDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue STRING_LOCALE = Issue.create((String)"DefaultLocale", (String)"Implied default locale in case conversion", (String)"Calling `String#toLowerCase()` or `#toUpperCase()` **without specifying an explicit locale** is a common source of bugs. The reason for that is that those methods will use the current locale on the user's device, and even though the code appears to work correctly when you are developing the app, it will fail in some locales. For example, in the Turkish locale, the uppercase replacement for `i` is **not** `I`.\n\nIf you want the methods to just perform ASCII replacement, for example to convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you really want to use the current locale, call `String#toUpperCase(Locale.getDefault())` instead.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/java/util/Locale.html#default_locale");

    public List<String> getApplicableMethodNames() {
        if (LintClient.isStudio()) {
            return Collections.singletonList("format");
        }
        return Arrays.asList("toLowerCase", "toUpperCase", "format");
    }

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        if (context.getEvaluator().isMemberInClass((PsiMember)method, "java.lang.String")) {
            String name = method.getName();
            if (name.equals("format")) {
                LocaleDetector.checkFormat(context, method, call);
            } else if (method.getParameterList().getParametersCount() == 0) {
                Location location = context.getNameLocation((UElement)call);
                String message = String.format("Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.", name);
                context.report(STRING_LOCALE, (UElement)call, location, message);
            }
        }
    }

    private static boolean isLoggingParameter(JavaContext context, UCallExpression node) {
        String name;
        UCallExpression parentCall = (UCallExpression)UastUtils.getParentOfType((UElement)node, UCallExpression.class, (boolean)true);
        if (parentCall != null && (name = LintUtils.getMethodName((UCallExpression)parentCall)) != null && name.length() == 1) {
            PsiMethod method = parentCall.resolve();
            return context.getEvaluator().isMemberInClass((PsiMember)method, "android.util.Log");
        }
        return false;
    }

    private static void checkFormat(JavaContext context, PsiMethod method, UCallExpression call) {
        if (method.getParameterList().getParametersCount() == 0 || !context.getEvaluator().parameterHasType(method, 0, "java.lang.String")) {
            return;
        }
        List expressions = call.getValueArguments();
        if (expressions.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)expressions.get(0);
        Object value = ConstantEvaluator.evaluate((JavaContext)context, (UElement)first);
        if (!(value instanceof String)) {
            return;
        }
        String format = (String)value;
        if (StringFormatDetector.isLocaleSpecific(format)) {
            if (LocaleDetector.isLoggingParameter(context, call)) {
                return;
            }
            if (UastUtils.getParentOfType((UElement)call, UThrowExpression.class, (boolean)true) != null) {
                return;
            }
            Location location = "format".equals(LintUtils.getMethodName((UCallExpression)call)) ? context.getCallLocation(call, true, true) : context.getCallLocation(call, false, true);
            String message = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            context.report(STRING_LOCALE, (UElement)call, location, message);
        }
    }
}

