/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.Variant;
import com.android.ide.common.resources.AbstractResourceRepository;
import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.checks.TranslationDetector$WhenMappings;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001FB\u0005\u00a2\u0006\u0002\u0010\u0005J.\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J<\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001fH\u0016J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\nH\u0016J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010'\u001a\u00020(2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\nH\u0002J\u0014\u0010*\u001a\u0004\u0018\u00010\n2\b\u0010 \u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\nH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\nH\u0002J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00162\u0006\u0010'\u001a\u00020(H\u0002J(\u0010.\u001a\u00020/2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u0002002\u0006\u00101\u001a\u00020/H\u0002J\u0010\u00102\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J<\u00103\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010\nH\u0002J\u001c\u00101\u001a\u00020/2\b\u00104\u001a\u0004\u0018\u0001052\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u00106\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u00107\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u00108\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u0002002\u0006\u0010 \u001a\u00020\nH\u0002J\u0018\u00109\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0002J*\u0010;\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J.\u0010<\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u0002002\u0006\u0010!\u001a\u00020\"2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J0\u0010>\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u0002002\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020/H\u0002J\u0018\u0010B\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u0002002\u0006\u0010C\u001a\u00020DH\u0016J4\u0010E\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\nH\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\f\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/android/tools/lint/checks/TranslationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "()V", "baseNames", "", "Lcom/android/resources/ResourceType;", "", "", "locales", "", "missingMap", "nonBaseNames", "nonTranslatable", "pendingLocales", "translations", "addResConfigsFromFlavor", "", "relevantLanguages", "variantFlavors", "", "container", "Lcom/android/builder/model/ProductFlavorContainer;", "afterCheckRootProject", "context", "Lcom/android/tools/lint/detector/api/Context;", "batchVisitResource", "type", "folderName", "Lcom/android/tools/lint/detector/api/ResourceContext;", "name", "element", "Lorg/w3c/dom/Element;", "defaultLocale", "checkBinaryResource", "checkFolder", "filterLocalesByResConfigs", "project", "Lcom/android/tools/lint/detector/api/Project;", "getLanguageTagFromFolder", "getLanguageTagFromQualifiers", "getLocaleTagFromFolder", "getLocaleTagFromQualifiers", "getResConfigLanguages", "handleNonTranslatable", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "isDefaultFolder", "ignoreFile", "incrementalVisitResource", "configuration", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "processExtraTranslations", "processMissingTranslations", "recordTranslatable", "recordTranslation", "language", "reportExtraResource", "reportMissingTranslation", "missingFrom", "reportTranslatedUntranslatable", "locationNode", "Lorg/w3c/dom/Node;", "translatableDefinedLocally", "visitDocument", "document", "Lorg/w3c/dom/Document;", "visitResource", "Companion", "lint-checks"})
public final class TranslationDetector
extends Detector
implements XmlScanner,
ResourceFolderScanner,
BinaryResourceScanner {
    private final Map<ResourceType, Set<String>> baseNames;
    private final Map<ResourceType, Set<String>> nonBaseNames;
    private Map<String, Set<String>> missingMap;
    private Set<String> locales;
    private Set<String> pendingLocales;
    private Set<String> nonTranslatable;
    private Map<String, Set<String>> translations;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue EXTRA;
    @JvmField
    @NotNull
    public static final Issue MISSING_BASE;
    @JvmField
    @NotNull
    public static final Issue TRANSLATED_UNTRANSLATABLE;
    public static final Companion Companion;

    private final boolean ignoreFile(Context context) {
        String string = context.file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.name");
        return StringsKt.startsWith$default((String)string, (String)"donottranslate", (boolean)false, (int)2, null) || ResourceUsageModel.isAnalyticsFile((File)context.file) || !context.getProject().getReportIssues();
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getPhase() == 2) {
            return;
        }
        this.processMissingTranslations(context);
        this.processExtraTranslations(context);
    }

    private final void processMissingTranslations(Context context) {
        Map<String, Set<String>> nameToLocales;
        Map<String, Set<String>> map = nameToLocales = this.translations;
        if (map != null) {
            Map<String, Set<String>> map2 = map;
            if (!map2.isEmpty()) {
                if (context.isEnabled(MISSING) && this.pendingLocales != null) {
                    Project project = context.getProject();
                    Set<String> set = this.pendingLocales;
                    if (set == null) {
                        Intrinsics.throwNpe();
                    }
                    Set<String> allLocales = this.filterLocalesByResConfigs(project, set);
                    int localeCount = allLocales.size();
                    Set set2 = this.nonTranslatable;
                    if (set2 == null) {
                        set2 = SetsKt.emptySet();
                    }
                    Set nonTranslatable = set2;
                    Set<String> set3 = this.baseNames.get(ResourceType.STRING);
                    if (set3 == null) {
                        return;
                    }
                    for (String key : set3) {
                        Sets.SetView setView;
                        Object object;
                        Set locales;
                        Set set4 = nameToLocales.get(key);
                        if (set4 == null) {
                            set4 = SetsKt.emptySet();
                        }
                        if ((locales = set4).size() >= localeCount || nonTranslatable.contains(key)) continue;
                        Sets.SetView missing = Sets.difference(allLocales, (Set)locales);
                        Map map3 = this.missingMap;
                        if (map3 == null) {
                            Object $receiver = object = this;
                            HashMap map4 = new HashMap();
                            ((TranslationDetector)((Object)$receiver)).missingMap = map4;
                            map3 = map4;
                        }
                        Map map5 = map3;
                        object = map5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)missing, (String)"missing");
                        object.put(key, setView);
                    }
                    if (this.missingMap != null) {
                        context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
                    }
                }
            }
        }
    }

    private final void processExtraTranslations(Context context) {
        Map<ResourceType, Set<String>> map = this.nonBaseNames;
        if (!map.isEmpty()) {
            for (ResourceType type : this.nonBaseNames.keySet()) {
                Set set = this.baseNames.get(type);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set base = set;
                Set<String> set2 = this.nonBaseNames.get(type);
                if (set2 == null) {
                    Intrinsics.throwNpe();
                }
                for (String name : set2) {
                    if (base.contains(name)) continue;
                    context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
                    return;
                }
            }
        }
    }

    public void checkFolder(@NotNull ResourceContext context, @NotNull String folderName) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderName, (String)"folderName");
            if (!context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES) || context.getDriver().getPhase() != 1 || !context.getProject().getReportIssues()) break block3;
            String string = this.getLanguageTagFromFolder(folderName);
            if (string == null) {
                return;
            }
            String language = string;
            if (this.pendingLocales == null) {
                this.pendingLocales = new HashSet();
            }
            Set<String> set = this.pendingLocales;
            if (set != null) {
                set.add(language);
            }
        }
    }

    public void checkBinaryResource(@NotNull ResourceContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType folderType = resourceFolderType;
        File file = context.file;
        if (Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.VALUES) ^ true) {
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            ResourceType type = (ResourceType)types.get(0);
            boolean bl = Intrinsics.areEqual((Object)type, (Object)ResourceType.ID) ^ true;
            if (_Assertions.ENABLED && !bl) {
                ResourceFolderType resourceFolderType2 = folderType;
                throw (Throwable)((Object)new AssertionError(resourceFolderType2));
            }
            String name = SdkUtils.fileNameToResourceName((String)file.getName());
            ResourceType resourceType = type;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"type");
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            this.visitResource(context, resourceType, string, null, null);
        }
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (this.ignoreFile((Context)context)) {
            return;
        }
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType folderType = resourceFolderType;
        File file = context.file;
        Element root = document.getDocumentElement();
        if (Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.VALUES) ^ true) {
            List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
            ResourceType type = (ResourceType)types.get(0);
            boolean bl = Intrinsics.areEqual((Object)type, (Object)ResourceType.ID) ^ true;
            if (_Assertions.ENABLED && !bl) {
                ResourceFolderType resourceFolderType2 = folderType;
                throw (Throwable)((Object)new AssertionError(resourceFolderType2));
            }
            String name = SdkUtils.fileNameToResourceName((String)file.getName());
            ResourceContext resourceContext = (ResourceContext)context;
            ResourceType resourceType = type;
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceType, (String)"type");
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            this.visitResource(resourceContext, resourceType, string, root, null);
        } else {
            String attribute;
            TranslationDetector type;
            if (root == null) {
                return;
            }
            if (Intrinsics.areEqual((Object)root.getTagName(), (Object)"resources") ^ true) {
                return;
            }
            TranslationDetector $receiver = type = this;
            String string = attribute = root.getAttributeNS("http://schemas.android.com/tools", "locale");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"attribute");
            CharSequence charSequence = string;
            String defaultLocale = !StringsKt.isBlank((CharSequence)charSequence) ? attribute : null;
            Element child = XmlUtils.getFirstSubTag((Node)root);
            while (child != null) {
                ResourceType type2 = ResourceUsageModel.getResourceType((Element)child);
                if (type2 != null && Intrinsics.areEqual((Object)type2, (Object)ResourceType.ID) ^ true && Intrinsics.areEqual((Object)type2, (Object)ResourceType.PUBLIC) ^ true && Intrinsics.areEqual((Object)type2, (Object)ResourceType.AAPT) ^ true) {
                    String name = ResourceUsageModel.getResourceFieldName((Element)child);
                    charSequence = name;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                        if (!child.hasAttribute("name")) {
                            LintFix fix = this.fix().set().todo(null, "name").build();
                            context.report(MISSING, (Node)child, context.getLocation((Node)child), "Missing `name` attribute in `<" + child.getTagName() + ">` declaration", fix);
                        }
                    } else {
                        ResourceContext resourceContext = (ResourceContext)context;
                        String string2 = name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                        this.visitResource(resourceContext, type2, string2, child, defaultLocale);
                    }
                }
                child = XmlUtils.getNextTag((Node)child);
            }
        }
    }

    private final void visitResource(ResourceContext context, ResourceType type, String name, Element element, String defaultLocale) {
        switch (TranslationDetector$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        File file = context.file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.file.parentFile");
        String folderName = file.getName();
        if (context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            String string = folderName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"folderName");
            this.batchVisitResource(type, string, context, name, element, defaultLocale);
        } else {
            String string = folderName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"folderName");
            this.incrementalVisitResource(context, type, name, element, string, defaultLocale);
        }
    }

    private final void incrementalVisitResource(ResourceContext context, ResourceType type, String name, Element element, String folderName, String defaultLocale) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return;
        }
        AbstractResourceRepository abstractResourceRepository = client.getResourceRepository(context.getMainProject(), true, false);
        if (abstractResourceRepository == null) {
            return;
        }
        AbstractResourceRepository resources = abstractResourceRepository;
        List list = resources.getResourceItems(context.getProject().getResourceNamespace(), type, name);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"resources.getResourceIte\u2026rceNamespace, type, name)");
        List items = list;
        Iterable iterable = $receiver$iv = (Iterable)items;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ResourceItem it = (ResourceItem)element$iv$iv;
            if (!this.isDefaultFolder(it.getConfiguration(), null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        boolean hasDefault = CollectionsKt.any((Iterable)((List)destination$iv$iv));
        if (!hasDefault) {
            this.reportExtraResource(type, name, context, element);
        } else if (Intrinsics.areEqual((Object)type, (Object)ResourceType.STRING) && !StringsKt.contains$default((CharSequence)folderName, (char)'-', (boolean)false, (int)2, null) && element != null && context instanceof XmlContext) {
            if (this.handleNonTranslatable(name, element, (XmlContext)context, true)) {
                return;
            }
            if (this.locales == null) {
                Project project = context.getProject();
                SortedSet sortedSet = resources.getLocales();
                Intrinsics.checkExpressionValueIsNotNull((Object)sortedSet, (String)"resources.locales");
                $receiver$iv = sortedSet;
                Project project2 = project;
                TranslationDetector translationDetector = this;
                TranslationDetector translationDetector2 = this;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    String string;
                    String string2;
                    Object element$iv$iv = element$iv$iv$iv;
                    LocaleQualifier it = (LocaleQualifier)element$iv$iv;
                    if (it.hasLanguage()) {
                        LocaleQualifier localeQualifier = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)localeQualifier, (String)"it");
                        string2 = localeQualifier.getLanguage();
                    } else {
                        string2 = defaultLocale;
                    }
                    if (string2 == null) continue;
                    String it$iv$iv = string = string2;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                translationDetector2.locales = translationDetector.filterLocalesByResConfigs(project2, CollectionsKt.toSet((Iterable)list2));
            }
            Set<String> set = this.locales;
            if (set == null) {
                Intrinsics.throwNpe();
            }
            HashSet locales = CollectionsKt.toHashSet((Iterable)set);
            for (ResourceItem item : items) {
                String language;
                String qualifiers;
                String string;
                String s;
                Object element$iv$iv;
                element$iv$iv = this;
                TranslationDetector $receiver = (TranslationDetector)((Object)element$iv$iv);
                FolderConfiguration folderConfiguration = item.getConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)folderConfiguration, (String)"item.configuration");
                String string3 = s = folderConfiguration.getQualifierString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"s");
                int index = StringsKt.indexOf$default((CharSequence)string3, (char)'-', (int)0, (boolean)false, (int)6, null);
                if (index != -1) {
                    String string4 = s;
                    int n = 0;
                    String string5 = string4.substring(n, index);
                    string = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else {
                    string = s;
                }
                if (this.getLanguageTagFromQualifiers(qualifiers = string) == null) {
                    continue;
                }
                locales.remove(language);
            }
            iterable = locales;
            if (!iterable.isEmpty()) {
                this.reportMissingTranslation(name, (XmlContext)context, element, locales);
            }
        }
    }

    private final void batchVisitResource(ResourceType type, String folderName, ResourceContext context, String name, Element element, String defaultLocale) {
        boolean isDefault = this.isDefaultFolder(context.getFolderConfiguration(), folderName);
        if (isDefault) {
            if (context.getPhase() == 1) {
                Set set = this.baseNames.get(type);
                if (set == null) {
                    TranslationDetector translationDetector;
                    TranslationDetector $receiver = translationDetector = this;
                    Set set2 = new LinkedHashSet();
                    Map<ResourceType, Set<String>> map = $receiver.baseNames;
                    ResourceType resourceType = type;
                    Set set3 = set2;
                    map.put(resourceType, set3);
                    set = set2;
                }
                Set names = set;
                names.add((String)name);
            } else if (element != null && context instanceof XmlContext) {
                Set<String> missingFrom;
                Map<String, Set<String>> map = this.missingMap;
                Set<String> set = missingFrom = map != null ? map.get(name) : null;
                if (missingFrom != null) {
                    this.reportMissingTranslation(name, (XmlContext)context, element, missingFrom);
                }
            }
            if (Intrinsics.areEqual((Object)type, (Object)ResourceType.STRING) && element != null && context instanceof XmlContext) {
                String language;
                if (defaultLocale != null && (language = this.getLanguageTagFromQualifiers(defaultLocale)) != null) {
                    this.recordTranslation(name, language);
                }
                this.handleNonTranslatable(name, element, (XmlContext)context, true);
            }
        } else if (context.getPhase() == 1) {
            Set set = this.nonBaseNames.get(type);
            if (set == null) {
                TranslationDetector translationDetector;
                TranslationDetector $receiver = translationDetector = this;
                Set set4 = new LinkedHashSet();
                Map<ResourceType, Set<String>> map = $receiver.nonBaseNames;
                ResourceType resourceType = type;
                Set set5 = set4;
                map.put(resourceType, set5);
                set = set4;
            }
            Set names = set;
            names.add((String)name);
            if (Intrinsics.areEqual((Object)type, (Object)ResourceType.STRING) && element != null && context instanceof XmlContext) {
                String string;
                if (this.handleNonTranslatable(name, element, (XmlContext)context, false)) {
                    return;
                }
                String string2 = this.getLanguageTagFromFolder(folderName);
                if (string2 == null) {
                    string2 = string = this.getLanguageTagFromQualifiers(defaultLocale);
                }
                if (string2 == null) {
                    string = "";
                }
                String language = string;
                this.recordTranslation(name, language);
            }
        } else {
            Set<String> set = this.baseNames.get(type);
            if (set == null || !set.contains(name)) {
                this.reportExtraResource(type, name, context, element);
            }
        }
    }

    private final boolean isDefaultFolder(FolderConfiguration configuration, String folderName) {
        FolderConfiguration folderConfiguration;
        if (configuration != null) {
            folderConfiguration = configuration;
        } else if (folderName != null) {
            if (!StringsKt.contains$default((CharSequence)folderName, (char)'-', (boolean)false, (int)2, null)) {
                return true;
            }
            if (!StringsKt.contains$default((CharSequence)folderName, (CharSequence)"dpi", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)folderName, (CharSequence)"-v", (boolean)false, (int)2, null)) {
                return false;
            }
            folderConfiguration = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfiguration == null) {
                return false;
            }
        } else {
            boolean bl = false;
            if (_Assertions.ENABLED) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return true;
        }
        FolderConfiguration config = folderConfiguration;
        return !config.any((Predicate)isDefaultFolder.1.INSTANCE);
    }

    private final void recordTranslation(String name, String language) {
        Map<String, Set<String>> map = this.translations;
        if (map == null) {
            TranslationDetector translationDetector;
            TranslationDetector $receiver = translationDetector = this;
            $receiver.translations = new HashMap();
            map = $receiver.translations;
            if (map == null) {
                Intrinsics.throwNpe();
            }
        }
        Map<String, Set<String>> translations = map;
        Set set = translations.get(name);
        if (set == null) {
            TranslationDetector translationDetector;
            TranslationDetector $receiver = translationDetector = this;
            HashSet set2 = new HashSet();
            Map<String, Set<String>> map2 = translations;
            String string = name;
            HashSet hashSet = set2;
            map2.put(string, hashSet);
            set = set2;
        }
        Set languages = set;
        languages.add((String)language);
    }

    private final boolean handleNonTranslatable(String name, Element element, XmlContext context, boolean isDefaultFolder2) {
        Attr translatable = element.getAttributeNode("translatable");
        if (translatable != null) {
            String string = translatable.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"translatable.value");
            String string2 = string;
            if (!Boolean.parseBoolean(string2)) {
                if (!isDefaultFolder2) {
                    File file = context.file.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.file.parentFile");
                    String string3 = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.file.parentFile.name");
                    if (Lint.getLocaleAndRegion((String)string3) != null) {
                        this.reportTranslatedUntranslatable(context, name, element, translatable, true);
                    }
                }
                this.recordTranslatable(context, name);
                return true;
            }
        }
        if (SdkUtils.isServiceKey((String)name) || Intrinsics.areEqual((Object)name, (Object)"google_maps_key") || Intrinsics.areEqual((Object)name, (Object)"google_maps_key_instructions")) {
            this.recordTranslatable(context, name);
            return true;
        }
        if (!isDefaultFolder2) {
            Set<String> set = this.nonTranslatable;
            if (set != null) {
                if (set.contains(name)) {
                    File file = context.file.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.file.parentFile");
                    String string = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.parentFile.name");
                    if (Lint.getLocaleAndRegion((String)string) != null) {
                        Attr attr = element.getAttributeNode("name");
                        this.reportTranslatedUntranslatable(context, name, element, attr != null ? (Node)attr : (Node)element, false);
                    }
                }
            }
        }
        return false;
    }

    private final void recordTranslatable(XmlContext context, String name) {
        if (context.getDriver().getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            if (this.nonTranslatable == null) {
                Set set;
                TranslationDetector translationDetector = this;
                translationDetector.nonTranslatable = set = (Set)new LinkedHashSet();
            }
            Set<String> set = this.nonTranslatable;
            if (set == null) {
                Intrinsics.throwNpe();
            }
            set.add(name);
        }
    }

    private final void reportTranslatedUntranslatable(XmlContext context, String name, Element element, Node locationNode, boolean translatableDefinedLocally) {
        File file = context.file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.file.parentFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.file.parentFile.name");
        String string2 = this.getLanguageTagFromFolder(string);
        if (string2 == null) {
            return;
        }
        String language = string2;
        if (context.getDriver().isSuppressed(context, EXTRA, locationNode)) {
            return;
        }
        String languageDescription = Companion.getLanguageDescription(language);
        String message2 = translatableDefinedLocally ? "The resource string \"" + name + "\" is marked as translatable=\"false\", but is translated to " + languageDescription + " here" : "The resource string \"" + name + "\" has been marked as translatable=\"false\" elsewhere (usually in the `values` folder), but is translated to " + languageDescription + " here";
        LintFix fix = this.fix().name("Remove translation").replace().range(context.getLocation((Node)element)).with("").build();
        context.report(TRANSLATED_UNTRANSLATABLE, locationNode, context.getLocation(locationNode), message2, fix);
    }

    private final void reportExtraResource(ResourceType type, String name, ResourceContext context, Element element) {
        String message2;
        File file = context.file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.file.parentFile");
        String parentFolder = file.getName();
        switch (TranslationDetector$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                String string = '\"' + name + "\" is translated here but not found in default locale";
                break;
            }
            case 2: {
                String string = "The drawable \"" + name + "\" in " + parentFolder + " has no declaration in " + "the base `drawable` folder or in a `drawable-`*density*`dpi` " + "folder; this can lead to crashes when the drawable is queried in " + "a configuration that does not match this qualifier";
                break;
            }
            default: {
                String typeName = type.getName();
                ResourceFolderType resourceFolderType = context.getResourceFolderType();
                String baseFolder = resourceFolderType != null ? resourceFolderType.getName() : null;
                String string = message2 = "The " + typeName + " \"" + name + "\" in " + parentFolder + " has no declaration in " + "the base `" + baseFolder + "` folder; this can lead to crashes " + "when the resource is queried in a configuration that " + "does not match this qualifier";
            }
        }
        if (element != null && context instanceof XmlContext) {
            LintFix lintFix;
            if (Intrinsics.areEqual((Object)context.getResourceFolderType(), (Object)ResourceFolderType.VALUES)) {
                String fixLabel = Intrinsics.areEqual((Object)type, (Object)ResourceType.STRING) ? "Remove translation" : "Remove resource override";
                lintFix = this.fix().name(fixLabel).replace().range(((XmlContext)context).getLocation((Node)element)).with("").build();
            } else {
                lintFix = null;
            }
            LintFix fix = lintFix;
            Issue issue = Intrinsics.areEqual((Object)type, (Object)ResourceType.STRING) || Intrinsics.areEqual((Object)type, (Object)ResourceType.ARRAY) && Intrinsics.areEqual((Object)element.getTagName(), (Object)"string-array") ? EXTRA : MISSING_BASE;
            Location location = XmlContext.getElementLocation$default((XmlContext)((XmlContext)context), (Element)element, null, null, (String)"name", (int)6, null);
            ((XmlContext)context).report(issue, (Node)element, location, message2, fix);
        } else {
            Location location = Location.Companion.create(context.file);
            Context.report$default((Context)context, (Issue)MISSING_BASE, (Location)location, (String)message2, null, (int)8, null);
        }
    }

    private final void reportMissingTranslation(String name, XmlContext context, Element element, Set<String> missingFrom) {
        String separator = missingFrom.size() == 2 ? " or " : ", ";
        String localeList2 = CollectionsKt.joinToString$default((Iterable)missingFrom, (CharSequence)separator, null, null, (int)0, null, (Function1)reportMissingTranslation.localeList.1.INSTANCE, (int)30, null);
        String message2 = '\"' + name + "\" is not translated in " + localeList2;
        Attr attr = element.getAttributeNode("name");
        Node locationNode = attr != null ? (Node)attr : (Node)element;
        LintFix fix = this.fix().name("Mark non-translatable").set(null, "translatable", "false").build();
        context.report(MISSING, (Node)element, context.getLocation(locationNode), message2, fix);
    }

    private final String getLanguageTagFromFolder(String name) {
        String string;
        String string2 = this.getLocaleTagFromFolder(name);
        if (string2 == null) {
            return null;
        }
        String locale = string2;
        int index = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string3 = locale;
            int n = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, index);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = locale;
        }
        return string;
    }

    private final String getLocaleTagFromFolder(String name) {
        LocaleQualifier locale;
        if (Intrinsics.areEqual((Object)name, (Object)"values")) {
            return null;
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForFolder((String)name);
        if (configuration != null && (locale = configuration.getLocaleQualifier()) != null && !locale.hasFakeValue()) {
            return locale.getTag();
        }
        return null;
    }

    private final String getLanguageTagFromQualifiers(String name) {
        String string;
        if (name == null) {
            return null;
        }
        String string2 = this.getLocaleTagFromQualifiers(name);
        if (string2 == null) {
            return null;
        }
        String locale = string2;
        int index = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string3 = locale;
            int n = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, index);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = locale;
        }
        return string;
    }

    private final String getLocaleTagFromQualifiers(String name) {
        LocaleQualifier locale;
        boolean bl;
        boolean bl2 = bl = !StringsKt.startsWith$default((String)name, (String)"values", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        CharSequence charSequence = name;
        if (charSequence.length() == 0) {
            return null;
        }
        FolderConfiguration configuration = FolderConfiguration.getConfigForQualifierString((String)name);
        if (configuration != null && (locale = configuration.getLocaleQualifier()) != null && !locale.hasFakeValue()) {
            return locale.getTag();
        }
        return null;
    }

    private final Set<String> filterLocalesByResConfigs(Project project, Set<String> locales) {
        List<String> list = this.getResConfigLanguages(project);
        if (list == null) {
            return locales;
        }
        List<String> configLanguages = list;
        return CollectionsKt.intersect((Iterable)locales, (Iterable)configLanguages);
    }

    private final List<String> getResConfigLanguages(Project project) {
        if (project.isGradleProject() && project.getGradleProjectModel() != null && project.getCurrentVariant() != null) {
            Variant variant;
            HashSet relevantDensities = Sets.newHashSet();
            Variant variant2 = variant = project.getCurrentVariant();
            if (variant2 == null) {
                Intrinsics.throwNpe();
            }
            List variantFlavors = variant2.getProductFlavors();
            AndroidProject gradleProjectModel = project.getGradleProjectModel();
            HashSet hashSet = relevantDensities;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"relevantDensities");
            Set set = hashSet;
            AndroidProject androidProject = project.getGradleProjectModel();
            if (androidProject == null) {
                Intrinsics.throwNpe();
            }
            ProductFlavorContainer productFlavorContainer = androidProject.getDefaultConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)productFlavorContainer, (String)"project.gradleProjectModel!!.defaultConfig");
            this.addResConfigsFromFlavor(set, null, productFlavorContainer);
            AndroidProject androidProject2 = gradleProjectModel;
            if (androidProject2 == null) {
                Intrinsics.throwNpe();
            }
            for (ProductFlavorContainer container : androidProject2.getProductFlavors()) {
                Set set2 = relevantDensities;
                ProductFlavorContainer productFlavorContainer2 = container;
                Intrinsics.checkExpressionValueIsNotNull((Object)productFlavorContainer2, (String)"container");
                this.addResConfigsFromFlavor(set2, variantFlavors, productFlavorContainer2);
            }
            if (!relevantDensities.isEmpty()) {
                ArrayList strings;
                ArrayList arrayList = strings = Lists.newArrayList((Iterable)relevantDensities);
                Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"strings");
                CollectionsKt.sort((List)arrayList);
                return strings;
            }
        }
        return null;
    }

    private final void addResConfigsFromFlavor(Set<String> relevantLanguages, List<String> variantFlavors, ProductFlavorContainer container) {
        block6: {
            ProductFlavor flavor;
            block5: {
                flavor = container.getProductFlavor();
                if (variantFlavors == null) break block5;
                ProductFlavor productFlavor = flavor;
                Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"flavor");
                if (!variantFlavors.contains(productFlavor.getName())) break block6;
            }
            ProductFlavor productFlavor = flavor;
            Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"flavor");
            if (!productFlavor.getResourceConfigurations().isEmpty()) {
                for (String resConfig : flavor.getResourceConfigurations()) {
                    if (resConfig.length() != 2) continue;
                    String string = resConfig;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resConfig");
                    relevantLanguages.add(string);
                }
            }
        }
    }

    public TranslationDetector() {
        EnumMap enumMap = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumMap, (String)"Maps.newEnumMap(ResourceType::class.java)");
        this.baseNames = enumMap;
        EnumMap enumMap2 = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)enumMap2, (String)"Maps.newEnumMap(ResourceType::class.java)");
        this.nonBaseNames = enumMap2;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(TranslationDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.RESOURCE_FOLDER, (Enum)Scope.BINARY_RESOURCE_FILE), new EnumSet[]{Scope.RESOURCE_FILE_SCOPE});
        MISSING = Issue.Companion.create("MissingTranslation", "Incomplete translation", "\n                If an application has more than one locale, then all the strings declared \\\n                in one language should also be translated in all other languages.\n\n                If the string should **not** be translated, you can add the attribute \\\n                `translatable=\"false\"` on the `<string>` element, or you can define all \\\n                your non-translatable strings in a resource file called \\\n                `donottranslate.xml`. Or, you can ignore the issue with a \\\n                `tools:ignore=\"MissingTranslation\"` attribute.\n\n                You can tell lint (and other tools) which language is the default language \\\n                in your `res/values/` folder by specifying `tools:locale=\"languageCode\"` \\\n                for the root `<resources>` element in your resource file. \\\n                (The `tools` prefix refers to the namespace declaration \\\n                `http://schemas.android.com/tools`.)", Category.MESSAGES, 8, Severity.ERROR, TranslationDetector.Companion.getIMPLEMENTATION());
        EXTRA = Issue.Companion.create("ExtraTranslation", "Extra translation", "\n                If a string appears in a specific language translation file, but there is \\\n                no corresponding string in the default locale, then this string is probably \\\n                unused. (It's technically possible that your application is only intended \\\n                to run in a specific locale, but it's still a good idea to provide a fallback.)\n\n                Note that these strings can lead to crashes if the string is looked up on \\\n                any locale not providing a translation, so it's important to clean them up.", Category.MESSAGES, 6, Severity.FATAL, TranslationDetector.Companion.getIMPLEMENTATION());
        MISSING_BASE = Issue.Companion.create("MissingDefaultResource", "Missing Default", "\n                If a resource is only defined in folders with qualifiers like `-land` or \\\n                `-en`, and there is no default declaration in the base folder (`layout` or \\\n                `values` etc), then the app will crash if that resource is accessed on a \\\n                device where the device is in a configuration missing the given qualifier.\n\n                As a special case, drawables do not have to be specified in the base folder; \\\n                if there is a match in a density folder (such as `drawable-mdpi`) that image \\\n                will be used and scaled. Note however that if you  only specify a drawable in \\\n                a folder like `drawable-en-hdpi`, the app will crash in non-English locales.\n\n                There may be scenarios where you have a resource, such as a `-fr` drawable, \\\n                which is only referenced from some other resource with the same qualifiers \\\n                (such as a `-fr` style), which itself has safe fallbacks. However, this still \\\n                makes it possible for somebody to accidentally reference the drawable and \\\n                crash, so it is safer to create a default dummy fallback in the base folder. \\\n                Alternatively, you can suppress the issue by adding \\\n                `tools:ignore=\"MissingDefaultResource\"` on the element.\n\n                (This scenario frequently happens with string translations, where you might \\\n                delete code and the corresponding resources, but forget to delete a \\\n                translation. There is a dedicated issue id for that scenario, with the id \\\n                `ExtraTranslation`.)", Category.CORRECTNESS, 6, Severity.FATAL, TranslationDetector.Companion.getIMPLEMENTATION());
        TRANSLATED_UNTRANSLATABLE = Issue.Companion.create("Untranslatable", "Translated Untranslatable", "\n                Strings can be marked with `translatable=false` to indicate that they are not \\\n                intended to be translated, but are present in the resource file for other \\\n                purposes (for example for non-display strings that should vary by some other \\\n                configuration qualifier such as screen size or API level).\n\n                There are cases where translators accidentally translate these strings anyway, \\\n                and lint will flag these occurrences with this lint check.", Category.MESSAGES, 6, Severity.WARNING, TranslationDetector.Companion.getIMPLEMENTATION());
    }

    @JvmStatic
    @NotNull
    public static final String getLanguageDescription(@NotNull String locale) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        return Companion.getLanguageDescription(locale);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/TranslationDetector$Companion;", "", "()V", "EXTRA", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "MISSING", "MISSING_BASE", "TRANSLATED_UNTRANSLATABLE", "getLanguageDescription", "", "locale", "lint-checks"})
    public static final class Companion {
        private final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        @JvmStatic
        @NotNull
        public final String getLanguageDescription(@NotNull String locale) {
            String string;
            String languageName;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
            int index = StringsKt.indexOf$default((CharSequence)locale, (char)'-', (int)0, (boolean)false, (int)6, null);
            String regionCode = null;
            String languageCode = locale;
            if (index != -1) {
                String string2 = locale;
                int n = index + 1;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                string2 = string3;
                Locale locale2 = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.US");
                Locale locale3 = locale2;
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toUpperCase(locale3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
                regionCode = string5;
                string2 = locale;
                int n2 = 0;
                String string6 = string2.substring(n2, index);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string2 = string6;
                Locale locale4 = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.US");
                object = locale4;
                String string7 = string2;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.toLowerCase((Locale)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
                languageCode = string8;
            }
            if ((languageName = LocaleManager.getLanguageName((String)languageCode)) != null) {
                String regionName;
                if (regionCode != null && (regionName = LocaleManager.getRegionName((String)regionCode)) != null) {
                    languageName = "" + languageName + ": " + regionName;
                }
                object = StringCompanionObject.INSTANCE;
                String string9 = "\"%1$s\" (%2$s)";
                Object[] objectArray = new Object[]{locale, languageName};
                String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
                string = string10;
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"java.lang.String.format(format, *args)");
            } else {
                string = "\"" + locale + "\"";
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

