/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J(\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/CanvasSizeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "computeErrorMessage", "verb", "name", "calling", "", "replacement", "computeQuickfixMessage", "kotlin", "drawable", "computeQuickfixReplacementString", "reportWarning", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "containingClass", "Lorg/jetbrains/uast/UClass;", "visitClass", "declaration", "Companion", "lint-checks"})
public final class CanvasSizeDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final String CLASS_CANVAS = "android.graphics.Canvas";
    private static final String CLASS_DRAWABLE = "android.graphics.drawable.Drawable";
    private static final String ON_DRAW = "onDraw";
    private static final String DRAW = "draw";
    private static final String GET_WIDTH = "getWidth";
    private static final String GET_HEIGHT = "getHeight";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    public static final Companion Companion;

    @Nullable
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object[])new String[]{"android.view.View", CLASS_DRAWABLE});
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context.getEvaluator();
        UMethod[] $receiver$iv = declaration.getMethods();
        UMethod[] uMethodArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            void it = element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)ON_DRAW) || Intrinsics.areEqual((Object)it.getName(), (Object)DRAW) && evaluator.parametersMatch((PsiMethod)it, new String[]{CLASS_CANVAS}))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List drawMethods = (List)destination$iv$iv;
        for (UMethod method : drawMethods) {
            method.accept((UastVisitor)new AbstractUastVisitor(this, context, declaration){
                final /* synthetic */ CanvasSizeDetector this$0;
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ UClass $declaration;

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    PsiMethod sizeMethod;
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    String name = Lint.getMethodName((UCallExpression)node);
                    if ((Intrinsics.areEqual((Object)name, (Object)"getWidth") || Intrinsics.areEqual((Object)name, (Object)"getHeight")) && (sizeMethod = node.resolve()) != null && this.$context.getEvaluator().isMemberInClass((PsiMember)sizeMethod, "android.graphics.Canvas")) {
                        CanvasSizeDetector.access$reportWarning(this.this$0, this.$context, (UElement)node, name, this.$declaration);
                    }
                    return super.visitCallExpression(node);
                }

                public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                    String name;
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    UExpression selector = node.getSelector();
                    if (selector instanceof USimpleNameReferenceExpression && (Intrinsics.areEqual((Object)(name = ((USimpleNameReferenceExpression)selector).getIdentifier()), (Object)"width") || Intrinsics.areEqual((Object)name, (Object)"height"))) {
                        PsiType type;
                        UExpression receiver = node.getReceiver();
                        PsiType psiType = type = receiver.getExpressionType();
                        if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)"android.graphics.Canvas")) {
                            CanvasSizeDetector.access$reportWarning(this.this$0, this.$context, (UElement)node, name, this.$declaration);
                        }
                    }
                    return super.visitQualifiedReferenceExpression(node);
                }
                {
                    this.this$0 = $outer;
                    this.$context = $captured_local_variable$1;
                    this.$declaration = $captured_local_variable$2;
                }
            });
        }
    }

    private final void reportWarning(JavaContext context, UElement node, String name, UClass containingClass) {
        boolean drawable = context.getEvaluator().extendsClass((PsiClass)containingClass, CLASS_DRAWABLE, false);
        boolean calling = node instanceof UCallExpression;
        String verb = calling ? "Calling" : "Referencing";
        boolean kotlin = Lint.isKotlin((PsiElement)node.getSourcePsi());
        String replacement = drawable ? (kotlin ? "bounds." + name : "getBounds()." + name) : name;
        String message2 = this.computeErrorMessage(verb, name, calling, replacement);
        Location range = context.getLocation(node);
        LintFix fix = this.fix().name(this.computeQuickfixMessage(kotlin, calling, drawable, name)).replace().range(range).pattern(drawable ? "(.*)" : "(.*)" + name).with(this.computeQuickfixReplacementString(kotlin, drawable, name)).build();
        context.report(ISSUE, node, context.getLocation(node), message2, fix);
    }

    private final String computeQuickfixReplacementString(boolean kotlin, boolean drawable, String name) {
        String string;
        if (drawable) {
            StringBuilder stringBuilder;
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            if (kotlin) {
                $receiver.append("bounds.");
            } else {
                $receiver.append("getBounds().");
            }
            $receiver.append(Intrinsics.areEqual((Object)name, (Object)GET_WIDTH) ? WIDTH : (Intrinsics.areEqual((Object)name, (Object)GET_HEIGHT) ? HEIGHT : name));
            String string2 = $receiver.append("()").toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"with(StringBuilder()) {\n\u2026\n            }.toString()");
        } else {
            string = "";
        }
        return string;
    }

    private final String computeErrorMessage(String verb, String name, boolean calling, String replacement) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(verb);
        $receiver.append(" `Canvas.").append(name);
        if (calling) {
            $receiver.append("()");
        }
        $receiver.append("` is usually wrong; you should be ");
        $receiver.append(StringsKt.decapitalize((String)verb));
        $receiver.append(" `");
        $receiver.append(replacement);
        if (calling) {
            $receiver.append("()");
        }
        String string = $receiver.append("` instead").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"with(StringBuilder()) {\n\u2026ad\")\n        }.toString()");
        return string;
    }

    private final String computeQuickfixMessage(boolean kotlin, boolean calling, boolean drawable, String name) {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        if (calling || drawable) {
            $receiver.append("Call");
        } else {
            $receiver.append("Reference");
        }
        $receiver.append(" ");
        if (drawable) {
            if (kotlin) {
                $receiver.append("bounds");
            } else {
                $receiver.append("getBounds()");
            }
            $receiver.append(".");
            $receiver.append(Intrinsics.areEqual((Object)name, (Object)GET_WIDTH) ? WIDTH : (Intrinsics.areEqual((Object)name, (Object)GET_HEIGHT) ? HEIGHT : name));
        } else {
            $receiver.append(name);
        }
        if (calling || drawable) {
            $receiver.append("()");
        }
        String string = $receiver.append(" instead").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"with(StringBuilder()) {\n\u2026ad\")\n        }.toString()");
        return string;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(CanvasSizeDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create("CanvasSize", "Wrong Canvas Size", "\n                In a custom view's draw implementation, you should normally call `getWidth` \\\n                and `getHeight` on the custom view itself, not on the `canvas` instance.\n\n                Canvas width and height are the width and height of the `Canvas`, which is \\\n                not always the same as size of the view.\n\n                In the hardware accelerated path the width and height of the canvas \\\n                typically always match that of the `View` because every view goes to its own \\\n                recorded `DisplayList`. But in software rendering there's just one canvas \\\n                that is clipped and transformed as it makes its way through the `View` tree, \\\n                and otherwise remains the same `Canvas` object for every View's draw method.\n\n                You should only use Canvas state to adjust how much you draw, such as a \\\n                quick-reject for early work avoidance if it's going to be clipped away, but \\\n                not what you draw.\n                ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    }

    public static final /* synthetic */ void access$reportWarning(CanvasSizeDetector $this, @NotNull JavaContext context, @NotNull UElement node, @NotNull String name, @NotNull UClass containingClass) {
        $this.reportWarning(context, node, name, containingClass);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/CanvasSizeDetector$Companion;", "", "()V", "CLASS_CANVAS", "", "CLASS_DRAWABLE", "DRAW", "GET_HEIGHT", "GET_WIDTH", "HEIGHT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "ON_DRAW", "WIDTH", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

