/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InstantAppDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(InstantAppDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE), new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE});
    public static final Issue ISSUE = Issue.create((String)"InstantApps", (String)"Instant App Issues", (String)"This issue flags code that will not work correctly in Instant Apps", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);

    private static boolean isInstantApp(Context context) {
        Project mainProject = context.getMainProject();
        AndroidProject model = mainProject.getGradleProjectModel();
        if (model == null) {
            return false;
        }
        GradleVersion modelVersion = mainProject.getGradleModelVersion();
        if (modelVersion == null) {
            return false;
        }
        if (!modelVersion.isAtLeast(2, 4, 0, "alpha", 1, false)) {
            return false;
        }
        if (InstantAppDetector.isInstantApp(mainProject)) {
            return true;
        }
        Project project = context.getProject();
        return project != mainProject && InstantAppDetector.isInstantApp(project);
    }

    private static boolean isInstantApp(Project project) {
        AndroidProject model = project.getGradleProjectModel();
        if (model == null) {
            return false;
        }
        int type = model.getProjectType();
        return type == 4;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("provider", "receiver", "service", "uses-sdk", "uses-permission");
    }

    public void visitElement(XmlContext context, Element element) {
        String tag;
        switch (tag = element.getTagName()) {
            case "provider": 
            case "receiver": 
            case "service": {
                InstantAppDetector.report(ISSUE, context, element, "Instant Apps are not allowed to export services, receivers, and providers");
                break;
            }
            case "uses-sdk": {
                String target;
                AndroidVersion version;
                Attr targetSdkVersionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion");
                if (targetSdkVersionNode == null || (version = SdkVersionInfo.getVersion((String)(target = targetSdkVersionNode.getValue()), null)) == null || version.getFeatureLevel() >= 23) break;
                InstantAppDetector.report(ISSUE, context, targetSdkVersionNode, "Instant Apps must target API 23+");
                break;
            }
            case "uses-permission": {
                String name;
                switch (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) {
                    case "android.permission.ACCESS_NETWORK_STATE": 
                    case "android.permission.ACCESS_WIFI_STATE": 
                    case "android.permission.INTERNET": 
                    case "android.permission.WAKE_LOCK": 
                    case "android.permission.VIBRATE": 
                    case "android.permission.ACCESS_COARSE_LOCATION": 
                    case "android.permission.ACCESS_FINE_LOCATION": 
                    case "android.permission.RECORD_AUDIO": {
                        return;
                    }
                }
                if (!name.startsWith("android.permission.")) {
                    if (name.endsWith(".permission.C2D_MESSAGE")) {
                        InstantAppDetector.report(ISSUE, context, element, "Instant Apps are not allowed to use Google Cloud Messaging (GCM)");
                    }
                    return;
                }
                InstantAppDetector.report(ISSUE, context, element, "This permission is not allowed for Instant Apps");
                break;
            }
        }
    }

    public void afterCheckRootProject(Context context) {
        if (context.getProject() != context.getMainProject()) {
            return;
        }
        if (!InstantAppDetector.isInstantApp(context)) {
            return;
        }
        Project project = context.getMainProject();
        Document mergedManifest = project.getMergedManifest();
        if (mergedManifest == null) {
            return;
        }
        Element root = mergedManifest.getDocumentElement();
        if (root == null) {
            return;
        }
        InstantAppDetector.checkMultipleLauncherActivities(context, root);
        if (context.getScope().contains(Scope.GRADLE_FILE)) {
            InstantAppDetector.checkMergedTargetSdkVersion(context, project, root);
        }
    }

    private static void checkMultipleLauncherActivities(Context context, Element root) {
        Element application = XmlUtils.getFirstSubTagByName((Node)root, (String)"application");
        if (application == null) {
            return;
        }
        Element activity = XmlUtils.getFirstSubTagByName((Node)application, (String)"activity");
        Element launchableActivity = null;
        while (activity != null) {
            if (ManifestDetector.isLaunchableActivity(activity)) {
                if (launchableActivity == null) {
                    launchableActivity = activity;
                } else {
                    LintClient client = context.getClient();
                    Pair source = client.findManifestSourceNode((Node)activity);
                    if (source != null) {
                        XmlParser parser = client.getXmlParser();
                        Node locationNode = ManifestDetector.findLaunchableCategoryNode((Element)source.getSecond());
                        if (locationNode == null) {
                            locationNode = activity;
                        }
                        Location location = parser.getLocation((File)source.getFirst(), locationNode);
                        Pair original = client.findManifestSourceNode((Node)launchableActivity);
                        if (original != null && original.getSecond() != source.getSecond()) {
                            locationNode = ManifestDetector.findLaunchableCategoryNode((Element)original.getSecond());
                            if (locationNode == null) {
                                locationNode = (Node)original.getSecond();
                            }
                            Location secondary = parser.getLocation((File)original.getFirst(), locationNode);
                            secondary.setMessage("Other launchable activity here");
                            location.setSecondary(secondary);
                        }
                        context.report(ISSUE, location, "Instant Apps are not allowed to have multiple launchable activities");
                    }
                }
            }
            activity = XmlUtils.getNextTagByName((Node)activity, (String)"activity");
        }
    }

    private static void checkMergedTargetSdkVersion(Context context, Project project, Element root) {
        String target;
        AndroidVersion version;
        Element usesSdk = XmlUtils.getFirstSubTagByName((Node)root, (String)"uses-sdk");
        if (usesSdk == null) {
            return;
        }
        Attr targetSdkVersionNode = usesSdk.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion");
        if (targetSdkVersionNode != null && (version = SdkVersionInfo.getVersion((String)(target = targetSdkVersionNode.getValue()), null)) != null && version.getFeatureLevel() < 23) {
            File dir = project.getDir();
            File gradle = project.isGradleProject() ? new File(dir, "build.gradle") : null;
            Location location = Location.create((File)(gradle != null && gradle.isFile() ? gradle : dir));
            context.report(ISSUE, location, "Instant Apps must target API 23+ (was " + version + ")");
        }
    }

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("notify", "registerReceiver", "getMacAddress", "getAddress", "getLong");
    }

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        switch (method.getName()) {
            case "notify": {
                if (!evaluator.isMemberInClass((PsiMember)method, "android.app.NotificationManager")) break;
                InstantAppDetector.report(ISSUE, context, (UElement)call, "Instant Apps are not allowed to create notifications");
                break;
            }
            case "registerReceiver": {
                if (!evaluator.isMemberInClass((PsiMember)method, "android.content.Context")) break;
                InstantAppDetector.report(ISSUE, context, (UElement)call, "Instant Apps are not allowed to listen to broadcasts from system or other apps");
                break;
            }
            case "getMacAddress": {
                if (!evaluator.isMemberInClass((PsiMember)method, "android.net.wifi.WifiInfo")) break;
                InstantAppDetector.report(ISSUE, context, (UElement)call, InstantAppDetector.getPlaceHolderError("Mac Addresses"));
                break;
            }
            case "getAddress": {
                if (!evaluator.isMemberInClass((PsiMember)method, "android.bluetooth.BluetoothAdapter")) break;
                InstantAppDetector.report(ISSUE, context, (UElement)call, InstantAppDetector.getPlaceHolderError("Mac Addresses"));
                break;
            }
            case "getLong": {
                Object key;
                List arguments;
                if (!evaluator.isMemberInClass((PsiMember)method, "com.google.android.gsf.Gservices") || (arguments = call.getValueArguments()).size() != 3 || !"android_id".equals(key = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)arguments.get(1))))) break;
                InstantAppDetector.report(ISSUE, context, (UElement)call, InstantAppDetector.getPlaceHolderError("Android Id"));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static String getPlaceHolderError(String type) {
        return "Instant Apps accessing \"" + type + "\" will get a XXX value";
    }

    public List<String> getApplicableReferenceNames() {
        return Arrays.asList("SERIAL", "ANDROID_ID");
    }

    public void visitReference(JavaContext context, UReferenceExpression reference, PsiElement referenced) {
        if (!(referenced instanceof PsiField)) {
            return;
        }
        PsiClass containingClass = ((PsiField)referenced).getContainingClass();
        if (containingClass == null) {
            return;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        switch (qualifiedName) {
            case "android.os.Build": {
                if (!"SERIAL".equals(reference.getResolvedName())) break;
                InstantAppDetector.report(ISSUE, context, (UElement)reference, InstantAppDetector.getPlaceHolderError("Build Serial"));
                break;
            }
            case "android.provider.Settings.Secure": {
                if (!"ANDROID_ID".equals(reference.getResolvedName())) break;
                InstantAppDetector.report(ISSUE, context, (UElement)reference, InstantAppDetector.getPlaceHolderError("Settings.Secure Android Id"));
            }
        }
    }

    private static void report(Issue issue, XmlContext context, Node node, String message2) {
        if (InstantAppDetector.isInstantApp((Context)context)) {
            context.report(issue, node, context.getLocation(node), message2);
        }
    }

    private static void report(Issue issue, JavaContext context, UElement element, String message2) {
        if (InstantAppDetector.isInstantApp((Context)context)) {
            context.report(issue, element, context.getLocation(element), message2);
        }
    }
}

