/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ClassField;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UnusedResourceDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
BinaryResourceScanner,
XmlScanner {
    private static final Implementation IMPLEMENTATION;
    public static final String EXCLUDE_TESTS_PROPERTY = "lint.unused-resources.exclude-tests";
    public static final String INCLUDE_TESTS_PROPERTY = "lint.unused-resources.include-tests";
    private static final String EXCLUDING_TESTS_EXPLANATION = "The unused resource check can ignore tests. If you want to include resources that are only referenced from tests, consider packaging them in a test source set instead.\n\nYou can include test sources in the unused resource check by setting the system property lint.unused-resources.include-tests=true, and to exclude them (usually for performance reasons), use lint.unused-resources.exclude-tests=true.";
    public static final Issue ISSUE;
    public static final Issue ISSUE_IDS;
    private final UnusedResourceDetectorUsageModel model = new UnusedResourceDetectorUsageModel();
    private Map<String, String> bindingClasses;
    public static boolean sIncludeInactiveReferences;

    private void addDynamicResources(Context context) {
        Project project = context.getProject();
        AndroidProject model = project.getGradleProjectModel();
        if (model != null) {
            Variant selectedVariant = project.getCurrentVariant();
            if (selectedVariant != null) {
                ProductFlavor mergedProductFlavor = selectedVariant.getMergedFlavor();
                this.recordManifestPlaceHolderUsages(mergedProductFlavor.getManifestPlaceholders());
                for (BuildTypeContainer container : model.getBuildTypes()) {
                    BuildType buildType = container.getBuildType();
                    if (!selectedVariant.getBuildType().equals(buildType.getName())) continue;
                    this.addDynamicResources(project, buildType.getResValues());
                    this.recordManifestPlaceHolderUsages(buildType.getManifestPlaceholders());
                }
            }
            ProductFlavor flavor = model.getDefaultConfig().getProductFlavor();
            this.addDynamicResources(project, flavor.getResValues());
        }
    }

    private void recordManifestPlaceHolderUsages(Map<String, Object> manifestPlaceholders) {
        for (Object value : manifestPlaceholders.values()) {
            if (!(value instanceof String)) continue;
            String string = (String)value;
            ResourceUsageModel.Resource resource = this.model.getResourceFromUrl(string);
            ResourceUsageModel.markReachable((ResourceUsageModel.Resource)resource);
        }
    }

    private void addDynamicResources(Project project, Map<String, ClassField> resValues) {
        Set<String> keys = resValues.keySet();
        if (!keys.isEmpty()) {
            Location location = Lint.guessGradleLocation((Project)project);
            for (String name : keys) {
                ClassField field = resValues.get(name);
                ResourceType type = ResourceType.fromClassName((String)field.getType());
                if (type == null) continue;
                LintResource resource = (LintResource)this.model.declareResource(type, name, null);
                resource.recordLocation(location);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void afterCheckRootProject(Context context) {
        if (context.getMainProject().isLibrary() && LintClient.isGradle()) {
            return;
        }
        if (context.getPhase() == 1) {
            Project project = context.getProject();
            if (sIncludeInactiveReferences && project.isGradleProject() && !project.isLibrary() && LintClient.isStudio()) {
                AndroidProject model = project.getGradleProjectModel();
                Variant variant = project.getCurrentVariant();
                if (model != null && variant != null) {
                    this.addInactiveReferences(model, variant);
                }
            }
            this.addDynamicResources(context);
            this.model.processToolsAttributes();
            List unusedResources = this.model.findUnused();
            HashSet hashSet = Sets.newHashSetWithExpectedSize((int)unusedResources.size());
            for (Object resource : unusedResources) {
                if (!resource.isDeclared() || resource.isPublic() || ((ResourceUsageModel.Resource)resource).type == ResourceType.PUBLIC) continue;
                hashSet.add(resource);
            }
            if (!hashSet.isEmpty() && !context.isEnabled(ISSUE_IDS)) {
                ArrayList ids = Lists.newArrayList();
                for (ResourceUsageModel.Resource resource : hashSet) {
                    if (resource.type != ResourceType.ID) continue;
                    ids.add(resource);
                }
                hashSet.removeAll(ids);
            }
            if (!hashSet.isEmpty()) {
                this.model.unused = hashSet;
                context.requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            Collection<Object> unused = this.model.unused;
            if (!unused.isEmpty()) {
                if ((unused = this.model.findUnused(Lists.newArrayList(unused))).isEmpty()) {
                    return;
                }
                for (ResourceUsageModel.Resource resource : unused) {
                    ResourceType type;
                    LintResource resource2 = (LintResource)resource;
                    Location location = resource2.locations;
                    if (location != null || (type = resource2.type) == null || !Lint.isFileBasedResourceType((ResourceType)type)) continue;
                    String name = resource2.name;
                    ArrayList folders = Lists.newArrayList();
                    List resourceFolders = context.getProject().getResourceFolders();
                    for (File res : resourceFolders) {
                        File[] f = res.listFiles();
                        if (f == null) continue;
                        folders.addAll(Arrays.asList(f));
                    }
                    if (folders.isEmpty()) continue;
                    folders.sort(Comparator.comparing(File::getName));
                    for (File folder : folders) {
                        Object[] files;
                        if (!folder.getName().startsWith(type.getName()) || (files = folder.listFiles()) == null) continue;
                        Arrays.sort(files);
                        for (Object file : files) {
                            String fileName = ((File)file).getName();
                            if (!fileName.startsWith(name) || !fileName.startsWith(".", name.length())) continue;
                            resource2.recordLocation(Location.create((File)file));
                        }
                    }
                }
                ArrayList sorted = Lists.newArrayList(unused);
                Collections.sort(sorted);
                Object var4_9 = null;
                for (ResourceUsageModel.Resource resource : sorted) {
                    Location location = ((LintResource)resource).locations;
                    if (location != null) {
                        location = Location.reverse((Location)location);
                    }
                    if (location == null) {
                        void var4_10;
                        if (var4_10 == null) {
                            Boolean bl = false;
                            for (Project project : context.getDriver().getProjects()) {
                                if (project.getReportIssues()) continue;
                                Boolean bl2 = true;
                                break;
                            }
                        }
                        if (var4_10.booleanValue()) continue;
                    }
                    String field = resource.getField();
                    String message2 = String.format("The resource `%1$s` appears to be unused", field);
                    if (location == null) {
                        location = Location.create((File)context.getProject().getDir());
                    }
                    LintFix fix = this.fix().data(new Object[]{field});
                    context.report(UnusedResourceDetector.getIssue(resource), location, message2, fix);
                }
            }
        }
    }

    private static List<SourceProvider> getInactiveSourceProviders(AndroidProject project, Variant variant) {
        Collection variants = project.getVariants();
        ArrayList providers = Lists.newArrayList();
        Collection flavors = project.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            if (variant.getProductFlavors().contains(pfc.getProductFlavor().getName())) continue;
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider;
            if (variant.getName().equals(v.getName()) || (provider = v.getMainArtifact().getMultiFlavorSourceProvider()) == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = project.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            if (variant.getBuildType().equals(btc.getBuildType().getName())) continue;
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider;
            if (variant.getName().equals(v.getName()) || (provider = v.getMainArtifact().getVariantSourceProvider()) == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    private void recordInactiveJavaReferences(File resDir) {
        File[] files = resDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.recordInactiveJavaReferences(file);
                    continue;
                }
                if (!file.getName().endsWith(".java")) continue;
                try {
                    String java = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
                    this.model.tokenizeJavaCode(java);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void recordInactiveXmlResources(File resDir) {
        File[] resourceFolders = resDir.listFiles();
        if (resourceFolders != null) {
            for (File folder : resourceFolders) {
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folder.getName());
                if (folderType == null) continue;
                this.recordInactiveXmlResources(folderType, folder);
            }
        }
    }

    private void recordInactiveXmlResources(ResourceFolderType folderType, File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                String path = file.getPath();
                boolean isXml = SdkUtils.endsWithIgnoreCase((String)path, (String)".xml");
                try {
                    if (isXml) {
                        String xml = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
                        Document document = XmlUtils.parseDocument((String)xml, (boolean)true);
                        this.model.visitXmlDocument(file, folderType, document);
                        continue;
                    }
                    this.model.visitBinaryResource(folderType, file);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void addInactiveReferences(AndroidProject model, Variant variant) {
        for (SourceProvider provider : UnusedResourceDetector.getInactiveSourceProviders(model, variant)) {
            for (File res : provider.getResDirectories()) {
                if (!res.isDirectory()) continue;
                this.recordInactiveXmlResources(res);
            }
            for (File file : provider.getJavaDirectories()) {
                if (!file.isDirectory()) continue;
                this.recordInactiveJavaReferences(file);
            }
        }
    }

    private static Issue getIssue(ResourceUsageModel.Resource resource) {
        return resource.type != ResourceType.ID ? ISSUE : ISSUE_IDS;
    }

    public boolean appliesTo(ResourceFolderType folderType) {
        return true;
    }

    public void checkBinaryResource(ResourceContext context) {
        this.model.context = context;
        try {
            this.model.visitBinaryResource(context.getResourceFolderType(), context.file);
        }
        finally {
            this.model.context = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitDocument(XmlContext context, Document document) {
        this.model.xmlContext = context;
        this.model.context = this.model.xmlContext;
        try {
            ResourceFolderType folderType = context.getResourceFolderType();
            this.model.visitXmlDocument(context.file, folderType, document);
            Element root = document.getDocumentElement();
            if (folderType == ResourceFolderType.LAYOUT && root != null && "layout".equals(root.getTagName())) {
                if (this.bindingClasses == null) {
                    this.bindingClasses = Maps.newHashMap();
                }
                String fileName = context.file.getName();
                String resourceName = Lint.getBaseName((String)fileName);
                Element data = XmlUtils.getFirstSubTagByName((Node)root, (String)"data");
                String bindingClass = null;
                while (data != null) {
                    bindingClass = data.getAttribute("class");
                    if (bindingClass != null && !bindingClass.isEmpty()) {
                        int dot = bindingClass.lastIndexOf(46);
                        bindingClass = bindingClass.substring(dot + 1);
                        break;
                    }
                    data = XmlUtils.getNextTagByName((Node)data, (String)"data");
                }
                if (bindingClass == null || bindingClass.isEmpty()) {
                    bindingClass = UnusedResourceDetector.toClassName(resourceName) + "Binding";
                }
                this.bindingClasses.put(bindingClass, resourceName);
            }
        }
        finally {
            this.model.xmlContext = null;
            this.model.context = null;
        }
    }

    public static String toClassName(String name) {
        StringBuilder builder = new StringBuilder();
        for (String item : name.split("[_-]")) {
            builder.append(UnusedResourceDetector.capitalize(item));
        }
        return builder.toString();
    }

    private static String capitalize(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        char ch = string.charAt(0);
        if (Character.isTitleCase(ch)) {
            return string;
        }
        return Character.toTitleCase(ch) + string.substring(1);
    }

    public boolean appliesToResourceRefs() {
        return true;
    }

    public void visitResourceReference(JavaContext context, UElement node, ResourceType type, String name, boolean isFramework) {
        if (!isFramework) {
            ResourceUsageModel.markReachable((ResourceUsageModel.Resource)this.model.addResource(type, name, null));
        }
    }

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(USimpleNameReferenceExpression.class);
    }

    public UElementHandler createUastHandler(final JavaContext context) {
        if (this.bindingClasses == null) {
            return null;
        }
        return new UElementHandler(){

            public void visitSimpleNameReferenceExpression(USimpleNameReferenceExpression expression) {
                PsiElement resolved;
                String name = expression.getIdentifier();
                String resourceName = (String)UnusedResourceDetector.this.bindingClasses.get(name);
                if (resourceName != null && (resolved = expression.resolve()) instanceof PsiClass && context.getEvaluator().extendsClass((PsiClass)resolved, "android.databinding.ViewDataBinding", true)) {
                    ResourceUsageModel.markReachable((ResourceUsageModel.Resource)UnusedResourceDetector.this.model.getResource(ResourceType.LAYOUT, resourceName));
                }
            }
        };
    }

    static {
        EnumSet<Scope> scopeSet = EnumSet.of(Scope.MANIFEST, Scope.ALL_RESOURCE_FILES, Scope.ALL_JAVA_FILES, Scope.BINARY_RESOURCE_FILE);
        if ("true".equals(System.getProperty(INCLUDE_TESTS_PROPERTY)) || !"false".equals(System.getProperty(EXCLUDE_TESTS_PROPERTY))) {
            scopeSet.add(Scope.TEST_SOURCES);
        }
        IMPLEMENTATION = new Implementation(UnusedResourceDetector.class, scopeSet);
        ISSUE = Issue.create((String)"UnusedResources", (String)"Unused resources", (String)"Unused resources make applications larger and slow down builds.\n\nThe unused resource check can ignore tests. If you want to include resources that are only referenced from tests, consider packaging them in a test source set instead.\n\nYou can include test sources in the unused resource check by setting the system property lint.unused-resources.include-tests=true, and to exclude them (usually for performance reasons), use lint.unused-resources.exclude-tests=true.", (Category)Category.PERFORMANCE, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
        ISSUE_IDS = Issue.create((String)"UnusedIds", (String)"Unused id", (String)"This resource id definition appears not to be needed since it is not referenced from anywhere. Having id definitions, even if unused, is not necessarily a bad idea since they make working on layouts and menus easier, so there is not a strong reason to delete these.\n\nThe unused resource check can ignore tests. If you want to include resources that are only referenced from tests, consider packaging them in a test source set instead.\n\nYou can include test sources in the unused resource check by setting the system property lint.unused-resources.include-tests=true, and to exclude them (usually for performance reasons), use lint.unused-resources.exclude-tests=true.", (Category)Category.PERFORMANCE, (int)1, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
        sIncludeInactiveReferences = true;
    }

    private static class UnusedResourceDetectorUsageModel
    extends ResourceUsageModel {
        public XmlContext xmlContext;
        public Context context;
        public Set<ResourceUsageModel.Resource> unused = Sets.newHashSet();

        private UnusedResourceDetectorUsageModel() {
        }

        protected ResourceUsageModel.Resource createResource(ResourceType type, String name, int realValue) {
            return new LintResource(type, name, realValue);
        }

        protected String readText(File file) {
            if (this.context != null) {
                return this.context.getClient().readFile(file).toString();
            }
            return super.readText(file);
        }

        protected ResourceUsageModel.Resource declareResource(ResourceType type, String name, Node node) {
            LintResource resource = (LintResource)super.declareResource(type, name, node);
            if (this.context != null) {
                resource.setDeclared(this.context.getProject().getReportIssues());
                if (this.context.getPhase() == 2 && this.unused.contains((Object)resource)) {
                    if (this.xmlContext != null && this.xmlContext.getDriver().isSuppressed(this.xmlContext, UnusedResourceDetector.getIssue(resource), node)) {
                        resource.setKeep(true);
                    } else if (node == null || this.xmlContext == null) {
                        resource.recordLocation(Location.create((File)this.context.file));
                    } else {
                        Attr attribute;
                        if (node instanceof Element && (attribute = ((Element)node).getAttributeNode("name")) != null) {
                            node = attribute;
                        }
                        resource.recordLocation(this.xmlContext.getLocation(node));
                    }
                }
                if (type == ResourceType.RAW && UnusedResourceDetectorUsageModel.isKeepFile(name, this.xmlContext)) {
                    resource.setReachable(true);
                }
            }
            return resource;
        }

        private static boolean isKeepFile(String name, XmlContext xmlContext) {
            Element element;
            if ("keep".equals(name)) {
                return true;
            }
            if (xmlContext != null && xmlContext.document != null && (element = xmlContext.document.getDocumentElement()) != null && element.getFirstChild() == null) {
                NamedNodeMap attributes = element.getAttributes();
                boolean found = false;
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    Node attr = attributes.item(i);
                    String nodeName = attr.getNodeName();
                    if (!nodeName.startsWith("xmlns:") && !nodeName.startsWith("tools")) {
                        return false;
                    }
                    if (!nodeName.endsWith("shrinkMode") && !nodeName.endsWith("discard") && !nodeName.endsWith("keep")) continue;
                    found = true;
                }
                return found;
            }
            return false;
        }
    }

    private static class LintResource
    extends ResourceUsageModel.Resource {
        public Location locations;

        public LintResource(ResourceType type, String name, int value) {
            super(type, name, value);
        }

        public void recordLocation(Location location) {
            Location oldLocation = this.locations;
            if (oldLocation != null) {
                location.setSecondary(oldLocation);
            }
            this.locations = location;
        }
    }
}

