/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastUtils;

public class WrongCallDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"WrongCall", (String)"Using wrong draw/layout method", (String)"Custom views typically need to call `measure()` on their children, not `onMeasure`. Ditto for onDraw, onLayout, etc.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(WrongCallDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("onDraw", "onMeasure", "onLayout");
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        String callName;
        UExpression operand = node.getReceiver();
        if (!(operand instanceof USuperExpression)) {
            WrongCallDetector.report(context, node, calledMethod);
            return;
        }
        PsiMethod method = (PsiMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (method != null && (callName = Lint.getMethodName((UCallExpression)node)) != null && !callName.equals(method.getName())) {
            WrongCallDetector.report(context, node, calledMethod);
        }
    }

    private static void report(JavaContext context, UCallExpression node, PsiMethod method) {
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
            return;
        }
        String name = method.getName();
        String suggestion = Character.toLowerCase(name.charAt(2)) + name.substring(3);
        String message2 = String.format("Suspicious method call; should probably call \"`%1$s`\" rather than \"`%2$s`\"", suggestion, name);
        LintFix fix = LintFix.create().name("Replace call with " + suggestion + "()").replace().text(name).with(suggestion).build();
        context.report(ISSUE, (UElement)node, context.getNameLocation((UElement)node), message2, fix);
    }
}

