/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class JavaPerformanceDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(JavaPerformanceDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue PAINT_ALLOC = Issue.create((String)"DrawAllocation", (String)"Memory allocations within drawing code", (String)"You should avoid allocating objects during a drawing or layout operation. These are called frequently, so a smooth UI can be interrupted by garbage collection pauses caused by the object allocations.\n\nThe way this is generally handled is to allocate the needed objects up front and to reuse them for each drawing operation.\n\nSome methods allocate memory on your behalf (such as `Bitmap.create`), and these should be handled in the same way.", (Category)Category.PERFORMANCE, (int)9, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue USE_SPARSE_ARRAY = Issue.create((String)"UseSparseArrays", (String)"HashMap can be replaced with SparseArray", (String)"For maps where the keys are of type integer, it's typically more efficient to use the Android `SparseArray` API. This check identifies scenarios where you might want to consider using `SparseArray` instead of `HashMap` for better performance.\n\nThis is **particularly** useful when the value types are primitives like ints, where you can use `SparseIntArray` and avoid auto-boxing the values from `int` to `Integer`.\n\nIf you need to construct a `HashMap` because you need to call an API outside of your control which requires a `Map`, you can suppress this warning using for example the `@SuppressLint` annotation.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue USE_VALUE_OF = Issue.create((String)"UseValueOf", (String)"Should use `valueOf` instead of `new`", (String)"You should not call the constructor for wrapper classes directly, such as`new Integer(42)`. Instead, call the `valueOf` factory method, such as `Integer.valueOf(42)`. This will typically use less memory because common integers such as 0 and 1 will share a single instance.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    static final String ON_MEASURE = "onMeasure";
    static final String ON_DRAW = "onDraw";
    static final String ON_LAYOUT = "onLayout";
    private static final String LAYOUT = "layout";
    private static final String HASH_MAP = "java.util.HashMap";
    private static final String SPARSE_ARRAY = "android.util.SparseArray";
    public static final String CLASS_CANVAS = "android.graphics.Canvas";

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(3);
        types.add(UCallExpression.class);
        types.add(UMethod.class);
        return types;
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new PerformanceVisitor(context);
    }

    private static String getUseValueOfErrorMessage(String typeName, String argument) {
        return String.format("Use `%1$s.valueOf(%2$s)` instead", typeName.substring(typeName.lastIndexOf(46) + 1), argument);
    }

    private static class AssignmentTracker
    extends AbstractUastVisitor {
        private final Collection<String> mVariables;

        public AssignmentTracker(Collection<String> variables) {
            this.mVariables = variables;
        }

        public boolean visitBinaryExpression(UBinaryExpression node) {
            if (UastExpressionUtils.isAssignment((UElement)node)) {
                UExpression left = node.getLeftOperand();
                if (left instanceof UQualifiedReferenceExpression) {
                    UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)left;
                    if (ref.getReceiver() instanceof UThisExpression || ref.getReceiver() instanceof USuperExpression) {
                        PsiElement resolved = ref.resolve();
                        if (resolved instanceof PsiField) {
                            this.mVariables.add(((PsiField)resolved).getName());
                        }
                    } else {
                        PsiElement resolved = ref.resolve();
                        if (resolved instanceof PsiField) {
                            this.mVariables.add(((PsiField)resolved).getName());
                        }
                    }
                } else if (left instanceof USimpleNameReferenceExpression) {
                    this.mVariables.add(((USimpleNameReferenceExpression)left).getIdentifier());
                }
            }
            return super.visitBinaryExpression(node);
        }
    }

    private static class PerformanceVisitor
    extends UElementHandler {
        private final JavaContext mContext;
        private final boolean mCheckMaps;
        private final boolean mCheckAllocations;
        private final boolean mCheckValueOf;
        private boolean mFlagAllocations;

        public PerformanceVisitor(JavaContext context) {
            this.mContext = context;
            this.mCheckAllocations = context.isEnabled(PAINT_ALLOC);
            this.mCheckMaps = context.isEnabled(USE_SPARSE_ARRAY);
            this.mCheckValueOf = context.isEnabled(USE_VALUE_OF);
        }

        public void visitMethod(UMethod node) {
            this.mFlagAllocations = this.isBlockedAllocationMethod((PsiMethod)node);
        }

        public void visitCallExpression(UCallExpression node) {
            UastCallKind kind = node.getKind();
            if (kind == UastCallKind.CONSTRUCTOR_CALL || kind == UastCallKind.NEW_ARRAY_WITH_DIMENSIONS || kind == UastCallKind.NEW_ARRAY_WITH_INITIALIZER) {
                this.visitConstructorCallExpression(node, kind != UastCallKind.CONSTRUCTOR_CALL);
            } else if (UastExpressionUtils.isMethodCall((UElement)node)) {
                this.visitMethodCallExpression(node);
            }
        }

        private void visitConstructorCallExpression(UCallExpression node, boolean isArray) {
            UMethod method;
            String typeName = null;
            UReferenceExpression classReference = node.getClassReference();
            if ((this.mCheckMaps || this.mCheckValueOf) && classReference != null) {
                typeName = UastUtils.getQualifiedName((UReferenceExpression)classReference);
            }
            if (!isArray && this.mCheckMaps) {
                if (JavaPerformanceDetector.HASH_MAP.equals(typeName)) {
                    this.checkHashMap(node);
                } else if (JavaPerformanceDetector.SPARSE_ARRAY.equals(typeName)) {
                    this.checkSparseArray(node);
                }
            }
            if (!isArray && this.mCheckValueOf && typeName != null && (typeName.equals("java.lang.Integer") || typeName.equals("java.lang.Boolean") || typeName.equals("java.lang.Float") || typeName.equals("java.lang.Character") || typeName.equals("java.lang.Long") || typeName.equals("java.lang.Double") || typeName.equals("java.lang.Byte")) && node.getValueArgumentCount() == 1) {
                String argument = ((UExpression)node.getValueArguments().get(0)).asSourceString();
                String replacedType = typeName.substring(typeName.lastIndexOf(46) + 1);
                LintFix fix = LintFix.create().name("Replace with valueOf()", true).replace().pattern("(new\\s+" + replacedType + ")").with(replacedType + ".valueOf").autoFix().build();
                this.mContext.report(USE_VALUE_OF, (UElement)node, this.mContext.getLocation((UElement)node), JavaPerformanceDetector.getUseValueOfErrorMessage(typeName, argument), fix);
            }
            if (this.mFlagAllocations && !(Lint.skipParentheses((UElement)node.getUastParent()) instanceof UThrowExpression) && this.mCheckAllocations && (method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class)) != null && this.isBlockedAllocationMethod((PsiMethod)method) && !PerformanceVisitor.isLazilyInitialized((UElement)node)) {
                this.reportAllocation(node);
            }
        }

        private void reportAllocation(UCallExpression node) {
            Location location = this.mContext.getLocation((UElement)node);
            this.mContext.report(PAINT_ALLOC, (UElement)node, location, "Avoid object allocations during draw/layout operations (preallocate and reuse instead)");
        }

        private void visitMethodCallExpression(UCallExpression node) {
            if (!this.mFlagAllocations) {
                return;
            }
            UExpression receiver = node.getReceiver();
            if (receiver == null) {
                return;
            }
            String functionName = Lint.getMethodName((UCallExpression)node);
            if (functionName == null) {
                return;
            }
            if (functionName.equals("createBitmap") || functionName.equals("createScaledBitmap")) {
                PsiMethod method = node.resolve();
                if (method != null && this.mContext.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Bitmap") && !PerformanceVisitor.isLazilyInitialized((UElement)node)) {
                    this.reportAllocation(node);
                }
            } else if (functionName.startsWith("decode")) {
                PsiMethod method = node.resolve();
                if (method != null && this.mContext.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.BitmapFactory") && !PerformanceVisitor.isLazilyInitialized((UElement)node)) {
                    this.reportAllocation(node);
                }
            } else if (functionName.equals("getClipBounds") && node.getValueArgumentCount() == 0) {
                Location callLocation = this.mContext.getLocation((UElement)node);
                this.mContext.report(PAINT_ALLOC, (UElement)node, callLocation, "Avoid object allocations during draw operations: Use `Canvas.getClipBounds(Rect)` instead of `Canvas.getClipBounds()` which allocates a temporary `Rect`");
            }
        }

        private static boolean isLazilyInitialized(UElement node) {
            for (UElement curr = node.getUastParent(); curr != null; curr = curr.getUastParent()) {
                if (curr instanceof UMethod) {
                    return false;
                }
                if (!(curr instanceof UIfExpression)) continue;
                UIfExpression ifNode = (UIfExpression)curr;
                ArrayList<String> assignments = new ArrayList<String>();
                AssignmentTracker visitor = new AssignmentTracker(assignments);
                if (ifNode.getThenExpression() != null) {
                    ifNode.getThenExpression().accept((UastVisitor)visitor);
                }
                if (!assignments.isEmpty()) {
                    ArrayList<String> references = new ArrayList<String>();
                    PerformanceVisitor.addReferencedVariables(references, ifNode.getCondition());
                    if (!references.isEmpty()) {
                        Sets.SetView intersection = Sets.intersection(new HashSet<String>(assignments), new HashSet<String>(references));
                        return !intersection.isEmpty();
                    }
                }
                return false;
            }
            return false;
        }

        private static void addReferencedVariables(Collection<String> variables, UExpression expression) {
            if (expression instanceof UPolyadicExpression) {
                UPolyadicExpression polyadicExpression = (UPolyadicExpression)expression;
                for (UExpression operand : polyadicExpression.getOperands()) {
                    PerformanceVisitor.addReferencedVariables(variables, operand);
                }
            } else if (expression instanceof UPrefixExpression) {
                UPrefixExpression unary = (UPrefixExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, unary.getOperand());
            } else if (expression instanceof UUnaryExpression) {
                UUnaryExpression unary = (UUnaryExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, unary.getOperand());
            } else if (expression instanceof UParenthesizedExpression) {
                UParenthesizedExpression exp = (UParenthesizedExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, exp.getExpression());
            } else if (expression instanceof USimpleNameReferenceExpression) {
                USimpleNameReferenceExpression reference = (USimpleNameReferenceExpression)expression;
                variables.add(reference.getIdentifier());
            } else if (expression instanceof UQualifiedReferenceExpression) {
                UQualifiedReferenceExpression ref = (UQualifiedReferenceExpression)expression;
                UExpression receiver = ref.getReceiver();
                UExpression selector = ref.getSelector();
                if (receiver instanceof UThisExpression || receiver instanceof USuperExpression) {
                    String identifier;
                    String string = identifier = selector instanceof USimpleNameReferenceExpression ? ((USimpleNameReferenceExpression)selector).getIdentifier() : null;
                    if (identifier != null) {
                        variables.add(identifier);
                    }
                }
            }
        }

        private boolean isBlockedAllocationMethod(PsiMethod node) {
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            return PerformanceVisitor.isOnDrawMethod(evaluator, node) || PerformanceVisitor.isOnMeasureMethod(evaluator, node) || PerformanceVisitor.isOnLayoutMethod(evaluator, node) || PerformanceVisitor.isLayoutMethod(evaluator, node);
        }

        private static boolean isOnDrawMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.ON_DRAW.equals(node.getName()) && evaluator.parametersMatch(node, new String[]{JavaPerformanceDetector.CLASS_CANVAS});
        }

        private static boolean isOnLayoutMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.ON_LAYOUT.equals(node.getName()) && evaluator.parametersMatch(node, new String[]{"boolean", "int", "int", "int", "int"});
        }

        private static boolean isOnMeasureMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.ON_MEASURE.equals(node.getName()) && evaluator.parametersMatch(node, new String[]{"int", "int"});
        }

        private static boolean isLayoutMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.LAYOUT.equals(node.getName()) && evaluator.parametersMatch(node, new String[]{"int", "int", "int", "int"});
        }

        private void checkHashMap(UCallExpression node) {
            if (!this.mContext.getProject().isAndroidProject()) {
                return;
            }
            List types = node.getTypeArguments();
            if (types.size() == 2) {
                PsiType first = (PsiType)types.get(0);
                String typeName = first.getCanonicalText();
                int minSdk = this.mContext.getMainProject().getMinSdk();
                if ("java.lang.Integer".equals(typeName) || "java.lang.Byte".equals(typeName)) {
                    String valueType = ((PsiType)types.get(1)).getCanonicalText();
                    if (valueType.equals("java.lang.Integer")) {
                        this.mContext.report(USE_SPARSE_ARRAY, (UElement)node, this.mContext.getLocation((UElement)node), "Use new `SparseIntArray(...)` instead for better performance");
                    } else if (valueType.equals("java.lang.Long") && minSdk >= 18) {
                        this.mContext.report(USE_SPARSE_ARRAY, (UElement)node, this.mContext.getLocation((UElement)node), "Use `new SparseLongArray(...)` instead for better performance");
                    } else if (valueType.equals("java.lang.Boolean")) {
                        this.mContext.report(USE_SPARSE_ARRAY, (UElement)node, this.mContext.getLocation((UElement)node), "Use `new SparseBooleanArray(...)` instead for better performance");
                    } else {
                        this.mContext.report(USE_SPARSE_ARRAY, (UElement)node, this.mContext.getLocation((UElement)node), String.format("Use `new SparseArray<%1$s>(...)` instead for better performance", valueType.substring(valueType.lastIndexOf(46) + 1)));
                    }
                } else if ("java.lang.Long".equals(typeName) && (minSdk >= 16 || Boolean.TRUE == this.mContext.getMainProject().dependsOn("com.android.support:support-v4"))) {
                    boolean useBuiltin = minSdk >= 16;
                    String message2 = useBuiltin ? "Use `new LongSparseArray(...)` instead for better performance" : "Use `new android.support.v4.util.LongSparseArray(...)` instead for better performance";
                    this.mContext.report(USE_SPARSE_ARRAY, (UElement)node, this.mContext.getLocation((UElement)node), message2);
                }
            }
        }

        private void checkSparseArray(UCallExpression node) {
            List types = node.getTypeArguments();
            if (types.size() == 1) {
                String valueType = ((PsiType)types.get(0)).getCanonicalText();
                if (valueType.equals("java.lang.Integer")) {
                    this.mContext.report(USE_SPARSE_ARRAY, (UElement)node, this.mContext.getLocation((UElement)node), "Use `new SparseIntArray(...)` instead for better performance");
                } else if (valueType.equals("java.lang.Boolean")) {
                    this.mContext.report(USE_SPARSE_ARRAY, (UElement)node, this.mContext.getLocation((UElement)node), "Use `new SparseBooleanArray(...)` instead for better performance");
                }
            }
        }
    }
}

