/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;

public class FragmentDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue ISSUE = Issue.create((String)"ValidFragment", (String)"Fragment not instantiatable", (String)"From the Fragment documentation:\n**Every** fragment must have an empty constructor, so it can be instantiated when restoring its activity's state. It is strongly recommended that subclasses do not have other constructors with parameters, since these constructors will not be called when the fragment is re-instantiated; instead, arguments can be supplied by the caller with `setArguments(Bundle)` and later retrieved by the Fragment with `getArguments()`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(FragmentDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/app/Fragment.html#Fragment()").setAndroidSpecific(true);

    public List<String> applicableSuperClasses() {
        return Arrays.asList("android.app.Fragment", SdkConstants.CLASS_V4_FRAGMENT.oldName(), SdkConstants.CLASS_V4_FRAGMENT.newName());
    }

    public void visitClass(JavaContext context, UClass node) {
        if (node instanceof UAnonymousClass) {
            String message2 = "Fragments should be static such that they can be re-instantiated by the system, and anonymous classes are not static";
            context.report(ISSUE, node, context.getNameLocation(node), message2);
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)node)) {
            return;
        }
        if (!evaluator.isPublic((PsiModifierListOwner)node)) {
            String message3 = String.format("This fragment class should be public (%1$s)", node.getQualifiedName());
            context.report(ISSUE, node, context.getNameLocation(node), message3);
            return;
        }
        if (node.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)node)) {
            String message4 = String.format("This fragment inner class should be static (%1$s)", node.getQualifiedName());
            context.report(ISSUE, node, context.getNameLocation(node), message4);
            return;
        }
        boolean hasDefaultConstructor = false;
        boolean hasConstructor = false;
        for (PsiMethod constructor : node.getConstructors()) {
            Location location;
            hasConstructor = true;
            if (constructor.getParameterList().getParametersCount() == 0) {
                if (evaluator.isPublic((PsiModifierListOwner)constructor)) {
                    hasDefaultConstructor = true;
                    continue;
                }
                location = context.getNameLocation((PsiElement)constructor);
                context.report(ISSUE, (PsiElement)constructor, location, "The default constructor must be public");
                hasDefaultConstructor = true;
                continue;
            }
            location = context.getNameLocation((PsiElement)constructor);
            String message5 = "Avoid non-default constructors in fragments: use a default constructor plus `Fragment#setArguments(Bundle)` instead";
            context.report(ISSUE, (PsiElement)constructor, location, message5);
        }
        if (!hasDefaultConstructor && hasConstructor) {
            String message6 = String.format("This fragment should provide a default constructor (a public constructor with no arguments) (`%1$s`)", node.getQualifiedName());
            context.report(ISSUE, node, context.getNameLocation(node), message6);
        }
    }
}

