/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.checks.ApiParser;
import com.android.utils.XmlUtils;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Api {
    private final Map<String, ApiClass> mClasses;
    private final Map<String, ApiClassOwner> mContainers;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Api parseApi(File apiFile) {
        try (FileInputStream inputStream = new FileInputStream(apiFile);){
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            XmlUtils.configureSaxFactory((SAXParserFactory)parserFactory, (boolean)false, (boolean)false);
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)parserFactory);
            ApiParser apiParser = new ApiParser();
            parser.parse((InputStream)inputStream, (DefaultHandler)apiParser);
            ((InputStream)inputStream).close();
            Api api = new Api(apiParser.getClasses(), apiParser.getContainers());
            return api;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private Api(Map<String, ApiClass> classes, Map<String, ApiClassOwner> containers) {
        this.mClasses = Collections.unmodifiableMap(new MyHashMap<ApiClass>(classes));
        this.mContainers = Collections.unmodifiableMap(new MyHashMap<ApiClassOwner>(containers));
    }

    ApiClass getClass(String fqcn) {
        return this.mClasses.get(fqcn);
    }

    Map<String, ApiClass> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiClassOwner> getContainers() {
        return this.mContainers;
    }

    private static class MyHashMap<V>
    extends THashMap<String, V> {
        private static final TObjectHashingStrategy<String> myHashingStrategy = new TObjectHashingStrategy<String>(){

            public int computeHashCode(String str) {
                int h = 0;
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    c = MyHashMap.normalizeSeparator(c);
                    h = 31 * h + c;
                }
                return h;
            }

            public boolean equals(String s1, String s2) {
                if (s1.length() != s2.length()) {
                    return false;
                }
                for (int i = 0; i < s1.length(); ++i) {
                    if (MyHashMap.normalizeSeparator(s1.charAt(i)) == MyHashMap.normalizeSeparator(s2.charAt(i))) continue;
                    return false;
                }
                return true;
            }
        };

        private static char normalizeSeparator(char c) {
            if (c == '/' || c == '$') {
                c = (char)46;
            }
            return c;
        }

        MyHashMap(Map<String, V> data) {
            super(data, myHashingStrategy);
        }
    }
}

