/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R,\u0010\u0003\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/StringCasingDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "allStrings", "Ljava/util/HashMap;", "Lcom/android/utils/Pair;", "", "", "Lcom/android/tools/lint/checks/StringCasingDetector$StringDeclaration;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkTextNode", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "text", "getApplicableElements", "", "visitElement", "Companion", "StringDeclaration", "lint-checks"})
public final class StringCasingDetector
extends ResourceXmlDetector {
    private final HashMap<Pair<String, String>, List<StringDeclaration>> allStrings = new HashMap();
    private static final Implementation IMPLEMENTATION_XML;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_STRINGS;
    public static final Companion Companion;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"string");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        NodeList childNodes;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        NodeList nodeList = childNodes = element.getChildNodes();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
        if (nodeList.getLength() > 0) {
            if (childNodes.getLength() == 1) {
                Node child;
                Node node = child = childNodes.item(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"child");
                if (node.getNodeType() == 3) {
                    String string = StringFormatDetector.stripQuotes(child.getNodeValue());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringFormatDetector.stripQuotes(child.nodeValue)");
                    this.checkTextNode(context, element, string);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                StringFormatDetector.addText(sb, element);
                CharSequence charSequence = sb;
                if (charSequence.length() > 0) {
                    String string = sb.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
                    this.checkTextNode(context, element, string);
                }
            }
        }
    }

    private final void checkTextNode(XmlContext context, Element element, String text) {
        Pair pair;
        String string;
        String string2;
        Locale locale;
        String string3;
        if (Intrinsics.areEqual((Object)"false", (Object)element.getAttribute("translatable"))) {
            return;
        }
        LocaleQualifier locale2 = Lint.getLocale((XmlContext)context);
        if (locale2 != null) {
            String string4 = locale2.getFull();
            string3 = text;
            Locale locale3 = Locale.forLanguageTag(locale2.getTag());
            Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.forLanguageTag(locale.tag)");
            locale = locale3;
            string2 = string4;
            String string5 = string3;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = string6;
            pair = Pair.of((Object)string2, (Object)string);
        } else {
            string3 = text;
            Locale locale4 = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.US");
            locale = locale4;
            string2 = "default";
            String string7 = string3;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = string8;
            pair = Pair.of((Object)string2, (Object)string);
        }
        Pair key = pair;
        Location.Handle handle = context.createLocationHandle((Node)element);
        handle.setClientData((Object)element);
        ArrayList arrayList = this.allStrings.getOrDefault(key, new ArrayList());
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"allStrings.getOrDefault(key, ArrayList())");
        List handleList = arrayList;
        String string9 = element.getAttribute("name");
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"element.getAttribute(ATTR_NAME)");
        handleList.add(new StringDeclaration(string9, text, handle));
        Map map = this.allStrings;
        Pair pair2 = key;
        Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"key");
        Pair pair3 = pair2;
        List list = handleList;
        map.put(pair3, list);
    }

    /*
     * WARNING - void declaration
     */
    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Map map = this.allStrings;
        for (Map.Entry entry : map.entrySet()) {
            void $receiver$iv$iv;
            Object string;
            Map.Entry entry2 = entry;
            List duplicates = (List)entry2.getValue();
            if (duplicates.size() <= 1) continue;
            Location firstLocation = null;
            Location prevLocation = null;
            Object prevString = "";
            boolean caseVaries = false;
            List names = new ArrayList();
            for (StringDeclaration duplicate : duplicates) {
                names.add(duplicate.getName());
                string = duplicate.getText();
                Location location = duplicate.getLocation().resolve();
                if (prevLocation == null) {
                    firstLocation = location;
                } else {
                    prevLocation.setSecondary(location);
                    location.setMessage("Duplicates value in `" + (String)names.get(0) + '`');
                    location.setSelfExplanatory(false);
                    if (Intrinsics.areEqual((Object)string, (Object)prevString) ^ true) {
                        caseVaries = true;
                        Location location2 = location;
                        location2.setMessage(Intrinsics.stringPlus((String)location2.getMessage(), (Object)" (case varies, but you can use `android:inputType` or `android:capitalize` in the presentation)"));
                    }
                }
                prevLocation = location;
                prevString = string;
            }
            if (firstLocation == null) {
                continue;
            }
            Iterable $receiver$iv = names;
            string = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = '`' + (String)it + '`';
                collection.add(string3);
            }
            String nameList = Lint.formatList$default((List)((List)destination$iv$iv), (int)0, (boolean)false, (boolean)true, (int)6, null);
            String message2 = "Duplicate string value `" + (String)prevString + "`, used in " + nameList;
            if (caseVaries) {
                message2 = message2 + ". Use `android:inputType` or `android:capitalize` to treat these as the same and avoid string duplication.";
            }
            Context.report$default((Context)context, (Issue)DUPLICATE_STRINGS, (Location)firstLocation, (String)message2, null, (int)8, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION_XML = new Implementation(StringCasingDetector.class, Scope.ALL_RESOURCES_SCOPE);
        DUPLICATE_STRINGS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DuplicateStrings", (String)"Duplicate Strings", (String)"\n                Duplicate strings can make applications larger unnecessarily.\n\n                This lint check looks for duplicate strings, including differences for strings \\\n                where the only difference is in capitalization. Title casing and all uppercase can \\\n                all be adjusted in the layout or in code.\n                ", (Implementation)IMPLEMENTATION_XML, (String)"https://developer.android.com/reference/android/widget/TextView.html#attr_android:inputType", (Category)Category.APP_SIZE, (int)2, (Severity)Severity.WARNING, (boolean)false, null, null, null, (int)3584, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/StringCasingDetector$StringDeclaration;", "", "name", "", "text", "location", "Lcom/android/tools/lint/detector/api/Location$Handle;", "(Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location$Handle;)V", "getLocation", "()Lcom/android/tools/lint/detector/api/Location$Handle;", "getName", "()Ljava/lang/String;", "getText", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-checks"})
    public static final class StringDeclaration {
        @NotNull
        private final String name;
        @NotNull
        private final String text;
        @NotNull
        private final Location.Handle location;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Location.Handle getLocation() {
            return this.location;
        }

        public StringDeclaration(@NotNull String name, @NotNull String text, @NotNull Location.Handle location) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            this.name = name;
            this.text = text;
            this.location = location;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final Location.Handle component3() {
            return this.location;
        }

        @NotNull
        public final StringDeclaration copy(@NotNull String name, @NotNull String text, @NotNull Location.Handle location) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            return new StringDeclaration(name, text, location);
        }

        @NotNull
        public static /* synthetic */ StringDeclaration copy$default(StringDeclaration stringDeclaration, String string, String string2, Location.Handle handle, int n, Object object) {
            if ((n & 1) != 0) {
                string = stringDeclaration.name;
            }
            if ((n & 2) != 0) {
                string2 = stringDeclaration.text;
            }
            if ((n & 4) != 0) {
                handle = stringDeclaration.location;
            }
            return stringDeclaration.copy(string, string2, handle);
        }

        @NotNull
        public String toString() {
            return "StringDeclaration(name=" + this.name + ", text=" + this.text + ", location=" + this.location + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.text;
            Location.Handle handle = this.location;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (handle != null ? handle.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StringDeclaration)) break block3;
                    StringDeclaration stringDeclaration = (StringDeclaration)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)stringDeclaration.name) || !Intrinsics.areEqual((Object)this.text, (Object)stringDeclaration.text) || !Intrinsics.areEqual((Object)this.location, (Object)stringDeclaration.location)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/StringCasingDetector$Companion;", "", "()V", "DUPLICATE_STRINGS", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION_XML", "Lcom/android/tools/lint/detector/api/Implementation;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

