/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0001>B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016Jb\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020\u0012H\u0002J \u0010%\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J*\u0010)\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010,\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010-H\u0016J\u0010\u0010.\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001dH\u0016J&\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u0002002\u0006\u00101\u001a\u00020\u0006H\u0002J \u00102\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010-2\u0006\u0010\u0016\u001a\u0002002\u0006\u00103\u001a\u00020#H\u0014J \u00104\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00105\u001a\u0002062\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0018\u00107\u001a\u00020\r2\u0006\u0010\u0016\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J \u0010;\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020'2\u0006\u0010<\u001a\u00020=H\u0016R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/lint/checks/ViewTypeDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "fileIdMap", "", "Lcom/android/ide/common/util/PathString;", "Lcom/google/common/collect/Multimap;", "", "idToViewTag", "Ljava/util/HashMap;", "", "addTags", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "map", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkCompatible", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "castType", "Lcom/intellij/psi/PsiClassType;", "castTypeClass", "tag", "tags", "", "node", "Lorg/jetbrains/uast/UElement;", "resourceReference", "Lorg/jetbrains/uast/UExpression;", "items", "Lcom/android/ide/common/resources/ResourceItem;", "findView", "checkMissingCast", "findViewByIdCall", "Lorg/jetbrains/uast/UCallExpression;", "surroundingCall", "createSecondary", "Lcom/android/tools/lint/detector/api/Location;", "sampleLayout", "getApplicableAttributes", "", "getApplicableMethodNames", "getIdToTagsIn", "Lcom/android/tools/lint/detector/api/Context;", "file", "getViewTags", "item", "isCompatible", "castClass", "Lcom/intellij/psi/PsiClass;", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public class ViewTypeDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private final HashMap<String, Object> idToViewTag = new HashMap(50);
    private Map<PathString, Multimap<String, String>> fileIdMap;
    @JvmField
    @NotNull
    public static final Issue WRONG_VIEW_CAST;
    @JvmField
    @NotNull
    public static final Issue ADD_CAST;
    @NotNull
    public static final String FIND_VIEW_BY_ID = "findViewById";
    @NotNull
    public static final String REQUIRE_VIEW_BY_ID = "requireViewById";
    @NotNull
    public static final String FIND_FRAGMENT_BY_TAG = "findFragmentByTag";
    private static final String TAG_NAME_PREFIX = ":tag:";
    public static final Companion Companion;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT;
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return Arrays.asList("id", "tag");
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        List list;
        String string;
        int n;
        String string2;
        String value;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        String string3 = value = attribute.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"value");
        if (StringsKt.startsWith$default((String)string3, (String)"@id/", (boolean)false, (int)2, null)) {
            string2 = value;
            n = "@id/".length();
            String string4 = string2.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null)) {
            string2 = value;
            n = "@+id/".length();
            String string5 = string2.substring(n);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (Intrinsics.areEqual((Object)"tag", (Object)attribute.getLocalName())) {
            string = TAG_NAME_PREFIX + value;
        } else {
            return;
        }
        String id = string;
        ViewTypeDetector viewTypeDetector = this;
        Object $receiver = viewTypeDetector;
        boolean bl2 = false;
        Element element = attribute.getOwnerElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"attribute.ownerElement");
        String cls = element.getTagName();
        if (Intrinsics.areEqual((Object)cls, (Object)"view")) {
            cls = attribute.getOwnerElement().getAttribute("class");
        } else if (Intrinsics.areEqual((Object)cls, (Object)"fragment")) {
            if (Intrinsics.areEqual((Object)"tag", (Object)attribute.getLocalName()) ^ true) {
                return;
            }
            cls = attribute.getOwnerElement().getAttribute("class");
        }
        String string6 = cls;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"cls");
        cls = StringsKt.replace$default((String)string6, (char)'$', (char)'.', (boolean)false, (int)4, null);
        Object object = cls;
        if (object.length() == 0) {
            return;
        }
        String view = cls;
        Object existing = this.idToViewTag.get(id);
        if (existing == null) {
            $receiver = this.idToViewTag;
            String string7 = view;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"view");
            String bl2 = string7;
            $receiver.put(id, bl2);
        } else if (existing instanceof String) {
            String existingString = (String)existing;
            if (Intrinsics.areEqual((Object)existingString, (Object)view) ^ true) {
                ArrayList<Object> list2 = new ArrayList<Object>(2);
                list2.add(existing);
                list2.add(view);
                Map map = this.idToViewTag;
                object = list2;
                map.put(id, object);
            }
        } else if (TypeIntrinsics.isMutableList((Object)existing) && !(list = TypeIntrinsics.asMutableList((Object)existing)).contains(view)) {
            String string8 = view;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"view");
            list.add(string8);
        }
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList(FIND_VIEW_BY_ID, REQUIRE_VIEW_BY_ID, FIND_FRAGMENT_BY_TAG);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        UElement variable;
        PsiClassType type;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        LintClient client = context.getClient();
        UElement uElement = Lint.skipParentheses((UElement)((UElement)node));
        if (uElement == null) {
            return;
        }
        UElement current = uElement;
        UElement parent = current.getUastParent();
        UElement errorNode = null;
        PsiClassType castType = null;
        UElement uElement2 = parent;
        if (uElement2 instanceof UBinaryExpressionWithType) {
            UElement cast = parent;
            PsiType psiType = ((UBinaryExpressionWithType)cast).getType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            PsiClassType psiClassType = (PsiClassType)psiType;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = cast;
        } else if (uElement2 instanceof UExpression) {
            UElement uElement3;
            if (parent instanceof UCallExpression) {
                UElement c = parent;
                this.checkMissingCast(context, node, (UCallExpression)c);
                return;
            }
            if (parent instanceof UQualifiedReferenceExpression) {
                UElement ref = parent;
                if (((UQualifiedReferenceExpression)ref).getSelector() != current) {
                    return;
                }
                if (!((parent = parent.getUastParent()) instanceof UBinaryExpressionWithType)) {
                    return;
                }
            }
            if (!((uElement3 = parent) instanceof UExpression)) {
                uElement3 = null;
            }
            UExpression uExpression = (UExpression)uElement3;
            if (uExpression == null) {
                return;
            }
            variable = uExpression;
            PsiType psiType = variable.getExpressionType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            PsiClassType psiClassType = (PsiClassType)psiType;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = parent;
        } else if (uElement2 instanceof UVariable) {
            variable = parent;
            PsiType psiType = ((UVariable)variable).getType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            PsiClassType psiClassType = (PsiClassType)psiType;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = parent;
        } else {
            return;
        }
        String string = castType.getCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"castType.canonicalText");
        String castTypeClass = string;
        if (Intrinsics.areEqual((Object)castTypeClass, (Object)"android.view.View") || Intrinsics.areEqual((Object)castTypeClass, (Object)"kotlin.Unit") || Intrinsics.areEqual((Object)castTypeClass, (Object)"android.app.Fragment") || Intrinsics.areEqual((Object)castTypeClass, (Object)"android.support.v4.app.Fragment") || Intrinsics.areEqual((Object)castTypeClass, (Object)"androidx.fragment.app.Fragment")) {
            return;
        }
        String methodName = node.getMethodName();
        boolean findView = Intrinsics.areEqual((Object)FIND_VIEW_BY_ID, (Object)methodName) || Intrinsics.areEqual((Object)REQUIRE_VIEW_BY_ID, (Object)methodName);
        boolean findTag = !findView && Intrinsics.areEqual((Object)FIND_FRAGMENT_BY_TAG, (Object)methodName);
        List args = node.getValueArguments();
        if (args.size() == 1) {
            UExpression first = (UExpression)args.get(0);
            String tag = null;
            String id = null;
            if (findTag) {
                String string2 = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)first), (boolean)false);
                if (string2 == null) {
                    return;
                }
                tag = string2;
                tag = TAG_NAME_PREFIX + tag;
            } else {
                ResourceUrl resourceUrl = ResourceEvaluator.getResource((JavaEvaluator)context.getEvaluator(), (UElement)((UElement)first));
                if (resourceUrl != null && resourceUrl.type == ResourceType.ID && !resourceUrl.isFramework()) {
                    id = resourceUrl.name;
                }
            }
            if (id != null || tag != null) {
                if (id != null && client.supportsProjectResources()) {
                    ResourceRepository resourceRepository = client.getResourceRepository(context.getMainProject(), true, false);
                    if (resourceRepository == null) {
                        return;
                    }
                    ResourceRepository resources = resourceRepository;
                    List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ID, id);
                    if (!items.isEmpty()) {
                        HashSet<String> compatible = new HashSet<String>();
                        for (ResourceItem item : items) {
                            Context context2 = (Context)context;
                            ResourceItem resourceItem = item;
                            Intrinsics.checkExpressionValueIsNotNull((Object)resourceItem, (String)"item");
                            Collection<String> tags = this.getViewTags(context2, resourceItem);
                            if (tags == null) continue;
                            compatible.addAll(tags);
                        }
                        if (!compatible.isEmpty()) {
                            ArrayList layoutTypes = new ArrayList(compatible);
                            this.checkCompatible(context, castType, castTypeClass, null, layoutTypes, errorNode, first, items, findView);
                        }
                    }
                } else {
                    Map items = this.idToViewTag;
                    String string3 = id != null ? id : tag;
                    Object types = items.get(string3);
                    if (types instanceof String) {
                        this.checkCompatible(context, castType, castTypeClass, (String)types, null, errorNode, first, null, findView);
                    } else if (types instanceof List) {
                        List layoutTypes = (List)types;
                        this.checkCompatible(context, castType, castTypeClass, null, layoutTypes, errorNode, first, null, findView);
                    }
                }
            }
        }
    }

    private final void checkMissingCast(JavaContext context, UCallExpression findViewByIdCall, UCallExpression surroundingCall) {
        LanguageLevel languageLevel = Lint.getLanguageLevel((UElement)((UElement)surroundingCall), (LanguageLevel)LanguageLevel.JDK_1_7);
        if (languageLevel.isLessThan(LanguageLevel.JDK_1_8)) {
            return;
        }
        UElement uElement = surroundingCall.getUastParent();
        if (!(uElement instanceof UQualifiedReferenceExpression)) {
            uElement = null;
        }
        if ((UQualifiedReferenceExpression)uElement == null) {
            return;
        }
        List valueArguments = surroundingCall.getValueArguments();
        int parameterIndex = -1;
        int n = valueArguments.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)findViewByIdCall, (Object)((UExpression)valueArguments.get(i)))) continue;
            parameterIndex = i;
        }
        if (parameterIndex == -1) {
            return;
        }
        PsiMethod psiMethod = surroundingCall.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod resolvedMethod = psiMethod;
        PsiParameterList psiParameterList = resolvedMethod.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"resolvedMethod.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"resolvedMethod.parameterList.parameters");
        PsiParameter[] parameters = psiParameterArray;
        if (parameterIndex >= parameters.length) {
            return;
        }
        PsiParameter psiParameter = parameters[parameterIndex];
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"parameters[parameterIndex]");
        PsiType psiType = psiParameter.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) {
            return;
        }
        PsiClassType parameterType = psiClassType;
        PsiClass psiClass = parameterType.resolve();
        if (!(psiClass instanceof PsiTypeParameter)) {
            psiClass = null;
        }
        if ((PsiTypeParameter)psiClass == null) {
            return;
        }
        PsiType erasure = TypeConversionUtil.erasure((PsiType)((PsiType)parameterType));
        if (erasure == null || Intrinsics.areEqual((Object)erasure.getCanonicalText(), (Object)"android.view.View")) {
            return;
        }
        PsiType psiType2 = resolvedMethod.getReturnType();
        if (!(psiType2 instanceof PsiClassType)) {
            psiType2 = null;
        }
        PsiClassType psiClassType2 = (PsiClassType)psiType2;
        if (psiClassType2 == null) {
            return;
        }
        PsiClassType returnType = psiClassType2;
        if (!(returnType.resolve() instanceof PsiTypeParameter)) {
            return;
        }
        String string = findViewByIdCall.getMethodName();
        if (string == null) {
            return;
        }
        String callName = string;
        LintFix fix = LintFix.create().replace().name("Add cast").text(callName).shortenNames().reformat(true).with("(android.view.View)" + callName).build();
        context.report(ADD_CAST, context.getLocation((UElement)findViewByIdCall), "Add explicit cast here; won't compile with Java language level 1.8 without it", fix);
    }

    @Nullable
    protected Collection<String> getViewTags(@NotNull Context context, @NotNull ResourceItem item) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        PathString pathString = item.getSource();
        if (pathString == null) {
            return null;
        }
        PathString source = pathString;
        Multimap<String, String> multimap = this.getIdToTagsIn(context, source);
        if (multimap == null) {
            return null;
        }
        Multimap<String, String> map = multimap;
        return map.get((Object)item.getName());
    }

    private final Multimap<String, String> getIdToTagsIn(Context context, PathString file) {
        Object $receiver;
        if (!StringsKt.endsWith$default((String)file.getFileName(), (String)".xml", (boolean)false, (int)2, null)) {
            return null;
        }
        Map map = this.fileIdMap;
        if (map == null) {
            ViewTypeDetector viewTypeDetector = this;
            $receiver = viewTypeDetector;
            boolean bl = false;
            HashMap list = new HashMap();
            ((ViewTypeDetector)((Object)$receiver)).fileIdMap = list;
            map = list;
        }
        Map fileIdMap = map;
        Multimap map2 = fileIdMap.get(file);
        if (map2 == null) {
            map2 = (Multimap)ArrayListMultimap.create();
            $receiver = fileIdMap;
            Multimap multimap = map2;
            Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"map");
            Multimap multimap2 = multimap;
            $receiver.put(file, multimap2);
            try {
                XmlPullParser parser = context.getClient().createXmlPullParser(file);
                if (parser != null) {
                    this.addTags(parser, (Multimap<String, String>)map2);
                }
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return map2;
    }

    private final void addTags(XmlPullParser parser, Multimap<String, String> map) {
        while (true) {
            int event;
            if ((event = parser.next()) == 2) {
                String tag;
                CharSequence charSequence;
                String id = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                if (id == null || (charSequence = (CharSequence)id).length() == 0) continue;
                id = Lint.stripIdPrefix((String)id);
                if (parser.getName() == null) {
                    continue;
                }
                if (Intrinsics.areEqual((Object)tag, (Object)"view") || Intrinsics.areEqual((Object)tag, (Object)"fragment")) {
                    CharSequence charSequence2;
                    String string = parser.getAttributeValue(null, "class");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parser.getAttributeValue(null, ATTR_CLASS)");
                    tag = string;
                    if (tag == null || (charSequence2 = (CharSequence)tag).length() == 0) {
                        continue;
                    }
                } else if (Intrinsics.areEqual((Object)tag, (Object)"merge") || Intrinsics.areEqual((Object)tag, (Object)"include")) continue;
                if (map.containsEntry((Object)id, (Object)(tag = StringsKt.replace$default((String)tag, (char)'$', (char)'.', (boolean)false, (int)4, null)))) continue;
                map.put((Object)id, (Object)tag);
                continue;
            }
            if (event == 1) break;
        }
    }

    private final void checkCompatible(JavaContext context, PsiClassType castType, String castTypeClass, String tag, List<String> tags, UElement node, UExpression resourceReference, List<? extends ResourceItem> items, boolean findView) {
        String verb;
        boolean bl;
        boolean bl2 = bl = tag == null || tags == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string = tag;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            List<String> list = tags;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            String string2 = stringBuilder2.append(list).toString();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (Intrinsics.areEqual((Object)castTypeClass, (Object)tag) || tags != null && tags.contains(castTypeClass)) {
            return;
        }
        PsiClass castClass = castType.resolve();
        boolean compatible = true;
        if (findView) {
            if (tag != null) {
                if (Intrinsics.areEqual((Object)tag, (Object)castTypeClass) ^ true && !context.getSdkInfo().isSubViewOf(castTypeClass, tag)) {
                    compatible = false;
                }
            } else if (tags != null) {
                compatible = false;
                for (String type : tags) {
                    if (!Intrinsics.areEqual((Object)type, (Object)castTypeClass) && !context.getSdkInfo().isSubViewOf(castTypeClass, type)) continue;
                    compatible = true;
                    break;
                }
            }
        } else {
            boolean bl3 = compatible = castClass == null;
        }
        if (castClass != null && !compatible) {
            if (tag != null) {
                if (this.isCompatible(context, castClass, tag)) {
                    return;
                }
            } else if (tags != null) {
                for (String t : tags) {
                    if (!this.isCompatible(context, castClass, t)) continue;
                    return;
                }
            }
        }
        if (compatible) {
            return;
        }
        String string = tag;
        if (string == null) {
            Joiner joiner = Joiner.on((String)"|");
            List<String> list = tags;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            string = joiner.join((Iterable)list);
        }
        String displayTag = string;
        String sampleLayout = null;
        if (items != null && (tags == null || tags.size() == 1)) {
            for (ResourceItem resourceItem : items) {
                PathString source;
                Collection<String> t = this.getViewTags((Context)context, resourceItem);
                if (t == null || !t.contains(displayTag) || (source = resourceItem.getSource()) == null) continue;
                String parentName = source.getParentFileName();
                FolderConfiguration folderConfiguration = resourceItem.getConfiguration();
                Intrinsics.checkExpressionValueIsNotNull((Object)folderConfiguration, (String)"item.configuration");
                sampleLayout = folderConfiguration.isDefault() || parentName == null ? source.getFileName() : parentName + "/" + source.getFileName();
                break;
            }
        }
        String string3 = castTypeClass;
        int t = StringsKt.lastIndexOf$default((CharSequence)castTypeClass, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = string3;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string2.substring(t);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String string5 = string4;
        String message2 = null;
        Location location = null;
        String type = findView ? "layout" : "fragment";
        String string6 = verb = findView ? "was" : "referenced";
        if (!(node instanceof UBinaryExpressionWithType)) {
            if (node instanceof UVariable && ((UVariable)node).getTypeReference() != null) {
                UTypeReferenceExpression uTypeReferenceExpression = ((UVariable)node).getTypeReference();
                if (uTypeReferenceExpression == null) {
                    Intrinsics.throwNpe();
                }
                location = context.getLocation((UElement)uTypeReferenceExpression);
                String string7 = displayTag;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"displayTag");
                location.setSecondary(this.createSecondary(context, string7, resourceReference, sampleLayout));
            } else {
                location = context.getLocation(node);
            }
            message2 = "Unexpected implicit cast to `" + string5 + "`: " + type + " tag " + verb + " `" + displayTag + '`';
        } else {
            location = context.getLocation(node);
            if (sampleLayout != null) {
                String string8 = displayTag;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"displayTag");
                location.setSecondary(this.createSecondary(context, string8, resourceReference, sampleLayout));
            }
            message2 = "Unexpected cast to `" + string5 + "`: " + type + " tag " + verb + " `" + displayTag + '`';
        }
        JavaContext.report$default((JavaContext)context, (Issue)WRONG_VIEW_CAST, (UElement)node, (Location)location, (String)message2, null, (int)16, null);
    }

    private final Location createSecondary(JavaContext context, String tag, UExpression resourceReference, String sampleLayout) {
        Location secondary = context.getLocation((UElement)resourceReference);
        if (sampleLayout != null) {
            String article = StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) == -1 && StringsKt.indexOf$default((CharSequence)tag, (char)'|', (int)0, (boolean)false, (int)6, null) == -1 && StringUtil.isVowel((char)Character.toLowerCase(tag.charAt(0))) ? "an" : "a";
            secondary.setMessage("Id bound to " + article + " `" + tag + "` in `" + sampleLayout + '`');
        }
        return secondary;
    }

    private final boolean isCompatible(JavaContext context, PsiClass castClass, String tag) {
        PsiClass cls = null;
        if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            for (String prefix : new String[]{"android.widget.", "android.view.", "android.webkit."}) {
                cls = context.getEvaluator().findClass(prefix + tag);
                if (cls == null) {
                    continue;
                }
                break;
            }
        } else {
            cls = context.getEvaluator().findClass(tag);
        }
        return cls != null ? cls.isInheritor(castClass, true) : true;
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(ViewTypeDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.ALL_JAVA_FILES), new EnumSet[]{Scope.JAVA_FILE_SCOPE});
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 9;
        String string = null;
        Category category = Category.CORRECTNESS;
        WRONG_VIEW_CAST = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"WrongViewCast", (String)"Mismatched view type", (String)"\n                Keeps track of the view types associated with ids and if it finds a usage \\\n                of the id in the Java code it ensures that it is treated as the same type.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = new Implementation(ViewTypeDetector.class, Scope.JAVA_FILE_SCOPE);
        bl = false;
        bl2 = true;
        severity = Severity.WARNING;
        n = 9;
        string = null;
        category = Category.CORRECTNESS;
        ADD_CAST = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"FindViewByIdCast", (String)"Add Explicit Cast", (String)"\n                In Android O, the `findViewById` signature switched to using generics, which \\\n                means that most of the time you can leave out explicit casts and just assign \\\n                the result of the `findViewById` call to variables of specific view classes.\n\n                However, due to language changes between Java 7 and 8, this change may cause \\\n                code to not compile without explicit casts. This lint check looks for these \\\n                scenarios and suggests casts to be added now such that the code will \\\n                continue to compile if the language level is updated to 1.8.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/ViewTypeDetector$Companion;", "", "()V", "ADD_CAST", "Lcom/android/tools/lint/detector/api/Issue;", "FIND_FRAGMENT_BY_TAG", "", "FIND_VIEW_BY_ID", "REQUIRE_VIEW_BY_ID", "TAG_NAME_PREFIX", "WRONG_VIEW_CAST", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

