/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.ControlFlowGraph;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.SdkUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class VersionChecks {
    public static final String SDK_INT = "SDK_INT";
    private static final String ANDROID_OS_BUILD_VERSION = "android/os/Build$VERSION";
    private static final String GET_BUILD_SDK_INT = "getBuildSdkInt";
    private static final String[] VERSION_METHOD_NAME_PREFIXES = new String[]{"isAtLeast", "isRunning", "is", "runningOn", "running"};
    private static final String[] VERSION_METHOD_NAME_SUFFIXES = new String[]{"OrLater", "OrAbove", "OrHigher", "OrNewer", "Sdk"};

    public static int codeNameToApi(String text) {
        int dotIndex = text.lastIndexOf(46);
        if (dotIndex != -1) {
            text = text.substring(dotIndex + 1);
        }
        return SdkVersionInfo.getApiByBuildCode((String)text, (boolean)true);
    }

    public static boolean isWithinSdkConditional(ClassContext context, ClassNode classNode, MethodNode method, AbstractInsnNode call, int requiredApi) {
        assert (requiredApi != -1);
        if (!VersionChecks.containsSimpleSdkCheck(method)) {
            return false;
        }
        try {
            ApiCheckGraph graph = new ApiCheckGraph(requiredApi);
            ControlFlowGraph.create(graph, classNode, method);
            AbstractInsnNode first = method.instructions.get(0);
            return !graph.isConnected(first, call);
        }
        catch (AnalyzerException e) {
            context.log((Throwable)e, null, new Object[0]);
            return false;
        }
    }

    private static boolean containsSimpleSdkCheck(MethodNode method) {
        InsnList nodes = method.instructions;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode ifNode;
            AbstractInsnNode bipush;
            AbstractInsnNode instruction = nodes.get(i);
            if (!VersionChecks.isSdkVersionLookup(instruction) || (bipush = Lint.getNextInstruction((AbstractInsnNode)instruction)) == null || bipush.getOpcode() != 16 || (ifNode = Lint.getNextInstruction((AbstractInsnNode)bipush)) == null || ifNode.getType() != 7) continue;
            return true;
        }
        return false;
    }

    private static boolean isSdkVersionLookup(AbstractInsnNode instruction) {
        if (instruction.getOpcode() == 178) {
            FieldInsnNode fieldNode = (FieldInsnNode)instruction;
            return SDK_INT.equals(fieldNode.name) && ANDROID_OS_BUILD_VERSION.equals(fieldNode.owner);
        }
        return false;
    }

    public static boolean isPrecededByVersionCheckExit(UElement element, int api) {
        UExpression currentExpression = (UExpression)UastUtils.getParentOfType((UElement)element, UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
        while (currentExpression != null) {
            VersionCheckWithExitFinder visitor2 = new VersionCheckWithExitFinder(element, api);
            currentExpression.accept((UastVisitor)visitor2);
            if (visitor2.found()) {
                return true;
            }
            element = currentExpression;
            currentExpression = (UExpression)UastUtils.getParentOfType((UElement)currentExpression, UExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class, UClass.class});
        }
        return false;
    }

    private static boolean isUnconditionalReturn(UExpression statement) {
        List expressions;
        int statements;
        if (statement instanceof UBlockExpression && (statements = (expressions = ((UBlockExpression)statement).getExpressions()).size()) > 0) {
            UCallExpression call;
            String methodName;
            UExpression last = (UExpression)expressions.get(statements - 1);
            if (last instanceof UReturnExpression || last instanceof UThrowExpression) {
                return true;
            }
            if (last instanceof UCallExpression && ("error".equals(methodName = Lint.getMethodName((UCallExpression)(call = (UCallExpression)last))) || "TODO".equals(methodName))) {
                return true;
            }
        }
        return statement instanceof UReturnExpression;
    }

    public static boolean isWithinVersionCheckConditional(JavaEvaluator evaluator, UElement element, int api) {
        return VersionChecks.isWithinVersionCheckConditional(evaluator, element, api, null);
    }

    public static boolean isWithinVersionCheckConditional(JavaEvaluator evaluator, UElement element, int api, ApiLevelLookup apiLookup) {
        UElement current = Lint.skipParentheses((UElement)element.getUastParent());
        UElement prev = element;
        while (current != null) {
            Boolean ok;
            if (current instanceof UIfExpression) {
                boolean fromThen;
                UIfExpression ifStatement = (UIfExpression)current;
                UExpression condition = ifStatement.getCondition();
                if (prev != condition && (ok = VersionChecks.isVersionCheckConditional(api, (UElement)condition, fromThen = prev.equals(ifStatement.getThenExpression()), prev, apiLookup)) != null && ok.booleanValue()) {
                    return true;
                }
            } else {
                UElement parent;
                if (current instanceof UPolyadicExpression && (VersionChecks.isAndedWithConditional(current, api, prev) || VersionChecks.isOredWithConditional(current, api, prev))) {
                    return true;
                }
                if (current instanceof USwitchClauseExpressionWithBody) {
                    USwitchClauseExpressionWithBody body = (USwitchClauseExpressionWithBody)current;
                    for (UExpression condition : body.getCaseValues()) {
                        ok = VersionChecks.isVersionCheckConditional(api, (UElement)condition, true, prev, apiLookup);
                        if (ok == null || !ok.booleanValue()) continue;
                        return true;
                    }
                } else if (current instanceof UCallExpression && prev instanceof ULambdaExpression) {
                    Map mapping;
                    PsiParameter parameter;
                    UCallExpression call = (UCallExpression)current;
                    PsiMethod method = call.resolve();
                    if (method != null && (parameter = (PsiParameter)(mapping = evaluator.computeArgumentMapping(call, method)).get(prev)) != null) {
                        UastContext context = UastUtils.getUastContext((UElement)element);
                        UMethod uMethod = context.getMethod(method);
                        final Ref match = new Ref();
                        final String parameterName = parameter.getName();
                        uMethod.accept((UastVisitor)new AbstractUastVisitor(){

                            public boolean visitCallExpression(UCallExpression node) {
                                String callName = Lint.getMethodName((UCallExpression)node);
                                if (Objects.equals(callName, parameterName)) {
                                    match.set((Object)node);
                                }
                                return super.visitCallExpression(node);
                            }
                        });
                        UCallExpression lambdaInvocation = (UCallExpression)match.get();
                        ApiLevelLookup newApiLookup = arg -> {
                            PsiElement resolved;
                            if (arg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)arg).resolve()) instanceof PsiParameter) {
                                PsiParameter parameter1 = (PsiParameter)resolved;
                                PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class);
                                if (parameterList != null) {
                                    int index = parameterList.getParameterIndex(parameter1);
                                    List arguments = call.getValueArguments();
                                    if (index != -1 && index < arguments.size()) {
                                        return VersionChecks.getApiLevel((UExpression)arguments.get(index), null);
                                    }
                                }
                            }
                            return -1;
                        };
                        if (lambdaInvocation != null && VersionChecks.isWithinVersionCheckConditional(evaluator, (UElement)lambdaInvocation, api, newApiLookup)) {
                            return true;
                        }
                    }
                } else if (current instanceof UMethod ? !((parent = current.getUastParent()) instanceof UAnonymousClass) : current instanceof PsiFile) {
                    return false;
                }
            }
            prev = current;
            current = Lint.skipParentheses((UElement)current.getUastParent());
        }
        return false;
    }

    private static Boolean isVersionCheckConditional(int api, UElement element, boolean and, UElement prev, ApiLevelLookup apiLookup) {
        if (element instanceof UPolyadicExpression) {
            UBinaryExpression binary;
            Boolean ok;
            if (element instanceof UBinaryExpression && (ok = VersionChecks.isVersionCheckConditional(api, and, binary = (UBinaryExpression)element, apiLookup)) != null) {
                return ok;
            }
            UPolyadicExpression expression = (UPolyadicExpression)element;
            UastBinaryOperator tokenType = expression.getOperator();
            if (and && tokenType == UastBinaryOperator.LOGICAL_AND ? VersionChecks.isAndedWithConditional(element, api, prev) : !and && tokenType == UastBinaryOperator.LOGICAL_OR && VersionChecks.isOredWithConditional(element, api, prev)) {
                return true;
            }
        } else {
            UExpression operand;
            Boolean ok;
            UUnaryExpression prefixExpression;
            if (element instanceof UCallExpression) {
                UCallExpression call = (UCallExpression)element;
                return VersionChecks.isValidVersionCall(api, and, call);
            }
            if (element instanceof UReferenceExpression) {
                UReferenceExpression refExpression = (UReferenceExpression)element;
                PsiElement resolved = refExpression.resolve();
                if (resolved instanceof PsiField) {
                    Boolean ok2;
                    UastContext context;
                    UExpression initializer;
                    PsiField field = (PsiField)resolved;
                    PsiModifierList modifierList = field.getModifierList();
                    if (modifierList != null && modifierList.hasExplicitModifier("static") && (initializer = (context = UastUtils.getUastContext((UElement)element)).getInitializerBody((PsiVariable)field)) != null && (ok2 = VersionChecks.isVersionCheckConditional(api, (UElement)initializer, and, null, null)) != null) {
                        return ok2;
                    }
                } else {
                    if (resolved instanceof PsiMethod && element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getSelector() instanceof UCallExpression) {
                        UCallExpression call = (UCallExpression)((UQualifiedReferenceExpression)element).getSelector();
                        return VersionChecks.isValidVersionCall(api, and, call);
                    }
                    if (resolved instanceof PsiMethod && element instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)element).getReceiver() instanceof UReferenceExpression) {
                        return VersionChecks.isValidVersionCall(api, and, element, (PsiMethod)resolved);
                    }
                }
            } else if (element instanceof UUnaryExpression && (prefixExpression = (UUnaryExpression)element).getOperator() == UastPrefixOperator.LOGICAL_NOT && (ok = VersionChecks.isVersionCheckConditional(api, (UElement)(operand = prefixExpression.getOperand()), !and, null, null)) != null) {
                return ok;
            }
        }
        return null;
    }

    private static Boolean isValidVersionCall(int api, boolean and, UCallExpression call) {
        PsiMethod method = call.resolve();
        if (method == null) {
            return null;
        }
        return VersionChecks.isValidVersionCall(api, and, (UElement)call, method);
    }

    private static Boolean isValidVersionCall(int api, boolean and, UElement call, PsiMethod method) {
        int version;
        PsiClass containingClass;
        String name = method.getName();
        if (name.startsWith("isAtLeast") && (containingClass = method.getContainingClass()) != null && "BuildCompat".equals(containingClass.getName())) {
            if (name.equals("isAtLeastN")) {
                return api <= 24;
            }
            if (name.equals("isAtLeastNMR1")) {
                return api <= 25;
            }
            if (name.equals("isAtLeastO")) {
                return api <= 26;
            }
            if (name.startsWith("isAtLeastP")) {
                return api <= 28;
            }
            if (name.startsWith("isAtLeastQ")) {
                return api <= 29;
            }
            if (name.startsWith("isAtLeast") && name.length() == 10 && Character.isUpperCase(name.charAt(9)) && name.charAt(9) > 'Q') {
                return api <= 29;
            }
        }
        if ((version = VersionChecks.getMinSdkVersionFromMethodName(name)) != -1) {
            return api <= version;
        }
        if (!method.hasModifierProperty("abstract")) {
            UastContext context = UastUtils.getUastContext((UElement)call);
            UExpression body = context.getMethodBody(method);
            if (body == null) {
                return null;
            }
            List expressions = body instanceof UBlockExpression ? ((UBlockExpression)body).getExpressions() : Collections.singletonList(body);
            if (expressions.size() == 1) {
                UExpression statement = (UExpression)expressions.get(0);
                UExpression returnValue = null;
                if (statement instanceof UReturnExpression) {
                    UReturnExpression returnStatement = (UReturnExpression)statement;
                    returnValue = returnStatement.getReturnExpression();
                } else if (statement != null) {
                    returnValue = statement;
                }
                if (returnValue != null) {
                    ApiLevelLookup lookup;
                    Boolean ok;
                    List arguments;
                    List list = arguments = call instanceof UCallExpression ? ((UCallExpression)call).getValueArguments() : Collections.emptyList();
                    if (arguments.isEmpty()) {
                        Boolean isConditional;
                        if ((returnValue instanceof UPolyadicExpression || returnValue instanceof UCallExpression || returnValue instanceof UQualifiedReferenceExpression) && (isConditional = VersionChecks.isVersionCheckConditional(api, (UElement)returnValue, and, null, null)) != null) {
                            return isConditional;
                        }
                    } else if (arguments.size() == 1 && (ok = VersionChecks.isVersionCheckConditional(api, (UElement)returnValue, and, null, lookup = arg -> {
                        PsiElement resolved;
                        if (arg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)arg).resolve()) instanceof PsiParameter) {
                            int index;
                            PsiParameter parameter = (PsiParameter)resolved;
                            PsiParameterList parameterList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiParameterList.class);
                            if (parameterList != null && (index = parameterList.getParameterIndex(parameter)) != -1 && index < arguments.size()) {
                                return VersionChecks.getApiLevel((UExpression)arguments.get(index), null);
                            }
                        }
                        return -1;
                    })) != null) {
                        return ok;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isSdkInt(PsiElement element) {
        PsiMethodCallExpression callExpression;
        if (element instanceof PsiReferenceExpression) {
            PsiExpression initializer;
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            if (SDK_INT.equals(ref.getReferenceName())) {
                return true;
            }
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null) {
                return VersionChecks.isSdkInt((PsiElement)initializer);
            }
        } else if (element instanceof PsiMethodCallExpression && GET_BUILD_SDK_INT.equals((callExpression = (PsiMethodCallExpression)element).getMethodExpression().getReferenceName())) {
            return true;
        }
        return false;
    }

    private static boolean isSdkInt(UElement element) {
        UCallExpression callExpression;
        if (element instanceof UReferenceExpression) {
            PsiExpression initializer;
            UReferenceExpression ref = (UReferenceExpression)element;
            if (SDK_INT.equals(ref.getResolvedName())) {
                return true;
            }
            PsiElement resolved = ref.resolve();
            if (resolved instanceof ULocalVariable) {
                UExpression initializer2 = ((ULocalVariable)resolved).getUastInitializer();
                if (initializer2 != null) {
                    return VersionChecks.isSdkInt((UElement)initializer2);
                }
            } else if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null) {
                return VersionChecks.isSdkInt((PsiElement)initializer);
            }
        } else if (element instanceof UCallExpression && GET_BUILD_SDK_INT.equals(Lint.getMethodName((UCallExpression)(callExpression = (UCallExpression)element)))) {
            return true;
        }
        return false;
    }

    static int getMinSdkVersionFromMethodName(String name) {
        String prefix = null;
        String suffix = null;
        for (String p : VERSION_METHOD_NAME_PREFIXES) {
            if (!name.startsWith(p)) continue;
            prefix = p;
            break;
        }
        for (String p : VERSION_METHOD_NAME_SUFFIXES) {
            if (!SdkUtils.endsWithIgnoreCase((String)name, (String)p)) continue;
            suffix = p;
            break;
        }
        if ("isAtLeast".equals(prefix) && suffix == null) {
            suffix = "";
        }
        if (prefix != null && suffix != null) {
            String codeName = name.substring(prefix.length(), name.length() - suffix.length());
            int version = SdkVersionInfo.getApiByPreviewName((String)codeName, (boolean)false);
            if (version == -1 && (version = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false)) == -1 && codeName.length() == 1 && Character.isUpperCase(codeName.charAt(0))) {
                version = 29;
            }
            return version;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Boolean isVersionCheckConditional(int api, boolean fromThen, UBinaryExpression binary, ApiLevelLookup apiLevelLookup) {
        int level;
        UastBinaryOperator tokenType = binary.getOperator();
        if (tokenType != UastBinaryOperator.GREATER && tokenType != UastBinaryOperator.GREATER_OR_EQUALS && tokenType != UastBinaryOperator.LESS_OR_EQUALS && tokenType != UastBinaryOperator.LESS && tokenType != UastBinaryOperator.EQUALS && tokenType != UastBinaryOperator.IDENTITY_EQUALS && tokenType != UastBinaryOperator.NOT_EQUALS && tokenType != UastBinaryOperator.IDENTITY_NOT_EQUALS) return null;
        UExpression left = binary.getLeftOperand();
        if (!VersionChecks.isSdkInt((UElement)left)) {
            UExpression right = binary.getRightOperand();
            if (!VersionChecks.isSdkInt((UElement)right)) return null;
            fromThen = !fromThen;
            level = VersionChecks.getApiLevel(left, apiLevelLookup);
        } else {
            UExpression right = binary.getRightOperand();
            level = VersionChecks.getApiLevel(right, apiLevelLookup);
        }
        if (level == -1) return null;
        if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS) {
            return level >= api && fromThen;
        }
        if (tokenType == UastBinaryOperator.GREATER) {
            return level >= api - 1 && fromThen;
        }
        if (tokenType == UastBinaryOperator.LESS_OR_EQUALS) {
            return level >= api - 1 && !fromThen;
        }
        if (tokenType == UastBinaryOperator.LESS) {
            return level >= api && !fromThen;
        }
        if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
            return level >= api && fromThen;
        }
        if (tokenType == UastBinaryOperator.NOT_EQUALS || tokenType == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            return level == api && !fromThen;
        }
        assert (false) : tokenType;
        return null;
    }

    private static int getApiLevel(UExpression element, ApiLevelLookup apiLevelLookup) {
        ULiteralExpression lit;
        Object value;
        int level = -1;
        if (element instanceof UReferenceExpression) {
            Object constant;
            UReferenceExpression ref2 = (UReferenceExpression)element;
            String codeName = ref2.getResolvedName();
            if (codeName != null) {
                level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)false);
            }
            if (level == -1 && (constant = ConstantEvaluator.evaluate(null, (UElement)element)) instanceof Number) {
                level = ((Number)constant).intValue();
            }
        } else if (element instanceof ULiteralExpression && (value = (lit = (ULiteralExpression)element).getValue()) instanceof Integer) {
            level = (Integer)value;
        }
        if (level == -1 && apiLevelLookup != null && element != null) {
            level = apiLevelLookup.getApiLevel((UElement)element);
        }
        return level;
    }

    private static boolean isOredWithConditional(UElement element, int api, UElement before) {
        UPolyadicExpression ppe;
        if (element instanceof UBinaryExpression) {
            Boolean value;
            UExpression left;
            UBinaryExpression inner = (UBinaryExpression)element;
            if (inner.getOperator() == UastBinaryOperator.LOGICAL_OR && before != (left = inner.getLeftOperand())) {
                Boolean ok = VersionChecks.isVersionCheckConditional(api, (UElement)left, false, null, null);
                if (ok != null) {
                    return ok;
                }
                UExpression right = inner.getRightOperand();
                ok = VersionChecks.isVersionCheckConditional(api, (UElement)right, false, null, null);
                if (ok != null) {
                    return ok;
                }
            }
            return (value = VersionChecks.isVersionCheckConditional(api, false, inner, null)) != null && value != false;
        }
        if (element instanceof UPolyadicExpression && (ppe = (UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_OR) {
            UExpression operand;
            Iterator iterator = ppe.getOperands().iterator();
            while (iterator.hasNext() && !(operand = (UExpression)iterator.next()).equals(before)) {
                if (!VersionChecks.isOredWithConditional((UElement)operand, api, before)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAndedWithConditional(UElement element, int api, UElement before) {
        UPolyadicExpression ppe;
        if (element instanceof UBinaryExpression) {
            Boolean value;
            UExpression left;
            UBinaryExpression inner = (UBinaryExpression)element;
            if (inner.getOperator() == UastBinaryOperator.LOGICAL_AND && before != (left = inner.getLeftOperand())) {
                Boolean ok = VersionChecks.isVersionCheckConditional(api, (UElement)left, true, null, null);
                if (ok != null) {
                    return ok;
                }
                UExpression right = inner.getRightOperand();
                ok = VersionChecks.isVersionCheckConditional(api, (UElement)right, true, null, null);
                if (ok != null) {
                    return ok;
                }
            }
            return (value = VersionChecks.isVersionCheckConditional(api, true, inner, null)) != null && value != false;
        }
        if (element instanceof UPolyadicExpression && (ppe = (UPolyadicExpression)element).getOperator() == UastBinaryOperator.LOGICAL_AND) {
            UExpression operand;
            Iterator iterator = ppe.getOperands().iterator();
            while (iterator.hasNext() && !(operand = (UExpression)iterator.next()).equals(before)) {
                if (!VersionChecks.isAndedWithConditional((UElement)operand, api, before)) continue;
                return true;
            }
        }
        return false;
    }

    public static Boolean isVersionCheckConditional(int api, UBinaryExpression binary) {
        UReferenceExpression ref;
        UExpression left;
        UastBinaryOperator tokenType = binary.getOperator();
        if ((tokenType == UastBinaryOperator.GREATER || tokenType == UastBinaryOperator.GREATER_OR_EQUALS || tokenType == UastBinaryOperator.LESS_OR_EQUALS || tokenType == UastBinaryOperator.LESS || tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) && (left = binary.getLeftOperand()) instanceof UReferenceExpression && SDK_INT.equals((ref = (UReferenceExpression)left).getResolvedName())) {
            ULiteralExpression lit;
            Object value;
            UExpression right = binary.getRightOperand();
            int level = -1;
            if (right instanceof UReferenceExpression) {
                UReferenceExpression ref2 = (UReferenceExpression)right;
                String codeName = ref2.getResolvedName();
                if (codeName == null) {
                    return false;
                }
                level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
            } else if (right instanceof ULiteralExpression && (value = (lit = (ULiteralExpression)right).getValue()) instanceof Integer) {
                level = (Integer)value;
            }
            if (level != -1) {
                if (tokenType == UastBinaryOperator.GREATER_OR_EQUALS && level < api) {
                    return true;
                }
                if (tokenType == UastBinaryOperator.GREATER && level <= api - 1) {
                    return true;
                }
                if (tokenType == UastBinaryOperator.LESS_OR_EQUALS && level < api) {
                    return false;
                }
                if (tokenType == UastBinaryOperator.LESS && level <= api) {
                    return false;
                }
                if ((tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) && level < api) {
                    return false;
                }
            }
        }
        return null;
    }

    private static class ApiCheckGraph
    extends ControlFlowGraph {
        private final int mRequiredApi;

        public ApiCheckGraph(int requiredApi) {
            this.mRequiredApi = requiredApi;
        }

        @Override
        protected void add(AbstractInsnNode from, AbstractInsnNode to) {
            IntInsnNode intNode;
            if (from.getType() == 7 && from.getPrevious() != null && from.getPrevious().getType() == 1 && (intNode = (IntInsnNode)from.getPrevious()).getPrevious() != null && VersionChecks.isSdkVersionLookup(intNode.getPrevious())) {
                boolean includeEdge;
                JumpInsnNode jumpNode = (JumpInsnNode)from;
                int api = intNode.operand;
                boolean isJumpEdge = to == jumpNode.label;
                switch (from.getOpcode()) {
                    case 160: {
                        includeEdge = api < this.mRequiredApi || isJumpEdge;
                        break;
                    }
                    case 164: {
                        includeEdge = api < this.mRequiredApi - 1 || isJumpEdge;
                        break;
                    }
                    case 161: {
                        includeEdge = api < this.mRequiredApi || isJumpEdge;
                        break;
                    }
                    case 162: {
                        includeEdge = api < this.mRequiredApi || !isJumpEdge;
                        break;
                    }
                    case 163: {
                        includeEdge = api < this.mRequiredApi - 1 || !isJumpEdge;
                        break;
                    }
                    default: {
                        includeEdge = true;
                    }
                }
                if (!includeEdge) {
                    return;
                }
            }
            super.add(from, to);
        }
    }

    private static class VersionCheckWithExitFinder
    extends AbstractUastVisitor {
        private final UElement endElement;
        private final int api;
        private boolean found = false;
        private boolean done = false;

        public VersionCheckWithExitFinder(UElement endElement, int api) {
            this.endElement = endElement;
            this.api = api;
        }

        public boolean visitElement(UElement node) {
            if (this.done) {
                return true;
            }
            if (node.equals(this.endElement)) {
                this.done = true;
            }
            return this.done;
        }

        public boolean visitIfExpression(UIfExpression ifStatement) {
            Boolean level;
            if (this.done) {
                return true;
            }
            UExpression thenBranch = ifStatement.getThenExpression();
            UExpression elseBranch = ifStatement.getElseExpression();
            if (thenBranch != null && (level = VersionChecks.isVersionCheckConditional(this.api, (UElement)ifStatement.getCondition(), false, null, null)) != null && level.booleanValue() && VersionChecks.isUnconditionalReturn(thenBranch)) {
                this.found = true;
                this.done = true;
            }
            if (elseBranch != null && (level = VersionChecks.isVersionCheckConditional(this.api, (UElement)ifStatement.getCondition(), true, null, null)) != null && level.booleanValue() && VersionChecks.isUnconditionalReturn(elseBranch)) {
                this.found = true;
                this.done = true;
            }
            return true;
        }

        public boolean found() {
            return this.found;
        }
    }

    private static interface ApiLevelLookup {
        public int getApiLevel(UElement var1);
    }
}

