/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.java.JavaUTypeCastExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class AnnotationDetector
extends Detector
implements SourceCodeScanner {
    public static final String GMS_HIDE_ANNOTATION = "com.google.android.gms.common.internal.Hide";
    public static final AndroidxName CHECK_RESULT_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"CheckResult");
    public static final AndroidxName INT_RANGE_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"IntRange");
    public static final AndroidxName FLOAT_RANGE_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"FloatRange");
    public static final AndroidxName SIZE_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"Size");
    public static final AndroidxName PERMISSION_ANNOTATION = AndroidxName.of((String)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.oldName(), (String)"RequiresPermission");
    public static final AndroidxName UI_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"UiThread");
    public static final AndroidxName MAIN_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"MainThread");
    public static final AndroidxName WORKER_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"WorkerThread");
    public static final AndroidxName BINDER_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"BinderThread");
    public static final AndroidxName ANY_THREAD_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"AnyThread");
    public static final AndroidxName RESTRICT_TO_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RestrictTo");
    public static final AndroidxName VISIBLE_FOR_TESTING_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"VisibleForTesting");
    public static final AndroidxName PERMISSION_ANNOTATION_READ = AndroidxName.of((AndroidxName)PERMISSION_ANNOTATION, (String)"Read");
    public static final AndroidxName PERMISSION_ANNOTATION_WRITE = AndroidxName.of((AndroidxName)PERMISSION_ANNOTATION, (String)"Write");
    public static final AndroidxName HALF_FLOAT_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"HalfFloat");
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final String SECURITY_EXCEPTION = "java.lang.SecurityException";
    public static final String FINDBUGS_ANNOTATIONS_CHECK_RETURN_VALUE = "edu.umd.cs.findbugs.annotations.CheckReturnValue";
    public static final String JAVAX_ANNOTATION_CHECK_RETURN_VALUE = "javax.annotation.CheckReturnValue";
    public static final String ERRORPRONE_CAN_IGNORE_RETURN_VALUE = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    public static final String GUAVA_VISIBLE_FOR_TESTING = "com.google.common.annotations.VisibleForTesting";
    public static final Implementation IMPLEMENTATION = new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INSIDE_METHOD = Issue.create((String)"LocalSuppress", (String)"@SuppressLint on invalid element", (String)"The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue ANNOTATION_USAGE = Issue.create((String)"SupportAnnotationUsage", (String)"Incorrect support annotation usage", (String)"This lint check makes sure that the support annotations (such as `@IntDef` and `@ColorInt`) are used correctly. For example, it's an error to specify an `@IntRange` where the `from` value is higher than the `to` value.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue UNIQUE = Issue.create((String)"UniqueConstants", (String)"Overlapping Enumeration Constants", (String)"The `@IntDef` annotation allows you to create a light-weight \"enum\" or type definition. However, it's possible to accidentally specify the same value for two or more of the values, which can lead to hard-to-detect bugs. This check looks for this scenario and flags any repeated constants.\n\nIn some cases, the repeated constant is intentional (for example, renaming a constant to a more intuitive name, and leaving the old name in place for compatibility purposes).  In that case, simply suppress this check by adding a `@SuppressLint(\"UniqueConstants\")` annotation.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).setAndroidSpecific(true);
    public static final Issue FLAG_STYLE = Issue.create((String)"ShiftFlags", (String)"Dangerous Flag Constant Declaration", (String)"When defining multiple constants for use in flags, the recommended style is to use the form `1 << 2`, `1 << 3`, `1 << 4` and so on to ensure that the constants are unique and non-overlapping.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue SWITCH_TYPE_DEF = Issue.create((String)"SwitchIntDef", (String)"Missing @IntDef in Switch", (String)"This check warns if a `switch` statement does not explicitly include all the values declared by the typedef `@IntDef` declaration.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setAndroidSpecific(true);
    private Set<PsiElement> mWarnedFlags;

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(2);
        types.add(UAnnotation.class);
        types.add(USwitchExpression.class);
        return types;
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new AnnotationChecker(context);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static List<String> computeFieldNames(USwitchExpression node, Iterable<?> allowedValues) {
        ArrayList list = Lists.newArrayList();
        Iterator<?> iterator = allowedValues.iterator();
        while (true) {
            PsiClass containingClass;
            void var4_4;
            block12: {
                PsiElement resolved;
                if (!iterator.hasNext()) {
                    Collections.sort(list);
                    return list;
                }
                Object obj = iterator.next();
                if (obj instanceof ExternalReferenceExpression) {
                    ExternalReferenceExpression externalRef = (ExternalReferenceExpression)obj;
                    resolved = UastLintUtils.resolve((ExternalReferenceExpression)externalRef, (UElement)node);
                    if (resolved != null) {
                        PsiElement psiElement = resolved;
                    }
                } else {
                    PsiReferenceExpression ref;
                    if (obj instanceof PsiReferenceExpression) {
                        ref = (PsiReferenceExpression)obj;
                        resolved = ref.resolve();
                        if (resolved != null) {
                            PsiElement psiElement = resolved;
                            break block12;
                        } else {
                            String referenceName = ref.getReferenceName();
                            if (referenceName == null) continue;
                            list.add('`' + referenceName + '`');
                            continue;
                        }
                    }
                    if (obj instanceof PsiLiteral) {
                        list.add("`" + ((PsiLiteral)obj).getValue() + '`');
                        continue;
                    }
                    if (obj instanceof UReferenceExpression) {
                        ref = (UReferenceExpression)obj;
                        resolved = ref.resolve();
                        if (resolved == null) {
                            String resolvedName = ref.getResolvedName();
                            if (resolvedName == null) continue;
                            list.add('`' + resolvedName + '`');
                            continue;
                        }
                        PsiElement psiElement = resolved;
                    }
                }
            }
            if (!(var4_4 instanceof PsiField)) continue;
            PsiField field = (PsiField)var4_4;
            String name = field.getName();
            UClass clz = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (clz != null && (containingClass = field.getContainingClass()) != null && !containingClass.equals(clz.getPsi())) {
                name = containingClass.getName() + '.' + field.getName();
            }
            list.add('`' + name + '`');
        }
    }

    private static UElement getAnnotationScope(UAnnotation node) {
        UElement scope = UastUtils.getParentOfType((UElement)node, UAnnotation.class, (boolean)true);
        if (scope == null) {
            scope = node;
        }
        return scope;
    }

    private static boolean removeFieldFromList(List<Object> fields, PsiField resolvedField) {
        for (Object field : fields) {
            PsiField candidateField;
            if (!(field instanceof PsiField) || !(candidateField = (PsiField)field).isEquivalentTo((PsiElement)resolvedField)) continue;
            return true;
        }
        return false;
    }

    static PsiAnnotation[] filterRelevantAnnotations(JavaEvaluator evaluator, PsiAnnotation[] annotations) {
        ArrayList<PsiAnnotation> result = null;
        int length = annotations.length;
        if (length == 0) {
            return annotations;
        }
        for (PsiAnnotation annotation : annotations) {
            String signature = annotation.getQualifiedName();
            if (signature == null || signature.startsWith("java.")) continue;
            if (SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(signature) || signature.equals(GMS_HIDE_ANNOTATION)) {
                if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) continue;
                if (length == 1) {
                    return annotations;
                }
                if (result == null) {
                    result = new ArrayList<PsiAnnotation>(2);
                }
                result.add(annotation);
            }
            PsiClass cls = null;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            if (ref != null) {
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiClass) {
                    cls = (PsiClass)resolved;
                }
            } else {
                Project project = annotation.getProject();
                GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
                cls = JavaPsiFacade.getInstance((Project)project).findClass(signature, scope);
            }
            if (cls == null || !cls.isAnnotationType()) continue;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls, false);
            for (int j = 0; j < innerAnnotations.length; ++j) {
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a == null || a.startsWith("java.") || !SdkConstants.INT_DEF_ANNOTATION.isEquals(a) && !SdkConstants.LONG_DEF_ANNOTATION.isEquals(a) && !PERMISSION_ANNOTATION.isEquals(a) && !INT_RANGE_ANNOTATION.isEquals(a) && !SdkConstants.STRING_DEF_ANNOTATION.isEquals(a)) continue;
                if (length == 1 && j == innerAnnotations.length - 1 && result == null) {
                    return innerAnnotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(inner);
            }
        }
        return result != null ? result.toArray(PsiAnnotation.EMPTY_ARRAY) : PsiAnnotation.EMPTY_ARRAY;
    }

    private class AnnotationChecker
    extends UElementHandler {
        private final JavaContext mContext;

        public AnnotationChecker(JavaContext context) {
            this.mContext = context;
        }

        public void visitAnnotation(UAnnotation annotation) {
            block15: {
                PsiClass cls;
                String type;
                block17: {
                    UExpression attributeValue;
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    int set;
                                    block27: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block20: {
                                                        long min;
                                                        long exact;
                                                        int unset;
                                                        block22: {
                                                            long multiple;
                                                            block21: {
                                                                block19: {
                                                                    boolean invalid;
                                                                    block18: {
                                                                        UMethod method;
                                                                        block14: {
                                                                            UExpression value;
                                                                            block16: {
                                                                                type = annotation.getQualifiedName();
                                                                                if (type == null || type.startsWith("java.lang.")) {
                                                                                    return;
                                                                                }
                                                                                if (!"android.annotation.SuppressLint".equals(type)) break block14;
                                                                                UElement parent = annotation.getUastParent();
                                                                                if (parent == null) {
                                                                                    return;
                                                                                }
                                                                                if (!(parent instanceof UDeclarationsExpression || parent instanceof ULocalVariable || parent instanceof UParameter)) {
                                                                                    return;
                                                                                }
                                                                                List attributes = annotation.getAttributeValues();
                                                                                if (attributes.size() != 1) break block15;
                                                                                UNamedExpression attribute = (UNamedExpression)attributes.get(0);
                                                                                value = attribute.getExpression();
                                                                                if (!(value instanceof ULiteralExpression)) break block16;
                                                                                Object v = ((ULiteralExpression)value).getValue();
                                                                                if (!(v instanceof String)) break block15;
                                                                                String id = (String)v;
                                                                                this.checkSuppressLint(annotation, id);
                                                                                break block15;
                                                                            }
                                                                            if (!UastExpressionUtils.isArrayInitializer((UElement)value)) break block15;
                                                                            for (UExpression ex : ((UCallExpression)value).getValueArguments()) {
                                                                                String id;
                                                                                Object v;
                                                                                if (!(ex instanceof ULiteralExpression) || !((v = ((ULiteralExpression)ex).getValue()) instanceof String) || this.checkSuppressLint(annotation, id = (String)v)) continue;
                                                                                return;
                                                                            }
                                                                            break block15;
                                                                        }
                                                                        if (!SdkConstants.SUPPORT_ANNOTATIONS_PREFIX.isPrefix(type)) break block17;
                                                                        if (!CHECK_RESULT_ANNOTATION.isEquals(type)) break block18;
                                                                        if (!(annotation.getUastParent() instanceof UMethod) || (method = (UMethod)annotation.getUastParent()).isConstructor() || !PsiType.VOID.equals((Object)method.getReturnType())) break block15;
                                                                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "@CheckResult should not be specified on `void` methods");
                                                                        break block15;
                                                                    }
                                                                    if (!INT_RANGE_ANNOTATION.isEquals(type) && !FLOAT_RANGE_ANNOTATION.isEquals(type)) break block19;
                                                                    if (INT_RANGE_ANNOTATION.isEquals(type)) {
                                                                        this.checkTargetType(annotation, "int", "long", true);
                                                                        long from = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_FROM, (long)Long.MIN_VALUE);
                                                                        long to = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_TO, (long)Long.MAX_VALUE);
                                                                        invalid = from > to;
                                                                    } else {
                                                                        this.checkTargetType(annotation, "float", "double", true);
                                                                        double from = UastLintUtils.getDoubleAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_FROM, (double)Double.NEGATIVE_INFINITY);
                                                                        double to = UastLintUtils.getDoubleAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_TO, (double)Double.POSITIVE_INFINITY);
                                                                        boolean bl = invalid = from > to;
                                                                    }
                                                                    if (!invalid) break block15;
                                                                    this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Invalid range: the `from` attribute must be less than the `to` attribute");
                                                                    break block15;
                                                                }
                                                                if (!SIZE_ANNOTATION.isEquals(type)) break block20;
                                                                unset = -42;
                                                                exact = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)"value", (long)unset);
                                                                min = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MIN, (long)Long.MIN_VALUE);
                                                                long max = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MAX, (long)Long.MAX_VALUE);
                                                                multiple = UastLintUtils.getLongAttribute((JavaContext)this.mContext, (UAnnotation)annotation, (String)AnnotationDetector.ATTR_MULTIPLE, (long)1L);
                                                                if (min <= max) break block21;
                                                                this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Invalid size range: the `min` attribute must be less than the `max` attribute");
                                                                break block15;
                                                            }
                                                            if (multiple >= 1L) break block22;
                                                            this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "The size multiple must be at least 1");
                                                            break block15;
                                                        }
                                                        if ((exact >= 0L || exact == (long)unset) && (min >= 0L || min == Long.MIN_VALUE)) break block15;
                                                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "The size can't be negative");
                                                        break block15;
                                                    }
                                                    if (!ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(type)) break block23;
                                                    this.checkTargetType(annotation, "int", "long", true);
                                                    break block15;
                                                }
                                                if (!ResourceEvaluator.DIMENSION_ANNOTATION.isEquals(type) && !ResourceEvaluator.PX_ANNOTATION.isEquals(type)) break block24;
                                                this.checkTargetType(annotation, "int", "long", "float", "double", true);
                                                break block15;
                                            }
                                            if (!SdkConstants.INT_DEF_ANNOTATION.isEquals(type) && !SdkConstants.LONG_DEF_ANNOTATION.isEquals(type)) break block25;
                                            this.ensureUniqueValues(annotation);
                                            break block15;
                                        }
                                        if (!PERMISSION_ANNOTATION.isEquals(type) && !PERMISSION_ANNOTATION_READ.isEquals(type) && !PERMISSION_ANNOTATION_WRITE.isEquals(type)) break block26;
                                        if (!(annotation.getUastParent() instanceof UMethod)) break block15;
                                        String value = UastLintUtils.getAnnotationStringValue((UAnnotation)annotation, (String)"value");
                                        String[] anyOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)AnnotationDetector.ATTR_ANY_OF);
                                        String[] allOf = UastLintUtils.getAnnotationStringValues((UAnnotation)annotation, (String)AnnotationDetector.ATTR_ALL_OF);
                                        set = 0;
                                        if (value != null) {
                                            ++set;
                                        }
                                        if (allOf != null) {
                                            ++set;
                                        }
                                        if (anyOf != null) {
                                            ++set;
                                        }
                                        if (set != 0) break block27;
                                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "For methods, permission annotation should specify one of `value`, `anyOf` or `allOf`");
                                        break block15;
                                    }
                                    if (set <= 1) break block15;
                                    this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Only specify one of `value`, `anyOf` or `allOf`");
                                    break block15;
                                }
                                if (!HALF_FLOAT_ANNOTATION.isEquals(type)) break block28;
                                this.checkTargetType(annotation, "short", null, true);
                                break block15;
                            }
                            if (!type.endsWith("Res")) break block29;
                            this.checkTargetType(annotation, "int", "long", true);
                            break block15;
                        }
                        if (!RESTRICT_TO_ANNOTATION.isEquals(type)) break block15;
                        attributeValue = annotation.findDeclaredAttributeValue("value");
                        if (attributeValue == null) {
                            attributeValue = annotation.findDeclaredAttributeValue(null);
                        }
                        if (attributeValue != null) break block30;
                        this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "Restrict to what? Expected at least one `RestrictTo.Scope` arguments.");
                        break block15;
                    }
                    String values = attributeValue.asSourceString();
                    if (!values.contains("SUBCLASSES") || !(annotation.getUastParent() instanceof UClass)) break block15;
                    this.mContext.report(ANNOTATION_USAGE, (UElement)annotation, this.mContext.getLocation((UElement)annotation), "`RestrictTo.Scope.SUBCLASSES` should only be specified on methods and fields");
                    break block15;
                }
                PsiClass resolved = annotation.resolve();
                if (resolved != null && (cls = resolved).isAnnotationType() && cls.getModifierList() != null) {
                    for (PsiAnnotation a : cls.getModifierList().getAnnotations()) {
                        String name = a.getQualifiedName();
                        if (SdkConstants.INT_DEF_ANNOTATION.isEquals(name)) {
                            this.checkTargetType(annotation, "int", "long", true);
                            continue;
                        }
                        if (SdkConstants.LONG_DEF_ANNOTATION.isEquals(name)) {
                            this.checkTargetType(annotation, "long", null, true);
                            continue;
                        }
                        if (!SdkConstants.STRING_DEF_ANNOTATION.isEquals(type)) continue;
                        this.checkTargetType(annotation, "java.lang.String", null, true);
                    }
                }
            }
        }

        private void checkTargetType(UAnnotation node, String type, boolean allowCollection) {
            this.checkTargetType(node, type, null, null, null, allowCollection);
        }

        private void checkTargetType(UAnnotation node, String type1, String type2, boolean allowCollection) {
            this.checkTargetType(node, type1, type2, null, null, allowCollection);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkTargetType(UAnnotation node, String type1, String type2, String type3, String type4, boolean allowCollection) {
            PsiType type;
            UElement parent = node.getUastParent();
            if (parent instanceof UDeclarationsExpression) {
                List elements = ((UDeclarationsExpression)parent).getDeclarations();
                if (elements.isEmpty()) return;
                UDeclaration element = (UDeclaration)elements.get(0);
                if (!(element instanceof ULocalVariable)) return;
                type = ((ULocalVariable)element).getType();
            } else if (parent instanceof UMethod) {
                UMethod method = (UMethod)parent;
                type = method.isConstructor() ? this.mContext.getEvaluator().getClassType(method.getContainingClass()) : method.getReturnType();
            } else {
                if (!(parent instanceof UVariable)) return;
                UVariable variable = (UVariable)parent;
                if (variable.getTypeReference() == null) {
                    return;
                }
                type = variable.getType();
            }
            if (type == null) {
                return;
            }
            if (allowCollection) {
                PsiClass resolved;
                PsiClassType classType;
                if (type instanceof PsiArrayType) {
                    type = type.getDeepComponentType();
                } else if (type instanceof PsiClassType && (classType = (PsiClassType)type).getParameters().length == 1 && (resolved = classType.resolve()) != null && this.mContext.getEvaluator().implementsInterface(resolved, "java.util.Collection", false)) {
                    type = classType.getParameters()[0];
                }
            }
            if (!type.isValid()) {
                return;
            }
            String typeName = type.getCanonicalText();
            if (typeName.equals("error.NonExistentClass")) {
                return;
            }
            if (typeName.equals(type1) || typeName.equals(type2) || typeName.equals(type3) || typeName.equals(type4)) return;
            if (typeName.equals(Lint.getAutoBoxedType((String)type1)) || type2 != null && typeName.equals(Lint.getAutoBoxedType((String)type2)) || type3 != null && typeName.equals(Lint.getAutoBoxedType((String)type3)) || type4 != null && typeName.equals(Lint.getAutoBoxedType((String)type4))) {
                return;
            }
            String expectedTypes = type4 != null ? type1 + ", " + type2 + ", " + type3 + ", or " + type4 : (type3 != null ? type1 + ", " + type2 + ", or " + type3 : (type2 != null ? type1 + " or " + type2 : type1));
            if (typeName.equals("java.lang.String")) {
                typeName = "String";
            }
            String message2 = String.format("This annotation does not apply for type %1$s; expected %2$s", typeName, expectedTypes);
            Location location = this.mContext.getLocation((UElement)node);
            this.mContext.report(ANNOTATION_USAGE, (UElement)node, location, message2);
        }

        public void visitSwitchExpression(USwitchExpression switchExpression) {
            UAnnotation annotation;
            UExpression condition = switchExpression.getExpression();
            if (condition != null && PsiType.INT.equals((Object)condition.getExpressionType()) && (annotation = this.findIntDefAnnotation(condition)) != null) {
                UExpression value = annotation.findAttributeValue("value");
                if (value == null) {
                    value = annotation.findAttributeValue(null);
                }
                if (value != null && UastExpressionUtils.isArrayInitializer((UElement)value)) {
                    List allowedValues = ((UCallExpression)value).getValueArguments();
                    switchExpression.accept((UastVisitor)new SwitchChecker(switchExpression, allowedValues));
                }
            }
        }

        private UAnnotation findIntDefAnnotation(UExpression expression) {
            if (expression instanceof UReferenceExpression) {
                PsiLocalVariable variable;
                UExpression lastAssignment;
                PsiElement resolved = ((UReferenceExpression)expression).resolve();
                if (resolved instanceof PsiModifierListOwner) {
                    PsiAnnotation[] annotations = this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)resolved, true);
                    PsiAnnotation[] relevantAnnotations = AnnotationDetector.filterRelevantAnnotations(this.mContext.getEvaluator(), annotations);
                    UAnnotation annotation = TypedefDetector.Companion.findIntDef(JavaUAnnotation.wrap((PsiAnnotation[])relevantAnnotations));
                    if (annotation != null) {
                        return annotation;
                    }
                }
                if (resolved instanceof PsiLocalVariable && (lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)(variable = (PsiLocalVariable)resolved), (UElement)expression)) != null) {
                    return this.findIntDefAnnotation(lastAssignment);
                }
            } else if (expression instanceof UCallExpression) {
                PsiMethod method = ((UCallExpression)expression).resolve();
                if (method != null) {
                    PsiAnnotation[] annotations = this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)method, true);
                    PsiAnnotation[] relevantAnnotations = AnnotationDetector.filterRelevantAnnotations(this.mContext.getEvaluator(), annotations);
                    List uAnnotations = JavaUAnnotation.wrap((PsiAnnotation[])relevantAnnotations);
                    UAnnotation annotation = TypedefDetector.Companion.findIntDef(uAnnotations);
                    if (annotation != null) {
                        return annotation;
                    }
                }
            } else if (expression instanceof UIfExpression) {
                UAnnotation result;
                UIfExpression ifExpression = (UIfExpression)expression;
                if (ifExpression.getThenExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getThenExpression())) != null) {
                    return result;
                }
                if (ifExpression.getElseExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getElseExpression())) != null) {
                    return result;
                }
            } else {
                if (expression instanceof JavaUTypeCastExpression) {
                    return this.findIntDefAnnotation(((JavaUTypeCastExpression)expression).getOperand());
                }
                if (expression instanceof UParenthesizedExpression) {
                    return this.findIntDefAnnotation(((UParenthesizedExpression)expression).getExpression());
                }
            }
            return null;
        }

        private Integer getConstantValue(PsiField intDefConstantRef) {
            Object constant = intDefConstantRef.computeConstantValue();
            if (constant instanceof Number) {
                return ((Number)constant).intValue();
            }
            return null;
        }

        private void ensureUniqueValues(UAnnotation node) {
            boolean flag;
            UExpression value = node.findDeclaredAttributeValue("value");
            if (value == null) {
                value = node.findDeclaredAttributeValue(null);
            }
            if (value == null) {
                return;
            }
            if (!UastExpressionUtils.isArrayInitializer((UElement)value)) {
                return;
            }
            List initializers = ((UCallExpression)value).getValueArguments();
            HashMap valueToIndex = Maps.newHashMapWithExpectedSize((int)initializers.size());
            boolean bl = flag = UastLintUtils.getAnnotationBooleanValue((UAnnotation)node, (String)"flag") == Boolean.TRUE;
            if (flag) {
                this.ensureUsingFlagStyle(initializers);
            }
            ConstantEvaluator constantEvaluator = new ConstantEvaluator();
            for (int index = 0; index < initializers.size(); ++index) {
                UExpression expression = (UExpression)initializers.get(index);
                Object o = constantEvaluator.evaluate((UElement)expression);
                if (!(o instanceof Number)) continue;
                Number number = (Number)o;
                if (valueToIndex.containsKey(number)) {
                    Number repeatedValue = number;
                    int prevIndex = (Integer)valueToIndex.get(number);
                    UExpression prevConstant = (UExpression)initializers.get(prevIndex);
                    String message2 = String.format("Constants `%1$s` and `%2$s` specify the same exact value (%3$s); this is usually a cut & paste or merge error", expression.asSourceString(), prevConstant.asSourceString(), repeatedValue.toString());
                    Location location = this.mContext.getLocation((UElement)expression);
                    Location secondary = this.mContext.getLocation((UElement)prevConstant);
                    secondary.setMessage("Previous same value");
                    location.setSecondary(secondary);
                    UElement scope = AnnotationDetector.getAnnotationScope(node);
                    this.mContext.report(UNIQUE, scope, location, message2);
                    break;
                }
                valueToIndex.put(number, index);
            }
        }

        private void ensureUsingFlagStyle(List<UExpression> constants) {
            if (constants.size() < 3) {
                return;
            }
            for (UExpression constant : constants) {
                long value;
                PsiLiteral literal;
                Object o;
                PsiExpression initializer;
                PsiElement resolved;
                if (!(constant instanceof UReferenceExpression) || (resolved = ((UReferenceExpression)constant).resolve()) instanceof PsiCompiledElement || !(resolved instanceof PsiField) || !((initializer = ((PsiField)resolved).getInitializer()) instanceof PsiLiteral) || !((o = (literal = (PsiLiteral)initializer).getValue()) instanceof Number) || Math.abs(value = ((Number)o).longValue()) <= 1L || Long.bitCount(value) != 1) continue;
                int shift = Long.numberOfTrailingZeros(value);
                if (AnnotationDetector.this.mWarnedFlags == null) {
                    AnnotationDetector.this.mWarnedFlags = Sets.newHashSet();
                }
                if (!AnnotationDetector.this.mWarnedFlags.add(resolved)) {
                    return;
                }
                String message2 = String.format("Consider declaring this constant using 1 << %1$d instead", shift);
                String replace = String.format(Locale.ROOT, "1%s << %d", o instanceof Long ? "L" : "", shift);
                LintFix fix = AnnotationDetector.this.fix().replace().sharedName("Change declaration to <<").with(replace).autoFix().build();
                Location location = this.mContext.getLocation((PsiElement)initializer);
                this.mContext.report(FLAG_STYLE, (PsiElement)initializer, location, message2, fix);
            }
        }

        private boolean checkSuppressLint(UAnnotation node, String id) {
            IssueRegistry registry = this.mContext.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains(Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                UElement scope = AnnotationDetector.getAnnotationScope(node);
                this.mContext.report(INSIDE_METHOD, scope, this.mContext.getLocation((UElement)node), String.format("The `@SuppressLint` annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id));
                return false;
            }
            return true;
        }

        private class SwitchChecker
        extends AbstractUastVisitor {
            private final USwitchExpression mSwitchExpression;
            private final List<UExpression> mAllowedValues;
            private final List<Object> mFields;
            private final List<Integer> mSeenValues;
            private boolean mReported = false;

            private SwitchChecker(USwitchExpression switchExpression, List<UExpression> allowedValues) {
                this.mSwitchExpression = switchExpression;
                this.mAllowedValues = allowedValues;
                this.mFields = Lists.newArrayListWithCapacity((int)allowedValues.size());
                for (UExpression allowedValue : allowedValues) {
                    if (allowedValue instanceof ExternalReferenceExpression) {
                        ExternalReferenceExpression externalRef = (ExternalReferenceExpression)allowedValue;
                        PsiElement resolved = UastLintUtils.resolve((ExternalReferenceExpression)externalRef, (UElement)switchExpression);
                        if (!(resolved instanceof PsiField)) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (allowedValue instanceof UReferenceExpression) {
                        PsiElement resolved = ((UReferenceExpression)allowedValue).resolve();
                        if (resolved == null) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (!(allowedValue instanceof ULiteralExpression)) continue;
                    this.mFields.add(allowedValue);
                }
                this.mSeenValues = Lists.newArrayListWithCapacity((int)allowedValues.size());
            }

            public boolean visitSwitchClauseExpression(USwitchClauseExpression node) {
                if (this.mReported) {
                    return true;
                }
                if (this.mAllowedValues == null) {
                    return true;
                }
                List caseValues = node.getCaseValues();
                if (caseValues.isEmpty()) {
                    this.mFields.clear();
                    return true;
                }
                for (UExpression caseValue : caseValues) {
                    UExpression initializer;
                    if (caseValue instanceof ULiteralExpression) {
                        List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mAllowedValues);
                        String message2 = "Don't use a constant here; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                        AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)caseValue, AnnotationChecker.this.mContext.getLocation((UElement)caseValue), message2);
                        this.mReported = true;
                        continue;
                    }
                    if (!(caseValue instanceof UReferenceExpression)) continue;
                    PsiElement resolved = ((UReferenceExpression)caseValue).resolve();
                    if (resolved == null) {
                        return true;
                    }
                    if (!(resolved instanceof PsiField)) continue;
                    PsiField resolvedField = (PsiField)resolved;
                    boolean found = AnnotationDetector.removeFieldFromList(this.mFields, resolvedField);
                    if (!found && (initializer = AnnotationChecker.this.mContext.getUastContext().getInitializerBody((PsiVariable)((PsiField)resolved))) instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) instanceof PsiField) {
                        found = AnnotationDetector.removeFieldFromList(this.mFields, (PsiField)resolved);
                    }
                    if (found) {
                        Integer cv = AnnotationChecker.this.getConstantValue((PsiField)resolved);
                        if (cv == null) continue;
                        this.mSeenValues.add(cv);
                        continue;
                    }
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mAllowedValues);
                    String message3 = "Unexpected constant; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                    LintFix fix = AnnotationDetector.this.fix().data(new Object[]{list});
                    Location location = AnnotationChecker.this.mContext.getNameLocation((UElement)caseValue);
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)caseValue, location, message3, fix);
                }
                return true;
            }

            public void afterVisitSwitchExpression(USwitchExpression node) {
                this.reportMissingSwitchCases();
                super.afterVisitSwitchExpression(node);
            }

            private void reportMissingSwitchCases() {
                if (this.mReported) {
                    return;
                }
                if (this.mAllowedValues == null) {
                    return;
                }
                if (!this.mFields.isEmpty()) {
                    ListIterator<Object> iterator = this.mFields.listIterator();
                    while (iterator.hasNext()) {
                        Integer cv;
                        Object next = iterator.next();
                        if (!(next instanceof PsiField) || !this.mSeenValues.contains(cv = AnnotationChecker.this.getConstantValue((PsiField)next))) continue;
                        iterator.remove();
                    }
                }
                if (!this.mFields.isEmpty()) {
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mFields);
                    String message2 = "Switch statement on an `int` with known associated constant missing case " + Joiner.on((String)", ").join((Iterable)list);
                    LintFix fix = AnnotationDetector.this.fix().data(new Object[]{list});
                    Location location = AnnotationChecker.this.mContext.getLocation((UElement)this.mSwitchExpression.getSwitchIdentifier());
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, (UElement)this.mSwitchExpression, location, message2, fix);
                }
            }
        }
    }
}

