/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.projectmodel.ProjectType;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.BlacklistedDeps;
import com.android.tools.lint.checks.DeprecatedSdkRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.GradleDetector$Companion$WhenMappings;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.StringHelper;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 {2\u00020\u00012\u00020\u0002:\u0002{|B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\bH\u0002J,\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010'H\u0002J\u001a\u0010)\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010*\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010+\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010%\u001a\u0004\u0018\u00010\rH\u0002J0\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\r2\u0006\u00101\u001a\u00020\rH\u0002J \u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020-2\u0006\u00104\u001a\u00020\rH\u0002JJ\u00105\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010'2\u0006\u00104\u001a\u00020\r2\u0006\u0010:\u001a\u00020\r2\u0006\u00101\u001a\u00020\rH\u0016J \u0010;\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020\rH\u0002J \u0010<\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u00107\u001a\u00020'2\u0006\u0010:\u001a\u00020\rH\u0002JL\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010>\u001a\u00020'2\b\u00108\u001a\u0004\u0018\u00010'2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020'0@2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020'0B2\u0006\u0010%\u001a\u00020\rH\u0016J \u0010C\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010D\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\rH\u0002J \u0010E\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u00107\u001a\u00020'2\u0006\u0010%\u001a\u00020\rH\u0002J0\u0010F\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010D\u001a\u00020G2\u0006\u0010H\u001a\u00020'2\u0006\u0010%\u001a\u00020\rH\u0002J2\u0010I\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010D\u001a\u00020G2\b\u0010J\u001a\u0004\u0018\u00010G2\u0006\u0010%\u001a\u00020\rH\u0002J\u0010\u0010K\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-H\u0002J:\u0010L\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020-2\b\u0010D\u001a\u0004\u0018\u00010G2\u0006\u0010%\u001a\u00020\r2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0002J\"\u0010P\u001a\u0004\u0018\u00010G2\u0006\u0010.\u001a\u00020/2\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010RH\u0002J\u0016\u0010S\u001a\u00020T2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020T0VH\u0002J\b\u0010W\u001a\u00020\u0005H\u0004J \u0010X\u001a\u0004\u0018\u00010'2\u0006\u0010\u001f\u001a\u00020 2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020Z0BH\u0002J\u0010\u0010[\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020]H\u0002J*\u0010^\u001a\u0004\u0018\u00010G2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010RH\u0002J\u0010\u0010_\u001a\u00020\u00112\u0006\u0010\\\u001a\u00020]H\u0002J\u001a\u0010`\u001a\u0004\u0018\u00010G2\u0006\u0010a\u001a\u00020G2\u0006\u0010b\u001a\u00020GH\u0002J\"\u0010`\u001a\u0004\u0018\u00010G2\u0006\u0010a\u001a\u00020G2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000bH\u0002J*\u0010`\u001a\u0004\u0018\u00010G2\u0006\u0010a\u001a\u00020G2\u0006\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000b2\u0006\u0010O\u001a\u00020\u000bH\u0002J\u0018\u0010c\u001a\u00020'2\u0006\u0010.\u001a\u00020/2\u0006\u0010D\u001a\u00020'H\u0002J\u0010\u0010d\u001a\u00020\u000b2\u0006\u00107\u001a\u00020'H\u0002J\u0018\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020'2\u0006\u0010h\u001a\u00020'H\u0002J0\u0010i\u001a\n\u0012\u0004\u0012\u00020G\u0018\u00010R2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010j\u001a\u00020'2\u0006\u0010H\u001a\u00020'H\u0002J\u0018\u0010k\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010j\u001a\u00020'H\u0002J4\u0010l\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\r2\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020'2\n\b\u0002\u0010p\u001a\u0004\u0018\u00010fH\u0002J \u0010q\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010r\u001a\u00020s2\u0006\u0010o\u001a\u00020'H\u0002J \u0010q\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\r2\u0006\u0010o\u001a\u00020'H\u0002J*\u0010q\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\r2\u0006\u0010o\u001a\u00020'2\b\u0010p\u001a\u0004\u0018\u00010fH\u0002J \u0010t\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010r\u001a\u00020s2\u0006\u0010o\u001a\u00020'H\u0002J,\u0010t\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\r2\u0006\u0010o\u001a\u00020'2\n\b\u0002\u0010u\u001a\u0004\u0018\u00010fH\u0002J\u001a\u0010v\u001a\u0004\u0018\u00010/2\u0006\u0010\u001f\u001a\u00020-2\u0006\u0010w\u001a\u00020/H\u0002J\u0010\u0010x\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\bH\u0002J\f\u0010y\u001a\u00020\u0016*\u00020TH\u0002J\f\u0010z\u001a\u00020\u0016*\u00020TH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcom/android/tools/lint/checks/GradleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "artifactCacheHome", "Ljava/io/File;", "blacklisted", "Ljava/util/HashMap;", "Lcom/android/tools/lint/detector/api/Project;", "Lcom/android/tools/lint/checks/BlacklistedDeps;", "compileSdkVersion", "", "compileSdkVersionCookie", "", "deprecatedSdkRegistry", "Lcom/android/tools/lint/checks/DeprecatedSdkRegistry;", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "gradleUserHome", "getGradleUserHome", "()Ljava/io/File;", "mAppliedKotlinAndroidPlugin", "", "mAppliedKotlinKaptPlugin", "mCheckedGms", "mCheckedSupportLibs", "mCheckedWearableLibs", "minSdkVersion", "targetSdkVersion", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "beforeCheckRootProject", "checkBlacklistedDependencies", "project", "checkConsistentLibraries", "cookie", "groupId", "", "groupId2", "checkConsistentPlayServices", "checkConsistentSupportLibraries", "checkConsistentWearableLibraries", "checkDependency", "Lcom/android/tools/lint/detector/api/GradleContext;", "dependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "isResolved", "statementCookie", "checkDeprecatedConfigurations", "configuration", "propertyCookie", "checkDslPropertyAssignment", "property", "value", "parent", "parentParent", "valueCookie", "checkGradlePluginDependency", "checkIntegerAsString", "checkMethodCall", "statement", "namedArguments", "", "unnamedArguments", "", "checkMinSdkVersion", "version", "checkOctal", "checkPlayServices", "Lcom/android/ide/common/repository/GradleVersion;", "revision", "checkSupportLibraries", "newerVersion", "checkTargetCompatibility", "ensureTargetCompatibleWithO", "major", "minor", "micro", "findCachedNewerVersion", "filter", "Ljava/util/function/Predicate;", "findFirst", "Lcom/android/builder/model/MavenCoordinates;", "coordinates", "", "getArtifactCacheHome", "getBlacklistedDependencyMessage", "path", "Lcom/android/builder/model/Library;", "getDeprecatedLibraryLookup", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getGoogleMavenRepoVersion", "getGoogleMavenRepository", "getNewerVersion", "version1", "version2", "getNewerVersionAvailableMessage", "getSdkVersion", "getUpdateDependencyFix", "Lcom/android/tools/lint/detector/api/LintFix;", "currentVersion", "suggestedVersion", "getUpgradeVersionFilter", "artifactId", "isSupportLibraryDependentOnCompileSdk", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "fix", "reportFatalCompatibilityIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "reportNonFatalCompatibilityIssue", "lintFix", "resolveCoordinate", "gc", "usesLegacyHttpLibrary", "isAndroidxArtifact", "isSupportLibArtifact", "Companion", "DeprecatedConfiguration", "lint-checks"})
public class GradleDetector
extends Detector
implements GradleScanner {
    private int minSdkVersion;
    private int compileSdkVersion;
    private Object compileSdkVersionCookie;
    private int targetSdkVersion;
    private File artifactCacheHome;
    private boolean mCheckedGms;
    private boolean mCheckedSupportLibs;
    private boolean mCheckedWearableLibs;
    private boolean mAppliedKotlinAndroidPlugin;
    private boolean mAppliedKotlinKaptPlugin;
    private final HashMap<Project, BlacklistedDeps> blacklisted = new HashMap();
    private GoogleMavenRepository googleMavenRepository;
    private DeprecatedSdkRegistry deprecatedSdkRegistry;
    @Nullable
    private static Calendar calendar;
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_CONFIGURATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue PATH;
    @JvmField
    @NotNull
    public static final Issue IDE_SUPPORT;
    @JvmField
    @NotNull
    public static final Issue PLUS;
    @JvmField
    @NotNull
    public static final Issue GRADLE_GETTER;
    @JvmField
    @NotNull
    public static final Issue COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue STRING_INTEGER;
    @JvmField
    @NotNull
    public static final Issue NOT_INTERPOLATED;
    @JvmField
    @NotNull
    public static final Issue REMOTE_VERSION;
    @JvmField
    @NotNull
    public static final Issue MIN_SDK_TOO_LOW;
    @JvmField
    @NotNull
    public static final Issue ACCIDENTAL_OCTAL;
    @JvmField
    @NotNull
    public static final Issue BUNDLED_GMS;
    @JvmField
    @NotNull
    public static final Issue HIGH_APP_VERSION_CODE;
    @JvmField
    @NotNull
    public static final Issue DEV_MODE_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_CLASSES;
    @JvmField
    @NotNull
    public static final Issue EXPIRING_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue EXPIRED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDING_WITHOUT_KAPT;
    @JvmField
    @NotNull
    public static final Issue LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8;
    @JvmField
    @NotNull
    public static final Issue RISKY_LIBRARY;
    @NotNull
    public static final String APP_PLUGIN_ID = "com.android.application";
    @NotNull
    public static final String LIB_PLUGIN_ID = "com.android.library";
    @NotNull
    public static final String OLD_APP_PLUGIN_ID = "android";
    @NotNull
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    @NotNull
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    @NotNull
    public static final String FIREBASE_GROUP_ID = "com.google.firebase";
    @NotNull
    public static final String GOOGLE_SUPPORT_GROUP_ID = "com.google.android.support";
    @NotNull
    public static final String ANDROID_WEAR_GROUP_ID = "com.google.android.wearable";
    private static final String WEARABLE_ARTIFACT_ID = "wearable";
    private static final GradleCoordinate PLAY_SERVICES_V650;
    private static final int VERSION_CODE_HIGH_THRESHOLD = 2000000000;
    private static int majorBuildTools;
    private static GradleVersion latestBuildTools;
    public static final Companion Companion;

    @NotNull
    protected File getGradleUserHome() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return new File(gradleUserHome);
    }

    private final void checkOctal(GradleContext context, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || value.charAt(1) >= '8' && GradleContext.Companion.isNonNegativeInteger(value)) && context.isEnabled(ACCIDENTAL_OCTAL)) {
            String string;
            StringBuilder stringBuilder;
            String message2 = "The leading 0 turns this number into octal which is probably not what was intended";
            StringBuilder stringBuilder2 = new StringBuilder().append(message2);
            try {
                stringBuilder = stringBuilder2;
                Long numericValue = Long.decode(value);
                string = " (interpreted as " + numericValue + ')';
            }
            catch (NumberFormatException numberFormatException) {
                stringBuilder = stringBuilder2;
                string = " (and it is not a valid octal number)";
            }
            message2 = stringBuilder.append(string).toString();
            GradleDetector.report$default(this, (Context)context, cookie, ACCIDENTAL_OCTAL, message2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)propertyCookie, (String)"propertyCookie");
        Intrinsics.checkParameterIsNotNull((Object)valueCookie, (String)"valueCookie");
        Intrinsics.checkParameterIsNotNull((Object)statementCookie, (String)"statementCookie");
        if (Intrinsics.areEqual((Object)parent, (Object)"defaultConfig")) {
            int version;
            int version2;
            if (Intrinsics.areEqual((Object)property, (Object)"targetSdkVersion")) {
                version2 = this.getSdkVersion(value);
                if (version2 > 0 && version2 < context.getClient().getHighestKnownApiLevel()) {
                    boolean warned = false;
                    if (version2 <= 25) {
                        String message2;
                        Calendar calendar = GradleDetector.calendar;
                        if (calendar == null) {
                            calendar = Calendar.getInstance();
                        }
                        Calendar now = calendar;
                        int year = now.get(1);
                        int month = now.get(2);
                        if (year > 2018 || month >= 10) {
                            boolean alreadySuppressed;
                            message2 = "Google Play requires that apps target API level 26 or higher.\n";
                            int highest = context.getClient().getHighestKnownApiLevel();
                            String label = "Update targetSdkVersion to " + highest;
                            LintFix fix = this.fix().name(label).replace().all().with(Integer.toString(highest)).build();
                            boolean bl = alreadySuppressed = context.containsCommentSuppress() && context.isSuppressedWithComment(valueCookie, EXPIRING_TARGET_SDK_VERSION);
                            if (!alreadySuppressed) {
                                this.report((Context)context, valueCookie, EXPIRED_TARGET_SDK_VERSION, message2, fix);
                            }
                            warned = true;
                        } else if (month >= 4 && year == 2018) {
                            message2 = "Google Play will soon require that apps target API level 26 or higher. This will be required for new apps in August 2018, and for updates to existing apps in November 2018.";
                            int highest = context.getClient().getHighestKnownApiLevel();
                            String label = "Update targetSdkVersion to " + highest;
                            LintFix fix = this.fix().name(label).replace().all().with(Integer.toString(highest)).build();
                            this.report((Context)context, valueCookie, EXPIRING_TARGET_SDK_VERSION, message2, fix);
                            warned = true;
                        }
                    }
                    if (!warned) {
                        String message3 = "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the android.os.Build.VERSION_CODES javadoc for details.";
                        int highest = context.getClient().getHighestKnownApiLevel();
                        String label = "Update targetSdkVersion to " + highest;
                        LintFix fix = this.fix().name(label).replace().all().with(Integer.toString(highest)).build();
                        Context context2 = (Context)context;
                        Issue issue = ManifestDetector.TARGET_NEWER;
                        Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"TARGET_NEWER");
                        this.report(context2, valueCookie, issue, message3, fix);
                    }
                }
                if (version2 > 0) {
                    this.targetSdkVersion = version2;
                    this.checkTargetCompatibility(context);
                } else {
                    this.checkIntegerAsString(context, value, valueCookie);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"minSdkVersion")) {
                version2 = this.getSdkVersion(value);
                if (version2 > 0) {
                    this.minSdkVersion = version2;
                    this.checkMinSdkVersion(context, version2, valueCookie);
                } else {
                    this.checkIntegerAsString(context, value, valueCookie);
                }
            }
            if (StringsKt.startsWith$default((String)value, (String)"0", (boolean)false, (int)2, null)) {
                this.checkOctal(context, value, valueCookie);
            }
            if (Intrinsics.areEqual((Object)property, (Object)"versionName") || Intrinsics.areEqual((Object)property, (Object)"versionCode") && !GradleContext.Companion.isNonNegativeInteger(value) || !GradleContext.Companion.isStringLiteral(value)) {
                if (Intrinsics.areEqual((Object)value, (Object)"getVersionCode") || Intrinsics.areEqual((Object)value, (Object)"getVersionName")) {
                    String message4 = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                    GradleDetector.report$default(this, (Context)context, valueCookie, GRADLE_GETTER, message4, null, 16, null);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"packageName")) {
                String message5 = "Deprecated: Replace 'packageName' with 'applicationId'";
                LintFix fix = this.fix().name("Replace 'packageName' with 'applicationId'", true).replace().text("packageName").with("applicationId").autoFix().build();
                this.report((Context)context, context.getPropertyKeyCookie(valueCookie), DEPRECATED, message5, fix);
            }
            if (Intrinsics.areEqual((Object)property, (Object)"versionCode") && context.isEnabled(HIGH_APP_VERSION_CODE) && GradleContext.Companion.isNonNegativeInteger(value) && (version = GradleContext.Companion.getIntLiteralValue(value, -1)) >= 2000000000) {
                String message6 = "The 'versionCode' is very high and close to the max allowed value";
                GradleDetector.report$default(this, (Context)context, valueCookie, HIGH_APP_VERSION_CODE, message6, null, 16, null);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"compileSdkVersion") && Intrinsics.areEqual((Object)parent, (Object)OLD_APP_PLUGIN_ID)) {
            int version = -1;
            if (GradleContext.Companion.isStringLiteral(value)) {
                AndroidVersion platformVersion;
                String hash = GradleContext.Companion.getStringLiteralValue(value);
                if (hash != null && !Lint.isNumberString((String)hash) && (platformVersion = AndroidTargetHash.getPlatformVersion((String)hash)) != null) {
                    version = platformVersion.getFeatureLevel();
                }
            } else {
                version = GradleContext.Companion.getIntLiteralValue(value, -1);
            }
            if (version > 0) {
                this.compileSdkVersion = version;
                this.compileSdkVersionCookie = valueCookie;
                this.checkTargetCompatibility(context);
            } else {
                this.checkIntegerAsString(context, value, valueCookie);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"buildToolsVersion") && Intrinsics.areEqual((Object)parent, (Object)OLD_APP_PLUGIN_ID)) {
            GradleVersion version;
            String versionString = GradleContext.Companion.getStringLiteralValue(value);
            if (versionString != null && (version = GradleVersion.tryParse((String)versionString)) != null) {
                String message7;
                GradleVersion recommended = GradleDetector.Companion.getLatestBuildTools(context.getClient(), version.getMajor());
                if (recommended != null && version.compareTo(recommended) < 0) {
                    message7 = "Old buildToolsVersion " + version + "; recommended version is " + recommended + " or later";
                    String string = version.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"version.toString()");
                    String string2 = recommended.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"recommended.toString()");
                    LintFix fix = this.getUpdateDependencyFix(string, string2);
                    this.report((Context)context, valueCookie, DEPENDENCY, message7, fix);
                }
                if (version.getMajor() == 23 && version.getMinor() == 0 && version.getMicro() == 0 && context.isEnabled(COMPATIBILITY)) {
                    if (recommended == null || recommended.getMajor() < 23) {
                        recommended = new GradleVersion(23, 0, 3);
                    }
                    message7 = "Build Tools `23.0.0` should not be used; " + "it has some known serious bugs. Use version `" + recommended + "` " + "instead.";
                    this.reportFatalCompatibilityIssue((Context)context, valueCookie, message7);
                }
            }
        } else if (Intrinsics.areEqual((Object)parent, (Object)"plugins")) {
            if (Intrinsics.areEqual((Object)property, (Object)"id")) {
                String plugin = GradleContext.Companion.getStringLiteralValue(value);
                boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
                if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                    String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                    String message8 = '\'' + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                    LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                    this.report((Context)context, valueCookie, DEPRECATED, message8, fix);
                }
                if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                    this.mAppliedKotlinAndroidPlugin = true;
                }
                if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                    this.mAppliedKotlinKaptPlugin = true;
                }
            }
        } else if (Intrinsics.areEqual((Object)parent, (Object)"dependencies")) {
            if (StringsKt.startsWith$default((String)value, (String)"files('", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"')", (boolean)false, (int)2, null)) {
                String message9;
                String isOldAppPlugin = value;
                int replaceWith = "files('".length();
                int message8 = value.length() - 2;
                boolean fix = false;
                String string = isOldAppPlugin.substring(replaceWith, message8);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String path = string;
                if (StringsKt.contains$default((CharSequence)path, (CharSequence)"\\\\", (boolean)false, (int)2, null)) {
                    message9 = "Do not use Windows file separators in .gradle files; use / instead";
                    GradleDetector.report$default(this, (Context)context, valueCookie, PATH, message9, null, 16, null);
                } else if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || new File(StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).isAbsolute()) {
                    message9 = "Avoid using absolute paths in .gradle files";
                    GradleDetector.report$default(this, (Context)context, valueCookie, PATH, message9, null, 16, null);
                }
            } else {
                String dependency = GradleContext.Companion.getStringLiteralValue(value);
                if (dependency == null) {
                    dependency = Companion.getNamedDependency(value);
                }
                if (dependency != null) {
                    LintFix fix;
                    String message10;
                    void gc;
                    Ref.ObjectRef message11 = new Ref.ObjectRef();
                    message11.element = GradleCoordinate.parseCoordinateString((String)dependency);
                    Ref.BooleanRef replaceWith = new Ref.BooleanRef();
                    replaceWith.element = false;
                    if ((GradleCoordinate)gc.element != null && StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null)) {
                        if (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && context.isEnabled(NOT_INTERPOLATED)) {
                            message10 = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                            String string = value;
                            int n = 1;
                            int n2 = value.length() - 1;
                            StringBuilder stringBuilder = new StringBuilder().append("\"");
                            LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().name("Replace single quotes with double quotes").replace().text(value);
                            boolean bl = false;
                            String string3 = string.substring(n, n2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            String string4 = string3;
                            fix = replaceStringBuilder.with(stringBuilder.append(string4).append("\"").toString()).build();
                            this.report((Context)context, statementCookie, NOT_INTERPOLATED, message10, fix);
                        }
                        gc.element = this.resolveCoordinate(context, (GradleCoordinate)gc.element);
                        isResolved.element = true;
                    }
                    if ((GradleCoordinate)gc.element != null) {
                        void isResolved;
                        if (((GradleCoordinate)gc.element).acceptsGreaterRevisions()) {
                            message10 = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependency + ")";
                            fix = this.fix().data(new Object[]{(GradleCoordinate)gc.element});
                            this.report((Context)context, valueCookie, PLUS, message10, fix);
                        }
                        context.getDriver().runLaterOutsideReadAction(new Runnable(this, context, (Ref.ObjectRef)gc, (Ref.BooleanRef)isResolved, valueCookie, statementCookie){
                            final /* synthetic */ GradleDetector this$0;
                            final /* synthetic */ GradleContext $context;
                            final /* synthetic */ Ref.ObjectRef $gc;
                            final /* synthetic */ Ref.BooleanRef $isResolved;
                            final /* synthetic */ Object $valueCookie;
                            final /* synthetic */ Object $statementCookie;

                            public final void run() {
                                GradleDetector.access$checkDependency(this.this$0, this.$context, (GradleCoordinate)this.$gc.element, this.$isResolved.element, this.$valueCookie, this.$statementCookie);
                            }
                            {
                                this.this$0 = gradleDetector;
                                this.$context = gradleContext;
                                this.$gc = objectRef;
                                this.$isResolved = booleanRef;
                                this.$valueCookie = object;
                                this.$statementCookie = object2;
                            }
                        });
                    }
                    if (GradleDetector.Companion.hasLifecycleAnnotationProcessor(dependency) && GradleDetector.Companion.targetJava8Plus(context.getProject())) {
                        this.report((Context)context, valueCookie, LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8, "Use the Lifecycle Java 8 API provided by the `lifecycle-common-java8` library instead of Lifecycle annotations for faster incremental build.", null);
                    }
                }
                this.checkDeprecatedConfigurations(property, context, propertyCookie);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"packageNameSuffix")) {
            String message12 = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
            LintFix fix = this.fix().name("Replace 'packageNameSuffix' with 'applicationIdSuffix'", true).replace().text("packageNameSuffix").with("applicationIdSuffix").autoFix().build();
            this.report((Context)context, context.getPropertyKeyCookie(valueCookie), DEPRECATED, message12, fix);
        } else if (Intrinsics.areEqual((Object)property, (Object)"applicationIdSuffix")) {
            String suffix = GradleContext.Companion.getStringLiteralValue(value);
            if (suffix != null && !StringsKt.startsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null)) {
                String message13 = "Application ID suffix should probably start with a \".\"";
                GradleDetector.report$default(this, (Context)context, valueCookie, PATH, message13, null, 16, null);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"minSdkVersion") && Intrinsics.areEqual((Object)parent, (Object)"dev") && Intrinsics.areEqual((Object)"21", (Object)value) && Intrinsics.areEqual((Object)"gradle", (Object)LintClient.Companion.getClientName()) ^ true) {
            GradleDetector.report$default(this, (Context)context, statementCookie, DEV_MODE_OBSOLETE, "You no longer need a `dev` mode to enable multi-dexing during development, and this can break API version checks", null, 16, null);
        } else if ((Intrinsics.areEqual((Object)property, (Object)"enabled") || Intrinsics.areEqual((Object)property, (Object)"isEnabled")) && Intrinsics.areEqual((Object)parent, (Object)"dataBinding") && Intrinsics.areEqual((Object)value, (Object)"true") && this.mAppliedKotlinAndroidPlugin && !this.mAppliedKotlinKaptPlugin) {
            String message14 = "If you plan to use data binding in a Kotlin project, you should apply the kotlin-kapt plugin.";
            this.report((Context)context, valueCookie, DATA_BINDING_WITHOUT_KAPT, message14, null);
        }
    }

    private final void checkDeprecatedConfigurations(String configuration, GradleContext context, Object propertyCookie) {
        GradleVersion gradleVersion = context.getProject().getGradleModelVersion();
        if (gradleVersion != null) {
            if (!gradleVersion.isAtLeastIncludingPreviews(3, 0, 0)) {
                return;
            }
        }
        for (DeprecatedConfiguration deprecatedConfiguration : DeprecatedConfiguration.values()) {
            if (!deprecatedConfiguration.matches(configuration)) continue;
            if (deprecatedConfiguration == DeprecatedConfiguration.COMPILE && GradleDetector.Companion.suggestApiConfigurationUse(context.getProject(), configuration)) {
                String implementation = null;
                String api = null;
                if (Intrinsics.areEqual((Object)configuration, (Object)"compile")) {
                    implementation = "implementation";
                    api = "api";
                } else {
                    String prefix = StringsKt.removeSuffix((String)configuration, (CharSequence)"Compile");
                    implementation = prefix + "Implementation";
                    api = prefix + "Api";
                }
                String message2 = '`' + configuration + "` is deprecated; " + "replace with either `" + api + "` to maintain current behavior, " + "or `" + implementation + "` to improve build performance " + "by not sharing this dependency transitively.";
                LintFix apiFix = this.fix().name("Replace '" + configuration + "' with '" + api + '\'').family("Replace compile with api").replace().text(configuration).with(api).independent(true).build();
                LintFix implementationFix = this.fix().name("Replace '" + configuration + "' with '" + implementation + '\'').family("Replace compile with implementation").replace().text(configuration).with(implementation).independent(true).build();
                LintFix fixes = this.fix().alternatives().name("Replace '" + configuration + "' with '" + api + "' or '" + implementation + '\'').add(apiFix).add(implementationFix).build();
                this.report((Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message2, fixes);
                continue;
            }
            String replacement = deprecatedConfiguration.replacement(configuration);
            String message3 = '`' + configuration + "` is deprecated; replace with `" + replacement + '`';
            LintFix fix = this.fix().name("Replace '" + configuration + "' with '" + replacement + '\'').family("Replace deprecated configurations").replace().text(configuration).with(replacement).autoFix().build();
            this.report((Context)context, propertyCookie, DEPRECATED_CONFIGURATION, message3, fix);
        }
    }

    private final void checkMinSdkVersion(GradleContext context, int version, Object valueCookie) {
        int n = version;
        if (1 <= n && 13 >= n) {
            String message2 = "The value of minSdkVersion is too low. It can be incremented without noticeably reducing the number of supported devices.";
            String label = "Update minSdkVersion to 14";
            LintFix fix = this.fix().name(label).replace().text(Integer.toString(version)).with(Integer.toString(14)).build();
            this.report((Context)context, valueCookie, MIN_SDK_TOO_LOW, message2, fix);
        }
    }

    private final void checkIntegerAsString(GradleContext context, String value, Object valueCookie) {
        String string = GradleContext.Companion.getStringLiteralValue(value);
        if (Lint.isNumberString((String)string)) {
            String message2 = "Use an integer rather than a string here (replace " + value + " with just " + string + ')';
            LintFix fix = this.fix().name("Replace with integer", true).replace().text(value).with(string).build();
            this.report((Context)context, valueCookie, STRING_INTEGER, message2, fix);
        }
    }

    public void checkMethodCall(@NotNull GradleContext context, @NotNull String statement, @Nullable String parent, @NotNull Map<String, String> namedArguments, @NotNull List<String> unnamedArguments, @NotNull Object cookie) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull(namedArguments, (String)"namedArguments");
        Intrinsics.checkParameterIsNotNull(unnamedArguments, (String)"unnamedArguments");
        Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
        String plugin = namedArguments.get("plugin");
        if (Intrinsics.areEqual((Object)statement, (Object)"apply") && parent == null) {
            boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
            if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                String message2 = '\'' + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                this.report((Context)context, cookie, DEPRECATED, message2, fix);
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                this.mAppliedKotlinAndroidPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                this.mAppliedKotlinKaptPlugin = true;
            }
        }
    }

    private final void checkTargetCompatibility(GradleContext context) {
        if (this.compileSdkVersion > 0 && this.targetSdkVersion > 0 && this.targetSdkVersion > this.compileSdkVersion) {
            String message2 = "The compileSdkVersion (" + this.compileSdkVersion + ") should not be lower than the targetSdkVersion (" + this.targetSdkVersion + ")";
            LintFix fix = this.fix().name("Set compileSdkVersion to " + this.targetSdkVersion).replace().text(Integer.toString(this.compileSdkVersion)).with(Integer.toString(this.targetSdkVersion)).build();
            Context context2 = (Context)context;
            Object object = this.compileSdkVersionCookie;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            this.reportNonFatalCompatibilityIssue(context2, object, message2, fix);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDependency(GradleContext context, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        block39: {
            block34: {
                block38: {
                    block35: {
                        block32: {
                            block33: {
                                block37: {
                                    block36: {
                                        version = dependency.getVersion();
                                        groupId = dependency.getGroupId();
                                        artifactId = dependency.getArtifactId();
                                        revision = dependency.getRevision();
                                        if (version == null || groupId == null || artifactId == null) {
                                            return;
                                        }
                                        newerVersion = null;
                                        v0 = revision;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"revision");
                                        filter = this.getUpgradeVersionFilter(context, groupId, artifactId, v0);
                                        var12_12 = groupId;
                                        switch (var12_12.hashCode()) {
                                            case 432891823: {
                                                if (!var12_12.equals("com.android.tools.build")) ** break;
                                                break;
                                            }
                                            case -1893440090: {
                                                if (!var12_12.equals("com.squareup.okhttp3")) ** break;
                                                break block32;
                                            }
                                            case -491662668: {
                                                if (!var12_12.equals("org.apache.httpcomponents")) ** break;
                                                break block33;
                                            }
                                            case 1502450888: {
                                                if (!var12_12.equals("com.bugsnag")) ** break;
                                                break block34;
                                            }
                                            case -1266275135: {
                                                if (!var12_12.equals("com.github.bumptech.glide")) ** break;
                                                break block35;
                                            }
                                            case 2042560118: {
                                                if (!var12_12.equals("com.google.guava")) ** break;
                                                break block36;
                                            }
                                            case 325967270: {
                                                if (!var12_12.equals("com.google.android.gms")) ** break;
                                                ** GOTO lbl51
                                            }
                                            case 726153860: {
                                                if (!var12_12.equals("com.google.code.gson")) ** break;
                                                break block37;
                                            }
                                            case 288657178: {
                                                if (!var12_12.equals("io.fabric.tools")) ** break;
                                                break block38;
                                            }
                                            case 26640288: {
                                                if (!var12_12.equals("com.google.android.wearable")) ** break;
                                                ** GOTO lbl51
                                            }
                                            case -225004625: {
                                                if (!var12_12.equals("com.google.firebase")) ** break;
                                                ** GOTO lbl51
                                            }
                                            case -315438450: {
                                                if (!var12_12.equals("org.robolectric")) ** break;
                                                break block39;
                                            }
                                            case 1356232872: {
                                                if (!var12_12.equals("com.google.android.support")) ** break;
lbl51:
                                                // 4 sources

                                                this.checkPlayServices(context, dependency, version, revision, cookie);
                                                ** break;
                                            }
                                        }
                                        if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) ** break;
                                        if (this.checkGradlePluginDependency(context, dependency, cookie)) {
                                            return;
                                        }
                                        newerVersion = GradleVersion.max((GradleVersion)version, (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, filter));
                                        ** break;
                                    }
                                    if (!Intrinsics.areEqual((Object)"guava", (Object)artifactId)) ** break;
                                    newerVersion = this.getNewerVersion(version, 21, 0);
                                    ** break;
                                }
                                if (!Intrinsics.areEqual((Object)"gson", (Object)artifactId)) ** break;
                                newerVersion = this.getNewerVersion(version, 2, 8, 2);
                                ** break;
                            }
                            if (!Intrinsics.areEqual((Object)"httpclient", (Object)artifactId)) ** break;
                            newerVersion = this.getNewerVersion(version, 4, 5, 5);
                            ** break;
                        }
                        if (!Intrinsics.areEqual((Object)"okhttp", (Object)artifactId)) ** break;
                        newerVersion = this.getNewerVersion(version, 3, 10, 0);
                        ** break;
                    }
                    if (!Intrinsics.areEqual((Object)"glide", (Object)artifactId)) ** break;
                    newerVersion = this.getNewerVersion(version, 3, 7, 0);
                    ** break;
                }
                if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) ** break;
                parsed = GradleVersion.tryParse((String)revision);
                if (parsed != null && parsed.compareTo("1.21.6") < 0) {
                    fix = this.getUpdateDependencyFix(revision, "1.22.1");
                    this.report((Context)context, cookie, GradleDetector.DEPENDENCY, "Use Fabric Gradle plugin version 1.21.6 or later to " + "improve Instant Run performance (was " + revision + ')', (LintFix)fix);
                    ** break;
                }
                newerVersion = this.getNewerVersion(version, new GradleVersion(1, 25, 1));
                ** break;
            }
            if (!Intrinsics.areEqual((Object)"bugsnag-android-gradle-plugin", (Object)artifactId)) ** break;
            if (!version.isAtLeast(2, 1, 2)) {
                fix = this.getUpdateDependencyFix(revision, "2.4.1");
                this.report((Context)context, cookie, GradleDetector.DEPENDENCY, "Use BugSnag Gradle plugin version 2.1.2 or later to " + "improve Instant Run performance (was " + revision + ')', (LintFix)fix);
                ** break;
            }
            newerVersion = this.getNewerVersion(version, 3, 2, 5);
            ** break;
        }
        if (!Intrinsics.areEqual((Object)"robolectric", (Object)artifactId)) ** break;
        v1 = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"System.getProperty(\"os.name\")");
        fix = v1;
        v2 = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"Locale.US");
        fix = v2;
        var15_15 = false;
        v3 = fix;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        v4 = v3.toLowerCase(fix);
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"(this as java.lang.String).toLowerCase(locale)");
        if (StringsKt.contains$default((CharSequence)v4, (CharSequence)"windows", (boolean)false, (int)2, null) && !version.isAtLeast(4, 2, 1)) {
            fix = this.getUpdateDependencyFix(revision, "4.2.1");
            this.report((Context)context, cookie, GradleDetector.DEPENDENCY, "Use robolectric version 4.2.1 or later to fix issues with parsing of Windows paths", (LintFix)fix);
        }
lbl113:
        // 37 sources

        blacklistedDeps = this.blacklisted.get(context.getProject());
        if (blacklistedDeps != null && (path = blacklistedDeps.checkDependency(groupId, artifactId, true)) != null && (message = this.getBlacklistedDependencyMessage((Context)context, path)) != null) {
            fix = this.fix().name("Delete dependency").replace().all().build();
            this.report((Context)context, statementCookie, GradleDetector.DUPLICATE_CLASSES, message, fix);
        }
        if ((deprecated = (sdkRegistry = this.getDeprecatedLibraryLookup(context.getClient())).getVersionInfo(dependency)) != null) {
            prefix = null;
            issue = null;
            if (Intrinsics.areEqual((Object)deprecated.getStatus(), (Object)"insecure")) {
                prefix = "This version is known to be insecure.";
                issue = GradleDetector.RISKY_LIBRARY;
            } else {
                prefix = "This version is " + deprecated.getStatus() + '.';
                issue = GradleDetector.DEPRECATED_LIBRARY;
            }
            suffix = null;
            fix = null;
            recommended = deprecated.getRecommended();
            if (recommended != null) {
                suffix = " Consider switching to recommended version " + recommended + '.';
                v5 = dependency.getRevision();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"dependency.revision");
                fix = this.getUpdateDependencyFix(v5, recommended);
            } else {
                suffix = "";
                fix = null;
            }
            var21_22 = deprecated.getMessage();
            var22_23 = false;
            separatorDot = var21_22.length() > 0 != false && StringsKt.endsWith$default((String)deprecated.getMessage(), (String)".", (boolean)false, (int)2, null) == false ? "." : "";
            message = prefix + " Details: " + deprecated.getMessage() + separatorDot + suffix;
            this.report((Context)context, statementCookie, issue, message, fix);
        } else {
            recommended = sdkRegistry.getRecommendedVersion(dependency);
            if (recommended != null && (newerVersion == null || recommended.compareTo(newerVersion) > 0)) {
                newerVersion = recommended;
            }
        }
        issue = GradleDetector.DEPENDENCY;
        if (context.getScope().size() > 1 && context.isEnabled(GradleDetector.REMOTE_VERSION) && (latest = GradleDetector.Companion.getLatestVersionFromRemoteRepo(context.getClient(), dependency, filter, dependency.isPreview())) != null && version.compareTo(latest) < 0) {
            newerVersion = latest;
            issue = GradleDetector.REMOTE_VERSION;
        }
        newerVersion = GradleVersion.max((GradleVersion)newerVersion, (GradleVersion)this.findCachedNewerVersion(dependency, filter));
        newerVersion = GradleVersion.max((GradleVersion)newerVersion, (GradleVersion)context.getClient().getHighestKnownVersion(dependency, filter));
        newerVersion = GradleVersion.max((GradleVersion)newerVersion, (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, filter));
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.support") || Intrinsics.areEqual((Object)groupId, (Object)"com.android.support.test")) {
            this.checkSupportLibraries(context, dependency, version, newerVersion, cookie);
        }
        if (newerVersion != null && newerVersion.compareTo(version) > 0) {
            v6 = newerVersion.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"newerVersion.toString()");
            versionString = v6;
            message = this.getNewerVersionAvailableMessage(dependency, versionString);
            fix = isResolved == false ? this.getUpdateDependencyFix(revision, versionString) : null;
            this.report((Context)context, cookie, issue, message, fix);
        }
    }

    private final Predicate<GradleVersion> getUpgradeVersionFilter(GradleContext context, String groupId, String artifactId, String revision) {
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId)) {
            if (this.compileSdkVersion >= 18) {
                return new Predicate<GradleVersion>(this){
                    final /* synthetic */ GradleDetector this$0;

                    public final boolean test(@NotNull GradleVersion version) {
                        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                        return version.getMajor() == GradleDetector.access$getCompileSdkVersion$p(this.this$0);
                    }
                    {
                        this.this$0 = gradleDetector;
                    }
                };
            }
            if (this.targetSdkVersion > 0) {
                return new Predicate<GradleVersion>(this){
                    final /* synthetic */ GradleDetector this$0;

                    public final boolean test(@NotNull GradleVersion version) {
                        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                        return version.getMajor() >= GradleDetector.access$getTargetSdkVersion$p(this.this$0);
                    }
                    {
                        this.this$0 = gradleDetector;
                    }
                };
            }
        }
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.tools.build") && LintClient.Companion.isStudio()) {
            String string = context.getClient().getClientRevision();
            if (string == null) {
                return null;
            }
            String clientRevision = string;
            GradleVersion ideVersion = GradleVersion.parse((String)clientRevision);
            GradleVersion version = GradleVersion.parse((String)revision);
            return new Predicate<GradleVersion>(ideVersion, version){
                final /* synthetic */ GradleVersion $ideVersion;
                final /* synthetic */ GradleVersion $version;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean test(@NotNull GradleVersion v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    int n = v.getMajor();
                    GradleVersion gradleVersion = this.$ideVersion;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"ideVersion");
                    if (n == gradleVersion.getMajor()) {
                        int n2 = v.getMinor();
                        GradleVersion gradleVersion2 = this.$ideVersion;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"ideVersion");
                        if (n2 == gradleVersion2.getMinor()) return true;
                    }
                    int n3 = v.getMajor();
                    GradleVersion gradleVersion3 = this.$version;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion3, (String)"version");
                    if (n3 != gradleVersion3.getMajor()) return false;
                    int n4 = v.getMinor();
                    GradleVersion gradleVersion4 = this.$version;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion4, (String)"version");
                    if (n4 != gradleVersion4.getMinor()) return false;
                    return true;
                }
                {
                    this.$ideVersion = gradleVersion;
                    this.$version = gradleVersion2;
                }
            };
        }
        return null;
    }

    @NotNull
    protected final File getArtifactCacheHome() {
        File file = this.artifactCacheHome;
        if (file == null) {
            File home;
            GradleDetector gradleDetector = this;
            boolean bl = false;
            boolean bl2 = false;
            GradleDetector $this$run = gradleDetector;
            boolean bl3 = false;
            $this$run.artifactCacheHome = home = new File($this$run.getGradleUserHome(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1");
            file = home;
        }
        return file;
    }

    private final GradleVersion findCachedNewerVersion(GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        File versionDir = new File(this.getArtifactCacheHome(), dependency.getGroupId() + File.separator + dependency.getArtifactId());
        return versionDir.exists() ? MavenRepositories.getHighestVersion((File)versionDir, filter, (boolean)MavenRepositories.isPreview((GradleCoordinate)dependency), (FileOp)FileOpUtils.create()) : null;
    }

    private final void ensureTargetCompatibleWithO(GradleContext context, GradleVersion version, Object cookie, int major, int minor, int micro) {
        if (version != null && !version.isAtLeast(major, minor, micro)) {
            GradleVersion revision = new GradleVersion(major, minor, micro);
            GradleVersion newest = this.getNewerVersion(version, revision);
            if (newest != null) {
                revision = newest;
            }
            String message2 = "Version must be at least " + revision + " when targeting O";
            this.reportFatalCompatibilityIssue((Context)context, cookie, message2);
        }
    }

    private final boolean checkGradlePluginDependency(GradleContext context, GradleCoordinate dependency, Object cookie) {
        GradleCoordinate minimum = GradleCoordinate.parseCoordinateString((String)"com.android.tools.build:gradle:1.0.0");
        if (minimum != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, minimum) < 0) {
            GradleVersion recommended = GradleVersion.max((GradleVersion)this.getGoogleMavenRepoVersion(context, minimum, null), (GradleVersion)GradleVersion.tryParse((String)"3.3.2"));
            String message2 = "You must use a newer version of the Android Gradle plugin. The minimum supported version is 1.0.0 and the recommended version is " + recommended;
            GradleDetector.report$default(this, (Context)context, cookie, GRADLE_PLUGIN_COMPATIBILITY, message2, null, 16, null);
            return true;
        }
        return false;
    }

    private final void checkSupportLibraries(GradleContext context, GradleCoordinate dependency, GradleVersion version, GradleVersion newerVersion, Object cookie) {
        String string = dependency.getGroupId();
        if (string == null) {
            return;
        }
        String groupId = string;
        String string2 = dependency.getArtifactId();
        if (string2 == null) {
            return;
        }
        String artifactId = string2;
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId) && this.compileSdkVersion >= 18 && dependency.getMajorVersion() != this.compileSdkVersion && dependency.getMajorVersion() != -1 && context.isEnabled(COMPATIBILITY)) {
            if (this.compileSdkVersion >= 29 && dependency.getMajorVersion() < 29) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, (Context)context, cookie, "Version 28 (intended for Android Pie and below) is the last version of the legacy support library, so we recommend that you migrate to AndroidX libraries when using Android Q and moving forward. The IDE can help with this: Refactor > Migrate to AndroidX...", null, 8, null);
                return;
            }
            LintFix fix = null;
            if (newerVersion != null) {
                fix = this.fix().name("Replace with " + newerVersion).replace().text(version.toString()).with(newerVersion.toString()).build();
            }
            String message2 = "This support library should not use a different version (" + dependency.getMajorVersion() + ") than the `compileSdkVersion` (" + this.compileSdkVersion + ")";
            this.reportNonFatalCompatibilityIssue((Context)context, cookie, message2, fix);
        }
        if (!this.mCheckedSupportLibs && !StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations") ^ true) {
            this.mCheckedSupportLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
                this.checkConsistentSupportLibraries((Context)context, cookie);
            }
        }
        if (Intrinsics.areEqual((Object)"appcompat-v7", (Object)artifactId)) {
            IAndroidTarget buildTarget;
            boolean compile26Beta;
            boolean supportLib26Beta = version.isAtLeast(26, 0, 0, "beta", 1, true);
            boolean bl = compile26Beta = this.compileSdkVersion >= 26;
            if (this.compileSdkVersion == 26 && (buildTarget = context.getProject().getBuildTarget()) != null) {
                AndroidVersion androidVersion = buildTarget.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"buildTarget.version");
                if (androidVersion.isPreview()) {
                    boolean bl2 = compile26Beta = buildTarget.getRevision() != 1;
                }
            }
            if (supportLib26Beta && !compile26Beta && this.compileSdkVersion == version.getMajor()) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, (Context)context, cookie, "When using a `compileSdkVersion` older than android-O revision 2, the support library version must be 26.0.0-alpha1 or lower " + "(was " + version + ')', null, 8, null);
            } else if (!supportLib26Beta && compile26Beta) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, (Context)context, cookie, "When using a `compileSdkVersion` android-O revision 2 or higher, the support library version should be 26.0.0-beta1 " + "or higher (was " + version + ')', null, 8, null);
            }
            if (this.minSdkVersion >= 14 && this.compileSdkVersion >= 1 && this.compileSdkVersion < 21) {
                GradleDetector.report$default(this, (Context)context, cookie, DEPENDENCY, "Using the appcompat library when minSdkVersion >= 14 and compileSdkVersion < 21 is not necessary", null, 16, null);
            }
        }
    }

    private final void checkPlayServices(GradleContext context, GradleCoordinate dependency, GradleVersion version, String revision, Object cookie) {
        String message2;
        LintFix fix;
        String string = dependency.getGroupId();
        if (string == null) {
            return;
        }
        String groupId = string;
        String string2 = dependency.getArtifactId();
        if (string2 == null) {
            return;
        }
        String artifactId = string2;
        if (Intrinsics.areEqual((Object)"5.2.08", (Object)revision) && context.isEnabled(COMPATIBILITY)) {
            GradleVersion maxVersion = GradleVersion.max((GradleVersion)GradleVersion.parse((String)"10.2.1"), (GradleVersion)this.getGoogleMavenRepoVersion(context, dependency, null));
            String string3 = maxVersion.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"maxVersion.toString()");
            fix = this.getUpdateDependencyFix(revision, string3);
            String message3 = "Version `5.2.08` should not be used; the app " + "can not be published with this version. Use version `" + maxVersion + "` " + "instead.";
            this.reportFatalCompatibilityIssue((Context)context, cookie, message3, fix);
        }
        if (context.isEnabled(BUNDLED_GMS) && PLAY_SERVICES_V650.isSameArtifact(dependency) && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, PLAY_SERVICES_V650) >= 0) {
            message2 = "Avoid using bundled version of Google Play services SDK.";
            GradleDetector.report$default(this, (Context)context, cookie, BUNDLED_GMS, message2, null, 16, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-appindexing", (Object)artifactId)) {
            message2 = "Deprecated: Replace 'com.google.android.gms:play-services-appindexing:" + revision + "' with 'com.google.firebase:firebase-appindexing:10.0.0' or above. " + "More info: http://firebase.google.com/docs/app-indexing/android/migrate";
            fix = this.fix().name("Replace with Firebase").replace().text("com.google.android.gms:play-services-appindexing:" + revision).with("com.google.firebase:firebase-appindexing:10.2.1").build();
            this.report((Context)context, cookie, DEPRECATED, message2, fix);
        }
        if (this.targetSdkVersion >= 26) {
            if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-gcm", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"firebase-messaging", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)"firebase-jobdispatcher", (Object)artifactId) || Intrinsics.areEqual((Object)"firebase-jobdispatcher-with-gcm-dep", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context, version, cookie, 0, 6, 0);
            }
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) || Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId)) {
            if (!this.mCheckedGms) {
                this.mCheckedGms = true;
                if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
                    this.checkConsistentPlayServices((Context)context, cookie);
                }
            }
        } else if (!this.mCheckedWearableLibs) {
            this.mCheckedWearableLibs = true;
            if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
                this.checkConsistentWearableLibraries((Context)context, cookie);
            }
        }
    }

    private final boolean isSupportLibArtifact(@NotNull MavenCoordinates $this$isSupportLibArtifact) {
        String string = $this$isSupportLibArtifact.getGroupId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"groupId");
        String string2 = $this$isSupportLibArtifact.getArtifactId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"artifactId");
        return this.isSupportLibraryDependentOnCompileSdk(string, string2);
    }

    private final boolean isAndroidxArtifact(@NotNull MavenCoordinates $this$isAndroidxArtifact) {
        String string = $this$isAndroidxArtifact.getGroupId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"groupId");
        return StringsKt.startsWith$default((String)string, (String)"androidx.", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)$this$isAndroidxArtifact.getGroupId(), (Object)"androidx.navigation") ^ true;
    }

    private final void checkConsistentSupportLibraries(Context context, Object cookie) {
        this.checkConsistentLibraries(context, cookie, "com.android.support", null);
        Collection<AndroidLibrary> androidLibraries = Companion.getAndroidLibraries(context.getProject());
        MavenCoordinates usesOldSupportLib = null;
        MavenCoordinates usesAndroidX = null;
        for (AndroidLibrary library : androidLibraries) {
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            if (usesOldSupportLib == null) {
                MavenCoordinates mavenCoordinates = coordinates;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"coordinates");
                if (this.isSupportLibArtifact(mavenCoordinates)) {
                    usesOldSupportLib = coordinates;
                }
            }
            if (usesAndroidX == null) {
                MavenCoordinates mavenCoordinates = coordinates;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"coordinates");
                if (this.isAndroidxArtifact(mavenCoordinates)) {
                    usesAndroidX = coordinates;
                }
            }
            if (usesOldSupportLib == null || usesAndroidX == null) continue;
            break;
        }
        if (usesOldSupportLib != null && usesAndroidX != null) {
            String message2 = "Dependencies using groupId `com.android.support` and `androidx.*` can not be combined but " + "found `" + usesOldSupportLib + "` and `" + usesAndroidX + "` incompatible dependencies";
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context, cookie, message2, null, 8, null);
            } else {
                this.reportNonFatalCompatibilityIssue(context, Lint.guessGradleLocation((Project)context.getProject()), message2);
            }
        }
    }

    private final void checkConsistentPlayServices(Context context, Object cookie) {
        this.checkConsistentLibraries(context, cookie, GMS_GROUP_ID, FIREBASE_GROUP_ID);
    }

    private final void checkConsistentWearableLibraries(Context context, Object cookie) {
        MavenCoordinates coordinates;
        Project project = context.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        HashSet<String> supportVersions = new HashSet<String>();
        HashSet<String> wearableVersions = new HashSet<String>();
        for (AndroidLibrary androidLibrary : Companion.getAndroidLibraries(project)) {
            coordinates = androidLibrary.getResolvedCoordinates();
            if (coordinates == null || !Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) || !Intrinsics.areEqual((Object)GOOGLE_SUPPORT_GROUP_ID, (Object)coordinates.getGroupId())) continue;
            supportVersions.add(coordinates.getVersion());
        }
        for (JavaLibrary javaLibrary : Companion.getJavaLibraries(project)) {
            coordinates = javaLibrary.getResolvedCoordinates();
            if (coordinates == null || !Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) || !Intrinsics.areEqual((Object)ANDROID_WEAR_GROUP_ID, (Object)coordinates.getGroupId())) continue;
            if (!javaLibrary.isProvided()) {
                if (cookie != null) {
                    String message2 = "This dependency should be marked as `provided`, not `compile`";
                    this.reportFatalCompatibilityIssue(context, cookie, message2);
                } else {
                    String message2 = "The com.google.android.wearable:wearable dependency should be marked as `provided`, not `compile`";
                    this.reportFatalCompatibilityIssue(context, Lint.guessGradleLocation((Project)context.getProject()), message2);
                }
            }
            wearableVersions.add(coordinates.getVersion());
        }
        if (!supportVersions.isEmpty()) {
            if (wearableVersions.isEmpty()) {
                ArrayList arrayList = new ArrayList(supportVersions);
                String first = (String)Collections.min(arrayList);
                String message3 = "Project depends on com.google.android.support:wearable:" + first + ", " + "so it must also depend (as a provided dependency) on " + "com.google.android.wearable:wearable:" + first;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message3);
                } else {
                    this.reportFatalCompatibilityIssue(context, Lint.guessGradleLocation((Project)context.getProject()), message3);
                }
            } else if (Intrinsics.areEqual(supportVersions, wearableVersions) ^ true) {
                ArrayList arrayList = new ArrayList(supportVersions);
                CollectionsKt.sort((List)arrayList);
                ArrayList supportedWearableVersions = new ArrayList(wearableVersions);
                CollectionsKt.sort((List)supportedWearableVersions);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "The wearable libraries for %1$s and %2$s must use **exactly** the same versions; found %3$s and %4$s";
                Object[] objectArray = new Object[]{GOOGLE_SUPPORT_GROUP_ID, ANDROID_WEAR_GROUP_ID, arrayList.size() == 1 ? (String)arrayList.get(0) : arrayList.toString(), supportedWearableVersions.size() == 1 ? (String)supportedWearableVersions.get(0) : supportedWearableVersions.toString()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String message3 = string2;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context, cookie, message3);
                } else {
                    this.reportFatalCompatibilityIssue(context, Lint.guessGradleLocation((Project)context.getProject()), message3);
                }
            }
        }
    }

    private final void checkConsistentLibraries(Context context, Object cookie, String groupId, String groupId2) {
        MavenCoordinates coordinates;
        Project project = context.getMainProject();
        ArrayListMultimap versionToCoordinate = ArrayListMultimap.create();
        Collection<AndroidLibrary> androidLibraries = Companion.getAndroidLibraries(project);
        for (AndroidLibrary androidLibrary : androidLibraries) {
            coordinates = androidLibrary.getResolvedCoordinates();
            if (coordinates == null || !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId) && !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId2)) continue;
            String string = coordinates.getArtifactId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"coordinates.artifactId");
            if (StringsKt.startsWith$default((String)string, (String)"multidex", (boolean)false, (int)2, null)) continue;
            String string2 = coordinates.getArtifactId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"coordinates.artifactId");
            if (StringsKt.startsWith$default((String)string2, (String)"renderscript", (boolean)false, (int)2, null)) continue;
            String string3 = coordinates.getArtifactId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"coordinates.artifactId");
            if (StringsKt.startsWith$default((String)string3, (String)"firebase-jobdispatcher", (boolean)false, (int)2, null)) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        for (JavaLibrary javaLibrary : Companion.getJavaLibraries(project)) {
            coordinates = javaLibrary.getResolvedCoordinates();
            if (coordinates == null || !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId) && !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId2) || !(Intrinsics.areEqual((Object)coordinates.getArtifactId(), (Object)"support-annotations") ^ true)) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), (Object)coordinates);
        }
        Set set = versionToCoordinate.keySet();
        if (set.size() > 1) {
            GradleVersion version;
            ArrayList sortedVersions = new ArrayList(set);
            List list = sortedVersions;
            Comparator comparator = Collections.reverseOrder();
            Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"Collections.reverseOrder()");
            CollectionsKt.sortWith((List)list, comparator);
            List list2 = versionToCoordinate.get(sortedVersions.get(0));
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"versionToCoordinate.get(sortedVersions[0])");
            MavenCoordinates c1 = this.findFirst(list2);
            List list3 = versionToCoordinate.get(sortedVersions.get(1));
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"versionToCoordinate.get(sortedVersions[1])");
            MavenCoordinates c2 = this.findFirst(list3);
            if ((Intrinsics.areEqual((Object)groupId, (Object)GMS_GROUP_ID) || Intrinsics.areEqual((Object)groupId, (Object)FIREBASE_GROUP_ID)) && (version = GradleVersion.tryParse((String)c2.getVersion())) != null && (version.getMajor() >= 14 || version.getMajor() == 0)) {
                return;
            }
            String example1 = c1.getGroupId() + ":" + c1.getArtifactId() + ":" + c1.getVersion();
            String example2 = c2.getGroupId() + ":" + c2.getArtifactId() + ":" + c2.getVersion();
            String groupDesc = Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) ? "gms/firebase" : groupId;
            String message2 = "All " + groupDesc + " libraries must use the exact same " + "version specification (mixing versions can lead to runtime crashes). " + "Found versions " + Joiner.on((String)", ").join((Iterable)sortedVersions) + ". " + "Examples include `" + example1 + "` and `" + example2 + "`";
            block2: for (AndroidLibrary library : androidLibraries) {
                MavenCoordinates coordinates2 = library.getResolvedCoordinates();
                if (coordinates2 == null || !Intrinsics.areEqual((Object)coordinates2.getGroupId(), (Object)"com.android.databinding") || !Intrinsics.areEqual((Object)coordinates2.getArtifactId(), (Object)"library")) continue;
                Iterator iterator = library.getLibraryDependencies().iterator();
                while (iterator.hasNext()) {
                    AndroidLibrary dep;
                    AndroidLibrary androidLibrary = dep = (AndroidLibrary)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)androidLibrary, (String)"dep");
                    MavenCoordinates c = androidLibrary.getResolvedCoordinates();
                    if (c == null || !Intrinsics.areEqual((Object)c.getGroupId(), (Object)"com.android.support") || !Intrinsics.areEqual((Object)c.getArtifactId(), (Object)"support-v4") || !(Intrinsics.areEqual((Object)((String)sortedVersions.get(0)), (Object)c.getVersion()) ^ true)) continue;
                    message2 = message2 + ". Note that this project is using data binding (com.android.databinding:library:" + coordinates2.getVersion() + ") which pulls in com.android.support:support-v4:" + c.getVersion() + ". You can try to work around this " + "by adding an explicit dependency on " + "com.android.support:support-v4:" + (String)sortedVersions.get(0);
                    break block2;
                }
                break block2;
            }
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context, cookie, message2, null, 8, null);
            } else {
                File projectDir = context.getProject().getDir();
                LintClient lintClient = context.getClient();
                File file = projectDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"projectDir");
                Location location1 = Lint.guessGradleLocation((LintClient)lintClient, (File)file, (String)example1);
                Location location2 = Lint.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)example2);
                if (location1.getStart() != null) {
                    if (location2.getStart() != null) {
                        location1.setSecondary(location2);
                    }
                } else if (location2.getStart() == null) {
                    location1 = Lint.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)(c1.getGroupId() + ":" + c1.getArtifactId() + ":"));
                    if (location1.getStart() == null) {
                        location1 = Lint.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)(c2.getGroupId() + ":" + c2.getArtifactId() + ":"));
                    }
                } else {
                    location1 = location2;
                }
                this.reportNonFatalCompatibilityIssue(context, location1, message2);
            }
        }
    }

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project = context.getProject();
        ((Map)this.blacklisted).put(project, new BlacklistedDeps(project));
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project = context.getProject();
        if (project == context.getMainProject() && context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.checkConsistentPlayServices(context, null);
            this.checkConsistentSupportLibraries(context, null);
            this.checkConsistentWearableLibraries(context, null);
        }
        this.checkBlacklistedDependencies(context, project);
    }

    private final void checkBlacklistedDependencies(Context context, Project project) {
        BlacklistedDeps blacklistedDeps = this.blacklisted.get(project);
        if (blacklistedDeps == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)blacklistedDeps, (String)"blacklisted[project] ?: return");
        BlacklistedDeps blacklistedDeps2 = blacklistedDeps;
        List<List<Library>> dependencies = blacklistedDeps2.getBlacklistedDependencies();
        if (!dependencies.isEmpty()) {
            for (List<Library> path : dependencies) {
                String message2;
                if (this.getBlacklistedDependencyMessage(context, path) == null) {
                    continue;
                }
                File projectDir = context.getProject().getDir();
                MavenCoordinates coordinates = path.get(0).getRequestedCoordinates();
                if (coordinates == null) {
                    coordinates = path.get(0).getResolvedCoordinates();
                }
                LintClient lintClient = context.getClient();
                File file = projectDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"projectDir");
                StringBuilder stringBuilder = new StringBuilder();
                MavenCoordinates mavenCoordinates = coordinates;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"coordinates");
                Location location = Lint.guessGradleLocation((LintClient)lintClient, (File)file, (String)stringBuilder.append(mavenCoordinates.getGroupId()).append(":").append(coordinates.getArtifactId()).toString());
                if (location.getStart() == null) {
                    location = Lint.guessGradleLocation((LintClient)context.getClient(), (File)projectDir, (String)coordinates.getArtifactId());
                }
                Context.report$default((Context)context, (Issue)DUPLICATE_CLASSES, (Location)location, (String)message2, null, (int)8, null);
            }
        }
        this.blacklisted.remove(project);
    }

    private final void report(Context context, Object cookie, Issue issue, String message2, LintFix fix) {
        context.getClient().runReadAction(new Runnable(context, issue, cookie, message2, fix){
            final /* synthetic */ Context $context;
            final /* synthetic */ Issue $issue;
            final /* synthetic */ Object $cookie;
            final /* synthetic */ String $message;
            final /* synthetic */ LintFix $fix;

            public final void run() {
                if (this.$context.isEnabled(this.$issue) && this.$context instanceof GradleContext) {
                    boolean checkComments = this.$context.containsCommentSuppress();
                    if (checkComments && ((GradleContext)this.$context).isSuppressedWithComment(this.$cookie, this.$issue)) {
                        return;
                    }
                    Location location = ((GradleContext)this.$context).getLocation(this.$cookie);
                    this.$context.report(this.$issue, location, this.$message, this.$fix);
                }
            }
            {
                this.$context = context;
                this.$issue = issue;
                this.$cookie = object;
                this.$message = string;
                this.$fix = lintFix;
            }
        });
    }

    static /* synthetic */ void report$default(GradleDetector gradleDetector, Context context, Object object, Issue issue, String string, LintFix lintFix, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        gradleDetector.report(context, object, issue, string, lintFix);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2) {
        GradleDetector.report$default(this, context, cookie, COMPATIBILITY, message2, null, 16, null);
    }

    private final void reportFatalCompatibilityIssue(Context context, Object cookie, String message2, LintFix fix) {
        this.report(context, cookie, COMPATIBILITY, message2, fix);
    }

    private final void reportNonFatalCompatibilityIssue(Context context, Object cookie, String message2, LintFix lintFix) {
        if (context.getDriver().getFatalOnlyMode()) {
            return;
        }
        this.report(context, cookie, COMPATIBILITY, message2, lintFix);
    }

    static /* synthetic */ void reportNonFatalCompatibilityIssue$default(GradleDetector gradleDetector, Context context, Object object, String string, LintFix lintFix, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportNonFatalCompatibilityIssue");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        gradleDetector.reportNonFatalCompatibilityIssue(context, object, string, lintFix);
    }

    private final void reportFatalCompatibilityIssue(Context context, Location location, String message2) {
        context.getClient().runReadAction(new Runnable(context, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;

            public final void run() {
                Context.report$default((Context)this.$context, (Issue)GradleDetector.COMPATIBILITY, (Location)this.$location, (String)this.$message, null, (int)8, null);
            }
            {
                this.$context = context;
                this.$location = location;
                this.$message = string;
            }
        });
    }

    private final void reportNonFatalCompatibilityIssue(Context context, Location location, String message2) {
        if (context.getDriver().getFatalOnlyMode()) {
            return;
        }
        context.getClient().runReadAction(new Runnable(context, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;

            public final void run() {
                Context.report$default((Context)this.$context, (Issue)GradleDetector.COMPATIBILITY, (Location)this.$location, (String)this.$message, null, (int)8, null);
            }
            {
                this.$context = context;
                this.$location = location;
                this.$message = string;
            }
        });
    }

    private final int getSdkVersion(String value) {
        int version = 0;
        if (GradleContext.Companion.isStringLiteral(value)) {
            String codeName = GradleContext.Companion.getStringLiteralValue(value);
            if (codeName != null) {
                if (Lint.isNumberString((String)codeName)) {
                    return -1;
                }
                AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)codeName, null);
                if (androidVersion != null) {
                    version = androidVersion.getFeatureLevel();
                }
            }
        } else {
            version = GradleContext.Companion.getIntLiteralValue(value, -1);
        }
        return version;
    }

    private final GradleCoordinate resolveCoordinate(GradleContext context, GradleCoordinate gc) {
        String string = gc.getRevision();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gc.revision");
        boolean bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GradleDetector$resolveCoordinate$22 = false;
            String string2 = gc.getRevision();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gc.revision");
            String $i$a$-assert-GradleDetector$resolveCoordinate$22 = string2;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-GradleDetector$resolveCoordinate$22));
        }
        Project project = context.getProject();
        Variant variant = project.getCurrentVariant();
        if (variant != null) {
            Dependencies dependencies;
            AndroidArtifact androidArtifact = variant.getMainArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidArtifact, (String)"variant.mainArtifact");
            Dependencies dependencies2 = dependencies = androidArtifact.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencies2, (String)"dependencies");
            Iterator iterator = dependencies2.getLibraries().iterator();
            while (iterator.hasNext()) {
                AndroidLibrary library;
                AndroidLibrary androidLibrary = library = (AndroidLibrary)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidLibrary, (String)"library");
                MavenCoordinates mc = androidLibrary.getResolvedCoordinates();
                if (mc == null || !Intrinsics.areEqual((Object)mc.getGroupId(), (Object)gc.getGroupId()) || !Intrinsics.areEqual((Object)mc.getArtifactId(), (Object)gc.getArtifactId())) continue;
                List revisions = GradleCoordinate.parseRevisionNumber((String)mc.getVersion());
                if (revisions.isEmpty()) break;
                return new GradleCoordinate(mc.getGroupId(), mc.getArtifactId(), revisions, null);
            }
        }
        return null;
    }

    private final boolean usesLegacyHttpLibrary(Project project) {
        AndroidProject androidProject = project.getGradleProjectModel();
        if (androidProject == null) {
            return false;
        }
        AndroidProject model = androidProject;
        Iterator iterator = model.getBootClasspath().iterator();
        while (iterator.hasNext()) {
            String path;
            String string = path = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            if (!StringsKt.endsWith$default((String)string, (String)"org.apache.http.legacy.jar", (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    private final LintFix getUpdateDependencyFix(String currentVersion, String suggestedVersion) {
        LintFix lintFix = LintFix.create().name("Change to " + suggestedVersion).sharedName("Update versions").replace().text(currentVersion).with(suggestedVersion).autoFix().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)lintFix, (String)"LintFix.create()\n       \u2026ix()\n            .build()");
        return lintFix;
    }

    private final String getNewerVersionAvailableMessage(GradleCoordinate dependency, String version) {
        return "A newer version of " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " than " + dependency.getRevision() + " is available: " + version;
    }

    private final boolean isSupportLibraryDependentOnCompileSdk(String groupId, String artifactId) {
        return Intrinsics.areEqual((Object)"com.android.support", (Object)groupId) && !StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations") ^ true;
    }

    private final MavenCoordinates findFirst(Collection<? extends MavenCoordinates> coordinates) {
        MavenCoordinates mavenCoordinates = Collections.min(coordinates, findFirst.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"Collections.min(\n       \u20262.toString()) }\n        )");
        return mavenCoordinates;
    }

    private final String getBlacklistedDependencyMessage(Context context, List<? extends Library> path) {
        AndroidVersion androidVersion = context.getMainProject().getMinSdkVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"context.mainProject.minSdkVersion");
        if (androidVersion.getApiLevel() >= 23 && !this.usesLegacyHttpLibrary(context.getMainProject())) {
            return null;
        }
        boolean direct = path.size() == 1;
        String message2 = null;
        String resolution = "Solutions include finding newer versions or alternative libraries that don't have the same problem (for example, for `httpclient` use `HttpUrlConnection` or `okhttp` instead), or repackaging the library using something like `jarjar`.";
        if (direct) {
            StringBuilder stringBuilder = new StringBuilder().append('`');
            MavenCoordinates mavenCoordinates = path.get(0).getResolvedCoordinates();
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"path[0].resolvedCoordinates");
            message2 = stringBuilder.append(mavenCoordinates.getArtifactId()).append("` defines classes that conflict with classes now provided by Android. ").append(resolution).toString();
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Library library : path) {
                MavenCoordinates coordinates;
                if (first) {
                    first = false;
                } else {
                    sb.append(" \u2192 ");
                }
                MavenCoordinates mavenCoordinates = coordinates = library.getResolvedCoordinates();
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"coordinates");
                sb.append(mavenCoordinates.getGroupId());
                sb.append(':');
                sb.append(coordinates.getArtifactId());
            }
            sb.append(") ");
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            String string2 = string;
            StringBuilder stringBuilder = new StringBuilder().append('`');
            MavenCoordinates mavenCoordinates = path.get(0).getResolvedCoordinates();
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"path[0].resolvedCoordinates");
            StringBuilder stringBuilder2 = stringBuilder.append(mavenCoordinates.getArtifactId()).append("` depends on a library ").append('(');
            MavenCoordinates mavenCoordinates2 = path.get(path.size() - 1).getResolvedCoordinates();
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates2, (String)"path[path.size - 1].resolvedCoordinates");
            message2 = stringBuilder2.append(mavenCoordinates2.getArtifactId()).append(") which defines ").append("classes that conflict with classes now provided by Android. ").append(resolution).append(' ').append("Dependency chain: ").append(string2).toString();
        }
        return message2;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor, int micro) {
        return !version1.isAtLeast(major, minor, micro) ? new GradleVersion(major, minor, micro) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor) {
        return !version1.isAtLeast(major, minor, 0) ? new GradleVersion(major, minor) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, GradleVersion version2) {
        return version1.compareTo(version2) < 0 ? version2 : null;
    }

    private final GradleVersion getGoogleMavenRepoVersion(GradleContext context, GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        GoogleMavenRepository repository = this.getGoogleMavenRepository(context.getClient());
        return repository.findVersion(dependency, filter, dependency.isPreview());
    }

    private final GoogleMavenRepository getGoogleMavenRepository(LintClient client) {
        GoogleMavenRepository googleMavenRepository = this.googleMavenRepository;
        if (googleMavenRepository == null) {
            GradleDetector gradleDetector = this;
            boolean bl = false;
            boolean bl2 = false;
            GradleDetector $this$run = gradleDetector;
            boolean bl3 = false;
            File cacheDir = client.getCacheDir("maven.google", true);
            GoogleMavenRepository repository = new GoogleMavenRepository(cacheDir, cacheDir, client){
                final /* synthetic */ File $cacheDir;
                final /* synthetic */ LintClient $client$inlined;
                {
                    this.$cacheDir = $captured_local_variable$1;
                    this.$client$inlined = lintClient;
                    super($super_call_param$2, 0, 0, false, 14, null);
                }

                @Nullable
                public byte[] readUrlData(@NotNull String url, int timeout) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    return Lint.readUrlData((LintClient)this.$client$inlined, (String)url, (int)timeout);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                    this.$client$inlined.log(throwable, message2, new Object[0]);
                }
            };
            $this$run.googleMavenRepository = repository;
            googleMavenRepository = repository;
        }
        return googleMavenRepository;
    }

    private final DeprecatedSdkRegistry getDeprecatedLibraryLookup(LintClient client) {
        DeprecatedSdkRegistry deprecatedSdkRegistry = this.deprecatedSdkRegistry;
        if (deprecatedSdkRegistry == null) {
            GradleDetector gradleDetector = this;
            boolean bl = false;
            boolean bl2 = false;
            GradleDetector $this$run = gradleDetector;
            boolean bl3 = false;
            File cacheDir = client.getCacheDir("sdk-registry.xml", true);
            DeprecatedSdkRegistry repository = new DeprecatedSdkRegistry(cacheDir, cacheDir, client){
                final /* synthetic */ File $cacheDir;
                final /* synthetic */ LintClient $client$inlined;
                {
                    this.$cacheDir = $captured_local_variable$1;
                    this.$client$inlined = lintClient;
                    super($super_call_param$2);
                }

                @Nullable
                public byte[] readUrlData(@NotNull String url, int timeout) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    return Lint.readUrlData((LintClient)this.$client$inlined, (String)url, (int)timeout);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                    this.$client$inlined.log(throwable, message2, new Object[0]);
                }
            };
            $this$run.deprecatedSdkRegistry = repository;
            deprecatedSdkRegistry = repository;
        }
        return deprecatedSdkRegistry;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
        DEPENDENCY = Issue.Companion.create("GradleDependency", "Obsolete Gradle Dependency", "\n                This detector looks for usages of libraries where the version you are using \\\n                is not the current stable release. Using older versions is fine, and there \\\n                are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is \\\n                available, and that is what this lint check helps find.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Object object = Severity.WARNING;
        Boolean bl2 = true;
        int n = 6;
        String string = null;
        Object object2 = Category.CORRECTNESS;
        DEPRECATED = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"GradleDeprecated", (String)"Deprecated Gradle Construct", (String)"\n                This detector looks for deprecated Gradle constructs which currently work \\\n                but will likely stop working in a future update.", (Implementation)implementation, string, (Category)object2, (int)n, (Severity)object, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = null;
        bl = false;
        object = IMPLEMENTATION;
        bl2 = Severity.WARNING;
        n = 6;
        string = "https://d.android.com/r/tools/update-dependency-configurations";
        object2 = Category.CORRECTNESS;
        DEPRECATED_CONFIGURATION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"GradleDeprecatedConfiguration", (String)"Deprecated Gradle Configuration", (String)"\n                Some Gradle configurations have been deprecated since Android Gradle Plugin 3.0.0 \\\n                and will be removed in a future version of the Android Gradle Plugin.\n             ", (Implementation)object, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl, (Boolean)implementation, enumSet, collection, (int)3840, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        bl2 = Severity.ERROR;
        n = 8;
        string = null;
        object2 = Category.CORRECTNESS;
        GRADLE_PLUGIN_COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"GradlePluginVersion", (String)"Incompatible Android Gradle Plugin", (String)"\n                Not all versions of the Android Gradle plugin are compatible with all \\\n                versions of the SDK. If you update your tools, or if you are trying to \\\n                open a project that was built with an old version of the tools, you may \\\n                need to update your plugin version number.", (Implementation)implementation, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl, (Boolean)object, enumSet, collection, (int)3344, null);
        PATH = Issue.Companion.create("GradlePath", "Gradle Path Issues", "\n                Gradle build scripts are meant to be cross platform, so file paths use \\\n                Unix-style path separators (a forward slash) rather than Windows path \\\n                separators (a backslash). Similarly, to keep projects portable and \\\n                repeatable, avoid using absolute paths on the system; keep files within \\\n                the project instead. To share code between projects, consider creating \\\n                an android-library and an AAR dependency", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        IDE_SUPPORT = Issue.Companion.create("GradleIdeError", "Gradle IDE Support Issues", "\n                Gradle is highly flexible, and there are things you can do in Gradle \\\n                files which can make it hard or impossible for IDEs to properly handle \\\n                the project. This lint check looks for constructs that potentially \\\n                break IDE support.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        PLUS = Issue.Companion.create("GradleDynamicVersion", "Gradle Dynamic Version", "\n                Using `+` in dependencies lets you automatically pick up the latest \\\n                available version rather than a specific, named version. However, \\\n                this is not recommended; your builds are not repeatable; you may have \\\n                tested with a slightly different version than what the build server \\\n                used. (Using a dynamic version as the major version number is more \\\n                problematic than using it in the minor version position.)", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        bl2 = Severity.ERROR;
        n = 6;
        string = null;
        object2 = Category.CORRECTNESS;
        GRADLE_GETTER = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"GradleGetter", (String)"Gradle Implicit Getter Call", (String)"\n                Gradle will let you replace specific constants in your build scripts \\\n                with method calls, so you can for example dynamically compute a version \\\n                string based on your current version control revision number, rather \\\n                than hardcoding a number.\n\n                When computing a version name, it's tempting to for example call the \\\n                method to do that `getVersionName`. However, when you put that method \\\n                call inside the `defaultConfig` block, you will actually be calling the \\\n                Groovy getter for the `versionName` property instead. Therefore, you \\\n                need to name your method something which does not conflict with the \\\n                existing implicit getters. Consider using `compute` as a prefix instead \\\n                of `get`.", (Implementation)implementation, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl, (Boolean)object, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        bl2 = Severity.FATAL;
        n = 8;
        string = null;
        object2 = Category.CORRECTNESS;
        COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"GradleCompatible", (String)"Incompatible Gradle Versions", (String)"\n                There are some combinations of libraries, or tools and libraries, that \\\n                are incompatible, or can lead to bugs. One such incompatibility is \\\n                compiling with a version of the Android support libraries that is not \\\n                the latest version (or in particular, a version lower than your \\\n                `targetSdkVersion`).", (Implementation)implementation, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl, (Boolean)object, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = IMPLEMENTATION;
        bl = false;
        object = true;
        bl2 = Severity.ERROR;
        n = 8;
        string = null;
        object2 = Category.CORRECTNESS;
        STRING_INTEGER = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"StringShouldBeInt", (String)"String should be int", (String)"\n                The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` \\\n                are usually numbers, but can be strings when you are using an add-on (in \\\n                the case of `compileSdkVersion`) or a preview platform (for the other two \\\n                properties).\n\n                However, you can not use a number as a string (e.g. \"19\" instead of 19); \\\n                that will result in a platform not found error message at build/sync \\\n                time.", (Implementation)implementation, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl, (Boolean)object, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation = null;
        bl = false;
        object = IMPLEMENTATION;
        bl2 = Severity.ERROR;
        n = 8;
        string = Category.CORRECTNESS;
        object2 = "http://www.groovy-lang.org/syntax.html#_string_interpolation";
        NOT_INTERPOLATED = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NotInterpolated", (String)"Incorrect Interpolation", (String)"\n                To insert the value of a variable, you can use `${variable}` inside a \\\n                string literal, but **only** if you are using double quotes!", (Implementation)object, (String)object2, (Category)string, (int)n, (Severity)bl2, (boolean)bl, (Boolean)implementation, enumSet, collection, (int)3840, null);
        collection = null;
        enumSet = null;
        implementation = null;
        bl = false;
        object = IMPLEMENTATION;
        bl2 = Severity.WARNING;
        n = 4;
        string = null;
        object2 = Category.CORRECTNESS;
        REMOTE_VERSION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NewerVersionAvailable", (String)"Newer Library Versions Available", (String)"\n                This detector checks with a central repository to see if there are newer \\\n                versions available for the dependencies used by this project. This is \\\n                similar to the `GradleDependency` check, which checks for newer versions \\\n                available in the Android SDK tools and libraries, but this works with any \\\n                MavenCentral dependency, and connects to the library every time, which \\\n                makes it more flexible but also **much** slower.", (Implementation)object, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl, (Boolean)implementation, enumSet, collection, (int)3600, null);
        collection = null;
        enumSet = null;
        boolean bl3 = false;
        Boolean bl4 = true;
        object = IMPLEMENTATION;
        bl2 = Severity.WARNING;
        n = 4;
        string = null;
        object2 = Category.CORRECTNESS;
        MIN_SDK_TOO_LOW = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MinSdkTooLow", (String)"API Version Too Low", (String)"\n                The value of the `minSdkVersion` property is too low and can be \\\n                incremented without noticeably reducing the number of supported \\\n                devices.", (Implementation)object, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl3, (Boolean)bl4, enumSet, collection, (int)3088, null);
        ACCIDENTAL_OCTAL = Issue.Companion.create("AccidentalOctal", "Accidental Octal", "\n                In Groovy, an integer literal that starts with a leading 0 will be \\\n                interpreted as an octal number. That is usually (always?) an accident \\\n                and can lead to subtle bugs, for example when used in the `versionCode` \\\n                of an app.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
        collection = null;
        enumSet = null;
        Implementation implementation2 = IMPLEMENTATION;
        boolean bl5 = false;
        object = true;
        bl2 = Severity.WARNING;
        n = 4;
        string = Category.PERFORMANCE;
        object2 = "http://developers.google.com/android/guides/setup#split";
        BUNDLED_GMS = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UseOfBundledGooglePlayServices", (String)"Use of bundled version of Google Play services", (String)"\n                Google Play services SDK's can be selectively included, which enables a \\\n                smaller APK size. Consider declaring dependencies on individual Google \\\n                Play services SDK's. If you are using Firebase API's \\\n                (http://firebase.google.com/docs/android/setup), Android Studio's \\\n                Tools \u2192 Firebase assistant window can automatically add just the \\\n                dependencies needed for each feature.", (Implementation)implementation2, (String)object2, (Category)string, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.ERROR;
        n = 8;
        string = Category.CORRECTNESS;
        object2 = "https://developer.android.com/studio/publish/versioning.html";
        HIGH_APP_VERSION_CODE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"HighAppVersionCode", (String)"VersionCode too high", (String)"\n                The declared `versionCode` is an Integer. Ensure that the version number is \\\n                not close to the limit. It is recommended to monotonically increase this \\\n                number each minor or major release of the app. Note that updating an app \\\n                with a versionCode over `Integer.MAX_VALUE` is not possible.", (Implementation)implementation2, (String)object2, (Category)string, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.WARNING;
        n = 2;
        string = null;
        object2 = Category.PERFORMANCE;
        DEV_MODE_OBSOLETE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DevModeObsolete", (String)"Dev Mode Obsolete", (String)"\n                In the past, our documentation recommended creating a `dev` product flavor \\\n                with has a minSdkVersion of 21, in order to enable multidexing to speed up \\\n                builds significantly during development.\n\n                That workaround is no longer necessary, and it has some serious downsides, \\\n                such as breaking API access checking (since the true `minSdkVersion` is no \\\n                longer known).\n\n                In recent versions of the IDE and the Gradle plugin, the IDE automatically \\\n                passes the API level of the connected device used for deployment, and if \\\n                that device is at least API 21, then multidexing is automatically turned \\\n                on, meaning that you get the same speed benefits as the `dev` product \\\n                flavor but without the downsides.", (Implementation)implementation2, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.FATAL;
        n = 8;
        string = null;
        object2 = Category.CORRECTNESS;
        DUPLICATE_CLASSES = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DuplicatePlatformClasses", (String)"Duplicate Platform Classes", (String)"\n                There are a number of libraries that duplicate not just functionality \\\n                of the Android platform but using the exact same class names as the ones \\\n                provided in Android -- for example the apache http classes. This can \\\n                lead to unexpected crashes.\n\n                To solve this, you need to either find a newer version of the library \\\n                which no longer has this problem, or to repackage the library (and all \\\n                of its dependencies) using something like the `jarjar` tool, or finally, \\\n                rewriting the code to use different APIs (for example, for http code, \\\n                consider using `HttpUrlConnection` or a library like `okhttp`).", (Implementation)implementation2, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.ERROR;
        n = 8;
        string = null;
        object2 = Category.COMPLIANCE;
        EXPIRING_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ExpiringTargetSdkVersion", (String)"TargetSdkVersion Soon Expiring", (String)"\n                In the second half of 2018, Google Play will require that new apps and app \\\n                updates target API level 26 or higher. This will be required for new apps in \\\n                August 2018, and for updates to existing apps in November 2018.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                This lint check starts warning you some months **before** these changes go \\\n                into effect if your `targetSdkVersion` is 25 or lower. This is intended to \\\n                give you a heads up to update your app, since depending on your current \\\n                `targetSdkVersion` the work can be nontrivial.\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\",\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", (Implementation)implementation2, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3344, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.FATAL;
        n = 8;
        string = Category.COMPLIANCE;
        object2 = "\n                As of the second half of 2018, Google Play requires that new apps and app \\\n                updates target API level 26 or higher.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\",\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ";
        String string2 = "https://support.google.com/googleplay/android-developer/answer/113469#targetsdk";
        EXPIRED_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"ExpiredTargetSdkVersion", (String)"TargetSdkVersion No Longer Supported", (String)object2, (Implementation)implementation2, (String)string2, (Category)string, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3328, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.ERROR;
        n = 8;
        string = null;
        object2 = Category.COMPLIANCE;
        DEPRECATED_LIBRARY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"OutdatedLibrary", (String)"Outdated Library", (String)"\n                Your app is using an outdated version of a library. This may cause violations \\\n                of Google Play policies (see https://play.google.com/about/monetization-ads/ads/) \\\n                and/or may affect your app\u2019s visibility on the Play Store.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n                ", (Implementation)implementation2, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3344, null);
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.WARNING;
        n = 1;
        string = Category.CORRECTNESS;
        object2 = "\n                Apps that use Kotlin and data binding should also apply the kotlin-kapt plugin. \\\n                ";
        string2 = "https://kotlinlang.org/docs/reference/kapt.html";
        DATA_BINDING_WITHOUT_KAPT = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"DataBindingWithoutKapt", (String)"Data Binding without Annotation Processing", (String)object2, (Implementation)implementation2, (String)string2, (Category)string, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.WARNING;
        n = 6;
        string = Category.PERFORMANCE;
        object2 = "\n                For faster incremental build, switch to the Lifecycle Java 8 API with these steps:\n\n                First replace\n\n                `annotationProcessor \"androidx.lifecycle:lifecycle-compiler:*version*\"`\n                `kapt \"androidx.lifecycle:lifecycle-compiler:*version*\"`\n\n                with\n\n                `implementation \"androidx.lifecycle:lifecycle-common-java8:*version*\"`\n\n                Then remove any `OnLifecycleEvent` annotations from `Observer` classes \\\n                and make them implement the `DefaultLifecycleObserver` interface.\n                ";
        string2 = "https://d.android.com/r/studio-ui/lifecycle-release-notes";
        LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8 = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"LifecycleAnnotationProcessorWithJava8", (String)"Lifecycle Annotation Processor with Java 8 Compile Option", (String)object2, (Implementation)implementation2, (String)string2, (Category)string, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3328, null);
        collection = null;
        enumSet = null;
        implementation2 = IMPLEMENTATION;
        bl5 = false;
        object = true;
        bl2 = Severity.ERROR;
        n = 8;
        string = null;
        object2 = Category.SECURITY;
        RISKY_LIBRARY = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"RiskyLibrary", (String)"Libraries with Privacy or Security Risks", (String)"\n                Your app is using a version of a library that has been identified by \\\n                the library developer as a potential source of privacy and/or security risks. \\\n                This may be a violation of Google Play policies (see \\\n                https://play.google.com/about/monetization-ads/ads/) and/or affect your app\u2019s \\\n                visibility on the Play Store.\n\n                When available, the individual error messages from lint will include details \\\n                about the reasons for this advisory.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n            ", (Implementation)implementation2, (String)string, (Category)object2, (int)n, (Severity)bl2, (boolean)bl5, (Boolean)object, enumSet, collection, (int)3344, null);
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)"com.google.android.gms:play-services:6.5.0");
        if (gradleCoordinate == null) {
            Intrinsics.throwNpe();
        }
        PLAY_SERVICES_V650 = gradleCoordinate;
    }

    public static final /* synthetic */ void access$checkDependency(GradleDetector $this, GradleContext context, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        $this.checkDependency(context, dependency, isResolved, cookie, statementCookie);
    }

    public static final /* synthetic */ int access$getCompileSdkVersion$p(GradleDetector $this) {
        return $this.compileSdkVersion;
    }

    public static final /* synthetic */ void access$setCompileSdkVersion$p(GradleDetector $this, int n) {
        $this.compileSdkVersion = n;
    }

    public static final /* synthetic */ int access$getTargetSdkVersion$p(GradleDetector $this) {
        return $this.targetSdkVersion;
    }

    public static final /* synthetic */ void access$setTargetSdkVersion$p(GradleDetector $this, int n) {
        $this.targetSdkVersion = n;
    }

    @JvmStatic
    @Nullable
    public static final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
        return Companion.getLatestVersionFromRemoteRepo(client, dependency, filter, allowPreview);
    }

    @JvmStatic
    @Nullable
    public static final Dependencies getCompileDependencies(@NotNull Project project) {
        return Companion.getCompileDependencies(project);
    }

    @JvmStatic
    @Nullable
    public static final String getNamedDependency(@NotNull String expression) {
        return Companion.getNamedDependency(expression);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$DeprecatedConfiguration;", "", "deprecatedName", "", "replacementName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "deprecatedSuffix", "replacementSuffix", "matches", "", "configurationName", "replacement", "COMPILE", "PROVIDED", "APK", "lint-checks"})
    private static final class DeprecatedConfiguration
    extends Enum<DeprecatedConfiguration> {
        public static final /* enum */ DeprecatedConfiguration COMPILE;
        public static final /* enum */ DeprecatedConfiguration PROVIDED;
        public static final /* enum */ DeprecatedConfiguration APK;
        private static final /* synthetic */ DeprecatedConfiguration[] $VALUES;
        private final String deprecatedSuffix;
        private final String replacementSuffix;
        private final String deprecatedName;
        private final String replacementName;

        static {
            DeprecatedConfiguration[] deprecatedConfigurationArray = new DeprecatedConfiguration[3];
            DeprecatedConfiguration[] deprecatedConfigurationArray2 = deprecatedConfigurationArray;
            deprecatedConfigurationArray[0] = COMPILE = new DeprecatedConfiguration("compile", "implementation");
            deprecatedConfigurationArray[1] = PROVIDED = new DeprecatedConfiguration("provided", "compileOnly");
            deprecatedConfigurationArray[2] = APK = new DeprecatedConfiguration("apk", "runtimeOnly");
            $VALUES = deprecatedConfigurationArray;
        }

        public final boolean matches(@NotNull String configurationName) {
            Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) || StringsKt.endsWith$default((String)configurationName, (String)this.deprecatedSuffix, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String replacement(@NotNull String configurationName) {
            Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) ? this.replacementName : StringsKt.removeSuffix((String)configurationName, (CharSequence)this.deprecatedSuffix) + this.replacementSuffix;
        }

        private DeprecatedConfiguration(String deprecatedName, String replacementName) {
            this.deprecatedName = deprecatedName;
            this.replacementName = replacementName;
            this.deprecatedSuffix = StringHelper.capitalize((String)this.deprecatedName);
            this.replacementSuffix = StringHelper.capitalize((String)this.replacementName);
        }

        public static DeprecatedConfiguration[] values() {
            return (DeprecatedConfiguration[])$VALUES.clone();
        }

        public static DeprecatedConfiguration valueOf(String string) {
            return Enum.valueOf(DeprecatedConfiguration.class, string);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090;H\u0002J$\u0010<\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u00020=082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020=0;H\u0002J\u0014\u0010>\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010?\u001a\u00020@J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010?\u001a\u00020@H\u0007J\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020=082\u0006\u0010?\u001a\u00020@J\u001a\u0010D\u001a\u0004\u0018\u0001032\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020*H\u0002J2\u0010H\u001a\u0004\u0018\u0001032\u0006\u0010E\u001a\u00020F2\u0006\u0010I\u001a\u00020$2\u000e\u0010J\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010K2\u0006\u0010L\u001a\u00020MH\u0007J\u0012\u0010N\u001a\u0004\u0018\u00010\u00062\u0006\u0010O\u001a\u00020\u0006H\u0007J\u0010\u0010P\u001a\u00020M2\u0006\u0010I\u001a\u00020\u0006H\u0002J\u0018\u0010Q\u001a\u00020M2\u0006\u0010?\u001a\u00020@2\u0006\u0010R\u001a\u00020\u0006H\u0002J\u0010\u0010S\u001a\u00020M2\u0006\u0010?\u001a\u00020@H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion;", "", "()V", "ACCIDENTAL_OCTAL", "Lcom/android/tools/lint/detector/api/Issue;", "ANDROID_WEAR_GROUP_ID", "", "APP_PLUGIN_ID", "BUNDLED_GMS", "COMPATIBILITY", "DATA_BINDING_WITHOUT_KAPT", "DEPENDENCY", "DEPRECATED", "DEPRECATED_CONFIGURATION", "DEPRECATED_LIBRARY", "DEV_MODE_OBSOLETE", "DUPLICATE_CLASSES", "EXPIRED_TARGET_SDK_VERSION", "EXPIRING_TARGET_SDK_VERSION", "FIREBASE_GROUP_ID", "GMS_GROUP_ID", "GOOGLE_SUPPORT_GROUP_ID", "GRADLE_GETTER", "GRADLE_PLUGIN_COMPATIBILITY", "HIGH_APP_VERSION_CODE", "IDE_SUPPORT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "LIB_PLUGIN_ID", "LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8", "MIN_SDK_TOO_LOW", "NOT_INTERPOLATED", "OLD_APP_PLUGIN_ID", "OLD_LIB_PLUGIN_ID", "PATH", "PLAY_SERVICES_V650", "Lcom/android/ide/common/repository/GradleCoordinate;", "PLUS", "REMOTE_VERSION", "RISKY_LIBRARY", "STRING_INTEGER", "VERSION_CODE_HIGH_THRESHOLD", "", "WEARABLE_ARTIFACT_ID", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "setCalendar", "(Ljava/util/Calendar;)V", "latestBuildTools", "Lcom/android/ide/common/repository/GradleVersion;", "majorBuildTools", "addIndirectAndroidLibraries", "", "libraries", "", "Lcom/android/builder/model/AndroidLibrary;", "result", "", "addIndirectJavaLibraries", "Lcom/android/builder/model/JavaLibrary;", "getAndroidLibraries", "project", "Lcom/android/tools/lint/detector/api/Project;", "getCompileDependencies", "Lcom/android/builder/model/Dependencies;", "getJavaLibraries", "getLatestBuildTools", "client", "Lcom/android/tools/lint/client/api/LintClient;", "major", "getLatestVersionFromRemoteRepo", "dependency", "filter", "Ljava/util/function/Predicate;", "allowPreview", "", "getNamedDependency", "expression", "hasLifecycleAnnotationProcessor", "suggestApiConfigurationUse", "configuration", "targetJava8Plus", "lint-checks"})
    public static final class Companion {
        @Nullable
        public final Calendar getCalendar() {
            return calendar;
        }

        public final void setCalendar(@Nullable Calendar calendar) {
            GradleDetector.calendar = calendar;
        }

        @JvmStatic
        @Nullable
        public final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            if (groupId == null || artifactId == null) {
                return null;
            }
            StringBuilder query = new StringBuilder();
            String encoding = Charsets.UTF_8.name();
            try {
                query.append("http://search.maven.org/solrsearch/select?q=g:%22");
                query.append(URLEncoder.encode(groupId, encoding));
                query.append("%22+AND+a:%22");
                query.append(URLEncoder.encode(artifactId, encoding));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            query.append("%22&core=gav");
            if (filter == null && allowPreview) {
                query.append("&rows=1");
            }
            query.append("&wt=json");
            String response = null;
            try {
                String string = query.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.toString()");
                response = Lint.readUrlDataAsString((LintClient)client, (String)string, (int)20000);
                if (response == null) {
                    return null;
                }
            }
            catch (IOException e) {
                client.log(null, "Could not connect to maven central to look up the latest available version for %1$s", new Object[]{dependency});
                return null;
            }
            int index = StringsKt.indexOf$default((CharSequence)response, (String)"\"response\"", (int)0, (boolean)false, (int)6, null);
            while (index != -1) {
                boolean preview;
                String substring;
                if ((index = StringsKt.indexOf$default((CharSequence)response, (String)"\"v\":", (int)index, (boolean)false, (int)4, null)) == -1) continue;
                int start = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(index += 4), (boolean)false, (int)4, null) + 1;
                int end = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(start + 1), (boolean)false, (int)4, null);
                int n = start;
                if (0 > n || end - 1 < n) continue;
                String string = response;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                GradleVersion revision = GradleVersion.tryParse((String)substring);
                if (revision == null) continue;
                boolean bl2 = preview = revision.isPreview() && !StringsKt.endsWith$default((String)substring, (String)"-android", (boolean)false, (int)2, null);
                if (!allowPreview && preview || filter != null && !filter.test(revision)) continue;
                return revision;
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final Dependencies getCompileDependencies(@NotNull Project project) {
            AndroidArtifact artifact;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (!project.isGradleProject()) {
                return null;
            }
            Variant variant = project.getCurrentVariant();
            if (variant == null) {
                return null;
            }
            Variant variant2 = variant;
            AndroidArtifact androidArtifact = artifact = variant2.getMainArtifact();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidArtifact, (String)"artifact");
            return androidArtifact.getDependencies();
        }

        @NotNull
        public final Collection<AndroidLibrary> getAndroidLibraries(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Dependencies dependencies = this.getCompileDependencies(project);
            if (dependencies == null) {
                return CollectionsKt.emptyList();
            }
            Dependencies compileDependencies = dependencies;
            HashSet allLibraries = new HashSet();
            Collection collection = compileDependencies.getLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"compileDependencies.libraries");
            this.addIndirectAndroidLibraries(collection, allLibraries);
            return allLibraries;
        }

        @NotNull
        public final Collection<JavaLibrary> getJavaLibraries(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Dependencies dependencies = this.getCompileDependencies(project);
            if (dependencies == null) {
                return CollectionsKt.emptyList();
            }
            Dependencies compileDependencies = dependencies;
            HashSet allLibraries = new HashSet();
            Collection collection = compileDependencies.getJavaLibraries();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"compileDependencies.javaLibraries");
            this.addIndirectJavaLibraries(collection, allLibraries);
            return allLibraries;
        }

        private final void addIndirectAndroidLibraries(Collection<? extends AndroidLibrary> libraries, Set<AndroidLibrary> result) {
            for (AndroidLibrary androidLibrary : libraries) {
                if (result.contains(androidLibrary)) continue;
                result.add(androidLibrary);
                List list = androidLibrary.getLibraryDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"library.libraryDependencies");
                this.addIndirectAndroidLibraries(list, result);
            }
        }

        private final void addIndirectJavaLibraries(Collection<? extends JavaLibrary> libraries, Set<JavaLibrary> result) {
            for (JavaLibrary javaLibrary : libraries) {
                if (result.contains(javaLibrary)) continue;
                result.add(javaLibrary);
                List list = javaLibrary.getDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"library.dependencies");
                this.addIndirectJavaLibraries(list, result);
            }
        }

        @JvmStatic
        @Nullable
        public final String getNamedDependency(@NotNull String expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            if (StringsKt.indexOf$default((CharSequence)expression, (char)',', (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.contains$default((CharSequence)expression, (CharSequence)"version:", (boolean)false, (int)2, null)) {
                String artifact = null;
                String group = null;
                String version = null;
                Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
                Iterator iterator = splitter.split((CharSequence)expression).iterator();
                while (iterator.hasNext()) {
                    String value;
                    int valueEnd;
                    String property;
                    String string = property = (String)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property");
                    int colon = StringsKt.indexOf$default((CharSequence)string, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon == -1) {
                        return null;
                    }
                    char quote = '\'';
                    int valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    if (valueStart == -1) {
                        quote = '\"';
                        valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    }
                    if (valueStart == -1) continue;
                    if ((valueEnd = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(++valueStart), (boolean)false, (int)4, null)) == -1) {
                        return null;
                    }
                    String string2 = property;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(valueStart, valueEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    if (StringsKt.startsWith$default((String)property, (String)"group:", (boolean)false, (int)2, null)) {
                        group = value;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)property, (String)"name:", (boolean)false, (int)2, null)) {
                        artifact = value;
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)property, (String)"version:", (boolean)false, (int)2, null)) continue;
                    version = value;
                }
                if (artifact != null && group != null && version != null) {
                    return group + ":" + artifact + ":" + version;
                }
            }
            return null;
        }

        private final GradleVersion getLatestBuildTools(LintClient client, int major) {
            if (major != majorBuildTools) {
                File[] dirs;
                majorBuildTools = major;
                ArrayList<GradleVersion> revisions = new ArrayList<GradleVersion>();
                switch (major) {
                    case 267: {
                        revisions.add(new GradleVersion(27, 0, 3));
                        break;
                    }
                    case 26: {
                        revisions.add(new GradleVersion(26, 0, 3));
                        break;
                    }
                    case 25: {
                        revisions.add(new GradleVersion(25, 0, 3));
                        break;
                    }
                    case 24: {
                        revisions.add(new GradleVersion(24, 0, 3));
                        break;
                    }
                    case 23: {
                        revisions.add(new GradleVersion(23, 0, 3));
                        break;
                    }
                    case 22: {
                        revisions.add(new GradleVersion(22, 0, 1));
                        break;
                    }
                    case 21: {
                        revisions.add(new GradleVersion(21, 1, 2));
                        break;
                    }
                    case 20: {
                        revisions.add(new GradleVersion(20, 0));
                        break;
                    }
                    case 19: {
                        revisions.add(new GradleVersion(19, 1));
                        break;
                    }
                    case 18: {
                        revisions.add(new GradleVersion(18, 1, 1));
                    }
                }
                File sdkHome = client.getSdkHome();
                if (sdkHome != null && (dirs = new File(sdkHome, "build-tools").listFiles()) != null) {
                    File[] fileArray = dirs;
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        GradleVersion v;
                        File dir;
                        File file = dir = fileArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
                        String name = file.getName();
                        if (!dir.isDirectory() || !Character.isDigit(name.charAt(0)) || (v = GradleVersion.tryParse((String)name)) == null || v.getMajor() != major) continue;
                        revisions.add(v);
                    }
                }
                if (!revisions.isEmpty()) {
                    latestBuildTools = (GradleVersion)Collections.max((Collection)revisions);
                }
            }
            return latestBuildTools;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean suggestApiConfigurationUse(Project project, String configuration) {
            if (StringsKt.startsWith$default((String)configuration, (String)"test", (boolean)false, (int)2, null)) return false;
            if (StringsKt.startsWith$default((String)configuration, (String)"androidTest", (boolean)false, (int)2, null)) {
                return false;
            }
            ProjectType projectType = project.getProjectType();
            if (projectType == null) throw new NoWhenBranchMatchedException();
            switch (GradleDetector$Companion$WhenMappings.$EnumSwitchMapping$0[projectType.ordinal()]) {
                case 1: {
                    boolean bl = project.hasDynamicFeatures();
                    return bl;
                }
                case 2: {
                    return true;
                }
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    return false;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final boolean targetJava8Plus(Project project) {
            return Lint.getLanguageLevel((Project)project, (LanguageLevel)LanguageLevel.JDK_1_7).isAtLeast(LanguageLevel.JDK_1_8);
        }

        private final boolean hasLifecycleAnnotationProcessor(String dependency) {
            return StringsKt.contains$default((CharSequence)dependency, (CharSequence)"android.arch.lifecycle:compiler", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependency, (CharSequence)"androidx.lifecycle:lifecycle-compiler", (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

