/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.ide.common.resources.ResourceRepository;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestDetector
extends Detector
implements XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(ManifestDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue ORDER = Issue.create((String)"ManifestOrder", (String)"Incorrect order of elements in manifest", (String)"The <application> tag should appear after the elements which declare which version you need, which features you need, which libraries you need, and so on. In the past there have been subtle bugs (such as themes not getting applied correctly) when the `<application>` tag appears before some of these other elements, so it's best to order your manifest in the logical dependency order.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue USES_SDK = Issue.create((String)"UsesMinSdkAttributes", (String)"Minimum SDK and target SDK attributes not defined", (String)"The manifest should contain a `<uses-sdk>` element which defines the minimum API Level required for the application to run, as well as the target version (the highest API level you have tested the version for).", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/uses-sdk-element.html");
    public static final Issue TARGET_NEWER = Issue.create((String)"OldTargetApi", (String)"Target SDK attribute is not targeting latest version", (String)"When your application runs on a version of Android that is more recent than your `targetSdkVersion` specifies that it has been tested with, various compatibility modes kick in. This ensures that your application continues to work, but it may look out of place. For example, if the `targetSdkVersion` is less than 14, your app may get an option button in the UI.\n\nTo fix this issue, set the `targetSdkVersion` to the highest available value. Then test your app to make sure everything works correctly. You may want to consult the compatibility notes to see what changes apply to each version you are adding support for: http://developer.android.com/reference/android/os/Build.VERSION_CODES.html as well as follow this guide:\nhttps://developer.android.com/distribute/best-practices/develop/target-sdk.html", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html").addMoreInfo("http://developer.android.com/reference/android/os/Build.VERSION_CODES.html");
    public static final Issue MULTIPLE_USES_SDK = Issue.create((String)"MultipleUsesSdk", (String)"Multiple `<uses-sdk>` elements in the manifest", (String)"The `<uses-sdk>` element should appear just once; the tools will **not** merge the contents of all the elements so if you split up the attributes across multiple elements, only one of them will take effect. To fix this, just merge all the attributes from the various elements into a single <uses-sdk> element.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/uses-sdk-element.html");
    public static final Issue WRONG_PARENT = Issue.create((String)"WrongManifestParent", (String)"Wrong manifest parent", (String)"The `<uses-library>` element should be defined as a direct child of the `<application>` tag, not the `<manifest>` tag or an `<activity>` tag. Similarly, a `<uses-sdk>` tag must be declared at the root level, and so on. This check looks for incorrect declaration locations in the manifest, and complains if an element is found in the wrong place.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html");
    public static final Issue DUPLICATE_ACTIVITY = Issue.create((String)"DuplicateActivity", (String)"Activity registered more than once", (String)"An activity should only be registered once in the manifest. If it is accidentally registered more than once, then subtle errors can occur, since attribute declarations from the two elements are not merged, so you may accidentally remove previous declarations.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    private static final String BACKUP_DOCUMENTATION_URL = "https://developer.android.com/training/backup/autosyncapi.html";
    public static final Issue ALLOW_BACKUP = Issue.create((String)"AllowBackup", (String)"AllowBackup/FullBackupContent Problems", (String)"The `allowBackup` attribute determines if an application's data can be backed up and restored. It is documented at http://developer.android.com/reference/android/R.attr.html#allowBackup\n\nBy default, this flag is set to `true`. When this flag is set to `true`, application data can be backed up and restored by the user using `adb backup` and `adb restore`.\n\nThis may have security consequences for an application. `adb backup` allows users who have enabled USB debugging to copy application data off of the device. Once backed up, all application data can be read by the user. `adb restore` allows creation of application data from a source specified by the user. Following a restore, applications should not assume that the data, file permissions, and directory permissions were created by the application itself.\n\nSetting `allowBackup=\"false\"` opts an application out of both backup and restore.\n\nTo fix this warning, decide whether your application should support backup, and explicitly set `android:allowBackup=(true|false)\"`.\n\nIf not set to false, and if targeting API 23 or later, lint will also warn that you should set `android:fullBackupContent` to configure auto backup.", (Category)Category.SECURITY, (int)3, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/backup/autosyncapi.html").addMoreInfo("http://developer.android.com/reference/android/R.attr.html#allowBackup");
    public static final Issue UNIQUE_PERMISSION = Issue.create((String)"UniquePermission", (String)"Permission names are not unique", (String)"The unqualified names or your permissions must be unique. The reason for this is that at build time, the `aapt` tool will generate a class named `Manifest` which contains a field for each of your permissions. These fields are named using your permission unqualified names (i.e. the name portion after the last dot).\n\nIf more than one permission maps to the same field name, that field will arbitrarily name just one of them.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue SET_VERSION = Issue.create((String)"MissingVersion", (String)"Missing application name/version", (String)"You should define the version information for your application.\n`android:versionCode`: An integer value that represents the version of the application code, relative to other versions.\n\n`android:versionName`: A string value that represents the release version of the application code, as it should be shown to users.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/tools/publishing/versioning.html#appversioning");
    public static final Issue ILLEGAL_REFERENCE = Issue.create((String)"IllegalResourceRef", (String)"Name and version must be integer or string, not resource", (String)"For the `versionCode` attribute, you have to specify an actual integer literal; you cannot use an indirection with a `@dimen/name` resource. Similarly, the `versionName` attribute should be an actual string, not a string resource url.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue DUPLICATE_USES_FEATURE = Issue.create((String)"DuplicateUsesFeature", (String)"Feature declared more than once", (String)"A given feature should only be declared once in the manifest.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue APPLICATION_ICON = Issue.create((String)"MissingApplicationIcon", (String)"Missing application icon", (String)"You should set an icon for the application as whole because there is no default. This attribute must be set as a reference to a drawable resource containing the image (for example `@drawable/icon`).", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/tools/publishing/preparing.html#publishing-configure");
    public static final Issue DEVICE_ADMIN = Issue.create((String)"DeviceAdmin", (String)"Malformed Device Admin", (String)"If you register a broadcast receiver which acts as a device admin, you must also register an `<intent-filter>` for the action `android.app.action.DEVICE_ADMIN_ENABLED`, without any `<data>`, such that the device admin can be activated/deactivated.\n\nTo do this, add\n`<intent-filter>`\n    `<action android:name=\"android.app.action.DEVICE_ADMIN_ENABLED\" />`\n`</intent-filter>`\nto your `<receiver>`.", (Category)Category.CORRECTNESS, (int)7, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue MOCK_LOCATION = Issue.create((String)"MockLocation", (String)"Using mock location provider in production", (String)"Using a mock location provider (by requiring the permission `android.permission.ACCESS_MOCK_LOCATION`) should **only** be done in debug builds (or from tests). In Gradle projects, that means you should only request this permission in a test or debug source set specific manifest file.\n\nTo fix this, create a new manifest file in the debug folder and move the `<uses-permission>` element there. A typical path to a debug manifest override file in a Gradle project is src/debug/AndroidManifest.xml.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue GRADLE_OVERRIDES = Issue.create((String)"GradleOverrides", (String)"Value overridden by Gradle build script", (String)"The value of (for example) `minSdkVersion` is only used if it is not specified in the `build.gradle` build scripts. When specified in the Gradle build scripts, the manifest value is ignored and can be misleading, so should be removed to avoid ambiguity.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue MIPMAP = Issue.create((String)"MipmapIcons", (String)"Use Mipmap Launcher Icons", (String)"Launcher icons should be provided in the `mipmap` resource directory. This is the same as the `drawable` resource directory, except resources in the `mipmap` directory will not get stripped out when creating density-specific APKs.\n\nIn certain cases, the Launcher app may use a higher resolution asset (than would normally be computed for the device) to display large app shortcuts. If drawables for densities other than the device's resolution have been stripped out, then the app shortcut could appear blurry.\n\nTo fix this, move your launcher icons from `drawable-`dpi to `mipmap-`dpi and change references from @drawable/ and R.drawable to @mipmap/ and R.mipmap.\nIn Android Studio this lint warning has a quickfix to perform this automatically.", (Category)Category.ICONS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue WEARABLE_BIND_LISTENER = Issue.create((String)"WearableBindListener", (String)"Usage of Android Wear BIND_LISTENER is deprecated", (String)"BIND_LISTENER receives all Android Wear events whether the application needs them or not. This can be inefficient and cause applications to wake up unnecessarily. With Google Play Services 8.2.0 or later it is recommended to use a more efficient combination of manifest listeners and api-based live listeners filtered by action, path and/or path prefix. ", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION).addMoreInfo("http://android-developers.blogspot.com/2016/04/deprecation-of-bindlistener.html");
    public static final Issue APP_INDEXING_SERVICE = Issue.create((String)"AppIndexingService", (String)"App Indexing Background Services", (String)"Apps targeting Android 8.0 or higher can no longer rely on background services while listening for updates to the on-device index. Use a `BroadcastReceiver` for the `UPDATE_INDEX` intent to continue supporting indexing in your app.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://firebase.google.com/docs/app-indexing/android/personal-content#add-a-broadcast-receiver-to-your-app");
    public static final String MOCK_LOCATION_PERMISSION = "android.permission.ACCESS_MOCK_LOCATION";
    public static final String MISSING_FULL_BACKUP_CONTENT_RESOURCE = "Missing `<full-backup-content>` resource";
    private static final GradleCoordinate MIN_WEARABLE_GMS_VERSION = GradleCoordinate.parseVersionOnly((String)"8.2.0");
    private boolean mSeenApplication;
    private int mSeenUsesSdk;
    private Set<String> mActivities;
    private Set<String> mUsesFeatures;
    private boolean checkedUniquePermissions;

    public void beforeCheckFile(Context context) {
        this.mSeenApplication = false;
        this.mSeenUsesSdk = 0;
        this.mActivities = new HashSet<String>();
        this.mUsesFeatures = new HashSet<String>();
    }

    public void afterCheckFile(Context context) {
        XmlContext xmlContext = (XmlContext)context;
        Element element = xmlContext.document.getDocumentElement();
        if (element != null) {
            this.checkDocumentElement(xmlContext, element);
        }
        if (this.mSeenUsesSdk == 0 && context.isEnabled(USES_SDK) && !context.getMainProject().isGradleProject()) {
            context.report(USES_SDK, Location.create((File)context.file), "Manifest should specify a minimum API level with `<uses-sdk android:minSdkVersion=\"?\" />`; if it really supports all versions of Android set it to 1.");
        }
    }

    private void checkMergedApplication(XmlContext context, Element sourceApplicationElement) {
        if (context.getProject().isLibrary()) {
            return;
        }
        Project mainProject = context.getMainProject();
        Document mergedManifest = mainProject.getMergedManifest();
        if (mergedManifest == null) {
            return;
        }
        Element root = mergedManifest.getDocumentElement();
        if (root == null) {
            return;
        }
        Element application = XmlUtils.getFirstSubTagByName((Node)root, (String)"application");
        if (application == null) {
            return;
        }
        if (context.isEnabled(ALLOW_BACKUP)) {
            String allowBackup = application.getAttributeNS("http://schemas.android.com/apk/res/android", "allowBackup");
            Attr fullBackupNode = application.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fullBackupContent");
            if (fullBackupNode != null && fullBackupNode.getValue().startsWith("@") && context.getClient().supportsProjectResources()) {
                ResourceRepository resources = context.getClient().getResourceRepository(mainProject, true, false);
                ResourceUrl url = ResourceUrl.parse((String)fullBackupNode.getValue());
                if (url != null && !url.isFramework() && resources != null && !resources.hasResources(ResourceNamespace.TODO(), url.type, url.name)) {
                    Attr sourceFullBackupNode = sourceApplicationElement.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fullBackupContent");
                    if (sourceFullBackupNode != null) {
                        fullBackupNode = sourceFullBackupNode;
                    }
                    Location location = context.getValueLocation(fullBackupNode);
                    context.report(ALLOW_BACKUP, (Node)fullBackupNode, location, MISSING_FULL_BACKUP_CONTENT_RESOURCE);
                }
            } else if (fullBackupNode == null && !"false".equals(allowBackup) && mainProject.getTargetSdk() >= 23) {
                if (ManifestDetector.hasGcmReceiver(application)) {
                    Location location = context.getNameLocation((Node)sourceApplicationElement);
                    context.report(ALLOW_BACKUP, (Node)sourceApplicationElement, location, "On SDK version 23 and up, your app data will be automatically backed up, and restored on app install. Your GCM regid will not work across restores, so you must ensure that it is excluded from the back-up set. Use the attribute `android:fullBackupContent` to specify an `@xml` resource which configures which files to backup. More info: https://developer.android.com/training/backup/autosyncapi.html");
                } else {
                    Location location = context.getNameLocation((Node)sourceApplicationElement);
                    context.report(ALLOW_BACKUP, (Node)sourceApplicationElement, location, "On SDK version 23 and up, your app data will be automatically backed up and restored on app install. Consider adding the attribute `android:fullBackupContent` to specify an `@xml` resource which configures which files to backup. More info: https://developer.android.com/training/backup/autosyncapi.html");
                }
            }
            if (allowBackup == null || allowBackup.isEmpty() && mainProject.getMinSdk() >= 4) {
                context.report(ALLOW_BACKUP, (Node)sourceApplicationElement, context.getNameLocation((Node)sourceApplicationElement), "Should explicitly set `android:allowBackup` to `true` or `false` (it's `true` by default, and that can have some security implications for the application's data)");
            }
        }
        if (!application.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon") && context.isEnabled(APPLICATION_ICON)) {
            LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "icon", "@mipmap/").caretEnd().build();
            context.report(APPLICATION_ICON, context.getNameLocation((Node)sourceApplicationElement), "Should explicitly set `android:icon`, there is no default", fix);
        }
    }

    private void checkDocumentElement(XmlContext context, Element element) {
        String pkg;
        Attr codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionCode");
        if (codeNode != null && codeNode.getValue().startsWith("@") && context.isEnabled(ILLEGAL_REFERENCE)) {
            context.report(ILLEGAL_REFERENCE, (Node)element, context.getLocation((Node)codeNode), "The `android:versionCode` cannot be a resource url, it must be a literal integer");
        } else if (codeNode == null && context.isEnabled(SET_VERSION) && !context.getMainProject().isGradleProject()) {
            LintFix fix = this.fix().set().todo("http://schemas.android.com/apk/res/android", "versionCode").build();
            context.report(SET_VERSION, (Node)element, context.getNameLocation((Node)element), "Should set `android:versionCode` to specify the application version", fix);
        }
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "versionName");
        if (nameNode == null && context.isEnabled(SET_VERSION) && !context.getMainProject().isGradleProject()) {
            LintFix fix = this.fix().set().todo("http://schemas.android.com/apk/res/android", "versionName").build();
            context.report(SET_VERSION, (Node)element, context.getNameLocation((Node)element), "Should set `android:versionName` to specify the application version", fix);
        }
        ManifestDetector.checkOverride(context, element, "versionCode");
        ManifestDetector.checkOverride(context, element, "versionName");
        Attr pkgNode = element.getAttributeNode("package");
        if (pkgNode != null && (pkg = pkgNode.getValue()).contains("${") && context.getMainProject().isGradleProject()) {
            context.report(GRADLE_OVERRIDES, (Node)pkgNode, context.getLocation((Node)pkgNode), "Cannot use placeholder for the package in the manifest; set `applicationId` in `build.gradle` instead");
        }
    }

    private static void checkOverride(XmlContext context, Element element, String attributeName) {
        Variant variant;
        Project project = context.getProject();
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        if (project.isGradleProject() && attribute != null && context.isEnabled(GRADLE_OVERRIDES) && (variant = project.getCurrentVariant()) != null) {
            ProductFlavor flavor = variant.getMergedFlavor();
            String gradleValue = null;
            if ("minSdkVersion".equals(attributeName)) {
                if (element.hasAttributeNS("http://schemas.android.com/tools", "overrideLibrary")) {
                    return;
                }
                ApiVersion minSdkVersion = flavor.getMinSdkVersion();
                gradleValue = minSdkVersion != null ? minSdkVersion.getApiString() : null;
            } else if ("targetSdkVersion".equals(attributeName)) {
                ApiVersion targetSdkVersion = flavor.getTargetSdkVersion();
                gradleValue = targetSdkVersion != null ? targetSdkVersion.getApiString() : null;
            } else if ("versionCode".equals(attributeName)) {
                Integer versionCode = flavor.getVersionCode();
                if (versionCode != null) {
                    gradleValue = versionCode.toString();
                }
            } else if ("versionName".equals(attributeName)) {
                gradleValue = flavor.getVersionName();
            } else {
                assert (false) : attributeName;
                return;
            }
            if (gradleValue != null) {
                String manifestValue = attribute.getValue();
                String message2 = String.format("This `%1$s` value (`%2$s`) is not used; it is always overridden by the value specified in the Gradle build script (`%3$s`)", attributeName, manifestValue, gradleValue);
                context.report(GRADLE_OVERRIDES, (Node)attribute, context.getLocation((Node)attribute), message2);
            }
        }
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("application", "uses-permission", "permission", "permission-tree", "permission-group", "uses-sdk", "uses-configuration", "uses-feature", "supports-screens", "compatible-screens", "supports-gl-texture", "uses-library", "activity", "service", "provider", "receiver");
    }

    public void visitElement(XmlContext context, Element element) {
        String name;
        Attr name2;
        Attr nameNode;
        String tag = element.getTagName();
        Node parentNode = element.getParentNode();
        boolean isReceiver = tag.equals("receiver");
        if (isReceiver) {
            ManifestDetector.checkDeviceAdmin(context, element);
        }
        if (tag.equals("uses-library") || tag.equals("activity") || tag.equals("service") || isReceiver) {
            if (!"application".equals(parentNode.getNodeName()) && context.isEnabled(WRONG_PARENT)) {
                context.report(WRONG_PARENT, (Node)element, context.getNameLocation((Node)element), String.format("The `<%1$s>` element must be a direct child of the <application> element", tag));
            }
            if (tag.equals("activity")) {
                String name3;
                Attr nameNode2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameNode2 != null && !(name3 = nameNode2.getValue()).isEmpty()) {
                    String pkg = context.getMainProject().getPackage();
                    if (name3.charAt(0) == '.') {
                        name3 = pkg + name3;
                    } else if (name3.indexOf(46) == -1) {
                        name3 = pkg + '.' + name3;
                    }
                    if (this.mActivities.contains(name3)) {
                        String message2 = String.format("Duplicate registration for activity `%1$s`", name3);
                        context.report(DUPLICATE_ACTIVITY, (Node)element, context.getLocation((Node)nameNode2), message2);
                    } else {
                        this.mActivities.add(name3);
                    }
                }
                ManifestDetector.checkMipmapIcon(context, element);
            } else if (tag.equals("service") && context.getMainProject().isGradleProject()) {
                String message3;
                Project project = context.getMainProject();
                if (project.getTargetSdk() >= 26) {
                    block2: for (Object child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                        for (Object innerChild : XmlUtils.getSubTagsByName((Node)child, (String)"action")) {
                            Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                            if (attr == null || !"com.google.firebase.appindexing.UPDATE_INDEX".equals(attr.getValue())) continue;
                            message3 = "`UPDATE_INDEX` is configured as a service in your app, which is no longer supported for the API level you're targeting. Use a `BroadcastReceiver` instead.";
                            context.report(APP_INDEXING_SERVICE, (Node)attr, context.getLocation((Node)attr), message3);
                            continue block2;
                        }
                    }
                }
                Attr bindListenerAttr = null;
                block4: for (Element child : XmlUtils.getSubTagsByName((Node)element, (String)"intent-filter")) {
                    for (Element innerChild : XmlUtils.getSubTagsByName((Node)child, (String)"action")) {
                        Attr attr = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                        if (attr == null || !"com.google.android.gms.wearable.BIND_LISTENER".equals(attr.getValue())) continue;
                        bindListenerAttr = attr;
                        continue block4;
                    }
                }
                if (bindListenerAttr == null) {
                    return;
                }
                Variant variant = project.getCurrentVariant();
                if (variant != null) {
                    Dependencies dependencies = variant.getMainArtifact().getDependencies();
                    for (AndroidLibrary library : dependencies.getLibraries()) {
                        if (!ManifestDetector.hasWearableGmsDependency(library)) continue;
                        context.report(WEARABLE_BIND_LISTENER, (Node)bindListenerAttr, context.getLocation((Node)bindListenerAttr), "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated.");
                        return;
                    }
                }
                if (project.getBuildSdk() >= 24) {
                    GradleCoordinate max;
                    File sdkHome = context.getClient().getSdkHome();
                    FileOp fileOp = FileOpUtils.create();
                    File repository = SdkMavenRepository.GOOGLE.getRepositoryLocation(sdkHome, true, fileOp);
                    message3 = "The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest version of play-services-wearable 8.2.0 or later";
                    if (repository != null && (max = MavenRepositories.getHighestInstalledVersion((String)"com.google.android.gms", (String)"play-services-wearable", (File)repository, null, (boolean)false, (FileOp)fileOp)) != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(max, MIN_WEARABLE_GMS_VERSION) > 0) {
                        message3 = String.format("The `com.google.android.gms.wearable.BIND_LISTENER` action is deprecated. Please upgrade to the latest available version of play-services-wearable: `%1$s`", max.getRevision());
                    }
                    context.report(WEARABLE_BIND_LISTENER, (Node)bindListenerAttr, context.getLocation((Node)bindListenerAttr), message3);
                }
            }
            return;
        }
        if (tag.equals("provider")) {
            if (!"application".equals(parentNode.getNodeName()) && !"queries".equals(parentNode.getNodeName()) && context.isEnabled(WRONG_PARENT)) {
                context.report(WRONG_PARENT, (Node)element, context.getNameLocation((Node)element), String.format("The `<%1$s>` element must be a direct child of the `<application>` element or the `<queries>` element", tag));
            }
            return;
        }
        if (parentNode != element.getOwnerDocument().getDocumentElement() && tag.indexOf(58) == -1 && context.isEnabled(WRONG_PARENT)) {
            context.report(WRONG_PARENT, (Node)element, context.getNameLocation((Node)element), String.format("The `<%1$s>` element must be a direct child of the `<manifest>` root element", tag));
        }
        if (tag.equals("uses-sdk")) {
            ++this.mSeenUsesSdk;
            if (this.mSeenUsesSdk == 2) {
                Location location = context.getNameLocation((Node)element);
                NodeList elements = element.getOwnerDocument().getElementsByTagName("uses-sdk");
                Location secondary = null;
                for (int i = elements.getLength() - 1; i >= 0; --i) {
                    Element e = (Element)elements.item(i);
                    if (e == element) continue;
                    Location l = context.getNameLocation((Node)e);
                    l.setSecondary(secondary);
                    l.setMessage("Also appears here");
                    secondary = l;
                }
                location.setSecondary(secondary);
                if (context.isEnabled(MULTIPLE_USES_SDK)) {
                    context.report(MULTIPLE_USES_SDK, (Node)element, location, "There should only be a single `<uses-sdk>` element in the manifest: merge these together");
                }
                return;
            }
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                if (context.isEnabled(USES_SDK) && !context.getMainProject().isGradleProject()) {
                    context.report(USES_SDK, (Node)element, context.getNameLocation((Node)element), "`<uses-sdk>` tag should specify a minimum API level with `android:minSdkVersion=\"?\"`");
                }
            } else {
                Attr codeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
                if (codeNode != null && codeNode.getValue().startsWith("@") && context.isEnabled(ILLEGAL_REFERENCE)) {
                    context.report(ILLEGAL_REFERENCE, (Node)element, context.getLocation((Node)codeNode), "The `android:minSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)");
                }
                ManifestDetector.checkOverride(context, element, "minSdkVersion");
            }
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                if (context.isEnabled(USES_SDK) && !context.getMainProject().isGradleProject()) {
                    context.report(USES_SDK, (Node)element, context.getNameLocation((Node)element), "`<uses-sdk>` tag should specify a target API level (the highest verified version; when running on later versions, compatibility behaviors may be enabled) with `android:targetSdkVersion=\"?\"`");
                }
            } else {
                Attr targetSdkVersionNode;
                ManifestDetector.checkOverride(context, element, "targetSdkVersion");
                if (context.isEnabled(TARGET_NEWER) && (targetSdkVersionNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null) {
                    String target = targetSdkVersionNode.getValue();
                    try {
                        int api = Integer.parseInt(target);
                        int highest = context.getClient().getHighestKnownApiLevel();
                        if (api < highest) {
                            LintFix fix = this.fix().name("Update targetSdkVersion to " + highest).replace().pattern("targetSdkVersion\\s*=\\s*[\"'](.*)[\"']").with(Integer.toString(highest)).build();
                            Location location = context.getLocation((Node)targetSdkVersionNode);
                            context.report(TARGET_NEWER, (Node)element, location, "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the `android.os.Build.VERSION_CODES` javadoc for details.", fix);
                        }
                    }
                    catch (NumberFormatException api) {
                        // empty catch block
                    }
                }
            }
            if ((nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) != null && nameNode.getValue().startsWith("@") && context.isEnabled(ILLEGAL_REFERENCE)) {
                context.report(ILLEGAL_REFERENCE, (Node)element, context.getLocation((Node)nameNode), "The `android:targetSdkVersion` cannot be a resource url, it must be a literal integer (or string if a preview codename)");
            }
        }
        if (tag.equals("permission") || tag.equals("permission-group")) {
            this.ensureUniquePermission(context);
        }
        if (tag.equals("uses-permission") && (name2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null && name2.getValue().equals(MOCK_LOCATION_PERMISSION) && context.getMainProject().isGradleProject() && !ManifestDetector.isDebugOrTestManifest(context, context.file) && context.isEnabled(MOCK_LOCATION)) {
            String message4 = "Mock locations should only be requested in a test or debug-specific manifest file (typically `src/debug/AndroidManifest.xml`)";
            Location location = context.getLocation((Node)name2);
            context.report(MOCK_LOCATION, (Node)element, location, message4);
        }
        if (tag.equals("application")) {
            this.mSeenApplication = true;
            this.checkMergedApplication(context, element);
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "icon")) {
                ManifestDetector.checkMipmapIcon(context, element);
            }
        } else if (this.mSeenApplication) {
            if (context.isEnabled(ORDER)) {
                context.report(ORDER, (Node)element, context.getNameLocation((Node)element), String.format("`<%1$s>` tag appears after `<application>` tag", tag));
            }
            this.mSeenApplication = false;
        }
        if (tag.equals("uses-feature") && (nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) != null && !(name = nameNode.getValue()).isEmpty()) {
            if (this.mUsesFeatures.contains(name)) {
                String message5 = String.format("Duplicate declaration of uses-feature `%1$s`", name);
                context.report(DUPLICATE_USES_FEATURE, (Node)element, context.getLocation((Node)nameNode), message5);
            } else {
                this.mUsesFeatures.add(name);
            }
        }
    }

    private void ensureUniquePermission(XmlContext context) {
        if (this.checkedUniquePermissions) {
            return;
        }
        this.checkedUniquePermissions = true;
        Project mainProject = context.getMainProject();
        Document mergedManifest = mainProject.getMergedManifest();
        if (mergedManifest == null) {
            return;
        }
        ManifestDetector.lookForNonUniqueNames(context, mainProject, mergedManifest, "permission", "permission");
        ManifestDetector.lookForNonUniqueNames(context, mainProject, mergedManifest, "permission group", "permission-group");
    }

    private static void lookForNonUniqueNames(XmlContext context, Project mainProject, Document mergedManifest, String humanReadableName, String tagName) {
        HashMap nameToFull = null;
        Element element = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)tagName);
        while (element != null) {
            Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (nameNode != null && !ManifestDetector.manifestMergerSkips(element)) {
                String name = nameNode.getValue();
                String base = name.substring(name.lastIndexOf(46) + 1);
                if (name.contains("${applicationId}") && !mainProject.isLibrary() && mainProject.getPackage() != null) {
                    name = name.replace("${applicationId}", mainProject.getPackage());
                }
                if (!name.contains("${")) {
                    if (nameToFull == null) {
                        nameToFull = Maps.newHashMap();
                    } else if (nameToFull.containsKey(base) && !name.equals(nameToFull.get(base))) {
                        Node node;
                        String prevName = (String)nameToFull.get(base);
                        Location location = context.getLocation((Node)nameNode);
                        NodeList siblings = element.getParentNode().getChildNodes();
                        int n = siblings.getLength();
                        for (int i = 0; i < n && (node = siblings.item(i)) != element; ++i) {
                            String b;
                            if (node.getNodeType() != 1) continue;
                            Element sibling = (Element)node;
                            String suffix = '.' + base;
                            if (!sibling.getTagName().equals(tagName) || !(b = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).endsWith(suffix)) continue;
                            Location prevLocation = context.getLocation(node);
                            prevLocation.setMessage("Previous " + humanReadableName + " here");
                            location.setSecondary(prevLocation);
                            break;
                        }
                        String message2 = String.format("%1$s name `%2$s` is not unique (appears in both `%3$s` and `%4$s`)", StringHelper.capitalize((String)humanReadableName), base, prevName, name);
                        context.report(UNIQUE_PERMISSION, (Node)element, location, message2);
                    }
                    nameToFull.put(base, name);
                }
            }
            element = XmlUtils.getNextTagByName((Node)element, (String)tagName);
        }
    }

    private static boolean manifestMergerSkips(Element element) {
        String action;
        Attr operation = element.getAttributeNodeNS("http://schemas.android.com/tools", "node");
        return operation != null && ((action = operation.getValue()).startsWith("remove") || action.equals("replace"));
    }

    private static boolean hasWearableGmsDependency(AndroidLibrary library) {
        GradleCoordinate gc;
        MavenCoordinates mc = library.getResolvedCoordinates();
        if (mc != null && mc.getGroupId().equals("com.google.android.gms") && mc.getArtifactId().equals("play-services-wearable") && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(gc = GradleCoordinate.parseVersionOnly((String)mc.getVersion()), MIN_WEARABLE_GMS_VERSION) >= 0) {
            return true;
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            if (!ManifestDetector.hasWearableGmsDependency(dependency)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasGcmReceiver(Element application) {
        NodeList applicationChildren = application.getChildNodes();
        int n1 = applicationChildren.getLength();
        for (int i1 = 0; i1 < n1; ++i1) {
            Node applicationChild = applicationChildren.item(i1);
            if (applicationChild.getNodeType() != 1 || !"receiver".equals(applicationChild.getNodeName())) continue;
            NodeList receiverChildren = applicationChild.getChildNodes();
            int n2 = receiverChildren.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node receiverChild = receiverChildren.item(i2);
                if (receiverChild.getNodeType() != 1 || !"intent-filter".equals(receiverChild.getNodeName())) continue;
                NodeList filterChildren = receiverChild.getChildNodes();
                int n3 = filterChildren.getLength();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Element action;
                    String name;
                    Node filterChild = filterChildren.item(i3);
                    if (filterChild.getNodeType() != 1 || !"action".equals(filterChild.getNodeName()) || !"com.google.android.c2dm.intent.RECEIVE".equals(name = (action = (Element)filterChild).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void checkMipmapIcon(XmlContext context, Element element) {
        Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "icon");
        if (attribute == null) {
            return;
        }
        String icon = attribute.getValue();
        if (icon.startsWith("@drawable/")) {
            if ("activity".equals(element.getTagName()) && !ManifestDetector.isLaunchableActivity(element)) {
                return;
            }
            if (context.isEnabled(MIPMAP) && context.getProject().getApplicableDensities() != null) {
                context.report(MIPMAP, (Node)element, context.getLocation((Node)attribute), "Should use `@mipmap` instead of `@drawable` for launcher icons");
            }
        }
    }

    static boolean isLaunchableActivity(Element activity) {
        return ManifestDetector.findLaunchableCategoryNode(activity) != null;
    }

    static Attr findLaunchableCategoryNode(Element activity) {
        if (!"activity".equals(activity.getTagName())) {
            return null;
        }
        Element child = XmlUtils.getFirstSubTagByName((Node)activity, (String)"intent-filter");
        while (child != null) {
            Element innerChild = XmlUtils.getFirstSubTagByName((Node)child, (String)"category");
            while (innerChild != null) {
                Attr attribute = innerChild.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (attribute != null && attribute.getValue().equals("android.intent.category.LAUNCHER")) {
                    return attribute;
                }
                innerChild = XmlUtils.getNextTagByName((Node)innerChild, (String)"category");
            }
            child = XmlUtils.getNextTagByName((Node)child, (String)"intent-filter");
        }
        return null;
    }

    private static boolean isDebugOrTestManifest(XmlContext context, File manifestFile) {
        AndroidProject model = context.getProject().getGradleProjectModel();
        if (model != null) {
            if (manifestFile.equals(model.getDefaultConfig().getSourceProvider().getManifestFile())) {
                return false;
            }
            for (BuildTypeContainer container : model.getBuildTypes()) {
                if (!container.getBuildType().isDebuggable() || !manifestFile.equals(container.getSourceProvider().getManifestFile())) continue;
                return true;
            }
            for (SourceProviderContainer extra : model.getDefaultConfig().getExtraSourceProviders()) {
                String artifactName = extra.getArtifactName();
                if (!"_android_test_".equals(artifactName) || !manifestFile.equals(extra.getSourceProvider().getManifestFile())) continue;
                return true;
            }
            for (BuildTypeContainer container : model.getProductFlavors()) {
                for (SourceProviderContainer extra : container.getExtraSourceProviders()) {
                    String artifactName = extra.getArtifactName();
                    if (!"_android_test_".equals(artifactName) || !manifestFile.equals(extra.getSourceProvider().getManifestFile())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void checkDeviceAdmin(XmlContext context, Element element) {
        boolean requiredIntentFilterFound = false;
        boolean deviceAdmin = false;
        Attr locationNode = null;
        for (Element child : XmlUtils.getSubTags((Node)element)) {
            String name;
            Attr valueNode;
            String tagName = child.getTagName();
            if (tagName.equals("intent-filter") && !requiredIntentFilterFound) {
                boolean dataFound = false;
                boolean actionFound = false;
                for (Element filterChild : XmlUtils.getSubTags((Node)child)) {
                    String filterTag = filterChild.getTagName();
                    if (filterTag.equals("action")) {
                        String name2 = filterChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (!"android.app.action.DEVICE_ADMIN_ENABLED".equals(name2)) continue;
                        actionFound = true;
                        continue;
                    }
                    if (!filterTag.equals("data")) continue;
                    dataFound = true;
                }
                if (!actionFound || dataFound) continue;
                requiredIntentFilterFound = true;
                continue;
            }
            if (!tagName.equals("meta-data") || (valueNode = child.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null || !"android.app.device_admin".equals(name = valueNode.getValue())) continue;
            deviceAdmin = true;
            locationNode = valueNode;
        }
        if (deviceAdmin && !requiredIntentFilterFound && context.isEnabled(DEVICE_ADMIN)) {
            context.report(DEVICE_ADMIN, locationNode, context.getLocation(locationNode), "You must have an intent filter for action `android.app.action.DEVICE_ADMIN_ENABLED`");
        }
    }
}

