/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.java.JavaUAnnotation;

public abstract class RangeConstraint {
    public static RangeConstraint create(UAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        if (AnnotationDetector.INT_RANGE_ANNOTATION.isEquals(qualifiedName)) {
            return IntRangeConstraint.create(annotation);
        }
        if (AnnotationDetector.FLOAT_RANGE_ANNOTATION.isEquals(qualifiedName)) {
            return FloatRangeConstraint.create(annotation);
        }
        if (AnnotationDetector.SIZE_ANNOTATION.isEquals(qualifiedName)) {
            return SizeConstraint.create(annotation);
        }
        return null;
    }

    public static RangeConstraint create(PsiModifierListOwner owner, JavaEvaluator evaluator) {
        for (PsiAnnotation annotation : evaluator.getAllAnnotations(owner, false)) {
            RangeConstraint constraint = RangeConstraint.create(JavaUAnnotation.wrap((PsiAnnotation)annotation));
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    public Boolean contains(RangeConstraint other) {
        return null;
    }
}

