/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.RangeDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ExternalReferenceExpression;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JH\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005H\u0002J8\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002JN\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J|\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0016\u00a8\u0006+"}, d2={"Lcom/android/tools/lint/checks/TypedefDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkTypeDefConstant", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "errorNode", "flag", "", "value", "", "allAnnotations", "getResolvedValues", "allowed", "Lorg/jetbrains/uast/UExpression;", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "listAllowedValues", "allowedValues", "reportTypeDef", "node", "visitAnnotationUsage", "usage", "qualifiedName", "method", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allClassAnnotations", "allPackageAnnotations", "Companion", "lint-checks"})
public final class TypedefDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION;
    @NotNull
    public static final String ATTR_OPEN = "open";
    @JvmField
    @NotNull
    public static final Issue TYPE_DEF;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object[])new String[]{SdkConstants.INT_DEF_ANNOTATION.oldName(), SdkConstants.INT_DEF_ANNOTATION.newName(), SdkConstants.LONG_DEF_ANNOTATION.oldName(), SdkConstants.LONG_DEF_ANNOTATION.newName(), SdkConstants.STRING_DEF_ANNOTATION.oldName(), SdkConstants.STRING_DEF_ANNOTATION.newName(), AnnotationDetector.INT_RANGE_ANNOTATION.oldName(), AnnotationDetector.INT_RANGE_ANNOTATION.newName()});
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return type != AnnotationUsageType.BINARY;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        String string = qualifiedName;
        if (Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.newName())) {
            Boolean flagAttribute = UastLintUtils.getAnnotationBooleanValue((UAnnotation)annotation, (String)"flag");
            boolean flag = flagAttribute != null && flagAttribute != false;
            this.checkTypeDefConstant(context, annotation, usage, null, flag, annotations);
        } else if (Intrinsics.areEqual((Object)string, (Object)SdkConstants.STRING_DEF_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)SdkConstants.STRING_DEF_ANNOTATION.newName())) {
            this.checkTypeDefConstant(context, annotation, usage, null, false, annotations);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.INT_RANGE_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string, (Object)AnnotationDetector.INT_RANGE_ANNOTATION.newName())) {
            // empty if block
        }
    }

    private final void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, List<? extends UAnnotation> allAnnotations) {
        if (argument == null) {
            return;
        }
        if (argument instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)argument).getValue();
            if (value == null) {
                return;
            }
            if (value instanceof String) {
                this.checkTypeDefConstant(context, annotation, argument, errorNode, false, value, allAnnotations);
            } else if (value instanceof Number) {
                long v = ((Number)value).longValue();
                if (flag && v == 0L) {
                    return;
                }
                this.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value, allAnnotations);
            }
        } else if (UastLintUtils.isMinusOne((UElement)argument)) {
            if (!flag) {
                this.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
            }
        } else if (argument instanceof UPrefixExpression) {
            if (flag) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UPrefixExpression)argument).getOperand(), errorNode, true, allAnnotations);
            } else {
                UastPrefixOperator operator = ((UPrefixExpression)argument).getOperator();
                if (operator == UastPrefixOperator.BITWISE_NOT) {
                    this.report(context, TYPE_DEF, argument, context.getLocation(argument), "Flag not allowed here");
                } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                    this.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                }
            }
        } else if (argument instanceof UParenthesizedExpression) {
            UExpression expression = ((UParenthesizedExpression)argument).getExpression();
            this.checkTypeDefConstant(context, annotation, (UElement)expression, errorNode, flag, allAnnotations);
        } else if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UIfExpression)argument).getThenExpression(), errorNode, flag, allAnnotations);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UIfExpression)argument).getElseExpression(), errorNode, flag, allAnnotations);
            }
        } else if (argument instanceof UPolyadicExpression) {
            if (flag) {
                if (((UPolyadicExpression)argument).getOperator() == UastBinaryOperator.BITWISE_AND) {
                    for (UExpression operand : ((UPolyadicExpression)argument).getOperands()) {
                        String resolvedName;
                        if (!(operand instanceof UReferenceExpression) || (resolvedName = ((UReferenceExpression)operand).getResolvedName()) == null || !StringsKt.contains((CharSequence)resolvedName, (CharSequence)"mask", (boolean)true)) continue;
                        return;
                    }
                }
                for (UExpression operand : ((UPolyadicExpression)argument).getOperands()) {
                    this.checkTypeDefConstant(context, annotation, (UElement)operand, errorNode, true, allAnnotations);
                }
            } else {
                UastBinaryOperator operator = ((UPolyadicExpression)argument).getOperator();
                if (operator == UastBinaryOperator.BITWISE_AND || operator == UastBinaryOperator.BITWISE_OR || operator == UastBinaryOperator.BITWISE_XOR) {
                    this.report(context, TYPE_DEF, argument, context.getLocation(argument), "Flag not allowed here");
                }
            }
        } else if (argument instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)argument).resolve();
            if (resolved instanceof PsiVariable) {
                if (((PsiVariable)resolved).getType() instanceof PsiArrayType) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, allAnnotations);
                    return;
                }
                if (((PsiVariable)resolved).hasModifierProperty("static") && ((PsiVariable)resolved).hasModifierProperty("final")) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, allAnnotations);
                } else {
                    UExpression lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)((PsiVariable)resolved), (UElement)argument);
                    if (lastAssignment != null) {
                        UElement uElement = (UElement)lastAssignment;
                        UElement uElement2 = errorNode;
                        if (uElement2 == null) {
                            uElement2 = argument;
                        }
                        this.checkTypeDefConstant(context, annotation, uElement, uElement2, flag, allAnnotations);
                    }
                }
            }
        } else if (argument instanceof UCallExpression) {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument) || UastExpressionUtils.isArrayInitializer((UElement)argument)) {
                PsiType type = ((UCallExpression)argument).getExpressionType();
                if (type != null) {
                    type = type.getDeepComponentType();
                }
                if (Intrinsics.areEqual((Object)PsiType.INT, (Object)type) || Intrinsics.areEqual((Object)PsiType.LONG, (Object)type)) {
                    for (UExpression expression : ((UCallExpression)argument).getValueArguments()) {
                        this.checkTypeDefConstant(context, annotation, (UElement)expression, errorNode, flag, allAnnotations);
                    }
                }
            } else {
                PsiMethod resolved = ((UCallExpression)argument).resolve();
                if (resolved instanceof PsiMethod) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, allAnnotations);
                }
            }
        }
    }

    private final void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, Object value, List<? extends UAnnotation> allAnnotations) {
        UAnnotation rangeAnnotation = RangeDetector.Companion.findIntRange(allAnnotations);
        if (rangeAnnotation != null && !(value instanceof PsiField) && RangeDetector.Companion.getIntRangeError(context, rangeAnnotation, argument) == null) {
            return;
        }
        UExpression uExpression = UastLintUtils.getAnnotationValue((UAnnotation)annotation);
        if (uExpression == null) {
            return;
        }
        UExpression allowed = uExpression;
        if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            UExpression initializer;
            UField uField;
            PsiElement resolvedArgument;
            UElement uElement = argument;
            Object object = uElement instanceof UReferenceExpression ? ((UReferenceExpression)argument).resolve() : (resolvedArgument = uElement instanceof UCallExpression ? (PsiElement)((UCallExpression)argument).resolve() : null);
            if (resolvedArgument instanceof PsiModifierListOwner) {
                UElement uMethod;
                JavaEvaluator evaluator = context.getEvaluator();
                PsiAnnotation[] annotations = evaluator.getAllAnnotations((PsiModifierListOwner)resolvedArgument, true);
                boolean hadTypeDef = false;
                for (PsiAnnotation a : evaluator.filterRelevantAnnotations(annotations)) {
                    String qualifiedName = a.getQualifiedName();
                    if (!SdkConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) && !SdkConstants.LONG_DEF_ANNOTATION.isEquals(qualifiedName) && !SdkConstants.STRING_DEF_ANNOTATION.isEquals(qualifiedName)) continue;
                    hadTypeDef = true;
                    UExpression paramValues = UastLintUtils.getAnnotationValue((UAnnotation)JavaUAnnotation.Companion.wrap(a));
                    if (paramValues == null) continue;
                    if (Intrinsics.areEqual((Object)paramValues, (Object)allowed)) {
                        return;
                    }
                    List<Object> param = this.getResolvedValues(paramValues, argument);
                    List<Object> all = this.getResolvedValues(allowed, argument);
                    if (!all.containsAll((Collection)param)) continue;
                    return;
                }
                if (!hadTypeDef && resolvedArgument instanceof PsiMethod && (uMethod = UastContextKt.toUElement((PsiElement)resolvedArgument)) instanceof UMethod) {
                    UExpression retValue;
                    UExpression uExpression2;
                    UExpression body = ((UMethod)uMethod).getUastBody();
                    if (body instanceof UBlockExpression) {
                        if (((UBlockExpression)body).getExpressions().size() == 1 && ((UBlockExpression)body).getExpressions().get(0) instanceof UReturnExpression) {
                            Object e = ((UBlockExpression)body).getExpressions().get(0);
                            if (e == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UReturnExpression");
                            }
                            UReturnExpression ret = (UReturnExpression)e;
                            uExpression2 = ret.getReturnExpression();
                        } else {
                            uExpression2 = null;
                        }
                    } else {
                        uExpression2 = retValue = body;
                    }
                    if (retValue instanceof UReferenceExpression) {
                        PsiElement psiElement = ((UReferenceExpression)retValue).resolve();
                        if (psiElement == null) {
                            return;
                        }
                        PsiElement psiElement2 = psiElement;
                        if (psiElement2 instanceof PsiField) {
                            this.checkTypeDefConstant(context, annotation, (UElement)retValue, errorNode, flag, psiElement2, allAnnotations);
                        }
                        return;
                    }
                    if (!(retValue instanceof ULiteralExpression)) {
                        return;
                    }
                }
            }
            if (argument instanceof ULiteralExpression && argument.getUastParent() instanceof UField) {
                UElement uElement2 = argument.getUastParent();
                if (uElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UField");
                }
                uField = (UField)uElement2;
            } else {
                uField = null;
            }
            UField fieldInitialization = uField;
            UExpression uExpression3 = allowed;
            if (uExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            }
            UCallExpression initializerExpression = (UCallExpression)uExpression3;
            List initializers = initializerExpression.getValueArguments();
            PsiElement psiValue = null;
            if (value instanceof PsiElement) {
                psiValue = (PsiElement)value;
            }
            for (UExpression expression : initializers) {
                PsiElement resolved;
                if (fieldInitialization != null && expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) != null && resolved.isEquivalentTo((PsiElement)fieldInitialization)) {
                    return;
                }
                if (!(expression instanceof ULiteralExpression ? Intrinsics.areEqual((Object)value, (Object)((ULiteralExpression)expression).getValue()) : psiValue != null && (expression instanceof ExternalReferenceExpression ? (resolved = UastLintUtils.resolve((ExternalReferenceExpression)((ExternalReferenceExpression)expression), (UElement)argument)) != null && resolved.isEquivalentTo(psiValue) : expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) != null && resolved.isEquivalentTo(psiValue)))) continue;
                return;
            }
            if (value instanceof PsiField && rangeAnnotation == null && (initializer = context.getUastContext().getInitializerBody((PsiVariable)value)) != null) {
                this.checkTypeDefConstant(context, annotation, (UElement)initializer, errorNode, flag, allAnnotations);
                return;
            }
            if (allowed instanceof PsiCompiledElement || annotation.getPsi() instanceof PsiCompiledElement) {
                return;
            }
            this.reportTypeDef(context, argument, errorNode, flag, initializers, allAnnotations, annotation);
        }
    }

    private final List<Object> getResolvedValues(UExpression allowed, UElement context) {
        ArrayList result = Lists.newArrayList();
        if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            UExpression uExpression = allowed;
            if (uExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            }
            UCallExpression initializerExpression = (UCallExpression)uExpression;
            List initializers = initializerExpression.getValueArguments();
            for (UExpression expression : initializers) {
                PsiElement resolved;
                if (expression instanceof ULiteralExpression) {
                    Object value = ((ULiteralExpression)expression).getValue();
                    if (value == null) continue;
                    result.add(value);
                    continue;
                }
                if (expression instanceof ExternalReferenceExpression) {
                    resolved = UastLintUtils.resolve((ExternalReferenceExpression)((ExternalReferenceExpression)expression), (UElement)context);
                    if (resolved == null) continue;
                    result.add(resolved);
                    continue;
                }
                if (!(expression instanceof UReferenceExpression) || (resolved = ((UReferenceExpression)expression).resolve()) == null) continue;
                result.add(resolved);
            }
        }
        ArrayList arrayList = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"result");
        return arrayList;
    }

    private final void reportTypeDef(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, List<? extends UAnnotation> allAnnotations) {
        UExpression allowed = UastLintUtils.getAnnotationValue((UAnnotation)annotation);
        if (allowed != null && UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            this.reportTypeDef(context, argument, errorNode, false, initializers, allAnnotations, annotation);
        }
    }

    private final void reportTypeDef(JavaContext context, UElement node, UElement errorNode, boolean flag, List<? extends UExpression> allowedValues, List<? extends UAnnotation> allAnnotations, UAnnotation annotation) {
        UElement uElement;
        String rangeError;
        String message2;
        UVariable declaration;
        if (UastLintUtils.isZero((UElement)node) && (declaration = (UVariable)UastUtils.getParentOfType((UElement)node, UVariable.class, (boolean)true)) != null && Intrinsics.areEqual((Object)node, (Object)declaration.getUastInitializer())) {
            return;
        }
        if (Intrinsics.areEqual((Object)UastLintUtils.getAnnotationBooleanValue((UAnnotation)annotation, (String)ATTR_OPEN), (Object)true)) {
            return;
        }
        String values = this.listAllowedValues(node, allowedValues);
        String string = message2 = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        if (Intrinsics.areEqual((Object)values, (Object)"RecyclerView.HORIZONTAL, RecyclerView.VERTICAL") && errorNode instanceof UResolvable) {
            PsiField psiField;
            PsiElement psiElement = ((UResolvable)errorNode).resolve();
            if (!(psiElement instanceof PsiField)) {
                psiElement = null;
            }
            if (Intrinsics.areEqual((Object)((psiField = (PsiField)psiElement) != null && (psiField = psiField.getContainingClass()) != null ? psiField.getName() : null), (Object)"LinearLayoutManager")) {
                return;
            }
        }
        if (StringsKt.startsWith$default((String)values, (String)"MediaMetadataCompat.METADATA_KEY_", (boolean)false, (int)2, null)) {
            return;
        }
        UAnnotation rangeAnnotation = RangeDetector.Companion.findIntRange(allAnnotations);
        if (rangeAnnotation != null && (rangeError = RangeDetector.Companion.getIntRangeError(context, rangeAnnotation, node)) != null) {
            CharSequence charSequence = rangeError;
            int n = 0;
            if (!(charSequence.length() == 0)) {
                charSequence = rangeError;
                n = 1;
                StringBuilder stringBuilder = new StringBuilder().append(message2).append(" or ").append(Character.toLowerCase(rangeError.charAt(0)));
                boolean bl = false;
                String string2 = ((String)charSequence).substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                String string3 = string2;
                message2 = stringBuilder.append(string3).toString();
            }
        }
        if ((uElement = errorNode) == null) {
            uElement = node;
        }
        UElement locationNode = uElement;
        this.report(context, TYPE_DEF, locationNode, context.getLocation(locationNode), message2);
    }

    private final String listAllowedValues(UElement context, List<? extends UExpression> allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (UExpression uExpression : allowedValues) {
            String s = null;
            PsiElement resolved = null;
            if (uExpression instanceof ExternalReferenceExpression) {
                resolved = UastLintUtils.resolve((ExternalReferenceExpression)((ExternalReferenceExpression)uExpression), (UElement)context);
            } else if (uExpression instanceof UReferenceExpression) {
                resolved = ((UReferenceExpression)uExpression).resolve();
            }
            if (resolved instanceof PsiField) {
                Object object = ((PsiField)resolved).getContainingClass();
                if (object == null || (object = object.getName()) == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"resolved.containingClass?.name ?: continue");
                Object containingClassName = object;
                s = (String)containingClassName + "." + ((PsiField)resolved).getName();
            }
            if (s == null) {
                s = uExpression.asSourceString();
            }
            CharSequence charSequence = sb;
            boolean bl = false;
            if (charSequence.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(TypedefDetector.class, Scope.JAVA_FILE_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = IMPLEMENTATION;
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.ERROR;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        TYPE_DEF = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"WrongConstant", (String)"Incorrect constant", (String)"\n                Ensures that when parameter in a method only allows a specific set of \\\n                constants, calls obey those rules.", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/TypedefDetector$Companion;", "", "()V", "ATTR_OPEN", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TYPE_DEF", "Lcom/android/tools/lint/detector/api/Issue;", "findIntDef", "Lorg/jetbrains/uast/UAnnotation;", "annotations", "", "lint-checks"})
    public static final class Companion {
        @Nullable
        public final UAnnotation findIntDef(@NotNull List<? extends UAnnotation> annotations) {
            Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
            for (UAnnotation uAnnotation : annotations) {
                String qualifiedName = uAnnotation.getQualifiedName();
                if (!SdkConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) && !SdkConstants.LONG_DEF_ANNOTATION.isEquals(qualifiedName)) continue;
                return uAnnotation;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

