/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\u0018\u00010\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/LeakDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "checkInstanceField", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "field", "Lorg/jetbrains/uast/UField;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "visitClass", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "FieldChecker", "lint-checks"})
public final class LeakDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final List<String> SUPER_CLASSES;
    private static final String CLASS_LIFECYCLE = "androidx.lifecycle.Lifecycle";
    private static final String CLASS_LIFECYCLE_OLD = "android.arch.lifecycle.Lifecycle";
    public static final Companion Companion;

    @Nullable
    public List<String> applicableSuperClasses() {
        return SUPER_CLASSES;
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        UMethod method;
        boolean isStatic;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)declaration));
        boolean isAnonymous = declaration instanceof UAnonymousClass;
        JavaEvaluator evaluator = context.getEvaluator();
        boolean bl = isStatic = evaluator.isStatic((PsiModifierListOwner)declaration) || containingClass == null;
        if (isStatic || isAnonymous) {
            for (UField field : declaration.getFields()) {
                this.checkInstanceField(context, field);
            }
            if (!isAnonymous) {
                return;
            }
        }
        String superClass = null;
        for (String cls : SUPER_CLASSES) {
            if (!evaluator.inheritsFrom((PsiClass)declaration, cls, false)) continue;
            superClass = cls;
            break;
        }
        if (superClass == null) {
            return;
        }
        UElement uastParent = declaration.getUastParent();
        if (uastParent != null && (method = (UMethod)UastUtils.getParentOfType((UElement)uastParent, UMethod.class, (boolean)true, (Class[])new Class[]{UClass.class, UObjectLiteralExpression.class})) != null && evaluator.isStatic((PsiModifierListOwner)method)) {
            return;
        }
        UCallExpression invocation = (UCallExpression)UastUtils.getParentOfType((UElement)((UElement)declaration), UObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class});
        Location location = null;
        location = isAnonymous && invocation != null ? context.getCallLocation(invocation, false, false) : context.getNameLocation(declaration);
        String name = null;
        if (isAnonymous) {
            StringBuilder stringBuilder = new StringBuilder().append("anonymous ");
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((UAnonymousClass)declaration).getBaseClassReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiJavaCodeReferenceElement, (String)"(declaration as UAnonymo\u2026      .baseClassReference");
            name = stringBuilder.append(psiJavaCodeReferenceElement.getQualifiedName()).toString();
        } else {
            name = declaration.getQualifiedName();
            if (name == null) {
                name = declaration.getName();
            }
        }
        String string = superClass;
        int n = StringsKt.lastIndexOf$default((CharSequence)superClass, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl2 = false;
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String superClassName = string2;
        context.report(ISSUE, declaration, location, "This `" + superClassName + "` class should be static or leaks might occur (" + name + ')');
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UField.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new FieldChecker(context);
    }

    private final void checkInstanceField(JavaContext context, UField field) {
        PsiType psiType = field.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        if (psiClassType == null) {
            return;
        }
        PsiClassType type = psiClassType;
        String string = type.getCanonicalText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.canonicalText");
        String fqn = string;
        if (StringsKt.startsWith$default((String)fqn, (String)"java.", (boolean)false, (int)2, null)) {
            return;
        }
        PsiClass psiClass = type.resolve();
        if (psiClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"type.resolve() ?: return");
        PsiClass cls = psiClass;
        if (LeakDetector.Companion.isLeakCandidate(cls, context.getEvaluator())) {
            context.report(ISSUE, field, context.getLocation(field), "This field leaks a context object");
        }
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(LeakDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Severity severity = Severity.WARNING;
        int n = 6;
        Boolean bl2 = true;
        String string = null;
        Category category = Category.PERFORMANCE;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"StaticFieldLeak", (String)"Static Field Leaks", (String)"\n                A static field will leak contexts.\n\n                Non-static inner classes have an implicit reference to their outer class. \\\n                If that outer class is for example a `Fragment` or `Activity`, then this \\\n                reference means that the long-running handler/loader/task will hold a \\\n                reference to the activity which prevents it from getting garbage collected.\n\n                Similarly, direct field references to activities and fragments from these \\\n                longer running instances can cause leaks.\n\n                ViewModel classes should never point to Views or non-application Contexts.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
        SUPER_CLASSES = CollectionsKt.listOf((Object[])new String[]{"android.content.Loader", "android.support.v4.content.Loader", "android.os.AsyncTask", "android.arch.lifecycle.ViewModel", "androidx.lifecycle.ViewModel"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/LeakDetector$FieldChecker;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "isInitializedToAppContext", "", "field", "Lcom/intellij/psi/PsiField;", "typeClass", "Lcom/intellij/psi/PsiClass;", "Lorg/jetbrains/uast/UField;", "report", "", "modifierList", "Lcom/intellij/psi/PsiModifierList;", "message", "", "visitField", "node", "lint-checks"})
    private static final class FieldChecker
    extends UElementHandler {
        private final JavaContext context;

        /*
         * WARNING - void declaration
         */
        public void visitField(@NotNull UField node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PsiModifierList modifierList = node.getModifierList();
            if (modifierList == null || !modifierList.hasModifierProperty("static")) {
                return;
            }
            PsiType psiType = node.getType();
            if (!(psiType instanceof PsiClassType)) {
                psiType = null;
            }
            PsiClassType psiClassType = (PsiClassType)psiType;
            if (psiClassType == null) {
                return;
            }
            PsiClassType type = psiClassType;
            String string = type.getCanonicalText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.canonicalText");
            String fqn = string;
            if (StringsKt.startsWith$default((String)fqn, (String)"java.", (boolean)false, (int)2, null)) {
                return;
            }
            PsiClass psiClass = type.resolve();
            if (psiClass == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"type.resolve() ?: return");
            PsiClass cls = psiClass;
            if (StringsKt.startsWith$default((String)fqn, (String)"android.", (boolean)false, (int)2, null)) {
                if (Companion.isLeakCandidate(cls, this.context.getEvaluator()) && !Companion.isAppContextName(cls, (PsiField)node) && !this.isInitializedToAppContext(node, cls)) {
                    String message2 = "Do not place Android context classes in static fields; this is a memory leak";
                    this.report((PsiField)node, modifierList, message2);
                }
            } else {
                PsiField[] psiFieldArray = cls.getAllFields();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFieldArray, (String)"cls.allFields");
                PsiField[] psiFieldArray2 = psiFieldArray;
                int n = psiFieldArray2.length;
                int message2 = 0;
                while (message2 < n) {
                    void count;
                    PsiField referenced = psiFieldArray2[message2];
                    if (count == 20) break;
                    PsiField psiField = referenced;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiField, (String)"referenced");
                    PsiType psiType2 = psiField.getType();
                    if (!(psiType2 instanceof PsiClassType)) {
                        psiType2 = null;
                    }
                    if ((PsiClassType)psiType2 == null) {
                    } else {
                        String canonical;
                        PsiClassType innerType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)innerType.getCanonicalText(), (String)"innerType.canonicalText");
                        if (!StringsKt.startsWith$default((String)canonical, (String)"java.", (boolean)false, (int)2, null)) {
                            if (innerType.resolve() == null) {
                            } else {
                                PsiClass innerCls;
                                Intrinsics.checkExpressionValueIsNotNull((Object)innerCls, (String)"innerType.resolve() ?: continue");
                                if (StringsKt.startsWith$default((String)canonical, (String)"android.", (boolean)false, (int)2, null) && Companion.isLeakCandidate(innerCls, this.context.getEvaluator()) && !Companion.isAppContextName(innerCls, referenced) && !this.isInitializedToAppContext(this.context, referenced, innerCls)) {
                                    String message3 = "Do not place Android context classes in static " + "fields (static reference to `" + cls.getName() + "` which has field " + '`' + referenced.getName() + "` pointing to `" + innerCls.getName() + "`); this " + "is a memory leak";
                                    this.report((PsiField)node, modifierList, message3);
                                    break;
                                }
                            }
                        }
                    }
                    ++count;
                }
            }
        }

        private final boolean isInitializedToAppContext(JavaContext context, PsiField field, PsiClass typeClass) {
            if (!context.getEvaluator().extendsClass(typeClass, "android.content.Context", false)) {
                return false;
            }
            UField uField = (UField)UastContextKt.toUElement((PsiElement)((PsiElement)field), UField.class);
            if (uField == null) {
                return true;
            }
            UField uField2 = uField;
            return this.isInitializedToAppContext(uField2, typeClass);
        }

        private final boolean isInitializedToAppContext(UField field, PsiClass typeClass) {
            PsiClass psiClass = field.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"field.containingClass ?: return false");
            PsiClass containingClass = psiClass;
            if (!this.context.getEvaluator().extendsClass(typeClass, "android.content.Context", false)) {
                return false;
            }
            PsiMethod[] psiMethodArray = containingClass.getConstructors();
            int n = psiMethodArray.length;
            for (int i = 0; i < n; ++i) {
                UExpression methodBody;
                PsiMethod method;
                PsiMethod psiMethod = method = psiMethodArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"method");
                if (UastFacade.INSTANCE.getMethodBody(psiMethod) == null) {
                    continue;
                }
                Ref assignedToAppContext = new Ref((Object)false);
                methodBody.accept((UastVisitor)new AbstractUastVisitor(field, assignedToAppContext){
                    final /* synthetic */ UField $field;
                    final /* synthetic */ Ref $assignedToAppContext;

                    public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                        if (UastExpressionUtils.isAssignment((UElement)((UElement)node)) && node.getLeftOperand() instanceof UResolvable) {
                            UExpression uExpression = node.getLeftOperand();
                            if (uExpression == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UResolvable");
                            }
                            if (Intrinsics.areEqual((Object)this.$field.getSourcePsi(), (Object)((UResolvable)uExpression).resolve())) {
                                UElement rhs = (UElement)node.getRightOperand();
                                while (rhs instanceof UQualifiedReferenceExpression) {
                                    rhs = (UElement)((UQualifiedReferenceExpression)rhs).getSelector();
                                }
                                if (rhs instanceof UCallExpression && Intrinsics.areEqual((Object)"getApplicationContext", (Object)Lint.getMethodName((UCallExpression)((UCallExpression)rhs)))) {
                                    this.$assignedToAppContext.set((Object)true);
                                }
                            }
                        }
                        return super.visitBinaryExpression(node);
                    }
                    {
                        this.$field = $captured_local_variable$0;
                        this.$assignedToAppContext = $captured_local_variable$1;
                    }
                });
                Object object = assignedToAppContext.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"assignedToAppContext.get()");
                if (!((Boolean)object).booleanValue()) continue;
                return true;
            }
            return false;
        }

        private final void report(PsiField field, PsiModifierList modifierList, String message2) {
            PsiElement locationNode = (PsiElement)field;
            if (modifierList.hasExplicitModifier("static")) {
                for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof PsiKeyword) || !Intrinsics.areEqual((Object)"static", (Object)((PsiKeyword)child).getText())) continue;
                    locationNode = child;
                    break;
                }
            }
            Location location = this.context.getLocation(locationNode);
            JavaContext.report$default((JavaContext)this.context, (Issue)ISSUE, (PsiElement)((PsiElement)field), (Location)location, (String)message2, null, (int)16, null);
        }

        public FieldChecker(@NotNull JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/LeakDetector$Companion;", "", "()V", "CLASS_LIFECYCLE", "", "CLASS_LIFECYCLE_OLD", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "SUPER_CLASSES", "", "isAppContextName", "", "cls", "Lcom/intellij/psi/PsiClass;", "field", "Lcom/intellij/psi/PsiField;", "isLeakCandidate", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "lint-checks"})
    public static final class Companion {
        private final boolean isAppContextName(PsiClass cls, PsiField field) {
            String name;
            String string = field.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"field.name");
            String string2 = name = string;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            String lower = string4;
            return (StringsKt.contains$default((CharSequence)lower, (CharSequence)"appcontext", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)lower, (CharSequence)"application", (boolean)false, (int)2, null)) && Intrinsics.areEqual((Object)"android.content.Context", (Object)cls.getQualifiedName());
        }

        private final boolean isLeakCandidate(PsiClass cls, JavaEvaluator evaluator) {
            return evaluator.extendsClass(cls, "android.content.Context", false) && !evaluator.extendsClass(cls, "android.app.Application", false) || evaluator.extendsClass(cls, "android.view.View", false) || evaluator.extendsClass(cls, "android.app.Fragment", false) || evaluator.extendsClass(cls, LeakDetector.CLASS_LIFECYCLE, false) || evaluator.extendsClass(cls, LeakDetector.CLASS_LIFECYCLE_OLD, false);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

