/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/C2dmDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class C2dmDetector
extends Detector
implements XmlScanner {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    public static final Companion Companion;

    @Nullable
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"receiver");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr attribute = attr;
        String receiverName = attribute.getValue();
        if (Intrinsics.areEqual((Object)receiverName, (Object)"com.google.android.c2dm.C2DMBroadcastReceiver") ^ true && Intrinsics.areEqual((Object)receiverName, (Object)"com.google.android.gcm.GCMBroadcastReceiver") ^ true) {
            return;
        }
        boolean haveReceive = false;
        boolean haveRegistration = false;
        Element intentFilter = XmlUtils.getFirstSubTagByName((Node)element, (String)"intent-filter");
        while (intentFilter != null) {
            Element action = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"action");
            while (action != null) {
                String actionName = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (Intrinsics.areEqual((Object)actionName, (Object)"com.google.android.c2dm.intent.RECEIVE")) {
                    haveReceive = true;
                } else if (Intrinsics.areEqual((Object)actionName, (Object)"com.google.android.c2dm.intent.REGISTRATION")) {
                    haveRegistration = true;
                }
                action = XmlUtils.getNextTagByName((Node)action, (String)"action");
            }
            intentFilter = XmlUtils.getNextTagByName((Node)intentFilter, (String)"intent-filter");
        }
        if (haveReceive && haveRegistration) {
            String message2 = "The C2DM library does not work on Android P or newer devices; you should migrate to Firebase Cloud Messaging to ensure reliable message delivery";
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)attribute, (Location)context.getValueLocation(attribute), (String)message2, null, (int)16, null);
        }
    }

    static {
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(C2dmDetector.class, Scope.MANIFEST_SCOPE);
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = null;
        boolean bl2 = false;
        Implementation implementation = IMPLEMENTATION;
        Severity severity = Severity.ERROR;
        int n = 8;
        Category category = Category.SECURITY;
        String string = "https://developers.google.com/cloud-messaging/c2dm";
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"UsingC2DM", (String)"Using C2DM", (String)"\n                The C2DM library does not work on Android P or newer devices; \\\n                you should migrate to Firebase Cloud Messaging to ensure reliable message delivery.\n                ", (Implementation)implementation, (String)string, (Category)category, (int)n, (Severity)severity, (boolean)bl2, bl, enumSet, collection, (int)3840, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/C2dmDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

