/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppLinksAutoVerifyDetector
extends Detector
implements XmlScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AppLinksAutoVerifyDetector.class, Scope.MANIFEST_SCOPE);
    public static final Issue ISSUE_ERROR = Issue.create((String)"AppLinksAutoVerifyError", (String)"App Links Auto Verification Failure", (String)"Ensures that app links are correctly set and associated with website.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://g.co/appindexing/applinks").setEnabledByDefault(false);
    public static final Issue ISSUE_WARNING = Issue.create((String)"AppLinksAutoVerifyWarning", (String)"Potential App Links Auto Verification Failure", (String)"Ensures that app links are correctly set and associated with website.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://g.co/appindexing/applinks").setEnabledByDefault(false);
    private static final String ATTRIBUTE_AUTO_VERIFY = "autoVerify";
    private static final String JSON_RELATIVE_PATH = "/.well-known/assetlinks.json";
    @VisibleForTesting
    static final int STATUS_HTTP_CONNECT_FAIL = -1;
    @VisibleForTesting
    static final int STATUS_MALFORMED_URL = -2;
    @VisibleForTesting
    static final int STATUS_UNKNOWN_HOST = -3;
    @VisibleForTesting
    static final int STATUS_NOT_FOUND = -4;
    @VisibleForTesting
    static final int STATUS_WRONG_JSON_SYNTAX = -5;
    @VisibleForTesting
    static final int STATUS_JSON_PARSE_FAIL = -6;
    @VisibleForTesting
    static final int STATUS_HTTP_OK = 200;
    private final Map<String, Future<HttpResult>> mFutures = Maps.newHashMap();
    private final Map<String, Attr> mJsonHost = Maps.newHashMap();
    @VisibleForTesting
    static Map<String, HttpResult> sMockData;

    public void visitDocument(XmlContext context, Document document) {
        if (!context.getScope().contains(Scope.ALL_JAVA_FILES)) {
            return;
        }
        if (document.getDocumentElement() != null) {
            List<Element> intents = AppLinksAutoVerifyDetector.getTags(document.getDocumentElement(), "intent-filter");
            if (!AppLinksAutoVerifyDetector.needAutoVerification(intents)) {
                return;
            }
            for (Element intent : intents) {
                boolean actionView = AppLinksAutoVerifyDetector.hasNamedSubTag(intent, "action", "android.intent.action.VIEW");
                boolean browsableCategory = AppLinksAutoVerifyDetector.hasNamedSubTag(intent, "category", "android.intent.category.BROWSABLE");
                if (!actionView || !browsableCategory) continue;
                this.mJsonHost.putAll(AppLinksAutoVerifyDetector.getJsonUrl(context, intent));
            }
        }
        Map<String, HttpResult> results = this.getJsonFileAsync();
        String packageName = context.getProject().getPackage();
        block10: for (Map.Entry<String, HttpResult> result : results.entrySet()) {
            Attr host;
            if (result.getValue() == null || (host = this.mJsonHost.get(result.getKey())) == null) continue;
            String jsonPath = result.getKey() + JSON_RELATIVE_PATH;
            switch (result.getValue().mStatus) {
                case 200: {
                    List<String> packageNames = AppLinksAutoVerifyDetector.getPackageNameFromJson(result.getValue().mJsonFile);
                    if (packageNames.contains(packageName)) continue block10;
                    context.report(ISSUE_ERROR, (Node)host, context.getLocation((Node)host), String.format("This host does not support app links to your app. Checks the Digital Asset Links JSON file: %s", jsonPath));
                    continue block10;
                }
                case -1: {
                    context.report(ISSUE_WARNING, (Node)host, context.getLocation((Node)host), String.format("Connection to Digital Asset Links JSON file %s fails", jsonPath));
                    continue block10;
                }
                case -2: {
                    context.report(ISSUE_ERROR, (Node)host, context.getLocation((Node)host), String.format("Malformed URL of Digital Asset Links JSON file: %s. An unknown protocol is specified", jsonPath));
                    continue block10;
                }
                case -3: {
                    context.report(ISSUE_WARNING, (Node)host, context.getLocation((Node)host), String.format("Unknown host: %s. Check if the host exists, and check your network connection", result.getKey()));
                    continue block10;
                }
                case -4: {
                    context.report(ISSUE_ERROR, (Node)host, context.getLocation((Node)host), String.format("Digital Asset Links JSON file %s is not found on the host", jsonPath));
                    continue block10;
                }
                case -5: {
                    context.report(ISSUE_ERROR, (Node)host, context.getLocation((Node)host), String.format("%s has incorrect JSON syntax", jsonPath));
                    continue block10;
                }
                case -6: {
                    context.report(ISSUE_ERROR, (Node)host, context.getLocation((Node)host), String.format("Parsing JSON file %s fails", jsonPath));
                    continue block10;
                }
            }
            context.report(ISSUE_WARNING, (Node)host, context.getLocation((Node)host), String.format("HTTP request for Digital Asset Links JSON file %1$s fails. HTTP response code: %2$s", jsonPath, result.getValue().mStatus));
        }
    }

    private static List<Element> getTags(Element element, String tagName) {
        ArrayList tagList = Lists.newArrayList();
        if (element.getTagName().equalsIgnoreCase(tagName)) {
            tagList.add(element);
        } else {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                tagList.addAll(AppLinksAutoVerifyDetector.getTags((Element)child, tagName));
            }
        }
        return tagList;
    }

    private static boolean needAutoVerification(List<Element> intents) {
        for (Element intent : intents) {
            if (!intent.getAttributeNS("http://schemas.android.com/apk/res/android", ATTRIBUTE_AUTO_VERIFY).equals("true")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNamedSubTag(Element element, String tagName, String nameAttrValue) {
        NodeList children = element.getElementsByTagName(tagName);
        for (int i = 0; i < children.getLength(); ++i) {
            Element e = (Element)children.item(i);
            if (!e.getAttributeNS("http://schemas.android.com/apk/res/android", "name").equals(nameAttrValue)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Attr> getJsonUrl(XmlContext context, Element intent) {
        ArrayList schemes = Lists.newArrayList();
        ArrayList hosts = Lists.newArrayList();
        NodeList dataTags = intent.getElementsByTagName("data");
        for (int k = 0; k < dataTags.getLength(); ++k) {
            Element dataTag = (Element)dataTags.item(k);
            String scheme = dataTag.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme");
            if (scheme.equals("http") || scheme.equals("https")) {
                schemes.add(scheme);
            }
            if (!dataTag.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) continue;
            Attr host = dataTag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "host");
            hosts.add(host);
        }
        HashMap urls = Maps.newHashMap();
        for (String scheme : schemes) {
            for (Attr host : hosts) {
                String hostname = host.getValue();
                if (hostname.startsWith("${") && (hostname = AppLinksAutoVerifyDetector.resolvePlaceHolder(context, hostname)) == null) continue;
                urls.put(scheme + "://" + hostname, host);
            }
        }
        return urls;
    }

    private static String resolvePlaceHolder(XmlContext context, String hostname) {
        assert (hostname.startsWith("${"));
        LintModelVariant variant = context.getProject().getBuildVariant();
        if (variant != null) {
            Map placeHolders = variant.getManifestPlaceholders();
            String name = hostname.substring("${".length(), hostname.length() - "}".length());
            return (String)placeHolders.get(name);
        }
        return null;
    }

    private Map<String, HttpResult> getJsonFileAsync() {
        if (sMockData != null) {
            return sMockData;
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (Map.Entry<String, Attr> url : this.mJsonHost.entrySet()) {
            Future<HttpResult> future = executorService.submit(() -> AppLinksAutoVerifyDetector.getJson((String)url.getKey() + JSON_RELATIVE_PATH));
            this.mFutures.put(url.getKey(), future);
        }
        executorService.shutdown();
        HashMap jsons = Maps.newHashMap();
        for (Map.Entry<String, Future<HttpResult>> entry : this.mFutures.entrySet()) {
            try {
                jsons.put(entry.getKey(), entry.getValue().get());
            }
            catch (Exception e) {
                jsons.put(entry.getKey(), null);
            }
        }
        return jsons;
    }

    /*
     * Exception decompiling
     */
    private static HttpResult getJson(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> getPackageNameFromJson(JsonElement element) {
        ArrayList packageNames = Lists.newArrayList();
        if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject target2;
                JsonElement app = jsonArray.get(i);
                if (!(app instanceof JsonObject) || (target2 = ((JsonObject)app).getAsJsonObject("target")) == null) continue;
                JsonElement namespace = target2.get("namespace");
                JsonElement packageName = target2.get("package_name");
                if (namespace == null || !namespace.getAsString().equals("android_app") || packageName == null) continue;
                packageNames.add(packageName.getAsString());
            }
        }
        return packageNames;
    }

    @VisibleForTesting
    static final class HttpResult {
        private final int mStatus;
        private final JsonElement mJsonFile;

        @VisibleForTesting
        HttpResult(int status, JsonElement jsonFile) {
            this.mStatus = status;
            this.mJsonFile = jsonFile;
        }
    }
}

