/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.java.JavaUSwitchExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0018\u00010\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/NonConstantResourceIdDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "Companion", "ResourceIdVisitor", "lint-checks"})
public final class NonConstantResourceIdDetector
extends Detector
implements SourceCodeScanner {
    @JvmField
    @NotNull
    public static final Issue NON_CONSTANT_RESOURCE_ID;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf((Object[])new Class[]{UAnnotation.class, USwitchExpression.class});
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new ResourceIdVisitor(context);
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(NonConstantResourceIdDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Boolean bl2 = true;
        Severity severity = Severity.WARNING;
        int n = 5;
        String string = null;
        Category category = Category.CORRECTNESS;
        NON_CONSTANT_RESOURCE_ID = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"NonConstantResourceId", (String)"Checks use of resource IDs in places requiring constants.", (String)"\n                Avoid the usage of resource IDs where constant expressions are required.\n\n                A future version of the Android Gradle Plugin will generate R classes with \\\n                non-constant IDs in order to improve the performance of incremental compilation.\n                ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/NonConstantResourceIdDetector$ResourceIdVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "getContext", "()Lcom/android/tools/lint/detector/api/JavaContext;", "checkExpressionReceiverIsRClass", "", "expression", "Lorg/jetbrains/uast/UExpression;", "checkSwitchCasesForRClassReferences", "", "body", "Lorg/jetbrains/uast/UExpressionList;", "visitAnnotation", "node", "Lorg/jetbrains/uast/UAnnotation;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "lint-checks"})
    public static final class ResourceIdVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public void visitSwitchExpression(@NotNull USwitchExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (node instanceof JavaUSwitchExpression) {
                this.checkSwitchCasesForRClassReferences((UExpressionList)((JavaUSwitchExpression)node).getBody());
            }
        }

        private final void checkSwitchCasesForRClassReferences(UExpressionList body) {
            for (UExpression expression : body.getExpressions()) {
                UExpression switchCase;
                if (!(expression instanceof USwitchClauseExpression)) continue;
                if ((UExpression)CollectionsKt.firstOrNull((List)((USwitchClauseExpression)expression).getCaseValues()) == null) {
                    continue;
                }
                if (!this.checkExpressionReceiverIsRClass(switchCase)) continue;
                Location location = this.context.getLocation((UElement)switchCase);
                JavaContext.report$default((JavaContext)this.context, (Issue)NON_CONSTANT_RESOURCE_ID, (UElement)((UElement)switchCase), (Location)location, (String)"Resource IDs will be non-final in Android Gradle Plugin version 7.0, avoid using them in switch case statements", null, (int)16, null);
            }
        }

        public void visitAnnotation(@NotNull UAnnotation node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            for (UNamedExpression attribute : node.getAttributeValues()) {
                UExpression attributeExpression = attribute.getExpression();
                if (!this.checkExpressionReceiverIsRClass(attributeExpression)) continue;
                Location location = this.context.getLocation((UElement)attributeExpression);
                JavaContext.report$default((JavaContext)this.context, (Issue)NON_CONSTANT_RESOURCE_ID, (UElement)((UElement)attributeExpression), (Location)location, (String)"Resource IDs will be non-final in Android Gradle Plugin version 7.0, avoid using them as annotation attributes", null, (int)16, null);
            }
        }

        private final boolean checkExpressionReceiverIsRClass(UExpression expression) {
            ResourceReference evaluatedExpression = ResourceReference.Companion.get((UElement)expression);
            return evaluatedExpression != null && Intrinsics.areEqual((Object)evaluatedExpression.getPackage(), (Object)"android") ^ true;
        }

        @NotNull
        public final JavaContext getContext() {
            return this.context;
        }

        public ResourceIdVisitor(@NotNull JavaContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/NonConstantResourceIdDetector$Companion;", "", "()V", "NON_CONSTANT_RESOURCE_ID", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

