/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.SdkIntAnnotation;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/SdkIntDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkPartialResults", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableMethodNames", "", "", "getApplicableReferenceNames", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "visitReference", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Companion", "lint-checks"})
public final class SdkIntDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(SdkIntDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"SDK_INT");
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"getBuildSdkInt");
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)referenced, (String)"referenced");
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isMemberInClass((PsiMember)(referenced instanceof PsiField ? (PsiField)referenced : null), "android.os.Build.VERSION")) {
            Companion.checkAnnotation(context, (UElement)reference);
        }
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Companion.checkAnnotation(context, (UElement)node);
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)partialResults, (String)"partialResults");
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"AnnotateVersionCheck", (String)"Annotate SDK_INT checks", (String)"\n                Methods which perform `SDK_INT` version checks (or field constants which reflect \\\n                the result of a version check) in libraries should be annotated with \\\n                `@ChecksSdkIntAtLeast`. This makes it possible for lint to correctly \\\n                check calls into the library later to correctly understand that problematic \\\n                code which is wrapped within a call into this library is safe after all.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J2\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\rH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0002J(\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u001a\u00100\u001a\u00020!2\u0006\u0010\f\u001a\u00020\r2\b\u00101\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u00102\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u000203H\u0002J\u0018\u00102\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u00104\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u000205H\u0002J\u0018\u00104\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00106\u001a\u00020\r2\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010:\u001a\u0004\u0018\u00010;R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/tools/lint/checks/SdkIntDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "annotated", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "Lorg/jetbrains/uast/UAnnotated;", "api", "", "checkAnnotation", "", "sdkInt", "Lorg/jetbrains/uast/UElement;", "checkField", "comparison", "Lorg/jetbrains/uast/UBinaryExpression;", "isGreaterOrEquals", "field", "Lorg/jetbrains/uast/UField;", "checkMethod", "method", "Lorg/jetbrains/uast/UMethod;", "receiver", "Lorg/jetbrains/uast/UExpression;", "lambda", "createAnnotationFix", "Lcom/android/tools/lint/detector/api/LintFix;", "args", "", "location", "Lcom/android/tools/lint/detector/api/Location;", "findAttribute", "name", "findSdkIntAnnotation", "Lcom/android/tools/lint/checks/SdkIntAnnotation;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "project", "Lcom/android/tools/lint/detector/api/Project;", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "getBuildCode", "constant", "getFieldKey", "Lcom/intellij/psi/PsiField;", "getMethodKey", "Lcom/intellij/psi/PsiMethod;", "getParameterIndex", "parameter", "Lcom/intellij/psi/PsiParameter;", "isLambdaType", "type", "Lcom/intellij/psi/PsiType;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isLambdaType(@NotNull JavaContext context, @Nullable PsiType type) {
            PsiClassType psiClassType;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            PsiClassType psiClassType2 = type instanceof PsiClassType ? (PsiClassType)type : null;
            PsiClassType psiClassType3 = object = psiClassType2 == null ? null : psiClassType2.rawType();
            if (object == null) {
                return false;
            }
            PsiClassType rawType = psiClassType = object;
            object = rawType.getCanonicalText();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"rawType.canonicalText");
            Object fqn = object;
            if (Intrinsics.areEqual((Object)fqn, (Object)"java.lang.Runnable") || Intrinsics.areEqual((Object)fqn, (Object)"java.util.function.Function") || StringsKt.startsWith$default((String)fqn, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null)) {
                return true;
            }
            String[] stringArray = rawType.resolve();
            if (stringArray == null) {
                return false;
            }
            PsiClassType clz = psiClassType2 = stringArray;
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.implementsInterface((PsiClass)clz, "kotlin.Function", false) || evaluator.implementsInterface((PsiClass)clz, "java.util.function.Function", false) || evaluator.findAnnotation((PsiModifierListOwner)clz, stringArray = new String[]{"java.lang.FunctionalInterface"}) != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void checkAnnotation(@NotNull JavaContext context, @NotNull UElement sdkInt) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)sdkInt, (String)"sdkInt");
            Project project = context.getProject();
            if (!project.isLibrary()) return;
            if (!project.isAndroidProject()) {
                return;
            }
            UBinaryExpression uBinaryExpression = (UBinaryExpression)UastUtils.getParentOfType((UElement)sdkInt, UBinaryExpression.class, (boolean)true);
            if (uBinaryExpression == null) {
                return;
            }
            UBinaryExpression comparison = uBinaryExpression;
            UastBinaryOperator tokenType = comparison.getOperator();
            if (tokenType != UastBinaryOperator.GREATER && tokenType != UastBinaryOperator.GREATER_OR_EQUALS) {
                return;
            }
            boolean isGreaterOrEquals = tokenType == UastBinaryOperator.GREATER_OR_EQUALS;
            UElement parent = comparison.getUastParent();
            if (parent instanceof UField) {
                this.checkField(comparison, context, isGreaterOrEquals, (UField)parent);
                return;
            }
            if (parent instanceof UReturnExpression) {
                UElement parentParent = parent.getUastParent();
                if (!(parentParent instanceof UBlockExpression)) return;
                if (!(parentParent.getUastParent() instanceof UMethod)) return;
                int size = ((UBlockExpression)parentParent).getExpressions().size();
                if (size != 1) return;
                UElement uElement = parentParent.getUastParent();
                if (uElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UMethod");
                }
                UMethod method = (UMethod)uElement;
                com.android.tools.lint.checks.SdkIntDetector$Companion.checkMethod$default(this, comparison, context, isGreaterOrEquals, method, 0, 16, null);
                return;
            } else {
                UMethod uMethod;
                UElement uElement;
                UElement uElement2;
                UElement uElement3;
                UElement uElement4;
                UExpression uExpression;
                UExpression uExpression2;
                List list;
                UExpression size;
                UBlockExpression method;
                if (!(parent instanceof UIfExpression)) return;
                UExpression uExpression3 = ((UIfExpression)parent).getThenExpression();
                UBlockExpression uBlockExpression = method = uExpression3 instanceof UBlockExpression ? (UBlockExpression)uExpression3 : null;
                UExpression uExpression4 = method == null ? null : (size = (list = method.getExpressions()) == null ? null : (UExpression)CollectionsKt.firstOrNull((List)list));
                if (size == null) {
                    method = ((UIfExpression)parent).getThenExpression();
                    if (method == null) {
                        return;
                    }
                    uExpression2 = method;
                } else {
                    uExpression2 = size;
                }
                UExpression then = uExpression2;
                method = then;
                if (method instanceof UQualifiedReferenceExpression) {
                    uExpression = ((UQualifiedReferenceExpression)then).getReceiver();
                } else {
                    if (!(method instanceof UCallExpression)) return;
                    UExpression uExpression5 = ((UCallExpression)then).getReceiver();
                    if (uExpression5 == null) {
                        return;
                    }
                    uExpression = uExpression5;
                }
                UExpression receiver = uExpression;
                if (parent.getUastParent() instanceof UReturnExpression) {
                    UMethod uMethod2;
                    uElement4 = parent.getUastParent();
                    uElement3 = uElement4 == null ? null : uElement4.getUastParent();
                    UMethod uMethod3 = uMethod2 = uElement3 instanceof UMethod ? (UMethod)uElement3 : null;
                    if (uMethod2 == null) {
                        uElement2 = parent.getUastParent();
                        uElement4 = uElement2 == null ? null : ((uElement = uElement2.getUastParent()) == null ? null : uElement.getUastParent());
                        if (!(uElement4 instanceof UMethod)) return;
                        UMethod uMethod4 = (UMethod)uElement4;
                        uElement3 = uMethod4;
                        if (uElement3 == null) {
                            return;
                        }
                        uMethod = uElement3;
                    } else {
                        uMethod = uMethod2;
                    }
                } else {
                    if (!(parent.getUastParent() instanceof UBlockExpression)) return;
                    UElement uElement5 = parent.getUastParent();
                    if (!((uElement5 == null ? null : uElement5.getUastParent()) instanceof UMethod)) return;
                    uElement3 = parent.getUastParent();
                    if (uElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.uast.UBlockExpression");
                    }
                    UBlockExpression uBlockExpression2 = (UBlockExpression)uElement3;
                    List expressions = uBlockExpression2.getExpressions();
                    if (expressions.size() != 1) {
                        if (expressions.size() != 2) return;
                        if (!(expressions.get(1) instanceof UReturnExpression)) return;
                    }
                    uElement2 = (uElement = parent.getUastParent()) == null ? null : uElement.getUastParent();
                    UMethod uMethod5 = uElement4 = uElement2 instanceof UMethod ? (UMethod)uElement2 : null;
                    if (uElement4 == null) {
                        UElement uElement6;
                        UElement uElement7 = parent.getUastParent();
                        uElement = uElement7 == null ? null : ((uElement6 = uElement7.getUastParent()) == null ? null : uElement6.getUastParent());
                        if (!(uElement instanceof UMethod)) return;
                        UMethod uMethod6 = (UMethod)uElement;
                        uElement2 = uMethod6;
                        if (uElement2 == null) {
                            return;
                        }
                        uMethod = uElement2;
                    } else {
                        uMethod = uElement4;
                    }
                }
                method = uMethod;
                this.checkMethod(context, (UMethod)method, receiver, comparison, isGreaterOrEquals);
            }
        }

        private final void checkMethod(JavaContext context, UMethod method, UExpression receiver, UBinaryExpression comparison, boolean isGreaterOrEquals) {
            PsiParameter psiParameter;
            PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)receiver));
            PsiParameter psiParameter2 = psiParameter = psiElement instanceof PsiParameter ? (PsiParameter)psiElement : null;
            if (psiParameter == null) {
                return;
            }
            PsiParameter parameter = psiParameter;
            int index = this.getParameterIndex(parameter);
            if (index != -1 && this.isLambdaType(context, parameter.getType())) {
                this.checkMethod(comparison, context, isGreaterOrEquals, method, index);
            }
        }

        private final int getParameterIndex(PsiParameter parameter) {
            PsiParameterList psiParameterList;
            PsiElement psiElement = parameter.getParent();
            PsiParameterList psiParameterList2 = psiParameterList = psiElement instanceof PsiParameterList ? (PsiParameterList)psiElement : null;
            if (psiParameterList == null) {
                return -1;
            }
            PsiParameterList parameterList = psiParameterList;
            return parameterList.getParameterIndex(parameter);
        }

        private final void checkMethod(UBinaryExpression comparison, JavaContext context, boolean isGreaterOrEquals, UMethod method, int lambda) {
            int index;
            PsiElement parameter;
            Integer api;
            UExpression apiOperand = comparison.getRightOperand();
            Object object = apiOperand.evaluate();
            Object apiValue = object == null ? ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)apiOperand)) : object;
            Integer n = api = apiValue instanceof Integer ? (Integer)apiValue : null;
            if (api != null) {
                int apiAtLeast;
                int n2 = apiAtLeast = isGreaterOrEquals ? api : api + 1;
                if (!this.annotated(context, (UAnnotated)method, apiAtLeast)) {
                    String buildCode = this.getBuildCode(apiAtLeast, (UElement)(isGreaterOrEquals ? apiOperand : null));
                    Location location = context.getNameLocation(method);
                    String args = "api=" + buildCode + (lambda != -1 ? Intrinsics.stringPlus((String)", lambda=", (Object)lambda) : "");
                    String message2 = "This method should be annotated with `@ChecksSdkIntAtLeast(" + args + ")`";
                    LintFix fix = this.createAnnotationFix(context, args, context.getLocation(method));
                    context.report(ISSUE, method, location, message2, fix);
                    if (!context.isGlobalAnalysis()) {
                        String methodDesc = this.getMethodKey(context.getEvaluator(), method);
                        LintMap map = context.getPartialResults(ISSUE).map();
                        map.put(methodDesc, "api=" + apiAtLeast + (lambda != -1 ? Intrinsics.stringPlus((String)",lambda=", (Object)lambda) : ""));
                    }
                }
            } else if (apiOperand instanceof UReferenceExpression && (parameter = ((UReferenceExpression)apiOperand).resolve()) instanceof PsiParameter && (index = this.getParameterIndex((PsiParameter)parameter)) != -1 && !this.annotated(context, (UAnnotated)method, -1)) {
                String args = "parameter=" + index + (lambda != -1 ? Intrinsics.stringPlus((String)", lambda=", (Object)lambda) : "");
                String message3 = "This method should be annotated with `@ChecksSdkIntAtLeast(" + args + ")`";
                Location location = context.getNameLocation(method);
                LintFix fix = this.createAnnotationFix(context, args, context.getLocation(method));
                context.report(ISSUE, method, location, message3, fix);
                if (!context.isGlobalAnalysis()) {
                    String methodDesc = this.getMethodKey(context.getEvaluator(), method);
                    LintMap map = context.getPartialResults(ISSUE).map();
                    map.put(methodDesc, "parameter=" + index + (lambda != -1 ? Intrinsics.stringPlus((String)",lambda=", (Object)lambda) : ""));
                }
            }
        }

        static /* synthetic */ void checkMethod$default(Companion companion, UBinaryExpression uBinaryExpression, JavaContext javaContext, boolean bl, UMethod uMethod, int n, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                n = -1;
            }
            companion.checkMethod(uBinaryExpression, javaContext, bl, uMethod, n);
        }

        private final LintFix createAnnotationFix(JavaContext context, String args, Location location) {
            if (context.getEvaluator().findClass("androidx.annotation.ChecksSdkIntAtLeast") == null) {
                return null;
            }
            return LintFix.Builder.annotate$default((LintFix.Builder)LintFix.Companion.create(), (String)("androidx.annotation.ChecksSdkIntAtLeast(" + args + ')'), (boolean)false, (int)2, null).range(location).build();
        }

        private final String getBuildCode(int api, UElement constant) {
            Object object;
            String text;
            UReferenceExpression uReferenceExpression;
            UReferenceExpression uReferenceExpression2 = uReferenceExpression = constant instanceof UReferenceExpression ? (UReferenceExpression)constant : null;
            String string = uReferenceExpression == null ? null : (text = (object = uReferenceExpression.getSourcePsi()) == null ? null : object.getText());
            if (text != null) {
                return text;
            }
            object = SdkVersionInfo.getBuildCode((int)api);
            if (object == null) {
                return String.valueOf(api);
            }
            Object buildCode = object;
            return Intrinsics.stringPlus((String)"android.os.Build.VERSION_CODES.", (Object)buildCode);
        }

        private final void checkField(UBinaryExpression comparison, JavaContext context, boolean isGreaterOrEquals, UField field) {
            int atLeast;
            Integer n;
            UExpression apiOperand = comparison.getRightOperand();
            Object object = apiOperand.evaluate();
            Object value = object == null ? ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)apiOperand)) : object;
            Integer n2 = n = value instanceof Integer ? (Integer)value : null;
            if (n == null) {
                return;
            }
            int api = n;
            int n3 = atLeast = isGreaterOrEquals ? api : api + 1;
            if (!this.annotated(context, (UAnnotated)field, atLeast)) {
                String buildCode = this.getBuildCode(atLeast, (UElement)(isGreaterOrEquals ? apiOperand : null));
                String args = Intrinsics.stringPlus((String)"api=", (Object)buildCode);
                String message2 = "This field should be annotated with `ChecksSdkIntAtLeast(" + args + ")`";
                Location location = context.getLocation(field);
                LintFix fix = this.createAnnotationFix(context, args, location);
                context.report(ISSUE, field, location, message2, fix);
                if (!context.isGlobalAnalysis()) {
                    String fieldDesc = this.getFieldKey(context.getEvaluator(), field);
                    LintMap map = context.getPartialResults(ISSUE).map();
                    map.put(fieldDesc, Intrinsics.stringPlus((String)"api=", (Object)atLeast));
                }
            }
        }

        private final boolean annotated(JavaContext context, UAnnotated annotated, int api) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = context.getEvaluator().getAllAnnotations(annotated, false);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"androidx.annotation.ChecksSdkIntAtLeast")) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final String getMethodKey(JavaEvaluator evaluator, UMethod method) {
            String string;
            String desc = evaluator.getMethodDescription((PsiMethod)method, false, false);
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
            if (uClass == null) {
                string = null;
            } else {
                UClass uClass2 = uClass;
                boolean bl = false;
                boolean bl2 = false;
                UClass it = uClass2;
                boolean bl3 = false;
                string = evaluator.getQualifiedName((PsiClass)it);
            }
            String cls = string;
            return cls + '#' + method.getName() + desc;
        }

        private final String getFieldKey(JavaEvaluator evaluator, UField field) {
            String string;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)field));
            if (uClass == null) {
                string = null;
            } else {
                UClass uClass2 = uClass;
                boolean bl = false;
                boolean bl2 = false;
                UClass it = uClass2;
                boolean bl3 = false;
                string = evaluator.getQualifiedName((PsiClass)it);
            }
            String cls = string;
            return cls + '#' + field.getName();
        }

        private final String getMethodKey(JavaEvaluator evaluator, PsiMethod method) {
            String string;
            String desc = evaluator.getMethodDescription(method, false, false);
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                string = null;
            } else {
                PsiClass psiClass2 = psiClass;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass2;
                boolean bl3 = false;
                string = evaluator.getQualifiedName(it);
            }
            String cls = string;
            return cls + '#' + method.getName() + desc;
        }

        private final String getFieldKey(JavaEvaluator evaluator, PsiField field) {
            String string;
            PsiClass psiClass = field.getContainingClass();
            if (psiClass == null) {
                string = null;
            } else {
                PsiClass psiClass2 = psiClass;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass2;
                boolean bl3 = false;
                string = evaluator.getQualifiedName(it);
            }
            String cls = string;
            return cls + '#' + field.getName();
        }

        @Nullable
        public final SdkIntAnnotation findSdkIntAnnotation(@NotNull LintClient client, @NotNull JavaEvaluator evaluator, @NotNull Project project, @NotNull PsiModifierListOwner owner) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)evaluator, (String)"evaluator");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            PsiModifierListOwner psiModifierListOwner = owner;
            if (psiModifierListOwner instanceof PsiMethod) {
                string = this.getMethodKey(evaluator, (PsiMethod)owner);
            } else if (psiModifierListOwner instanceof PsiField) {
                string = this.getFieldKey(evaluator, (PsiField)owner);
            } else {
                return null;
            }
            String key = string;
            LintMap map = client.getPartialResults(project, ISSUE).map();
            String string2 = map.get(key);
            if (string2 == null) {
                return null;
            }
            String args = string2;
            String string3 = this.findAttribute(args, "api");
            Integer api = string3 == null ? null : StringsKt.toIntOrNull((String)string3);
            String codename = this.findAttribute(args, "codename");
            String string4 = this.findAttribute(args, "parameter");
            Integer parameter = string4 == null ? null : StringsKt.toIntOrNull((String)string4);
            String string5 = this.findAttribute(args, "lambda");
            Integer lambda = string5 == null ? null : StringsKt.toIntOrNull((String)string5);
            return new SdkIntAnnotation(api, codename, parameter, lambda);
        }

        private final String findAttribute(String args, String name) {
            String key = Intrinsics.stringPlus((String)name, (Object)"=");
            int index = StringsKt.indexOf$default((CharSequence)args, (String)key, (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                return null;
            }
            int start = index + key.length();
            int n = StringsKt.indexOf$default((CharSequence)args, (char)',', (int)start, (boolean)false, (int)4, null);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            int end = it == -1 ? args.length() : it;
            String string = args;
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

