/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ClassScanner;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelModule;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UReferenceExpression;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J \u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/MediaCapabilitiesDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/ClassScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "foundVideoUsage", "", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkInstruction", "Lcom/android/tools/lint/detector/api/ClassContext;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "method", "Lorg/objectweb/asm/tree/MethodNode;", "instruction", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "checkManifest", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableAsmNodeTypes", "", "getApplicableReferenceNames", "", "", "visitReference", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Companion", "lint-checks"})
public final class MediaCapabilitiesDetector
extends Detector
implements SourceCodeScanner,
ClassScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean foundVideoUsage;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String VALUE_MEDIA_CAPABILITIES = "android.content.MEDIA_CAPABILITIES";
    @NotNull
    public static final String ATTR_RESOURCE = "resource";
    @NotNull
    private static final String FQN_MEDIASTORE = "android.provider.MediaStore";
    @NotNull
    private static final String NAME_VIDEO = "Video";
    @NotNull
    private static final String FQN_MEDIASTORE_VIDEO = "android.provider.MediaStore.Video";
    @NotNull
    private static final String JVM_MEDIASTORE_VIDEO = "android/provider/MediaStore$Video";

    @NotNull
    public int[] getApplicableAsmNodeTypes() {
        int[] nArray = new int[]{5, 4};
        return nArray;
    }

    public void checkInstruction(@NotNull ClassContext context, @NotNull ClassNode classNode, @NotNull MethodNode method, @NotNull AbstractInsnNode instruction) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
        if (this.foundVideoUsage) {
            return;
        }
        AbstractInsnNode abstractInsnNode = instruction;
        if (abstractInsnNode instanceof FieldInsnNode) {
            string = ((FieldInsnNode)instruction).owner;
        } else if (abstractInsnNode instanceof MethodInsnNode) {
            string = ((MethodInsnNode)instruction).owner;
        } else {
            String string2 = "Only field or method accesses are supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String owner = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)owner, (String)"owner");
        if (StringsKt.startsWith$default((String)owner, (String)JVM_MEDIASTORE_VIDEO, (boolean)false, (int)2, null)) {
            this.foundVideoUsage = true;
            return;
        }
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)NAME_VIDEO);
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)referenced, (String)"referenced");
        if (this.foundVideoUsage) {
            return;
        }
        if (referenced instanceof PsiClass && Intrinsics.areEqual((Object)((PsiClass)referenced).getQualifiedName(), (Object)FQN_MEDIASTORE_VIDEO)) {
            this.foundVideoUsage = true;
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.foundVideoUsage) {
            return;
        }
        if (context.isGlobalAnalysis()) {
            if (context.getProject() == context.getMainProject()) {
                this.checkManifest(context);
            }
        } else {
            context.getPartialResults(ISSUE).map().put("hasVideoUsage", true);
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)partialResults, (String)"partialResults");
        this.checkManifest(context);
    }

    private final void checkManifest(Context context) {
        Object v0;
        Element application;
        block7: {
            Object object;
            LintModelModule lintModelModule = context.getMainProject().getBuildModule();
            if (!Intrinsics.areEqual(lintModelModule == null ? null : ((object = lintModelModule.getGradleVersion()) == null ? null : Boolean.valueOf(object.isAtLeastIncludingPreviews(7, 0, 0))), (Object)true)) {
                return;
            }
            object = context.getMainProject().getMergedManifest();
            if (object == null) {
                return;
            }
            Object mergedManifest = object;
            Element element = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application");
            if (element == null) {
                return;
            }
            application = element;
            Iterable iterable = XmlUtils.getSubTagsByName((Node)application, (String)"property");
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"getSubTagsByName(application, TAG_PROPERTY)");
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Element element2 = (Element)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)element2.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)VALUE_MEDIA_CAPABILITIES)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        Element propertyElement = v0;
        if (propertyElement == null) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)Context.getLocation$default((Context)context, (Object)application, null, (int)2, null), (String)"The app accesses `MediaStore.Video`, but is missing a `<property>` tag with a `android.content.MEDIA_CAPABILITIES` declaration", null, (int)8, null);
        } else if (!propertyElement.hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_RESOURCE)) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)Context.getLocation$default((Context)context, (Object)propertyElement, null, (int)2, null), (String)"The `android.content.MEDIA_CAPABILITIES` `<property>` tag is missing the `android:resource` attribute pointing to a valid XML file", null, (int)8, null);
        }
    }

    static {
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_LIBRARIES)};
        Implementation implementation = new Implementation(MediaCapabilitiesDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE, (Enum)Scope.JAVA_LIBRARIES), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"MediaCapabilities", (String)"Media Capabilities property not specified", (String)"\n                In Android 12 and higher, an app that opens media files should explicitly specify \\\n                media formats that it doesn't support, so the OS can provide a transcoded file \\\n                instead.\n                ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3088, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/MediaCapabilitiesDetector$Companion;", "", "()V", "ATTR_RESOURCE", "", "FQN_MEDIASTORE", "FQN_MEDIASTORE_VIDEO", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "JVM_MEDIASTORE_VIDEO", "NAME_VIDEO", "VALUE_MEDIA_CAPABILITIES", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

