/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class WrongIdDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE);
    private final Set<String> mGlobalIds = new HashSet<String>(100);
    private Set<String> mFileIds;
    private Set<String> mDeclaredIds;
    private Map<String, Location.Handle> mHandles;
    private Map<String, String> mPendingNotSibling;
    private List<Element> mRelativeLayouts;
    public static final Issue UNKNOWN_ID = Issue.create((String)"UnknownId", (String)"Reference to an unknown id", (String)"The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand. This check catches errors where you have renamed an id without updating all of the references to it.", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(WrongIdDetector.class, Scope.ALL_RESOURCES_SCOPE, new EnumSet[]{Scope.RESOURCE_FILE_SCOPE}));
    public static final Issue NOT_SIBLING = Issue.create((String)"NotSibling", (String)"Invalid Constraints", (String)"Layout constraints in a given `ConstraintLayout` or `RelativeLayout` should reference other views within the same relative layout (but not itself!)", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue INVALID = Issue.create((String)"InvalidId", (String)"Invalid ID declaration", (String)"An id definition **must** be of the form `@+id/yourname`. The tools have not rejected strings of the form `@+foo/bar` in the past, but that was an error, and could lead to tricky errors because of the way the id integers are assigned.\n\nIf you really want to have different \"scopes\" for your id's, use prefixes instead, such as `login_button1` and `login_button2`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)IMPLEMENTATION);
    public static final Issue UNKNOWN_ID_LAYOUT = Issue.create((String)"UnknownIdInLayout", (String)"Reference to an id that is not in the current layout", (String)"The `@+id/` syntax refers to an existing id, or creates a new one if it has not already been defined elsewhere. However, this means that if you have a typo in your reference, or if the referred view no longer exists, you do not get a warning since the id will be created on demand.\n\nThis is sometimes intentional, for example where you are referring to a view which is provided in a different layout via an include. However, it is usually an accident where you have a typo or you have renamed a view without updating all the references to it.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.WARNING, (Implementation)new Implementation(WrongIdDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES;
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("id");
    }

    public Collection<String> getApplicableElements() {
        return ImmutableSet.of((Object)"RelativeLayout", (Object)"item", (Object)"android.support.percent.PercentRelativeLayout", (Object)SdkConstants.CLASS_CONSTRAINT_LAYOUT.oldName(), (Object)SdkConstants.CLASS_CONSTRAINT_LAYOUT.newName());
    }

    public void beforeCheckFile(Context context) {
        this.mFileIds = new HashSet<String>();
        this.mRelativeLayouts = null;
    }

    public void afterCheckFile(Context context) {
        if (this.mRelativeLayouts != null) {
            if (!context.getProject().getReportIssues()) {
                return;
            }
            for (Element layout : this.mRelativeLayouts) {
                this.checkLayout(context, layout);
            }
        }
        this.mFileIds = null;
        if (!context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context);
        }
    }

    private void checkLayout(Context context, Element layout) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)20);
        for (Element child : XmlUtils.getSubTags((Node)layout)) {
            String included;
            String id = child.getAttributeNS("http://schemas.android.com/apk/res/android", "id");
            if (id != null && !id.isEmpty()) {
                ids.add(id);
                continue;
            }
            if (!"include".equals(child.getTagName()) || WrongIdDetector.addIncludedIds(context, ids, included = child.getAttribute("layout"))) continue;
            this.mHandles = null;
            return;
        }
        boolean isConstraintLayout = SdkConstants.CLASS_CONSTRAINT_LAYOUT.isEquals(layout.getTagName());
        for (Element element : XmlUtils.getSubTags((Node)layout)) {
            String selfId = Lint.stripIdPrefix((String)element.getAttributeNS("http://schemas.android.com/apk/res/android", "id"));
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)attributes.item(i);
                String value = attr.getValue();
                if (value.startsWith("@+id/") || value.startsWith("@id/")) {
                    String localName = attr.getLocalName();
                    if (localName == null || !localName.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI()) && !"http://schemas.android.com/apk/res-auto".equals(attr.getNamespaceURI())) continue;
                    this.checkIdReference(context, layout, ids, isConstraintLayout, selfId, attr, value);
                    continue;
                }
                if (!isConstraintLayout || !"constraint_referenced_ids".equals(attr.getLocalName())) continue;
                Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
                for (String id : splitter.split((CharSequence)value)) {
                    this.checkIdReference(context, layout, ids, true, selfId, attr, id);
                }
            }
        }
    }

    private static boolean addIncludedIds(Context context, Set<String> ids, String included) {
        boolean full;
        Project project;
        if (included.isEmpty()) {
            return true;
        }
        LintClient client = context.getClient();
        ResourceRepository resources = client.getResources(project = (full = context.isGlobalAnalysis()) ? context.getMainProject() : context.getProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        List layouts = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, included);
        if (layouts.isEmpty()) {
            return false;
        }
        ResourceItem layout = (ResourceItem)layouts.get(0);
        PathString source = layout.getSource();
        if (source == null) {
            return false;
        }
        try {
            XmlPullParser parser = client.createXmlPullParser(source);
            if (parser != null) {
                WrongIdDetector.addIncludedIds(parser, ids);
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            // empty catch block
        }
        return true;
    }

    private static void addIncludedIds(XmlPullParser parser, Set<String> ids) throws XmlPullParserException, IOException {
        int depth = -1;
        while (true) {
            int event;
            if ((event = parser.next()) == 2) {
                String id;
                if (++depth == 0 && !"merge".equals(parser.getName())) {
                    id = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                    if (!id.isEmpty()) {
                        ids.add(id);
                    }
                    return;
                }
                if (depth != 1 || (id = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id")).isEmpty()) continue;
                ids.add(id);
                continue;
            }
            if (event == 3) {
                --depth;
                continue;
            }
            if (event == 1) break;
        }
    }

    private void checkIdReference(Context context, Element layout, Set<String> siblingIds, boolean isConstraintLayout, String selfId, Attr attr, String id) {
        String parentId;
        String message2;
        if (!WrongIdDetector.idDefined(this.mFileIds, id)) {
            XmlContext xmlContext = (XmlContext)context;
            Location.Handle handle = xmlContext.createLocationHandle((Node)attr);
            handle.setClientData((Object)attr);
            if (this.mHandles == null) {
                this.mHandles = new LinkedHashMap<String, Location.Handle>();
                this.mPendingNotSibling = new HashMap<String, String>();
            }
            this.mHandles.put(id, handle);
        }
        if (siblingIds.contains(id)) {
            if (!"id".equals(attr.getLocalName()) && !selfId.isEmpty() && id.endsWith(selfId) && Lint.stripIdPrefix((String)id).equals(selfId)) {
                message2 = String.format("Cannot be relative to self: id=%1$s, %2$s=%3$s", selfId, attr.getLocalName(), selfId);
                this.reportNotSiblingIfKnownId(context, id, attr, message2);
            }
            return;
        }
        if (id.startsWith("@+id/") ? siblingIds.contains("@id/" + Lint.stripIdPrefix((String)id)) : (id.startsWith("@id/") ? siblingIds.contains("@+id/" + Lint.stripIdPrefix((String)id)) : siblingIds.contains("@+id/" + id) || siblingIds.contains("@id/" + id))) {
            return;
        }
        if (isConstraintLayout && (parentId = Lint.stripIdPrefix((String)layout.getAttributeNS("http://schemas.android.com/apk/res/android", "id"))).equals(Lint.stripIdPrefix((String)id))) {
            return;
        }
        if (context.isEnabled(NOT_SIBLING)) {
            message2 = String.format("`%1$s` is not a sibling in the same `%2$s`", id, isConstraintLayout ? "ConstraintLayout" : "RelativeLayout");
            this.reportNotSiblingIfKnownId(context, id, attr, message2);
        }
    }

    public void afterCheckRootProject(Context context) {
        if (context.getScope().contains(Scope.ALL_RESOURCE_FILES)) {
            this.checkHandles(context);
        }
    }

    private void reportNotSiblingIfKnownId(Context context, String id, Node attr, String message2) {
        if (this.mHandles != null && this.mHandles.containsKey(id)) {
            this.mPendingNotSibling.put(id, message2);
        } else {
            XmlContext xmlContext = (XmlContext)context;
            Location location = xmlContext.getLocation(attr);
            xmlContext.report(NOT_SIBLING, attr, location, message2);
        }
    }

    private void checkHandles(Context context) {
        if (this.mHandles != null) {
            boolean checkSameLayout = context.isEnabled(UNKNOWN_ID_LAYOUT);
            boolean checkExists = context.isEnabled(UNKNOWN_ID);
            boolean projectScope = context.getScope().contains(Scope.ALL_RESOURCE_FILES);
            for (Map.Entry<String, Location.Handle> pair : this.mHandles.entrySet()) {
                String id = pair.getKey();
                Location.Handle handle = pair.getValue();
                boolean isBound = projectScope ? WrongIdDetector.idDefined(this.mGlobalIds, id) : this.idDefined(context, id, context.file);
                LintClient client = context.getClient();
                if (!isBound && checkExists) {
                    List<String> suggestions;
                    boolean isDeclared = WrongIdDetector.idDefined(this.mDeclaredIds, id);
                    id = Lint.stripIdPrefix((String)id);
                    HashSet spellingDictionary = this.createSpellingDictionary();
                    if (!projectScope) {
                        Project project = context.getProject();
                        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                        spellingDictionary = Sets.newHashSet((Iterable)resources.getResources(ResourceNamespace.TODO(), ResourceType.ID).keySet());
                        spellingDictionary.remove(id);
                    }
                    String suggestionMessage = (suggestions = WrongIdDetector.getSpellingSuggestions(id, spellingDictionary)).size() > 1 ? String.format(" Did you mean one of {%2$s} ?", id, Joiner.on((String)", ").join(suggestions)) : (!suggestions.isEmpty() ? String.format(" Did you mean %2$s ?", id, suggestions.get(0)) : "");
                    String message2 = isDeclared ? String.format("The id \"`%1$s`\" is defined but not assigned to any views.%2$s", id, suggestionMessage) : String.format("The id \"`%1$s`\" is not defined anywhere.%2$s", id, suggestionMessage);
                    WrongIdDetector.report(context, UNKNOWN_ID, handle, message2);
                    continue;
                }
                if (checkSameLayout && (!projectScope || isBound) && id.startsWith("@+id/")) {
                    WrongIdDetector.report(context, UNKNOWN_ID_LAYOUT, handle, String.format("The id \"`%1$s`\" is not referring to any views in this layout", Lint.stripIdPrefix((String)id)));
                    continue;
                }
                if (!this.mPendingNotSibling.containsKey(id)) continue;
                String message3 = this.mPendingNotSibling.get(id);
                context.report(NOT_SIBLING, handle.resolve(), message3);
            }
        }
    }

    private Set<String> createSpellingDictionary() {
        HashSet<String> dictionary = new HashSet<String>();
        this.mGlobalIds.stream().filter(id -> id.startsWith("@+id/")).forEach(id -> dictionary.add(Lint.stripIdPrefix((String)id)));
        if (this.mDeclaredIds != null) {
            this.mDeclaredIds.forEach(id -> dictionary.add(Lint.stripIdPrefix((String)id)));
        }
        return dictionary;
    }

    private static void report(Context context, Issue issue, Location.Handle handle, String message2) {
        Location location = handle.resolve();
        Object clientData = handle.getClientData();
        if (clientData instanceof Node && context.getDriver().isSuppressed(null, issue, (Node)clientData)) {
            return;
        }
        context.report(issue, location, message2);
    }

    public void visitElement(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if (tagName.equals("item")) {
            String name;
            String type = element.getAttribute("type");
            if ("id".equals(type) && !(name = element.getAttribute("name")).isEmpty()) {
                if (this.mDeclaredIds == null) {
                    this.mDeclaredIds = Sets.newHashSet();
                }
                this.mDeclaredIds.add("@+id/" + name);
                this.mGlobalIds.add("@+id/" + name);
            }
        } else {
            assert (tagName.equals("RelativeLayout") || tagName.equals("android.support.percent.PercentRelativeLayout") || SdkConstants.CLASS_CONSTRAINT_LAYOUT.isEquals(tagName));
            if (this.mRelativeLayouts == null) {
                this.mRelativeLayouts = new ArrayList<Element>();
            }
            this.mRelativeLayouts.add(element);
        }
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        assert (attribute.getName().equals("id") || attribute.getLocalName().equals("id"));
        String id = attribute.getValue();
        this.mFileIds.add(id);
        this.mGlobalIds.add(id);
        if (id.equals("@+id/") || id.equals("@id/")) {
            String message2 = "Invalid id: missing value";
            context.report(INVALID, (Node)attribute, context.getLocation((Node)attribute), message2);
        } else if (id.startsWith("@+") && !id.startsWith("@+id/") && !id.startsWith("@+android:id/") || id.startsWith("@+id/") && id.indexOf(47, "@+id/".length()) != -1) {
            int nameStart = id.startsWith("@+id/") ? "@+id/".length() : 2;
            String suggested = "@+id/" + id.substring(nameStart).replace('/', '_');
            String message3 = String.format("ID definitions **must** be of the form `@+id/name`; try using `%1$s`", suggested);
            context.report(INVALID, (Node)attribute, context.getLocation((Node)attribute), message3);
        }
    }

    private static boolean idDefined(Set<String> ids, String id) {
        if (ids == null) {
            return false;
        }
        boolean definedLocally = ids.contains(id);
        if (!definedLocally) {
            if (id.startsWith("@+id/")) {
                return ids.contains("@id/" + id.substring("@+id/".length()));
            }
            if (id.startsWith("@id/")) {
                return ids.contains("@+id/" + id.substring("@id/".length()));
            }
            return ids.contains("@+id/" + id);
        }
        return true;
    }

    private boolean idDefined(Context context, String id, File notIn) {
        LintClient client = context.getClient();
        Project project = context.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ID, Lint.stripIdPrefix((String)id));
        for (ResourceItem item : items) {
            PathString source = item.getSource();
            if (source == null) continue;
            String parentName = source.getParentFileName();
            if (parentName != null && parentName.startsWith("values")) {
                if (this.mDeclaredIds == null) {
                    this.mDeclaredIds = Sets.newHashSet();
                }
                this.mDeclaredIds.add(id);
                continue;
            }
            if (Lint.isSameResourceFile((File)source.toFile(), (File)notIn)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getSpellingSuggestions(String id, Collection<String> ids) {
        int maxDistance = id.length() >= 4 ? 2 : 1;
        ArrayListMultimap matches = ArrayListMultimap.create((int)2, (int)10);
        int count = 0;
        if (!ids.isEmpty()) {
            for (String matchWith : ids) {
                int distance = Lint.editDistance((String)id, (String)(matchWith = Lint.stripIdPrefix((String)matchWith)), (int)maxDistance);
                if (distance <= maxDistance) {
                    matches.put((Object)distance, (Object)matchWith);
                }
                if (count++ <= 100) continue;
                break;
            }
        }
        for (int i = 0; i < maxDistance; ++i) {
            Collection strings = matches.get((Object)i);
            if (strings == null || strings.isEmpty()) continue;
            ArrayList<String> suggestions = new ArrayList<String>(strings);
            Collections.sort(suggestions);
            return suggestions;
        }
        return Collections.emptyList();
    }
}

