/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0016\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/lint/checks/MotionSceneDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "customAttributeNames", "", "", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkMultipleOnClicks", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "checkNoSubTags", "getApplicableElements", "", "visitConstraint", "visitConstraintSet", "visitCustomAttribute", "visitElement", "visitKeyAttribute", "visitKeyCycle", "visitKeyFrameSet", "visitKeyPosition", "visitKeyTimeCycle", "visitKeyTrigger", "visitLayout", "visitMotion", "visitOnClick", "visitOnSwipe", "visitPropertySet", "visitState", "visitStateSet", "visitTransform", "visitTransition", "visitVariant", "Companion", "lint-checks"})
public final class MotionSceneDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> customAttributeNames;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MotionSceneDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue MOTION_SCENE_FILE_VALIDATION_ERROR = Issue.Companion.create("MotionSceneFileValidationError", "Validation errors in `MotionScene` files", "\n                A motion scene file specifies the animations used in a `MotionLayout`. \\\n                This check performs various serious correctness checks in a motion scene file.\n                ", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);

    public MotionSceneDetector() {
        boolean bl = false;
        this.customAttributeNames = new LinkedHashSet();
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"MotionScene");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (string == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case 269306229: {
                    if (string.equals("Transition")) {
                        n = 1;
                    }
                    break;
                }
                case -1349929691: {
                    if (string.equals("ConstraintSet")) {
                        n = 2;
                    }
                    break;
                }
                case 1382829617: {
                    if (string.equals("StateSet")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.visitConstraintSet(context, child);
                    break;
                }
                case 1: {
                    this.visitTransition(context, child);
                    break;
                }
                case 3: {
                    this.visitStateSet(context, child);
                }
            }
        }
    }

    private final void visitConstraintSet(XmlContext context, Element element) {
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (!Intrinsics.areEqual((Object)string, (Object)"Constraint")) continue;
            this.visitConstraint(context, child);
        }
    }

    private final void visitConstraint(XmlContext context, Element element) {
        this.customAttributeNames.clear();
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (string == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case -1984451626: {
                    if (string.equals("Motion")) {
                        n = 1;
                    }
                    break;
                }
                case -2025855158: {
                    if (string.equals("Layout")) {
                        n = 2;
                    }
                    break;
                }
                case 1791837707: {
                    if (string.equals("CustomAttribute")) {
                        n = 3;
                    }
                    break;
                }
                case -1269513683: {
                    if (string.equals("PropertySet")) {
                        n = 4;
                    }
                    break;
                }
                case -1238332596: {
                    if (string.equals("Transform")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.visitLayout(context, child);
                    break;
                }
                case 1: {
                    this.visitMotion(context, child);
                    break;
                }
                case 4: {
                    this.visitPropertySet(context, child);
                    break;
                }
                case 5: {
                    this.visitTransform(context, child);
                    break;
                }
                case 3: {
                    this.visitCustomAttribute(context, child);
                }
            }
        }
    }

    private final void visitLayout(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitMotion(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitPropertySet(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitTransform(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitCustomAttribute(XmlContext context, Element element) {
        String name = element.getAttributeNS("http://schemas.android.com/apk/res-auto", "attributeName");
        CharSequence charSequence = name;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            context.report(MOTION_SCENE_FILE_VALIDATION_ERROR, (Node)element, context.getNameLocation((Node)element), "`attributeName` should be defined", LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res-auto", (String)"attributeName", null, null, (int)12, null).build());
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
            if (!this.customAttributeNames.add(name)) {
                context.report(MOTION_SCENE_FILE_VALIDATION_ERROR, (Node)element, context.getNameLocation((Node)element), "The custom attribute `" + name + "` was specified multiple times", this.fix().name("Delete this custom attribute").replace().with("").range(context.getLocation((Node)element)).build());
            }
        }
    }

    private final void visitTransition(XmlContext context, Element element) {
        this.checkMultipleOnClicks(context, element);
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (string == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case 327855227: {
                    if (string.equals("OnSwipe")) {
                        n = 1;
                    }
                    break;
                }
                case -1239391468: {
                    if (string.equals("KeyFrameSet")) {
                        n = 2;
                    }
                    break;
                }
                case 312750793: {
                    if (string.equals("OnClick")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.visitKeyFrameSet(context, child);
                    break;
                }
                case 1: {
                    this.visitOnSwipe(context, child);
                    break;
                }
                case 3: {
                    this.visitOnClick(context, child);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMultipleOnClicks(XmlContext context, Element element) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = XmlUtils.getSubTags((Node)element);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"getSubTags(element)");
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element it = (Element)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTagName(), (Object)"OnClick")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element onClickElement = (Element)element$iv;
            boolean bl = false;
            Node node = onClickElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)onClickElement, (String)"onClickElement");
            context.report(MOTION_SCENE_FILE_VALIDATION_ERROR, node, context.getNameLocation((Node)onClickElement), "Can only have one `OnClick` per `Transition`", this.fix().name("Delete additional OnClick").replace().with("").range(context.getLocation((Node)onClickElement)).build());
        }
    }

    private final void visitKeyFrameSet(XmlContext context, Element element) {
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (string == null) continue;
            int n = -1;
            switch (string.hashCode()) {
                case 1153397896: {
                    if (string.equals("KeyPosition")) {
                        n = 1;
                    }
                    break;
                }
                case 540053991: {
                    if (string.equals("KeyCycle")) {
                        n = 2;
                    }
                    break;
                }
                case 1308496505: {
                    if (string.equals("KeyTrigger")) {
                        n = 3;
                    }
                    break;
                }
                case -298435811: {
                    if (string.equals("KeyAttribute")) {
                        n = 4;
                    }
                    break;
                }
                case -300573030: {
                    if (string.equals("KeyTimeCycle")) {
                        n = 5;
                    }
                    break;
                }
            }
            switch (n) {
                case 4: {
                    this.visitKeyAttribute(context, child);
                    break;
                }
                case 1: {
                    this.visitKeyPosition(context, child);
                    break;
                }
                case 2: {
                    this.visitKeyCycle(context, child);
                    break;
                }
                case 5: {
                    this.visitKeyTimeCycle(context, child);
                    break;
                }
                case 3: {
                    this.visitKeyTrigger(context, child);
                }
            }
        }
    }

    private final void visitKeyAttribute(XmlContext context, Element element) {
        this.customAttributeNames.clear();
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (!Intrinsics.areEqual((Object)string, (Object)"CustomAttribute")) continue;
            this.visitCustomAttribute(context, child);
        }
    }

    private final void visitKeyPosition(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitKeyCycle(XmlContext context, Element element) {
        this.customAttributeNames.clear();
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (!Intrinsics.areEqual((Object)string, (Object)"CustomAttribute")) continue;
            this.visitCustomAttribute(context, child);
        }
    }

    private final void visitKeyTimeCycle(XmlContext context, Element element) {
        this.customAttributeNames.clear();
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (!Intrinsics.areEqual((Object)string, (Object)"CustomAttribute")) continue;
            this.visitCustomAttribute(context, child);
        }
    }

    private final void visitKeyTrigger(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitOnSwipe(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitOnClick(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void visitStateSet(XmlContext context, Element element) {
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (!Intrinsics.areEqual((Object)string, (Object)"State")) continue;
            this.visitState(context, child);
        }
    }

    private final void visitState(XmlContext context, Element element) {
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String string = child.getTagName();
            if (!Intrinsics.areEqual((Object)string, (Object)"Variant")) continue;
            this.visitVariant(context, child);
        }
    }

    private final void visitVariant(XmlContext context, Element element) {
        this.checkNoSubTags(context, element);
    }

    private final void checkNoSubTags(XmlContext context, Element element) {
        Iterator iterator = DomExtensions.iterator((Element)element);
        while (iterator.hasNext()) {
            Element subTag = (Element)iterator.next();
            context.report(MOTION_SCENE_FILE_VALIDATION_ERROR, (Node)subTag, context.getNameLocation((Node)subTag), '`' + element.getTagName() + "` can not have any child tags", this.fix().name(Intrinsics.stringPlus((String)"Delete ", (Object)subTag.getTagName())).replace().with("").range(context.getLocation((Node)subTag)).build());
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/MotionSceneDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MOTION_SCENE_FILE_VALIDATION_ERROR", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

