/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/HighSensorSamplingRateDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "lint-checks"})
public final class HighSensorSamplingRateDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String HIGHER_SENSOR_SAMPLING_RATE = "android.permission.HIGH_SAMPLING_RATE_SENSORS";
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("HighSamplingRate", "High sensor sampling rate", "\n                Most apps don't need access to high sensor sampling rate. Double check your use \\\n                case to ensure your app absolutely needs access to sensor sampling rate > 200Hz. \\\n                Be prepared for your app to be rejected from listing on Play Store until your use \\\n                case for high sensor sampling rate has been reviewed and validated by the policy \\\n                team.\n            ", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(HighSensorSamplingRateDetector.class, Scope.MANIFEST_SCOPE));

    @NotNull
    public Set<String> getApplicableElements() {
        return SetsKt.setOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (!Intrinsics.areEqual((Object)name, (Object)HIGHER_SENSOR_SAMPLING_RATE)) {
            return;
        }
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"element.getAttributeNodeNS(ANDROID_URI, ATTR_NAME)");
        context.report(new Incident(ISSUE, context.getValueLocation(attr), "Most apps don't need access to high sensor sampling rate."), Constraints.targetSdkAtLeast((int)31));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/HighSensorSamplingRateDetector$Companion;", "", "()V", "HIGHER_SENSOR_SAMPLING_RATE", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

