/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/LayoutInflationDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "layoutsWithRootLayoutParams", "", "", "pendingErrors", "", "Lcom/android/utils/Pair;", "Lcom/android/tools/lint/detector/api/Location;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableMethodNames", "", "hasLayoutParams", "", "Lcom/android/tools/lint/detector/api/JavaContext;", "name", "visitDocument", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public final class LayoutInflationDetector
extends LayoutDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Set<String> layoutsWithRootLayoutParams;
    @Nullable
    private List<Pair<String, Location>> pendingErrors;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String ERROR_MESSAGE = "Avoid passing `null` as the view root (needed to resolve layout parameters on the inflated layout's root element)";

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<Pair<String, Location>> list = this.pendingErrors;
        if (list == null) {
            return;
        }
        List<Pair<String, Location>> pendingErrors = list;
        for (Pair pair : pendingErrors) {
            Location location;
            String inflatedLayout = (String)pair.getFirst();
            if (this.layoutsWithRootLayoutParams == null) continue;
            Set<String> set = this.layoutsWithRootLayoutParams;
            Intrinsics.checkNotNull(set);
            if (!CollectionsKt.contains((Iterable)set, (Object)inflatedLayout) || (location = (Location)pair.getSecond()) == null) continue;
            Location location2 = location;
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location2, (String)ERROR_MESSAGE, null, (int)8, null);
        }
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element root = document.getDocumentElement();
        if (root != null) {
            NamedNodeMap attributes = root.getAttributes();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Object object = attributes.item(i);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Attr");
                }
                Attr attribute = (Attr)object;
                if (attribute.getLocalName() != null) {
                    object = attribute.getLocalName();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attribute.localName");
                    if (StringsKt.startsWith$default((String)object, (String)"layout_", (boolean)false, (int)2, null)) {
                        Set set;
                        Object object2 = this.layoutsWithRootLayoutParams;
                        if (object2 == null) {
                            LayoutInflationDetector layoutInflationDetector = this;
                            boolean bl = false;
                            boolean bl2 = false;
                            LayoutInflationDetector $this$visitDocument_u24lambda_u2d0 = layoutInflationDetector;
                            boolean bl3 = false;
                            HashSet hashSet = new HashSet(20);
                            $this$visitDocument_u24lambda_u2d0.layoutsWithRootLayoutParams = hashSet;
                            set = hashSet;
                        } else {
                            set = object2;
                        }
                        Set layouts = set;
                        object2 = context.file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"context.file.name");
                        layouts.add((String)Lint.getBaseName((String)object2));
                        break;
                    }
                }
                int n2 = i;
                i = n2 + 1;
            }
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"inflate");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        UExpression uExpression = node.getReceiver();
        if (uExpression == null) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() < 2) {
            return;
        }
        UExpression second = (UExpression)arguments.get(1);
        if (!UastLiteralUtils.isNullLiteral((UElement)((UElement)second))) {
            return;
        }
        UExpression first = (UExpression)arguments.get(0);
        ResourceReference resourceReference = ResourceReference.Companion.get((UElement)first);
        if (resourceReference == null) {
            return;
        }
        ResourceReference reference = resourceReference;
        if (LayoutInflationDetector.Companion.isUsedWithAlertDialog(context, node)) {
            return;
        }
        String layoutName = reference.getName();
        if (context.getScope().contains(Scope.RESOURCE_FILE)) {
            if (!context.getDriver().isSuppressed(context, ISSUE, (UAnnotated)node)) {
                List list;
                LayoutInflationDetector layoutInflationDetector;
                List list2 = this.pendingErrors;
                if (list2 == null) {
                    layoutInflationDetector = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    LayoutInflationDetector $this$visitMethodCall_u24lambda_u2d1 = layoutInflationDetector;
                    boolean bl3 = false;
                    ArrayList arrayList = new ArrayList();
                    $this$visitMethodCall_u24lambda_u2d1.pendingErrors = arrayList;
                    list = arrayList;
                } else {
                    list = list2;
                }
                List pending = list;
                Location location = context.getLocation((UElement)second);
                layoutInflationDetector = Pair.of((Object)layoutName, (Object)location);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)layoutInflationDetector), (String)"of(layoutName, location)");
                pending.add((Pair<String, Location>)layoutInflationDetector);
            }
        } else if (this.hasLayoutParams(context, layoutName)) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)second), (String)ERROR_MESSAGE, null, (int)16, null);
        }
    }

    private final boolean hasLayoutParams(JavaContext context, String name) {
        LintClient client = context.getClient();
        if (!context.isGlobalAnalysis()) {
            return true;
        }
        Project project = context.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, name);
        if (items.isEmpty()) {
            return true;
        }
        for (ResourceItem item : items) {
            PathString pathString = item.getSource();
            if (pathString == null) {
                return true;
            }
            PathString source = pathString;
            try {
                XmlPullParser parser = client.createXmlPullParser(source);
                if (parser == null || !Companion.hasLayoutParams(parser)) continue;
                return true;
            }
            catch (XmlPullParserException e) {
                context.log((Throwable)e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
            catch (IOException e) {
                context.log((Throwable)e, "Could not read/parse inflated layout", new Object[0]);
                return true;
            }
        }
        return false;
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean hasLayoutParams(@NotNull XmlPullParser parser) throws XmlPullParserException, IOException {
        return Companion.hasLayoutParams(parser);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(LayoutInflationDetector.class, Scope.JAVA_AND_RESOURCE_FILES, enumSetArray);
        enumSetArray = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"InflateParams", (String)"Layout Inflation without a Parent", (String)"\n                    When inflating a layout, avoid passing in null as the parent view, since \\\n                    otherwise any layout parameters on the root of the inflated layout will be \\\n                    ignored.", (Implementation)implementation, (String)"https://www.bignerdranch.com/blog/understanding-androids-layoutinflater-inflate/", (Category)enumSetArray, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/LayoutInflationDetector$Companion;", "", "()V", "ERROR_MESSAGE", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "hasLayoutParams", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "isAlertBuilder", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "cls", "Lcom/intellij/psi/PsiClass;", "s", "isUsedWithAlertDialog", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUsedWithAlertDialog(JavaContext context, UCallExpression call) {
            UElement uElement = UastUtils.getParentOfType$default((UElement)((UElement)call), UVariable.class, (boolean)false, (int)2, null);
            if (uElement == null) {
                return false;
            }
            UElement variable = uElement;
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)variable, UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return false;
            }
            UMethod method = uMethod;
            PsiElement sourcePsi = variable.getSourcePsi();
            PsiElement javaPsi = variable.getJavaPsi();
            Ref isAlertBuilderUsage = new Ref((Object)false);
            method.accept((UastVisitor)new AbstractUastVisitor(sourcePsi, javaPsi, (Ref<Boolean>)isAlertBuilderUsage, context){
                final /* synthetic */ PsiElement $sourcePsi;
                final /* synthetic */ PsiElement $javaPsi;
                final /* synthetic */ Ref<Boolean> $isAlertBuilderUsage;
                final /* synthetic */ JavaContext $context;
                {
                    this.$sourcePsi = $sourcePsi;
                    this.$javaPsi = $javaPsi;
                    this.$isAlertBuilderUsage = $isAlertBuilderUsage;
                    this.$context = $context;
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    this.checkUsage(node);
                    return super.visitSimpleNameReferenceExpression(node);
                }

                private final void checkUsage(USimpleNameReferenceExpression node) {
                    UCallExpression uCallExpression;
                    PsiElement psiElement = node.resolve();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement resolved = psiElement;
                    if (!Intrinsics.areEqual((Object)resolved, (Object)this.$sourcePsi) && !Intrinsics.areEqual((Object)resolved, (Object)this.$javaPsi)) {
                        return;
                    }
                    UElement uElement = node.getUastParent();
                    UCallExpression uCallExpression2 = uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
                    if (uCallExpression == null) {
                        return;
                    }
                    UCallExpression setViewCall = uCallExpression;
                    if (!Intrinsics.areEqual((Object)"setView", (Object)setViewCall.getMethodName())) {
                        return;
                    }
                    uElement = setViewCall.getReceiver();
                    if (uElement == null) {
                        return;
                    }
                    UElement receiver = uElement;
                    Object object = receiver.getExpressionType();
                    if (object == null) {
                        return;
                    }
                    PsiType psiType = object;
                    object = psiType.getCanonicalText();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"psiType.canonicalText");
                    if (com.android.tools.lint.checks.LayoutInflationDetector$Companion.access$isAlertBuilder(LayoutInflationDetector.Companion, (String)object)) {
                        this.$isAlertBuilderUsage.set((Object)true);
                    } else {
                        JavaEvaluator evaluator = this.$context.getEvaluator();
                        PsiMethod[] psiMethodArray = evaluator.getTypeClass(psiType);
                        if (psiMethodArray == null) {
                            return;
                        }
                        PsiMethod[] typeClass = psiMethodArray;
                        PsiMethod[] psiMethodArray2 = typeClass.getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"typeClass.methods");
                        for (PsiMethod m : psiMethodArray2) {
                            PsiType returnClass;
                            PsiType psiType2;
                            PsiType returnType;
                            PsiType psiType3 = m.getReturnType();
                            if (psiType3 == null || (returnType = (psiType2 = psiType3)) instanceof PsiPrimitiveType || (psiType3 = evaluator.getTypeClass(returnType)) == null || (returnClass = psiType3) == typeClass || !com.android.tools.lint.checks.LayoutInflationDetector$Companion.access$isAlertBuilder(LayoutInflationDetector.Companion, evaluator, (PsiClass)returnClass)) continue;
                            this.$isAlertBuilderUsage.set((Object)true);
                            break;
                        }
                    }
                }
            });
            Object object = isAlertBuilderUsage.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"isAlertBuilderUsage.get()");
            return (Boolean)object;
        }

        private final boolean isAlertBuilder(String s) {
            boolean bl;
            switch (s) {
                case "android.app.AlertDialog.Builder": 
                case "androidx.appcompat.app.AlertDialog.Builder": 
                case "com.google.android.material.dialog.MaterialAlertDialogBuilder": 
                case "android.support.v7.app.AlertDialog.Builder": {
                    bl = true;
                    break;
                }
                default: {
                    bl = StringsKt.contains$default((CharSequence)s, (CharSequence)"AlertDialog", (boolean)false, (int)2, null);
                }
            }
            return bl;
        }

        private final boolean isAlertBuilder(JavaEvaluator evaluator, PsiClass cls) {
            return !evaluator.inheritsFrom(cls, "android.app.Dialog", true) ? false : evaluator.inheritsFrom(cls, "android.app.AlertDialog", false) || evaluator.inheritsFrom(cls, "android.support.v7.app.AlertDialog", false) || evaluator.inheritsFrom(cls, "androidx.appcompat.app.AlertDialog", false);
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean hasLayoutParams(@NotNull XmlPullParser parser) throws XmlPullParserException, IOException {
            int event;
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            do {
                if ((event = parser.next()) != 2) continue;
                int n = 0;
                int n2 = parser.getAttributeCount();
                if (n < n2) {
                    do {
                        String prefix;
                        int i = n++;
                        String string = parser.getAttributeName(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.getAttributeName(i)");
                        if (!StringsKt.startsWith$default((String)string, (String)"layout_", (boolean)false, (int)2, null) || (prefix = parser.getAttributePrefix(i)) == null) continue;
                        CharSequence charSequence = prefix;
                        boolean bl = false;
                        if (charSequence.length() == 0 || !Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)parser.getNamespace(prefix))) continue;
                        return true;
                    } while (n < n2);
                }
                return false;
            } while (event != 1 && event != 3);
            return false;
        }

        public static final /* synthetic */ boolean access$isAlertBuilder(Companion $this, String s) {
            return $this.isAlertBuilder(s);
        }

        public static final /* synthetic */ boolean access$isAlertBuilder(Companion $this, JavaEvaluator evaluator, PsiClass cls) {
            return $this.isAlertBuilder(evaluator, cls);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

