/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.Interpreter;

public class ControlFlowGraph {
    private Map<AbstractInsnNode, Node> mNodeMap;
    private MethodNode mMethod;

    public static ControlFlowGraph create(ControlFlowGraph initial, ClassNode classNode, MethodNode method) throws AnalyzerException {
        final ControlFlowGraph graph = initial != null ? initial : new ControlFlowGraph();
        final InsnList instructions = method.instructions;
        graph.mNodeMap = Maps.newHashMapWithExpectedSize((int)instructions.size());
        graph.mMethod = method;
        Analyzer analyzer2 = new Analyzer((Interpreter)new BasicInterpreter()){

            protected void newControlFlowEdge(int insn, int successor) {
                AbstractInsnNode from = instructions.get(insn);
                AbstractInsnNode to = instructions.get(successor);
                graph.add(from, to);
            }

            protected boolean newControlFlowExceptionEdge(int insn, TryCatchBlockNode tcb) {
                AbstractInsnNode from = instructions.get(insn);
                graph.exception(from, tcb);
                return super.newControlFlowExceptionEdge(insn, tcb);
            }

            protected boolean newControlFlowExceptionEdge(int insn, int successor) {
                AbstractInsnNode from = instructions.get(insn);
                AbstractInsnNode to = instructions.get(successor);
                graph.exception(from, to);
                return super.newControlFlowExceptionEdge(insn, successor);
            }
        };
        analyzer2.analyze(classNode.name, method);
        return graph;
    }

    protected void add(AbstractInsnNode from, AbstractInsnNode to) {
        this.getNode(from).addSuccessor(this.getNode(to));
    }

    protected void exception(AbstractInsnNode from, AbstractInsnNode to) {
    }

    protected void exception(AbstractInsnNode from, TryCatchBlockNode tcb) {
        LabelNode start = tcb.start;
        LabelNode end = tcb.end;
        Node handlerNode = this.getNode((AbstractInsnNode)tcb.handler);
        for (LabelNode curr = start; curr != end && curr != null; curr = curr.getNext()) {
            if (curr.getType() != 5 && (curr.getType() != 0 || curr.getOpcode() != 191)) continue;
            if (tcb.type == null) {
                this.getNode((AbstractInsnNode)curr).addSuccessor(handlerNode);
            }
            this.getNode((AbstractInsnNode)curr).addExceptionPath(handlerNode);
        }
    }

    public Node getNode(AbstractInsnNode instruction) {
        Node node = this.mNodeMap.get(instruction);
        if (node == null) {
            node = new Node(instruction);
            this.mNodeMap.put(instruction, node);
        }
        return node;
    }

    public static class Node {
        public final AbstractInsnNode instruction;
        public final List<Node> successors = new ArrayList<Node>(2);
        public final List<Node> exceptions = new ArrayList<Node>(1);
        public int visit;

        public Node(AbstractInsnNode instruction) {
            this.instruction = instruction;
        }

        void addSuccessor(Node node) {
            if (!this.successors.contains(node)) {
                this.successors.add(node);
            }
        }

        void addExceptionPath(Node node) {
            if (!this.exceptions.contains(node)) {
                this.exceptions.add(node);
            }
        }
    }
}

