/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u00012\u00020\u0002:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/LeanbackWifiUsageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "checkMergedProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "Companion", "lint-checks"})
public final class LeanbackWifiUsageDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LEANBACK_ATTR_NAME = "android.software.leanback";
    @NotNull
    private static final String WIFI_FEATURE_NAME = "android.hardware.wifi";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public void checkMergedProject(@NotNull Context context) {
        boolean wifiFeatureNodeRequired;
        boolean bl;
        Element element;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Element wifiFeatureNode = null;
        Document document = context.getMainProject().getMergedManifest();
        Element element2 = element = document == null ? null : document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element document2 = element;
        Element wifiPermissionsNode = null;
        boolean hasLeanBack = false;
        Iterator iterator = DomExtensions.iterator((Element)document2);
        while (iterator.hasNext()) {
            String name;
            Element element3 = (Element)iterator.next();
            String string = element3.getTagName();
            if (Intrinsics.areEqual((Object)string, (Object)"uses-feature")) {
                name = element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (Intrinsics.areEqual((Object)name, (Object)LEANBACK_ATTR_NAME)) {
                    hasLeanBack = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)WIFI_FEATURE_NAME)) continue;
                wifiFeatureNode = element3;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"uses-permission")) continue;
            name = element3.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if (!LeanbackWifiUsageDetector.Companion.isWifiStatePermission(name)) continue;
            wifiPermissionsNode = element3;
        }
        if (!hasLeanBack) {
            return;
        }
        Element element4 = wifiFeatureNode;
        if (element4 == null) {
            bl = false;
        } else {
            boolean bl2;
            Element element5 = element4;
            boolean bl3 = false;
            boolean bl4 = false;
            Element wifiNode = element5;
            boolean bl5 = false;
            bl = wifiFeatureNodeRequired = (bl2 = !Intrinsics.areEqual((Object)wifiNode.getAttributeNS("http://schemas.android.com/apk/res/android", "required"), (Object)"false"));
        }
        if (wifiFeatureNode != null) {
            if (wifiFeatureNodeRequired) {
                Context.report$default((Context)context, (Issue)ISSUE, (Location)Context.getLocation$default((Context)context, (Object)wifiFeatureNode, null, (int)2, null), (String)"Requiring `android.hardware.wifi` limits app availability on TVs that support only Ethernet", null, (int)8, null);
            }
        } else if (wifiPermissionsNode != null) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)Context.getLocation$default((Context)context, wifiPermissionsNode, null, (int)2, null), (String)"Requiring Wifi permissions limits app availability on TVs that support only Ethernet", null, (int)8, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(LeanbackWifiUsageDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"LeanbackUsesWifi", (String)"Using android.hardware.wifi on TV", (String)"\n                WiFi is not required for Android TV and many devices connect to the internet via \\\n                alternative methods e.g. Ethernet.\n\n                If your app is not focused specifically on WiFi functionality and only wishes to \\\n                connect to the internet, please modify your Manifest to contain: \\\n                `<uses-feature android:name=\"android.hardware.wifi\" android:required=\"false\" />`\n\n                Un-metered or non-roaming connections can be detected in software using\n                `NetworkCapabilities#NET_CAPABILITY_NOT_METERED` and \\\n                `NetworkCapabilities#NET_CAPABILITY_NOT_ROAMING.`\n                ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/LeanbackWifiUsageDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "LEANBACK_ATTR_NAME", "", "WIFI_FEATURE_NAME", "isWifiStatePermission", "", "s", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isWifiStatePermission(String s) {
            boolean bl;
            switch (s) {
                case "android.permission.CHANGE_WIFI_STATE": 
                case "android.permission.CHANGE_WIFI_MULTICAST_STATE": 
                case "android.permission.ACCESS_WIFI_STATE": {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

