/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.SecurityDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0016\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/checks/PreferenceActivityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "findManifestElement", "Lorg/w3c/dom/Element;", "Lcom/android/tools/lint/detector/api/JavaContext;", "className", "getApplicableElements", "", "overridesIsValidFragment", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "resolvedClass", "Lcom/intellij/psi/PsiClass;", "visitClass", "", "declaration", "Lorg/jetbrains/uast/UClass;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Companion", "lint-checks"})
public final class PreferenceActivityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String PREFERENCE_ACTIVITY = "android.preference.PreferenceActivity";
    @NotNull
    private static final String IS_VALID_FRAGMENT = "isValidFragment";
    @NotNull
    private static final String KEY_OVERRIDES = "overrides";
    @NotNull
    private static final String KEY_IMPLICIT = "implicit";

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"activity");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        boolean implicitlyExportedPreS;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Boolean explicitlyDecided = SecurityDetector.getExplicitExported(element);
        boolean bl = implicitlyExportedPreS = explicitlyDecided == null && SecurityDetector.isImplicitlyExportedPreS(element);
        if (implicitlyExportedPreS || Intrinsics.areEqual((Object)explicitlyDecided, (Object)true)) {
            String className = Lint.resolveManifestName((Element)element);
            if (Intrinsics.areEqual((Object)className, (Object)PREFERENCE_ACTIVITY)) {
                String message2 = "`PreferenceActivity` should not be exported";
                Incident incident = new Incident(ISSUE, (Object)element, context.getLocation((Node)element), message2);
                if (implicitlyExportedPreS) {
                    context.report(incident, Constraints.targetSdkLessThan((int)31));
                } else {
                    context.report(incident);
                }
            } else {
                UastParser parser = context.getClient().getUastParser(context.getProject());
                JavaEvaluator evaluator = parser.getEvaluator();
                PsiClass declaration = evaluator.findClass(StringsKt.replace$default((String)className, (char)'$', (char)'.', (boolean)false, (int)4, null));
                if (declaration != null && evaluator.extendsClass(declaration, PREFERENCE_ACTIVITY, true)) {
                    boolean overrides = this.overridesIsValidFragment(evaluator, declaration);
                    String message3 = "`PreferenceActivity` subclass " + className + " should not be exported";
                    Location location = context.getLocation((Node)element);
                    if (context.getDriver().isIsolated()) {
                        location.setSecondary(Context.getLocation$default((Context)((Context)context), (Object)declaration, null, (int)2, null));
                    }
                    Incident incident = new Incident(ISSUE, (Object)declaration, location, message3);
                    context.report(incident, this.map().put(KEY_OVERRIDES, overrides).put(KEY_IMPLICIT, implicitlyExportedPreS));
                }
            }
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() < 19) {
            return true;
        }
        if (Intrinsics.areEqual((Object)map.getBoolean(KEY_IMPLICIT, Boolean.valueOf(false)), (Object)true) && context.getMainProject().getTargetSdk() >= 31) {
            return true;
        }
        return Intrinsics.areEqual((Object)map.getBoolean(KEY_OVERRIDES, Boolean.valueOf(false)), (Object)false);
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)PREFERENCE_ACTIVITY);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        boolean implicitlyExportedPreS;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!context.getProject().getReportIssues() || !context.getDriver().isIsolated()) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.extendsClass((PsiClass)declaration, PREFERENCE_ACTIVITY, false)) {
            return;
        }
        String string = declaration.getQualifiedName();
        if (string == null) {
            return;
        }
        String className = string;
        Element element = this.findManifestElement(context, className);
        if (element == null) {
            return;
        }
        Element element2 = element;
        Boolean explicitlyDecided = SecurityDetector.getExplicitExported(element2);
        boolean bl = implicitlyExportedPreS = explicitlyDecided == null && SecurityDetector.isImplicitlyExportedPreS(element2);
        if (implicitlyExportedPreS || Intrinsics.areEqual((Object)explicitlyDecided, (Object)true)) {
            boolean overrides = this.overridesIsValidFragment(evaluator, (PsiClass)declaration);
            String message2 = "`PreferenceActivity` subclass " + className + " should not be exported in the manifest";
            Location location = context.getNameLocation(declaration);
            Incident incident = new Incident(ISSUE, (Object)declaration, location, message2);
            context.report(incident, this.map().put(KEY_OVERRIDES, overrides).put(KEY_IMPLICIT, implicitlyExportedPreS));
        }
    }

    private final Element findManifestElement(JavaContext context, String className) {
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        Document document = project.getMergedManifest();
        if (document == null) {
            return null;
        }
        Document mergedManifest = document;
        Element element = mergedManifest.getDocumentElement();
        if (element == null) {
            return null;
        }
        Element manifest = element;
        Object object = DomExtensions.subtag((Element)manifest, (String)"application");
        if (object == null) {
            return null;
        }
        Element application = object;
        Iterator iterator = DomExtensions.subtags((Element)application, (String)"activity");
        boolean bl = false;
        object = iterator;
        while (object.hasNext()) {
            String fqn;
            Element element2 = (Element)object.next();
            String name = element2.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if (!StringsKt.endsWith$default((String)className, (String)name, (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)(fqn = Lint.resolveManifestName((Element)element2)), (Object)className)) continue;
            return element2;
        }
        return null;
    }

    private final boolean overridesIsValidFragment(JavaEvaluator evaluator, PsiClass resolvedClass) {
        PsiMethod[] psiMethodArray = resolvedClass.findMethodsByName(IS_VALID_FRAGMENT, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"resolvedClass.findMethod\u2026IS_VALID_FRAGMENT, false)");
        for (PsiMethod method : psiMethodArray) {
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            String[] stringArray = new String[]{"java.lang.String"};
            if (!evaluator.parametersMatch(method, stringArray)) continue;
            return true;
        }
        return false;
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(PreferenceActivityDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"ExportedPreferenceActivity", (String)"PreferenceActivity should not be exported", (String)"\n                Fragment injection gives anyone who can send your `PreferenceActivity` an intent \\\n                the ability to load any fragment, with any arguments, in your process.", (Implementation)implementation, (String)"http://securityintelligence.com/new-vulnerability-android-framework-fragment-injection", (Category)category, (int)8, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/PreferenceActivityDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "IS_VALID_FRAGMENT", "", "KEY_IMPLICIT", "KEY_OVERRIDES", "PREFERENCE_ACTIVITY", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

