/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.IntRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.checks.RangeDetector;
import com.android.tools.lint.checks.SizeConstraint;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/RangeDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkFloatRange", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "checkIntRange", "checkSize", "visitAnnotationUsage", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "Companion", "lint-checks"})
public final class RangeDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RangeDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String AOSP_INT_RANGE_ANNOTATION = "android.annotation.IntRange";
    @JvmField
    @NotNull
    public static final Issue RANGE = Issue.Companion.create("Range", "Outside Range", "\n                Some parameters are required to in a particular numerical range; this check \\\n                makes sure that arguments passed fall within the range. For arrays, Strings \\\n                and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName(), AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName(), AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.oldName(), AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.newName(), AnnotationDetectorKt.SIZE_ANNOTATION.oldName(), AnnotationDetectorKt.SIZE_ANNOTATION.newName(), SdkConstants.INT_DEF_ANNOTATION.oldName(), SdkConstants.INT_DEF_ANNOTATION.newName(), SdkConstants.LONG_DEF_ANNOTATION.oldName(), SdkConstants.LONG_DEF_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        String string = annotationInfo.getQualifiedName();
        if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName())) {
            this.checkIntRange(context, annotation, element, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.FLOAT_RANGE_ANNOTATION.newName())) {
            this.checkFloatRange(context, annotation, element, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.SIZE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.SIZE_ANNOTATION.newName())) {
            this.checkSize(context, annotation, element, usageInfo);
        } else if (((Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)SdkConstants.INT_DEF_ANNOTATION.newName())) ? true : Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.oldName())) ? true : Intrinsics.areEqual((Object)string, (Object)SdkConstants.LONG_DEF_ANNOTATION.newName())) {
            // empty if block
        }
    }

    private final void checkIntRange(JavaContext context, UAnnotation annotation, UElement argument, AnnotationUsageInfo usageInfo) {
        if (argument instanceof UIfExpression) {
            boolean bl;
            boolean bl2;
            UExpression uExpression;
            UExpression uExpression2 = ((UIfExpression)argument).getThenExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                bl2 = false;
                bl = false;
                UExpression thenExpression = uExpression;
                boolean bl3 = false;
                this.checkIntRange(context, annotation, (UElement)thenExpression, usageInfo);
            }
            uExpression2 = ((UIfExpression)argument).getElseExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                bl2 = false;
                bl = false;
                UExpression elseExpression = uExpression;
                boolean bl4 = false;
                this.checkIntRange(context, annotation, (UElement)elseExpression, usageInfo);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkIntRange(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression(), usageInfo);
            return;
        }
        String message2 = Companion.getIntRangeError(context, annotation, argument, usageInfo);
        if (message2 != null) {
            if (usageInfo.anySameScope((Function1)checkIntRange.3.INSTANCE)) {
                return;
            }
            this.report(context, RANGE, argument, context.getLocation(argument), message2);
        }
    }

    private final void checkFloatRange(JavaContext context, UAnnotation annotation, UElement argument, AnnotationUsageInfo usageInfo) {
        if (argument instanceof UIfExpression) {
            boolean bl;
            UExpression uExpression;
            UExpression uExpression2 = ((UIfExpression)argument).getThenExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                boolean bl2 = false;
                bl = false;
                UExpression thenExpression = uExpression;
                boolean bl3 = false;
                this.checkFloatRange(context, annotation, (UElement)thenExpression, usageInfo);
            }
            uExpression2 = ((UIfExpression)argument).getElseExpression();
            if (uExpression2 != null) {
                uExpression = uExpression2;
                boolean bl2 = false;
                bl = false;
                UExpression elseExpression = uExpression;
                boolean bl4 = false;
                this.checkFloatRange(context, annotation, (UElement)elseExpression, usageInfo);
            }
            return;
        }
        if (argument instanceof UParenthesizedExpression) {
            this.checkFloatRange(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression(), usageInfo);
            return;
        }
        if (UastExpressionUtils.isNewArrayWithDimensions((UElement)argument)) {
            return;
        }
        FloatRangeConstraint constraint2 = FloatRangeConstraint.Companion.create(annotation);
        Object constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
        if (!(constant instanceof Number)) {
            RangeConstraint here;
            String error;
            RangeConstraint rangeConstraint;
            if (constant instanceof float[] || constant instanceof double[] || constant instanceof int[] || constant instanceof long[]) {
                if (constant instanceof float[]) {
                    for (float value : (float[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String message2 = constraint2.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message2);
                        return;
                    }
                }
                if (constant instanceof double[]) {
                    for (double value : (double[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String message3 = constraint2.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message3);
                        return;
                    }
                }
                if (constant instanceof int[]) {
                    for (int value : (int[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String message4 = constraint2.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message4);
                        return;
                    }
                }
                if (constant instanceof long[]) {
                    for (long value : (long[])constant) {
                        if (constraint2.isValid(value)) continue;
                        String message5 = constraint2.describe(value);
                        this.report(context, RANGE, argument, context.getLocation(argument), message5);
                        return;
                    }
                }
            }
            if (argument instanceof UResolvable && (rangeConstraint = RangeDetector.Companion.getRangeConstraint(context, (UResolvable)argument)) != null && (error = RangeDetector.Companion.getNonOverlapMessage(here = RangeConstraint.Companion.create(annotation), rangeConstraint, argument, usageInfo)) != null) {
                this.report(context, RANGE, argument, context.getLocation(argument), error);
            }
            return;
        }
        double d = ((Number)constant).doubleValue();
        if (!constraint2.isValid(d)) {
            String message6 = FloatRangeConstraint.describe$default(constraint2, argument instanceof UExpression ? (UExpression)argument : null, d, null, 4, null);
            this.report(context, RANGE, argument, context.getLocation(argument), message6);
        }
    }

    private final void checkSize(JavaContext context, UAnnotation annotation, UElement argument, AnnotationUsageInfo usageInfo) {
        long actual = 0L;
        boolean isString = false;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            actual = ((UCallExpression)argument).getValueArgumentCount();
        } else {
            if (argument instanceof UIfExpression) {
                boolean bl;
                boolean bl2;
                UExpression uExpression;
                UExpression uExpression2 = ((UIfExpression)argument).getThenExpression();
                if (uExpression2 != null) {
                    uExpression = uExpression2;
                    bl2 = false;
                    bl = false;
                    UExpression thenExpression = uExpression;
                    boolean bl3 = false;
                    this.checkSize(context, annotation, (UElement)thenExpression, usageInfo);
                }
                uExpression2 = ((UIfExpression)argument).getElseExpression();
                if (uExpression2 != null) {
                    uExpression = uExpression2;
                    bl2 = false;
                    bl = false;
                    UExpression elseExpression = uExpression;
                    boolean bl4 = false;
                    this.checkSize(context, annotation, (UElement)elseExpression, usageInfo);
                }
                return;
            }
            if (argument instanceof UParenthesizedExpression) {
                this.checkSize(context, annotation, (UElement)((UParenthesizedExpression)argument).getExpression(), usageInfo);
                return;
            }
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (object instanceof String) {
                actual = ((String)object).length();
                isString = true;
            } else {
                actual = ConstantEvaluator.getArraySize((Object)object);
                if (actual == -1L) {
                    RangeConstraint here;
                    String error;
                    RangeConstraint constraint2;
                    if (argument instanceof UResolvable && (constraint2 = RangeDetector.Companion.getRangeConstraint(context, (UResolvable)argument)) != null && (error = RangeDetector.Companion.getNonOverlapMessage(here = RangeConstraint.Companion.create(annotation), constraint2, argument, usageInfo)) != null) {
                        this.report(context, RANGE, argument, context.getLocation(argument), error);
                    }
                    return;
                }
            }
        }
        SizeConstraint constraint3 = SizeConstraint.Companion.create(annotation);
        if (!constraint3.isValid(actual)) {
            String unit = isString ? "length" : "size";
            String message2 = SizeConstraint.describe$default(constraint3, argument instanceof UExpression ? (UExpression)argument : null, unit, actual, false, 8, null);
            this.report(context, RANGE, argument, context.getLocation(argument), message2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J&\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/lint/checks/RangeDetector$Companion;", "", "()V", "AOSP_INT_RANGE_ANNOTATION", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RANGE", "Lcom/android/tools/lint/detector/api/Issue;", "getIntRangeError", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "getNonOverlapMessage", "allowed", "Lcom/android/tools/lint/checks/RangeConstraint;", "actual", "getRangeConstraint", "resolvable", "Lorg/jetbrains/uast/UResolvable;", "getRangeConstraints", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "condition", "Lorg/jetbrains/uast/UExpression;", "previousConstraint", "isIntRange", "", "qualifiedName", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isIntRange(@Nullable String qualifiedName) {
            return AnnotationDetectorKt.INT_RANGE_ANNOTATION.isEquals(qualifiedName) || Intrinsics.areEqual((Object)RangeDetector.AOSP_INT_RANGE_ANNOTATION, (Object)qualifiedName);
        }

        @Nullable
        public final String getIntRangeError(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull UElement argument, @NotNull AnnotationUsageInfo usageInfo) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
                UCallExpression newExpression = (UCallExpression)argument;
                for (UExpression uExpression : newExpression.getValueArguments()) {
                    UExpression expression;
                    String error;
                    UExpression uExpression2 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
                    if (uExpression2 == null || (error = this.getIntRangeError(context, annotation, (UElement)(expression = uExpression2), usageInfo)) == null) continue;
                    return error;
                }
            } else if (UastExpressionUtils.isNewArrayWithDimensions((UElement)argument)) {
                return null;
            }
            IntRangeConstraint constraint2 = IntRangeConstraint.Companion.create(annotation);
            Object o = ConstantEvaluator.evaluate((JavaContext)context, (UElement)argument);
            if (!(o instanceof Number)) {
                RangeConstraint here;
                String error;
                RangeConstraint rangeConstraint;
                if (o instanceof int[] || o instanceof long[]) {
                    if (o instanceof int[]) {
                        for (int value : (int[])o) {
                            if (constraint2.isValid(value)) continue;
                            return constraint2.describe(Long.valueOf(value));
                        }
                    }
                    if (o instanceof long[]) {
                        for (long value : (long[])o) {
                            if (constraint2.isValid(value)) continue;
                            return constraint2.describe(value);
                        }
                    }
                }
                if (argument instanceof UResolvable && (rangeConstraint = this.getRangeConstraint(context, (UResolvable)argument)) != null && (error = this.getNonOverlapMessage(here = RangeConstraint.Companion.create(annotation), rangeConstraint, argument, usageInfo)) != null) {
                    return error;
                }
                return null;
            }
            long l = ((Number)o).longValue();
            return !constraint2.isValid(l) ? constraint2.describe(l) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final RangeConstraint getRangeConstraint(JavaContext context, UResolvable resolvable) {
            UResolvable constraint2;
            RangeConstraint rangeConstraint;
            UAnnotated uAnnotated;
            PsiElement psiElement;
            UResolvable uResolvable = resolvable;
            PsiElement psiElement2 = psiElement = uResolvable == null ? null : uResolvable.resolve();
            if (psiElement == null) {
                return null;
            }
            PsiElement resolved = psiElement;
            UElement uElement = UastContextKt.toUElement((PsiElement)resolved);
            UAnnotated uAnnotated2 = uAnnotated = uElement instanceof UAnnotated ? (UAnnotated)uElement : null;
            if (uAnnotated == null) {
                rangeConstraint = null;
            } else {
                uElement = uAnnotated;
                boolean bl = false;
                boolean bl2 = false;
                UElement it = uElement;
                boolean bl3 = false;
                rangeConstraint = RangeConstraint.Companion.create((UAnnotated)it, context.getEvaluator());
            }
            uResolvable = rangeConstraint;
            Object object = uResolvable == null ? (resolved instanceof PsiModifierListOwner ? RangeConstraint.Companion.create((PsiModifierListOwner)resolved, context.getEvaluator()) : null) : (constraint2 = uResolvable);
            if (resolvable instanceof USimpleNameReferenceExpression) {
                void $this$getParentOfType$iv;
                uAnnotated = (UElement)resolvable;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType2 = false;
                UIfExpression surroundingIf = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UIfExpression.class, (boolean)strict$iv);
                if (surroundingIf != null) {
                    UExpression condition = UastUtils.skipParenthesizedExprDown((UExpression)surroundingIf.getCondition());
                    RangeConstraint $i$f$getParentOfType2 = this.getRangeConstraints((USimpleNameReferenceExpression)resolvable, condition, (RangeConstraint)constraint2);
                    if ($i$f$getParentOfType2 == null) {
                        return constraint2;
                    }
                    RangeConstraint newConstraint = $i$f$getParentOfType2;
                    newConstraint.setInferred(true);
                    UExpression elseExpression = surroundingIf.getElseExpression();
                    if (elseExpression != null && UastLintUtilsKt.isBelow$default((UElement)((UElement)resolvable), (UElement)((UElement)elseExpression), (boolean)false, (int)2, null)) {
                        if (constraint2 != null) {
                            return constraint2.remove(newConstraint);
                        }
                        return null;
                    }
                    return constraint2 != null ? constraint2.and(newConstraint) : newConstraint;
                }
            }
            return constraint2;
        }

        private final RangeConstraint getRangeConstraints(USimpleNameReferenceExpression resolvable, UExpression condition, RangeConstraint previousConstraint) {
            RangeConstraint rangeConstraint;
            Number number;
            if (!(condition instanceof UBinaryExpression)) {
                return null;
            }
            UastBinaryOperator operator = ((UBinaryExpression)condition).getOperator();
            if (Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.LOGICAL_AND)) {
                RangeConstraint rangeConstraint2;
                RangeConstraint left = this.getRangeConstraints(resolvable, UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)condition).getLeftOperand()), previousConstraint);
                RangeConstraint right = this.getRangeConstraints(resolvable, UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)condition).getRightOperand()), previousConstraint);
                return left == null && right == null ? null : (left != null && right != null ? right.and(left) : ((rangeConstraint2 = left) == null ? right : rangeConstraint2));
            }
            if (Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.LOGICAL_OR)) {
                return null;
            }
            UExpression lhs = ((UBinaryExpression)condition).getLeftOperand();
            if (!Intrinsics.areEqual((Object)UastUtils.tryResolve((UElement)((UElement)lhs)), (Object)resolvable.resolve())) {
                return null;
            }
            Object object = ((UBinaryExpression)condition).getRightOperand().evaluate();
            Number number2 = number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number == null) {
                return null;
            }
            Number value = number;
            if (value instanceof Float || value instanceof Double) {
                RangeConstraint rangeConstraint3;
                double number3 = value.doubleValue();
                if (number3 == Double.POSITIVE_INFINITY || number3 == Double.NEGATIVE_INFINITY) {
                    return null;
                }
                UastBinaryOperator uastBinaryOperator = operator;
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.greaterThan(number3);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.atLeast(number3);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.lessThan(number3);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.atMost(number3);
                } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) {
                    rangeConstraint3 = FloatRangeConstraint.Companion.range(number3, number3);
                } else {
                    return null;
                }
                return rangeConstraint3;
            }
            long number4 = value.longValue();
            if (number4 == Long.MIN_VALUE || number4 == Long.MAX_VALUE) {
                return null;
            }
            UastBinaryOperator uastBinaryOperator = operator;
            if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER)) {
                rangeConstraint = IntRangeConstraint.Companion.atLeast(number4);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS)) {
                rangeConstraint = IntRangeConstraint.Companion.atLeast(number4);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS)) {
                rangeConstraint = IntRangeConstraint.Companion.atMost(number4);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS)) {
                rangeConstraint = IntRangeConstraint.Companion.atMost(number4);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) {
                rangeConstraint = IntRangeConstraint.Companion.range(number4, number4);
            } else if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) ? true : Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) {
                rangeConstraint = previousConstraint instanceof IntRangeConstraint ? (((IntRangeConstraint)previousConstraint).getFrom() == number4 ? IntRangeConstraint.Companion.range(((IntRangeConstraint)previousConstraint).getFrom() + 1L, ((IntRangeConstraint)previousConstraint).getTo()) : (((IntRangeConstraint)previousConstraint).getTo() == number4 ? IntRangeConstraint.Companion.range(((IntRangeConstraint)previousConstraint).getFrom(), ((IntRangeConstraint)previousConstraint).getTo() - 1L) : (IntRangeConstraint)null)) : (IntRangeConstraint)null;
            } else {
                return null;
            }
            return rangeConstraint;
        }

        private final String getNonOverlapMessage(RangeConstraint allowed, RangeConstraint actual, UElement argument, AnnotationUsageInfo usageInfo) {
            RangeConstraint rangeConstraint = allowed;
            if (rangeConstraint == null) {
                return null;
            }
            Boolean bl = allowed.contains(actual);
            if (bl == null) {
                return null;
            }
            boolean contains = bl;
            if (!contains) {
                String string;
                String string2;
                if (actual.getInfinite() && actual.getInferred()) {
                    return null;
                }
                String actualLabel = "";
                String allowedLabel = "";
                UElement selector = UastLintUtilsKt.findSelector((UElement)argument);
                if (selector instanceof UCallExpression) {
                    string2 = ((UCallExpression)selector).getMethodName();
                    string = string2 == null ? "" : string2;
                } else if (selector instanceof USimpleNameReferenceExpression) {
                    string = ((USimpleNameReferenceExpression)selector).getIdentifier();
                } else {
                    string2 = argument.getSourcePsi();
                    if (string2 == null) {
                        string = "";
                    } else {
                        String string3 = string2.getText();
                        if (string3 == null) {
                            string = "";
                        } else {
                            String string4 = string3;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            String it = string4;
                            boolean bl4 = false;
                            String string5 = it.length() < 40 ? string4 : null;
                            string = string5 == null ? "" : string5;
                        }
                    }
                }
                String argumentSource = string;
                CharSequence charSequence = argumentSource;
                boolean bl5 = false;
                if (!StringsKt.isBlank((CharSequence)charSequence)) {
                    actualLabel = '`' + argumentSource + '`';
                } else if (usageInfo.getType() == AnnotationUsageType.METHOD_CALL_PARAMETER) {
                    allowedLabel = "the parameter ";
                    actualLabel = "the argument ";
                }
                return allowed.describeDelta(actual, actualLabel, allowedLabel);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

