/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.support.AndroidxName;
import com.android.tools.lint.checks.ApiConstraint;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.DesugaredMethodLookup;
import com.android.tools.lint.checks.LibraryDesugaringKt;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.VersionChecks;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceFolderScanner;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UImplicitCallExpressionKt;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScannerConstants;
import com.android.utils.StringHelper;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 O2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002NOB\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J:\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\f\u001a\u00020\u001dH\u0016J \u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u001dH\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\t0+H\u0016J\u0016\u0010-\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001f0.0\bH\u0016J\u0010\u0010/\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\tH\u0016J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u000207H\u0002J$\u00108\u001a\u00020#2\u0006\u0010\f\u001a\u00020\r2\b\u00109\u001a\u0004\u0018\u00010\t2\b\u0010:\u001a\u0004\u0018\u00010\tH\u0002J0\u0010;\u001a\u00020#2\b\u00101\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\u00142\u0014\b\u0002\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#0?H\u0002J@\u0010@\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u0014H\u0002J(\u0010G\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016J\u0018\u0010L\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u00106\u001a\u000207H\u0016J\u0018\u0010M\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/android/tools/lint/checks/ApiDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/ResourceFolderScanner;", "()V", "apiDatabase", "Lcom/android/tools/lint/checks/ApiLookup;", "applicableAnnotations", "", "", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "tag", "api", "", "gradleVersion", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "checkFolder", "Lcom/android/tools/lint/detector/api/ResourceContext;", "folderName", "checkLevelList", "checkObsoleteSdkVersion", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "filterIncident", "", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApiLevelString", "requires", "getApplicableAttributes", "", "getApplicableElements", "getApplicableUastTypes", "Ljava/lang/Class;", "getMinSdk", "inheritAnnotation", "annotation", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isAttributeOfGradientOrGradientItem", "attribute", "Lorg/w3c/dom/Attr;", "isLibraryDesugared", "owner", "name", "isSurroundedByHigherTargetAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "atLeast", "isApiLevelAnnotation", "Lkotlin/Function1;", "report", "scope", "Lorg/w3c/dom/Node;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "minSdk", "visitAnnotationUsage", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "visitAttribute", "visitElement", "ApiVisitor", "Companion", "lint-checks"})
public final class ApiDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
ResourceFolderScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ApiLookup apiDatabase;
    @JvmField
    public static final AndroidxName REQUIRES_API_ANNOTATION = AndroidxName.of((AndroidxName)SdkConstants.SUPPORT_ANNOTATIONS_PREFIX, (String)"RequiresApi");
    @NotNull
    public static final String KEY_FILE = "file";
    @NotNull
    public static final String KEY_REQUIRES_API = "requiresApi";
    @NotNull
    public static final String KEY_FOLDER_NAME = "folderName";
    @NotNull
    public static final String KEY_CONDITIONAL = "conditional";
    @NotNull
    public static final String KEY_REQUIRE_CLASS = "requireClass";
    @NotNull
    private static final String KEY_MESSAGE = "message";
    @NotNull
    private static final String KEY_MIN_API = "minSdk";
    @NotNull
    private static final String KEY_OWNER = "owner";
    @NotNull
    private static final String KEY_NAME = "name";
    @NotNull
    private static final String KEY_DESUGAR = "desugar";
    @NotNull
    private static final String SDK_SUPPRESS_ANNOTATION = "android.support.test.filters.SdkSuppress";
    @NotNull
    private static final String ANDROIDX_SDK_SUPPRESS_ANNOTATION = "androidx.test.filters.SdkSuppress";
    @NotNull
    private static final String ROBO_ELECTRIC_CONFIG_ANNOTATION = "org.robolectric.annotation.Config";
    @NotNull
    private static final String ATTR_PROPERTY_VALUES_HOLDER = "propertyValuesHolder";
    @NotNull
    private static final Implementation JAVA_IMPLEMENTATION = new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue UNSUPPORTED;
    @JvmField
    @NotNull
    public static final Issue INLINED;
    @JvmField
    @NotNull
    public static final Issue OVERRIDE;
    @JvmField
    @NotNull
    public static final Issue UNUSED;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_SDK;
    @NotNull
    private static final String TAG_RIPPLE = "ripple";
    @NotNull
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    @NotNull
    private static final Pair<UAnnotation, Integer> NO_ANNOTATION_FOUND;
    @NotNull
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";

    public void beforeCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.apiDatabase == null) {
            this.apiDatabase = ApiLookup.get(context.getClient(), context.getProject().getBuildTarget());
        }
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        List list = XmlScannerConstants.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALL");
        return list;
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        List list = XmlScannerConstants.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ALL");
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        block44: {
            block43: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                var4_3 = this.apiDatabase;
                if (var4_3 == null) {
                    return;
                }
                apiDatabase = var4_3;
                attributeApiLevel = -1;
                namespace = attribute.getNamespaceURI();
                if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)namespace)) break block43;
                name = attribute.getLocalName();
                if (!(Intrinsics.areEqual((Object)name, (Object)"layout_width") || Intrinsics.areEqual((Object)name, (Object)"layout_height") || Intrinsics.areEqual((Object)name, (Object)"id") || (this.isAttributeOfGradientOrGradientItem(attribute) || Intrinsics.areEqual((Object)name, (Object)"fillType")) && com.android.tools.lint.checks.ApiDetector$Companion.access$dependsOnAppCompat(ApiDetector.Companion, context.getProject()) || (attributeApiLevel = apiDatabase.getFieldVersion(owner = "android/R$attr", name)) <= (minSdk = this.getMinSdk((Context)context)) || attributeApiLevel <= context.getFolderVersion())) {
                    var9_19 = attribute.getOwnerElement();
                    Intrinsics.checkNotNullExpressionValue((Object)var9_19, (String)"attribute.ownerElement");
                    if (attributeApiLevel > com.android.tools.lint.checks.ApiDetector$Companion.access$getLocalMinSdk(ApiDetector.Companion, var9_19)) {
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                        if (!(ApiDetector.Companion.isBenignUnusedAttribute(name) || com.android.tools.lint.checks.ApiDetector$Companion.access$isAlreadyWarnedDrawableFile(ApiDetector.Companion, context, attribute, attributeApiLevel) || RtlDetector.isRtlAttributeName(name) || Intrinsics.areEqual((Object)"supportsRtl", (Object)name))) {
                            location = context.getLocation((Node)attribute);
                            localName = attribute.getLocalName();
                            message = "Attribute `" + localName + "` is only used in API level " + attributeApiLevel + " and higher (current min is %1$d)";
                            if (Intrinsics.areEqual((Object)"fontFamily", (Object)localName) && com.android.tools.lint.checks.ApiDetector$Companion.access$dependsOnAppCompat(ApiDetector.Companion, context.getProject())) {
                                prefix = XmlUtils.lookupNamespacePrefix((Node)attribute, (String)"http://schemas.android.com/apk/res-auto", (String)"app", (boolean)false);
                                message = message + " Did you mean `" + prefix + ":fontFamily` ?";
                            }
                            this.report(context, ApiDetector.UNUSED, attribute, location, message, attributeApiLevel, minSdk);
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)name, (Object)"divider")) {
                    return;
                }
                if (Intrinsics.areEqual((Object)name, (Object)"theme") && Intrinsics.areEqual((Object)"include", (Object)attribute.getOwnerElement().getTagName())) {
                    minSdk = this.getMinSdk((Context)context);
                    minSdk = context.getFolderVersion();
                    location = false;
                    if (Math.max(minSdk, minSdk) < 23) {
                        location = context.getLocation((Node)attribute);
                        message = "Attribute `android:theme` is only used by `<include>` tags in API level 23 and higher (current min is %1$d)";
                        this.report(context, ApiDetector.UNUSED, attribute, location, message, 23, minSdk);
                    }
                }
                if (Intrinsics.areEqual((Object)name, (Object)"foreground") && context.getResourceFolderType() == ResourceFolderType.LAYOUT) {
                    minSdk = attribute.getOwnerElement().getTagName();
                    Intrinsics.checkNotNullExpressionValue((Object)minSdk, (String)"attribute.ownerElement.tagName");
                    if (!com.android.tools.lint.checks.ApiDetector$Companion.access$isFrameLayout(ApiDetector.Companion, context, minSdk, true)) {
                        minSdk = this.getMinSdk((Context)context);
                        location = context.getFolderVersion();
                        message = false;
                        if (Math.max(minSdk, location) < 23) {
                            location = context.getLocation((Node)attribute);
                            message = "Attribute `android:foreground` has no effect on API levels lower than 23 (current min is %1$d)";
                            this.report(context, ApiDetector.UNUSED, attribute, location, message, 23, minSdk);
                            ** GOTO lbl71
                        }
                    }
                }
                break block44;
            }
            if (!Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace) || !Intrinsics.areEqual((Object)(name = attribute.getLocalName()), (Object)"targetApi")) break block44;
            targetApiString = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)targetApiString, (String)"targetApiString");
            message = targetApiString;
            localName = false;
            if (!(StringsKt.isBlank((CharSequence)message) == false)) ** GOTO lbl-1000
            message = targetApiString.charAt(0);
            localName = false;
            if (Character.isDigit(message)) {
                try {
                    message = Integer.parseInt(targetApiString);
                }
                catch (NumberFormatException e) {
                    message = null;
                }
                v0 = message;
            } else lbl-1000:
            // 2 sources

            {
                v0 = api = Integer.valueOf(SdkVersionInfo.getApiByBuildCode((String)targetApiString, (boolean)true));
            }
            if (api != null) {
                message = Intrinsics.stringPlus((String)"Unnecessary; SDK_INT is always >= ", (Object)api);
                fix = this.fix().replace().all().with("").range(context.getLocation((Node)attribute)).name(Intrinsics.stringPlus((String)"Delete ", (Object)attribute.getName())).build();
                context.report(new Incident(ApiDetector.OBSOLETE_SDK, message, context.getLocation((Node)attribute), (Object)attribute, fix), Constraints.minSdkAtLeast((int)api));
                return;
            }
        }
        value = attribute.getValue();
        owner = null;
        name = null;
        prefix = null;
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        if (StringsKt.startsWith$default((String)value, (String)"@android:", (boolean)false, (int)2, null)) {
            prefix = "@android:";
        } else if (StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) {
            prefix = "?android:";
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && (api = 21) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion()) {
                prefix = attribute.getOwnerElement();
                Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"attribute.ownerElement");
                if (api > com.android.tools.lint.checks.ApiDetector$Companion.access$getLocalMinSdk(ApiDetector.Companion, (Element)prefix)) {
                    location = context.getLocation((Node)attribute);
                    message = "Using theme references in XML drawables requires API level " + api + " (current min is %1$d)";
                    this.report(context, ApiDetector.UNSUPPORTED, attribute, location, message, api, minSdk);
                    return;
                }
            }
        } else if (StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)"name", (Object)attribute.getName()) && Intrinsics.areEqual((Object)"item", (Object)attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && Intrinsics.areEqual((Object)"style", (Object)attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            api = value;
            minSdk = "android:".length();
            location = false;
            v1 = api.substring(minSdk);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"(this as java.lang.String).substring(startIndex)");
            name = v1;
            prefix = null;
        } else if (StringsKt.startsWith$default((String)value, (String)"android:", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)"parent", (Object)attribute.getName()) && Intrinsics.areEqual((Object)"style", (Object)attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            api = value;
            minSdk = "android:".length();
            location = false;
            v2 = api.substring(minSdk);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).substring(startIndex)");
            name = ResourcesUtil.resourceNameToFieldName((String)v2);
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            minSdk = prefix;
            index = StringsKt.indexOf$default((CharSequence)value, (char)'/', (int)(minSdk == null ? 0 : (location = minSdk.length())), (boolean)false, (int)4, null);
            if (index >= 0) {
                minSdk = value;
                location = prefix;
                location = location == null ? 0 : (message = location.length());
                message = 0;
                v3 = minSdk.substring(location, index);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                owner = Intrinsics.stringPlus((String)"android/R$", (Object)v3);
                minSdk = value;
                location = index + 1;
                message = 0;
                v4 = minSdk.substring(location);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"(this as java.lang.String).substring(startIndex)");
                name = ResourcesUtil.resourceNameToFieldName((String)v4);
            } else if (StringsKt.startsWith$default((String)value, (String)"?android:", (boolean)false, (int)2, null)) {
                owner = "android/R$attr";
                minSdk = value;
                location = "?android:".length();
                message = 0;
                v5 = minSdk.substring(location);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"(this as java.lang.String).substring(startIndex)");
                name = v5;
            } else {
                return;
            }
        }
        if ((index = name) == null) {
            return;
        }
        api = apiDatabase.getFieldVersion(owner, name);
        if (api > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion()) {
            location = attribute.getOwnerElement();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"attribute.ownerElement");
            if (api > com.android.tools.lint.checks.ApiDetector$Companion.access$getLocalMinSdk(ApiDetector.Companion, location)) {
                if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)namespace)) {
                    return;
                }
                if (attributeApiLevel < api) {
                    if (attributeApiLevel > minSdk) {
                        attributeName = attribute.getLocalName();
                        location = context.getLocation((Node)attribute);
                        message = '`' + name + "` requires API level " + api + " (current min is %1$d), but note that attribute `" + attributeName + "` is only used in API level " + attributeApiLevel + " and higher";
                        this.report(context, ApiDetector.UNSUPPORTED, attribute, location, message, api, minSdk);
                    } else {
                        if (api == 17 && RtlDetector.isRtlAttributeName(name) && !Intrinsics.areEqual((Object)name, (Object)(old = RtlDetector.convertNewToOld(name)))) {
                            parent = attribute.getOwnerElement();
                            if (Intrinsics.areEqual((Object)"item", (Object)parent.getTagName())) {
                                var15_58 = parent.getParentNode();
                                Intrinsics.checkNotNullExpressionValue((Object)var15_58, (String)"parent.parentNode");
                                for (Element item : Lint.getChildren((Node)var15_58)) {
                                    v = item.getAttribute("name");
                                    Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
                                    Intrinsics.checkNotNullExpressionValue((Object)old, (String)"old");
                                    if (!StringsKt.endsWith$default((String)v, (String)old, (boolean)false, (int)2, null)) continue;
                                    return;
                                }
                            } else if (parent.hasAttributeNS("http://schemas.android.com/apk/res/android", old)) {
                                return;
                            }
                        }
                        location = context.getLocation((Node)attribute);
                        message = '`' + value + "` requires API level " + api + " (current min is %1$d)";
                        this.report(context, ApiDetector.UNSUPPORTED, attribute, (Location)location, message, api, minSdk);
                    }
                }
            }
        }
    }

    private final boolean isAttributeOfGradientOrGradientItem(Attr attribute) {
        Element element = attribute.getOwnerElement();
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"gradient")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)element.getNodeName(), (Object)"item")) {
            Node node = element.getParentNode();
            return Intrinsics.areEqual((Object)(node == null ? null : node.getLocalName()), (Object)"gradient");
        }
        return false;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ApiLookup apiLookup = this.apiDatabase;
        if (apiLookup == null) {
            return;
        }
        ApiLookup apiDatabase = apiLookup;
        String string = element.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.tagName");
        String tag = string;
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, "vector", 21, "1.4", UNSUPPORTED);
                this.checkElement(context, element, TAG_RIPPLE, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, "animated-vector", 21, null, UNSUPPORTED);
                this.checkElement(context, element, "drawable", 24, null, UNSUPPORTED);
                if (Intrinsics.areEqual((Object)"layer-list", (Object)tag)) {
                    this.checkLevelList(context, element);
                } else if (StringsKt.contains$default((CharSequence)tag, (CharSequence)".", (boolean)false, (int)2, null)) {
                    this.checkElement(context, element, tag, 24, null, UNSUPPORTED);
                }
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            int n = childNodes.getLength();
            while (i < n) {
                Node textNode = childNodes.item(i);
                if (textNode.getNodeType() == 3) {
                    String text;
                    String string2 = text = textNode.getNodeValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"@android:", (boolean)false, (int)2, null)) {
                        string2 = text;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
                        boolean bl = false;
                        String string3 = text = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text");
                        int index = StringsKt.indexOf$default((CharSequence)string3, (char)'/', (int)"@android:".length(), (boolean)false, (int)4, null);
                        if (index != -1) {
                            String typeString;
                            String string4 = text;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"text");
                            int n2 = "@android:".length();
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n2, index), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            if (ResourceType.fromXmlValue((String)typeString) != null) {
                                String owner = Intrinsics.stringPlus((String)"android/R$", (Object)typeString);
                                String string5 = text;
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text");
                                int n3 = index + 1;
                                boolean bl3 = false;
                                String string6 = string5.substring(n3);
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                                String name = ResourcesUtil.resourceNameToFieldName((String)string6);
                                int api = apiDatabase.getFieldVersion(owner, name);
                                int minSdk = this.getMinSdk((Context)context);
                                if (api > minSdk && api > context.getFolderVersion() && api > ApiDetector.Companion.getLocalMinSdk(element)) {
                                    Intrinsics.checkNotNullExpressionValue((Object)textNode, (String)"textNode");
                                    Location location = context.getLocation(textNode);
                                    String message2 = '`' + text + "` requires API level " + api + " (current min is %1$d)";
                                    this.report(context, UNSUPPORTED, element, location, message2, api, minSdk);
                                }
                            }
                        }
                    }
                }
                int text = i;
                i = text + 1;
            }
        } else {
            int localMinSdk;
            int minSdk;
            int api;
            if (Intrinsics.areEqual((Object)"view", (Object)tag)) {
                CharSequence childNodes = element.getAttribute("class");
                if (childNodes == null) {
                    return;
                }
                tag = childNodes;
                childNodes = tag;
                boolean i = false;
                if (childNodes.length() == 0) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", 21, null, UNUSED);
            }
            if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
                return;
            }
            String fqn = Intrinsics.stringPlus((String)"android/widget/", (Object)tag);
            if (Intrinsics.areEqual((Object)tag, (Object)"TextureView")) {
                fqn = "android/view/TextureView";
            }
            if ((api = apiDatabase.getClassVersion(fqn)) > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > (localMinSdk = ApiDetector.Companion.getLocalMinSdk(element))) {
                Location location = context.getNameLocation((Node)element);
                String message3 = "View requires API level " + api + " (current min is %1$d): `<" + tag + ">`";
                this.report(context, UNSUPPORTED, element, location, message3, api, localMinSdk);
            }
        }
    }

    private final void checkLevelList(XmlContext context, Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            int minSdk;
            int attributeApiLevel;
            Node node;
            Element e;
            if (curr.getNodeType() != 1 || !Intrinsics.areEqual((Object)"item", (Object)curr.getNodeName()) || !(e = (Element)(node = curr)).hasAttributeNS("http://schemas.android.com/apk/res/android", "width") && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", "height") || (attributeApiLevel = 23) <= (minSdk = this.getMinSdk((Context)context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.Companion.getLocalMinSdk(element)) continue;
            String[] stringArray = new String[]{"width", "height"};
            for (String attributeName : stringArray) {
                Attr attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                if (attr == null) continue;
                Attr attribute = attr;
                Location location = context.getLocation((Node)attribute);
                String message2 = "Attribute `" + attribute.getLocalName() + "` is only used in API level " + attributeApiLevel + " and higher (current min is %1$d)";
                this.report(context, UNUSED, attribute, location, message2, attributeApiLevel, minSdk);
            }
        }
    }

    private final void checkElement(XmlContext context, Element element, String tag, int api, String gradleVersion, Issue issue) {
        int minSdk;
        String realTag = tag;
        if (Intrinsics.areEqual((Object)realTag, (Object)element.getTagName()) && api > (minSdk = this.getMinSdk((Context)context)) && api > context.getFolderVersion() && api > ApiDetector.Companion.getLocalMinSdk(element) && !ApiDetector.Companion.featureProvidedByGradle(context, gradleVersion)) {
            Location location = context.getNameLocation((Node)element);
            if (Intrinsics.areEqual((Object)"drawable", (Object)realTag)) {
                Attr attr = element.getAttributeNode("class");
                if (attr == null) {
                    return;
                }
                Attr attribute = attr;
                location = context.getLocation((Node)attribute);
                realTag = "class";
            }
            String message2 = null;
            if (issue == UNSUPPORTED) {
                message2 = "`<" + realTag + ">` requires API level " + api + " (current min is %1$d)";
                if (gradleVersion != null) {
                    message2 = message2 + " or building with Android Gradle plugin " + gradleVersion + " or higher";
                } else if (StringsKt.contains$default((CharSequence)realTag, (CharSequence)".", (boolean)false, (int)2, null)) {
                    message2 = "Custom drawables requires API level " + api + " (current min is %1$d)";
                }
            } else {
                boolean bl = issue == UNUSED;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    Issue issue2 = issue;
                    throw (Throwable)((Object)new AssertionError(issue2));
                }
                message2 = "`<" + realTag + ">` is only used in API level " + api + " and higher (current min is %1$d)";
            }
            this.report(context, issue, element, location, message2, api, minSdk);
        }
    }

    private final int getMinSdk(Context context) {
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        return !project.isAndroidProject() ? Integer.MAX_VALUE : project.getMinSdkVersion().getFeatureLevel();
    }

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[5];
        String string = REQUIRES_API_ANNOTATION.oldName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"REQUIRES_API_ANNOTATION.oldName()");
        objectArray[0] = string;
        string = REQUIRES_API_ANNOTATION.newName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"REQUIRES_API_ANNOTATION.newName()");
        objectArray[1] = string;
        objectArray[2] = ANDROIDX_SDK_SUPPRESS_ANNOTATION;
        objectArray[3] = "android.annotation.TargetApi";
        objectArray[4] = ROBO_ELECTRIC_CONFIG_ANNOTATION;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        AnnotationUsageType annotationUsageType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[annotationUsageType.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMember member = psiElement instanceof PsiMember ? (PsiMember)psiElement : null;
        int api = Companion.getApiLevel(context, annotation, annotationInfo.getQualifiedName());
        if (api == -1) {
            return;
        }
        int minSdk = this.getMinSdk((Context)context);
        if (usageInfo.getType() == AnnotationUsageType.DEFINITION) {
            LintFix fix = this.fix().replace().all().with("").range(context.getLocation((UElement)annotation)).name("Delete @RequiresApi").build();
            UElement uElement = element.getUastParent();
            Pair pair = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApiAnnotation$default(Companion, uElement == null ? null : uElement.getUastParent(), null, 2, null);
            UAnnotation targetAnnotation = (UAnnotation)pair.component1();
            int target2 = ((Number)pair.component2()).intValue();
            if (target2 > api) {
                String string;
                UAnnotation uAnnotation;
                String outerAnnotation = '@' + ((uAnnotation = targetAnnotation) == null ? null : ((string = uAnnotation.getQualifiedName()) == null ? null : StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null))) + '(' + target2 + ')';
                String message2 = "Unnecessary; SDK_INT is always >= " + target2 + " from outer annotation (`" + outerAnnotation + "`)";
                context.report(new Incident(OBSOLETE_SDK, message2, context.getLocation((UElement)annotation), (Object)annotation, fix));
            } else {
                String message3 = Intrinsics.stringPlus((String)"Unnecessary; SDK_INT is always >= ", (Object)api);
                context.report(new Incident(OBSOLETE_SDK, message3, context.getLocation((UElement)annotation), (Object)annotation, fix), Constraints.minSdkAtLeast((int)api));
            }
            return;
        }
        if (!REQUIRES_API_ANNOTATION.isEquals(annotation.getQualifiedName())) {
            return;
        }
        Pair pair = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApiAnnotation$default(Companion, element, null, 2, null);
        UAnnotation targetAnnotation = (UAnnotation)pair.component1();
        int target3 = ((Number)pair.component2()).intValue();
        if (target3 == -1 || api > target3) {
            Issue issue;
            String string;
            String string2;
            String string3;
            PsiMember classReference;
            if (VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, context, element, api, false, 8, null)) {
                return;
            }
            if (VersionChecks.Companion.isPrecededByVersionCheckExit(context, element, api)) {
                return;
            }
            if (ApiDetector.isSurroundedByHigherTargetAnnotation$default(this, targetAnnotation, api, null, 4, null)) {
                return;
            }
            Location location = null;
            String fqcn = null;
            if (element instanceof UCallExpression && !Intrinsics.areEqual((Object)((UCallExpression)element).getKind(), (Object)UastCallKind.METHOD_CALL) && ((UCallExpression)element).getClassReference() != null) {
                PsiMember psiMember;
                UReferenceExpression uReferenceExpression = ((UCallExpression)element).getClassReference();
                Intrinsics.checkNotNull((Object)uReferenceExpression);
                classReference = uReferenceExpression;
                location = context.getRangeLocation(element, 0, (UElement)classReference, 0);
                string3 = classReference.getResolvedName();
                fqcn = string3 == null ? ((psiMember = member) == null ? "" : ((string2 = psiMember.getName()) == null ? "" : string2)) : string3;
            } else {
                location = context.getNameLocation(element);
                classReference = member;
                fqcn = classReference == null ? "" : ((string3 = classReference.getName()) == null ? "" : string3);
            }
            string3 = usageInfo.getType();
            int n = WhenMappings.$EnumSwitchMapping$0[string3.ordinal()];
            switch (n) {
                case 6: {
                    string = Intrinsics.stringPlus((String)"Extending ", (Object)fqcn);
                    break;
                }
                case 4: 
                case 5: {
                    string = "Class";
                    break;
                }
                case 8: 
                case 9: {
                    string = "Method";
                    break;
                }
                case 3: 
                case 10: {
                    string = "Field";
                    break;
                }
                default: {
                    string = "Call";
                }
            }
            String type = string;
            PsiElement field = usageInfo.getReferenced();
            if (field instanceof PsiField && Lint.isInlined((PsiField)((PsiField)field), (JavaEvaluator)context.getEvaluator())) {
                String string4;
                JavaEvaluator javaEvaluator = context.getEvaluator();
                PsiField psiField = (PsiField)field;
                string2 = ((PsiField)field).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name");
                String string5 = string2;
                PsiClass psiClass = ((PsiField)field).getContainingClass();
                String string6 = psiClass == null ? "" : (string2 = (string4 = psiClass.getQualifiedName()) == null ? "" : string4);
                if (Companion.isBenignConstantUsage(javaEvaluator, psiField, element, string5, string2)) {
                    return;
                }
                issue = INLINED;
            } else {
                issue = UNSUPPORTED;
            }
            Issue issue2 = issue;
            ApiVisitor.report$default(new ApiVisitor(context), issue2, element, location, type, fqcn, api, minSdk, ApiDetector.Companion.apiLevelFix(api), null, null, null, null, 3840, null);
        }
    }

    private final boolean isSurroundedByHigherTargetAnnotation(UAnnotation annotation, int atLeast, Function1<? super String, Boolean> isApiLevelAnnotation) {
        UAnnotation uAnnotation = annotation;
        if (uAnnotation == null) {
            return false;
        }
        UAnnotation curr = uAnnotation;
        while (true) {
            UElement uElement;
            uAnnotation = Companion.getTargetApiAnnotation((uElement = curr.getUastParent()) == null ? null : uElement.getUastParent(), isApiLevelAnnotation);
            UAnnotation outer = (UAnnotation)uAnnotation.component1();
            int target2 = ((Number)uAnnotation.component2()).intValue();
            if (target2 >= atLeast) {
                return true;
            }
            UAnnotation uAnnotation2 = outer;
            if (uAnnotation2 == null) {
                return false;
            }
            curr = uAnnotation2;
        }
    }

    static /* synthetic */ boolean isSurroundedByHigherTargetAnnotation$default(ApiDetector apiDetector, UAnnotation uAnnotation, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function1 = (Function1)new Function1<String, Boolean>((Object)Companion){

                @NotNull
                public final Boolean invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return com.android.tools.lint.checks.ApiDetector$Companion.access$isTargetAnnotation((Companion)this.receiver, p0);
                }
            };
        }
        return apiDetector.isSurroundedByHigherTargetAnnotation(uAnnotation, n, (Function1<? super String, Boolean>)function1);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.apiDatabase == null || context.isTestSource() && !context.getDriver().getCheckTestSources()) {
            return null;
        }
        Project project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        return project.isAndroidProject() ? (UElementHandler)new ApiVisitor(context) : (UElementHandler)null;
    }

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{USimpleNameReferenceExpression.class, ULocalVariable.class, UTryExpression.class, UBinaryExpressionWithType.class, UBinaryExpression.class, UUnaryExpression.class, UCallExpression.class, UClass.class, UMethod.class, UForEachExpression.class, UClassLiteralExpression.class, USwitchExpression.class, UCallableReferenceExpression.class, UArrayAccessExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        boolean bl;
        Object object;
        Desugaring desugaring;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Project mainProject = context.getMainProject();
        int mainMinSdk = !mainProject.isAndroidProject() ? Integer.MAX_VALUE : mainProject.getMinSdkVersion().getFeatureLevel();
        Integer n = LintMap.getInt$default((LintMap)map, (String)KEY_REQUIRES_API, null, (int)2, null);
        if (n == null) {
            return false;
        }
        int requires = n;
        if (requires <= mainMinSdk) {
            return false;
        }
        Integer n2 = LintMap.getInt$default((LintMap)map, (String)KEY_MIN_API, null, (int)2, null);
        if (n2 == null) {
            return false;
        }
        int target2 = n2;
        boolean bl2 = false;
        int minSdk = Math.max(target2, mainMinSdk);
        Integer n3 = map.getInt(KEY_DESUGAR, null);
        if (n3 == null) {
            desugaring = null;
        } else {
            object = n3;
            boolean bl3 = false;
            bl = false;
            int it = ((Number)object).intValue();
            boolean bl4 = false;
            desugaring = Desugaring.Companion.fromConstant(it);
        }
        Desugaring desugaring2 = desugaring;
        if (desugaring2 != null && mainProject.isDesugaring(desugaring2)) {
            if (desugaring2 == Desugaring.JAVA_8_LIBRARY) {
                String name;
                String owner = map.getString(KEY_OWNER, null);
                if (owner != null && this.isLibraryDesugared(context, owner, name = LintMap.getString$default((LintMap)map, (String)KEY_NAME, null, (int)2, null))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((object = LintMap.getString$default((LintMap)map, (String)KEY_MESSAGE, null, (int)2, null)) == null) {
            return false;
        }
        Object formatString = object;
        object = StringCompanionObject.INSTANCE;
        Object[] objectArray = new Object[]{minSdk};
        bl = false;
        String string = String.format((String)formatString, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        incident.setMessage(string);
        return true;
    }

    private final boolean isLibraryDesugared(Context context, String owner, String name) {
        Project project;
        Project project2 = project = context.isGlobalAnalysis() ? context.getMainProject() : context.getProject();
        return owner != null && (StringsKt.startsWith$default((String)owner, (String)"java/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"java.", (boolean)false, (int)2, null)) && project.isDesugaring(Desugaring.JAVA_8_LIBRARY) && LibraryDesugaringKt.isApiDesugared(project, StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), name);
    }

    private final void report(XmlContext context, Issue issue, Node scope, Location location, String message2, int api, int minSdk) {
        int n;
        boolean bl = StringsKt.contains$default((CharSequence)message2, (CharSequence)"%1$d", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        LintFix lintFix = ApiDetector.Companion.apiLevelFix(api);
        Incident incident = new Incident(issue, (Object)scope, location, "", lintFix);
        LintMap lintMap = this.map();
        boolean bl5 = false;
        boolean bl6 = false;
        LintMap $this$report_u24lambda_u2d2 = lintMap;
        boolean bl7 = false;
        $this$report_u24lambda_u2d2.put(KEY_REQUIRES_API, api);
        $this$report_u24lambda_u2d2.put(KEY_MESSAGE, message2);
        if (minSdk == -1) {
            Node node = scope;
            Element element = node instanceof Attr ? ((Attr)scope).getOwnerElement() : (node instanceof Element ? (Element)scope : scope.getOwnerDocument().getDocumentElement());
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            n = ApiDetector.Companion.getLocalMinSdk(element);
        } else {
            n = minSdk;
        }
        int localMinSdk = n;
        $this$report_u24lambda_u2d2.put(KEY_MIN_API, localMinSdk);
        LintMap map = lintMap;
        context.report(incident, map);
    }

    private final String getApiLevelString(int requires, JavaContext context) {
        AndroidVersion androidVersion;
        String string;
        return requires <= 32 || requires <= context.getProject().getBuildSdk() && ((string = context.getProject().getBuildTarget()) == null ? false : ((androidVersion = string.getVersion()) == null ? false : !androidVersion.isPreview())) ? String.valueOf(requires) : ((string = SdkVersionInfo.getCodeName((int)requires)) == null ? String.valueOf(requires) : string);
    }

    private final void checkObsoleteSdkVersion(JavaContext context, UElement node) {
        UBinaryExpression binary = (UBinaryExpression)UastUtils.getParentOfType((UElement)node, UBinaryExpression.class, (boolean)true);
        if (binary != null) {
            int minSdk = this.getMinSdk((Context)context);
            ApiConstraint constraint2 = VersionChecks.Companion.getVersionCheckConditional-xCz0aec(binary);
            if (constraint2 != null) {
                String string;
                boolean always = ApiConstraint.alwaysAtLeast-impl(constraint2.unbox-impl(), minSdk);
                boolean never = ApiConstraint.neverAtMost-impl(constraint2.unbox-impl(), minSdk);
                if (always) {
                    string = Intrinsics.stringPlus((String)"Unnecessary; SDK_INT is always >= ", (Object)minSdk);
                } else if (never) {
                    string = Intrinsics.stringPlus((String)"Unnecessary; SDK_INT is never < ", (Object)minSdk);
                } else {
                    return;
                }
                String message2 = string;
                Object[] objectArray = new Object[]{KEY_CONDITIONAL, always};
                context.report(new Incident(OBSOLETE_SDK, message2, context.getLocation((UElement)binary), (Object)binary, LintFix.Companion.create().data(objectArray)));
            }
        }
    }

    public void checkFolder(@NotNull ResourceContext context, @NotNull String folderName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)folderName, (String)KEY_FOLDER_NAME);
        int folderVersion = context.getFolderVersion();
        AndroidVersion minSdkVersion = context.getProject().getMinSdkVersion();
        if (folderVersion > 1 && folderVersion <= minSdkVersion.getFeatureLevel()) {
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfiguration == null) {
                File file = context.file;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(((Object)file).toString());
            }
            FolderConfiguration folderConfig = folderConfiguration;
            folderConfig.setVersionQualifier(null);
            ResourceFolderType resourceFolderType = context.getResourceFolderType();
            if (resourceFolderType == null) {
                File file = context.file;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(((Object)file).toString());
            }
            ResourceFolderType resourceFolderType2 = resourceFolderType;
            String newFolderName = folderConfig.getFolderName(resourceFolderType2);
            String message2 = "This folder configuration (`v" + folderVersion + "`) is unnecessary; `minSdkVersion` is " + minSdkVersion.getApiString() + ". Merge all the resources in this folder into `" + newFolderName + "`.";
            Location location = Location.Companion.create(context.file);
            LintFix.Builder builder = this.fix();
            Object[] objectArray = new Object[6];
            objectArray[0] = KEY_FILE;
            objectArray[1] = context.file;
            objectArray[2] = KEY_FOLDER_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)newFolderName, (String)"newFolderName");
            objectArray[3] = newFolderName;
            objectArray[4] = KEY_REQUIRES_API;
            objectArray[5] = minSdkVersion.getApiLevel();
            context.report(new Incident(OBSOLETE_SDK, message2, location, builder.data(objectArray)));
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final int getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApi(scope, isApiLevelAnnotation);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<UAnnotation, Integer> getTargetApiAnnotation(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
        return Companion.getTargetApiAnnotation(scope, isApiLevelAnnotation);
    }

    @JvmStatic
    public static final int getApiLevel(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull String qualifiedName) {
        return Companion.getApiLevel(context, annotation, qualifiedName);
    }

    @JvmStatic
    @JvmOverloads
    public static final int getTargetApi(@Nullable UElement scope) {
        return Companion.getTargetApi(scope);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pair<UAnnotation, Integer> getTargetApiAnnotation(@Nullable UElement scope) {
        return Companion.getTargetApiAnnotation(scope);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        Implementation implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.RESOURCE_FILE, (Enum)Scope.MANIFEST), enumSetArray);
        UNSUPPORTED = Issue.Companion.create$default((Issue.Companion)companion, (String)"NewApi", (String)"Calling new methods on older versions", (String)"\n                This check scans through all the Android API calls in the application and \\\n                warns about any calls that are not available on **all** versions targeted by \\\n                this application (according to its minimum SDK attribute in the manifest).\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n\n                If you are deliberately setting `android:` attributes in style definitions, \\\n                make sure you place this in a `values-v`*NN* folder in order to avoid running \\\n                into runtime conflicts on certain devices where manufacturers have added \\\n                custom attributes whose ids conflict with the new ones on later platforms.\n\n                Similarly, you can use tools:targetApi=\"11\" in an XML file to indicate that \\\n                the element will only be inflated in an adequate context.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = JAVA_IMPLEMENTATION;
        INLINED = Issue.Companion.create$default((Issue.Companion)companion, (String)"InlinedApi", (String)"Using inlined constants on older versions", (String)"\n                This check scans through all the Android API field references in the \\\n                application and flags certain constants, such as static final integers and \\\n                Strings, which were introduced in later versions. These will actually be \\\n                copied into the class files rather than being referenced, which means that \\\n                the value is available even when running on older devices. In some cases \\\n                that's fine, and in other cases it can result in a runtime crash or \\\n                incorrect behavior. It depends on the context, so consider the code carefully \\\n                and decide whether it's safe and can be suppressed or whether the code needs \\\n                to be guarded.\n\n                If you really want to use this API and don't need to support older devices \\\n                just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` \\\n                files.\n\n                If your code is **deliberately** accessing newer APIs, and you have ensured \\\n                (e.g. with conditional execution) that this code will only ever be called on \\\n                a supported platform, then you can annotate your class or method with the \\\n                `@TargetApi` annotation specifying the local minimum SDK to apply, such as \\\n                `@TargetApi(11)`, such that this check considers 11 rather than your manifest \\\n                file's minimum SDK as the required API level.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = JAVA_IMPLEMENTATION;
        OVERRIDE = Issue.Companion.create$default((Issue.Companion)companion, (String)"Override", (String)"Method conflicts with new inherited method", (String)"\n                Suppose you are building against Android API 8, and you've subclassed \\\n                Activity. In your subclass you add a new method called `isDestroyed`(). \\\n                At some later point, a method of the same name and signature is added to \\\n                Android. Your method will now override the Android method, and possibly break \\\n                its contract. Your method is not calling `super.isDestroyed()`, since your \\\n                compilation target doesn't know about the method.\n\n                The above scenario is what this lint detector looks for. The above example is \\\n                real, since `isDestroyed()` was added in API 17, but it will be true for \\\n                **any** method you have added to a subclass of an Android class where your \\\n                build target is lower than the version the method was introduced in.\n\n                To fix this, either rename your method, or if you are really trying to augment \\\n                the builtin method if available, switch to a higher build target where you can \\\n                deliberately add `@Override` on your overriding method, and call `super` if \\\n                appropriate etc.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.RESOURCE_FOLDER_SCOPE};
        implementation = new Implementation(ApiDetector.class, EnumSet.of((Enum)Scope.RESOURCE_FILE, (Enum)Scope.RESOURCE_FOLDER), enumSetArray);
        UNUSED = Issue.Companion.create$default((Issue.Companion)companion, (String)"UnusedAttribute", (String)"Attribute unused on older versions", (String)"\n                This check finds attributes set in XML files that were introduced in a version \\\n                newer than the oldest version targeted by your application (with the \\\n                `minSdkVersion` attribute).\n\n                This is not an error; the application will simply ignore the attribute. \\\n                However, if the attribute is important to the appearance or functionality of \\\n                your application, you should consider finding an alternative way to achieve the \\\n                same result with only available attributes, and then you can optionally create \\\n                a copy of the layout in a layout-vNN folder which will be used on API NN or \\\n                higher where you can take advantage of the newer attribute.\n\n                Note: This check does not only apply to attributes. For example, some tags can \\\n                be unused too, such as the new `<tag>` element in layouts introduced in API 21.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = JAVA_IMPLEMENTATION;
        OBSOLETE_SDK = Issue.Companion.create$default((Issue.Companion)companion, (String)"ObsoleteSdkInt", (String)"Obsolete SDK_INT Version Check", (String)"\n                This check flags version checks that are not necessary, because the \\\n                `minSdkVersion` (or surrounding known API level) is already at least as high \\\n                as the version checked for.\n\n                Similarly, it also looks for resources in `-vNN` folders, such as `values-v14` \\\n                where the version qualifier is less than or equal to the `minSdkVersion`, \\\n                where the contents should be merged into the best folder.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        NO_ANNOTATION_FOUND = TuplesKt.to(null, (Object)-1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\"\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0002J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002Jv\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\b2\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\b2\u0006\u00104\u001a\u0002052\b\b\u0002\u00106\u001a\u0002052\n\b\u0002\u00107\u001a\u0004\u0018\u000108H\u0002Jz\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u00109\u001a\u00020\b2\u0006\u00104\u001a\u0002052\u0006\u0010:\u001a\u0002052\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\b2\n\b\u0002\u00107\u001a\u0004\u0018\u000108J\u0010\u0010;\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020@H\u0016J \u0010A\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010B\u001a\u00020\u0010H\u0002J\u0010\u0010C\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010D\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0016H\u0016J\u0010\u0010U\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020@H\u0002J\u0010\u0010V\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020WH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$ApiVisitor;", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/checks/ApiDetector;Lcom/android/tools/lint/detector/api/JavaContext;)V", "canBeDesugaredLater", "", "owner", "", "name", "checkAnimator", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "checkCast", "node", "Lorg/jetbrains/uast/UElement;", "classType", "Lcom/intellij/psi/PsiClassType;", "interfaceType", "checkCatchTypeElement", "statement", "Lorg/jetbrains/uast/UTryExpression;", "typeReference", "Lorg/jetbrains/uast/UTypeReferenceExpression;", "type", "Lcom/intellij/psi/PsiType;", "checkClass", "element", "cls", "Lcom/intellij/psi/PsiClass;", "descriptor", "fqcn", "checkClassReference", "checkClassType", "checkField", "field", "Lcom/intellij/psi/PsiField;", "checkMethodReference", "expression", "Lorg/jetbrains/uast/UReferenceExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "formatString", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "desc", "requires", "", "min", "desugaring", "Lcom/android/tools/lint/detector/api/Desugaring;", "sig", "minSdk", "visitArrayAccessExpression", "Lorg/jetbrains/uast/UArrayAccessExpression;", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "visitBinaryExpressionWithType", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "visitCall", "reference", "visitCallExpression", "visitCallableReferenceExpression", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitClassLiteralExpression", "Lorg/jetbrains/uast/UClassLiteralExpression;", "visitForEachExpression", "Lorg/jetbrains/uast/UForEachExpression;", "visitLocalVariable", "Lorg/jetbrains/uast/ULocalVariable;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitSwitchExpression", "Lorg/jetbrains/uast/USwitchExpression;", "visitTryExpression", "visitTypeCastExpression", "visitUnaryExpression", "Lorg/jetbrains/uast/UUnaryExpression;", "lint-checks"})
    private final class ApiVisitor
    extends UElementHandler {
        @NotNull
        private final JavaContext context;

        public ApiVisitor(JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)((Object)ApiDetector.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        public final void report(@NotNull Issue issue, @NotNull UElement node, @NotNull Location location, @NotNull String type, @NotNull String sig, int requires, int minSdk, @Nullable LintFix fix, @Nullable String owner, @Nullable String name, @Nullable String desc, @Nullable Desugaring desugaring) {
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)sig, (String)"sig");
            String apiLevel = ApiDetector.this.getApiLevelString(requires, this.context);
            String typeString = StringHelper.usLocaleCapitalize((String)type);
            String formatString = typeString + " requires API level " + apiLevel + " (current min is %1$s): `" + sig + '`';
            this.report(issue, node, location, formatString, fix, owner, name, desc, requires, minSdk, desugaring);
        }

        public static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string, String string2, int n, int n2, LintFix lintFix, String string3, String string4, String string5, Desugaring desugaring, int n3, Object object) {
            if ((n3 & 0x80) != 0) {
                lintFix = null;
            }
            if ((n3 & 0x100) != 0) {
                string3 = null;
            }
            if ((n3 & 0x200) != 0) {
                string4 = null;
            }
            if ((n3 & 0x400) != 0) {
                string5 = null;
            }
            if ((n3 & 0x800) != 0) {
                desugaring = null;
            }
            apiVisitor.report(issue, uElement, location, string, string2, n, n2, lintFix, string3, string4, string5, desugaring);
        }

        private final void report(Issue issue, UElement node, Location location, String formatString, LintFix fix, String owner, String name, String desc, int requires, int min, Desugaring desugaring) {
            if (ApiDetector.this.isLibraryDesugared((Context)this.context, owner, name)) {
                return;
            }
            Incident incident = new Incident(issue, (Object)node, location, "", fix);
            LintMap lintMap = ApiDetector.this.map();
            boolean bl = false;
            boolean bl2 = false;
            LintMap $this$report_u24lambda_u2d1 = lintMap;
            boolean bl3 = false;
            $this$report_u24lambda_u2d1.put(ApiDetector.KEY_REQUIRES_API, requires);
            int n = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, node, null, 2, null);
            boolean bl4 = false;
            $this$report_u24lambda_u2d1.put(ApiDetector.KEY_MIN_API, Math.max(min, n));
            $this$report_u24lambda_u2d1.put(ApiDetector.KEY_MESSAGE, formatString);
            if (owner != null && this.canBeDesugaredLater(owner, name)) {
                $this$report_u24lambda_u2d1.put(ApiDetector.KEY_OWNER, owner);
                String string = name;
                if (string != null) {
                    String string2 = string;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    String it = string2;
                    boolean bl7 = false;
                    $this$report_u24lambda_u2d1.put(ApiDetector.KEY_NAME, it);
                }
            }
            if (desugaring != null) {
                $this$report_u24lambda_u2d1.put(ApiDetector.KEY_DESUGAR, desugaring.getConstant());
            }
            LintMap map = lintMap;
            this.context.report(incident, map);
        }

        static /* synthetic */ void report$default(ApiVisitor apiVisitor, Issue issue, UElement uElement, Location location, String string, LintFix lintFix, String string2, String string3, String string4, int n, int n2, Desugaring desugaring, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                lintFix = null;
            }
            if ((n3 & 0x20) != 0) {
                string2 = null;
            }
            if ((n3 & 0x40) != 0) {
                string3 = null;
            }
            if ((n3 & 0x80) != 0) {
                string4 = null;
            }
            if ((n3 & 0x200) != 0) {
                n2 = 1;
            }
            if ((n3 & 0x400) != 0) {
                desugaring = null;
            }
            apiVisitor.report(issue, uElement, location, string, lintFix, string2, string3, string4, n, n2, desugaring);
        }

        private final boolean canBeDesugaredLater(String owner, String name) {
            Project project = this.context.isGlobalAnalysis() ? this.context.getMainProject() : this.context.getProject();
            return owner != null && (StringsKt.startsWith$default((String)owner, (String)"java/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)owner, (String)"java.", (boolean)false, (int)2, null)) && !project.isDesugaring(Desugaring.JAVA_8_LIBRARY);
        }

        public void visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiField) {
                this.checkField((UElement)node, (PsiField)resolved);
            } else if (resolved instanceof PsiMethod && node instanceof UCallExpression) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        public void visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiMethod) {
                this.checkMethodReference((UReferenceExpression)node, (PsiMethod)resolved);
            }
        }

        private final void checkMethodReference(UReferenceExpression expression, PsiMethod method) {
            PsiClass psiClass;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass2 = method.getContainingClass();
            if (psiClass2 == null) {
                return;
            }
            PsiClass containingClass = psiClass = psiClass2;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(containingClass);
            if (string == null) {
                return;
            }
            String owner = string;
            if (!apiDatabase.containsClass(owner)) {
                return;
            }
            String name = Lint.getInternalMethodName((PsiMethod)method);
            String string2 = evaluator.getMethodDescription(method, false, false);
            if (string2 == null) {
                return;
            }
            String desc = string2;
            int api = apiDatabase.getMethodVersion(owner, name, desc);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (Companion.isSuppressed(this.context, api, (UElement)expression, minSdk)) {
                return;
            }
            String signature = expression.asSourceString();
            Location location = this.context.getLocation((UElement)expression);
            ApiVisitor.report$default(this, UNSUPPORTED, (UElement)expression, location, "Method reference", signature, api, minSdk, Companion.apiLevelFix(api), owner, name, desc, null, 2048, null);
        }

        public void visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
            PsiType type;
            UTypeReferenceExpression typeReference;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isTypeCast((UElement)((UElement)node))) {
                this.visitTypeCastExpression(node);
            } else if (UastExpressionUtils.isInstanceCheck((UElement)((UElement)node)) && (typeReference = node.getTypeReference()) != null && (type = typeReference.getType()) instanceof PsiClassType) {
                this.checkClassReference((UElement)typeReference, (PsiClassType)type);
            }
        }

        private final void visitTypeCastExpression(UBinaryExpressionWithType expression) {
            UExpression operand = expression.getOperand();
            PsiType operandType = operand.getExpressionType();
            PsiType castType = expression.getType();
            if (Intrinsics.areEqual((Object)castType, (Object)operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            UTypeReferenceExpression typeReference = expression.getTypeReference();
            if (typeReference != null && !this.checkClassReference((UElement)typeReference, (PsiClassType)castType)) {
                return;
            }
            this.checkCast((UElement)expression, (PsiClassType)operandType, (PsiClassType)castType);
        }

        private final boolean checkClassReference(UElement node, PsiClassType classType) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return true;
            }
            ApiLookup apiDatabase = apiLookup;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(classType);
            if (string == null) {
                return true;
            }
            String expressionOwner = string;
            int api = apiDatabase.getClassVersion(expressionOwner);
            if (api == -1) {
                return true;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (Companion.isSuppressed(this.context, api, node, minSdk)) {
                return true;
            }
            Location location = this.context.getLocation(node);
            ApiVisitor.report$default(this, UNSUPPORTED, node, location, "Class", expressionOwner, api, minSdk, Companion.apiLevelFix(api), expressionOwner, null, null, null, 3584, null);
            return false;
        }

        private final void checkCast(UElement node, PsiClassType classType, PsiClassType interfaceType) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            if (Intrinsics.areEqual((Object)classType, (Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String classTypeInternal = evaluator.getQualifiedName(classType);
            String interfaceTypeInternal = evaluator.getQualifiedName(interfaceType);
            if (interfaceTypeInternal == null || classTypeInternal == null) {
                return;
            }
            if (ApiLookup.equivalentName(interfaceTypeInternal, "java/lang/Object")) {
                return;
            }
            int api = apiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (api <= minSdk) {
                return;
            }
            if (Companion.isSuppressed(this.context, api, node, minSdk)) {
                return;
            }
            UElement curr = node;
            while (true) {
                Object condition;
                UElement uElement;
                if ((uElement = curr) instanceof UIfExpression) {
                    PsiType type;
                    if (UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)((UIfExpression)curr).getThenExpression()), (boolean)true) && (condition = UastUtils.skipParenthesizedExprDown((UExpression)((UIfExpression)curr).getCondition())) instanceof UBinaryExpressionWithType && Intrinsics.areEqual((Object)(type = ((UBinaryExpressionWithType)condition).getType()), (Object)interfaceType)) {
                        return;
                    }
                } else if (uElement instanceof USwitchClauseExpressionWithBody) {
                    if (UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)((USwitchClauseExpressionWithBody)curr).getBody()), (boolean)true)) {
                        condition = ((USwitchClauseExpressionWithBody)curr).getCaseValues().iterator();
                        while (condition.hasNext()) {
                            PsiType type;
                            UExpression uExpression = (UExpression)condition.next();
                            UExpression condition2 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression);
                            if (!(condition2 instanceof UBinaryExpressionWithType) || !Intrinsics.areEqual((Object)(type = ((UBinaryExpressionWithType)condition2).getType()), (Object)interfaceType)) continue;
                            return;
                        }
                    }
                } else if (uElement instanceof UMethod) break;
                if ((uElement = curr.getUastParent()) == null) break;
                curr = uElement;
            }
            Location location = this.context.getLocation(node);
            String message2 = null;
            String to = interfaceType.getClassName();
            String from = classType.getClassName();
            message2 = Intrinsics.areEqual((Object)interfaceTypeInternal, (Object)classTypeInternal) ? "Cast to `" + to + "` requires API level " + api + " (current min is %1$d)" : "Cast from `" + from + "` to `" + to + "` requires API level " + api + " (current min is %1$d)";
            ApiVisitor.report$default(this, UNSUPPORTED, node, location, message2, Companion.apiLevelFix(api), classTypeInternal, null, null, api, minSdk, null, 1216, null);
        }

        public void visitMethod(@NotNull UMethod node) {
            Object fqcn;
            PsiClass psiClass;
            PsiClass cls;
            String string;
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass containingClass = node.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && !this.context.getProject().isDesugaring(Desugaring.INTERFACE_METHODS)) {
                int minSdk;
                int api;
                PsiModifierList psiModifierList = node.getModifierList();
                Intrinsics.checkNotNullExpressionValue((Object)psiModifierList, (String)"node.modifierList");
                PsiModifierList methodModifierList = psiModifierList;
                if ((methodModifierList.hasExplicitModifier("default") || methodModifierList.hasExplicitModifier("static")) && !Companion.isSuppressed(this.context, api = 24, (UElement)node, minSdk = ApiDetector.this.getMinSdk((Context)this.context))) {
                    Location location = this.context.getLocation(node);
                    String desc = methodModifierList.hasExplicitModifier("default") ? "Default method" : "Static interface method";
                    ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, desc, containingClass.getName() + '#' + node.getName(), api, minSdk, Companion.apiLevelFix(api), containingClass.getQualifiedName(), null, null, Desugaring.INTERFACE_METHODS, 1536, null);
                }
            }
            int buildSdk = this.context.getProject().getBuildSdk();
            String name = node.getName();
            JavaEvaluator evaluator = this.context.getEvaluator();
            PsiMethod superMethod = evaluator.getSuperMethod((PsiMethod)node);
            while (superMethod != null && (object = superMethod.getContainingClass()) != null && (string = (cls = (psiClass = object)).getQualifiedName()) != null && (StringsKt.startsWith$default((String)(fqcn = (object = string)), (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)fqcn, (String)"java.", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)fqcn, (Object)"java.lang.Object") || StringsKt.startsWith$default((String)fqcn, (String)"javax.", (boolean)false, (int)2, null))) {
                String desc = evaluator.getMethodDescription(superMethod, false, false);
                if (desc != null) {
                    String string2 = evaluator.getQualifiedName(cls);
                    if (string2 == null) {
                        return;
                    }
                    String owner = string2;
                    int api = apiDatabase.getMethodVersion(owner, name, desc);
                    if (api > buildSdk && buildSdk != -1) {
                        if (this.context.getDriver().isSuppressed(this.context, OVERRIDE, (UElement)node)) {
                            return;
                        }
                        if (containingClass != null) {
                            String className = containingClass.getName();
                            String fullClassName = containingClass.getQualifiedName();
                            if (fullClassName != null) {
                                className = fullClassName;
                            }
                            fqcn = className + '#' + name;
                        } else {
                            fqcn = name;
                        }
                        String message2 = "This method is not overriding anything with the current build target, but will in API level " + api + " (current target is " + buildSdk + "): `" + (String)fqcn + '`';
                        PsiElement locationNode = (PsiElement)node.getNameIdentifier();
                        if (locationNode == null) {
                            locationNode = (PsiElement)node;
                        }
                        Location location = this.context.getLocation(locationNode);
                        this.context.report(new Incident(OVERRIDE, (Object)node, location, message2));
                    }
                }
                superMethod = evaluator.getSuperMethod(superMethod);
            }
        }

        public void visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.isAnnotationType() && !this.context.getProject().isDesugaring(Desugaring.TYPE_ANNOTATIONS)) {
                JavaEvaluator evaluator = this.context.getEvaluator();
                for (UAnnotation annotation : JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)node), (boolean)false, null, (int)4, null)) {
                    int minSdk;
                    int api;
                    String name = annotation.getQualifiedName();
                    if (!Intrinsics.areEqual((Object)"java.lang.annotation.Repeatable", (Object)name) || Companion.isSuppressed(this.context, api = 24, (UElement)node, minSdk = ApiDetector.this.getMinSdk((Context)this.context))) continue;
                    Location location = this.context.getLocation((UElement)annotation);
                    int n = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)node, null, 2, null);
                    boolean bl = false;
                    int min = Math.max(minSdk, n);
                    Issue issue = UNSUPPORTED;
                    LintFix lintFix = Companion.apiLevelFix(api);
                    Incident incident = new Incident(issue, (Object)annotation, location, "", lintFix);
                    lintFix = ApiDetector.this.map();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    LintFix $this$visitClass_u24lambda_u2d2 = lintFix;
                    boolean bl4 = false;
                    $this$visitClass_u24lambda_u2d2.put(ApiDetector.KEY_REQUIRES_API, api);
                    $this$visitClass_u24lambda_u2d2.put(ApiDetector.KEY_MIN_API, min);
                    $this$visitClass_u24lambda_u2d2.put(ApiDetector.KEY_MESSAGE, "Repeatable annotation requires API level " + api + " (current min is %1$d)");
                    $this$visitClass_u24lambda_u2d2.put(ApiDetector.KEY_DESUGAR, Desugaring.TYPE_ANNOTATIONS.getConstant());
                    LintFix map = lintFix;
                    this.context.report(incident, (LintMap)map);
                }
            }
            for (UTypeReferenceExpression typeReferenceExpression : node.getUastSuperTypes()) {
                PsiClass cls;
                PsiType type = typeReferenceExpression.getType();
                if (!(type instanceof PsiClassType) || (cls = ((PsiClassType)type).resolve()) == null) continue;
                this.checkClass((UElement)typeReferenceExpression, cls);
            }
        }

        public void visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiType type = node.getType();
            if (type instanceof PsiClassType) {
                UExpression lhs = node.getExpression();
                UExpression uExpression = lhs;
                UExpression locationElement = uExpression == null ? (UExpression)node : uExpression;
                this.checkClassType((UElement)locationElement, (PsiClassType)type, null);
            }
        }

        private final void checkClassType(UElement element, PsiClassType classType, String descriptor) {
            String owner = this.context.getEvaluator().getQualifiedName(classType);
            String string = classType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classType.canonicalText");
            String fqcn = string;
            if (owner != null) {
                this.checkClass(element, descriptor, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, PsiClass cls) {
            String string = this.context.getEvaluator().getQualifiedName(cls);
            if (string == null) {
                return;
            }
            String owner = string;
            String fqcn = cls.getQualifiedName();
            if (fqcn != null) {
                this.checkClass(element, null, owner, fqcn);
            }
        }

        private final void checkClass(UElement element, String descriptor, String owner, String fqcn) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            int api = apiDatabase.getClassVersion(owner);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (Companion.isSuppressed(this.context, api, element, minSdk)) {
                return;
            }
            if (UastUtils.getParentOfType$default((UElement)element, UAnnotation.class, (boolean)false, (int)2, null) != null) {
                return;
            }
            Location location = this.context.getNameLocation(element);
            String string = descriptor;
            String desc = string == null ? "Class" : string;
            ApiVisitor.report$default(this, UNSUPPORTED, element, location, desc, fqcn, api, minSdk, Companion.apiLevelFix(api), owner, null, null, null, 3584, null);
        }

        public void visitForEachExpression(@NotNull UForEachExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            UExpression value = node.getIteratedValue();
            JavaEvaluator evaluator = this.context.getEvaluator();
            PsiType type = value.getExpressionType();
            if (type instanceof PsiClassType) {
                PsiClass containingClass;
                PsiElement keySet;
                String string = evaluator.getQualifiedName((PsiClassType)type);
                if (string == null) {
                    return;
                }
                String expressionOwner = string;
                int api = apiDatabase.getClassVersion(expressionOwner);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
                if (Companion.isSuppressed(this.context, api, (UElement)node, minSdk)) {
                    return;
                }
                Location location = this.context.getLocation((UElement)value);
                String message2 = "The type of the for loop iterated value is " + ((PsiClassType)type).getCanonicalText() + ", which requires API level " + api + " (current min is %1$d)";
                if (value instanceof UQualifiedReferenceExpression && Intrinsics.areEqual((Object)"keySet", (Object)((UQualifiedReferenceExpression)value).getResolvedName()) && (keySet = ((UQualifiedReferenceExpression)value).resolve()) instanceof PsiMethod && (containingClass = ((PsiMethod)keySet).getContainingClass()) != null && Intrinsics.areEqual((Object)"java.util.concurrent.ConcurrentHashMap", (Object)containingClass.getQualifiedName())) {
                    message2 = Intrinsics.stringPlus((String)message2, (Object)"; to work around this, add an explicit cast to `(Map)` before the `keySet` call.");
                }
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, location, message2, Companion.apiLevelFix(api), expressionOwner, null, null, api, minSdk, null, 1216, null);
            }
        }

        public void visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolve();
            if (method != null) {
                this.visitCall(method, node, (UElement)node);
            }
        }

        private final void visitCall(PsiMethod method, UCallExpression call, UElement reference) {
            Location location;
            UExpression receiver;
            PsiClass psiClass;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass psiClass2 = method.getContainingClass();
            if (psiClass2 == null) {
                return;
            }
            PsiClass containingClass = psiClass = psiClass2;
            psiClass2 = method.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"method.parameterList");
            PsiClass parameterList = psiClass2;
            if (parameterList.getParametersCount() > 0) {
                PsiParameter[] parameters = parameterList.getParameters();
                List arguments = call.getValueArguments();
                int n = 0;
                int n2 = parameters.length + -1;
                if (n <= n2) {
                    do {
                        int i = n++;
                        PsiType psiType = parameters[i].getType();
                        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"parameters[i].type");
                        PsiType parameterType = psiType;
                        if (!(parameterType instanceof PsiClassType)) continue;
                        if (i >= arguments.size()) break;
                        UExpression argument = (UExpression)arguments.get(i);
                        PsiType argumentType = argument.getExpressionType();
                        if (argumentType == null || Intrinsics.areEqual((Object)parameterType, (Object)argumentType) || !(argumentType instanceof PsiClassType) || Intrinsics.areEqual((Object)((PsiClassType)parameterType).rawType(), (Object)((PsiClassType)argumentType).rawType())) continue;
                        this.checkCast((UElement)argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                    } while (n <= n2);
                }
            }
            if (!(method instanceof PsiCompiledElement)) {
                return;
            }
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string = evaluator.getQualifiedName(containingClass);
            if (string == null) {
                return;
            }
            String owner = string;
            if (ApiLookup.startsWithEquivalentPrefix(owner, "android/support/")) {
                return;
            }
            if (!apiDatabase.containsClass(owner)) {
                return;
            }
            String name = Lint.getInternalMethodName((PsiMethod)method);
            String i = evaluator.getMethodDescription(method, false, false);
            if (i == null) {
                return;
            }
            String desc = i;
            if (ApiLookup.startsWithEquivalentPrefix(owner, "java/text/SimpleDateFormat") && Intrinsics.areEqual((Object)name, (Object)"<init>") && !Intrinsics.areEqual((Object)desc, (Object)"()V")) {
                Companion.checkSimpleDateFormat(this.context, call, ApiDetector.this.getMinSdk((Context)this.context));
            } else if (Intrinsics.areEqual((Object)name, (Object)"loadAnimator") && Intrinsics.areEqual((Object)owner, (Object)"android.animation.AnimatorInflater") && Intrinsics.areEqual((Object)desc, (Object)"(Landroid.content.Context;I)")) {
                this.checkAnimator(this.context, call);
            }
            int api = apiDatabase.getMethodVersion(owner, name, desc);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
            if (api <= minSdk) {
                return;
            }
            String fqcn = containingClass.getQualifiedName();
            UExpression uExpression = receiver = UastExpressionUtils.isMethodCall((UElement)((UElement)call)) ? call.getReceiver() : (UExpression)null;
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)call))) {
                if (receiver != null && !(receiver instanceof UThisExpression) && !(receiver instanceof PsiSuperExpression)) {
                    PsiClassType containingType;
                    List inheritanceChain;
                    PsiType receiverType = receiver.getExpressionType();
                    if (receiverType instanceof PsiClassType && (inheritanceChain = Companion.getInheritanceChain((PsiClassType)receiverType, containingType = this.context.getEvaluator().getClassType(containingClass))) != null) {
                        for (PsiClassType type : inheritanceChain) {
                            String expressionOwner = evaluator.getQualifiedName(type);
                            if (expressionOwner == null || Intrinsics.areEqual((Object)expressionOwner, (Object)owner)) continue;
                            int specificApi = apiDatabase.getMethodVersion(expressionOwner, name, desc);
                            if (specificApi == -1) {
                                if (!apiDatabase.isRelevantOwner(expressionOwner)) continue;
                                return;
                            }
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = type.getCanonicalText();
                            }
                            boolean bl = false;
                            api = Math.min(specificApi, api);
                        }
                    }
                } else {
                    UInstanceExpression pte;
                    PsiElement resolved;
                    PsiClass cls = null;
                    PsiType receiverType = call.getReceiverType();
                    if (receiverType instanceof PsiClassType) {
                        cls = ((PsiClassType)receiverType).resolve();
                    }
                    if ((receiver instanceof UThisExpression || receiver instanceof USuperExpression) && (resolved = (pte = (UInstanceExpression)receiver).resolve()) instanceof PsiClass) {
                        cls = (PsiClass)resolved;
                    }
                    while (cls != null) {
                        String expressionOwner;
                        if (cls instanceof PsiAnonymousClass) {
                            boolean found = false;
                            PsiClassType type = ((PsiAnonymousClass)cls).getBaseClassType();
                            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"cls.baseClassType");
                            PsiClassType anonymousBaseType = type;
                            PsiClass anonymousBase = anonymousBaseType.resolve();
                            if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                cls = anonymousBase;
                                found = true;
                            } else {
                                PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)cls), PsiClass.class, (boolean)true);
                                if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                    cls = surroundingBaseType;
                                    found = true;
                                }
                            }
                            if (!found) break;
                        }
                        if ((expressionOwner = evaluator.getQualifiedName(cls)) == null || ApiLookup.equivalentName(expressionOwner, "java/lang/Object")) break;
                        int specificApi = apiDatabase.getMethodVersion(expressionOwner, name, desc);
                        if (specificApi == -1) {
                            if (apiDatabase.isRelevantOwner(expressionOwner)) {
                                break;
                            }
                        } else {
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = cls.getQualifiedName();
                            }
                            boolean bl = false;
                            api = Math.min(specificApi, api);
                            break;
                        }
                        cls = cls.getSuperClass();
                    }
                }
            }
            if (Companion.isSuppressed(this.context, api, reference, minSdk)) {
                return;
            }
            if (receiver != null || UastExpressionUtils.isMethodCall((UElement)((UElement)call))) {
                PsiMethod[] methods;
                PsiClass target2 = null;
                if (!method.isConstructor()) {
                    PsiType type;
                    if (receiver != null) {
                        type = receiver.getExpressionType();
                        if (type instanceof PsiClassType) {
                            target2 = ((PsiClassType)type).resolve();
                        }
                    } else {
                        type = UastUtils.getContainingUClass((UElement)((UElement)call));
                        PsiClass psiClass3 = target2 = type == null ? null : type.getJavaPsi();
                    }
                }
                if (target2 != null && (methods = target2.findMethodsBySignature(method, true)).length > 1) {
                    Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
                    for (PsiMethod m : methods) {
                        int methodApi;
                        String methodOwner;
                        PsiClass provider;
                        if (Intrinsics.areEqual((Object)method, (Object)m) || (provider = m.getContainingClass()) == null || (methodOwner = evaluator.getQualifiedName(provider)) == null || (methodApi = apiDatabase.getMethodVersion(methodOwner, name, desc)) != -1 && methodApi > minSdk) continue;
                        return;
                    }
                }
                if (receiver instanceof USuperExpression) {
                    PsiMethod containingMethod;
                    UMethod expressionOwner = UastUtils.getContainingUMethod((UElement)((UElement)call));
                    PsiMethod psiMethod = containingMethod = expressionOwner == null ? null : expressionOwner.getJavaPsi();
                    if (containingMethod != null && Intrinsics.areEqual((Object)name, (Object)containingMethod.getName()) && evaluator.areSignaturesEqual(method, containingMethod) && !method.isConstructor()) {
                        return;
                    }
                }
            }
            if (DesugaredMethodLookup.Companion.isDesugared(owner, name, desc)) {
                return;
            }
            Desugaring desugaring = null;
            if (api == 19 && Intrinsics.areEqual((Object)owner, (Object)"java.lang.Throwable") && (Intrinsics.areEqual((Object)name, (Object)"addSuppressed") && Intrinsics.areEqual((Object)desc, (Object)"(Ljava.lang.Throwable;)") || Intrinsics.areEqual((Object)name, (Object)"getSuppressed") && Intrinsics.areEqual((Object)desc, (Object)"()"))) {
                if (this.context.getProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES)) {
                    return;
                }
                desugaring = Desugaring.TRY_WITH_RESOURCES;
            }
            String signature = fqcn == null ? name : (Intrinsics.areEqual((Object)"<init>", (Object)name) ? (Lint.isKotlin((PsiElement)reference.getSourcePsi()) ? Intrinsics.stringPlus((String)fqcn, (Object)"()") : Intrinsics.stringPlus((String)"new ", (Object)fqcn)) : fqcn + '#' + name);
            UIdentifier nameIdentifier = call.getMethodIdentifier();
            if (UastExpressionUtils.isConstructorCall((UElement)((UElement)call)) && call.getClassReference() != null) {
                UElement uElement = (UElement)call;
                UReferenceExpression uReferenceExpression = call.getClassReference();
                Intrinsics.checkNotNull((Object)uReferenceExpression);
                location = this.context.getRangeLocation(uElement, 0, (UElement)uReferenceExpression, 0);
            } else {
                location = nameIdentifier != null ? this.context.getLocation((UElement)nameIdentifier) : this.context.getLocation(reference);
            }
            Location location2 = location;
            this.report(UNSUPPORTED, reference, location2, "Call", signature, api, minSdk, Companion.apiLevelFix(api), owner, name, desc, desugaring);
        }

        private final void checkAnimator(JavaContext context, UCallExpression call) {
            UExpression resourceParameter = (UExpression)call.getValueArguments().get(1);
            ResourceReference resourceReference = ResourceReference.Companion.get((UElement)resourceParameter);
            if (resourceReference == null) {
                return;
            }
            ResourceReference resource = resourceReference;
            if (Intrinsics.areEqual((Object)resource.getPackage(), (Object)"android")) {
                return;
            }
            int api = 21;
            if (ApiDetector.this.getMinSdk((Context)context) >= api) {
                return;
            }
            if (VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, context, (UElement)call, api, false, 8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context, (UElement)call, api)) {
                return;
            }
            LintClient client = context.getClient();
            boolean full = context.isGlobalAnalysis();
            Project project = full ? context.getMainProject() : context.getProject();
            ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
            List items = resources.getResources(ResourceNamespace.TODO(), resource.getType(), resource.getName());
            Intrinsics.checkNotNullExpressionValue((Object)items, (String)"items");
            Set paths2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)items), (Function1)checkAnimator.paths.1.INSTANCE));
            for (PathString path : paths2) {
                try {
                    XmlPullParser xmlPullParser = client.createXmlPullParser(path);
                    if (xmlPullParser == null) continue;
                    XmlPullParser parser = xmlPullParser;
                    block8: while (true) {
                        int event = parser.next();
                        switch (event) {
                            case 2: {
                                String string;
                                File file;
                                String name;
                                Object object = parser.getName();
                                if (object == null || !Intrinsics.areEqual((Object)(name = object), (Object)ApiDetector.ATTR_PROPERTY_VALUES_HOLDER)) continue block8;
                                object = path.toFile();
                                if (object != null && (file = ((File)object).getParentFile()) != null && (string = file.getName()) != null) {
                                    String string2 = string;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    String nae = string2;
                                    boolean bl3 = false;
                                    FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder((String)nae);
                                    if (folderConfiguration != null) {
                                        FolderConfiguration folderConfiguration2 = folderConfiguration;
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        FolderConfiguration config = folderConfiguration2;
                                        boolean bl6 = false;
                                        VersionQualifier versionQualifier = config.getVersionQualifier();
                                        if (versionQualifier != null && versionQualifier.getVersion() >= api) {
                                            return;
                                        }
                                    }
                                }
                                JavaContext.report$default((JavaContext)context, (Issue)UNSUPPORTED, (UElement)((UElement)call), (Location)context.getLocation((UElement)call), (String)("The resource `" + resource.getType() + '.' + resource.getName() + "` includes the tag `propertyValuesHolder` which causes crashes on API < " + api + ". Consider switching to `AnimatorInflaterCompat.loadAnimator` to safely load the animation."), null, (int)16, null);
                                return;
                            }
                            case 1: {
                                return;
                            }
                        }
                    }
                }
                catch (XmlPullParserException xmlPullParserException) {
                }
                catch (IOException iOException) {
                }
            }
        }

        public void visitLocalVariable(@NotNull ULocalVariable node) {
            PsiClassType psiClassType;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression uExpression = node.getUastInitializer();
            if (uExpression == null) {
                return;
            }
            UExpression initializer = uExpression;
            PsiType psiType = initializer.getExpressionType();
            PsiClassType psiClassType2 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            PsiClassType initializerType = psiClassType;
            PsiType interfaceType = node.getType();
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            if (Intrinsics.areEqual((Object)initializerType, (Object)interfaceType)) {
                return;
            }
            this.checkCast((UElement)initializer, initializerType, (PsiClassType)interfaceType);
        }

        public void visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod psiMethod = Lint.resolveOperator((UArrayAccessExpression)node);
            if (psiMethod == null) {
                return;
            }
            PsiMethod method = psiMethod;
            UCallExpression call = UImplicitCallExpressionKt.asCall((UArrayAccessExpression)node, (PsiMethod)method);
            this.visitCall(method, call, (UElement)node);
        }

        public void visitUnaryExpression(@NotNull UUnaryExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolveOperator();
            if (method != null) {
                UCallExpression call = UImplicitCallExpressionKt.asCall((UUnaryExpression)node, (PsiMethod)method);
                this.visitCall(method, call, (UElement)node);
            }
        }

        public void visitBinaryExpression(@NotNull UBinaryExpression node) {
            UastBinaryOperator operator;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiMethod method = node.resolveOperator();
            if (method != null) {
                UCallExpression call = UImplicitCallExpressionKt.asCall((UBinaryExpression)node, (PsiMethod)method);
                this.visitCall(method, call, (UElement)node);
            }
            if ((operator = node.getOperator()) instanceof UastBinaryOperator.AssignOperator) {
                PsiClassType psiClassType;
                UExpression rExpression = node.getRightOperand();
                PsiType psiType = rExpression.getExpressionType();
                PsiClassType psiClassType2 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                if (psiClassType == null) {
                    return;
                }
                PsiClassType rhsType = psiClassType;
                PsiType interfaceType = node.getLeftOperand().getExpressionType();
                if (!(interfaceType instanceof PsiClassType)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)rhsType, (Object)interfaceType)) {
                    return;
                }
                this.checkCast((UElement)rExpression, rhsType, (PsiClassType)interfaceType);
            }
        }

        public void visitTryExpression(@NotNull UTryExpression node) {
            Issue location;
            int minSdk;
            int api;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List resourceList = node.getResourceVariables();
            Collection collection = resourceList;
            boolean bl = false;
            if (!collection.isEmpty() && !this.context.getProject().isDesugaring(Desugaring.TRY_WITH_RESOURCES) && (api = 19) > (minSdk = ApiDetector.this.getMinSdk((Context)this.context)) && api > com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)node, null, 2, null)) {
                if (Companion.isSuppressed(this.context, api, (UElement)node, minSdk)) {
                    return;
                }
                UVariable first = (UVariable)resourceList.get(0);
                UVariable last = (UVariable)resourceList.get(resourceList.size() - 1);
                location = this.context.getRangeLocation((UDeclaration)first, 0, (UDeclaration)last, 0);
                String message2 = "Try-with-resources requires API level " + api + " (current min is %1$d)";
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)node, (Location)location, message2, Companion.apiLevelFix(api), null, null, null, api, minSdk, Desugaring.TRY_WITH_RESOURCES, 224, null);
            }
            for (UCatchClause catchClause : node.getCatchClauses()) {
                int minSdk2 = ApiDetector.this.getMinSdk((Context)this.context);
                if (minSdk2 < 19 && Companion.isMultiCatchReflectiveOperationException(catchClause)) {
                    if (Companion.isSuppressed(this.context, 19, (UElement)node, minSdk2)) {
                        return;
                    }
                    String message3 = "Multi-catch with these reflection exceptions requires API level 19 (current min is %1$d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.";
                    location = UNSUPPORTED;
                    Location location2 = Companion.getCatchParametersLocation(this.context, catchClause);
                    LintFix lintFix = Companion.apiLevelFix(19);
                    ApiVisitor.report$default(this, location, (UElement)node, location2, message3, lintFix, null, null, null, 19, minSdk2, null, 1248, null);
                    continue;
                }
                for (UTypeReferenceExpression typeReference : catchClause.getTypeReferences()) {
                    this.checkCatchTypeElement(node, typeReference, typeReference.getType());
                }
            }
        }

        private final void checkCatchTypeElement(UTryExpression statement, UTypeReferenceExpression typeReference, PsiType type) {
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            PsiClass resolved = null;
            if (type instanceof PsiClassType) {
                resolved = ((PsiClassType)type).resolve();
            }
            if (resolved != null) {
                LintFix lintFix;
                Object object;
                String string = this.context.getEvaluator().getQualifiedName(resolved);
                if (string == null) {
                    return;
                }
                String signature = string;
                int api = apiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk((Context)this.context);
                if (api <= minSdk) {
                    return;
                }
                UClass containingClass = UastUtils.getContainingUClass((UElement)((UElement)statement));
                if (containingClass != null) {
                    int target2;
                    int n = target2 = minSdk < 19 ? Companion.getTargetApi((UElement)containingClass, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>((Object)Companion){

                        @NotNull
                        public final Boolean invoke(@NotNull String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return com.android.tools.lint.checks.ApiDetector$Companion.access$isRequiresApiAnnotation((Companion)this.receiver, p0);
                        }
                    })) : com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, (UElement)statement, null, 2, null);
                    if (target2 != -1 && api <= target2) {
                        return;
                    }
                }
                if (Companion.isSuppressed(this.context, api, (UElement)statement, minSdk)) {
                    if (minSdk < 19) {
                        UCatchClause clause;
                        String string2;
                        Location location = this.context.getLocation((UElement)typeReference);
                        String fqcn = resolved.getQualifiedName();
                        String apiLevel = ApiDetector.this.getApiLevelString(api, this.context);
                        String apiMessage = StringHelper.usLocaleCapitalize((String)"Exception") + " requires API level " + apiLevel + " (current min is %1$d): `" + ((string2 = fqcn) == null ? "" : string2) + '`';
                        String message2 = Intrinsics.stringPlus((String)apiMessage, (Object)", and having a surrounding/preceding version check **does not** help since prior to API level 19, just **loading** the class will cause a crash. Consider marking the surrounding class with `RequiresApi(19)` to ensure that the class is never loaded except when on API 19 or higher.");
                        Object[] objectArray = new Object[]{ApiDetector.KEY_REQUIRES_API, api, ApiDetector.KEY_REQUIRE_CLASS, true};
                        LintFix fix = ApiDetector.this.fix().data(objectArray);
                        UElement uElement = typeReference.getUastParent();
                        UCatchClause uCatchClause = clause = uElement instanceof UCatchClause ? (UCatchClause)uElement : null;
                        if (clause != null && this.context.getDriver().isSuppressed(this.context, UNSUPPORTED, clause)) {
                            return;
                        }
                        ApiVisitor.report$default(this, UNSUPPORTED, (UElement)typeReference, location, message2, fix, signature, null, null, 19, minSdk, null, 1216, null);
                        return;
                    }
                    return;
                }
                Location location = this.context.getLocation((UElement)typeReference);
                String fqcn = resolved.getQualifiedName();
                if (minSdk < 19) {
                    object = new Object[]{ApiDetector.KEY_REQUIRES_API, api, ApiDetector.KEY_REQUIRE_CLASS, true};
                    lintFix = ApiDetector.this.fix().data((Object[])object);
                } else {
                    object = new Object[]{ApiDetector.KEY_REQUIRES_API, api};
                    lintFix = ApiDetector.this.fix().data((Object[])object);
                }
                LintFix fix = lintFix;
                object = fqcn;
                ApiVisitor.report$default(this, UNSUPPORTED, (UElement)typeReference, location, "Exception", (String)(object == null ? "" : object), api, minSdk, fix, signature, null, null, null, 3584, null);
            }
        }

        public void visitSwitchExpression(@NotNull USwitchExpression node) {
            PsiType type;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression expression = node.getExpression();
            if (expression != null && (type = expression.getExpressionType()) instanceof PsiClassType) {
                this.checkClassType((UElement)expression, (PsiClassType)type, "Enum for switch");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void checkField(UElement node, PsiField field) {
            List conditions;
            UElement parent;
            Issue issue;
            int minSdk;
            int api;
            PsiClass psiClass;
            ApiLookup apiLookup = ApiDetector.this.apiDatabase;
            if (apiLookup == null) {
                return;
            }
            ApiLookup apiDatabase = apiLookup;
            String string = field.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
            String name = string;
            PsiClass psiClass2 = field.getContainingClass();
            if (psiClass2 == null) {
                return;
            }
            PsiClass containingClass = psiClass = psiClass2;
            JavaEvaluator evaluator = this.context.getEvaluator();
            String string2 = evaluator.getQualifiedName(containingClass);
            if (string2 == null) {
                return;
            }
            String owner = string2;
            if (Intrinsics.areEqual((Object)"SDK_INT", (Object)name) && Intrinsics.areEqual((Object)"android.os.Build.VERSION", (Object)owner)) {
                ApiDetector.this.checkObsoleteSdkVersion(this.context, node);
            }
            if ((api = apiDatabase.getFieldVersion(owner, name)) == -1 || api <= (minSdk = ApiDetector.this.getMinSdk((Context)this.context)) || api <= com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, node, null, 2, null)) return;
            Issue issue2 = issue = Lint.isInlined((PsiField)field, (JavaEvaluator)evaluator) ? INLINED : UNSUPPORTED;
            if (Intrinsics.areEqual((Object)issue, (Object)UNSUPPORTED) ? (parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent())) instanceof USwitchClauseExpression && CollectionsKt.contains((Iterable)(conditions = ((USwitchClauseExpression)parent).getCaseValues()), (Object)node) : Intrinsics.areEqual((Object)issue, (Object)INLINED) && Companion.isBenignConstantUsage(evaluator, field, node, name, owner)) {
                return;
            }
            if (Intrinsics.areEqual((Object)owner, (Object)"java.lang.annotation.ElementType") && (parent = (UDeclaration)UastUtils.getParentOfType((UElement)node, UDeclaration.class, (boolean)true)) instanceof UClass && ((UClass)parent).isAnnotationType()) {
                return;
            }
            if (Companion.isSuppressed(this.context, api, node, minSdk)) {
                return;
            }
            parent = node.getUastParent();
            if (parent instanceof UQualifiedReferenceExpression) {
                int specificApi;
                String string3;
                String string4;
                UExpression receiver = ((UQualifiedReferenceExpression)parent).getReceiver();
                PsiType psiType = receiver.getExpressionType();
                String string5 = string4 = psiType == null ? null : psiType.getCanonicalText();
                if (string4 == null) {
                    UReferenceExpression uReferenceExpression = psiType = receiver instanceof UReferenceExpression ? (UReferenceExpression)receiver : null;
                    string3 = psiType == null ? null : UastUtils.getQualifiedName((UReferenceExpression)psiType);
                } else {
                    string3 = string4;
                }
                String string6 = string3;
                int n = specificApi = string6 != null ? apiDatabase.getFieldVersion(string6, name) : -1;
                if (specificApi != -1 && string6 != null) {
                    if (specificApi < api) {
                        api = specificApi;
                        owner = string6;
                    }
                    if (specificApi <= minSdk || specificApi <= com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(Companion, node, null, 2, null)) return;
                    if (Companion.isSuppressed(this.context, specificApi, node, minSdk)) {
                        return;
                    }
                } else if ((specificApi == 28 || specificApi == 29) && Intrinsics.areEqual((Object)string6, (Object)"android.app.TaskInfo")) {
                    return;
                }
            }
            UElement locationNode = node;
            while (locationNode.getUastParent() instanceof UQualifiedReferenceExpression) {
                UElement uElement = locationNode.getUastParent();
                if (uElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.uast.UQualifiedReferenceExpression");
                }
                if (((UQualifiedReferenceExpression)uElement).getSelector() != locationNode) break;
                UElement uElement2 = locationNode.getUastParent();
                locationNode = uElement2 == null ? node : uElement2;
            }
            Location location = this.context.getLocation(locationNode);
            String fqcn = ClassContext.Companion.getFqcn(owner) + '#' + name;
            ApiVisitor.report$default(this, issue, node, location, "Field", fqcn, api, minSdk, Companion.apiLevelFix(api), owner, name, null, null, 3072, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0017H\u0002J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u001a\u00102\u001a\u00020/2\u0006\u0010)\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0004H\u0002J \u00105\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u0004H\u0007J\u0016\u00108\u001a\u0002092\u0006\u0010)\u001a\u00020*2\u0006\u0010:\u001a\u00020;J\"\u0010<\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=2\u0006\u0010?\u001a\u00020>2\b\u0010@\u001a\u0004\u0018\u00010>H\u0002JB\u0010<\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010A2\u0006\u0010?\u001a\u00020>2\b\u0010@\u001a\u0004\u0018\u00010>2\u0016\u0010B\u001a\u0012\u0012\u0004\u0012\u00020D0Cj\b\u0012\u0004\u0012\u00020D`E2\u0006\u0010F\u001a\u00020\u0017H\u0002J\u0010\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020IH\u0002J(\u0010J\u001a\u00020\u00172\b\u0010K\u001a\u0004\u0018\u00010L2\u0014\b\u0002\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020/0NH\u0007J6\u0010O\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00170\u00152\b\u0010K\u001a\u0004\u0018\u00010L2\u0014\b\u0002\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020/0NH\u0007J&\u0010P\u001a\u00020\u00172\b\u0010Q\u001a\u0004\u0018\u00010R2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020/0NH\u0002J$\u0010S\u001a\u00020\u00172\u0006\u00106\u001a\u00020\u00162\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020/0NH\u0002J \u0010T\u001a\u00020/2\u0006\u0010)\u001a\u0002032\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020\u0017H\u0002J0\u0010X\u001a\u00020/2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\b\u0010]\u001a\u0004\u0018\u00010L2\u0006\u0010^\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004J\u000e\u0010`\u001a\u00020/2\u0006\u0010^\u001a\u00020\u0004J \u0010a\u001a\u00020/2\u0006\u0010)\u001a\u0002032\u0006\u0010b\u001a\u00020\u00042\u0006\u0010c\u001a\u00020/H\u0002J\u000e\u0010d\u001a\u00020/2\u0006\u0010:\u001a\u00020;J\u0010\u0010e\u001a\u00020/2\u0006\u0010f\u001a\u00020\u0004H\u0002J\u0010\u0010g\u001a\u00020/2\u0006\u0010h\u001a\u00020DH\u0002J(\u0010i\u001a\u00020/2\u0006\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010H\u001a\u00020L2\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0010\u0010j\u001a\u00020/2\u0006\u0010f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/android/tools/lint/checks/ApiDetector$Companion;", "", "()V", "ANDROIDX_SDK_SUPPRESS_ANNOTATION", "", "ATTR_PROPERTY_VALUES_HOLDER", "INLINED", "Lcom/android/tools/lint/detector/api/Issue;", "JAVA_IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "KEY_CONDITIONAL", "KEY_DESUGAR", "KEY_FILE", "KEY_FOLDER_NAME", "KEY_MESSAGE", "KEY_MIN_API", "KEY_NAME", "KEY_OWNER", "KEY_REQUIRES_API", "KEY_REQUIRE_CLASS", "NO_ANNOTATION_FOUND", "Lkotlin/Pair;", "Lorg/jetbrains/uast/UAnnotation;", "", "OBSOLETE_SDK", "OVERRIDE", "REFLECTIVE_OPERATION_EXCEPTION", "REQUIRES_API_ANNOTATION", "Lcom/android/support/AndroidxName;", "kotlin.jvm.PlatformType", "ROBO_ELECTRIC_CONFIG_ANNOTATION", "SDK_SUPPRESS_ANNOTATION", "TAG_ANIMATED_SELECTOR", "TAG_RIPPLE", "UNSUPPORTED", "UNUSED", "apiLevelFix", "Lcom/android/tools/lint/detector/api/LintFix;", "api", "checkSimpleDateFormat", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "minSdk", "dependsOnAppCompat", "", "project", "Lcom/android/tools/lint/detector/api/Project;", "featureProvidedByGradle", "Lcom/android/tools/lint/detector/api/XmlContext;", "minGradleVersionString", "getApiLevel", "annotation", "qualifiedName", "getCatchParametersLocation", "Lcom/android/tools/lint/detector/api/Location;", "catchClause", "Lorg/jetbrains/uast/UCatchClause;", "getInheritanceChain", "", "Lcom/intellij/psi/PsiClassType;", "derivedClass", "baseClass", "", "visited", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiType;", "Lkotlin/collections/HashSet;", "depth", "getLocalMinSdk", "element", "Lorg/w3c/dom/Element;", "getTargetApi", "scope", "Lorg/jetbrains/uast/UElement;", "isApiLevelAnnotation", "Lkotlin/Function1;", "getTargetApiAnnotation", "getTargetApiForAnnotated", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "getTargetApiForAnnotation", "isAlreadyWarnedDrawableFile", "attribute", "Lorg/w3c/dom/Attr;", "attributeApiLevel", "isBenignConstantUsage", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "field", "Lcom/intellij/psi/PsiField;", "node", "name", "owner", "isBenignUnusedAttribute", "isFrameLayout", "tagName", "defaultValue", "isMultiCatchReflectiveOperationException", "isRequiresApiAnnotation", "fqcn", "isSubclassOfReflectiveOperationException", "type", "isSuppressed", "isTargetAnnotation", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFrameLayout(XmlContext context, String tagName, boolean defaultValue) {
            if (StringsKt.indexOf$default((CharSequence)tagName, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                SdkInfo sdkInfo = context.getClient().getSdkInfo(context.getProject());
                return sdkInfo.isSubViewOf("FrameLayout", tagName);
            }
            UastParser parser = context.getClient().getUastParser(context.getProject());
            JavaEvaluator evaluator = parser.getEvaluator();
            PsiClass psiClass = evaluator.findClass(tagName);
            if (psiClass == null) {
                return defaultValue;
            }
            PsiClass psiClass2 = psiClass;
            return evaluator.extendsClass(psiClass2, "android.widget.FrameLayout", false);
        }

        private final boolean dependsOnAppCompat(Project project) {
            return Intrinsics.areEqual((Object)Boolean.TRUE, (Object)project.dependsOn("com.android.support:appcompat-v7"));
        }

        private final LintFix apiLevelFix(int api) {
            Object[] objectArray = new Object[]{ApiDetector.KEY_REQUIRES_API, api};
            return LintFix.Companion.create().data(objectArray);
        }

        private final boolean isTargetAnnotation(String fqcn) {
            return Intrinsics.areEqual((Object)fqcn, (Object)"android.annotation.TargetApi") || this.isRequiresApiAnnotation(fqcn) || Intrinsics.areEqual((Object)fqcn, (Object)ApiDetector.SDK_SUPPRESS_ANNOTATION) || Intrinsics.areEqual((Object)fqcn, (Object)ApiDetector.ANDROIDX_SDK_SUPPRESS_ANNOTATION) || Intrinsics.areEqual((Object)fqcn, (Object)ApiDetector.ROBO_ELECTRIC_CONFIG_ANNOTATION) || Intrinsics.areEqual((Object)fqcn, (Object)"TargetApi") || StringsKt.startsWith$default((String)fqcn, (String)"android.annotation.", (boolean)false, (int)2, null) && this.isTargetAnnotation(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(fqcn));
        }

        private final boolean isRequiresApiAnnotation(String fqcn) {
            return REQUIRES_API_ANNOTATION.isEquals(fqcn) || Intrinsics.areEqual((Object)fqcn, (Object)"RequiresApi") || StringsKt.startsWith$default((String)fqcn, (String)"android.annotation.", (boolean)false, (int)2, null) && this.isRequiresApiAnnotation(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(fqcn));
        }

        private final boolean isAlreadyWarnedDrawableFile(XmlContext context, Attr attribute, int attributeApiLevel) {
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel == 21) {
                Element element = attribute.getOwnerElement();
                while (element != null) {
                    String root = element.getTagName();
                    if (Intrinsics.areEqual((Object)ApiDetector.TAG_RIPPLE, (Object)root) || Intrinsics.areEqual((Object)"vector", (Object)root) || Intrinsics.areEqual((Object)"animated-vector", (Object)root) || Intrinsics.areEqual((Object)ApiDetector.TAG_ANIMATED_SELECTOR, (Object)root)) {
                        return true;
                    }
                    Node parentNode = element.getParentNode();
                    if (!(parentNode instanceof Element)) break;
                    element = (Element)parentNode;
                }
            }
            return false;
        }

        public final boolean isBenignUnusedAttribute(@NotNull String name) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)ApiDetector.KEY_NAME);
            switch (name) {
                case "labelFor": 
                case "importantForAutofill": 
                case "layout_marginVertical": 
                case "fullBackupContent": 
                case "textIsSelectable": 
                case "roundIcon": 
                case "requestLegacyExternalStorage": 
                case "foregroundServiceType": 
                case "autofilledHighlight": 
                case "paddingVertical": 
                case "layout_marginHorizontal": 
                case "textAlignment": 
                case "autofillHints": 
                case "paddingHorizontal": {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        private final void checkSimpleDateFormat(JavaContext context, UCallExpression call, int minSdk) {
            Object constant;
            Object object;
            Object object2;
            if (minSdk >= 24) {
                return;
            }
            List expressions = call.getValueArguments();
            if (expressions.isEmpty()) {
                return;
            }
            UExpression argument = (UExpression)expressions.get(0);
            ArrayList warned = null;
            char checked = '\u0000';
            UExpression uExpression = argument;
            if (uExpression instanceof ULiteralExpression) {
                object2 = ((ULiteralExpression)argument).getValue();
            } else if (uExpression instanceof UInjectionHost) {
                String string = ((UInjectionHost)argument).evaluateToString();
                Object object3 = object = string == null ? new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument) : string;
                if (object == null) {
                    return;
                }
                object2 = object;
            } else {
                object = new ConstantEvaluator().allowUnknowns().evaluate((UElement)argument);
                if (object == null) {
                    return;
                }
                object2 = constant = object;
            }
            if (constant instanceof String) {
                boolean isEscaped = false;
                int n = 0;
                int n2 = ((String)constant).length();
                if (n < n2) {
                    do {
                        List list;
                        int api;
                        int index;
                        char c;
                        if ((c = ((String)constant).charAt(index = n++)) == '\'') {
                            isEscaped = !isEscaped;
                            continue;
                        }
                        if (!((((c == 'L' ? true : c == 'c') ? true : c == 'Y') ? true : c == 'X') ? true : c == 'u') || isEscaped || c == checked || warned != null && ((List)warned).contains(Character.valueOf(c))) continue;
                        int n3 = api = c == 'L' || c == 'c' ? 9 : 24;
                        if (minSdk >= api) {
                            checked = c;
                            continue;
                        }
                        if (VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, context, (UElement)argument, api, false, 8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context, (UElement)argument, api)) {
                            checked = c;
                            continue;
                        }
                        int end = index + 1;
                        while (end < ((String)constant).length() && ((String)constant).charAt(end) == c) {
                            int n4 = end;
                            end = n4 + 1;
                        }
                        Location location = argument instanceof ULiteralExpression ? context.getRangeLocation((UElement)argument, index, end - index) : (argument instanceof UInjectionHost && argument instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)argument).getOperator(), (Object)UastBinaryOperator.PLUS) && ((UPolyadicExpression)argument).getOperands().size() == 1 && CollectionsKt.first((List)((UPolyadicExpression)argument).getOperands()) instanceof ULiteralExpression ? context.getRangeLocation((UElement)((UPolyadicExpression)argument).getOperands().get(0), index, end - index) : context.getLocation((UElement)argument));
                        Incident incident = new Incident(UNSUPPORTED, (Object)call, location, "", this.apiLevelFix(api));
                        LintMap lintMap = new LintMap();
                        boolean bl = false;
                        boolean bl2 = false;
                        LintMap $this$checkSimpleDateFormat_u24lambda_u2d0 = lintMap;
                        boolean bl3 = false;
                        $this$checkSimpleDateFormat_u24lambda_u2d0.put(ApiDetector.KEY_REQUIRES_API, api);
                        $this$checkSimpleDateFormat_u24lambda_u2d0.put(ApiDetector.KEY_MIN_API, minSdk);
                        $this$checkSimpleDateFormat_u24lambda_u2d0.put(ApiDetector.KEY_MESSAGE, "The pattern character '" + c + "' requires API level " + api + " (current min is %1$d) : \"`" + constant + "`\"");
                        LintMap map = lintMap;
                        context.report(incident, map);
                        List list2 = warned;
                        if (list2 == null) {
                            ArrayList arrayList = new ArrayList();
                            boolean bl4 = false;
                            boolean bl5 = false;
                            ArrayList it = arrayList;
                            boolean bl6 = false;
                            warned = it;
                            list = arrayList;
                        } else {
                            list = list2;
                        }
                        List list3 = list;
                        list3.add(Character.valueOf(c));
                    } while (n < n2);
                }
            }
        }

        private final int getLocalMinSdk(Element element) {
            Element current = element;
            while (true) {
                Node parent;
                String targetApi;
                if ((targetApi = current.getAttributeNS("http://schemas.android.com/tools", "targetApi")) != null) {
                    CharSequence charSequence = targetApi;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        int n;
                        int n2 = targetApi.charAt(0);
                        bl = false;
                        if (Character.isDigit((char)n2)) {
                            try {
                                n2 = Integer.parseInt(targetApi);
                            }
                            catch (NumberFormatException e) {
                                break;
                            }
                            n = n2;
                        } else {
                            n = SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
                        }
                        return n;
                    }
                }
                if ((parent = current.getParentNode()) == null || parent.getNodeType() != 1) break;
                current = (Element)parent;
            }
            return -1;
        }

        private final boolean featureProvidedByGradle(XmlContext context, String minGradleVersionString) {
            GradleVersion minVersion;
            if (minGradleVersionString == null) {
                return false;
            }
            GradleVersion gradleModelVersion = context.getProject().getGradleModelVersion();
            return gradleModelVersion != null && (minVersion = GradleVersion.tryParse((String)minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
        }

        public final boolean isBenignConstantUsage(@NotNull JavaEvaluator evaluator, @NotNull PsiField field, @Nullable UElement node, @NotNull String name, @NotNull String owner) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)name, (String)ApiDetector.KEY_NAME);
            Intrinsics.checkNotNullParameter((Object)owner, (String)ApiDetector.KEY_OWNER);
            if (ApiLookup.equivalentName(owner, "android/os/Build$VERSION_CODES")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android/view/ViewGroup$LayoutParams") && Intrinsics.areEqual((Object)name, (Object)"MATCH_PARENT")) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android/widget/AbsListView") && (Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_NONE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_MULTIPLE") || Intrinsics.areEqual((Object)name, (Object)"CHOICE_MODE_SINGLE"))) {
                return true;
            }
            if (ApiLookup.equivalentName(owner, "android/view/Gravity") && (Intrinsics.areEqual((Object)"START", (Object)name) || Intrinsics.areEqual((Object)"END", (Object)name))) {
                return true;
            }
            if (node == null) {
                return false;
            }
            for (UElement curr = node.getUastParent(); curr != null; curr = curr.getUastParent()) {
                if (curr instanceof USwitchClauseExpression) {
                    List caseValues = ((USwitchClauseExpression)curr).getCaseValues();
                    for (UExpression condition : caseValues) {
                        if (!UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false)) continue;
                        return true;
                    }
                    return false;
                }
                if (curr instanceof UIfExpression) {
                    UExpression condition = ((UIfExpression)curr).getCondition();
                    return UastUtils.isUastChildOf((UElement)node, (UElement)((UElement)condition), (boolean)false);
                }
                if (curr instanceof UMethod || curr instanceof UClass) break;
            }
            return false;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass) {
            if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                return CollectionsKt.emptyList();
            }
            List<PsiClassType> chain = this.getInheritanceChain(derivedClass, baseClass, new HashSet<PsiType>(), 0);
            List<PsiClassType> list = chain;
            if (list != null) {
                CollectionsKt.reverse(list);
            }
            return chain;
        }

        private final List<PsiClassType> getInheritanceChain(PsiClassType derivedClass, PsiClassType baseClass, HashSet<PsiType> visited, int depth) {
            if (Intrinsics.areEqual((Object)derivedClass, (Object)baseClass)) {
                return new ArrayList(depth);
            }
            PsiType[] psiTypeArray = derivedClass.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"derivedClass.superTypes");
            for (PsiType type : psiTypeArray) {
                List<PsiClassType> chain;
                if (!visited.add(type) || !(type instanceof PsiClassType) || (chain = this.getInheritanceChain((PsiClassType)type, baseClass, visited, depth + 1)) == null) continue;
                chain.add(derivedClass);
                return chain;
            }
            return null;
        }

        private final boolean isSuppressed(JavaContext context, int api, UElement element, int minSdk) {
            if (api <= minSdk) {
                return true;
            }
            int target2 = com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, element, null, 2, null);
            if (target2 != -1 && api <= target2) {
                return true;
            }
            LintDriver driver = context.getDriver();
            return driver.isSuppressed(context, UNSUPPORTED, element) || driver.isSuppressed(context, INLINED, element) || VersionChecks.Companion.isWithinVersionCheckConditional$default(VersionChecks.Companion, context, element, api, false, 8, null) || VersionChecks.Companion.isPrecededByVersionCheckExit(context, element, api);
        }

        @JvmStatic
        @JvmOverloads
        public final int getTargetApi(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            for (UElement current = scope; current != null; current = current.getUastParent()) {
                int targetApi;
                if (current instanceof UAnnotated && (targetApi = this.getTargetApiForAnnotated((UAnnotated)current, isApiLevelAnnotation)) != -1) {
                    return targetApi;
                }
                if (current instanceof UFile) break;
            }
            return -1;
        }

        public static /* synthetic */ int getTargetApi$default(Companion companion, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)companion){

                    @NotNull
                    public final Boolean invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.ApiDetector$Companion.access$isTargetAnnotation((Companion)this.receiver, p0);
                    }
                };
            }
            return companion.getTargetApi(uElement, (Function1<? super String, Boolean>)function1);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<UAnnotation, Integer> getTargetApiAnnotation(@Nullable UElement scope, @NotNull Function1<? super String, Boolean> isApiLevelAnnotation) {
            Intrinsics.checkNotNullParameter(isApiLevelAnnotation, (String)"isApiLevelAnnotation");
            for (UElement current = scope; current != null; current = current.getUastParent()) {
                if (current instanceof UAnnotated) {
                    for (UAnnotation annotation : ((UAnnotated)current).getUAnnotations()) {
                        int target2 = this.getTargetApiForAnnotation(annotation, isApiLevelAnnotation);
                        if (target2 == -1) continue;
                        return TuplesKt.to((Object)annotation, (Object)target2);
                    }
                }
                if (current instanceof UFile) break;
            }
            return NO_ANNOTATION_FOUND;
        }

        public static /* synthetic */ Pair getTargetApiAnnotation$default(Companion companion, UElement uElement, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = (Function1)new Function1<String, Boolean>((Object)companion){

                    @NotNull
                    public final Boolean invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.android.tools.lint.checks.ApiDetector$Companion.access$isTargetAnnotation((Companion)this.receiver, p0);
                    }
                };
            }
            return companion.getTargetApiAnnotation(uElement, (Function1<? super String, Boolean>)function1);
        }

        @JvmStatic
        public final int getApiLevel(@NotNull JavaContext context, @NotNull UAnnotation annotation, @NotNull String qualifiedName) {
            int api;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            switch (qualifiedName) {
                case "org.robolectric.annotation.Config": {
                    int n = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, ApiDetector.KEY_MIN_API, -1L);
                    break;
                }
                case "androidx.test.filters.SdkSuppress": 
                case "android.support.test.filters.SdkSuppress": {
                    long fromCodeName = UastLintUtils.Companion.getLongAttribute(context, annotation, "codeName", -1L);
                    int n = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "minSdkVersion", fromCodeName);
                    break;
                }
                default: {
                    int n = api = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "value", -1L);
                }
            }
            if (api <= 1) {
                api = (int)UastLintUtils.Companion.getLongAttribute(context, annotation, "api", -1L);
            } else if (api == 10000) {
                String name;
                String string;
                UExpression value;
                AndroidVersion version;
                IAndroidTarget fromCodeName = context.getProject().getBuildTarget();
                AndroidVersion androidVersion = version = fromCodeName == null ? null : fromCodeName.getVersion();
                if (version != null && version.isPreview()) {
                    return version.getFeatureLevel();
                }
                api = 33;
                UExpression uExpression = annotation.findDeclaredAttributeValue("value");
                UExpression uExpression2 = value = uExpression == null ? annotation.findDeclaredAttributeValue("api") : uExpression;
                if (value instanceof PsiReferenceExpression && ((string = (name = ((PsiReferenceExpression)value).getReferenceName())) == null ? false : string.length() == 1)) {
                    int n = SdkVersionInfo.getApiByBuildCode((String)name, (boolean)true);
                    boolean bl = false;
                    api = Math.max(api, n);
                }
            }
            return api;
        }

        private final int getTargetApiForAnnotated(UAnnotated annotated, Function1<? super String, Boolean> isApiLevelAnnotation) {
            if (annotated == null) {
                return -1;
            }
            for (UAnnotation annotation : annotated.getUAnnotations()) {
                int target2 = this.getTargetApiForAnnotation(annotation, isApiLevelAnnotation);
                if (target2 == -1) continue;
                return target2;
            }
            return -1;
        }

        private final int getTargetApiForAnnotation(UAnnotation annotation, Function1<? super String, Boolean> isApiLevelAnnotation) {
            block33: {
                String fqcn;
                block30: {
                    fqcn = annotation.getQualifiedName();
                    if (fqcn == null || !((Boolean)isApiLevelAnnotation.invoke((Object)fqcn)).booleanValue()) break block30;
                    List attributeList = annotation.getAttributeValues();
                    block8: for (UNamedExpression attribute : attributeList) {
                        Integer apiLevel;
                        UExpression expression;
                        block31: {
                            if (fqcn == null) break block31;
                            int n = -1;
                            switch (fqcn.hashCode()) {
                                case 1080124037: {
                                    if (fqcn.equals(ApiDetector.ANDROIDX_SDK_SUPPRESS_ANNOTATION)) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case 854141857: {
                                    if (fqcn.equals(ApiDetector.ROBO_ELECTRIC_CONFIG_ANNOTATION)) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case -1087347458: {
                                    if (fqcn.equals(ApiDetector.SDK_SUPPRESS_ANNOTATION)) {
                                        n = 1;
                                    }
                                    break;
                                }
                            }
                            switch (n) {
                                case 1: {
                                    String name = attribute.getName();
                                    if (name != null && (StringsKt.startsWith$default((String)name, (String)ApiDetector.KEY_MIN_API, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"codeName"))) break;
                                    continue block8;
                                }
                            }
                        }
                        if ((expression = attribute.getExpression()) instanceof ULiteralExpression) {
                            Object value = ((ULiteralExpression)expression).getValue();
                            if (value instanceof Integer) {
                                return ((Number)value).intValue();
                            }
                            if (!(value instanceof String)) continue;
                            return VersionChecks.Companion.codeNameToApi((String)value);
                        }
                        Object object = ConstantEvaluator.evaluate(null, (UElement)((UElement)expression));
                        Integer n = apiLevel = object instanceof Integer ? (Integer)object : null;
                        if (apiLevel != null) {
                            return apiLevel;
                        }
                        if (expression instanceof UReferenceExpression) {
                            String name = ((UReferenceExpression)expression).getResolvedName();
                            if (name == null) continue;
                            return VersionChecks.Companion.codeNameToApi(name);
                        }
                        return VersionChecks.Companion.codeNameToApi(expression.asSourceString());
                    }
                    break block33;
                }
                if (fqcn == null) {
                    int end;
                    PsiElement psiElement = annotation.getSourcePsi();
                    if (psiElement == null) {
                        return -1;
                    }
                    PsiElement psi = psiElement;
                    if (psi instanceof PsiCompiledElement) {
                        return -1;
                    }
                    String text = psi.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                    int start = StringsKt.indexOf$default((CharSequence)text, (char)'(', (int)0, (boolean)false, (int)6, null);
                    if (start == -1) {
                        return -1;
                    }
                    int colon = StringsKt.indexOf$default((CharSequence)text, (char)':', (int)0, (boolean)false, (int)6, null);
                    String name = text;
                    int n = colon < start ? colon + 1 : 0;
                    boolean bl = false;
                    String string = name.substring(n, start);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String annotationString = string;
                    if (((Boolean)isApiLevelAnnotation.invoke((Object)annotationString)).booleanValue() && (end = StringsKt.indexOf$default((CharSequence)text, (char)')', (int)(start + 1), (boolean)false, (int)4, null)) != -1) {
                        boolean bl2;
                        String string2 = text;
                        int n2 = start + 1;
                        int n3 = 0;
                        String string3 = string2.substring(n2, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String name2 = string3;
                        int index = StringsKt.indexOf$default((CharSequence)name2, (char)'=', (int)0, (boolean)false, (int)6, null);
                        if (index != -1) {
                            String string4 = name2;
                            n3 = index + 1;
                            bl2 = false;
                            String string5 = string4;
                            if (string5 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string6 = string5.substring(n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                            string4 = string6;
                            n3 = 0;
                            String string7 = string4;
                            if (string7 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            name2 = ((Object)StringsKt.trim((CharSequence)string7)).toString();
                        }
                        if ((index = StringsKt.indexOf$default((CharSequence)name2, (char)'.', (int)0, (boolean)false, (int)6, null)) != -1) {
                            String string8 = name2;
                            n3 = index + 1;
                            bl2 = false;
                            String string9 = string8;
                            if (string9 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string10 = string9.substring(n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
                            name2 = string10;
                        }
                        CharSequence charSequence = name2;
                        n3 = 0;
                        if (charSequence.length() > 0) {
                            char c = name2.charAt(0);
                            n3 = 0;
                            if (Character.isDigit(c)) {
                                int api = Integer.parseInt(name2);
                                if (api > 0) {
                                    return api;
                                }
                            } else {
                                return VersionChecks.Companion.codeNameToApi(name2);
                            }
                        }
                    }
                }
            }
            return -1;
        }

        @NotNull
        public final Location getCatchParametersLocation(@NotNull JavaContext context, @NotNull UCatchClause catchClause) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypeReferences();
            if (types.isEmpty()) {
                return Location.NONE;
            }
            Location first = context.getLocation((UElement)types.get(0));
            if (types.size() < 2) {
                return first;
            }
            Location last = context.getLocation((UElement)types.get(types.size() - 1));
            File file = first.getFile();
            Position start = first.getStart();
            Position end = last.getEnd();
            return start == null ? Location.Companion.create(file) : Location.Companion.create(file, start, end);
        }

        public final boolean isMultiCatchReflectiveOperationException(@NotNull UCatchClause catchClause) {
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            List types = catchClause.getTypes();
            if (types.size() < 2) {
                return false;
            }
            for (PsiType t : types) {
                if (this.isSubclassOfReflectiveOperationException(t)) continue;
                return false;
            }
            return true;
        }

        private final boolean isSubclassOfReflectiveOperationException(PsiType type) {
            PsiType[] psiTypeArray = type.getSuperTypes();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"type.superTypes");
            for (PsiType t : psiTypeArray) {
                if (!Intrinsics.areEqual((Object)ApiDetector.REFLECTIVE_OPERATION_EXCEPTION, (Object)t.getCanonicalText())) continue;
                return true;
            }
            return false;
        }

        @JvmStatic
        @JvmOverloads
        public final int getTargetApi(@Nullable UElement scope) {
            return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApi$default(this, scope, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Pair<UAnnotation, Integer> getTargetApiAnnotation(@Nullable UElement scope) {
            return com.android.tools.lint.checks.ApiDetector$Companion.getTargetApiAnnotation$default(this, scope, null, 2, null);
        }

        public static final /* synthetic */ boolean access$dependsOnAppCompat(Companion $this, Project project) {
            return $this.dependsOnAppCompat(project);
        }

        public static final /* synthetic */ boolean access$isAlreadyWarnedDrawableFile(Companion $this, XmlContext context, Attr attribute, int attributeApiLevel) {
            return $this.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel);
        }

        public static final /* synthetic */ boolean access$isFrameLayout(Companion $this, XmlContext context, String tagName, boolean defaultValue) {
            return $this.isFrameLayout(context, tagName, defaultValue);
        }

        public static final /* synthetic */ boolean access$isTargetAnnotation(Companion $this, String fqcn) {
            return $this.isTargetAnnotation(fqcn);
        }

        public static final /* synthetic */ boolean access$isRequiresApiAnnotation(Companion $this, String fqcn) {
            return $this.isRequiresApiAnnotation(fqcn);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 2;
            nArray[AnnotationUsageType.FIELD_REFERENCE.ordinal()] = 3;
            nArray[AnnotationUsageType.CLASS_REFERENCE.ordinal()] = 4;
            nArray[AnnotationUsageType.ANNOTATION_REFERENCE.ordinal()] = 5;
            nArray[AnnotationUsageType.EXTENDS.ordinal()] = 6;
            nArray[AnnotationUsageType.DEFINITION.ordinal()] = 7;
            nArray[AnnotationUsageType.METHOD_RETURN.ordinal()] = 8;
            nArray[AnnotationUsageType.METHOD_OVERRIDE.ordinal()] = 9;
            nArray[AnnotationUsageType.VARIABLE_REFERENCE.ordinal()] = 10;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

