/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Attr;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016Jb\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001d2\u0006\u0010$\u001a\u00020\u0012H\u0002J \u0010%\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\"\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001e\u001a\u00020+2\u0006\u0010,\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\b\u0010/\u001a\u0004\u0018\u00010\bH\u0002J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\b03H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u001dH\u0016J&\u00105\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u0002062\u0006\u00107\u001a\u00020\u0006H\u0002J \u00108\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u0001032\u0006\u0010\u0016\u001a\u0002062\u0006\u00109\u001a\u00020#H\u0014J \u0010:\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010;\u001a\u0002012\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0018\u0010<\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J \u0010@\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020'2\u0006\u0010A\u001a\u00020BH\u0016R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/android/tools/lint/checks/ViewTypeDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "fileIdMap", "", "Lcom/android/ide/common/util/PathString;", "Lcom/google/common/collect/Multimap;", "", "idToViewTag", "Ljava/util/HashMap;", "", "addTags", "", "parser", "Lorg/xmlpull/v1/XmlPullParser;", "map", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkCompatible", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "castType", "Lcom/intellij/psi/PsiClassType;", "castTypeClass", "tag", "tags", "", "node", "Lorg/jetbrains/uast/UElement;", "resourceReference", "Lorg/jetbrains/uast/UExpression;", "items", "Lcom/android/ide/common/resources/ResourceItem;", "findView", "checkMissingCast", "findViewByIdCall", "Lorg/jetbrains/uast/UCallExpression;", "surroundingCall", "createCastFix", "Lcom/android/tools/lint/detector/api/LintFix;", "Lorg/jetbrains/uast/UBinaryExpressionWithType;", "displayTag", "createSecondary", "Lcom/android/tools/lint/detector/api/Location;", "sampleLayout", "findViewForTag", "Lcom/intellij/psi/PsiClass;", "getApplicableAttributes", "", "getApplicableMethodNames", "getIdToTagsIn", "Lcom/android/tools/lint/detector/api/Context;", "file", "getViewTags", "item", "isCompatible", "castClass", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "lint-checks"})
public class ViewTypeDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Object> idToViewTag = new HashMap(50);
    @Nullable
    private Map<PathString, Multimap<String, String>> fileIdMap;
    @NotNull
    private static final String[] viewPackages;
    @JvmField
    @NotNull
    public static final Issue WRONG_VIEW_CAST;
    @JvmField
    @NotNull
    public static final Issue ADD_CAST;
    @NotNull
    public static final String FIND_VIEW_BY_ID = "findViewById";
    @NotNull
    public static final String REQUIRE_VIEW_BY_ID = "requireViewById";
    @NotNull
    public static final String FIND_FRAGMENT_BY_TAG = "findFragmentByTag";
    @NotNull
    private static final String TAG_NAME_PREFIX = ":tag:";

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT;
    }

    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{"id", "tag"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        List list;
        String string;
        boolean bl;
        int n;
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String value = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        if (StringsKt.startsWith$default((String)value, (String)"@id/", (boolean)false, (int)2, null)) {
            string2 = value;
            n = "@id/".length();
            bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)value, (String)"@+id/", (boolean)false, (int)2, null)) {
            string2 = value;
            n = "@+id/".length();
            bl = false;
            String string4 = string2.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else if (Intrinsics.areEqual((Object)"tag", (Object)attribute.getLocalName())) {
            string = Intrinsics.stringPlus((String)TAG_NAME_PREFIX, (Object)value);
        } else {
            return;
        }
        String id = string;
        ViewTypeDetector viewTypeDetector = this;
        bl = false;
        boolean bl2 = false;
        ViewTypeDetector $this$visitAttribute_u24lambda_u2d0 = viewTypeDetector;
        boolean bl3 = false;
        String cls = attribute.getOwnerElement().getTagName();
        if (Intrinsics.areEqual((Object)cls, (Object)"view")) {
            cls = attribute.getOwnerElement().getAttribute("class");
        } else if (Intrinsics.areEqual((Object)cls, (Object)"fragment")) {
            if (!Intrinsics.areEqual((Object)"tag", (Object)attribute.getLocalName())) {
                return;
            }
            cls = attribute.getOwnerElement().getAttribute("class");
        } else if (attribute.getOwnerElement().hasAttributeNS("http://schemas.android.com/apk/res/android", "name")) {
            cls = attribute.getOwnerElement().getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        }
        CharSequence charSequence = cls;
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"cls");
        cls = StringsKt.replace$default((String)charSequence, (char)'$', (char)'.', (boolean)false, (int)4, null);
        charSequence = cls;
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"cls");
        charSequence = charSequence;
        boolean bl4 = false;
        if (charSequence.length() == 0) {
            return;
        }
        charSequence = cls;
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"cls");
        CharSequence view = charSequence;
        Object existing = this.idToViewTag.get(id);
        if (existing == null) {
            Map map = this.idToViewTag;
            bl2 = false;
            map.put(id, view);
        } else if (existing instanceof String) {
            String existingString = (String)existing;
            if (!Intrinsics.areEqual((Object)existingString, (Object)view)) {
                ArrayList<Object> list2 = new ArrayList<Object>(2);
                list2.add(existing);
                list2.add(view);
                Map map = this.idToViewTag;
                boolean bl5 = false;
                map.put(id, list2);
            }
        } else if (TypeIntrinsics.isMutableList((Object)existing) && !(list = TypeIntrinsics.asMutableList((Object)existing)).contains(view)) {
            list.add(view);
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{FIND_VIEW_BY_ID, REQUIRE_VIEW_BY_ID, FIND_FRAGMENT_BY_TAG};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Object variable;
        PsiClassType type;
        PsiClassType psiClassType;
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        LintClient client = context.getClient();
        UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)((UElement)node));
        if (uElement == null) {
            return;
        }
        UElement current = uElement;
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)current.getUastParent());
        UElement errorNode = null;
        PsiClassType castType = null;
        UElement uElement2 = parent;
        if (uElement2 instanceof UBinaryExpressionWithType) {
            UElement cast = parent;
            psiType = ((UBinaryExpressionWithType)cast).getType();
            PsiClassType psiClassType2 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            psiClassType = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)cast));
            errorNode = psiClassType == null ? cast : (UElement)psiClassType;
        } else if (uElement2 instanceof UExpression) {
            if (parent instanceof UCallExpression) {
                UElement c = parent;
                this.checkMissingCast(context, node, (UCallExpression)c);
                return;
            }
            if (parent instanceof UQualifiedReferenceExpression) {
                UElement ref = parent;
                if (UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)ref).getSelector()) != current) {
                    return;
                }
                if (!((parent = UastUtils.skipParenthesizedExprUp((UElement)((UExpression)parent).getUastParent())) instanceof UBinaryExpressionWithType)) {
                    return;
                }
            }
            UExpression uExpression = type = (psiClassType = parent) instanceof UExpression ? (UExpression)psiClassType : null;
            if (type == null) {
                return;
            }
            variable = type;
            psiType = variable.getExpressionType();
            PsiClassType psiClassType3 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = parent;
        } else if (uElement2 instanceof UVariable) {
            variable = parent;
            psiType = ((UVariable)variable).getType();
            PsiClassType psiClassType4 = psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null) {
                return;
            }
            castType = type = psiClassType;
            errorNode = parent;
        } else {
            return;
        }
        variable = castType.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"castType.canonicalText");
        switch (variable) {
            case "android.app.Fragment": 
            case "kotlin.Unit": 
            case "android.support.v4.app.Fragment": 
            case "androidx.fragment.app.Fragment": 
            case "android.view.View": {
                return;
            }
        }
        String methodName = node.getMethodName();
        boolean findView = Intrinsics.areEqual((Object)FIND_VIEW_BY_ID, (Object)methodName) || Intrinsics.areEqual((Object)REQUIRE_VIEW_BY_ID, (Object)methodName);
        boolean findTag = !findView && Intrinsics.areEqual((Object)FIND_FRAGMENT_BY_TAG, (Object)methodName);
        List args = node.getValueArguments();
        if (args.size() == 1) {
            UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)args.get(0)));
            if (uExpression == null) {
                return;
            }
            UExpression first = uExpression;
            String tag = null;
            String id = null;
            if (findTag) {
                String string = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)first), (boolean)false);
                if (string == null) {
                    return;
                }
                tag = string;
                tag = Intrinsics.stringPlus((String)TAG_NAME_PREFIX, (Object)tag);
            } else {
                ResourceUrl resourceUrl = ResourceEvaluator.getResource((JavaEvaluator)context.getEvaluator(), (UElement)((UElement)first));
                if (resourceUrl != null && resourceUrl.type == ResourceType.ID && !resourceUrl.isFramework()) {
                    id = resourceUrl.name;
                }
            }
            if (id != null || tag != null) {
                Object castTypeClass;
                if (id != null) {
                    boolean full = context.isGlobalAnalysis();
                    Project project = full ? context.getMainProject() : context.getProject();
                    ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
                    List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.ID, id);
                    Intrinsics.checkNotNullExpressionValue((Object)items, (String)"items");
                    Collection collection = items;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        HashSet<String> compatible = new HashSet<String>();
                        for (ResourceItem item : items) {
                            Context context2 = (Context)context;
                            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                            Collection<String> tags = this.getViewTags(context2, item);
                            if (tags == null) continue;
                            compatible.addAll(tags);
                        }
                        Collection collection2 = compatible;
                        boolean bl2 = false;
                        if (!collection2.isEmpty()) {
                            ArrayList layoutTypes = new ArrayList(compatible);
                            this.checkCompatible(context, castType, (String)castTypeClass, null, layoutTypes, errorNode, first, items, findView);
                        }
                    }
                } else {
                    Map project = this.idToViewTag;
                    String string = id;
                    string = tag;
                    boolean bl = false;
                    Object types = project.get(string);
                    if (types instanceof String) {
                        this.checkCompatible(context, castType, (String)castTypeClass, (String)types, null, errorNode, first, null, findView);
                    } else if (types instanceof List) {
                        List layoutTypes = (List)types;
                        this.checkCompatible(context, castType, (String)castTypeClass, null, layoutTypes, errorNode, first, null, findView);
                    }
                }
            }
        }
    }

    private final void checkMissingCast(JavaContext context, UCallExpression findViewByIdCall, UCallExpression surroundingCall) {
        PsiClassType psiClassType;
        PsiClassType psiClassType2;
        LanguageLevel languageLevel = Lint.getLanguageLevel((UElement)((UElement)surroundingCall), (LanguageLevel)LanguageLevel.JDK_1_7);
        if (languageLevel.isLessThan(LanguageLevel.JDK_1_8)) {
            return;
        }
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)surroundingCall.getUastParent());
        if (!(parent instanceof UQualifiedReferenceExpression)) {
            return;
        }
        List valueArguments = surroundingCall.getValueArguments();
        int parameterIndex = -1;
        int i = 0;
        int n = valueArguments.size();
        while (i < n) {
            if (Intrinsics.areEqual((Object)findViewByIdCall, (Object)UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)valueArguments.get(i))))) {
                parameterIndex = i;
            }
            int n2 = i;
            i = n2 + 1;
        }
        if (parameterIndex == -1) {
            return;
        }
        PsiMethod psiMethod = surroundingCall.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod resolvedMethod = psiMethod;
        PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
        if (parameterIndex >= parameters.length) {
            return;
        }
        PsiType psiType = parameters[parameterIndex].getType();
        PsiClassType psiClassType3 = psiClassType2 = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
        if (psiClassType2 == null) {
            return;
        }
        PsiClassType parameterType = psiClassType2;
        if (!(parameterType.resolve() instanceof PsiTypeParameter)) {
            return;
        }
        PsiType erasure = TypeConversionUtil.erasure((PsiType)((PsiType)parameterType));
        if (erasure == null || Intrinsics.areEqual((Object)erasure.getCanonicalText(), (Object)"android.view.View")) {
            return;
        }
        Object object = resolvedMethod.getReturnType();
        PsiClassType psiClassType4 = psiClassType = object instanceof PsiClassType ? (PsiClassType)object : null;
        if (psiClassType == null) {
            return;
        }
        PsiClassType returnType = psiClassType;
        if (!(returnType.resolve() instanceof PsiTypeParameter)) {
            return;
        }
        object = findViewByIdCall.getMethodName();
        if (object == null) {
            return;
        }
        Object callName = object;
        LintFix fix = LintFix.Companion.create().replace().name("Add cast").text((String)callName).shortenNames().reformat(true).with(Intrinsics.stringPlus((String)"(android.view.View)", (Object)callName)).build();
        context.report(ADD_CAST, (UElement)findViewByIdCall, context.getLocation((UElement)findViewByIdCall), "Add explicit cast here; won't compile with Java language level 1.8 without it", fix);
    }

    @Nullable
    protected Collection<String> getViewTags(@NotNull Context context, @NotNull ResourceItem item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PathString pathString = item.getSource();
        if (pathString == null) {
            return null;
        }
        PathString source = pathString;
        Multimap<String, String> multimap = this.getIdToTagsIn(context, source);
        if (multimap == null) {
            return null;
        }
        Multimap<String, String> map = multimap;
        return map.get((Object)item.getName());
    }

    private final Multimap<String, String> getIdToTagsIn(Context context, PathString file) {
        Map map;
        boolean bl;
        Object object;
        if (!StringsKt.endsWith$default((String)file.getFileName(), (String)".xml", (boolean)false, (int)2, null)) {
            return null;
        }
        Map map2 = this.fileIdMap;
        if (map2 == null) {
            object = this;
            bl = false;
            boolean bl2 = false;
            ViewTypeDetector $this$getIdToTagsIn_u24lambda_u2d1 = object;
            boolean bl3 = false;
            HashMap list = new HashMap();
            $this$getIdToTagsIn_u24lambda_u2d1.fileIdMap = list;
            map = list;
        } else {
            map = map2;
        }
        Map fileIdMap = map;
        Multimap map3 = fileIdMap.get(file);
        if (map3 == null) {
            map3 = (Multimap)ArrayListMultimap.create();
            object = fileIdMap;
            bl = false;
            object.put(file, map3);
            try {
                XmlPullParser parser = context.getClient().createXmlPullParser(file);
                if (parser != null) {
                    this.addTags(parser, (Multimap<String, String>)map3);
                }
            }
            catch (XmlPullParserException xmlPullParserException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return map3;
    }

    private final void addTags(XmlPullParser parser, Multimap<String, String> map) {
        block14: while (true) {
            int event = parser.next();
            switch (event) {
                case 2: {
                    String tag;
                    String id = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "id");
                    if (id == null) continue block14;
                    CharSequence charSequence = id;
                    boolean bl = false;
                    if (!(charSequence.length() > 0)) continue block14;
                    id = Lint.stripIdPrefix((String)id);
                    CharSequence charSequence2 = parser.getName();
                    if (charSequence2 == null) continue block14;
                    switch (charSequence2) {
                        case "view": 
                        case "fragment": {
                            charSequence2 = parser.getAttributeValue(null, "class");
                            if (charSequence2 == null) continue block14;
                            tag = charSequence2;
                            charSequence2 = tag;
                            boolean bl2 = false;
                            if (!(charSequence2.length() == 0)) break;
                            continue block14;
                        }
                        case "include": 
                        case "merge": {
                            continue block14;
                        }
                    }
                    if (map.containsEntry((Object)id, (Object)(tag = StringsKt.replace$default((String)tag, (char)'$', (char)'.', (boolean)false, (int)4, null)))) continue block14;
                    map.put((Object)id, (Object)tag);
                    continue block14;
                }
                case 1: {
                    return;
                }
            }
        }
    }

    private final void checkCompatible(JavaContext context, PsiClassType castType, String castTypeClass, String tag, List<String> tags, UElement node, UExpression resourceReference, List<? extends ResourceItem> items, boolean findView) {
        String verb;
        String string;
        String t22;
        boolean bl = tag == null || tags == null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ViewTypeDetector$checkCompatible$232 = false;
            String string2 = tag;
            Intrinsics.checkNotNull((Object)string2);
            List<String> list = tags;
            Intrinsics.checkNotNull(list);
            String $i$a$-assert-ViewTypeDetector$checkCompatible$232 = Intrinsics.stringPlus((String)string2, list);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-ViewTypeDetector$checkCompatible$232));
        }
        if (Intrinsics.areEqual((Object)castTypeClass, (Object)tag) || tags != null && tags.contains(castTypeClass)) {
            return;
        }
        PsiClass castClass = castType.resolve();
        boolean compatible = true;
        if (findView) {
            if (tag != null) {
                if (!Intrinsics.areEqual((Object)tag, (Object)castTypeClass) && !context.getSdkInfo().isSubViewOf(castTypeClass, tag)) {
                    compatible = false;
                }
            } else if (tags != null) {
                compatible = false;
                for (String type : tags) {
                    if (!Intrinsics.areEqual((Object)type, (Object)castTypeClass) && !context.getSdkInfo().isSubViewOf(castTypeClass, type)) continue;
                    compatible = true;
                    break;
                }
            }
        } else {
            boolean bl3 = compatible = castClass == null;
        }
        if (castClass != null && !compatible) {
            if (tag != null) {
                if (this.isCompatible(context, castClass, tag)) {
                    return;
                }
            } else if (tags != null) {
                for (String t22 : tags) {
                    if (!this.isCompatible(context, castClass, t22)) continue;
                    return;
                }
            }
        }
        if (compatible) {
            return;
        }
        t22 = tag;
        if (t22 == null) {
            Joiner joiner = Joiner.on((String)"|");
            List<String> list = tags;
            Intrinsics.checkNotNull(list);
            string = joiner.join((Iterable)list);
        } else {
            string = t22;
        }
        String displayTag = string;
        String sampleLayout = null;
        if (items != null && (tags == null || tags.size() == 1)) {
            for (ResourceItem resourceItem : items) {
                PathString source;
                Collection<String> t3 = this.getViewTags((Context)context, resourceItem);
                if (t3 == null || !t3.contains(displayTag) || (source = resourceItem.getSource()) == null) continue;
                String parentName = source.getParentFileName();
                sampleLayout = resourceItem.getConfiguration().isDefault() || parentName == null ? source.getFileName() : parentName + '/' + source.getFileName();
                break;
            }
        }
        String string3 = castTypeClass;
        int t3 = StringsKt.lastIndexOf$default((CharSequence)castTypeClass, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        boolean source = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(t3);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String incompatibleTag = string5;
        String string6 = findView ? "layout" : "fragment";
        String string7 = verb = findView ? "was" : "referenced";
        if (!(node instanceof UBinaryExpressionWithType)) {
            Location location = null;
            if (node instanceof UVariable && ((UVariable)node).getTypeReference() != null) {
                UTypeReferenceExpression uTypeReferenceExpression = ((UVariable)node).getTypeReference();
                Intrinsics.checkNotNull((Object)uTypeReferenceExpression);
                location = context.getLocation((UElement)uTypeReferenceExpression);
                Intrinsics.checkNotNullExpressionValue((Object)displayTag, (String)"displayTag");
                location.setSecondary(this.createSecondary(context, displayTag, resourceReference, sampleLayout));
            } else {
                location = context.getLocation(node);
            }
            String message2 = "Unexpected implicit cast to `" + incompatibleTag + "`: " + string6 + " tag " + verb + " `" + displayTag + '`';
            JavaContext.report$default((JavaContext)context, (Issue)WRONG_VIEW_CAST, (UElement)node, (Location)location, (String)message2, null, (int)16, null);
        } else {
            Location location = context.getLocation(node);
            if (sampleLayout != null) {
                Intrinsics.checkNotNullExpressionValue((Object)displayTag, (String)"displayTag");
                location.setSecondary(this.createSecondary(context, displayTag, resourceReference, sampleLayout));
            }
            String message2 = "Unexpected cast to `" + incompatibleTag + "`: " + string6 + " tag " + verb + " `" + displayTag + '`';
            UBinaryExpressionWithType uBinaryExpressionWithType = (UBinaryExpressionWithType)node;
            Intrinsics.checkNotNullExpressionValue((Object)displayTag, (String)"displayTag");
            LintFix fix = this.createCastFix(uBinaryExpressionWithType, displayTag, context);
            context.report(WRONG_VIEW_CAST, node, location, message2, fix);
        }
    }

    private final LintFix createCastFix(UBinaryExpressionWithType node, String displayTag, JavaContext context) {
        String string;
        UTypeReferenceExpression uTypeReferenceExpression = node.getTypeReference();
        if (uTypeReferenceExpression == null) {
            return null;
        }
        UTypeReferenceExpression typeReference = uTypeReferenceExpression;
        if (StringsKt.contains$default((CharSequence)displayTag, (char)'.', (boolean)false, (int)2, null)) {
            string = StringsKt.replace$default((String)displayTag, (char)'$', (char)'.', (boolean)false, (int)4, null);
        } else {
            String string2;
            String string3;
            PsiClass psiClass = this.findViewForTag(displayTag, context);
            String string4 = string3 = psiClass == null ? null : psiClass.getQualifiedName();
            if (string3 == null) {
                return null;
            }
            string = string2 = string3;
        }
        String className = string;
        return this.fix().replace().all().with(className).name(Intrinsics.stringPlus((String)"Cast to ", (Object)displayTag)).range(context.getLocation((UElement)typeReference)).reformat(true).shortenNames().build();
    }

    private final Location createSecondary(JavaContext context, String tag, UExpression resourceReference, String sampleLayout) {
        Location secondary = context.getLocation((UElement)resourceReference);
        if (sampleLayout != null) {
            String article = StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) == -1 && StringsKt.indexOf$default((CharSequence)tag, (char)'|', (int)0, (boolean)false, (int)6, null) == -1 && StringUtil.isVowel((char)Character.toLowerCase(tag.charAt(0))) ? "an" : "a";
            secondary.setMessage("Id bound to " + article + " `" + tag + "` in `" + sampleLayout + '`');
        }
        return secondary;
    }

    private final boolean isCompatible(JavaContext context, PsiClass castClass, String tag) {
        boolean bl;
        PsiClass psiClass = this.findViewForTag(tag, context);
        return psiClass == null ? true : (bl = psiClass.isInheritor(castClass, true));
    }

    private final PsiClass findViewForTag(String tag, JavaContext context) {
        return Companion.findViewForTag(tag, context.getEvaluator());
    }

    static {
        Issue.Companion companion = new Issue.Companion[]{"android.widget.", "android.view.", "android.webkit."};
        viewPackages = companion;
        companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(ViewTypeDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.ALL_JAVA_FILES), enumSetArray);
        WRONG_VIEW_CAST = Issue.Companion.create$default((Issue.Companion)companion, (String)"WrongViewCast", (String)"Mismatched view type", (String)"\n                Keeps track of the view types associated with ids and if it finds a usage \\\n                of the id in the Java code it ensures that it is treated as the same type.", (Implementation)implementation, null, (Category)category, (int)9, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(ViewTypeDetector.class, Scope.JAVA_FILE_SCOPE);
        ADD_CAST = Issue.Companion.create$default((Issue.Companion)companion, (String)"FindViewByIdCast", (String)"Add Explicit Cast", (String)"\n                In Android O, the `findViewById` signature switched to using generics, which \\\n                means that most of the time you can leave out explicit casts and just assign \\\n                the result of the `findViewById` call to variables of specific view classes.\n\n                However, due to language changes between Java 7 and 8, this change may cause \\\n                code to not compile without explicit casts. This lint check looks for these \\\n                scenarios and suggests casts to be added now such that the code will \\\n                continue to compile if the language level is updated to 1.8.", (Implementation)implementation, null, (Category)category, (int)9, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/ViewTypeDetector$Companion;", "", "()V", "ADD_CAST", "Lcom/android/tools/lint/detector/api/Issue;", "FIND_FRAGMENT_BY_TAG", "", "FIND_VIEW_BY_ID", "REQUIRE_VIEW_BY_ID", "TAG_NAME_PREFIX", "WRONG_VIEW_CAST", "viewPackages", "", "[Ljava/lang/String;", "findViewForTag", "Lcom/intellij/psi/PsiClass;", "tag", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiClass findViewForTag(@NotNull String tag, @NotNull JavaEvaluator evaluator) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            PsiClass cls = null;
            if (StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                for (String prefix : viewPackages) {
                    cls = evaluator.findClass(Intrinsics.stringPlus((String)prefix, (Object)tag));
                    if (cls == null) continue;
                    break;
                }
            } else {
                cls = evaluator.findClass(tag);
            }
            return cls;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

